/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/qconnect/QConnectClient.h>
#include <aws/qconnect/QConnectEndpointProvider.h>
#include <aws/qconnect/QConnectEndpointRules.h>
#include <aws/qconnect/QConnectErrorMarshaller.h>
#include <aws/qconnect/QConnectErrors.h>
#include <aws/qconnect/QConnectRequest.h>
#include <aws/qconnect/QConnectServiceClientModel.h>
#include <aws/qconnect/QConnect_EXPORTS.h>
#include <aws/qconnect/model/AIAgentAssociationConfigurationType.h>
#include <aws/qconnect/model/AIAgentConfiguration.h>
#include <aws/qconnect/model/AIAgentConfigurationData.h>
#include <aws/qconnect/model/AIAgentData.h>
#include <aws/qconnect/model/AIAgentSummary.h>
#include <aws/qconnect/model/AIAgentType.h>
#include <aws/qconnect/model/AIAgentVersionSummary.h>
#include <aws/qconnect/model/AIGuardrailContentPolicyConfig.h>
#include <aws/qconnect/model/AIGuardrailContextualGroundingPolicyConfig.h>
#include <aws/qconnect/model/AIGuardrailData.h>
#include <aws/qconnect/model/AIGuardrailSensitiveInformationPolicyConfig.h>
#include <aws/qconnect/model/AIGuardrailSummary.h>
#include <aws/qconnect/model/AIGuardrailTopicPolicyConfig.h>
#include <aws/qconnect/model/AIGuardrailVersionSummary.h>
#include <aws/qconnect/model/AIGuardrailWordPolicyConfig.h>
#include <aws/qconnect/model/AIPromptAPIFormat.h>
#include <aws/qconnect/model/AIPromptData.h>
#include <aws/qconnect/model/AIPromptSummary.h>
#include <aws/qconnect/model/AIPromptTemplateConfiguration.h>
#include <aws/qconnect/model/AIPromptTemplateType.h>
#include <aws/qconnect/model/AIPromptType.h>
#include <aws/qconnect/model/AIPromptVersionSummary.h>
#include <aws/qconnect/model/ActivateMessageTemplateRequest.h>
#include <aws/qconnect/model/ActivateMessageTemplateResult.h>
#include <aws/qconnect/model/AgentAttributes.h>
#include <aws/qconnect/model/AmazonConnectGuideAssociationData.h>
#include <aws/qconnect/model/AnswerRecommendationAIAgentConfiguration.h>
#include <aws/qconnect/model/AppIntegrationsConfiguration.h>
#include <aws/qconnect/model/AssistantAssociationData.h>
#include <aws/qconnect/model/AssistantAssociationInputData.h>
#include <aws/qconnect/model/AssistantAssociationOutputData.h>
#include <aws/qconnect/model/AssistantAssociationSummary.h>
#include <aws/qconnect/model/AssistantCapabilityConfiguration.h>
#include <aws/qconnect/model/AssistantCapabilityType.h>
#include <aws/qconnect/model/AssistantData.h>
#include <aws/qconnect/model/AssistantIntegrationConfiguration.h>
#include <aws/qconnect/model/AssistantStatus.h>
#include <aws/qconnect/model/AssistantSummary.h>
#include <aws/qconnect/model/AssistantType.h>
#include <aws/qconnect/model/AssociationConfiguration.h>
#include <aws/qconnect/model/AssociationConfigurationData.h>
#include <aws/qconnect/model/AssociationType.h>
#include <aws/qconnect/model/BedrockFoundationModelConfigurationForParsing.h>
#include <aws/qconnect/model/ChannelSubtype.h>
#include <aws/qconnect/model/ChunkingConfiguration.h>
#include <aws/qconnect/model/ChunkingStrategy.h>
#include <aws/qconnect/model/CitationSpan.h>
#include <aws/qconnect/model/Configuration.h>
#include <aws/qconnect/model/ConnectConfiguration.h>
#include <aws/qconnect/model/ContentAssociationContents.h>
#include <aws/qconnect/model/ContentAssociationData.h>
#include <aws/qconnect/model/ContentAssociationSummary.h>
#include <aws/qconnect/model/ContentAssociationType.h>
#include <aws/qconnect/model/ContentData.h>
#include <aws/qconnect/model/ContentDataDetails.h>
#include <aws/qconnect/model/ContentDisposition.h>
#include <aws/qconnect/model/ContentFeedbackData.h>
#include <aws/qconnect/model/ContentReference.h>
#include <aws/qconnect/model/ContentStatus.h>
#include <aws/qconnect/model/ContentSummary.h>
#include <aws/qconnect/model/ConversationContext.h>
#include <aws/qconnect/model/ConversationState.h>
#include <aws/qconnect/model/ConversationStatus.h>
#include <aws/qconnect/model/ConversationStatusReason.h>
#include <aws/qconnect/model/CreateAIAgentRequest.h>
#include <aws/qconnect/model/CreateAIAgentResult.h>
#include <aws/qconnect/model/CreateAIAgentVersionRequest.h>
#include <aws/qconnect/model/CreateAIAgentVersionResult.h>
#include <aws/qconnect/model/CreateAIGuardrailRequest.h>
#include <aws/qconnect/model/CreateAIGuardrailResult.h>
#include <aws/qconnect/model/CreateAIGuardrailVersionRequest.h>
#include <aws/qconnect/model/CreateAIGuardrailVersionResult.h>
#include <aws/qconnect/model/CreateAIPromptRequest.h>
#include <aws/qconnect/model/CreateAIPromptResult.h>
#include <aws/qconnect/model/CreateAIPromptVersionRequest.h>
#include <aws/qconnect/model/CreateAIPromptVersionResult.h>
#include <aws/qconnect/model/CreateAssistantAssociationRequest.h>
#include <aws/qconnect/model/CreateAssistantAssociationResult.h>
#include <aws/qconnect/model/CreateAssistantRequest.h>
#include <aws/qconnect/model/CreateAssistantResult.h>
#include <aws/qconnect/model/CreateContentAssociationRequest.h>
#include <aws/qconnect/model/CreateContentAssociationResult.h>
#include <aws/qconnect/model/CreateContentRequest.h>
#include <aws/qconnect/model/CreateContentResult.h>
#include <aws/qconnect/model/CreateKnowledgeBaseRequest.h>
#include <aws/qconnect/model/CreateKnowledgeBaseResult.h>
#include <aws/qconnect/model/CreateMessageTemplateAttachmentRequest.h>
#include <aws/qconnect/model/CreateMessageTemplateAttachmentResult.h>
#include <aws/qconnect/model/CreateMessageTemplateRequest.h>
#include <aws/qconnect/model/CreateMessageTemplateResult.h>
#include <aws/qconnect/model/CreateMessageTemplateVersionRequest.h>
#include <aws/qconnect/model/CreateMessageTemplateVersionResult.h>
#include <aws/qconnect/model/CreateQuickResponseRequest.h>
#include <aws/qconnect/model/CreateQuickResponseResult.h>
#include <aws/qconnect/model/CreateSessionRequest.h>
#include <aws/qconnect/model/CreateSessionResult.h>
#include <aws/qconnect/model/CustomerProfileAttributes.h>
#include <aws/qconnect/model/DataDetails.h>
#include <aws/qconnect/model/DataReference.h>
#include <aws/qconnect/model/DataSummary.h>
#include <aws/qconnect/model/DeactivateMessageTemplateRequest.h>
#include <aws/qconnect/model/DeactivateMessageTemplateResult.h>
#include <aws/qconnect/model/DeleteAIAgentRequest.h>
#include <aws/qconnect/model/DeleteAIAgentResult.h>
#include <aws/qconnect/model/DeleteAIAgentVersionRequest.h>
#include <aws/qconnect/model/DeleteAIAgentVersionResult.h>
#include <aws/qconnect/model/DeleteAIGuardrailRequest.h>
#include <aws/qconnect/model/DeleteAIGuardrailResult.h>
#include <aws/qconnect/model/DeleteAIGuardrailVersionRequest.h>
#include <aws/qconnect/model/DeleteAIGuardrailVersionResult.h>
#include <aws/qconnect/model/DeleteAIPromptRequest.h>
#include <aws/qconnect/model/DeleteAIPromptResult.h>
#include <aws/qconnect/model/DeleteAIPromptVersionRequest.h>
#include <aws/qconnect/model/DeleteAIPromptVersionResult.h>
#include <aws/qconnect/model/DeleteAssistantAssociationRequest.h>
#include <aws/qconnect/model/DeleteAssistantAssociationResult.h>
#include <aws/qconnect/model/DeleteAssistantRequest.h>
#include <aws/qconnect/model/DeleteAssistantResult.h>
#include <aws/qconnect/model/DeleteContentAssociationRequest.h>
#include <aws/qconnect/model/DeleteContentAssociationResult.h>
#include <aws/qconnect/model/DeleteContentRequest.h>
#include <aws/qconnect/model/DeleteContentResult.h>
#include <aws/qconnect/model/DeleteImportJobRequest.h>
#include <aws/qconnect/model/DeleteImportJobResult.h>
#include <aws/qconnect/model/DeleteKnowledgeBaseRequest.h>
#include <aws/qconnect/model/DeleteKnowledgeBaseResult.h>
#include <aws/qconnect/model/DeleteMessageTemplateAttachmentRequest.h>
#include <aws/qconnect/model/DeleteMessageTemplateAttachmentResult.h>
#include <aws/qconnect/model/DeleteMessageTemplateRequest.h>
#include <aws/qconnect/model/DeleteMessageTemplateResult.h>
#include <aws/qconnect/model/DeleteQuickResponseRequest.h>
#include <aws/qconnect/model/DeleteQuickResponseResult.h>
#include <aws/qconnect/model/Document.h>
#include <aws/qconnect/model/DocumentText.h>
#include <aws/qconnect/model/EmailHeader.h>
#include <aws/qconnect/model/EmailMessageTemplateContent.h>
#include <aws/qconnect/model/EmailMessageTemplateContentBody.h>
#include <aws/qconnect/model/ExtendedMessageTemplateData.h>
#include <aws/qconnect/model/ExternalSource.h>
#include <aws/qconnect/model/ExternalSourceConfiguration.h>
#include <aws/qconnect/model/Filter.h>
#include <aws/qconnect/model/FilterField.h>
#include <aws/qconnect/model/FilterOperator.h>
#include <aws/qconnect/model/FixedSizeChunkingConfiguration.h>
#include <aws/qconnect/model/GenerativeChunkDataDetails.h>
#include <aws/qconnect/model/GenerativeContentFeedbackData.h>
#include <aws/qconnect/model/GenerativeDataDetails.h>
#include <aws/qconnect/model/GenerativeReference.h>
#include <aws/qconnect/model/GetAIAgentRequest.h>
#include <aws/qconnect/model/GetAIAgentResult.h>
#include <aws/qconnect/model/GetAIGuardrailRequest.h>
#include <aws/qconnect/model/GetAIGuardrailResult.h>
#include <aws/qconnect/model/GetAIPromptRequest.h>
#include <aws/qconnect/model/GetAIPromptResult.h>
#include <aws/qconnect/model/GetAssistantAssociationRequest.h>
#include <aws/qconnect/model/GetAssistantAssociationResult.h>
#include <aws/qconnect/model/GetAssistantRequest.h>
#include <aws/qconnect/model/GetAssistantResult.h>
#include <aws/qconnect/model/GetContentAssociationRequest.h>
#include <aws/qconnect/model/GetContentAssociationResult.h>
#include <aws/qconnect/model/GetContentRequest.h>
#include <aws/qconnect/model/GetContentResult.h>
#include <aws/qconnect/model/GetContentSummaryRequest.h>
#include <aws/qconnect/model/GetContentSummaryResult.h>
#include <aws/qconnect/model/GetImportJobRequest.h>
#include <aws/qconnect/model/GetImportJobResult.h>
#include <aws/qconnect/model/GetKnowledgeBaseRequest.h>
#include <aws/qconnect/model/GetKnowledgeBaseResult.h>
#include <aws/qconnect/model/GetMessageTemplateRequest.h>
#include <aws/qconnect/model/GetMessageTemplateResult.h>
#include <aws/qconnect/model/GetNextMessageRequest.h>
#include <aws/qconnect/model/GetNextMessageResult.h>
#include <aws/qconnect/model/GetQuickResponseRequest.h>
#include <aws/qconnect/model/GetQuickResponseResult.h>
#include <aws/qconnect/model/GetSessionRequest.h>
#include <aws/qconnect/model/GetSessionResult.h>
#include <aws/qconnect/model/GroupingConfiguration.h>
#include <aws/qconnect/model/GuardrailContentFilterConfig.h>
#include <aws/qconnect/model/GuardrailContentFilterType.h>
#include <aws/qconnect/model/GuardrailContextualGroundingFilterConfig.h>
#include <aws/qconnect/model/GuardrailContextualGroundingFilterType.h>
#include <aws/qconnect/model/GuardrailFilterStrength.h>
#include <aws/qconnect/model/GuardrailManagedWordsConfig.h>
#include <aws/qconnect/model/GuardrailManagedWordsType.h>
#include <aws/qconnect/model/GuardrailPiiEntityConfig.h>
#include <aws/qconnect/model/GuardrailPiiEntityType.h>
#include <aws/qconnect/model/GuardrailRegexConfig.h>
#include <aws/qconnect/model/GuardrailSensitiveInformationAction.h>
#include <aws/qconnect/model/GuardrailTopicConfig.h>
#include <aws/qconnect/model/GuardrailTopicType.h>
#include <aws/qconnect/model/GuardrailWordConfig.h>
#include <aws/qconnect/model/HierarchicalChunkingConfiguration.h>
#include <aws/qconnect/model/HierarchicalChunkingLevelConfiguration.h>
#include <aws/qconnect/model/Highlight.h>
#include <aws/qconnect/model/ImportJobData.h>
#include <aws/qconnect/model/ImportJobStatus.h>
#include <aws/qconnect/model/ImportJobSummary.h>
#include <aws/qconnect/model/ImportJobType.h>
#include <aws/qconnect/model/IntentDetectedDataDetails.h>
#include <aws/qconnect/model/IntentInputData.h>
#include <aws/qconnect/model/KnowledgeBaseAssociationConfigurationData.h>
#include <aws/qconnect/model/KnowledgeBaseAssociationData.h>
#include <aws/qconnect/model/KnowledgeBaseData.h>
#include <aws/qconnect/model/KnowledgeBaseSearchType.h>
#include <aws/qconnect/model/KnowledgeBaseStatus.h>
#include <aws/qconnect/model/KnowledgeBaseSummary.h>
#include <aws/qconnect/model/KnowledgeBaseType.h>
#include <aws/qconnect/model/ListAIAgentVersionsRequest.h>
#include <aws/qconnect/model/ListAIAgentVersionsResult.h>
#include <aws/qconnect/model/ListAIAgentsRequest.h>
#include <aws/qconnect/model/ListAIAgentsResult.h>
#include <aws/qconnect/model/ListAIGuardrailVersionsRequest.h>
#include <aws/qconnect/model/ListAIGuardrailVersionsResult.h>
#include <aws/qconnect/model/ListAIGuardrailsRequest.h>
#include <aws/qconnect/model/ListAIGuardrailsResult.h>
#include <aws/qconnect/model/ListAIPromptVersionsRequest.h>
#include <aws/qconnect/model/ListAIPromptVersionsResult.h>
#include <aws/qconnect/model/ListAIPromptsRequest.h>
#include <aws/qconnect/model/ListAIPromptsResult.h>
#include <aws/qconnect/model/ListAssistantAssociationsRequest.h>
#include <aws/qconnect/model/ListAssistantAssociationsResult.h>
#include <aws/qconnect/model/ListAssistantsRequest.h>
#include <aws/qconnect/model/ListAssistantsResult.h>
#include <aws/qconnect/model/ListContentAssociationsRequest.h>
#include <aws/qconnect/model/ListContentAssociationsResult.h>
#include <aws/qconnect/model/ListContentsRequest.h>
#include <aws/qconnect/model/ListContentsResult.h>
#include <aws/qconnect/model/ListImportJobsRequest.h>
#include <aws/qconnect/model/ListImportJobsResult.h>
#include <aws/qconnect/model/ListKnowledgeBasesRequest.h>
#include <aws/qconnect/model/ListKnowledgeBasesResult.h>
#include <aws/qconnect/model/ListMessageTemplateVersionsRequest.h>
#include <aws/qconnect/model/ListMessageTemplateVersionsResult.h>
#include <aws/qconnect/model/ListMessageTemplatesRequest.h>
#include <aws/qconnect/model/ListMessageTemplatesResult.h>
#include <aws/qconnect/model/ListMessagesRequest.h>
#include <aws/qconnect/model/ListMessagesResult.h>
#include <aws/qconnect/model/ListQuickResponsesRequest.h>
#include <aws/qconnect/model/ListQuickResponsesResult.h>
#include <aws/qconnect/model/ListTagsForResourceRequest.h>
#include <aws/qconnect/model/ListTagsForResourceResult.h>
#include <aws/qconnect/model/ManagedSourceConfiguration.h>
#include <aws/qconnect/model/ManualSearchAIAgentConfiguration.h>
#include <aws/qconnect/model/MessageConfiguration.h>
#include <aws/qconnect/model/MessageData.h>
#include <aws/qconnect/model/MessageInput.h>
#include <aws/qconnect/model/MessageOutput.h>
#include <aws/qconnect/model/MessageTemplateAttachment.h>
#include <aws/qconnect/model/MessageTemplateAttributeType.h>
#include <aws/qconnect/model/MessageTemplateAttributes.h>
#include <aws/qconnect/model/MessageTemplateBodyContentProvider.h>
#include <aws/qconnect/model/MessageTemplateContentProvider.h>
#include <aws/qconnect/model/MessageTemplateData.h>
#include <aws/qconnect/model/MessageTemplateFilterField.h>
#include <aws/qconnect/model/MessageTemplateFilterOperator.h>
#include <aws/qconnect/model/MessageTemplateOrderField.h>
#include <aws/qconnect/model/MessageTemplateQueryField.h>
#include <aws/qconnect/model/MessageTemplateQueryOperator.h>
#include <aws/qconnect/model/MessageTemplateSearchExpression.h>
#include <aws/qconnect/model/MessageTemplateSearchResultData.h>
#include <aws/qconnect/model/MessageTemplateSummary.h>
#include <aws/qconnect/model/MessageTemplateVersionSummary.h>
#include <aws/qconnect/model/MessageType.h>
#include <aws/qconnect/model/NotifyRecommendationsReceivedError.h>
#include <aws/qconnect/model/NotifyRecommendationsReceivedRequest.h>
#include <aws/qconnect/model/NotifyRecommendationsReceivedResult.h>
#include <aws/qconnect/model/OrCondition.h>
#include <aws/qconnect/model/Order.h>
#include <aws/qconnect/model/Origin.h>
#include <aws/qconnect/model/ParsingConfiguration.h>
#include <aws/qconnect/model/ParsingPrompt.h>
#include <aws/qconnect/model/ParsingStrategy.h>
#include <aws/qconnect/model/Participant.h>
#include <aws/qconnect/model/Priority.h>
#include <aws/qconnect/model/PutFeedbackRequest.h>
#include <aws/qconnect/model/PutFeedbackResult.h>
#include <aws/qconnect/model/QueryCondition.h>
#include <aws/qconnect/model/QueryConditionComparisonOperator.h>
#include <aws/qconnect/model/QueryConditionFieldName.h>
#include <aws/qconnect/model/QueryConditionItem.h>
#include <aws/qconnect/model/QueryInputData.h>
#include <aws/qconnect/model/QueryRecommendationTriggerData.h>
#include <aws/qconnect/model/QueryResultType.h>
#include <aws/qconnect/model/QueryTextInputData.h>
#include <aws/qconnect/model/QuickResponseContentProvider.h>
#include <aws/qconnect/model/QuickResponseContents.h>
#include <aws/qconnect/model/QuickResponseData.h>
#include <aws/qconnect/model/QuickResponseDataProvider.h>
#include <aws/qconnect/model/QuickResponseFilterField.h>
#include <aws/qconnect/model/QuickResponseFilterOperator.h>
#include <aws/qconnect/model/QuickResponseOrderField.h>
#include <aws/qconnect/model/QuickResponseQueryField.h>
#include <aws/qconnect/model/QuickResponseQueryOperator.h>
#include <aws/qconnect/model/QuickResponseSearchExpression.h>
#include <aws/qconnect/model/QuickResponseSearchResultData.h>
#include <aws/qconnect/model/QuickResponseStatus.h>
#include <aws/qconnect/model/QuickResponseSummary.h>
#include <aws/qconnect/model/RankingData.h>
#include <aws/qconnect/model/RecommendationData.h>
#include <aws/qconnect/model/RecommendationSourceType.h>
#include <aws/qconnect/model/RecommendationTrigger.h>
#include <aws/qconnect/model/RecommendationTriggerData.h>
#include <aws/qconnect/model/RecommendationTriggerType.h>
#include <aws/qconnect/model/RecommendationType.h>
#include <aws/qconnect/model/ReferenceType.h>
#include <aws/qconnect/model/Relevance.h>
#include <aws/qconnect/model/RelevanceLevel.h>
#include <aws/qconnect/model/RemoveAssistantAIAgentRequest.h>
#include <aws/qconnect/model/RemoveAssistantAIAgentResult.h>
#include <aws/qconnect/model/RemoveKnowledgeBaseTemplateUriRequest.h>
#include <aws/qconnect/model/RemoveKnowledgeBaseTemplateUriResult.h>
#include <aws/qconnect/model/RenderMessageTemplateRequest.h>
#include <aws/qconnect/model/RenderMessageTemplateResult.h>
#include <aws/qconnect/model/RenderingConfiguration.h>
#include <aws/qconnect/model/ResourceNotFoundException.h>
#include <aws/qconnect/model/ResultData.h>
#include <aws/qconnect/model/RuntimeSessionData.h>
#include <aws/qconnect/model/RuntimeSessionDataValue.h>
#include <aws/qconnect/model/SMSMessageTemplateContent.h>
#include <aws/qconnect/model/SMSMessageTemplateContentBody.h>
#include <aws/qconnect/model/SearchContentRequest.h>
#include <aws/qconnect/model/SearchContentResult.h>
#include <aws/qconnect/model/SearchExpression.h>
#include <aws/qconnect/model/SearchMessageTemplatesRequest.h>
#include <aws/qconnect/model/SearchMessageTemplatesResult.h>
#include <aws/qconnect/model/SearchQuickResponsesRequest.h>
#include <aws/qconnect/model/SearchQuickResponsesResult.h>
#include <aws/qconnect/model/SearchSessionsRequest.h>
#include <aws/qconnect/model/SearchSessionsResult.h>
#include <aws/qconnect/model/SeedUrl.h>
#include <aws/qconnect/model/SelfServiceAIAgentConfiguration.h>
#include <aws/qconnect/model/SelfServiceConversationHistory.h>
#include <aws/qconnect/model/SemanticChunkingConfiguration.h>
#include <aws/qconnect/model/SendMessageRequest.h>
#include <aws/qconnect/model/SendMessageResult.h>
#include <aws/qconnect/model/ServerSideEncryptionConfiguration.h>
#include <aws/qconnect/model/SessionData.h>
#include <aws/qconnect/model/SessionDataNamespace.h>
#include <aws/qconnect/model/SessionIntegrationConfiguration.h>
#include <aws/qconnect/model/SessionSummary.h>
#include <aws/qconnect/model/SourceConfiguration.h>
#include <aws/qconnect/model/SourceContentDataDetails.h>
#include <aws/qconnect/model/SourceContentType.h>
#include <aws/qconnect/model/StartContentUploadRequest.h>
#include <aws/qconnect/model/StartContentUploadResult.h>
#include <aws/qconnect/model/StartImportJobRequest.h>
#include <aws/qconnect/model/StartImportJobResult.h>
#include <aws/qconnect/model/Status.h>
#include <aws/qconnect/model/SyncStatus.h>
#include <aws/qconnect/model/SystemAttributes.h>
#include <aws/qconnect/model/SystemEndpointAttributes.h>
#include <aws/qconnect/model/TagCondition.h>
#include <aws/qconnect/model/TagFilter.h>
#include <aws/qconnect/model/TagResourceRequest.h>
#include <aws/qconnect/model/TagResourceResult.h>
#include <aws/qconnect/model/TargetType.h>
#include <aws/qconnect/model/TextData.h>
#include <aws/qconnect/model/TextFullAIPromptEditTemplateConfiguration.h>
#include <aws/qconnect/model/TextMessage.h>
#include <aws/qconnect/model/TooManyTagsException.h>
#include <aws/qconnect/model/UntagResourceRequest.h>
#include <aws/qconnect/model/UntagResourceResult.h>
#include <aws/qconnect/model/UpdateAIAgentRequest.h>
#include <aws/qconnect/model/UpdateAIAgentResult.h>
#include <aws/qconnect/model/UpdateAIGuardrailRequest.h>
#include <aws/qconnect/model/UpdateAIGuardrailResult.h>
#include <aws/qconnect/model/UpdateAIPromptRequest.h>
#include <aws/qconnect/model/UpdateAIPromptResult.h>
#include <aws/qconnect/model/UpdateAssistantAIAgentRequest.h>
#include <aws/qconnect/model/UpdateAssistantAIAgentResult.h>
#include <aws/qconnect/model/UpdateContentRequest.h>
#include <aws/qconnect/model/UpdateContentResult.h>
#include <aws/qconnect/model/UpdateKnowledgeBaseTemplateUriRequest.h>
#include <aws/qconnect/model/UpdateKnowledgeBaseTemplateUriResult.h>
#include <aws/qconnect/model/UpdateMessageTemplateMetadataRequest.h>
#include <aws/qconnect/model/UpdateMessageTemplateMetadataResult.h>
#include <aws/qconnect/model/UpdateMessageTemplateRequest.h>
#include <aws/qconnect/model/UpdateMessageTemplateResult.h>
#include <aws/qconnect/model/UpdateQuickResponseRequest.h>
#include <aws/qconnect/model/UpdateQuickResponseResult.h>
#include <aws/qconnect/model/UpdateSessionDataRequest.h>
#include <aws/qconnect/model/UpdateSessionDataResult.h>
#include <aws/qconnect/model/UpdateSessionRequest.h>
#include <aws/qconnect/model/UpdateSessionResult.h>
#include <aws/qconnect/model/UrlConfiguration.h>
#include <aws/qconnect/model/VectorIngestionConfiguration.h>
#include <aws/qconnect/model/VisibilityStatus.h>
#include <aws/qconnect/model/WebCrawlerConfiguration.h>
#include <aws/qconnect/model/WebCrawlerLimits.h>
#include <aws/qconnect/model/WebScopeType.h>

using QConnectIncludeTest = ::testing::Test;

TEST_F(QConnectIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::QConnect::QConnectClient>("QConnectIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
