/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/quicksight/QuickSightClient.h>
#include <aws/quicksight/QuickSightEndpointProvider.h>
#include <aws/quicksight/QuickSightEndpointRules.h>
#include <aws/quicksight/QuickSightErrorMarshaller.h>
#include <aws/quicksight/QuickSightErrors.h>
#include <aws/quicksight/QuickSightRequest.h>
#include <aws/quicksight/QuickSightServiceClientModel.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/AccessDeniedException.h>
#include <aws/quicksight/model/AccountCustomization.h>
#include <aws/quicksight/model/AccountInfo.h>
#include <aws/quicksight/model/AccountSettings.h>
#include <aws/quicksight/model/ActiveIAMPolicyAssignment.h>
#include <aws/quicksight/model/AdHocFilteringOption.h>
#include <aws/quicksight/model/AggFunction.h>
#include <aws/quicksight/model/AggType.h>
#include <aws/quicksight/model/AggregationFunction.h>
#include <aws/quicksight/model/AggregationPartitionBy.h>
#include <aws/quicksight/model/AggregationSortConfiguration.h>
#include <aws/quicksight/model/AllSheetsFilterScopeConfiguration.h>
#include <aws/quicksight/model/AmazonElasticsearchParameters.h>
#include <aws/quicksight/model/AmazonOpenSearchParameters.h>
#include <aws/quicksight/model/AmazonQInQuickSightConsoleConfigurations.h>
#include <aws/quicksight/model/AmazonQInQuickSightDashboardConfigurations.h>
#include <aws/quicksight/model/Analysis.h>
#include <aws/quicksight/model/AnalysisDefaults.h>
#include <aws/quicksight/model/AnalysisDefinition.h>
#include <aws/quicksight/model/AnalysisError.h>
#include <aws/quicksight/model/AnalysisErrorType.h>
#include <aws/quicksight/model/AnalysisFilterAttribute.h>
#include <aws/quicksight/model/AnalysisSearchFilter.h>
#include <aws/quicksight/model/AnalysisSourceEntity.h>
#include <aws/quicksight/model/AnalysisSourceTemplate.h>
#include <aws/quicksight/model/AnalysisSummary.h>
#include <aws/quicksight/model/Anchor.h>
#include <aws/quicksight/model/AnchorDateConfiguration.h>
#include <aws/quicksight/model/AnchorOption.h>
#include <aws/quicksight/model/AnchorType.h>
#include <aws/quicksight/model/AnonymousUserDashboardEmbeddingConfiguration.h>
#include <aws/quicksight/model/AnonymousUserDashboardEmbeddingConfigurationDisabledFeature.h>
#include <aws/quicksight/model/AnonymousUserDashboardEmbeddingConfigurationEnabledFeature.h>
#include <aws/quicksight/model/AnonymousUserDashboardFeatureConfigurations.h>
#include <aws/quicksight/model/AnonymousUserDashboardVisualEmbeddingConfiguration.h>
#include <aws/quicksight/model/AnonymousUserEmbeddingExperienceConfiguration.h>
#include <aws/quicksight/model/AnonymousUserGenerativeQnAEmbeddingConfiguration.h>
#include <aws/quicksight/model/AnonymousUserQSearchBarEmbeddingConfiguration.h>
#include <aws/quicksight/model/AnonymousUserSnapshotJobResult.h>
#include <aws/quicksight/model/ApplicationTheme.h>
#include <aws/quicksight/model/ArcAxisConfiguration.h>
#include <aws/quicksight/model/ArcAxisDisplayRange.h>
#include <aws/quicksight/model/ArcConfiguration.h>
#include <aws/quicksight/model/ArcOptions.h>
#include <aws/quicksight/model/ArcThickness.h>
#include <aws/quicksight/model/ArcThicknessOptions.h>
#include <aws/quicksight/model/AssetBundleCloudFormationOverridePropertyConfiguration.h>
#include <aws/quicksight/model/AssetBundleExportFormat.h>
#include <aws/quicksight/model/AssetBundleExportJobAnalysisOverrideProperties.h>
#include <aws/quicksight/model/AssetBundleExportJobAnalysisPropertyToOverride.h>
#include <aws/quicksight/model/AssetBundleExportJobDashboardOverrideProperties.h>
#include <aws/quicksight/model/AssetBundleExportJobDashboardPropertyToOverride.h>
#include <aws/quicksight/model/AssetBundleExportJobDataSetOverrideProperties.h>
#include <aws/quicksight/model/AssetBundleExportJobDataSetPropertyToOverride.h>
#include <aws/quicksight/model/AssetBundleExportJobDataSourceOverrideProperties.h>
#include <aws/quicksight/model/AssetBundleExportJobDataSourcePropertyToOverride.h>
#include <aws/quicksight/model/AssetBundleExportJobError.h>
#include <aws/quicksight/model/AssetBundleExportJobFolderOverrideProperties.h>
#include <aws/quicksight/model/AssetBundleExportJobFolderPropertyToOverride.h>
#include <aws/quicksight/model/AssetBundleExportJobRefreshScheduleOverrideProperties.h>
#include <aws/quicksight/model/AssetBundleExportJobRefreshSchedulePropertyToOverride.h>
#include <aws/quicksight/model/AssetBundleExportJobResourceIdOverrideConfiguration.h>
#include <aws/quicksight/model/AssetBundleExportJobStatus.h>
#include <aws/quicksight/model/AssetBundleExportJobSummary.h>
#include <aws/quicksight/model/AssetBundleExportJobThemeOverrideProperties.h>
#include <aws/quicksight/model/AssetBundleExportJobThemePropertyToOverride.h>
#include <aws/quicksight/model/AssetBundleExportJobVPCConnectionOverrideProperties.h>
#include <aws/quicksight/model/AssetBundleExportJobVPCConnectionPropertyToOverride.h>
#include <aws/quicksight/model/AssetBundleExportJobValidationStrategy.h>
#include <aws/quicksight/model/AssetBundleExportJobWarning.h>
#include <aws/quicksight/model/AssetBundleImportFailureAction.h>
#include <aws/quicksight/model/AssetBundleImportJobAnalysisOverrideParameters.h>
#include <aws/quicksight/model/AssetBundleImportJobAnalysisOverridePermissions.h>
#include <aws/quicksight/model/AssetBundleImportJobAnalysisOverrideTags.h>
#include <aws/quicksight/model/AssetBundleImportJobDashboardOverrideParameters.h>
#include <aws/quicksight/model/AssetBundleImportJobDashboardOverridePermissions.h>
#include <aws/quicksight/model/AssetBundleImportJobDashboardOverrideTags.h>
#include <aws/quicksight/model/AssetBundleImportJobDataSetOverrideParameters.h>
#include <aws/quicksight/model/AssetBundleImportJobDataSetOverridePermissions.h>
#include <aws/quicksight/model/AssetBundleImportJobDataSetOverrideTags.h>
#include <aws/quicksight/model/AssetBundleImportJobDataSourceCredentialPair.h>
#include <aws/quicksight/model/AssetBundleImportJobDataSourceCredentials.h>
#include <aws/quicksight/model/AssetBundleImportJobDataSourceOverrideParameters.h>
#include <aws/quicksight/model/AssetBundleImportJobDataSourceOverridePermissions.h>
#include <aws/quicksight/model/AssetBundleImportJobDataSourceOverrideTags.h>
#include <aws/quicksight/model/AssetBundleImportJobError.h>
#include <aws/quicksight/model/AssetBundleImportJobFolderOverrideParameters.h>
#include <aws/quicksight/model/AssetBundleImportJobFolderOverridePermissions.h>
#include <aws/quicksight/model/AssetBundleImportJobFolderOverrideTags.h>
#include <aws/quicksight/model/AssetBundleImportJobOverrideParameters.h>
#include <aws/quicksight/model/AssetBundleImportJobOverridePermissions.h>
#include <aws/quicksight/model/AssetBundleImportJobOverrideTags.h>
#include <aws/quicksight/model/AssetBundleImportJobOverrideValidationStrategy.h>
#include <aws/quicksight/model/AssetBundleImportJobRefreshScheduleOverrideParameters.h>
#include <aws/quicksight/model/AssetBundleImportJobResourceIdOverrideConfiguration.h>
#include <aws/quicksight/model/AssetBundleImportJobStatus.h>
#include <aws/quicksight/model/AssetBundleImportJobSummary.h>
#include <aws/quicksight/model/AssetBundleImportJobThemeOverrideParameters.h>
#include <aws/quicksight/model/AssetBundleImportJobThemeOverridePermissions.h>
#include <aws/quicksight/model/AssetBundleImportJobThemeOverrideTags.h>
#include <aws/quicksight/model/AssetBundleImportJobVPCConnectionOverrideParameters.h>
#include <aws/quicksight/model/AssetBundleImportJobVPCConnectionOverrideTags.h>
#include <aws/quicksight/model/AssetBundleImportJobWarning.h>
#include <aws/quicksight/model/AssetBundleImportSource.h>
#include <aws/quicksight/model/AssetBundleImportSourceDescription.h>
#include <aws/quicksight/model/AssetBundleResourceLinkSharingConfiguration.h>
#include <aws/quicksight/model/AssetBundleResourcePermissions.h>
#include <aws/quicksight/model/AssetOptions.h>
#include <aws/quicksight/model/AssignmentStatus.h>
#include <aws/quicksight/model/AthenaParameters.h>
#include <aws/quicksight/model/AttributeAggregationFunction.h>
#include <aws/quicksight/model/AuroraParameters.h>
#include <aws/quicksight/model/AuroraPostgreSqlParameters.h>
#include <aws/quicksight/model/AuthenticationMethodOption.h>
#include <aws/quicksight/model/AuthenticationType.h>
#include <aws/quicksight/model/AuthorSpecifiedAggregation.h>
#include <aws/quicksight/model/AuthorizedTargetsByService.h>
#include <aws/quicksight/model/AwsIotAnalyticsParameters.h>
#include <aws/quicksight/model/AxisBinding.h>
#include <aws/quicksight/model/AxisDataOptions.h>
#include <aws/quicksight/model/AxisDisplayDataDrivenRange.h>
#include <aws/quicksight/model/AxisDisplayMinMaxRange.h>
#include <aws/quicksight/model/AxisDisplayOptions.h>
#include <aws/quicksight/model/AxisDisplayRange.h>
#include <aws/quicksight/model/AxisLabelOptions.h>
#include <aws/quicksight/model/AxisLabelReferenceOptions.h>
#include <aws/quicksight/model/AxisLinearScale.h>
#include <aws/quicksight/model/AxisLogarithmicScale.h>
#include <aws/quicksight/model/AxisScale.h>
#include <aws/quicksight/model/AxisTickLabelOptions.h>
#include <aws/quicksight/model/BarChartAggregatedFieldWells.h>
#include <aws/quicksight/model/BarChartConfiguration.h>
#include <aws/quicksight/model/BarChartFieldWells.h>
#include <aws/quicksight/model/BarChartOrientation.h>
#include <aws/quicksight/model/BarChartSortConfiguration.h>
#include <aws/quicksight/model/BarChartVisual.h>
#include <aws/quicksight/model/BarsArrangement.h>
#include <aws/quicksight/model/BaseMapStyleType.h>
#include <aws/quicksight/model/BatchCreateTopicReviewedAnswerRequest.h>
#include <aws/quicksight/model/BatchCreateTopicReviewedAnswerResult.h>
#include <aws/quicksight/model/BatchDeleteTopicReviewedAnswerRequest.h>
#include <aws/quicksight/model/BatchDeleteTopicReviewedAnswerResult.h>
#include <aws/quicksight/model/BigQueryParameters.h>
#include <aws/quicksight/model/BinCountOptions.h>
#include <aws/quicksight/model/BinWidthOptions.h>
#include <aws/quicksight/model/BodySectionConfiguration.h>
#include <aws/quicksight/model/BodySectionContent.h>
#include <aws/quicksight/model/BodySectionDynamicCategoryDimensionConfiguration.h>
#include <aws/quicksight/model/BodySectionDynamicNumericDimensionConfiguration.h>
#include <aws/quicksight/model/BodySectionRepeatConfiguration.h>
#include <aws/quicksight/model/BodySectionRepeatDimensionConfiguration.h>
#include <aws/quicksight/model/BodySectionRepeatPageBreakConfiguration.h>
#include <aws/quicksight/model/BookmarksConfigurations.h>
#include <aws/quicksight/model/BorderStyle.h>
#include <aws/quicksight/model/BoxPlotAggregatedFieldWells.h>
#include <aws/quicksight/model/BoxPlotChartConfiguration.h>
#include <aws/quicksight/model/BoxPlotFieldWells.h>
#include <aws/quicksight/model/BoxPlotFillStyle.h>
#include <aws/quicksight/model/BoxPlotOptions.h>
#include <aws/quicksight/model/BoxPlotSortConfiguration.h>
#include <aws/quicksight/model/BoxPlotStyleOptions.h>
#include <aws/quicksight/model/BoxPlotVisual.h>
#include <aws/quicksight/model/BrandColorPalette.h>
#include <aws/quicksight/model/BrandDefinition.h>
#include <aws/quicksight/model/BrandDetail.h>
#include <aws/quicksight/model/BrandElementStyle.h>
#include <aws/quicksight/model/BrandStatus.h>
#include <aws/quicksight/model/BrandSummary.h>
#include <aws/quicksight/model/BrandVersionStatus.h>
#include <aws/quicksight/model/CalculatedColumn.h>
#include <aws/quicksight/model/CalculatedField.h>
#include <aws/quicksight/model/CalculatedMeasureField.h>
#include <aws/quicksight/model/CancelIngestionRequest.h>
#include <aws/quicksight/model/CancelIngestionResult.h>
#include <aws/quicksight/model/Capabilities.h>
#include <aws/quicksight/model/CapabilityState.h>
#include <aws/quicksight/model/CascadingControlConfiguration.h>
#include <aws/quicksight/model/CascadingControlSource.h>
#include <aws/quicksight/model/CastColumnTypeOperation.h>
#include <aws/quicksight/model/CategoricalAggregationFunction.h>
#include <aws/quicksight/model/CategoricalDimensionField.h>
#include <aws/quicksight/model/CategoricalMeasureField.h>
#include <aws/quicksight/model/CategoryDrillDownFilter.h>
#include <aws/quicksight/model/CategoryFilter.h>
#include <aws/quicksight/model/CategoryFilterConfiguration.h>
#include <aws/quicksight/model/CategoryFilterFunction.h>
#include <aws/quicksight/model/CategoryFilterMatchOperator.h>
#include <aws/quicksight/model/CategoryFilterSelectAllOptions.h>
#include <aws/quicksight/model/CategoryFilterType.h>
#include <aws/quicksight/model/CategoryInnerFilter.h>
#include <aws/quicksight/model/CellValueSynonym.h>
#include <aws/quicksight/model/ChartAxisLabelOptions.h>
#include <aws/quicksight/model/ClusterMarker.h>
#include <aws/quicksight/model/ClusterMarkerConfiguration.h>
#include <aws/quicksight/model/CollectiveConstant.h>
#include <aws/quicksight/model/CollectiveConstantEntry.h>
#include <aws/quicksight/model/ColorFillType.h>
#include <aws/quicksight/model/ColorScale.h>
#include <aws/quicksight/model/ColorsConfiguration.h>
#include <aws/quicksight/model/ColumnConfiguration.h>
#include <aws/quicksight/model/ColumnDataRole.h>
#include <aws/quicksight/model/ColumnDataSubType.h>
#include <aws/quicksight/model/ColumnDataType.h>
#include <aws/quicksight/model/ColumnDescription.h>
#include <aws/quicksight/model/ColumnGroup.h>
#include <aws/quicksight/model/ColumnGroupColumnSchema.h>
#include <aws/quicksight/model/ColumnGroupSchema.h>
#include <aws/quicksight/model/ColumnHierarchy.h>
#include <aws/quicksight/model/ColumnIdentifier.h>
#include <aws/quicksight/model/ColumnLevelPermissionRule.h>
#include <aws/quicksight/model/ColumnOrderingType.h>
#include <aws/quicksight/model/ColumnRole.h>
#include <aws/quicksight/model/ColumnSchema.h>
#include <aws/quicksight/model/ColumnSort.h>
#include <aws/quicksight/model/ColumnTag.h>
#include <aws/quicksight/model/ColumnTagName.h>
#include <aws/quicksight/model/ColumnTooltipItem.h>
#include <aws/quicksight/model/ComboChartAggregatedFieldWells.h>
#include <aws/quicksight/model/ComboChartConfiguration.h>
#include <aws/quicksight/model/ComboChartFieldWells.h>
#include <aws/quicksight/model/ComboChartSortConfiguration.h>
#include <aws/quicksight/model/ComboChartVisual.h>
#include <aws/quicksight/model/CommitMode.h>
#include <aws/quicksight/model/ComparativeOrder.h>
#include <aws/quicksight/model/ComparisonConfiguration.h>
#include <aws/quicksight/model/ComparisonFormatConfiguration.h>
#include <aws/quicksight/model/ComparisonMethod.h>
#include <aws/quicksight/model/ComparisonMethodType.h>
#include <aws/quicksight/model/Computation.h>
#include <aws/quicksight/model/ConcurrentUpdatingException.h>
#include <aws/quicksight/model/ConditionalFormattingColor.h>
#include <aws/quicksight/model/ConditionalFormattingCustomIconCondition.h>
#include <aws/quicksight/model/ConditionalFormattingCustomIconOptions.h>
#include <aws/quicksight/model/ConditionalFormattingGradientColor.h>
#include <aws/quicksight/model/ConditionalFormattingIcon.h>
#include <aws/quicksight/model/ConditionalFormattingIconDisplayConfiguration.h>
#include <aws/quicksight/model/ConditionalFormattingIconDisplayOption.h>
#include <aws/quicksight/model/ConditionalFormattingIconSet.h>
#include <aws/quicksight/model/ConditionalFormattingIconSetType.h>
#include <aws/quicksight/model/ConditionalFormattingSolidColor.h>
#include <aws/quicksight/model/ConflictException.h>
#include <aws/quicksight/model/ConstantType.h>
#include <aws/quicksight/model/ContextMenuOption.h>
#include <aws/quicksight/model/ContributionAnalysisDefault.h>
#include <aws/quicksight/model/ContributionAnalysisDirection.h>
#include <aws/quicksight/model/ContributionAnalysisFactor.h>
#include <aws/quicksight/model/ContributionAnalysisSortType.h>
#include <aws/quicksight/model/ContributionAnalysisTimeRanges.h>
#include <aws/quicksight/model/CreateAccountCustomizationRequest.h>
#include <aws/quicksight/model/CreateAccountCustomizationResult.h>
#include <aws/quicksight/model/CreateAccountSubscriptionRequest.h>
#include <aws/quicksight/model/CreateAccountSubscriptionResult.h>
#include <aws/quicksight/model/CreateAnalysisRequest.h>
#include <aws/quicksight/model/CreateAnalysisResult.h>
#include <aws/quicksight/model/CreateBrandRequest.h>
#include <aws/quicksight/model/CreateBrandResult.h>
#include <aws/quicksight/model/CreateColumnsOperation.h>
#include <aws/quicksight/model/CreateCustomPermissionsRequest.h>
#include <aws/quicksight/model/CreateCustomPermissionsResult.h>
#include <aws/quicksight/model/CreateDashboardRequest.h>
#include <aws/quicksight/model/CreateDashboardResult.h>
#include <aws/quicksight/model/CreateDataSetRequest.h>
#include <aws/quicksight/model/CreateDataSetResult.h>
#include <aws/quicksight/model/CreateDataSourceRequest.h>
#include <aws/quicksight/model/CreateDataSourceResult.h>
#include <aws/quicksight/model/CreateFolderMembershipRequest.h>
#include <aws/quicksight/model/CreateFolderMembershipResult.h>
#include <aws/quicksight/model/CreateFolderRequest.h>
#include <aws/quicksight/model/CreateFolderResult.h>
#include <aws/quicksight/model/CreateGroupMembershipRequest.h>
#include <aws/quicksight/model/CreateGroupMembershipResult.h>
#include <aws/quicksight/model/CreateGroupRequest.h>
#include <aws/quicksight/model/CreateGroupResult.h>
#include <aws/quicksight/model/CreateIAMPolicyAssignmentRequest.h>
#include <aws/quicksight/model/CreateIAMPolicyAssignmentResult.h>
#include <aws/quicksight/model/CreateIngestionRequest.h>
#include <aws/quicksight/model/CreateIngestionResult.h>
#include <aws/quicksight/model/CreateNamespaceRequest.h>
#include <aws/quicksight/model/CreateNamespaceResult.h>
#include <aws/quicksight/model/CreateRefreshScheduleRequest.h>
#include <aws/quicksight/model/CreateRefreshScheduleResult.h>
#include <aws/quicksight/model/CreateRoleMembershipRequest.h>
#include <aws/quicksight/model/CreateRoleMembershipResult.h>
#include <aws/quicksight/model/CreateTemplateAliasRequest.h>
#include <aws/quicksight/model/CreateTemplateAliasResult.h>
#include <aws/quicksight/model/CreateTemplateRequest.h>
#include <aws/quicksight/model/CreateTemplateResult.h>
#include <aws/quicksight/model/CreateThemeAliasRequest.h>
#include <aws/quicksight/model/CreateThemeAliasResult.h>
#include <aws/quicksight/model/CreateThemeRequest.h>
#include <aws/quicksight/model/CreateThemeResult.h>
#include <aws/quicksight/model/CreateTopicRefreshScheduleRequest.h>
#include <aws/quicksight/model/CreateTopicRefreshScheduleResult.h>
#include <aws/quicksight/model/CreateTopicRequest.h>
#include <aws/quicksight/model/CreateTopicResult.h>
#include <aws/quicksight/model/CreateTopicReviewedAnswer.h>
#include <aws/quicksight/model/CreateVPCConnectionRequest.h>
#include <aws/quicksight/model/CreateVPCConnectionResult.h>
#include <aws/quicksight/model/CredentialPair.h>
#include <aws/quicksight/model/CrossDatasetTypes.h>
#include <aws/quicksight/model/CurrencyDisplayFormatConfiguration.h>
#include <aws/quicksight/model/CustomActionFilterOperation.h>
#include <aws/quicksight/model/CustomActionNavigationOperation.h>
#include <aws/quicksight/model/CustomActionSetParametersOperation.h>
#include <aws/quicksight/model/CustomActionURLOperation.h>
#include <aws/quicksight/model/CustomColor.h>
#include <aws/quicksight/model/CustomContentConfiguration.h>
#include <aws/quicksight/model/CustomContentImageScalingConfiguration.h>
#include <aws/quicksight/model/CustomContentType.h>
#include <aws/quicksight/model/CustomContentVisual.h>
#include <aws/quicksight/model/CustomFilterConfiguration.h>
#include <aws/quicksight/model/CustomFilterListConfiguration.h>
#include <aws/quicksight/model/CustomNarrativeOptions.h>
#include <aws/quicksight/model/CustomParameterValues.h>
#include <aws/quicksight/model/CustomPermissions.h>
#include <aws/quicksight/model/CustomSql.h>
#include <aws/quicksight/model/CustomValuesConfiguration.h>
#include <aws/quicksight/model/CustomerManagedKeyUnavailableException.h>
#include <aws/quicksight/model/Dashboard.h>
#include <aws/quicksight/model/DashboardBehavior.h>
#include <aws/quicksight/model/DashboardError.h>
#include <aws/quicksight/model/DashboardErrorType.h>
#include <aws/quicksight/model/DashboardFilterAttribute.h>
#include <aws/quicksight/model/DashboardPublishOptions.h>
#include <aws/quicksight/model/DashboardSearchFilter.h>
#include <aws/quicksight/model/DashboardSourceEntity.h>
#include <aws/quicksight/model/DashboardSourceTemplate.h>
#include <aws/quicksight/model/DashboardSummary.h>
#include <aws/quicksight/model/DashboardUIState.h>
#include <aws/quicksight/model/DashboardVersion.h>
#include <aws/quicksight/model/DashboardVersionDefinition.h>
#include <aws/quicksight/model/DashboardVersionSummary.h>
#include <aws/quicksight/model/DashboardVisualId.h>
#include <aws/quicksight/model/DashboardVisualResult.h>
#include <aws/quicksight/model/DashboardsQAStatus.h>
#include <aws/quicksight/model/DataAggregation.h>
#include <aws/quicksight/model/DataBarsOptions.h>
#include <aws/quicksight/model/DataColor.h>
#include <aws/quicksight/model/DataColorPalette.h>
#include <aws/quicksight/model/DataFieldSeriesItem.h>
#include <aws/quicksight/model/DataLabelContent.h>
#include <aws/quicksight/model/DataLabelOptions.h>
#include <aws/quicksight/model/DataLabelOverlap.h>
#include <aws/quicksight/model/DataLabelPosition.h>
#include <aws/quicksight/model/DataLabelType.h>
#include <aws/quicksight/model/DataPathColor.h>
#include <aws/quicksight/model/DataPathLabelType.h>
#include <aws/quicksight/model/DataPathSort.h>
#include <aws/quicksight/model/DataPathType.h>
#include <aws/quicksight/model/DataPathValue.h>
#include <aws/quicksight/model/DataPointDrillUpDownOption.h>
#include <aws/quicksight/model/DataPointMenuLabelOption.h>
#include <aws/quicksight/model/DataPointTooltipOption.h>
#include <aws/quicksight/model/DataQAEnabledOption.h>
#include <aws/quicksight/model/DataQnAConfigurations.h>
#include <aws/quicksight/model/DataSet.h>
#include <aws/quicksight/model/DataSetConfiguration.h>
#include <aws/quicksight/model/DataSetFilterAttribute.h>
#include <aws/quicksight/model/DataSetIdentifierDeclaration.h>
#include <aws/quicksight/model/DataSetImportMode.h>
#include <aws/quicksight/model/DataSetReference.h>
#include <aws/quicksight/model/DataSetRefreshProperties.h>
#include <aws/quicksight/model/DataSetSchema.h>
#include <aws/quicksight/model/DataSetSearchFilter.h>
#include <aws/quicksight/model/DataSetSummary.h>
#include <aws/quicksight/model/DataSetUsageConfiguration.h>
#include <aws/quicksight/model/DataSetUseAs.h>
#include <aws/quicksight/model/DataSource.h>
#include <aws/quicksight/model/DataSourceCredentials.h>
#include <aws/quicksight/model/DataSourceErrorInfo.h>
#include <aws/quicksight/model/DataSourceErrorInfoType.h>
#include <aws/quicksight/model/DataSourceFilterAttribute.h>
#include <aws/quicksight/model/DataSourceParameters.h>
#include <aws/quicksight/model/DataSourceSearchFilter.h>
#include <aws/quicksight/model/DataSourceSummary.h>
#include <aws/quicksight/model/DataSourceType.h>
#include <aws/quicksight/model/DataStoriesConfigurations.h>
#include <aws/quicksight/model/DatabricksParameters.h>
#include <aws/quicksight/model/DatasetMetadata.h>
#include <aws/quicksight/model/DatasetParameter.h>
#include <aws/quicksight/model/DatasetParameterValueType.h>
#include <aws/quicksight/model/DateAggregationFunction.h>
#include <aws/quicksight/model/DateAxisOptions.h>
#include <aws/quicksight/model/DateDimensionField.h>
#include <aws/quicksight/model/DateMeasureField.h>
#include <aws/quicksight/model/DateTimeDatasetParameter.h>
#include <aws/quicksight/model/DateTimeDatasetParameterDefaultValues.h>
#include <aws/quicksight/model/DateTimeDefaultValues.h>
#include <aws/quicksight/model/DateTimeFormatConfiguration.h>
#include <aws/quicksight/model/DateTimeHierarchy.h>
#include <aws/quicksight/model/DateTimeParameter.h>
#include <aws/quicksight/model/DateTimeParameterDeclaration.h>
#include <aws/quicksight/model/DateTimePickerControlDisplayOptions.h>
#include <aws/quicksight/model/DateTimeValueWhenUnsetConfiguration.h>
#include <aws/quicksight/model/DayOfTheWeek.h>
#include <aws/quicksight/model/DayOfWeek.h>
#include <aws/quicksight/model/DecimalDatasetParameter.h>
#include <aws/quicksight/model/DecimalDatasetParameterDefaultValues.h>
#include <aws/quicksight/model/DecimalDefaultValues.h>
#include <aws/quicksight/model/DecimalParameter.h>
#include <aws/quicksight/model/DecimalParameterDeclaration.h>
#include <aws/quicksight/model/DecimalPlacesConfiguration.h>
#include <aws/quicksight/model/DecimalValueWhenUnsetConfiguration.h>
#include <aws/quicksight/model/DefaultAggregation.h>
#include <aws/quicksight/model/DefaultDateTimePickerControlOptions.h>
#include <aws/quicksight/model/DefaultFilterControlConfiguration.h>
#include <aws/quicksight/model/DefaultFilterControlOptions.h>
#include <aws/quicksight/model/DefaultFilterDropDownControlOptions.h>
#include <aws/quicksight/model/DefaultFilterListControlOptions.h>
#include <aws/quicksight/model/DefaultFormatting.h>
#include <aws/quicksight/model/DefaultFreeFormLayoutConfiguration.h>
#include <aws/quicksight/model/DefaultGridLayoutConfiguration.h>
#include <aws/quicksight/model/DefaultInteractiveLayoutConfiguration.h>
#include <aws/quicksight/model/DefaultNewSheetConfiguration.h>
#include <aws/quicksight/model/DefaultPaginatedLayoutConfiguration.h>
#include <aws/quicksight/model/DefaultRelativeDateTimeControlOptions.h>
#include <aws/quicksight/model/DefaultSectionBasedLayoutConfiguration.h>
#include <aws/quicksight/model/DefaultSliderControlOptions.h>
#include <aws/quicksight/model/DefaultTextAreaControlOptions.h>
#include <aws/quicksight/model/DefaultTextFieldControlOptions.h>
#include <aws/quicksight/model/DeleteAccountCustomizationRequest.h>
#include <aws/quicksight/model/DeleteAccountCustomizationResult.h>
#include <aws/quicksight/model/DeleteAccountSubscriptionRequest.h>
#include <aws/quicksight/model/DeleteAccountSubscriptionResult.h>
#include <aws/quicksight/model/DeleteAnalysisRequest.h>
#include <aws/quicksight/model/DeleteAnalysisResult.h>
#include <aws/quicksight/model/DeleteBrandAssignmentRequest.h>
#include <aws/quicksight/model/DeleteBrandAssignmentResult.h>
#include <aws/quicksight/model/DeleteBrandRequest.h>
#include <aws/quicksight/model/DeleteBrandResult.h>
#include <aws/quicksight/model/DeleteCustomPermissionsRequest.h>
#include <aws/quicksight/model/DeleteCustomPermissionsResult.h>
#include <aws/quicksight/model/DeleteDashboardRequest.h>
#include <aws/quicksight/model/DeleteDashboardResult.h>
#include <aws/quicksight/model/DeleteDataSetRefreshPropertiesRequest.h>
#include <aws/quicksight/model/DeleteDataSetRefreshPropertiesResult.h>
#include <aws/quicksight/model/DeleteDataSetRequest.h>
#include <aws/quicksight/model/DeleteDataSetResult.h>
#include <aws/quicksight/model/DeleteDataSourceRequest.h>
#include <aws/quicksight/model/DeleteDataSourceResult.h>
#include <aws/quicksight/model/DeleteDefaultQBusinessApplicationRequest.h>
#include <aws/quicksight/model/DeleteDefaultQBusinessApplicationResult.h>
#include <aws/quicksight/model/DeleteFolderMembershipRequest.h>
#include <aws/quicksight/model/DeleteFolderMembershipResult.h>
#include <aws/quicksight/model/DeleteFolderRequest.h>
#include <aws/quicksight/model/DeleteFolderResult.h>
#include <aws/quicksight/model/DeleteGroupMembershipRequest.h>
#include <aws/quicksight/model/DeleteGroupMembershipResult.h>
#include <aws/quicksight/model/DeleteGroupRequest.h>
#include <aws/quicksight/model/DeleteGroupResult.h>
#include <aws/quicksight/model/DeleteIAMPolicyAssignmentRequest.h>
#include <aws/quicksight/model/DeleteIAMPolicyAssignmentResult.h>
#include <aws/quicksight/model/DeleteIdentityPropagationConfigRequest.h>
#include <aws/quicksight/model/DeleteIdentityPropagationConfigResult.h>
#include <aws/quicksight/model/DeleteNamespaceRequest.h>
#include <aws/quicksight/model/DeleteNamespaceResult.h>
#include <aws/quicksight/model/DeleteRefreshScheduleRequest.h>
#include <aws/quicksight/model/DeleteRefreshScheduleResult.h>
#include <aws/quicksight/model/DeleteRoleCustomPermissionRequest.h>
#include <aws/quicksight/model/DeleteRoleCustomPermissionResult.h>
#include <aws/quicksight/model/DeleteRoleMembershipRequest.h>
#include <aws/quicksight/model/DeleteRoleMembershipResult.h>
#include <aws/quicksight/model/DeleteTemplateAliasRequest.h>
#include <aws/quicksight/model/DeleteTemplateAliasResult.h>
#include <aws/quicksight/model/DeleteTemplateRequest.h>
#include <aws/quicksight/model/DeleteTemplateResult.h>
#include <aws/quicksight/model/DeleteThemeAliasRequest.h>
#include <aws/quicksight/model/DeleteThemeAliasResult.h>
#include <aws/quicksight/model/DeleteThemeRequest.h>
#include <aws/quicksight/model/DeleteThemeResult.h>
#include <aws/quicksight/model/DeleteTopicRefreshScheduleRequest.h>
#include <aws/quicksight/model/DeleteTopicRefreshScheduleResult.h>
#include <aws/quicksight/model/DeleteTopicRequest.h>
#include <aws/quicksight/model/DeleteTopicResult.h>
#include <aws/quicksight/model/DeleteUserByPrincipalIdRequest.h>
#include <aws/quicksight/model/DeleteUserByPrincipalIdResult.h>
#include <aws/quicksight/model/DeleteUserCustomPermissionRequest.h>
#include <aws/quicksight/model/DeleteUserCustomPermissionResult.h>
#include <aws/quicksight/model/DeleteUserRequest.h>
#include <aws/quicksight/model/DeleteUserResult.h>
#include <aws/quicksight/model/DeleteVPCConnectionRequest.h>
#include <aws/quicksight/model/DeleteVPCConnectionResult.h>
#include <aws/quicksight/model/DescribeAccountCustomizationRequest.h>
#include <aws/quicksight/model/DescribeAccountCustomizationResult.h>
#include <aws/quicksight/model/DescribeAccountSettingsRequest.h>
#include <aws/quicksight/model/DescribeAccountSettingsResult.h>
#include <aws/quicksight/model/DescribeAccountSubscriptionRequest.h>
#include <aws/quicksight/model/DescribeAccountSubscriptionResult.h>
#include <aws/quicksight/model/DescribeAnalysisDefinitionRequest.h>
#include <aws/quicksight/model/DescribeAnalysisDefinitionResult.h>
#include <aws/quicksight/model/DescribeAnalysisPermissionsRequest.h>
#include <aws/quicksight/model/DescribeAnalysisPermissionsResult.h>
#include <aws/quicksight/model/DescribeAnalysisRequest.h>
#include <aws/quicksight/model/DescribeAnalysisResult.h>
#include <aws/quicksight/model/DescribeAssetBundleExportJobRequest.h>
#include <aws/quicksight/model/DescribeAssetBundleExportJobResult.h>
#include <aws/quicksight/model/DescribeAssetBundleImportJobRequest.h>
#include <aws/quicksight/model/DescribeAssetBundleImportJobResult.h>
#include <aws/quicksight/model/DescribeBrandAssignmentRequest.h>
#include <aws/quicksight/model/DescribeBrandAssignmentResult.h>
#include <aws/quicksight/model/DescribeBrandPublishedVersionRequest.h>
#include <aws/quicksight/model/DescribeBrandPublishedVersionResult.h>
#include <aws/quicksight/model/DescribeBrandRequest.h>
#include <aws/quicksight/model/DescribeBrandResult.h>
#include <aws/quicksight/model/DescribeCustomPermissionsRequest.h>
#include <aws/quicksight/model/DescribeCustomPermissionsResult.h>
#include <aws/quicksight/model/DescribeDashboardDefinitionRequest.h>
#include <aws/quicksight/model/DescribeDashboardDefinitionResult.h>
#include <aws/quicksight/model/DescribeDashboardPermissionsRequest.h>
#include <aws/quicksight/model/DescribeDashboardPermissionsResult.h>
#include <aws/quicksight/model/DescribeDashboardRequest.h>
#include <aws/quicksight/model/DescribeDashboardResult.h>
#include <aws/quicksight/model/DescribeDashboardSnapshotJobRequest.h>
#include <aws/quicksight/model/DescribeDashboardSnapshotJobResult.h>
#include <aws/quicksight/model/DescribeDashboardSnapshotJobResultRequest.h>
#include <aws/quicksight/model/DescribeDashboardSnapshotJobResultResult.h>
#include <aws/quicksight/model/DescribeDashboardsQAConfigurationRequest.h>
#include <aws/quicksight/model/DescribeDashboardsQAConfigurationResult.h>
#include <aws/quicksight/model/DescribeDataSetPermissionsRequest.h>
#include <aws/quicksight/model/DescribeDataSetPermissionsResult.h>
#include <aws/quicksight/model/DescribeDataSetRefreshPropertiesRequest.h>
#include <aws/quicksight/model/DescribeDataSetRefreshPropertiesResult.h>
#include <aws/quicksight/model/DescribeDataSetRequest.h>
#include <aws/quicksight/model/DescribeDataSetResult.h>
#include <aws/quicksight/model/DescribeDataSourcePermissionsRequest.h>
#include <aws/quicksight/model/DescribeDataSourcePermissionsResult.h>
#include <aws/quicksight/model/DescribeDataSourceRequest.h>
#include <aws/quicksight/model/DescribeDataSourceResult.h>
#include <aws/quicksight/model/DescribeDefaultQBusinessApplicationRequest.h>
#include <aws/quicksight/model/DescribeDefaultQBusinessApplicationResult.h>
#include <aws/quicksight/model/DescribeFolderPermissionsRequest.h>
#include <aws/quicksight/model/DescribeFolderPermissionsResult.h>
#include <aws/quicksight/model/DescribeFolderRequest.h>
#include <aws/quicksight/model/DescribeFolderResolvedPermissionsRequest.h>
#include <aws/quicksight/model/DescribeFolderResolvedPermissionsResult.h>
#include <aws/quicksight/model/DescribeFolderResult.h>
#include <aws/quicksight/model/DescribeGroupMembershipRequest.h>
#include <aws/quicksight/model/DescribeGroupMembershipResult.h>
#include <aws/quicksight/model/DescribeGroupRequest.h>
#include <aws/quicksight/model/DescribeGroupResult.h>
#include <aws/quicksight/model/DescribeIAMPolicyAssignmentRequest.h>
#include <aws/quicksight/model/DescribeIAMPolicyAssignmentResult.h>
#include <aws/quicksight/model/DescribeIngestionRequest.h>
#include <aws/quicksight/model/DescribeIngestionResult.h>
#include <aws/quicksight/model/DescribeIpRestrictionRequest.h>
#include <aws/quicksight/model/DescribeIpRestrictionResult.h>
#include <aws/quicksight/model/DescribeKeyRegistrationRequest.h>
#include <aws/quicksight/model/DescribeKeyRegistrationResult.h>
#include <aws/quicksight/model/DescribeNamespaceRequest.h>
#include <aws/quicksight/model/DescribeNamespaceResult.h>
#include <aws/quicksight/model/DescribeQPersonalizationConfigurationRequest.h>
#include <aws/quicksight/model/DescribeQPersonalizationConfigurationResult.h>
#include <aws/quicksight/model/DescribeQuickSightQSearchConfigurationRequest.h>
#include <aws/quicksight/model/DescribeQuickSightQSearchConfigurationResult.h>
#include <aws/quicksight/model/DescribeRefreshScheduleRequest.h>
#include <aws/quicksight/model/DescribeRefreshScheduleResult.h>
#include <aws/quicksight/model/DescribeRoleCustomPermissionRequest.h>
#include <aws/quicksight/model/DescribeRoleCustomPermissionResult.h>
#include <aws/quicksight/model/DescribeTemplateAliasRequest.h>
#include <aws/quicksight/model/DescribeTemplateAliasResult.h>
#include <aws/quicksight/model/DescribeTemplateDefinitionRequest.h>
#include <aws/quicksight/model/DescribeTemplateDefinitionResult.h>
#include <aws/quicksight/model/DescribeTemplatePermissionsRequest.h>
#include <aws/quicksight/model/DescribeTemplatePermissionsResult.h>
#include <aws/quicksight/model/DescribeTemplateRequest.h>
#include <aws/quicksight/model/DescribeTemplateResult.h>
#include <aws/quicksight/model/DescribeThemeAliasRequest.h>
#include <aws/quicksight/model/DescribeThemeAliasResult.h>
#include <aws/quicksight/model/DescribeThemePermissionsRequest.h>
#include <aws/quicksight/model/DescribeThemePermissionsResult.h>
#include <aws/quicksight/model/DescribeThemeRequest.h>
#include <aws/quicksight/model/DescribeThemeResult.h>
#include <aws/quicksight/model/DescribeTopicPermissionsRequest.h>
#include <aws/quicksight/model/DescribeTopicPermissionsResult.h>
#include <aws/quicksight/model/DescribeTopicRefreshRequest.h>
#include <aws/quicksight/model/DescribeTopicRefreshResult.h>
#include <aws/quicksight/model/DescribeTopicRefreshScheduleRequest.h>
#include <aws/quicksight/model/DescribeTopicRefreshScheduleResult.h>
#include <aws/quicksight/model/DescribeTopicRequest.h>
#include <aws/quicksight/model/DescribeTopicResult.h>
#include <aws/quicksight/model/DescribeUserRequest.h>
#include <aws/quicksight/model/DescribeUserResult.h>
#include <aws/quicksight/model/DescribeVPCConnectionRequest.h>
#include <aws/quicksight/model/DescribeVPCConnectionResult.h>
#include <aws/quicksight/model/DestinationParameterValueConfiguration.h>
#include <aws/quicksight/model/DigitGroupingStyle.h>
#include <aws/quicksight/model/DimensionField.h>
#include <aws/quicksight/model/DisplayFormat.h>
#include <aws/quicksight/model/DisplayFormatOptions.h>
#include <aws/quicksight/model/DomainNotWhitelistedException.h>
#include <aws/quicksight/model/DonutCenterOptions.h>
#include <aws/quicksight/model/DonutOptions.h>
#include <aws/quicksight/model/DrillDownFilter.h>
#include <aws/quicksight/model/DropDownControlDisplayOptions.h>
#include <aws/quicksight/model/DynamicDefaultValue.h>
#include <aws/quicksight/model/Edition.h>
#include <aws/quicksight/model/EmbeddingIdentityType.h>
#include <aws/quicksight/model/EmptyVisual.h>
#include <aws/quicksight/model/Entity.h>
#include <aws/quicksight/model/ErrorInfo.h>
#include <aws/quicksight/model/ExasolParameters.h>
#include <aws/quicksight/model/ExceptionResourceType.h>
#include <aws/quicksight/model/ExcludePeriodConfiguration.h>
#include <aws/quicksight/model/ExecutiveSummaryConfigurations.h>
#include <aws/quicksight/model/ExplicitHierarchy.h>
#include <aws/quicksight/model/ExportHiddenFieldsOption.h>
#include <aws/quicksight/model/ExportToCSVOption.h>
#include <aws/quicksight/model/ExportWithHiddenFieldsOption.h>
#include <aws/quicksight/model/FailedKeyRegistrationEntry.h>
#include <aws/quicksight/model/FieldBasedTooltip.h>
#include <aws/quicksight/model/FieldFolder.h>
#include <aws/quicksight/model/FieldLabelType.h>
#include <aws/quicksight/model/FieldSeriesItem.h>
#include <aws/quicksight/model/FieldSort.h>
#include <aws/quicksight/model/FieldSortOptions.h>
#include <aws/quicksight/model/FieldTooltipItem.h>
#include <aws/quicksight/model/FileFormat.h>
#include <aws/quicksight/model/FilledMapAggregatedFieldWells.h>
#include <aws/quicksight/model/FilledMapConditionalFormatting.h>
#include <aws/quicksight/model/FilledMapConditionalFormattingOption.h>
#include <aws/quicksight/model/FilledMapConfiguration.h>
#include <aws/quicksight/model/FilledMapFieldWells.h>
#include <aws/quicksight/model/FilledMapShapeConditionalFormatting.h>
#include <aws/quicksight/model/FilledMapSortConfiguration.h>
#include <aws/quicksight/model/FilledMapVisual.h>
#include <aws/quicksight/model/Filter.h>
#include <aws/quicksight/model/FilterAggMetrics.h>
#include <aws/quicksight/model/FilterClass.h>
#include <aws/quicksight/model/FilterControl.h>
#include <aws/quicksight/model/FilterCrossSheetControl.h>
#include <aws/quicksight/model/FilterDateTimePickerControl.h>
#include <aws/quicksight/model/FilterDropDownControl.h>
#include <aws/quicksight/model/FilterGroup.h>
#include <aws/quicksight/model/FilterListConfiguration.h>
#include <aws/quicksight/model/FilterListControl.h>
#include <aws/quicksight/model/FilterNullOption.h>
#include <aws/quicksight/model/FilterOperation.h>
#include <aws/quicksight/model/FilterOperationSelectedFieldsConfiguration.h>
#include <aws/quicksight/model/FilterOperationTargetVisualsConfiguration.h>
#include <aws/quicksight/model/FilterOperator.h>
#include <aws/quicksight/model/FilterRelativeDateTimeControl.h>
#include <aws/quicksight/model/FilterScopeConfiguration.h>
#include <aws/quicksight/model/FilterSelectableValues.h>
#include <aws/quicksight/model/FilterSliderControl.h>
#include <aws/quicksight/model/FilterTextAreaControl.h>
#include <aws/quicksight/model/FilterTextFieldControl.h>
#include <aws/quicksight/model/FilterVisualScope.h>
#include <aws/quicksight/model/Folder.h>
#include <aws/quicksight/model/FolderFilterAttribute.h>
#include <aws/quicksight/model/FolderMember.h>
#include <aws/quicksight/model/FolderSearchFilter.h>
#include <aws/quicksight/model/FolderSummary.h>
#include <aws/quicksight/model/FolderType.h>
#include <aws/quicksight/model/Font.h>
#include <aws/quicksight/model/FontConfiguration.h>
#include <aws/quicksight/model/FontDecoration.h>
#include <aws/quicksight/model/FontSize.h>
#include <aws/quicksight/model/FontStyle.h>
#include <aws/quicksight/model/FontWeight.h>
#include <aws/quicksight/model/FontWeightName.h>
#include <aws/quicksight/model/ForecastComputation.h>
#include <aws/quicksight/model/ForecastComputationSeasonality.h>
#include <aws/quicksight/model/ForecastConfiguration.h>
#include <aws/quicksight/model/ForecastScenario.h>
#include <aws/quicksight/model/FormatConfiguration.h>
#include <aws/quicksight/model/FreeFormLayoutCanvasSizeOptions.h>
#include <aws/quicksight/model/FreeFormLayoutConfiguration.h>
#include <aws/quicksight/model/FreeFormLayoutElement.h>
#include <aws/quicksight/model/FreeFormLayoutElementBackgroundStyle.h>
#include <aws/quicksight/model/FreeFormLayoutElementBorderStyle.h>
#include <aws/quicksight/model/FreeFormLayoutScreenCanvasSizeOptions.h>
#include <aws/quicksight/model/FreeFormSectionLayoutConfiguration.h>
#include <aws/quicksight/model/FunnelChartAggregatedFieldWells.h>
#include <aws/quicksight/model/FunnelChartConfiguration.h>
#include <aws/quicksight/model/FunnelChartDataLabelOptions.h>
#include <aws/quicksight/model/FunnelChartFieldWells.h>
#include <aws/quicksight/model/FunnelChartMeasureDataLabelStyle.h>
#include <aws/quicksight/model/FunnelChartSortConfiguration.h>
#include <aws/quicksight/model/FunnelChartVisual.h>
#include <aws/quicksight/model/GaugeChartArcConditionalFormatting.h>
#include <aws/quicksight/model/GaugeChartColorConfiguration.h>
#include <aws/quicksight/model/GaugeChartConditionalFormatting.h>
#include <aws/quicksight/model/GaugeChartConditionalFormattingOption.h>
#include <aws/quicksight/model/GaugeChartConfiguration.h>
#include <aws/quicksight/model/GaugeChartFieldWells.h>
#include <aws/quicksight/model/GaugeChartOptions.h>
#include <aws/quicksight/model/GaugeChartPrimaryValueConditionalFormatting.h>
#include <aws/quicksight/model/GaugeChartVisual.h>
#include <aws/quicksight/model/GenerateEmbedUrlForAnonymousUserRequest.h>
#include <aws/quicksight/model/GenerateEmbedUrlForAnonymousUserResult.h>
#include <aws/quicksight/model/GenerateEmbedUrlForRegisteredUserRequest.h>
#include <aws/quicksight/model/GenerateEmbedUrlForRegisteredUserResult.h>
#include <aws/quicksight/model/GenerateEmbedUrlForRegisteredUserWithIdentityRequest.h>
#include <aws/quicksight/model/GenerateEmbedUrlForRegisteredUserWithIdentityResult.h>
#include <aws/quicksight/model/GeneratedAnswerResult.h>
#include <aws/quicksight/model/GeneratedAnswerStatus.h>
#include <aws/quicksight/model/GenerativeAuthoringConfigurations.h>
#include <aws/quicksight/model/GeoSpatialColumnGroup.h>
#include <aws/quicksight/model/GeoSpatialCountryCode.h>
#include <aws/quicksight/model/GeoSpatialDataRole.h>
#include <aws/quicksight/model/GeospatialCategoricalColor.h>
#include <aws/quicksight/model/GeospatialCategoricalDataColor.h>
#include <aws/quicksight/model/GeospatialCircleRadius.h>
#include <aws/quicksight/model/GeospatialCircleSymbolStyle.h>
#include <aws/quicksight/model/GeospatialColor.h>
#include <aws/quicksight/model/GeospatialColorState.h>
#include <aws/quicksight/model/GeospatialCoordinateBounds.h>
#include <aws/quicksight/model/GeospatialDataSourceItem.h>
#include <aws/quicksight/model/GeospatialGradientColor.h>
#include <aws/quicksight/model/GeospatialGradientStepColor.h>
#include <aws/quicksight/model/GeospatialHeatmapColorScale.h>
#include <aws/quicksight/model/GeospatialHeatmapConfiguration.h>
#include <aws/quicksight/model/GeospatialHeatmapDataColor.h>
#include <aws/quicksight/model/GeospatialLayerColorField.h>
#include <aws/quicksight/model/GeospatialLayerDefinition.h>
#include <aws/quicksight/model/GeospatialLayerItem.h>
#include <aws/quicksight/model/GeospatialLayerJoinDefinition.h>
#include <aws/quicksight/model/GeospatialLayerMapConfiguration.h>
#include <aws/quicksight/model/GeospatialLayerType.h>
#include <aws/quicksight/model/GeospatialLineLayer.h>
#include <aws/quicksight/model/GeospatialLineStyle.h>
#include <aws/quicksight/model/GeospatialLineSymbolStyle.h>
#include <aws/quicksight/model/GeospatialLineWidth.h>
#include <aws/quicksight/model/GeospatialMapAggregatedFieldWells.h>
#include <aws/quicksight/model/GeospatialMapConfiguration.h>
#include <aws/quicksight/model/GeospatialMapFieldWells.h>
#include <aws/quicksight/model/GeospatialMapNavigation.h>
#include <aws/quicksight/model/GeospatialMapState.h>
#include <aws/quicksight/model/GeospatialMapStyle.h>
#include <aws/quicksight/model/GeospatialMapStyleOptions.h>
#include <aws/quicksight/model/GeospatialMapVisual.h>
#include <aws/quicksight/model/GeospatialNullDataSettings.h>
#include <aws/quicksight/model/GeospatialNullSymbolStyle.h>
#include <aws/quicksight/model/GeospatialPointLayer.h>
#include <aws/quicksight/model/GeospatialPointStyle.h>
#include <aws/quicksight/model/GeospatialPointStyleOptions.h>
#include <aws/quicksight/model/GeospatialPolygonLayer.h>
#include <aws/quicksight/model/GeospatialPolygonStyle.h>
#include <aws/quicksight/model/GeospatialPolygonSymbolStyle.h>
#include <aws/quicksight/model/GeospatialSelectedPointStyle.h>
#include <aws/quicksight/model/GeospatialSolidColor.h>
#include <aws/quicksight/model/GeospatialStaticFileSource.h>
#include <aws/quicksight/model/GeospatialWindowOptions.h>
#include <aws/quicksight/model/GetDashboardEmbedUrlRequest.h>
#include <aws/quicksight/model/GetDashboardEmbedUrlResult.h>
#include <aws/quicksight/model/GetSessionEmbedUrlRequest.h>
#include <aws/quicksight/model/GetSessionEmbedUrlResult.h>
#include <aws/quicksight/model/GlobalTableBorderOptions.h>
#include <aws/quicksight/model/GradientColor.h>
#include <aws/quicksight/model/GradientStop.h>
#include <aws/quicksight/model/GridLayoutCanvasSizeOptions.h>
#include <aws/quicksight/model/GridLayoutConfiguration.h>
#include <aws/quicksight/model/GridLayoutElement.h>
#include <aws/quicksight/model/GridLayoutScreenCanvasSizeOptions.h>
#include <aws/quicksight/model/Group.h>
#include <aws/quicksight/model/GroupFilterAttribute.h>
#include <aws/quicksight/model/GroupFilterOperator.h>
#include <aws/quicksight/model/GroupMember.h>
#include <aws/quicksight/model/GroupSearchFilter.h>
#include <aws/quicksight/model/GrowthRateComputation.h>
#include <aws/quicksight/model/GutterStyle.h>
#include <aws/quicksight/model/HeaderFooterSectionConfiguration.h>
#include <aws/quicksight/model/HeatMapAggregatedFieldWells.h>
#include <aws/quicksight/model/HeatMapConfiguration.h>
#include <aws/quicksight/model/HeatMapFieldWells.h>
#include <aws/quicksight/model/HeatMapSortConfiguration.h>
#include <aws/quicksight/model/HeatMapVisual.h>
#include <aws/quicksight/model/HistogramAggregatedFieldWells.h>
#include <aws/quicksight/model/HistogramBinOptions.h>
#include <aws/quicksight/model/HistogramBinType.h>
#include <aws/quicksight/model/HistogramConfiguration.h>
#include <aws/quicksight/model/HistogramFieldWells.h>
#include <aws/quicksight/model/HistogramVisual.h>
#include <aws/quicksight/model/HorizontalTextAlignment.h>
#include <aws/quicksight/model/IAMPolicyAssignment.h>
#include <aws/quicksight/model/IAMPolicyAssignmentSummary.h>
#include <aws/quicksight/model/Icon.h>
#include <aws/quicksight/model/Identifier.h>
#include <aws/quicksight/model/IdentityCenterConfiguration.h>
#include <aws/quicksight/model/IdentityStore.h>
#include <aws/quicksight/model/IdentityType.h>
#include <aws/quicksight/model/IdentityTypeNotSupportedException.h>
#include <aws/quicksight/model/Image.h>
#include <aws/quicksight/model/ImageConfiguration.h>
#include <aws/quicksight/model/ImageCustomAction.h>
#include <aws/quicksight/model/ImageCustomActionOperation.h>
#include <aws/quicksight/model/ImageCustomActionTrigger.h>
#include <aws/quicksight/model/ImageInteractionOptions.h>
#include <aws/quicksight/model/ImageMenuOption.h>
#include <aws/quicksight/model/ImageSet.h>
#include <aws/quicksight/model/ImageSetConfiguration.h>
#include <aws/quicksight/model/ImageSource.h>
#include <aws/quicksight/model/ImageStaticFile.h>
#include <aws/quicksight/model/IncludeFolderMembers.h>
#include <aws/quicksight/model/IncludeGeneratedAnswer.h>
#include <aws/quicksight/model/IncludeQuickSightQIndex.h>
#include <aws/quicksight/model/IncrementalRefresh.h>
#include <aws/quicksight/model/Ingestion.h>
#include <aws/quicksight/model/IngestionErrorType.h>
#include <aws/quicksight/model/IngestionRequestSource.h>
#include <aws/quicksight/model/IngestionRequestType.h>
#include <aws/quicksight/model/IngestionStatus.h>
#include <aws/quicksight/model/IngestionType.h>
#include <aws/quicksight/model/InnerFilter.h>
#include <aws/quicksight/model/InputColumn.h>
#include <aws/quicksight/model/InputColumnDataType.h>
#include <aws/quicksight/model/InsightConfiguration.h>
#include <aws/quicksight/model/InsightVisual.h>
#include <aws/quicksight/model/IntegerDatasetParameter.h>
#include <aws/quicksight/model/IntegerDatasetParameterDefaultValues.h>
#include <aws/quicksight/model/IntegerDefaultValues.h>
#include <aws/quicksight/model/IntegerParameter.h>
#include <aws/quicksight/model/IntegerParameterDeclaration.h>
#include <aws/quicksight/model/IntegerValueWhenUnsetConfiguration.h>
#include <aws/quicksight/model/InternalFailureException.h>
#include <aws/quicksight/model/InvalidNextTokenException.h>
#include <aws/quicksight/model/InvalidParameterValueException.h>
#include <aws/quicksight/model/InvalidRequestException.h>
#include <aws/quicksight/model/InvalidTopicReviewedAnswer.h>
#include <aws/quicksight/model/ItemsLimitConfiguration.h>
#include <aws/quicksight/model/JiraParameters.h>
#include <aws/quicksight/model/JoinInstruction.h>
#include <aws/quicksight/model/JoinKeyProperties.h>
#include <aws/quicksight/model/JoinType.h>
#include <aws/quicksight/model/KPIActualValueConditionalFormatting.h>
#include <aws/quicksight/model/KPIComparisonValueConditionalFormatting.h>
#include <aws/quicksight/model/KPIConditionalFormatting.h>
#include <aws/quicksight/model/KPIConditionalFormattingOption.h>
#include <aws/quicksight/model/KPIConfiguration.h>
#include <aws/quicksight/model/KPIFieldWells.h>
#include <aws/quicksight/model/KPIOptions.h>
#include <aws/quicksight/model/KPIPrimaryValueConditionalFormatting.h>
#include <aws/quicksight/model/KPIProgressBarConditionalFormatting.h>
#include <aws/quicksight/model/KPISortConfiguration.h>
#include <aws/quicksight/model/KPISparklineOptions.h>
#include <aws/quicksight/model/KPISparklineType.h>
#include <aws/quicksight/model/KPIVisual.h>
#include <aws/quicksight/model/KPIVisualLayoutOptions.h>
#include <aws/quicksight/model/KPIVisualStandardLayout.h>
#include <aws/quicksight/model/KPIVisualStandardLayoutType.h>
#include <aws/quicksight/model/LabelOptions.h>
#include <aws/quicksight/model/LayerCustomAction.h>
#include <aws/quicksight/model/LayerCustomActionOperation.h>
#include <aws/quicksight/model/LayerCustomActionTrigger.h>
#include <aws/quicksight/model/LayerMapVisual.h>
#include <aws/quicksight/model/Layout.h>
#include <aws/quicksight/model/LayoutConfiguration.h>
#include <aws/quicksight/model/LayoutElementType.h>
#include <aws/quicksight/model/LegendOptions.h>
#include <aws/quicksight/model/LegendPosition.h>
#include <aws/quicksight/model/LimitExceededException.h>
#include <aws/quicksight/model/LineChartAggregatedFieldWells.h>
#include <aws/quicksight/model/LineChartConfiguration.h>
#include <aws/quicksight/model/LineChartDefaultSeriesSettings.h>
#include <aws/quicksight/model/LineChartFieldWells.h>
#include <aws/quicksight/model/LineChartLineStyle.h>
#include <aws/quicksight/model/LineChartLineStyleSettings.h>
#include <aws/quicksight/model/LineChartMarkerShape.h>
#include <aws/quicksight/model/LineChartMarkerStyleSettings.h>
#include <aws/quicksight/model/LineChartSeriesSettings.h>
#include <aws/quicksight/model/LineChartSortConfiguration.h>
#include <aws/quicksight/model/LineChartType.h>
#include <aws/quicksight/model/LineChartVisual.h>
#include <aws/quicksight/model/LineInterpolation.h>
#include <aws/quicksight/model/LineSeriesAxisDisplayOptions.h>
#include <aws/quicksight/model/LinkSharingConfiguration.h>
#include <aws/quicksight/model/ListAnalysesRequest.h>
#include <aws/quicksight/model/ListAnalysesResult.h>
#include <aws/quicksight/model/ListAssetBundleExportJobsRequest.h>
#include <aws/quicksight/model/ListAssetBundleExportJobsResult.h>
#include <aws/quicksight/model/ListAssetBundleImportJobsRequest.h>
#include <aws/quicksight/model/ListAssetBundleImportJobsResult.h>
#include <aws/quicksight/model/ListBrandsRequest.h>
#include <aws/quicksight/model/ListBrandsResult.h>
#include <aws/quicksight/model/ListControlDisplayOptions.h>
#include <aws/quicksight/model/ListControlSearchOptions.h>
#include <aws/quicksight/model/ListControlSelectAllOptions.h>
#include <aws/quicksight/model/ListCustomPermissionsRequest.h>
#include <aws/quicksight/model/ListCustomPermissionsResult.h>
#include <aws/quicksight/model/ListDashboardVersionsRequest.h>
#include <aws/quicksight/model/ListDashboardVersionsResult.h>
#include <aws/quicksight/model/ListDashboardsRequest.h>
#include <aws/quicksight/model/ListDashboardsResult.h>
#include <aws/quicksight/model/ListDataSetsRequest.h>
#include <aws/quicksight/model/ListDataSetsResult.h>
#include <aws/quicksight/model/ListDataSourcesRequest.h>
#include <aws/quicksight/model/ListDataSourcesResult.h>
#include <aws/quicksight/model/ListFolderMembersRequest.h>
#include <aws/quicksight/model/ListFolderMembersResult.h>
#include <aws/quicksight/model/ListFoldersForResourceRequest.h>
#include <aws/quicksight/model/ListFoldersForResourceResult.h>
#include <aws/quicksight/model/ListFoldersRequest.h>
#include <aws/quicksight/model/ListFoldersResult.h>
#include <aws/quicksight/model/ListGroupMembershipsRequest.h>
#include <aws/quicksight/model/ListGroupMembershipsResult.h>
#include <aws/quicksight/model/ListGroupsRequest.h>
#include <aws/quicksight/model/ListGroupsResult.h>
#include <aws/quicksight/model/ListIAMPolicyAssignmentsForUserRequest.h>
#include <aws/quicksight/model/ListIAMPolicyAssignmentsForUserResult.h>
#include <aws/quicksight/model/ListIAMPolicyAssignmentsRequest.h>
#include <aws/quicksight/model/ListIAMPolicyAssignmentsResult.h>
#include <aws/quicksight/model/ListIdentityPropagationConfigsRequest.h>
#include <aws/quicksight/model/ListIdentityPropagationConfigsResult.h>
#include <aws/quicksight/model/ListIngestionsRequest.h>
#include <aws/quicksight/model/ListIngestionsResult.h>
#include <aws/quicksight/model/ListNamespacesRequest.h>
#include <aws/quicksight/model/ListNamespacesResult.h>
#include <aws/quicksight/model/ListRefreshSchedulesRequest.h>
#include <aws/quicksight/model/ListRefreshSchedulesResult.h>
#include <aws/quicksight/model/ListRoleMembershipsRequest.h>
#include <aws/quicksight/model/ListRoleMembershipsResult.h>
#include <aws/quicksight/model/ListTagsForResourceRequest.h>
#include <aws/quicksight/model/ListTagsForResourceResult.h>
#include <aws/quicksight/model/ListTemplateAliasesRequest.h>
#include <aws/quicksight/model/ListTemplateAliasesResult.h>
#include <aws/quicksight/model/ListTemplateVersionsRequest.h>
#include <aws/quicksight/model/ListTemplateVersionsResult.h>
#include <aws/quicksight/model/ListTemplatesRequest.h>
#include <aws/quicksight/model/ListTemplatesResult.h>
#include <aws/quicksight/model/ListThemeAliasesRequest.h>
#include <aws/quicksight/model/ListThemeAliasesResult.h>
#include <aws/quicksight/model/ListThemeVersionsRequest.h>
#include <aws/quicksight/model/ListThemeVersionsResult.h>
#include <aws/quicksight/model/ListThemesRequest.h>
#include <aws/quicksight/model/ListThemesResult.h>
#include <aws/quicksight/model/ListTopicRefreshSchedulesRequest.h>
#include <aws/quicksight/model/ListTopicRefreshSchedulesResult.h>
#include <aws/quicksight/model/ListTopicReviewedAnswersRequest.h>
#include <aws/quicksight/model/ListTopicReviewedAnswersResult.h>
#include <aws/quicksight/model/ListTopicsRequest.h>
#include <aws/quicksight/model/ListTopicsResult.h>
#include <aws/quicksight/model/ListUserGroupsRequest.h>
#include <aws/quicksight/model/ListUserGroupsResult.h>
#include <aws/quicksight/model/ListUsersRequest.h>
#include <aws/quicksight/model/ListUsersResult.h>
#include <aws/quicksight/model/ListVPCConnectionsRequest.h>
#include <aws/quicksight/model/ListVPCConnectionsResult.h>
#include <aws/quicksight/model/LoadingAnimation.h>
#include <aws/quicksight/model/LocalNavigationConfiguration.h>
#include <aws/quicksight/model/LogicalTable.h>
#include <aws/quicksight/model/LogicalTableSource.h>
#include <aws/quicksight/model/Logo.h>
#include <aws/quicksight/model/LogoConfiguration.h>
#include <aws/quicksight/model/LogoSet.h>
#include <aws/quicksight/model/LogoSetConfiguration.h>
#include <aws/quicksight/model/LongFormatText.h>
#include <aws/quicksight/model/LookbackWindow.h>
#include <aws/quicksight/model/LookbackWindowSizeUnit.h>
#include <aws/quicksight/model/ManifestFileLocation.h>
#include <aws/quicksight/model/MapZoomMode.h>
#include <aws/quicksight/model/MappedDataSetParameter.h>
#include <aws/quicksight/model/MarginStyle.h>
#include <aws/quicksight/model/MariaDbParameters.h>
#include <aws/quicksight/model/MaximumLabelType.h>
#include <aws/quicksight/model/MaximumMinimumComputation.h>
#include <aws/quicksight/model/MaximumMinimumComputationType.h>
#include <aws/quicksight/model/MeasureField.h>
#include <aws/quicksight/model/MemberIdArnPair.h>
#include <aws/quicksight/model/MemberType.h>
#include <aws/quicksight/model/MetricComparisonComputation.h>
#include <aws/quicksight/model/MinimumLabelType.h>
#include <aws/quicksight/model/MissingDataConfiguration.h>
#include <aws/quicksight/model/MissingDataTreatmentOption.h>
#include <aws/quicksight/model/MySqlParameters.h>
#include <aws/quicksight/model/NamedEntityAggType.h>
#include <aws/quicksight/model/NamedEntityDefinition.h>
#include <aws/quicksight/model/NamedEntityDefinitionMetric.h>
#include <aws/quicksight/model/NamedEntityRef.h>
#include <aws/quicksight/model/NamedFilterAggType.h>
#include <aws/quicksight/model/NamedFilterType.h>
#include <aws/quicksight/model/NamespaceError.h>
#include <aws/quicksight/model/NamespaceErrorType.h>
#include <aws/quicksight/model/NamespaceInfoV2.h>
#include <aws/quicksight/model/NamespaceStatus.h>
#include <aws/quicksight/model/NavbarStyle.h>
#include <aws/quicksight/model/NegativeFormat.h>
#include <aws/quicksight/model/NegativeValueConfiguration.h>
#include <aws/quicksight/model/NegativeValueDisplayMode.h>
#include <aws/quicksight/model/NestedFilter.h>
#include <aws/quicksight/model/NetworkInterface.h>
#include <aws/quicksight/model/NetworkInterfaceStatus.h>
#include <aws/quicksight/model/NewDefaultValues.h>
#include <aws/quicksight/model/NullFilterOption.h>
#include <aws/quicksight/model/NullValueFormatConfiguration.h>
#include <aws/quicksight/model/NumberDisplayFormatConfiguration.h>
#include <aws/quicksight/model/NumberFormatConfiguration.h>
#include <aws/quicksight/model/NumberScale.h>
#include <aws/quicksight/model/NumericAxisOptions.h>
#include <aws/quicksight/model/NumericEqualityDrillDownFilter.h>
#include <aws/quicksight/model/NumericEqualityFilter.h>
#include <aws/quicksight/model/NumericEqualityMatchOperator.h>
#include <aws/quicksight/model/NumericFilterSelectAllOptions.h>
#include <aws/quicksight/model/NumericFormatConfiguration.h>
#include <aws/quicksight/model/NumericRangeFilter.h>
#include <aws/quicksight/model/NumericRangeFilterValue.h>
#include <aws/quicksight/model/NumericSeparatorConfiguration.h>
#include <aws/quicksight/model/NumericSeparatorSymbol.h>
#include <aws/quicksight/model/NumericalAggregationFunction.h>
#include <aws/quicksight/model/NumericalDimensionField.h>
#include <aws/quicksight/model/NumericalMeasureField.h>
#include <aws/quicksight/model/OAuthParameters.h>
#include <aws/quicksight/model/OracleParameters.h>
#include <aws/quicksight/model/OtherCategories.h>
#include <aws/quicksight/model/OutputColumn.h>
#include <aws/quicksight/model/OverrideDatasetParameterOperation.h>
#include <aws/quicksight/model/PaginationConfiguration.h>
#include <aws/quicksight/model/Palette.h>
#include <aws/quicksight/model/PanelBorderStyle.h>
#include <aws/quicksight/model/PanelConfiguration.h>
#include <aws/quicksight/model/PanelTitleOptions.h>
#include <aws/quicksight/model/PaperOrientation.h>
#include <aws/quicksight/model/PaperSize.h>
#include <aws/quicksight/model/ParameterControl.h>
#include <aws/quicksight/model/ParameterDateTimePickerControl.h>
#include <aws/quicksight/model/ParameterDeclaration.h>
#include <aws/quicksight/model/ParameterDropDownControl.h>
#include <aws/quicksight/model/ParameterListControl.h>
#include <aws/quicksight/model/ParameterSelectableValues.h>
#include <aws/quicksight/model/ParameterSliderControl.h>
#include <aws/quicksight/model/ParameterTextAreaControl.h>
#include <aws/quicksight/model/ParameterTextFieldControl.h>
#include <aws/quicksight/model/ParameterValueType.h>
#include <aws/quicksight/model/Parameters.h>
#include <aws/quicksight/model/PercentVisibleRange.h>
#include <aws/quicksight/model/PercentageDisplayFormatConfiguration.h>
#include <aws/quicksight/model/PercentileAggregation.h>
#include <aws/quicksight/model/PerformanceConfiguration.h>
#include <aws/quicksight/model/PeriodOverPeriodComputation.h>
#include <aws/quicksight/model/PeriodToDateComputation.h>
#include <aws/quicksight/model/PersonalizationMode.h>
#include <aws/quicksight/model/PhysicalTable.h>
#include <aws/quicksight/model/PieChartAggregatedFieldWells.h>
#include <aws/quicksight/model/PieChartConfiguration.h>
#include <aws/quicksight/model/PieChartFieldWells.h>
#include <aws/quicksight/model/PieChartSortConfiguration.h>
#include <aws/quicksight/model/PieChartVisual.h>
#include <aws/quicksight/model/PivotFieldSortOptions.h>
#include <aws/quicksight/model/PivotTableAggregatedFieldWells.h>
#include <aws/quicksight/model/PivotTableCellConditionalFormatting.h>
#include <aws/quicksight/model/PivotTableConditionalFormatting.h>
#include <aws/quicksight/model/PivotTableConditionalFormattingOption.h>
#include <aws/quicksight/model/PivotTableConditionalFormattingScope.h>
#include <aws/quicksight/model/PivotTableConditionalFormattingScopeRole.h>
#include <aws/quicksight/model/PivotTableConfiguration.h>
#include <aws/quicksight/model/PivotTableDataPathOption.h>
#include <aws/quicksight/model/PivotTableDataPathType.h>
#include <aws/quicksight/model/PivotTableFieldCollapseState.h>
#include <aws/quicksight/model/PivotTableFieldCollapseStateOption.h>
#include <aws/quicksight/model/PivotTableFieldCollapseStateTarget.h>
#include <aws/quicksight/model/PivotTableFieldOption.h>
#include <aws/quicksight/model/PivotTableFieldOptions.h>
#include <aws/quicksight/model/PivotTableFieldSubtotalOptions.h>
#include <aws/quicksight/model/PivotTableFieldWells.h>
#include <aws/quicksight/model/PivotTableMetricPlacement.h>
#include <aws/quicksight/model/PivotTableOptions.h>
#include <aws/quicksight/model/PivotTablePaginatedReportOptions.h>
#include <aws/quicksight/model/PivotTableRowsLabelOptions.h>
#include <aws/quicksight/model/PivotTableRowsLayout.h>
#include <aws/quicksight/model/PivotTableSortBy.h>
#include <aws/quicksight/model/PivotTableSortConfiguration.h>
#include <aws/quicksight/model/PivotTableSubtotalLevel.h>
#include <aws/quicksight/model/PivotTableTotalOptions.h>
#include <aws/quicksight/model/PivotTableVisual.h>
#include <aws/quicksight/model/PivotTotalOptions.h>
#include <aws/quicksight/model/PluginVisual.h>
#include <aws/quicksight/model/PluginVisualAxisName.h>
#include <aws/quicksight/model/PluginVisualConfiguration.h>
#include <aws/quicksight/model/PluginVisualFieldWell.h>
#include <aws/quicksight/model/PluginVisualItemsLimitConfiguration.h>
#include <aws/quicksight/model/PluginVisualOptions.h>
#include <aws/quicksight/model/PluginVisualProperty.h>
#include <aws/quicksight/model/PluginVisualSortConfiguration.h>
#include <aws/quicksight/model/PluginVisualTableQuerySort.h>
#include <aws/quicksight/model/PostgreSqlParameters.h>
#include <aws/quicksight/model/PreconditionNotMetException.h>
#include <aws/quicksight/model/PredefinedHierarchy.h>
#include <aws/quicksight/model/PredictQAResultsRequest.h>
#include <aws/quicksight/model/PredictQAResultsResult.h>
#include <aws/quicksight/model/PrestoParameters.h>
#include <aws/quicksight/model/PrimaryValueDisplayType.h>
#include <aws/quicksight/model/ProgressBarOptions.h>
#include <aws/quicksight/model/ProjectOperation.h>
#include <aws/quicksight/model/PropertyRole.h>
#include <aws/quicksight/model/PropertyUsage.h>
#include <aws/quicksight/model/PurchaseMode.h>
#include <aws/quicksight/model/PutDataSetRefreshPropertiesRequest.h>
#include <aws/quicksight/model/PutDataSetRefreshPropertiesResult.h>
#include <aws/quicksight/model/QAResult.h>
#include <aws/quicksight/model/QAResultType.h>
#include <aws/quicksight/model/QBusinessInsightsStatus.h>
#include <aws/quicksight/model/QSearchStatus.h>
#include <aws/quicksight/model/QueryExecutionMode.h>
#include <aws/quicksight/model/QueryExecutionOptions.h>
#include <aws/quicksight/model/QueueInfo.h>
#include <aws/quicksight/model/QuickSightUserNotFoundException.h>
#include <aws/quicksight/model/RadarChartAggregatedFieldWells.h>
#include <aws/quicksight/model/RadarChartAreaStyleSettings.h>
#include <aws/quicksight/model/RadarChartAxesRangeScale.h>
#include <aws/quicksight/model/RadarChartConfiguration.h>
#include <aws/quicksight/model/RadarChartFieldWells.h>
#include <aws/quicksight/model/RadarChartSeriesSettings.h>
#include <aws/quicksight/model/RadarChartShape.h>
#include <aws/quicksight/model/RadarChartSortConfiguration.h>
#include <aws/quicksight/model/RadarChartVisual.h>
#include <aws/quicksight/model/RangeConstant.h>
#include <aws/quicksight/model/RangeEndsLabelType.h>
#include <aws/quicksight/model/RdsParameters.h>
#include <aws/quicksight/model/RecentSnapshotsConfigurations.h>
#include <aws/quicksight/model/RedshiftIAMParameters.h>
#include <aws/quicksight/model/RedshiftParameters.h>
#include <aws/quicksight/model/ReferenceLine.h>
#include <aws/quicksight/model/ReferenceLineCustomLabelConfiguration.h>
#include <aws/quicksight/model/ReferenceLineDataConfiguration.h>
#include <aws/quicksight/model/ReferenceLineDynamicDataConfiguration.h>
#include <aws/quicksight/model/ReferenceLineLabelConfiguration.h>
#include <aws/quicksight/model/ReferenceLineLabelHorizontalPosition.h>
#include <aws/quicksight/model/ReferenceLineLabelVerticalPosition.h>
#include <aws/quicksight/model/ReferenceLinePatternType.h>
#include <aws/quicksight/model/ReferenceLineSeriesType.h>
#include <aws/quicksight/model/ReferenceLineStaticDataConfiguration.h>
#include <aws/quicksight/model/ReferenceLineStyleConfiguration.h>
#include <aws/quicksight/model/ReferenceLineValueLabelConfiguration.h>
#include <aws/quicksight/model/ReferenceLineValueLabelRelativePosition.h>
#include <aws/quicksight/model/RefreshConfiguration.h>
#include <aws/quicksight/model/RefreshFailureAlertStatus.h>
#include <aws/quicksight/model/RefreshFailureConfiguration.h>
#include <aws/quicksight/model/RefreshFailureEmailAlert.h>
#include <aws/quicksight/model/RefreshFrequency.h>
#include <aws/quicksight/model/RefreshInterval.h>
#include <aws/quicksight/model/RefreshSchedule.h>
#include <aws/quicksight/model/RegisterUserRequest.h>
#include <aws/quicksight/model/RegisterUserResult.h>
#include <aws/quicksight/model/RegisteredCustomerManagedKey.h>
#include <aws/quicksight/model/RegisteredUserConsoleFeatureConfigurations.h>
#include <aws/quicksight/model/RegisteredUserDashboardEmbeddingConfiguration.h>
#include <aws/quicksight/model/RegisteredUserDashboardFeatureConfigurations.h>
#include <aws/quicksight/model/RegisteredUserDashboardVisualEmbeddingConfiguration.h>
#include <aws/quicksight/model/RegisteredUserEmbeddingExperienceConfiguration.h>
#include <aws/quicksight/model/RegisteredUserGenerativeQnAEmbeddingConfiguration.h>
#include <aws/quicksight/model/RegisteredUserQSearchBarEmbeddingConfiguration.h>
#include <aws/quicksight/model/RegisteredUserQuickSightConsoleEmbeddingConfiguration.h>
#include <aws/quicksight/model/RelationalTable.h>
#include <aws/quicksight/model/RelativeDateTimeControlDisplayOptions.h>
#include <aws/quicksight/model/RelativeDateType.h>
#include <aws/quicksight/model/RelativeDatesFilter.h>
#include <aws/quicksight/model/RelativeFontSize.h>
#include <aws/quicksight/model/RenameColumnOperation.h>
#include <aws/quicksight/model/ResizeOption.h>
#include <aws/quicksight/model/ResourceExistsException.h>
#include <aws/quicksight/model/ResourceNotFoundException.h>
#include <aws/quicksight/model/ResourcePermission.h>
#include <aws/quicksight/model/ResourceStatus.h>
#include <aws/quicksight/model/ResourceUnavailableException.h>
#include <aws/quicksight/model/RestoreAnalysisRequest.h>
#include <aws/quicksight/model/RestoreAnalysisResult.h>
#include <aws/quicksight/model/ReviewedAnswerErrorCode.h>
#include <aws/quicksight/model/Role.h>
#include <aws/quicksight/model/RollingDateConfiguration.h>
#include <aws/quicksight/model/RowAlternateColorOptions.h>
#include <aws/quicksight/model/RowInfo.h>
#include <aws/quicksight/model/RowLevelPermissionDataSet.h>
#include <aws/quicksight/model/RowLevelPermissionFormatVersion.h>
#include <aws/quicksight/model/RowLevelPermissionPolicy.h>
#include <aws/quicksight/model/RowLevelPermissionTagConfiguration.h>
#include <aws/quicksight/model/RowLevelPermissionTagRule.h>
#include <aws/quicksight/model/S3BucketConfiguration.h>
#include <aws/quicksight/model/S3Parameters.h>
#include <aws/quicksight/model/S3Source.h>
#include <aws/quicksight/model/SameSheetTargetVisualConfiguration.h>
#include <aws/quicksight/model/SankeyDiagramAggregatedFieldWells.h>
#include <aws/quicksight/model/SankeyDiagramChartConfiguration.h>
#include <aws/quicksight/model/SankeyDiagramFieldWells.h>
#include <aws/quicksight/model/SankeyDiagramSortConfiguration.h>
#include <aws/quicksight/model/SankeyDiagramVisual.h>
#include <aws/quicksight/model/ScatterPlotCategoricallyAggregatedFieldWells.h>
#include <aws/quicksight/model/ScatterPlotConfiguration.h>
#include <aws/quicksight/model/ScatterPlotFieldWells.h>
#include <aws/quicksight/model/ScatterPlotSortConfiguration.h>
#include <aws/quicksight/model/ScatterPlotUnaggregatedFieldWells.h>
#include <aws/quicksight/model/ScatterPlotVisual.h>
#include <aws/quicksight/model/ScheduleRefreshOnEntity.h>
#include <aws/quicksight/model/SchedulesConfigurations.h>
#include <aws/quicksight/model/ScrollBarOptions.h>
#include <aws/quicksight/model/SearchAnalysesRequest.h>
#include <aws/quicksight/model/SearchAnalysesResult.h>
#include <aws/quicksight/model/SearchDashboardsRequest.h>
#include <aws/quicksight/model/SearchDashboardsResult.h>
#include <aws/quicksight/model/SearchDataSetsRequest.h>
#include <aws/quicksight/model/SearchDataSetsResult.h>
#include <aws/quicksight/model/SearchDataSourcesRequest.h>
#include <aws/quicksight/model/SearchDataSourcesResult.h>
#include <aws/quicksight/model/SearchFoldersRequest.h>
#include <aws/quicksight/model/SearchFoldersResult.h>
#include <aws/quicksight/model/SearchGroupsRequest.h>
#include <aws/quicksight/model/SearchGroupsResult.h>
#include <aws/quicksight/model/SearchTopicsRequest.h>
#include <aws/quicksight/model/SearchTopicsResult.h>
#include <aws/quicksight/model/SecondaryValueOptions.h>
#include <aws/quicksight/model/SectionAfterPageBreak.h>
#include <aws/quicksight/model/SectionBasedLayoutCanvasSizeOptions.h>
#include <aws/quicksight/model/SectionBasedLayoutConfiguration.h>
#include <aws/quicksight/model/SectionBasedLayoutPaperCanvasSizeOptions.h>
#include <aws/quicksight/model/SectionLayoutConfiguration.h>
#include <aws/quicksight/model/SectionPageBreakConfiguration.h>
#include <aws/quicksight/model/SectionPageBreakStatus.h>
#include <aws/quicksight/model/SectionStyle.h>
#include <aws/quicksight/model/SelectAllValueOptions.h>
#include <aws/quicksight/model/SelectedFieldOptions.h>
#include <aws/quicksight/model/SelectedSheetsFilterScopeConfiguration.h>
#include <aws/quicksight/model/SelectedTooltipType.h>
#include <aws/quicksight/model/SemanticEntityType.h>
#include <aws/quicksight/model/SemanticType.h>
#include <aws/quicksight/model/SeriesItem.h>
#include <aws/quicksight/model/ServiceNowParameters.h>
#include <aws/quicksight/model/ServiceType.h>
#include <aws/quicksight/model/SessionLifetimeInMinutesInvalidException.h>
#include <aws/quicksight/model/SessionTag.h>
#include <aws/quicksight/model/SetParameterValueConfiguration.h>
#include <aws/quicksight/model/ShapeConditionalFormat.h>
#include <aws/quicksight/model/SharedViewConfigurations.h>
#include <aws/quicksight/model/SharingModel.h>
#include <aws/quicksight/model/Sheet.h>
#include <aws/quicksight/model/SheetContentType.h>
#include <aws/quicksight/model/SheetControlDateTimePickerType.h>
#include <aws/quicksight/model/SheetControlInfoIconLabelOptions.h>
#include <aws/quicksight/model/SheetControlLayout.h>
#include <aws/quicksight/model/SheetControlLayoutConfiguration.h>
#include <aws/quicksight/model/SheetControlListType.h>
#include <aws/quicksight/model/SheetControlSliderType.h>
#include <aws/quicksight/model/SheetControlsOption.h>
#include <aws/quicksight/model/SheetDefinition.h>
#include <aws/quicksight/model/SheetElementConfigurationOverrides.h>
#include <aws/quicksight/model/SheetElementRenderingRule.h>
#include <aws/quicksight/model/SheetImage.h>
#include <aws/quicksight/model/SheetImageScalingConfiguration.h>
#include <aws/quicksight/model/SheetImageScalingType.h>
#include <aws/quicksight/model/SheetImageSource.h>
#include <aws/quicksight/model/SheetImageStaticFileSource.h>
#include <aws/quicksight/model/SheetImageTooltipConfiguration.h>
#include <aws/quicksight/model/SheetImageTooltipText.h>
#include <aws/quicksight/model/SheetLayoutElementMaximizationOption.h>
#include <aws/quicksight/model/SheetStyle.h>
#include <aws/quicksight/model/SheetTextBox.h>
#include <aws/quicksight/model/SheetVisualScopingConfiguration.h>
#include <aws/quicksight/model/ShortFormatText.h>
#include <aws/quicksight/model/SignupResponse.h>
#include <aws/quicksight/model/SimpleAttributeAggregationFunction.h>
#include <aws/quicksight/model/SimpleClusterMarker.h>
#include <aws/quicksight/model/SimpleNumericalAggregationFunction.h>
#include <aws/quicksight/model/SimpleTotalAggregationFunction.h>
#include <aws/quicksight/model/SingleAxisOptions.h>
#include <aws/quicksight/model/SingleYAxisOption.h>
#include <aws/quicksight/model/SliderControlDisplayOptions.h>
#include <aws/quicksight/model/Slot.h>
#include <aws/quicksight/model/SmallMultiplesAxisPlacement.h>
#include <aws/quicksight/model/SmallMultiplesAxisProperties.h>
#include <aws/quicksight/model/SmallMultiplesAxisScale.h>
#include <aws/quicksight/model/SmallMultiplesOptions.h>
#include <aws/quicksight/model/SnapshotAnonymousUser.h>
#include <aws/quicksight/model/SnapshotAnonymousUserRedacted.h>
#include <aws/quicksight/model/SnapshotConfiguration.h>
#include <aws/quicksight/model/SnapshotDestinationConfiguration.h>
#include <aws/quicksight/model/SnapshotFile.h>
#include <aws/quicksight/model/SnapshotFileFormatType.h>
#include <aws/quicksight/model/SnapshotFileGroup.h>
#include <aws/quicksight/model/SnapshotFileSheetSelection.h>
#include <aws/quicksight/model/SnapshotFileSheetSelectionScope.h>
#include <aws/quicksight/model/SnapshotJobErrorInfo.h>
#include <aws/quicksight/model/SnapshotJobResult.h>
#include <aws/quicksight/model/SnapshotJobResultErrorInfo.h>
#include <aws/quicksight/model/SnapshotJobResultFileGroup.h>
#include <aws/quicksight/model/SnapshotJobS3Result.h>
#include <aws/quicksight/model/SnapshotJobStatus.h>
#include <aws/quicksight/model/SnapshotS3DestinationConfiguration.h>
#include <aws/quicksight/model/SnapshotUserConfiguration.h>
#include <aws/quicksight/model/SnapshotUserConfigurationRedacted.h>
#include <aws/quicksight/model/SnowflakeParameters.h>
#include <aws/quicksight/model/SortDirection.h>
#include <aws/quicksight/model/Spacing.h>
#include <aws/quicksight/model/SparkParameters.h>
#include <aws/quicksight/model/SpatialStaticFile.h>
#include <aws/quicksight/model/SpecialValue.h>
#include <aws/quicksight/model/SqlServerParameters.h>
#include <aws/quicksight/model/SslProperties.h>
#include <aws/quicksight/model/StarburstParameters.h>
#include <aws/quicksight/model/StarburstProductType.h>
#include <aws/quicksight/model/StartAssetBundleExportJobRequest.h>
#include <aws/quicksight/model/StartAssetBundleExportJobResult.h>
#include <aws/quicksight/model/StartAssetBundleImportJobRequest.h>
#include <aws/quicksight/model/StartAssetBundleImportJobResult.h>
#include <aws/quicksight/model/StartDashboardSnapshotJobRequest.h>
#include <aws/quicksight/model/StartDashboardSnapshotJobResult.h>
#include <aws/quicksight/model/StartDashboardSnapshotJobScheduleRequest.h>
#include <aws/quicksight/model/StartDashboardSnapshotJobScheduleResult.h>
#include <aws/quicksight/model/StatePersistenceConfigurations.h>
#include <aws/quicksight/model/StaticFile.h>
#include <aws/quicksight/model/StaticFileS3SourceOptions.h>
#include <aws/quicksight/model/StaticFileSource.h>
#include <aws/quicksight/model/StaticFileUrlSourceOptions.h>
#include <aws/quicksight/model/Status.h>
#include <aws/quicksight/model/StringDatasetParameter.h>
#include <aws/quicksight/model/StringDatasetParameterDefaultValues.h>
#include <aws/quicksight/model/StringDefaultValues.h>
#include <aws/quicksight/model/StringFormatConfiguration.h>
#include <aws/quicksight/model/StringParameter.h>
#include <aws/quicksight/model/StringParameterDeclaration.h>
#include <aws/quicksight/model/StringValueWhenUnsetConfiguration.h>
#include <aws/quicksight/model/StyledCellType.h>
#include <aws/quicksight/model/SubtotalOptions.h>
#include <aws/quicksight/model/SucceededTopicReviewedAnswer.h>
#include <aws/quicksight/model/SuccessfulKeyRegistrationEntry.h>
#include <aws/quicksight/model/TableAggregatedFieldWells.h>
#include <aws/quicksight/model/TableBorderOptions.h>
#include <aws/quicksight/model/TableBorderStyle.h>
#include <aws/quicksight/model/TableCellConditionalFormatting.h>
#include <aws/quicksight/model/TableCellImageScalingConfiguration.h>
#include <aws/quicksight/model/TableCellImageSizingConfiguration.h>
#include <aws/quicksight/model/TableCellStyle.h>
#include <aws/quicksight/model/TableConditionalFormatting.h>
#include <aws/quicksight/model/TableConditionalFormattingOption.h>
#include <aws/quicksight/model/TableConfiguration.h>
#include <aws/quicksight/model/TableFieldCustomIconContent.h>
#include <aws/quicksight/model/TableFieldCustomTextContent.h>
#include <aws/quicksight/model/TableFieldIconSetType.h>
#include <aws/quicksight/model/TableFieldImageConfiguration.h>
#include <aws/quicksight/model/TableFieldLinkConfiguration.h>
#include <aws/quicksight/model/TableFieldLinkContentConfiguration.h>
#include <aws/quicksight/model/TableFieldOption.h>
#include <aws/quicksight/model/TableFieldOptions.h>
#include <aws/quicksight/model/TableFieldURLConfiguration.h>
#include <aws/quicksight/model/TableFieldWells.h>
#include <aws/quicksight/model/TableInlineVisualization.h>
#include <aws/quicksight/model/TableOptions.h>
#include <aws/quicksight/model/TableOrientation.h>
#include <aws/quicksight/model/TablePaginatedReportOptions.h>
#include <aws/quicksight/model/TablePinnedFieldOptions.h>
#include <aws/quicksight/model/TableRowConditionalFormatting.h>
#include <aws/quicksight/model/TableSideBorderOptions.h>
#include <aws/quicksight/model/TableSortConfiguration.h>
#include <aws/quicksight/model/TableStyleTarget.h>
#include <aws/quicksight/model/TableTotalsPlacement.h>
#include <aws/quicksight/model/TableTotalsScrollStatus.h>
#include <aws/quicksight/model/TableUnaggregatedFieldWells.h>
#include <aws/quicksight/model/TableVisual.h>
#include <aws/quicksight/model/Tag.h>
#include <aws/quicksight/model/TagColumnOperation.h>
#include <aws/quicksight/model/TagResourceRequest.h>
#include <aws/quicksight/model/TagResourceResult.h>
#include <aws/quicksight/model/TargetVisualOptions.h>
#include <aws/quicksight/model/Template.h>
#include <aws/quicksight/model/TemplateAlias.h>
#include <aws/quicksight/model/TemplateError.h>
#include <aws/quicksight/model/TemplateErrorType.h>
#include <aws/quicksight/model/TemplateSourceAnalysis.h>
#include <aws/quicksight/model/TemplateSourceEntity.h>
#include <aws/quicksight/model/TemplateSourceTemplate.h>
#include <aws/quicksight/model/TemplateSummary.h>
#include <aws/quicksight/model/TemplateVersion.h>
#include <aws/quicksight/model/TemplateVersionDefinition.h>
#include <aws/quicksight/model/TemplateVersionSummary.h>
#include <aws/quicksight/model/TeradataParameters.h>
#include <aws/quicksight/model/TextAreaControlDisplayOptions.h>
#include <aws/quicksight/model/TextConditionalFormat.h>
#include <aws/quicksight/model/TextControlPlaceholderOptions.h>
#include <aws/quicksight/model/TextFieldControlDisplayOptions.h>
#include <aws/quicksight/model/TextQualifier.h>
#include <aws/quicksight/model/TextWrap.h>
#include <aws/quicksight/model/Theme.h>
#include <aws/quicksight/model/ThemeAlias.h>
#include <aws/quicksight/model/ThemeConfiguration.h>
#include <aws/quicksight/model/ThemeError.h>
#include <aws/quicksight/model/ThemeErrorType.h>
#include <aws/quicksight/model/ThemeSummary.h>
#include <aws/quicksight/model/ThemeType.h>
#include <aws/quicksight/model/ThemeVersion.h>
#include <aws/quicksight/model/ThemeVersionSummary.h>
#include <aws/quicksight/model/ThousandSeparatorOptions.h>
#include <aws/quicksight/model/ThresholdAlertsConfigurations.h>
#include <aws/quicksight/model/ThrottlingException.h>
#include <aws/quicksight/model/TileLayoutStyle.h>
#include <aws/quicksight/model/TileStyle.h>
#include <aws/quicksight/model/TimeBasedForecastProperties.h>
#include <aws/quicksight/model/TimeEqualityFilter.h>
#include <aws/quicksight/model/TimeGranularity.h>
#include <aws/quicksight/model/TimeRangeDrillDownFilter.h>
#include <aws/quicksight/model/TimeRangeFilter.h>
#include <aws/quicksight/model/TimeRangeFilterValue.h>
#include <aws/quicksight/model/TooltipItem.h>
#include <aws/quicksight/model/TooltipOptions.h>
#include <aws/quicksight/model/TooltipTarget.h>
#include <aws/quicksight/model/TooltipTitleType.h>
#include <aws/quicksight/model/TopBottomComputationType.h>
#include <aws/quicksight/model/TopBottomFilter.h>
#include <aws/quicksight/model/TopBottomMoversComputation.h>
#include <aws/quicksight/model/TopBottomRankedComputation.h>
#include <aws/quicksight/model/TopBottomSortOrder.h>
#include <aws/quicksight/model/TopicCalculatedField.h>
#include <aws/quicksight/model/TopicCategoryFilter.h>
#include <aws/quicksight/model/TopicCategoryFilterConstant.h>
#include <aws/quicksight/model/TopicColumn.h>
#include <aws/quicksight/model/TopicConfigOptions.h>
#include <aws/quicksight/model/TopicConstantValue.h>
#include <aws/quicksight/model/TopicDateRangeFilter.h>
#include <aws/quicksight/model/TopicDetails.h>
#include <aws/quicksight/model/TopicFilter.h>
#include <aws/quicksight/model/TopicFilterAttribute.h>
#include <aws/quicksight/model/TopicFilterOperator.h>
#include <aws/quicksight/model/TopicIR.h>
#include <aws/quicksight/model/TopicIRComparisonMethod.h>
#include <aws/quicksight/model/TopicIRContributionAnalysis.h>
#include <aws/quicksight/model/TopicIRFilterFunction.h>
#include <aws/quicksight/model/TopicIRFilterOption.h>
#include <aws/quicksight/model/TopicIRFilterType.h>
#include <aws/quicksight/model/TopicIRGroupBy.h>
#include <aws/quicksight/model/TopicIRMetric.h>
#include <aws/quicksight/model/TopicNamedEntity.h>
#include <aws/quicksight/model/TopicNumericEqualityFilter.h>
#include <aws/quicksight/model/TopicNumericRangeFilter.h>
#include <aws/quicksight/model/TopicNumericSeparatorSymbol.h>
#include <aws/quicksight/model/TopicRangeFilterConstant.h>
#include <aws/quicksight/model/TopicRefreshDetails.h>
#include <aws/quicksight/model/TopicRefreshSchedule.h>
#include <aws/quicksight/model/TopicRefreshScheduleSummary.h>
#include <aws/quicksight/model/TopicRefreshStatus.h>
#include <aws/quicksight/model/TopicRelativeDateFilter.h>
#include <aws/quicksight/model/TopicRelativeDateFilterFunction.h>
#include <aws/quicksight/model/TopicReviewedAnswer.h>
#include <aws/quicksight/model/TopicScheduleType.h>
#include <aws/quicksight/model/TopicSearchFilter.h>
#include <aws/quicksight/model/TopicSingularFilterConstant.h>
#include <aws/quicksight/model/TopicSortClause.h>
#include <aws/quicksight/model/TopicSortDirection.h>
#include <aws/quicksight/model/TopicSummary.h>
#include <aws/quicksight/model/TopicTemplate.h>
#include <aws/quicksight/model/TopicTimeGranularity.h>
#include <aws/quicksight/model/TopicUserExperienceVersion.h>
#include <aws/quicksight/model/TopicVisual.h>
#include <aws/quicksight/model/TotalAggregationComputation.h>
#include <aws/quicksight/model/TotalAggregationFunction.h>
#include <aws/quicksight/model/TotalAggregationOption.h>
#include <aws/quicksight/model/TotalOptions.h>
#include <aws/quicksight/model/TransformOperation.h>
#include <aws/quicksight/model/TransposedColumnType.h>
#include <aws/quicksight/model/TransposedTableOption.h>
#include <aws/quicksight/model/TreeMapAggregatedFieldWells.h>
#include <aws/quicksight/model/TreeMapConfiguration.h>
#include <aws/quicksight/model/TreeMapFieldWells.h>
#include <aws/quicksight/model/TreeMapSortConfiguration.h>
#include <aws/quicksight/model/TreeMapVisual.h>
#include <aws/quicksight/model/TrendArrowOptions.h>
#include <aws/quicksight/model/TrinoParameters.h>
#include <aws/quicksight/model/TwitterParameters.h>
#include <aws/quicksight/model/Typography.h>
#include <aws/quicksight/model/UIColorPalette.h>
#include <aws/quicksight/model/URLTargetConfiguration.h>
#include <aws/quicksight/model/UnaggregatedField.h>
#include <aws/quicksight/model/UndefinedSpecifiedValueType.h>
#include <aws/quicksight/model/UniqueKey.h>
#include <aws/quicksight/model/UniqueValuesComputation.h>
#include <aws/quicksight/model/UnsupportedPricingPlanException.h>
#include <aws/quicksight/model/UnsupportedUserEditionException.h>
#include <aws/quicksight/model/UntagColumnOperation.h>
#include <aws/quicksight/model/UntagResourceRequest.h>
#include <aws/quicksight/model/UntagResourceResult.h>
#include <aws/quicksight/model/UpdateAccountCustomizationRequest.h>
#include <aws/quicksight/model/UpdateAccountCustomizationResult.h>
#include <aws/quicksight/model/UpdateAccountSettingsRequest.h>
#include <aws/quicksight/model/UpdateAccountSettingsResult.h>
#include <aws/quicksight/model/UpdateAnalysisPermissionsRequest.h>
#include <aws/quicksight/model/UpdateAnalysisPermissionsResult.h>
#include <aws/quicksight/model/UpdateAnalysisRequest.h>
#include <aws/quicksight/model/UpdateAnalysisResult.h>
#include <aws/quicksight/model/UpdateApplicationWithTokenExchangeGrantRequest.h>
#include <aws/quicksight/model/UpdateApplicationWithTokenExchangeGrantResult.h>
#include <aws/quicksight/model/UpdateBrandAssignmentRequest.h>
#include <aws/quicksight/model/UpdateBrandAssignmentResult.h>
#include <aws/quicksight/model/UpdateBrandPublishedVersionRequest.h>
#include <aws/quicksight/model/UpdateBrandPublishedVersionResult.h>
#include <aws/quicksight/model/UpdateBrandRequest.h>
#include <aws/quicksight/model/UpdateBrandResult.h>
#include <aws/quicksight/model/UpdateCustomPermissionsRequest.h>
#include <aws/quicksight/model/UpdateCustomPermissionsResult.h>
#include <aws/quicksight/model/UpdateDashboardLinksRequest.h>
#include <aws/quicksight/model/UpdateDashboardLinksResult.h>
#include <aws/quicksight/model/UpdateDashboardPermissionsRequest.h>
#include <aws/quicksight/model/UpdateDashboardPermissionsResult.h>
#include <aws/quicksight/model/UpdateDashboardPublishedVersionRequest.h>
#include <aws/quicksight/model/UpdateDashboardPublishedVersionResult.h>
#include <aws/quicksight/model/UpdateDashboardRequest.h>
#include <aws/quicksight/model/UpdateDashboardResult.h>
#include <aws/quicksight/model/UpdateDashboardsQAConfigurationRequest.h>
#include <aws/quicksight/model/UpdateDashboardsQAConfigurationResult.h>
#include <aws/quicksight/model/UpdateDataSetPermissionsRequest.h>
#include <aws/quicksight/model/UpdateDataSetPermissionsResult.h>
#include <aws/quicksight/model/UpdateDataSetRequest.h>
#include <aws/quicksight/model/UpdateDataSetResult.h>
#include <aws/quicksight/model/UpdateDataSourcePermissionsRequest.h>
#include <aws/quicksight/model/UpdateDataSourcePermissionsResult.h>
#include <aws/quicksight/model/UpdateDataSourceRequest.h>
#include <aws/quicksight/model/UpdateDataSourceResult.h>
#include <aws/quicksight/model/UpdateDefaultQBusinessApplicationRequest.h>
#include <aws/quicksight/model/UpdateDefaultQBusinessApplicationResult.h>
#include <aws/quicksight/model/UpdateFolderPermissionsRequest.h>
#include <aws/quicksight/model/UpdateFolderPermissionsResult.h>
#include <aws/quicksight/model/UpdateFolderRequest.h>
#include <aws/quicksight/model/UpdateFolderResult.h>
#include <aws/quicksight/model/UpdateGroupRequest.h>
#include <aws/quicksight/model/UpdateGroupResult.h>
#include <aws/quicksight/model/UpdateIAMPolicyAssignmentRequest.h>
#include <aws/quicksight/model/UpdateIAMPolicyAssignmentResult.h>
#include <aws/quicksight/model/UpdateIdentityPropagationConfigRequest.h>
#include <aws/quicksight/model/UpdateIdentityPropagationConfigResult.h>
#include <aws/quicksight/model/UpdateIpRestrictionRequest.h>
#include <aws/quicksight/model/UpdateIpRestrictionResult.h>
#include <aws/quicksight/model/UpdateKeyRegistrationRequest.h>
#include <aws/quicksight/model/UpdateKeyRegistrationResult.h>
#include <aws/quicksight/model/UpdatePublicSharingSettingsRequest.h>
#include <aws/quicksight/model/UpdatePublicSharingSettingsResult.h>
#include <aws/quicksight/model/UpdateQPersonalizationConfigurationRequest.h>
#include <aws/quicksight/model/UpdateQPersonalizationConfigurationResult.h>
#include <aws/quicksight/model/UpdateQuickSightQSearchConfigurationRequest.h>
#include <aws/quicksight/model/UpdateQuickSightQSearchConfigurationResult.h>
#include <aws/quicksight/model/UpdateRefreshScheduleRequest.h>
#include <aws/quicksight/model/UpdateRefreshScheduleResult.h>
#include <aws/quicksight/model/UpdateRoleCustomPermissionRequest.h>
#include <aws/quicksight/model/UpdateRoleCustomPermissionResult.h>
#include <aws/quicksight/model/UpdateSPICECapacityConfigurationRequest.h>
#include <aws/quicksight/model/UpdateSPICECapacityConfigurationResult.h>
#include <aws/quicksight/model/UpdateTemplateAliasRequest.h>
#include <aws/quicksight/model/UpdateTemplateAliasResult.h>
#include <aws/quicksight/model/UpdateTemplatePermissionsRequest.h>
#include <aws/quicksight/model/UpdateTemplatePermissionsResult.h>
#include <aws/quicksight/model/UpdateTemplateRequest.h>
#include <aws/quicksight/model/UpdateTemplateResult.h>
#include <aws/quicksight/model/UpdateThemeAliasRequest.h>
#include <aws/quicksight/model/UpdateThemeAliasResult.h>
#include <aws/quicksight/model/UpdateThemePermissionsRequest.h>
#include <aws/quicksight/model/UpdateThemePermissionsResult.h>
#include <aws/quicksight/model/UpdateThemeRequest.h>
#include <aws/quicksight/model/UpdateThemeResult.h>
#include <aws/quicksight/model/UpdateTopicPermissionsRequest.h>
#include <aws/quicksight/model/UpdateTopicPermissionsResult.h>
#include <aws/quicksight/model/UpdateTopicRefreshScheduleRequest.h>
#include <aws/quicksight/model/UpdateTopicRefreshScheduleResult.h>
#include <aws/quicksight/model/UpdateTopicRequest.h>
#include <aws/quicksight/model/UpdateTopicResult.h>
#include <aws/quicksight/model/UpdateUserCustomPermissionRequest.h>
#include <aws/quicksight/model/UpdateUserCustomPermissionResult.h>
#include <aws/quicksight/model/UpdateUserRequest.h>
#include <aws/quicksight/model/UpdateUserResult.h>
#include <aws/quicksight/model/UpdateVPCConnectionRequest.h>
#include <aws/quicksight/model/UpdateVPCConnectionResult.h>
#include <aws/quicksight/model/UploadSettings.h>
#include <aws/quicksight/model/User.h>
#include <aws/quicksight/model/UserRole.h>
#include <aws/quicksight/model/VPCConnection.h>
#include <aws/quicksight/model/VPCConnectionAvailabilityStatus.h>
#include <aws/quicksight/model/VPCConnectionResourceStatus.h>
#include <aws/quicksight/model/VPCConnectionSummary.h>
#include <aws/quicksight/model/ValidationStrategy.h>
#include <aws/quicksight/model/ValidationStrategyMode.h>
#include <aws/quicksight/model/ValueWhenUnsetOption.h>
#include <aws/quicksight/model/VerticalTextAlignment.h>
#include <aws/quicksight/model/Visibility.h>
#include <aws/quicksight/model/VisibleRangeOptions.h>
#include <aws/quicksight/model/Visual.h>
#include <aws/quicksight/model/VisualAxisSortOption.h>
#include <aws/quicksight/model/VisualCustomAction.h>
#include <aws/quicksight/model/VisualCustomActionDefaults.h>
#include <aws/quicksight/model/VisualCustomActionOperation.h>
#include <aws/quicksight/model/VisualCustomActionTrigger.h>
#include <aws/quicksight/model/VisualHighlightOperation.h>
#include <aws/quicksight/model/VisualHighlightTrigger.h>
#include <aws/quicksight/model/VisualInteractionOptions.h>
#include <aws/quicksight/model/VisualMenuOption.h>
#include <aws/quicksight/model/VisualOptions.h>
#include <aws/quicksight/model/VisualPalette.h>
#include <aws/quicksight/model/VisualRole.h>
#include <aws/quicksight/model/VisualSubtitleLabelOptions.h>
#include <aws/quicksight/model/VisualTitleLabelOptions.h>
#include <aws/quicksight/model/VpcConnectionProperties.h>
#include <aws/quicksight/model/WaterfallChartAggregatedFieldWells.h>
#include <aws/quicksight/model/WaterfallChartColorConfiguration.h>
#include <aws/quicksight/model/WaterfallChartConfiguration.h>
#include <aws/quicksight/model/WaterfallChartFieldWells.h>
#include <aws/quicksight/model/WaterfallChartGroupColorConfiguration.h>
#include <aws/quicksight/model/WaterfallChartOptions.h>
#include <aws/quicksight/model/WaterfallChartSortConfiguration.h>
#include <aws/quicksight/model/WaterfallVisual.h>
#include <aws/quicksight/model/WhatIfPointScenario.h>
#include <aws/quicksight/model/WhatIfRangeScenario.h>
#include <aws/quicksight/model/WidgetStatus.h>
#include <aws/quicksight/model/WordCloudAggregatedFieldWells.h>
#include <aws/quicksight/model/WordCloudChartConfiguration.h>
#include <aws/quicksight/model/WordCloudCloudLayout.h>
#include <aws/quicksight/model/WordCloudFieldWells.h>
#include <aws/quicksight/model/WordCloudOptions.h>
#include <aws/quicksight/model/WordCloudSortConfiguration.h>
#include <aws/quicksight/model/WordCloudVisual.h>
#include <aws/quicksight/model/WordCloudWordCasing.h>
#include <aws/quicksight/model/WordCloudWordOrientation.h>
#include <aws/quicksight/model/WordCloudWordPadding.h>
#include <aws/quicksight/model/WordCloudWordScaling.h>
#include <aws/quicksight/model/YAxisOptions.h>

using QuickSightIncludeTest = ::testing::Test;

TEST_F(QuickSightIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::QuickSight::QuickSightClient>("QuickSightIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
