/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/rds/RDSClient.h>
#include <aws/rds/RDSEndpointProvider.h>
#include <aws/rds/RDSEndpointRules.h>
#include <aws/rds/RDSErrorMarshaller.h>
#include <aws/rds/RDSErrors.h>
#include <aws/rds/RDSRequest.h>
#include <aws/rds/RDSServiceClientModel.h>
#include <aws/rds/RDS_EXPORTS.h>
#include <aws/rds/model/AccountQuota.h>
#include <aws/rds/model/ActivityStreamMode.h>
#include <aws/rds/model/ActivityStreamPolicyStatus.h>
#include <aws/rds/model/ActivityStreamStatus.h>
#include <aws/rds/model/AddRoleToDBClusterRequest.h>
#include <aws/rds/model/AddRoleToDBInstanceRequest.h>
#include <aws/rds/model/AddSourceIdentifierToSubscriptionRequest.h>
#include <aws/rds/model/AddSourceIdentifierToSubscriptionResult.h>
#include <aws/rds/model/AddTagsToResourceRequest.h>
#include <aws/rds/model/ApplyMethod.h>
#include <aws/rds/model/ApplyPendingMaintenanceActionRequest.h>
#include <aws/rds/model/ApplyPendingMaintenanceActionResult.h>
#include <aws/rds/model/AuditPolicyState.h>
#include <aws/rds/model/AuthScheme.h>
#include <aws/rds/model/AuthorizeDBSecurityGroupIngressRequest.h>
#include <aws/rds/model/AuthorizeDBSecurityGroupIngressResult.h>
#include <aws/rds/model/AutomationMode.h>
#include <aws/rds/model/AvailabilityZone.h>
#include <aws/rds/model/AvailableProcessorFeature.h>
#include <aws/rds/model/BacktrackDBClusterRequest.h>
#include <aws/rds/model/BacktrackDBClusterResult.h>
#include <aws/rds/model/BlueGreenDeployment.h>
#include <aws/rds/model/BlueGreenDeploymentTask.h>
#include <aws/rds/model/CancelExportTaskRequest.h>
#include <aws/rds/model/CancelExportTaskResult.h>
#include <aws/rds/model/Certificate.h>
#include <aws/rds/model/CertificateDetails.h>
#include <aws/rds/model/CharacterSet.h>
#include <aws/rds/model/ClientPasswordAuthType.h>
#include <aws/rds/model/CloudwatchLogsExportConfiguration.h>
#include <aws/rds/model/ClusterPendingModifiedValues.h>
#include <aws/rds/model/ClusterScalabilityType.h>
#include <aws/rds/model/ConnectionPoolConfiguration.h>
#include <aws/rds/model/ConnectionPoolConfigurationInfo.h>
#include <aws/rds/model/ContextAttribute.h>
#include <aws/rds/model/CopyDBClusterParameterGroupRequest.h>
#include <aws/rds/model/CopyDBClusterParameterGroupResult.h>
#include <aws/rds/model/CopyDBClusterSnapshotRequest.h>
#include <aws/rds/model/CopyDBClusterSnapshotResult.h>
#include <aws/rds/model/CopyDBParameterGroupRequest.h>
#include <aws/rds/model/CopyDBParameterGroupResult.h>
#include <aws/rds/model/CopyDBSnapshotRequest.h>
#include <aws/rds/model/CopyDBSnapshotResult.h>
#include <aws/rds/model/CopyOptionGroupRequest.h>
#include <aws/rds/model/CopyOptionGroupResult.h>
#include <aws/rds/model/CreateBlueGreenDeploymentRequest.h>
#include <aws/rds/model/CreateBlueGreenDeploymentResult.h>
#include <aws/rds/model/CreateCustomDBEngineVersionRequest.h>
#include <aws/rds/model/CreateCustomDBEngineVersionResult.h>
#include <aws/rds/model/CreateDBClusterEndpointRequest.h>
#include <aws/rds/model/CreateDBClusterEndpointResult.h>
#include <aws/rds/model/CreateDBClusterParameterGroupRequest.h>
#include <aws/rds/model/CreateDBClusterParameterGroupResult.h>
#include <aws/rds/model/CreateDBClusterRequest.h>
#include <aws/rds/model/CreateDBClusterResult.h>
#include <aws/rds/model/CreateDBClusterSnapshotRequest.h>
#include <aws/rds/model/CreateDBClusterSnapshotResult.h>
#include <aws/rds/model/CreateDBInstanceReadReplicaRequest.h>
#include <aws/rds/model/CreateDBInstanceReadReplicaResult.h>
#include <aws/rds/model/CreateDBInstanceRequest.h>
#include <aws/rds/model/CreateDBInstanceResult.h>
#include <aws/rds/model/CreateDBParameterGroupRequest.h>
#include <aws/rds/model/CreateDBParameterGroupResult.h>
#include <aws/rds/model/CreateDBProxyEndpointRequest.h>
#include <aws/rds/model/CreateDBProxyEndpointResult.h>
#include <aws/rds/model/CreateDBProxyRequest.h>
#include <aws/rds/model/CreateDBProxyResult.h>
#include <aws/rds/model/CreateDBSecurityGroupRequest.h>
#include <aws/rds/model/CreateDBSecurityGroupResult.h>
#include <aws/rds/model/CreateDBShardGroupRequest.h>
#include <aws/rds/model/CreateDBShardGroupResult.h>
#include <aws/rds/model/CreateDBSnapshotRequest.h>
#include <aws/rds/model/CreateDBSnapshotResult.h>
#include <aws/rds/model/CreateDBSubnetGroupRequest.h>
#include <aws/rds/model/CreateDBSubnetGroupResult.h>
#include <aws/rds/model/CreateEventSubscriptionRequest.h>
#include <aws/rds/model/CreateEventSubscriptionResult.h>
#include <aws/rds/model/CreateGlobalClusterRequest.h>
#include <aws/rds/model/CreateGlobalClusterResult.h>
#include <aws/rds/model/CreateIntegrationRequest.h>
#include <aws/rds/model/CreateIntegrationResult.h>
#include <aws/rds/model/CreateOptionGroupRequest.h>
#include <aws/rds/model/CreateOptionGroupResult.h>
#include <aws/rds/model/CreateTenantDatabaseRequest.h>
#include <aws/rds/model/CreateTenantDatabaseResult.h>
#include <aws/rds/model/CustomDBEngineVersionAMI.h>
#include <aws/rds/model/CustomEngineVersionStatus.h>
#include <aws/rds/model/DBCluster.h>
#include <aws/rds/model/DBClusterAutomatedBackup.h>
#include <aws/rds/model/DBClusterBacktrack.h>
#include <aws/rds/model/DBClusterEndpoint.h>
#include <aws/rds/model/DBClusterMember.h>
#include <aws/rds/model/DBClusterOptionGroupStatus.h>
#include <aws/rds/model/DBClusterParameterGroup.h>
#include <aws/rds/model/DBClusterRole.h>
#include <aws/rds/model/DBClusterSnapshot.h>
#include <aws/rds/model/DBClusterSnapshotAttribute.h>
#include <aws/rds/model/DBClusterSnapshotAttributesResult.h>
#include <aws/rds/model/DBClusterStatusInfo.h>
#include <aws/rds/model/DBEngineVersion.h>
#include <aws/rds/model/DBInstance.h>
#include <aws/rds/model/DBInstanceAutomatedBackup.h>
#include <aws/rds/model/DBInstanceAutomatedBackupsReplication.h>
#include <aws/rds/model/DBInstanceRole.h>
#include <aws/rds/model/DBInstanceStatusInfo.h>
#include <aws/rds/model/DBMajorEngineVersion.h>
#include <aws/rds/model/DBParameterGroup.h>
#include <aws/rds/model/DBParameterGroupStatus.h>
#include <aws/rds/model/DBProxy.h>
#include <aws/rds/model/DBProxyEndpoint.h>
#include <aws/rds/model/DBProxyEndpointStatus.h>
#include <aws/rds/model/DBProxyEndpointTargetRole.h>
#include <aws/rds/model/DBProxyStatus.h>
#include <aws/rds/model/DBProxyTarget.h>
#include <aws/rds/model/DBProxyTargetGroup.h>
#include <aws/rds/model/DBRecommendation.h>
#include <aws/rds/model/DBSecurityGroup.h>
#include <aws/rds/model/DBSecurityGroupMembership.h>
#include <aws/rds/model/DBShardGroup.h>
#include <aws/rds/model/DBSnapshot.h>
#include <aws/rds/model/DBSnapshotAttribute.h>
#include <aws/rds/model/DBSnapshotAttributesResult.h>
#include <aws/rds/model/DBSnapshotTenantDatabase.h>
#include <aws/rds/model/DBSubnetGroup.h>
#include <aws/rds/model/DatabaseInsightsMode.h>
#include <aws/rds/model/DeleteBlueGreenDeploymentRequest.h>
#include <aws/rds/model/DeleteBlueGreenDeploymentResult.h>
#include <aws/rds/model/DeleteCustomDBEngineVersionRequest.h>
#include <aws/rds/model/DeleteCustomDBEngineVersionResult.h>
#include <aws/rds/model/DeleteDBClusterAutomatedBackupRequest.h>
#include <aws/rds/model/DeleteDBClusterAutomatedBackupResult.h>
#include <aws/rds/model/DeleteDBClusterEndpointRequest.h>
#include <aws/rds/model/DeleteDBClusterEndpointResult.h>
#include <aws/rds/model/DeleteDBClusterParameterGroupRequest.h>
#include <aws/rds/model/DeleteDBClusterRequest.h>
#include <aws/rds/model/DeleteDBClusterResult.h>
#include <aws/rds/model/DeleteDBClusterSnapshotRequest.h>
#include <aws/rds/model/DeleteDBClusterSnapshotResult.h>
#include <aws/rds/model/DeleteDBInstanceAutomatedBackupRequest.h>
#include <aws/rds/model/DeleteDBInstanceAutomatedBackupResult.h>
#include <aws/rds/model/DeleteDBInstanceRequest.h>
#include <aws/rds/model/DeleteDBInstanceResult.h>
#include <aws/rds/model/DeleteDBParameterGroupRequest.h>
#include <aws/rds/model/DeleteDBProxyEndpointRequest.h>
#include <aws/rds/model/DeleteDBProxyEndpointResult.h>
#include <aws/rds/model/DeleteDBProxyRequest.h>
#include <aws/rds/model/DeleteDBProxyResult.h>
#include <aws/rds/model/DeleteDBSecurityGroupRequest.h>
#include <aws/rds/model/DeleteDBShardGroupRequest.h>
#include <aws/rds/model/DeleteDBShardGroupResult.h>
#include <aws/rds/model/DeleteDBSnapshotRequest.h>
#include <aws/rds/model/DeleteDBSnapshotResult.h>
#include <aws/rds/model/DeleteDBSubnetGroupRequest.h>
#include <aws/rds/model/DeleteEventSubscriptionRequest.h>
#include <aws/rds/model/DeleteEventSubscriptionResult.h>
#include <aws/rds/model/DeleteGlobalClusterRequest.h>
#include <aws/rds/model/DeleteGlobalClusterResult.h>
#include <aws/rds/model/DeleteIntegrationRequest.h>
#include <aws/rds/model/DeleteIntegrationResult.h>
#include <aws/rds/model/DeleteOptionGroupRequest.h>
#include <aws/rds/model/DeleteTenantDatabaseRequest.h>
#include <aws/rds/model/DeleteTenantDatabaseResult.h>
#include <aws/rds/model/DeregisterDBProxyTargetsRequest.h>
#include <aws/rds/model/DeregisterDBProxyTargetsResult.h>
#include <aws/rds/model/DescribeAccountAttributesRequest.h>
#include <aws/rds/model/DescribeAccountAttributesResult.h>
#include <aws/rds/model/DescribeBlueGreenDeploymentsRequest.h>
#include <aws/rds/model/DescribeBlueGreenDeploymentsResult.h>
#include <aws/rds/model/DescribeCertificatesRequest.h>
#include <aws/rds/model/DescribeCertificatesResult.h>
#include <aws/rds/model/DescribeDBClusterAutomatedBackupsRequest.h>
#include <aws/rds/model/DescribeDBClusterAutomatedBackupsResult.h>
#include <aws/rds/model/DescribeDBClusterBacktracksRequest.h>
#include <aws/rds/model/DescribeDBClusterBacktracksResult.h>
#include <aws/rds/model/DescribeDBClusterEndpointsRequest.h>
#include <aws/rds/model/DescribeDBClusterEndpointsResult.h>
#include <aws/rds/model/DescribeDBClusterParameterGroupsRequest.h>
#include <aws/rds/model/DescribeDBClusterParameterGroupsResult.h>
#include <aws/rds/model/DescribeDBClusterParametersRequest.h>
#include <aws/rds/model/DescribeDBClusterParametersResult.h>
#include <aws/rds/model/DescribeDBClusterSnapshotAttributesRequest.h>
#include <aws/rds/model/DescribeDBClusterSnapshotAttributesResult.h>
#include <aws/rds/model/DescribeDBClusterSnapshotsRequest.h>
#include <aws/rds/model/DescribeDBClusterSnapshotsResult.h>
#include <aws/rds/model/DescribeDBClustersRequest.h>
#include <aws/rds/model/DescribeDBClustersResult.h>
#include <aws/rds/model/DescribeDBEngineVersionsRequest.h>
#include <aws/rds/model/DescribeDBEngineVersionsResult.h>
#include <aws/rds/model/DescribeDBInstanceAutomatedBackupsRequest.h>
#include <aws/rds/model/DescribeDBInstanceAutomatedBackupsResult.h>
#include <aws/rds/model/DescribeDBInstancesRequest.h>
#include <aws/rds/model/DescribeDBInstancesResult.h>
#include <aws/rds/model/DescribeDBLogFilesDetails.h>
#include <aws/rds/model/DescribeDBLogFilesRequest.h>
#include <aws/rds/model/DescribeDBLogFilesResult.h>
#include <aws/rds/model/DescribeDBMajorEngineVersionsRequest.h>
#include <aws/rds/model/DescribeDBMajorEngineVersionsResult.h>
#include <aws/rds/model/DescribeDBParameterGroupsRequest.h>
#include <aws/rds/model/DescribeDBParameterGroupsResult.h>
#include <aws/rds/model/DescribeDBParametersRequest.h>
#include <aws/rds/model/DescribeDBParametersResult.h>
#include <aws/rds/model/DescribeDBProxiesRequest.h>
#include <aws/rds/model/DescribeDBProxiesResult.h>
#include <aws/rds/model/DescribeDBProxyEndpointsRequest.h>
#include <aws/rds/model/DescribeDBProxyEndpointsResult.h>
#include <aws/rds/model/DescribeDBProxyTargetGroupsRequest.h>
#include <aws/rds/model/DescribeDBProxyTargetGroupsResult.h>
#include <aws/rds/model/DescribeDBProxyTargetsRequest.h>
#include <aws/rds/model/DescribeDBProxyTargetsResult.h>
#include <aws/rds/model/DescribeDBRecommendationsRequest.h>
#include <aws/rds/model/DescribeDBRecommendationsResult.h>
#include <aws/rds/model/DescribeDBSecurityGroupsRequest.h>
#include <aws/rds/model/DescribeDBSecurityGroupsResult.h>
#include <aws/rds/model/DescribeDBShardGroupsRequest.h>
#include <aws/rds/model/DescribeDBShardGroupsResult.h>
#include <aws/rds/model/DescribeDBSnapshotAttributesRequest.h>
#include <aws/rds/model/DescribeDBSnapshotAttributesResult.h>
#include <aws/rds/model/DescribeDBSnapshotTenantDatabasesRequest.h>
#include <aws/rds/model/DescribeDBSnapshotTenantDatabasesResult.h>
#include <aws/rds/model/DescribeDBSnapshotsRequest.h>
#include <aws/rds/model/DescribeDBSnapshotsResult.h>
#include <aws/rds/model/DescribeDBSubnetGroupsRequest.h>
#include <aws/rds/model/DescribeDBSubnetGroupsResult.h>
#include <aws/rds/model/DescribeEngineDefaultClusterParametersRequest.h>
#include <aws/rds/model/DescribeEngineDefaultClusterParametersResult.h>
#include <aws/rds/model/DescribeEngineDefaultParametersRequest.h>
#include <aws/rds/model/DescribeEngineDefaultParametersResult.h>
#include <aws/rds/model/DescribeEventCategoriesRequest.h>
#include <aws/rds/model/DescribeEventCategoriesResult.h>
#include <aws/rds/model/DescribeEventSubscriptionsRequest.h>
#include <aws/rds/model/DescribeEventSubscriptionsResult.h>
#include <aws/rds/model/DescribeEventsRequest.h>
#include <aws/rds/model/DescribeEventsResult.h>
#include <aws/rds/model/DescribeExportTasksRequest.h>
#include <aws/rds/model/DescribeExportTasksResult.h>
#include <aws/rds/model/DescribeGlobalClustersRequest.h>
#include <aws/rds/model/DescribeGlobalClustersResult.h>
#include <aws/rds/model/DescribeIntegrationsRequest.h>
#include <aws/rds/model/DescribeIntegrationsResult.h>
#include <aws/rds/model/DescribeOptionGroupOptionsRequest.h>
#include <aws/rds/model/DescribeOptionGroupOptionsResult.h>
#include <aws/rds/model/DescribeOptionGroupsRequest.h>
#include <aws/rds/model/DescribeOptionGroupsResult.h>
#include <aws/rds/model/DescribeOrderableDBInstanceOptionsRequest.h>
#include <aws/rds/model/DescribeOrderableDBInstanceOptionsResult.h>
#include <aws/rds/model/DescribePendingMaintenanceActionsRequest.h>
#include <aws/rds/model/DescribePendingMaintenanceActionsResult.h>
#include <aws/rds/model/DescribeReservedDBInstancesOfferingsRequest.h>
#include <aws/rds/model/DescribeReservedDBInstancesOfferingsResult.h>
#include <aws/rds/model/DescribeReservedDBInstancesRequest.h>
#include <aws/rds/model/DescribeReservedDBInstancesResult.h>
#include <aws/rds/model/DescribeSourceRegionsRequest.h>
#include <aws/rds/model/DescribeSourceRegionsResult.h>
#include <aws/rds/model/DescribeTenantDatabasesRequest.h>
#include <aws/rds/model/DescribeTenantDatabasesResult.h>
#include <aws/rds/model/DescribeValidDBInstanceModificationsRequest.h>
#include <aws/rds/model/DescribeValidDBInstanceModificationsResult.h>
#include <aws/rds/model/DisableHttpEndpointRequest.h>
#include <aws/rds/model/DisableHttpEndpointResult.h>
#include <aws/rds/model/DocLink.h>
#include <aws/rds/model/DomainMembership.h>
#include <aws/rds/model/DoubleRange.h>
#include <aws/rds/model/DownloadDBLogFilePortionRequest.h>
#include <aws/rds/model/DownloadDBLogFilePortionResult.h>
#include <aws/rds/model/EC2SecurityGroup.h>
#include <aws/rds/model/EnableHttpEndpointRequest.h>
#include <aws/rds/model/EnableHttpEndpointResult.h>
#include <aws/rds/model/Endpoint.h>
#include <aws/rds/model/EngineDefaults.h>
#include <aws/rds/model/EngineFamily.h>
#include <aws/rds/model/Event.h>
#include <aws/rds/model/EventCategoriesMap.h>
#include <aws/rds/model/EventSubscription.h>
#include <aws/rds/model/ExportSourceType.h>
#include <aws/rds/model/ExportTask.h>
#include <aws/rds/model/FailoverDBClusterRequest.h>
#include <aws/rds/model/FailoverDBClusterResult.h>
#include <aws/rds/model/FailoverGlobalClusterRequest.h>
#include <aws/rds/model/FailoverGlobalClusterResult.h>
#include <aws/rds/model/FailoverState.h>
#include <aws/rds/model/FailoverStatus.h>
#include <aws/rds/model/Filter.h>
#include <aws/rds/model/GlobalCluster.h>
#include <aws/rds/model/GlobalClusterMember.h>
#include <aws/rds/model/GlobalClusterMemberSynchronizationStatus.h>
#include <aws/rds/model/IAMAuthMode.h>
#include <aws/rds/model/IPRange.h>
#include <aws/rds/model/Integration.h>
#include <aws/rds/model/IntegrationError.h>
#include <aws/rds/model/IntegrationStatus.h>
#include <aws/rds/model/IssueDetails.h>
#include <aws/rds/model/LifecycleSupportName.h>
#include <aws/rds/model/LimitlessDatabase.h>
#include <aws/rds/model/LimitlessDatabaseStatus.h>
#include <aws/rds/model/ListTagsForResourceRequest.h>
#include <aws/rds/model/ListTagsForResourceResult.h>
#include <aws/rds/model/LocalWriteForwardingStatus.h>
#include <aws/rds/model/MasterUserSecret.h>
#include <aws/rds/model/Metric.h>
#include <aws/rds/model/MetricQuery.h>
#include <aws/rds/model/MetricReference.h>
#include <aws/rds/model/MinimumEngineVersionPerAllowedValue.h>
#include <aws/rds/model/ModifyActivityStreamRequest.h>
#include <aws/rds/model/ModifyActivityStreamResult.h>
#include <aws/rds/model/ModifyCertificatesRequest.h>
#include <aws/rds/model/ModifyCertificatesResult.h>
#include <aws/rds/model/ModifyCurrentDBClusterCapacityRequest.h>
#include <aws/rds/model/ModifyCurrentDBClusterCapacityResult.h>
#include <aws/rds/model/ModifyCustomDBEngineVersionRequest.h>
#include <aws/rds/model/ModifyCustomDBEngineVersionResult.h>
#include <aws/rds/model/ModifyDBClusterEndpointRequest.h>
#include <aws/rds/model/ModifyDBClusterEndpointResult.h>
#include <aws/rds/model/ModifyDBClusterParameterGroupRequest.h>
#include <aws/rds/model/ModifyDBClusterParameterGroupResult.h>
#include <aws/rds/model/ModifyDBClusterRequest.h>
#include <aws/rds/model/ModifyDBClusterResult.h>
#include <aws/rds/model/ModifyDBClusterSnapshotAttributeRequest.h>
#include <aws/rds/model/ModifyDBClusterSnapshotAttributeResult.h>
#include <aws/rds/model/ModifyDBInstanceRequest.h>
#include <aws/rds/model/ModifyDBInstanceResult.h>
#include <aws/rds/model/ModifyDBParameterGroupRequest.h>
#include <aws/rds/model/ModifyDBParameterGroupResult.h>
#include <aws/rds/model/ModifyDBProxyEndpointRequest.h>
#include <aws/rds/model/ModifyDBProxyEndpointResult.h>
#include <aws/rds/model/ModifyDBProxyRequest.h>
#include <aws/rds/model/ModifyDBProxyResult.h>
#include <aws/rds/model/ModifyDBProxyTargetGroupRequest.h>
#include <aws/rds/model/ModifyDBProxyTargetGroupResult.h>
#include <aws/rds/model/ModifyDBRecommendationRequest.h>
#include <aws/rds/model/ModifyDBRecommendationResult.h>
#include <aws/rds/model/ModifyDBShardGroupRequest.h>
#include <aws/rds/model/ModifyDBShardGroupResult.h>
#include <aws/rds/model/ModifyDBSnapshotAttributeRequest.h>
#include <aws/rds/model/ModifyDBSnapshotAttributeResult.h>
#include <aws/rds/model/ModifyDBSnapshotRequest.h>
#include <aws/rds/model/ModifyDBSnapshotResult.h>
#include <aws/rds/model/ModifyDBSubnetGroupRequest.h>
#include <aws/rds/model/ModifyDBSubnetGroupResult.h>
#include <aws/rds/model/ModifyEventSubscriptionRequest.h>
#include <aws/rds/model/ModifyEventSubscriptionResult.h>
#include <aws/rds/model/ModifyGlobalClusterRequest.h>
#include <aws/rds/model/ModifyGlobalClusterResult.h>
#include <aws/rds/model/ModifyIntegrationRequest.h>
#include <aws/rds/model/ModifyIntegrationResult.h>
#include <aws/rds/model/ModifyOptionGroupRequest.h>
#include <aws/rds/model/ModifyOptionGroupResult.h>
#include <aws/rds/model/ModifyTenantDatabaseRequest.h>
#include <aws/rds/model/ModifyTenantDatabaseResult.h>
#include <aws/rds/model/Option.h>
#include <aws/rds/model/OptionConfiguration.h>
#include <aws/rds/model/OptionGroup.h>
#include <aws/rds/model/OptionGroupMembership.h>
#include <aws/rds/model/OptionGroupOption.h>
#include <aws/rds/model/OptionGroupOptionSetting.h>
#include <aws/rds/model/OptionSetting.h>
#include <aws/rds/model/OptionVersion.h>
#include <aws/rds/model/OrderableDBInstanceOption.h>
#include <aws/rds/model/Outpost.h>
#include <aws/rds/model/Parameter.h>
#include <aws/rds/model/PendingCloudwatchLogsExports.h>
#include <aws/rds/model/PendingMaintenanceAction.h>
#include <aws/rds/model/PendingModifiedValues.h>
#include <aws/rds/model/PerformanceInsightsMetricDimensionGroup.h>
#include <aws/rds/model/PerformanceInsightsMetricQuery.h>
#include <aws/rds/model/PerformanceIssueDetails.h>
#include <aws/rds/model/ProcessorFeature.h>
#include <aws/rds/model/PromoteReadReplicaDBClusterRequest.h>
#include <aws/rds/model/PromoteReadReplicaDBClusterResult.h>
#include <aws/rds/model/PromoteReadReplicaRequest.h>
#include <aws/rds/model/PromoteReadReplicaResult.h>
#include <aws/rds/model/PurchaseReservedDBInstancesOfferingRequest.h>
#include <aws/rds/model/PurchaseReservedDBInstancesOfferingResult.h>
#include <aws/rds/model/Range.h>
#include <aws/rds/model/RdsCustomClusterConfiguration.h>
#include <aws/rds/model/RebootDBClusterRequest.h>
#include <aws/rds/model/RebootDBClusterResult.h>
#include <aws/rds/model/RebootDBInstanceRequest.h>
#include <aws/rds/model/RebootDBInstanceResult.h>
#include <aws/rds/model/RebootDBShardGroupRequest.h>
#include <aws/rds/model/RebootDBShardGroupResult.h>
#include <aws/rds/model/RecommendedAction.h>
#include <aws/rds/model/RecommendedActionParameter.h>
#include <aws/rds/model/RecommendedActionUpdate.h>
#include <aws/rds/model/RecurringCharge.h>
#include <aws/rds/model/ReferenceDetails.h>
#include <aws/rds/model/RegisterDBProxyTargetsRequest.h>
#include <aws/rds/model/RegisterDBProxyTargetsResult.h>
#include <aws/rds/model/RemoveFromGlobalClusterRequest.h>
#include <aws/rds/model/RemoveFromGlobalClusterResult.h>
#include <aws/rds/model/RemoveRoleFromDBClusterRequest.h>
#include <aws/rds/model/RemoveRoleFromDBInstanceRequest.h>
#include <aws/rds/model/RemoveSourceIdentifierFromSubscriptionRequest.h>
#include <aws/rds/model/RemoveSourceIdentifierFromSubscriptionResult.h>
#include <aws/rds/model/RemoveTagsFromResourceRequest.h>
#include <aws/rds/model/ReplicaMode.h>
#include <aws/rds/model/ReservedDBInstance.h>
#include <aws/rds/model/ReservedDBInstancesOffering.h>
#include <aws/rds/model/ResetDBClusterParameterGroupRequest.h>
#include <aws/rds/model/ResetDBClusterParameterGroupResult.h>
#include <aws/rds/model/ResetDBParameterGroupRequest.h>
#include <aws/rds/model/ResetDBParameterGroupResult.h>
#include <aws/rds/model/ResourcePendingMaintenanceActions.h>
#include <aws/rds/model/ResponseMetadata.h>
#include <aws/rds/model/RestoreDBClusterFromS3Request.h>
#include <aws/rds/model/RestoreDBClusterFromS3Result.h>
#include <aws/rds/model/RestoreDBClusterFromSnapshotRequest.h>
#include <aws/rds/model/RestoreDBClusterFromSnapshotResult.h>
#include <aws/rds/model/RestoreDBClusterToPointInTimeRequest.h>
#include <aws/rds/model/RestoreDBClusterToPointInTimeResult.h>
#include <aws/rds/model/RestoreDBInstanceFromDBSnapshotRequest.h>
#include <aws/rds/model/RestoreDBInstanceFromDBSnapshotResult.h>
#include <aws/rds/model/RestoreDBInstanceFromS3Request.h>
#include <aws/rds/model/RestoreDBInstanceFromS3Result.h>
#include <aws/rds/model/RestoreDBInstanceToPointInTimeRequest.h>
#include <aws/rds/model/RestoreDBInstanceToPointInTimeResult.h>
#include <aws/rds/model/RestoreWindow.h>
#include <aws/rds/model/RevokeDBSecurityGroupIngressRequest.h>
#include <aws/rds/model/RevokeDBSecurityGroupIngressResult.h>
#include <aws/rds/model/ScalarReferenceDetails.h>
#include <aws/rds/model/ScalingConfiguration.h>
#include <aws/rds/model/ScalingConfigurationInfo.h>
#include <aws/rds/model/ServerlessV2FeaturesSupport.h>
#include <aws/rds/model/ServerlessV2ScalingConfiguration.h>
#include <aws/rds/model/ServerlessV2ScalingConfigurationInfo.h>
#include <aws/rds/model/SourceRegion.h>
#include <aws/rds/model/SourceType.h>
#include <aws/rds/model/StartActivityStreamRequest.h>
#include <aws/rds/model/StartActivityStreamResult.h>
#include <aws/rds/model/StartDBClusterRequest.h>
#include <aws/rds/model/StartDBClusterResult.h>
#include <aws/rds/model/StartDBInstanceAutomatedBackupsReplicationRequest.h>
#include <aws/rds/model/StartDBInstanceAutomatedBackupsReplicationResult.h>
#include <aws/rds/model/StartDBInstanceRequest.h>
#include <aws/rds/model/StartDBInstanceResult.h>
#include <aws/rds/model/StartExportTaskRequest.h>
#include <aws/rds/model/StartExportTaskResult.h>
#include <aws/rds/model/StopActivityStreamRequest.h>
#include <aws/rds/model/StopActivityStreamResult.h>
#include <aws/rds/model/StopDBClusterRequest.h>
#include <aws/rds/model/StopDBClusterResult.h>
#include <aws/rds/model/StopDBInstanceAutomatedBackupsReplicationRequest.h>
#include <aws/rds/model/StopDBInstanceAutomatedBackupsReplicationResult.h>
#include <aws/rds/model/StopDBInstanceRequest.h>
#include <aws/rds/model/StopDBInstanceResult.h>
#include <aws/rds/model/Subnet.h>
#include <aws/rds/model/SupportedEngineLifecycle.h>
#include <aws/rds/model/SwitchoverBlueGreenDeploymentRequest.h>
#include <aws/rds/model/SwitchoverBlueGreenDeploymentResult.h>
#include <aws/rds/model/SwitchoverDetail.h>
#include <aws/rds/model/SwitchoverGlobalClusterRequest.h>
#include <aws/rds/model/SwitchoverGlobalClusterResult.h>
#include <aws/rds/model/SwitchoverReadReplicaRequest.h>
#include <aws/rds/model/SwitchoverReadReplicaResult.h>
#include <aws/rds/model/Tag.h>
#include <aws/rds/model/TargetHealth.h>
#include <aws/rds/model/TargetHealthReason.h>
#include <aws/rds/model/TargetRole.h>
#include <aws/rds/model/TargetState.h>
#include <aws/rds/model/TargetType.h>
#include <aws/rds/model/TenantDatabase.h>
#include <aws/rds/model/TenantDatabasePendingModifiedValues.h>
#include <aws/rds/model/Timezone.h>
#include <aws/rds/model/UpgradeTarget.h>
#include <aws/rds/model/UserAuthConfig.h>
#include <aws/rds/model/UserAuthConfigInfo.h>
#include <aws/rds/model/ValidDBInstanceModificationsMessage.h>
#include <aws/rds/model/ValidStorageOptions.h>
#include <aws/rds/model/VpcSecurityGroupMembership.h>
#include <aws/rds/model/WriteForwardingStatus.h>

using RDSIncludeTest = ::testing::Test;

TEST_F(RDSIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::RDS::RDSClient>("RDSIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
