/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/redshift-serverless/RedshiftServerlessClient.h>
#include <aws/redshift-serverless/RedshiftServerlessEndpointProvider.h>
#include <aws/redshift-serverless/RedshiftServerlessEndpointRules.h>
#include <aws/redshift-serverless/RedshiftServerlessErrorMarshaller.h>
#include <aws/redshift-serverless/RedshiftServerlessErrors.h>
#include <aws/redshift-serverless/RedshiftServerlessRequest.h>
#include <aws/redshift-serverless/RedshiftServerlessServiceClientModel.h>
#include <aws/redshift-serverless/RedshiftServerless_EXPORTS.h>
#include <aws/redshift-serverless/model/AccessDeniedException.h>
#include <aws/redshift-serverless/model/Association.h>
#include <aws/redshift-serverless/model/ConfigParameter.h>
#include <aws/redshift-serverless/model/ConvertRecoveryPointToSnapshotRequest.h>
#include <aws/redshift-serverless/model/ConvertRecoveryPointToSnapshotResult.h>
#include <aws/redshift-serverless/model/CreateCustomDomainAssociationRequest.h>
#include <aws/redshift-serverless/model/CreateCustomDomainAssociationResult.h>
#include <aws/redshift-serverless/model/CreateEndpointAccessRequest.h>
#include <aws/redshift-serverless/model/CreateEndpointAccessResult.h>
#include <aws/redshift-serverless/model/CreateNamespaceRequest.h>
#include <aws/redshift-serverless/model/CreateNamespaceResult.h>
#include <aws/redshift-serverless/model/CreateReservationRequest.h>
#include <aws/redshift-serverless/model/CreateReservationResult.h>
#include <aws/redshift-serverless/model/CreateScheduledActionRequest.h>
#include <aws/redshift-serverless/model/CreateScheduledActionResult.h>
#include <aws/redshift-serverless/model/CreateSnapshotCopyConfigurationRequest.h>
#include <aws/redshift-serverless/model/CreateSnapshotCopyConfigurationResult.h>
#include <aws/redshift-serverless/model/CreateSnapshotRequest.h>
#include <aws/redshift-serverless/model/CreateSnapshotResult.h>
#include <aws/redshift-serverless/model/CreateSnapshotScheduleActionParameters.h>
#include <aws/redshift-serverless/model/CreateUsageLimitRequest.h>
#include <aws/redshift-serverless/model/CreateUsageLimitResult.h>
#include <aws/redshift-serverless/model/CreateWorkgroupRequest.h>
#include <aws/redshift-serverless/model/CreateWorkgroupResult.h>
#include <aws/redshift-serverless/model/DeleteCustomDomainAssociationRequest.h>
#include <aws/redshift-serverless/model/DeleteCustomDomainAssociationResult.h>
#include <aws/redshift-serverless/model/DeleteEndpointAccessRequest.h>
#include <aws/redshift-serverless/model/DeleteEndpointAccessResult.h>
#include <aws/redshift-serverless/model/DeleteNamespaceRequest.h>
#include <aws/redshift-serverless/model/DeleteNamespaceResult.h>
#include <aws/redshift-serverless/model/DeleteResourcePolicyRequest.h>
#include <aws/redshift-serverless/model/DeleteResourcePolicyResult.h>
#include <aws/redshift-serverless/model/DeleteScheduledActionRequest.h>
#include <aws/redshift-serverless/model/DeleteScheduledActionResult.h>
#include <aws/redshift-serverless/model/DeleteSnapshotCopyConfigurationRequest.h>
#include <aws/redshift-serverless/model/DeleteSnapshotCopyConfigurationResult.h>
#include <aws/redshift-serverless/model/DeleteSnapshotRequest.h>
#include <aws/redshift-serverless/model/DeleteSnapshotResult.h>
#include <aws/redshift-serverless/model/DeleteUsageLimitRequest.h>
#include <aws/redshift-serverless/model/DeleteUsageLimitResult.h>
#include <aws/redshift-serverless/model/DeleteWorkgroupRequest.h>
#include <aws/redshift-serverless/model/DeleteWorkgroupResult.h>
#include <aws/redshift-serverless/model/Endpoint.h>
#include <aws/redshift-serverless/model/EndpointAccess.h>
#include <aws/redshift-serverless/model/GetCredentialsRequest.h>
#include <aws/redshift-serverless/model/GetCredentialsResult.h>
#include <aws/redshift-serverless/model/GetCustomDomainAssociationRequest.h>
#include <aws/redshift-serverless/model/GetCustomDomainAssociationResult.h>
#include <aws/redshift-serverless/model/GetEndpointAccessRequest.h>
#include <aws/redshift-serverless/model/GetEndpointAccessResult.h>
#include <aws/redshift-serverless/model/GetNamespaceRequest.h>
#include <aws/redshift-serverless/model/GetNamespaceResult.h>
#include <aws/redshift-serverless/model/GetRecoveryPointRequest.h>
#include <aws/redshift-serverless/model/GetRecoveryPointResult.h>
#include <aws/redshift-serverless/model/GetReservationOfferingRequest.h>
#include <aws/redshift-serverless/model/GetReservationOfferingResult.h>
#include <aws/redshift-serverless/model/GetReservationRequest.h>
#include <aws/redshift-serverless/model/GetReservationResult.h>
#include <aws/redshift-serverless/model/GetResourcePolicyRequest.h>
#include <aws/redshift-serverless/model/GetResourcePolicyResult.h>
#include <aws/redshift-serverless/model/GetScheduledActionRequest.h>
#include <aws/redshift-serverless/model/GetScheduledActionResult.h>
#include <aws/redshift-serverless/model/GetSnapshotRequest.h>
#include <aws/redshift-serverless/model/GetSnapshotResult.h>
#include <aws/redshift-serverless/model/GetTableRestoreStatusRequest.h>
#include <aws/redshift-serverless/model/GetTableRestoreStatusResult.h>
#include <aws/redshift-serverless/model/GetTrackRequest.h>
#include <aws/redshift-serverless/model/GetTrackResult.h>
#include <aws/redshift-serverless/model/GetUsageLimitRequest.h>
#include <aws/redshift-serverless/model/GetUsageLimitResult.h>
#include <aws/redshift-serverless/model/GetWorkgroupRequest.h>
#include <aws/redshift-serverless/model/GetWorkgroupResult.h>
#include <aws/redshift-serverless/model/ListCustomDomainAssociationsRequest.h>
#include <aws/redshift-serverless/model/ListCustomDomainAssociationsResult.h>
#include <aws/redshift-serverless/model/ListEndpointAccessRequest.h>
#include <aws/redshift-serverless/model/ListEndpointAccessResult.h>
#include <aws/redshift-serverless/model/ListManagedWorkgroupsRequest.h>
#include <aws/redshift-serverless/model/ListManagedWorkgroupsResult.h>
#include <aws/redshift-serverless/model/ListNamespacesRequest.h>
#include <aws/redshift-serverless/model/ListNamespacesResult.h>
#include <aws/redshift-serverless/model/ListRecoveryPointsRequest.h>
#include <aws/redshift-serverless/model/ListRecoveryPointsResult.h>
#include <aws/redshift-serverless/model/ListReservationOfferingsRequest.h>
#include <aws/redshift-serverless/model/ListReservationOfferingsResult.h>
#include <aws/redshift-serverless/model/ListReservationsRequest.h>
#include <aws/redshift-serverless/model/ListReservationsResult.h>
#include <aws/redshift-serverless/model/ListScheduledActionsRequest.h>
#include <aws/redshift-serverless/model/ListScheduledActionsResult.h>
#include <aws/redshift-serverless/model/ListSnapshotCopyConfigurationsRequest.h>
#include <aws/redshift-serverless/model/ListSnapshotCopyConfigurationsResult.h>
#include <aws/redshift-serverless/model/ListSnapshotsRequest.h>
#include <aws/redshift-serverless/model/ListSnapshotsResult.h>
#include <aws/redshift-serverless/model/ListTableRestoreStatusRequest.h>
#include <aws/redshift-serverless/model/ListTableRestoreStatusResult.h>
#include <aws/redshift-serverless/model/ListTagsForResourceRequest.h>
#include <aws/redshift-serverless/model/ListTagsForResourceResult.h>
#include <aws/redshift-serverless/model/ListTracksRequest.h>
#include <aws/redshift-serverless/model/ListTracksResult.h>
#include <aws/redshift-serverless/model/ListUsageLimitsRequest.h>
#include <aws/redshift-serverless/model/ListUsageLimitsResult.h>
#include <aws/redshift-serverless/model/ListWorkgroupsRequest.h>
#include <aws/redshift-serverless/model/ListWorkgroupsResult.h>
#include <aws/redshift-serverless/model/LogExport.h>
#include <aws/redshift-serverless/model/ManagedWorkgroupListItem.h>
#include <aws/redshift-serverless/model/ManagedWorkgroupStatus.h>
#include <aws/redshift-serverless/model/Namespace.h>
#include <aws/redshift-serverless/model/NamespaceStatus.h>
#include <aws/redshift-serverless/model/NetworkInterface.h>
#include <aws/redshift-serverless/model/OfferingType.h>
#include <aws/redshift-serverless/model/PerformanceTarget.h>
#include <aws/redshift-serverless/model/PerformanceTargetStatus.h>
#include <aws/redshift-serverless/model/PutResourcePolicyRequest.h>
#include <aws/redshift-serverless/model/PutResourcePolicyResult.h>
#include <aws/redshift-serverless/model/RecoveryPoint.h>
#include <aws/redshift-serverless/model/Reservation.h>
#include <aws/redshift-serverless/model/ReservationOffering.h>
#include <aws/redshift-serverless/model/ResourceNotFoundException.h>
#include <aws/redshift-serverless/model/ResourcePolicy.h>
#include <aws/redshift-serverless/model/RestoreFromRecoveryPointRequest.h>
#include <aws/redshift-serverless/model/RestoreFromRecoveryPointResult.h>
#include <aws/redshift-serverless/model/RestoreFromSnapshotRequest.h>
#include <aws/redshift-serverless/model/RestoreFromSnapshotResult.h>
#include <aws/redshift-serverless/model/RestoreTableFromRecoveryPointRequest.h>
#include <aws/redshift-serverless/model/RestoreTableFromRecoveryPointResult.h>
#include <aws/redshift-serverless/model/RestoreTableFromSnapshotRequest.h>
#include <aws/redshift-serverless/model/RestoreTableFromSnapshotResult.h>
#include <aws/redshift-serverless/model/Schedule.h>
#include <aws/redshift-serverless/model/ScheduledActionAssociation.h>
#include <aws/redshift-serverless/model/ScheduledActionResponse.h>
#include <aws/redshift-serverless/model/ServerlessTrack.h>
#include <aws/redshift-serverless/model/Snapshot.h>
#include <aws/redshift-serverless/model/SnapshotCopyConfiguration.h>
#include <aws/redshift-serverless/model/SnapshotStatus.h>
#include <aws/redshift-serverless/model/State.h>
#include <aws/redshift-serverless/model/TableRestoreStatus.h>
#include <aws/redshift-serverless/model/Tag.h>
#include <aws/redshift-serverless/model/TagResourceRequest.h>
#include <aws/redshift-serverless/model/TagResourceResult.h>
#include <aws/redshift-serverless/model/TargetAction.h>
#include <aws/redshift-serverless/model/ThrottlingException.h>
#include <aws/redshift-serverless/model/TooManyTagsException.h>
#include <aws/redshift-serverless/model/UntagResourceRequest.h>
#include <aws/redshift-serverless/model/UntagResourceResult.h>
#include <aws/redshift-serverless/model/UpdateCustomDomainAssociationRequest.h>
#include <aws/redshift-serverless/model/UpdateCustomDomainAssociationResult.h>
#include <aws/redshift-serverless/model/UpdateEndpointAccessRequest.h>
#include <aws/redshift-serverless/model/UpdateEndpointAccessResult.h>
#include <aws/redshift-serverless/model/UpdateNamespaceRequest.h>
#include <aws/redshift-serverless/model/UpdateNamespaceResult.h>
#include <aws/redshift-serverless/model/UpdateScheduledActionRequest.h>
#include <aws/redshift-serverless/model/UpdateScheduledActionResult.h>
#include <aws/redshift-serverless/model/UpdateSnapshotCopyConfigurationRequest.h>
#include <aws/redshift-serverless/model/UpdateSnapshotCopyConfigurationResult.h>
#include <aws/redshift-serverless/model/UpdateSnapshotRequest.h>
#include <aws/redshift-serverless/model/UpdateSnapshotResult.h>
#include <aws/redshift-serverless/model/UpdateTarget.h>
#include <aws/redshift-serverless/model/UpdateUsageLimitRequest.h>
#include <aws/redshift-serverless/model/UpdateUsageLimitResult.h>
#include <aws/redshift-serverless/model/UpdateWorkgroupRequest.h>
#include <aws/redshift-serverless/model/UpdateWorkgroupResult.h>
#include <aws/redshift-serverless/model/UsageLimit.h>
#include <aws/redshift-serverless/model/UsageLimitBreachAction.h>
#include <aws/redshift-serverless/model/UsageLimitPeriod.h>
#include <aws/redshift-serverless/model/UsageLimitUsageType.h>
#include <aws/redshift-serverless/model/VpcEndpoint.h>
#include <aws/redshift-serverless/model/VpcSecurityGroupMembership.h>
#include <aws/redshift-serverless/model/Workgroup.h>
#include <aws/redshift-serverless/model/WorkgroupStatus.h>

using RedshiftServerlessIncludeTest = ::testing::Test;

TEST_F(RedshiftServerlessIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::RedshiftServerless::RedshiftServerlessClient>("RedshiftServerlessIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
