/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/rekognition/RekognitionClient.h>
#include <aws/rekognition/RekognitionEndpointProvider.h>
#include <aws/rekognition/RekognitionEndpointRules.h>
#include <aws/rekognition/RekognitionErrorMarshaller.h>
#include <aws/rekognition/RekognitionErrors.h>
#include <aws/rekognition/RekognitionRequest.h>
#include <aws/rekognition/RekognitionServiceClientModel.h>
#include <aws/rekognition/Rekognition_EXPORTS.h>
#include <aws/rekognition/model/AgeRange.h>
#include <aws/rekognition/model/Asset.h>
#include <aws/rekognition/model/AssociateFacesRequest.h>
#include <aws/rekognition/model/AssociateFacesResult.h>
#include <aws/rekognition/model/AssociatedFace.h>
#include <aws/rekognition/model/Attribute.h>
#include <aws/rekognition/model/AudioMetadata.h>
#include <aws/rekognition/model/AuditImage.h>
#include <aws/rekognition/model/Beard.h>
#include <aws/rekognition/model/BlackFrame.h>
#include <aws/rekognition/model/BodyPart.h>
#include <aws/rekognition/model/BoundingBox.h>
#include <aws/rekognition/model/Celebrity.h>
#include <aws/rekognition/model/CelebrityDetail.h>
#include <aws/rekognition/model/CelebrityRecognition.h>
#include <aws/rekognition/model/CelebrityRecognitionSortBy.h>
#include <aws/rekognition/model/Challenge.h>
#include <aws/rekognition/model/ChallengePreference.h>
#include <aws/rekognition/model/ChallengeType.h>
#include <aws/rekognition/model/CompareFacesMatch.h>
#include <aws/rekognition/model/CompareFacesRequest.h>
#include <aws/rekognition/model/CompareFacesResult.h>
#include <aws/rekognition/model/ComparedFace.h>
#include <aws/rekognition/model/ComparedSourceImageFace.h>
#include <aws/rekognition/model/ConnectedHomeSettings.h>
#include <aws/rekognition/model/ConnectedHomeSettingsForUpdate.h>
#include <aws/rekognition/model/ContentClassifier.h>
#include <aws/rekognition/model/ContentModerationAggregateBy.h>
#include <aws/rekognition/model/ContentModerationDetection.h>
#include <aws/rekognition/model/ContentModerationSortBy.h>
#include <aws/rekognition/model/ContentType.h>
#include <aws/rekognition/model/CopyProjectVersionRequest.h>
#include <aws/rekognition/model/CopyProjectVersionResult.h>
#include <aws/rekognition/model/CoversBodyPart.h>
#include <aws/rekognition/model/CreateCollectionRequest.h>
#include <aws/rekognition/model/CreateCollectionResult.h>
#include <aws/rekognition/model/CreateDatasetRequest.h>
#include <aws/rekognition/model/CreateDatasetResult.h>
#include <aws/rekognition/model/CreateFaceLivenessSessionRequest.h>
#include <aws/rekognition/model/CreateFaceLivenessSessionRequestSettings.h>
#include <aws/rekognition/model/CreateFaceLivenessSessionResult.h>
#include <aws/rekognition/model/CreateProjectRequest.h>
#include <aws/rekognition/model/CreateProjectResult.h>
#include <aws/rekognition/model/CreateProjectVersionRequest.h>
#include <aws/rekognition/model/CreateProjectVersionResult.h>
#include <aws/rekognition/model/CreateStreamProcessorRequest.h>
#include <aws/rekognition/model/CreateStreamProcessorResult.h>
#include <aws/rekognition/model/CreateUserRequest.h>
#include <aws/rekognition/model/CreateUserResult.h>
#include <aws/rekognition/model/CustomLabel.h>
#include <aws/rekognition/model/CustomizationFeature.h>
#include <aws/rekognition/model/CustomizationFeatureConfig.h>
#include <aws/rekognition/model/CustomizationFeatureContentModerationConfig.h>
#include <aws/rekognition/model/DatasetChanges.h>
#include <aws/rekognition/model/DatasetDescription.h>
#include <aws/rekognition/model/DatasetLabelDescription.h>
#include <aws/rekognition/model/DatasetLabelStats.h>
#include <aws/rekognition/model/DatasetMetadata.h>
#include <aws/rekognition/model/DatasetSource.h>
#include <aws/rekognition/model/DatasetStats.h>
#include <aws/rekognition/model/DatasetStatus.h>
#include <aws/rekognition/model/DatasetStatusMessageCode.h>
#include <aws/rekognition/model/DatasetType.h>
#include <aws/rekognition/model/DeleteCollectionRequest.h>
#include <aws/rekognition/model/DeleteCollectionResult.h>
#include <aws/rekognition/model/DeleteDatasetRequest.h>
#include <aws/rekognition/model/DeleteDatasetResult.h>
#include <aws/rekognition/model/DeleteFacesRequest.h>
#include <aws/rekognition/model/DeleteFacesResult.h>
#include <aws/rekognition/model/DeleteProjectPolicyRequest.h>
#include <aws/rekognition/model/DeleteProjectPolicyResult.h>
#include <aws/rekognition/model/DeleteProjectRequest.h>
#include <aws/rekognition/model/DeleteProjectResult.h>
#include <aws/rekognition/model/DeleteProjectVersionRequest.h>
#include <aws/rekognition/model/DeleteProjectVersionResult.h>
#include <aws/rekognition/model/DeleteStreamProcessorRequest.h>
#include <aws/rekognition/model/DeleteStreamProcessorResult.h>
#include <aws/rekognition/model/DeleteUserRequest.h>
#include <aws/rekognition/model/DeleteUserResult.h>
#include <aws/rekognition/model/DescribeCollectionRequest.h>
#include <aws/rekognition/model/DescribeCollectionResult.h>
#include <aws/rekognition/model/DescribeDatasetRequest.h>
#include <aws/rekognition/model/DescribeDatasetResult.h>
#include <aws/rekognition/model/DescribeProjectVersionsRequest.h>
#include <aws/rekognition/model/DescribeProjectVersionsResult.h>
#include <aws/rekognition/model/DescribeProjectsRequest.h>
#include <aws/rekognition/model/DescribeProjectsResult.h>
#include <aws/rekognition/model/DescribeStreamProcessorRequest.h>
#include <aws/rekognition/model/DescribeStreamProcessorResult.h>
#include <aws/rekognition/model/DetectCustomLabelsRequest.h>
#include <aws/rekognition/model/DetectCustomLabelsResult.h>
#include <aws/rekognition/model/DetectFacesRequest.h>
#include <aws/rekognition/model/DetectFacesResult.h>
#include <aws/rekognition/model/DetectLabelsFeatureName.h>
#include <aws/rekognition/model/DetectLabelsImageBackground.h>
#include <aws/rekognition/model/DetectLabelsImageForeground.h>
#include <aws/rekognition/model/DetectLabelsImageProperties.h>
#include <aws/rekognition/model/DetectLabelsImagePropertiesSettings.h>
#include <aws/rekognition/model/DetectLabelsImageQuality.h>
#include <aws/rekognition/model/DetectLabelsRequest.h>
#include <aws/rekognition/model/DetectLabelsResult.h>
#include <aws/rekognition/model/DetectLabelsSettings.h>
#include <aws/rekognition/model/DetectModerationLabelsRequest.h>
#include <aws/rekognition/model/DetectModerationLabelsResult.h>
#include <aws/rekognition/model/DetectProtectiveEquipmentRequest.h>
#include <aws/rekognition/model/DetectProtectiveEquipmentResult.h>
#include <aws/rekognition/model/DetectTextFilters.h>
#include <aws/rekognition/model/DetectTextRequest.h>
#include <aws/rekognition/model/DetectTextResult.h>
#include <aws/rekognition/model/DetectionFilter.h>
#include <aws/rekognition/model/DisassociateFacesRequest.h>
#include <aws/rekognition/model/DisassociateFacesResult.h>
#include <aws/rekognition/model/DisassociatedFace.h>
#include <aws/rekognition/model/DistributeDataset.h>
#include <aws/rekognition/model/DistributeDatasetEntriesRequest.h>
#include <aws/rekognition/model/DistributeDatasetEntriesResult.h>
#include <aws/rekognition/model/DominantColor.h>
#include <aws/rekognition/model/Emotion.h>
#include <aws/rekognition/model/EmotionName.h>
#include <aws/rekognition/model/EquipmentDetection.h>
#include <aws/rekognition/model/EvaluationResult.h>
#include <aws/rekognition/model/EyeDirection.h>
#include <aws/rekognition/model/EyeOpen.h>
#include <aws/rekognition/model/Eyeglasses.h>
#include <aws/rekognition/model/Face.h>
#include <aws/rekognition/model/FaceAttributes.h>
#include <aws/rekognition/model/FaceDetail.h>
#include <aws/rekognition/model/FaceDetection.h>
#include <aws/rekognition/model/FaceMatch.h>
#include <aws/rekognition/model/FaceOccluded.h>
#include <aws/rekognition/model/FaceRecord.h>
#include <aws/rekognition/model/FaceSearchSettings.h>
#include <aws/rekognition/model/FaceSearchSortBy.h>
#include <aws/rekognition/model/Gender.h>
#include <aws/rekognition/model/GenderType.h>
#include <aws/rekognition/model/GeneralLabelsSettings.h>
#include <aws/rekognition/model/Geometry.h>
#include <aws/rekognition/model/GetCelebrityInfoRequest.h>
#include <aws/rekognition/model/GetCelebrityInfoResult.h>
#include <aws/rekognition/model/GetCelebrityRecognitionRequest.h>
#include <aws/rekognition/model/GetCelebrityRecognitionResult.h>
#include <aws/rekognition/model/GetContentModerationRequest.h>
#include <aws/rekognition/model/GetContentModerationRequestMetadata.h>
#include <aws/rekognition/model/GetContentModerationResult.h>
#include <aws/rekognition/model/GetFaceDetectionRequest.h>
#include <aws/rekognition/model/GetFaceDetectionResult.h>
#include <aws/rekognition/model/GetFaceLivenessSessionResultsRequest.h>
#include <aws/rekognition/model/GetFaceLivenessSessionResultsResult.h>
#include <aws/rekognition/model/GetFaceSearchRequest.h>
#include <aws/rekognition/model/GetFaceSearchResult.h>
#include <aws/rekognition/model/GetLabelDetectionRequest.h>
#include <aws/rekognition/model/GetLabelDetectionRequestMetadata.h>
#include <aws/rekognition/model/GetLabelDetectionResult.h>
#include <aws/rekognition/model/GetMediaAnalysisJobRequest.h>
#include <aws/rekognition/model/GetMediaAnalysisJobResult.h>
#include <aws/rekognition/model/GetPersonTrackingRequest.h>
#include <aws/rekognition/model/GetPersonTrackingResult.h>
#include <aws/rekognition/model/GetSegmentDetectionRequest.h>
#include <aws/rekognition/model/GetSegmentDetectionResult.h>
#include <aws/rekognition/model/GetTextDetectionRequest.h>
#include <aws/rekognition/model/GetTextDetectionResult.h>
#include <aws/rekognition/model/GroundTruthManifest.h>
#include <aws/rekognition/model/HumanLoopActivationOutput.h>
#include <aws/rekognition/model/HumanLoopConfig.h>
#include <aws/rekognition/model/HumanLoopDataAttributes.h>
#include <aws/rekognition/model/HumanLoopQuotaExceededException.h>
#include <aws/rekognition/model/Image.h>
#include <aws/rekognition/model/ImageQuality.h>
#include <aws/rekognition/model/IndexFacesRequest.h>
#include <aws/rekognition/model/IndexFacesResult.h>
#include <aws/rekognition/model/Instance.h>
#include <aws/rekognition/model/KinesisDataStream.h>
#include <aws/rekognition/model/KinesisVideoStream.h>
#include <aws/rekognition/model/KinesisVideoStreamStartSelector.h>
#include <aws/rekognition/model/KnownGender.h>
#include <aws/rekognition/model/KnownGenderType.h>
#include <aws/rekognition/model/Label.h>
#include <aws/rekognition/model/LabelAlias.h>
#include <aws/rekognition/model/LabelCategory.h>
#include <aws/rekognition/model/LabelDetection.h>
#include <aws/rekognition/model/LabelDetectionAggregateBy.h>
#include <aws/rekognition/model/LabelDetectionFeatureName.h>
#include <aws/rekognition/model/LabelDetectionSettings.h>
#include <aws/rekognition/model/LabelDetectionSortBy.h>
#include <aws/rekognition/model/Landmark.h>
#include <aws/rekognition/model/LandmarkType.h>
#include <aws/rekognition/model/ListCollectionsRequest.h>
#include <aws/rekognition/model/ListCollectionsResult.h>
#include <aws/rekognition/model/ListDatasetEntriesRequest.h>
#include <aws/rekognition/model/ListDatasetEntriesResult.h>
#include <aws/rekognition/model/ListDatasetLabelsRequest.h>
#include <aws/rekognition/model/ListDatasetLabelsResult.h>
#include <aws/rekognition/model/ListFacesRequest.h>
#include <aws/rekognition/model/ListFacesResult.h>
#include <aws/rekognition/model/ListMediaAnalysisJobsRequest.h>
#include <aws/rekognition/model/ListMediaAnalysisJobsResult.h>
#include <aws/rekognition/model/ListProjectPoliciesRequest.h>
#include <aws/rekognition/model/ListProjectPoliciesResult.h>
#include <aws/rekognition/model/ListStreamProcessorsRequest.h>
#include <aws/rekognition/model/ListStreamProcessorsResult.h>
#include <aws/rekognition/model/ListTagsForResourceRequest.h>
#include <aws/rekognition/model/ListTagsForResourceResult.h>
#include <aws/rekognition/model/ListUsersRequest.h>
#include <aws/rekognition/model/ListUsersResult.h>
#include <aws/rekognition/model/LivenessOutputConfig.h>
#include <aws/rekognition/model/LivenessSessionStatus.h>
#include <aws/rekognition/model/MatchedUser.h>
#include <aws/rekognition/model/MediaAnalysisDetectModerationLabelsConfig.h>
#include <aws/rekognition/model/MediaAnalysisInput.h>
#include <aws/rekognition/model/MediaAnalysisJobDescription.h>
#include <aws/rekognition/model/MediaAnalysisJobFailureCode.h>
#include <aws/rekognition/model/MediaAnalysisJobFailureDetails.h>
#include <aws/rekognition/model/MediaAnalysisJobStatus.h>
#include <aws/rekognition/model/MediaAnalysisManifestSummary.h>
#include <aws/rekognition/model/MediaAnalysisModelVersions.h>
#include <aws/rekognition/model/MediaAnalysisOperationsConfig.h>
#include <aws/rekognition/model/MediaAnalysisOutputConfig.h>
#include <aws/rekognition/model/MediaAnalysisResults.h>
#include <aws/rekognition/model/ModerationLabel.h>
#include <aws/rekognition/model/MouthOpen.h>
#include <aws/rekognition/model/Mustache.h>
#include <aws/rekognition/model/NotificationChannel.h>
#include <aws/rekognition/model/OrientationCorrection.h>
#include <aws/rekognition/model/OutputConfig.h>
#include <aws/rekognition/model/Parent.h>
#include <aws/rekognition/model/PersonDetail.h>
#include <aws/rekognition/model/PersonDetection.h>
#include <aws/rekognition/model/PersonMatch.h>
#include <aws/rekognition/model/PersonTrackingSortBy.h>
#include <aws/rekognition/model/Point.h>
#include <aws/rekognition/model/Pose.h>
#include <aws/rekognition/model/ProjectAutoUpdate.h>
#include <aws/rekognition/model/ProjectDescription.h>
#include <aws/rekognition/model/ProjectPolicy.h>
#include <aws/rekognition/model/ProjectStatus.h>
#include <aws/rekognition/model/ProjectVersionDescription.h>
#include <aws/rekognition/model/ProjectVersionStatus.h>
#include <aws/rekognition/model/ProtectiveEquipmentBodyPart.h>
#include <aws/rekognition/model/ProtectiveEquipmentPerson.h>
#include <aws/rekognition/model/ProtectiveEquipmentSummarizationAttributes.h>
#include <aws/rekognition/model/ProtectiveEquipmentSummary.h>
#include <aws/rekognition/model/ProtectiveEquipmentType.h>
#include <aws/rekognition/model/PutProjectPolicyRequest.h>
#include <aws/rekognition/model/PutProjectPolicyResult.h>
#include <aws/rekognition/model/QualityFilter.h>
#include <aws/rekognition/model/Reason.h>
#include <aws/rekognition/model/RecognizeCelebritiesRequest.h>
#include <aws/rekognition/model/RecognizeCelebritiesResult.h>
#include <aws/rekognition/model/RegionOfInterest.h>
#include <aws/rekognition/model/S3Destination.h>
#include <aws/rekognition/model/S3Object.h>
#include <aws/rekognition/model/SearchFacesByImageRequest.h>
#include <aws/rekognition/model/SearchFacesByImageResult.h>
#include <aws/rekognition/model/SearchFacesRequest.h>
#include <aws/rekognition/model/SearchFacesResult.h>
#include <aws/rekognition/model/SearchUsersByImageRequest.h>
#include <aws/rekognition/model/SearchUsersByImageResult.h>
#include <aws/rekognition/model/SearchUsersRequest.h>
#include <aws/rekognition/model/SearchUsersResult.h>
#include <aws/rekognition/model/SearchedFace.h>
#include <aws/rekognition/model/SearchedFaceDetails.h>
#include <aws/rekognition/model/SearchedUser.h>
#include <aws/rekognition/model/SegmentDetection.h>
#include <aws/rekognition/model/SegmentType.h>
#include <aws/rekognition/model/SegmentTypeInfo.h>
#include <aws/rekognition/model/ShotSegment.h>
#include <aws/rekognition/model/Smile.h>
#include <aws/rekognition/model/StartCelebrityRecognitionRequest.h>
#include <aws/rekognition/model/StartCelebrityRecognitionResult.h>
#include <aws/rekognition/model/StartContentModerationRequest.h>
#include <aws/rekognition/model/StartContentModerationResult.h>
#include <aws/rekognition/model/StartFaceDetectionRequest.h>
#include <aws/rekognition/model/StartFaceDetectionResult.h>
#include <aws/rekognition/model/StartFaceSearchRequest.h>
#include <aws/rekognition/model/StartFaceSearchResult.h>
#include <aws/rekognition/model/StartLabelDetectionRequest.h>
#include <aws/rekognition/model/StartLabelDetectionResult.h>
#include <aws/rekognition/model/StartMediaAnalysisJobRequest.h>
#include <aws/rekognition/model/StartMediaAnalysisJobResult.h>
#include <aws/rekognition/model/StartPersonTrackingRequest.h>
#include <aws/rekognition/model/StartPersonTrackingResult.h>
#include <aws/rekognition/model/StartProjectVersionRequest.h>
#include <aws/rekognition/model/StartProjectVersionResult.h>
#include <aws/rekognition/model/StartSegmentDetectionFilters.h>
#include <aws/rekognition/model/StartSegmentDetectionRequest.h>
#include <aws/rekognition/model/StartSegmentDetectionResult.h>
#include <aws/rekognition/model/StartShotDetectionFilter.h>
#include <aws/rekognition/model/StartStreamProcessorRequest.h>
#include <aws/rekognition/model/StartStreamProcessorResult.h>
#include <aws/rekognition/model/StartTechnicalCueDetectionFilter.h>
#include <aws/rekognition/model/StartTextDetectionFilters.h>
#include <aws/rekognition/model/StartTextDetectionRequest.h>
#include <aws/rekognition/model/StartTextDetectionResult.h>
#include <aws/rekognition/model/StopProjectVersionRequest.h>
#include <aws/rekognition/model/StopProjectVersionResult.h>
#include <aws/rekognition/model/StopStreamProcessorRequest.h>
#include <aws/rekognition/model/StopStreamProcessorResult.h>
#include <aws/rekognition/model/StreamProcessingStartSelector.h>
#include <aws/rekognition/model/StreamProcessingStopSelector.h>
#include <aws/rekognition/model/StreamProcessor.h>
#include <aws/rekognition/model/StreamProcessorDataSharingPreference.h>
#include <aws/rekognition/model/StreamProcessorInput.h>
#include <aws/rekognition/model/StreamProcessorNotificationChannel.h>
#include <aws/rekognition/model/StreamProcessorOutput.h>
#include <aws/rekognition/model/StreamProcessorParameterToDelete.h>
#include <aws/rekognition/model/StreamProcessorSettings.h>
#include <aws/rekognition/model/StreamProcessorSettingsForUpdate.h>
#include <aws/rekognition/model/StreamProcessorStatus.h>
#include <aws/rekognition/model/Summary.h>
#include <aws/rekognition/model/Sunglasses.h>
#include <aws/rekognition/model/TagResourceRequest.h>
#include <aws/rekognition/model/TagResourceResult.h>
#include <aws/rekognition/model/TechnicalCueSegment.h>
#include <aws/rekognition/model/TechnicalCueType.h>
#include <aws/rekognition/model/TestingData.h>
#include <aws/rekognition/model/TestingDataResult.h>
#include <aws/rekognition/model/TextDetection.h>
#include <aws/rekognition/model/TextDetectionResult.h>
#include <aws/rekognition/model/TextTypes.h>
#include <aws/rekognition/model/TrainingData.h>
#include <aws/rekognition/model/TrainingDataResult.h>
#include <aws/rekognition/model/UnindexedFace.h>
#include <aws/rekognition/model/UnsearchedFace.h>
#include <aws/rekognition/model/UnsearchedFaceReason.h>
#include <aws/rekognition/model/UnsuccessfulFaceAssociation.h>
#include <aws/rekognition/model/UnsuccessfulFaceAssociationReason.h>
#include <aws/rekognition/model/UnsuccessfulFaceDeletion.h>
#include <aws/rekognition/model/UnsuccessfulFaceDeletionReason.h>
#include <aws/rekognition/model/UnsuccessfulFaceDisassociation.h>
#include <aws/rekognition/model/UnsuccessfulFaceDisassociationReason.h>
#include <aws/rekognition/model/UntagResourceRequest.h>
#include <aws/rekognition/model/UntagResourceResult.h>
#include <aws/rekognition/model/UpdateDatasetEntriesRequest.h>
#include <aws/rekognition/model/UpdateDatasetEntriesResult.h>
#include <aws/rekognition/model/UpdateStreamProcessorRequest.h>
#include <aws/rekognition/model/UpdateStreamProcessorResult.h>
#include <aws/rekognition/model/User.h>
#include <aws/rekognition/model/UserMatch.h>
#include <aws/rekognition/model/UserStatus.h>
#include <aws/rekognition/model/ValidationData.h>
#include <aws/rekognition/model/Versions.h>
#include <aws/rekognition/model/Video.h>
#include <aws/rekognition/model/VideoColorRange.h>
#include <aws/rekognition/model/VideoJobStatus.h>
#include <aws/rekognition/model/VideoMetadata.h>

using RekognitionIncludeTest = ::testing::Test;

TEST_F(RekognitionIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Rekognition::RekognitionClient>("RekognitionIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
