/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/resiliencehub/ResilienceHubClient.h>
#include <aws/resiliencehub/ResilienceHubEndpointProvider.h>
#include <aws/resiliencehub/ResilienceHubEndpointRules.h>
#include <aws/resiliencehub/ResilienceHubErrorMarshaller.h>
#include <aws/resiliencehub/ResilienceHubErrors.h>
#include <aws/resiliencehub/ResilienceHubRequest.h>
#include <aws/resiliencehub/ResilienceHubServiceClientModel.h>
#include <aws/resiliencehub/ResilienceHub_EXPORTS.h>
#include <aws/resiliencehub/model/AcceptGroupingRecommendationEntry.h>
#include <aws/resiliencehub/model/AcceptResourceGroupingRecommendationsRequest.h>
#include <aws/resiliencehub/model/AcceptResourceGroupingRecommendationsResult.h>
#include <aws/resiliencehub/model/AddDraftAppVersionResourceMappingsRequest.h>
#include <aws/resiliencehub/model/AddDraftAppVersionResourceMappingsResult.h>
#include <aws/resiliencehub/model/Alarm.h>
#include <aws/resiliencehub/model/AlarmRecommendation.h>
#include <aws/resiliencehub/model/AlarmType.h>
#include <aws/resiliencehub/model/App.h>
#include <aws/resiliencehub/model/AppAssessment.h>
#include <aws/resiliencehub/model/AppAssessmentScheduleType.h>
#include <aws/resiliencehub/model/AppAssessmentSummary.h>
#include <aws/resiliencehub/model/AppComplianceStatusType.h>
#include <aws/resiliencehub/model/AppComponent.h>
#include <aws/resiliencehub/model/AppComponentCompliance.h>
#include <aws/resiliencehub/model/AppDriftStatusType.h>
#include <aws/resiliencehub/model/AppInputSource.h>
#include <aws/resiliencehub/model/AppStatusType.h>
#include <aws/resiliencehub/model/AppSummary.h>
#include <aws/resiliencehub/model/AppVersionSummary.h>
#include <aws/resiliencehub/model/AssessmentInvoker.h>
#include <aws/resiliencehub/model/AssessmentRiskRecommendation.h>
#include <aws/resiliencehub/model/AssessmentStatus.h>
#include <aws/resiliencehub/model/AssessmentSummary.h>
#include <aws/resiliencehub/model/BatchUpdateRecommendationStatusFailedEntry.h>
#include <aws/resiliencehub/model/BatchUpdateRecommendationStatusRequest.h>
#include <aws/resiliencehub/model/BatchUpdateRecommendationStatusResult.h>
#include <aws/resiliencehub/model/BatchUpdateRecommendationStatusSuccessfulEntry.h>
#include <aws/resiliencehub/model/ComplianceDrift.h>
#include <aws/resiliencehub/model/ComplianceStatus.h>
#include <aws/resiliencehub/model/ComponentRecommendation.h>
#include <aws/resiliencehub/model/Condition.h>
#include <aws/resiliencehub/model/ConditionOperatorType.h>
#include <aws/resiliencehub/model/ConfigRecommendation.h>
#include <aws/resiliencehub/model/ConfigRecommendationOptimizationType.h>
#include <aws/resiliencehub/model/ConflictException.h>
#include <aws/resiliencehub/model/Cost.h>
#include <aws/resiliencehub/model/CostFrequency.h>
#include <aws/resiliencehub/model/CreateAppRequest.h>
#include <aws/resiliencehub/model/CreateAppResult.h>
#include <aws/resiliencehub/model/CreateAppVersionAppComponentRequest.h>
#include <aws/resiliencehub/model/CreateAppVersionAppComponentResult.h>
#include <aws/resiliencehub/model/CreateAppVersionResourceRequest.h>
#include <aws/resiliencehub/model/CreateAppVersionResourceResult.h>
#include <aws/resiliencehub/model/CreateRecommendationTemplateRequest.h>
#include <aws/resiliencehub/model/CreateRecommendationTemplateResult.h>
#include <aws/resiliencehub/model/CreateResiliencyPolicyRequest.h>
#include <aws/resiliencehub/model/CreateResiliencyPolicyResult.h>
#include <aws/resiliencehub/model/DataLocationConstraint.h>
#include <aws/resiliencehub/model/DeleteAppAssessmentRequest.h>
#include <aws/resiliencehub/model/DeleteAppAssessmentResult.h>
#include <aws/resiliencehub/model/DeleteAppInputSourceRequest.h>
#include <aws/resiliencehub/model/DeleteAppInputSourceResult.h>
#include <aws/resiliencehub/model/DeleteAppRequest.h>
#include <aws/resiliencehub/model/DeleteAppResult.h>
#include <aws/resiliencehub/model/DeleteAppVersionAppComponentRequest.h>
#include <aws/resiliencehub/model/DeleteAppVersionAppComponentResult.h>
#include <aws/resiliencehub/model/DeleteAppVersionResourceRequest.h>
#include <aws/resiliencehub/model/DeleteAppVersionResourceResult.h>
#include <aws/resiliencehub/model/DeleteRecommendationTemplateRequest.h>
#include <aws/resiliencehub/model/DeleteRecommendationTemplateResult.h>
#include <aws/resiliencehub/model/DeleteResiliencyPolicyRequest.h>
#include <aws/resiliencehub/model/DeleteResiliencyPolicyResult.h>
#include <aws/resiliencehub/model/DescribeAppAssessmentRequest.h>
#include <aws/resiliencehub/model/DescribeAppAssessmentResult.h>
#include <aws/resiliencehub/model/DescribeAppRequest.h>
#include <aws/resiliencehub/model/DescribeAppResult.h>
#include <aws/resiliencehub/model/DescribeAppVersionAppComponentRequest.h>
#include <aws/resiliencehub/model/DescribeAppVersionAppComponentResult.h>
#include <aws/resiliencehub/model/DescribeAppVersionRequest.h>
#include <aws/resiliencehub/model/DescribeAppVersionResourceRequest.h>
#include <aws/resiliencehub/model/DescribeAppVersionResourceResult.h>
#include <aws/resiliencehub/model/DescribeAppVersionResourcesResolutionStatusRequest.h>
#include <aws/resiliencehub/model/DescribeAppVersionResourcesResolutionStatusResult.h>
#include <aws/resiliencehub/model/DescribeAppVersionResult.h>
#include <aws/resiliencehub/model/DescribeAppVersionTemplateRequest.h>
#include <aws/resiliencehub/model/DescribeAppVersionTemplateResult.h>
#include <aws/resiliencehub/model/DescribeDraftAppVersionResourcesImportStatusRequest.h>
#include <aws/resiliencehub/model/DescribeDraftAppVersionResourcesImportStatusResult.h>
#include <aws/resiliencehub/model/DescribeMetricsExportRequest.h>
#include <aws/resiliencehub/model/DescribeMetricsExportResult.h>
#include <aws/resiliencehub/model/DescribeResiliencyPolicyRequest.h>
#include <aws/resiliencehub/model/DescribeResiliencyPolicyResult.h>
#include <aws/resiliencehub/model/DescribeResourceGroupingRecommendationTaskRequest.h>
#include <aws/resiliencehub/model/DescribeResourceGroupingRecommendationTaskResult.h>
#include <aws/resiliencehub/model/DifferenceType.h>
#include <aws/resiliencehub/model/DisruptionCompliance.h>
#include <aws/resiliencehub/model/DisruptionType.h>
#include <aws/resiliencehub/model/DriftStatus.h>
#include <aws/resiliencehub/model/DriftType.h>
#include <aws/resiliencehub/model/EksSource.h>
#include <aws/resiliencehub/model/EksSourceClusterNamespace.h>
#include <aws/resiliencehub/model/ErrorDetail.h>
#include <aws/resiliencehub/model/EstimatedCostTier.h>
#include <aws/resiliencehub/model/EventSubscription.h>
#include <aws/resiliencehub/model/EventType.h>
#include <aws/resiliencehub/model/ExcludeRecommendationReason.h>
#include <aws/resiliencehub/model/Experiment.h>
#include <aws/resiliencehub/model/FailedGroupingRecommendationEntry.h>
#include <aws/resiliencehub/model/FailurePolicy.h>
#include <aws/resiliencehub/model/Field.h>
#include <aws/resiliencehub/model/FieldAggregationType.h>
#include <aws/resiliencehub/model/GroupingAppComponent.h>
#include <aws/resiliencehub/model/GroupingRecommendation.h>
#include <aws/resiliencehub/model/GroupingRecommendationConfidenceLevel.h>
#include <aws/resiliencehub/model/GroupingRecommendationRejectionReason.h>
#include <aws/resiliencehub/model/GroupingRecommendationStatusType.h>
#include <aws/resiliencehub/model/GroupingResource.h>
#include <aws/resiliencehub/model/HaArchitecture.h>
#include <aws/resiliencehub/model/ImportResourcesToDraftAppVersionRequest.h>
#include <aws/resiliencehub/model/ImportResourcesToDraftAppVersionResult.h>
#include <aws/resiliencehub/model/ListAlarmRecommendationsRequest.h>
#include <aws/resiliencehub/model/ListAlarmRecommendationsResult.h>
#include <aws/resiliencehub/model/ListAppAssessmentComplianceDriftsRequest.h>
#include <aws/resiliencehub/model/ListAppAssessmentComplianceDriftsResult.h>
#include <aws/resiliencehub/model/ListAppAssessmentResourceDriftsRequest.h>
#include <aws/resiliencehub/model/ListAppAssessmentResourceDriftsResult.h>
#include <aws/resiliencehub/model/ListAppAssessmentsRequest.h>
#include <aws/resiliencehub/model/ListAppAssessmentsResult.h>
#include <aws/resiliencehub/model/ListAppComponentCompliancesRequest.h>
#include <aws/resiliencehub/model/ListAppComponentCompliancesResult.h>
#include <aws/resiliencehub/model/ListAppComponentRecommendationsRequest.h>
#include <aws/resiliencehub/model/ListAppComponentRecommendationsResult.h>
#include <aws/resiliencehub/model/ListAppInputSourcesRequest.h>
#include <aws/resiliencehub/model/ListAppInputSourcesResult.h>
#include <aws/resiliencehub/model/ListAppVersionAppComponentsRequest.h>
#include <aws/resiliencehub/model/ListAppVersionAppComponentsResult.h>
#include <aws/resiliencehub/model/ListAppVersionResourceMappingsRequest.h>
#include <aws/resiliencehub/model/ListAppVersionResourceMappingsResult.h>
#include <aws/resiliencehub/model/ListAppVersionResourcesRequest.h>
#include <aws/resiliencehub/model/ListAppVersionResourcesResult.h>
#include <aws/resiliencehub/model/ListAppVersionsRequest.h>
#include <aws/resiliencehub/model/ListAppVersionsResult.h>
#include <aws/resiliencehub/model/ListAppsRequest.h>
#include <aws/resiliencehub/model/ListAppsResult.h>
#include <aws/resiliencehub/model/ListMetricsRequest.h>
#include <aws/resiliencehub/model/ListMetricsResult.h>
#include <aws/resiliencehub/model/ListRecommendationTemplatesRequest.h>
#include <aws/resiliencehub/model/ListRecommendationTemplatesResult.h>
#include <aws/resiliencehub/model/ListResiliencyPoliciesRequest.h>
#include <aws/resiliencehub/model/ListResiliencyPoliciesResult.h>
#include <aws/resiliencehub/model/ListResourceGroupingRecommendationsRequest.h>
#include <aws/resiliencehub/model/ListResourceGroupingRecommendationsResult.h>
#include <aws/resiliencehub/model/ListSopRecommendationsRequest.h>
#include <aws/resiliencehub/model/ListSopRecommendationsResult.h>
#include <aws/resiliencehub/model/ListSuggestedResiliencyPoliciesRequest.h>
#include <aws/resiliencehub/model/ListSuggestedResiliencyPoliciesResult.h>
#include <aws/resiliencehub/model/ListTagsForResourceRequest.h>
#include <aws/resiliencehub/model/ListTagsForResourceResult.h>
#include <aws/resiliencehub/model/ListTestRecommendationsRequest.h>
#include <aws/resiliencehub/model/ListTestRecommendationsResult.h>
#include <aws/resiliencehub/model/ListUnsupportedAppVersionResourcesRequest.h>
#include <aws/resiliencehub/model/ListUnsupportedAppVersionResourcesResult.h>
#include <aws/resiliencehub/model/LogicalResourceId.h>
#include <aws/resiliencehub/model/MetricsExportStatusType.h>
#include <aws/resiliencehub/model/PermissionModel.h>
#include <aws/resiliencehub/model/PermissionModelType.h>
#include <aws/resiliencehub/model/PhysicalIdentifierType.h>
#include <aws/resiliencehub/model/PhysicalResource.h>
#include <aws/resiliencehub/model/PhysicalResourceId.h>
#include <aws/resiliencehub/model/PublishAppVersionRequest.h>
#include <aws/resiliencehub/model/PublishAppVersionResult.h>
#include <aws/resiliencehub/model/PutDraftAppVersionTemplateRequest.h>
#include <aws/resiliencehub/model/PutDraftAppVersionTemplateResult.h>
#include <aws/resiliencehub/model/RecommendationComplianceStatus.h>
#include <aws/resiliencehub/model/RecommendationDisruptionCompliance.h>
#include <aws/resiliencehub/model/RecommendationItem.h>
#include <aws/resiliencehub/model/RecommendationStatus.h>
#include <aws/resiliencehub/model/RecommendationTemplate.h>
#include <aws/resiliencehub/model/RecommendationTemplateStatus.h>
#include <aws/resiliencehub/model/RejectGroupingRecommendationEntry.h>
#include <aws/resiliencehub/model/RejectResourceGroupingRecommendationsRequest.h>
#include <aws/resiliencehub/model/RejectResourceGroupingRecommendationsResult.h>
#include <aws/resiliencehub/model/RemoveDraftAppVersionResourceMappingsRequest.h>
#include <aws/resiliencehub/model/RemoveDraftAppVersionResourceMappingsResult.h>
#include <aws/resiliencehub/model/RenderRecommendationType.h>
#include <aws/resiliencehub/model/ResiliencyPolicy.h>
#include <aws/resiliencehub/model/ResiliencyPolicyTier.h>
#include <aws/resiliencehub/model/ResiliencyScore.h>
#include <aws/resiliencehub/model/ResiliencyScoreType.h>
#include <aws/resiliencehub/model/ResolveAppVersionResourcesRequest.h>
#include <aws/resiliencehub/model/ResolveAppVersionResourcesResult.h>
#include <aws/resiliencehub/model/ResourceDrift.h>
#include <aws/resiliencehub/model/ResourceError.h>
#include <aws/resiliencehub/model/ResourceErrorsDetails.h>
#include <aws/resiliencehub/model/ResourceIdentifier.h>
#include <aws/resiliencehub/model/ResourceImportStatusType.h>
#include <aws/resiliencehub/model/ResourceImportStrategyType.h>
#include <aws/resiliencehub/model/ResourceMapping.h>
#include <aws/resiliencehub/model/ResourceMappingType.h>
#include <aws/resiliencehub/model/ResourceNotFoundException.h>
#include <aws/resiliencehub/model/ResourceResolutionStatusType.h>
#include <aws/resiliencehub/model/ResourceSourceType.h>
#include <aws/resiliencehub/model/ResourcesGroupingRecGenStatusType.h>
#include <aws/resiliencehub/model/S3Location.h>
#include <aws/resiliencehub/model/ScoringComponentResiliencyScore.h>
#include <aws/resiliencehub/model/SopRecommendation.h>
#include <aws/resiliencehub/model/SopServiceType.h>
#include <aws/resiliencehub/model/Sort.h>
#include <aws/resiliencehub/model/StartAppAssessmentRequest.h>
#include <aws/resiliencehub/model/StartAppAssessmentResult.h>
#include <aws/resiliencehub/model/StartMetricsExportRequest.h>
#include <aws/resiliencehub/model/StartMetricsExportResult.h>
#include <aws/resiliencehub/model/StartResourceGroupingRecommendationTaskRequest.h>
#include <aws/resiliencehub/model/StartResourceGroupingRecommendationTaskResult.h>
#include <aws/resiliencehub/model/TagResourceRequest.h>
#include <aws/resiliencehub/model/TagResourceResult.h>
#include <aws/resiliencehub/model/TemplateFormat.h>
#include <aws/resiliencehub/model/TerraformSource.h>
#include <aws/resiliencehub/model/TestRecommendation.h>
#include <aws/resiliencehub/model/TestRisk.h>
#include <aws/resiliencehub/model/TestType.h>
#include <aws/resiliencehub/model/ThrottlingException.h>
#include <aws/resiliencehub/model/UnsupportedResource.h>
#include <aws/resiliencehub/model/UntagResourceRequest.h>
#include <aws/resiliencehub/model/UntagResourceResult.h>
#include <aws/resiliencehub/model/UpdateAppRequest.h>
#include <aws/resiliencehub/model/UpdateAppResult.h>
#include <aws/resiliencehub/model/UpdateAppVersionAppComponentRequest.h>
#include <aws/resiliencehub/model/UpdateAppVersionAppComponentResult.h>
#include <aws/resiliencehub/model/UpdateAppVersionRequest.h>
#include <aws/resiliencehub/model/UpdateAppVersionResourceRequest.h>
#include <aws/resiliencehub/model/UpdateAppVersionResourceResult.h>
#include <aws/resiliencehub/model/UpdateAppVersionResult.h>
#include <aws/resiliencehub/model/UpdateRecommendationStatusItem.h>
#include <aws/resiliencehub/model/UpdateRecommendationStatusRequestEntry.h>
#include <aws/resiliencehub/model/UpdateResiliencyPolicyRequest.h>
#include <aws/resiliencehub/model/UpdateResiliencyPolicyResult.h>

using ResilienceHubIncludeTest = ::testing::Test;

TEST_F(ResilienceHubIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::ResilienceHub::ResilienceHubClient>("ResilienceHubIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
