/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/robomaker/RoboMakerClient.h>
#include <aws/robomaker/RoboMakerEndpointProvider.h>
#include <aws/robomaker/RoboMakerEndpointRules.h>
#include <aws/robomaker/RoboMakerErrorMarshaller.h>
#include <aws/robomaker/RoboMakerErrors.h>
#include <aws/robomaker/RoboMakerRequest.h>
#include <aws/robomaker/RoboMakerServiceClientModel.h>
#include <aws/robomaker/RoboMaker_EXPORTS.h>
#include <aws/robomaker/model/Architecture.h>
#include <aws/robomaker/model/BatchDeleteWorldsRequest.h>
#include <aws/robomaker/model/BatchDeleteWorldsResult.h>
#include <aws/robomaker/model/BatchDescribeSimulationJobRequest.h>
#include <aws/robomaker/model/BatchDescribeSimulationJobResult.h>
#include <aws/robomaker/model/BatchPolicy.h>
#include <aws/robomaker/model/CancelSimulationJobBatchRequest.h>
#include <aws/robomaker/model/CancelSimulationJobBatchResult.h>
#include <aws/robomaker/model/CancelSimulationJobRequest.h>
#include <aws/robomaker/model/CancelSimulationJobResult.h>
#include <aws/robomaker/model/CancelWorldExportJobRequest.h>
#include <aws/robomaker/model/CancelWorldExportJobResult.h>
#include <aws/robomaker/model/CancelWorldGenerationJobRequest.h>
#include <aws/robomaker/model/CancelWorldGenerationJobResult.h>
#include <aws/robomaker/model/Compute.h>
#include <aws/robomaker/model/ComputeResponse.h>
#include <aws/robomaker/model/ComputeType.h>
#include <aws/robomaker/model/CreateRobotApplicationRequest.h>
#include <aws/robomaker/model/CreateRobotApplicationResult.h>
#include <aws/robomaker/model/CreateRobotApplicationVersionRequest.h>
#include <aws/robomaker/model/CreateRobotApplicationVersionResult.h>
#include <aws/robomaker/model/CreateSimulationApplicationRequest.h>
#include <aws/robomaker/model/CreateSimulationApplicationResult.h>
#include <aws/robomaker/model/CreateSimulationApplicationVersionRequest.h>
#include <aws/robomaker/model/CreateSimulationApplicationVersionResult.h>
#include <aws/robomaker/model/CreateSimulationJobRequest.h>
#include <aws/robomaker/model/CreateSimulationJobResult.h>
#include <aws/robomaker/model/CreateWorldExportJobRequest.h>
#include <aws/robomaker/model/CreateWorldExportJobResult.h>
#include <aws/robomaker/model/CreateWorldGenerationJobRequest.h>
#include <aws/robomaker/model/CreateWorldGenerationJobResult.h>
#include <aws/robomaker/model/CreateWorldTemplateRequest.h>
#include <aws/robomaker/model/CreateWorldTemplateResult.h>
#include <aws/robomaker/model/DataSource.h>
#include <aws/robomaker/model/DataSourceConfig.h>
#include <aws/robomaker/model/DataSourceType.h>
#include <aws/robomaker/model/DeleteRobotApplicationRequest.h>
#include <aws/robomaker/model/DeleteRobotApplicationResult.h>
#include <aws/robomaker/model/DeleteSimulationApplicationRequest.h>
#include <aws/robomaker/model/DeleteSimulationApplicationResult.h>
#include <aws/robomaker/model/DeleteWorldTemplateRequest.h>
#include <aws/robomaker/model/DeleteWorldTemplateResult.h>
#include <aws/robomaker/model/DeploymentApplicationConfig.h>
#include <aws/robomaker/model/DeploymentConfig.h>
#include <aws/robomaker/model/DeploymentJob.h>
#include <aws/robomaker/model/DeploymentJobErrorCode.h>
#include <aws/robomaker/model/DeploymentLaunchConfig.h>
#include <aws/robomaker/model/DeploymentStatus.h>
#include <aws/robomaker/model/DescribeRobotApplicationRequest.h>
#include <aws/robomaker/model/DescribeRobotApplicationResult.h>
#include <aws/robomaker/model/DescribeSimulationApplicationRequest.h>
#include <aws/robomaker/model/DescribeSimulationApplicationResult.h>
#include <aws/robomaker/model/DescribeSimulationJobBatchRequest.h>
#include <aws/robomaker/model/DescribeSimulationJobBatchResult.h>
#include <aws/robomaker/model/DescribeSimulationJobRequest.h>
#include <aws/robomaker/model/DescribeSimulationJobResult.h>
#include <aws/robomaker/model/DescribeWorldExportJobRequest.h>
#include <aws/robomaker/model/DescribeWorldExportJobResult.h>
#include <aws/robomaker/model/DescribeWorldGenerationJobRequest.h>
#include <aws/robomaker/model/DescribeWorldGenerationJobResult.h>
#include <aws/robomaker/model/DescribeWorldRequest.h>
#include <aws/robomaker/model/DescribeWorldResult.h>
#include <aws/robomaker/model/DescribeWorldTemplateRequest.h>
#include <aws/robomaker/model/DescribeWorldTemplateResult.h>
#include <aws/robomaker/model/Environment.h>
#include <aws/robomaker/model/ExitBehavior.h>
#include <aws/robomaker/model/FailedCreateSimulationJobRequest.h>
#include <aws/robomaker/model/FailureBehavior.h>
#include <aws/robomaker/model/FailureSummary.h>
#include <aws/robomaker/model/Filter.h>
#include <aws/robomaker/model/FinishedWorldsSummary.h>
#include <aws/robomaker/model/Fleet.h>
#include <aws/robomaker/model/GetWorldTemplateBodyRequest.h>
#include <aws/robomaker/model/GetWorldTemplateBodyResult.h>
#include <aws/robomaker/model/LaunchConfig.h>
#include <aws/robomaker/model/ListRobotApplicationsRequest.h>
#include <aws/robomaker/model/ListRobotApplicationsResult.h>
#include <aws/robomaker/model/ListSimulationApplicationsRequest.h>
#include <aws/robomaker/model/ListSimulationApplicationsResult.h>
#include <aws/robomaker/model/ListSimulationJobBatchesRequest.h>
#include <aws/robomaker/model/ListSimulationJobBatchesResult.h>
#include <aws/robomaker/model/ListSimulationJobsRequest.h>
#include <aws/robomaker/model/ListSimulationJobsResult.h>
#include <aws/robomaker/model/ListTagsForResourceRequest.h>
#include <aws/robomaker/model/ListTagsForResourceResult.h>
#include <aws/robomaker/model/ListWorldExportJobsRequest.h>
#include <aws/robomaker/model/ListWorldExportJobsResult.h>
#include <aws/robomaker/model/ListWorldGenerationJobsRequest.h>
#include <aws/robomaker/model/ListWorldGenerationJobsResult.h>
#include <aws/robomaker/model/ListWorldTemplatesRequest.h>
#include <aws/robomaker/model/ListWorldTemplatesResult.h>
#include <aws/robomaker/model/ListWorldsRequest.h>
#include <aws/robomaker/model/ListWorldsResult.h>
#include <aws/robomaker/model/LoggingConfig.h>
#include <aws/robomaker/model/NetworkInterface.h>
#include <aws/robomaker/model/OutputLocation.h>
#include <aws/robomaker/model/PortForwardingConfig.h>
#include <aws/robomaker/model/PortMapping.h>
#include <aws/robomaker/model/ProgressDetail.h>
#include <aws/robomaker/model/RenderingEngine.h>
#include <aws/robomaker/model/RenderingEngineType.h>
#include <aws/robomaker/model/RestartSimulationJobRequest.h>
#include <aws/robomaker/model/RestartSimulationJobResult.h>
#include <aws/robomaker/model/Robot.h>
#include <aws/robomaker/model/RobotApplicationConfig.h>
#include <aws/robomaker/model/RobotApplicationSummary.h>
#include <aws/robomaker/model/RobotDeployment.h>
#include <aws/robomaker/model/RobotDeploymentStep.h>
#include <aws/robomaker/model/RobotSoftwareSuite.h>
#include <aws/robomaker/model/RobotSoftwareSuiteType.h>
#include <aws/robomaker/model/RobotSoftwareSuiteVersionType.h>
#include <aws/robomaker/model/RobotStatus.h>
#include <aws/robomaker/model/S3KeyOutput.h>
#include <aws/robomaker/model/S3Object.h>
#include <aws/robomaker/model/SimulationApplicationConfig.h>
#include <aws/robomaker/model/SimulationApplicationSummary.h>
#include <aws/robomaker/model/SimulationJob.h>
#include <aws/robomaker/model/SimulationJobBatchErrorCode.h>
#include <aws/robomaker/model/SimulationJobBatchStatus.h>
#include <aws/robomaker/model/SimulationJobBatchSummary.h>
#include <aws/robomaker/model/SimulationJobErrorCode.h>
#include <aws/robomaker/model/SimulationJobRequest.h>
#include <aws/robomaker/model/SimulationJobStatus.h>
#include <aws/robomaker/model/SimulationJobSummary.h>
#include <aws/robomaker/model/SimulationSoftwareSuite.h>
#include <aws/robomaker/model/SimulationSoftwareSuiteType.h>
#include <aws/robomaker/model/Source.h>
#include <aws/robomaker/model/SourceConfig.h>
#include <aws/robomaker/model/StartSimulationJobBatchRequest.h>
#include <aws/robomaker/model/StartSimulationJobBatchResult.h>
#include <aws/robomaker/model/TagResourceRequest.h>
#include <aws/robomaker/model/TagResourceResult.h>
#include <aws/robomaker/model/TemplateLocation.h>
#include <aws/robomaker/model/TemplateSummary.h>
#include <aws/robomaker/model/Tool.h>
#include <aws/robomaker/model/UntagResourceRequest.h>
#include <aws/robomaker/model/UntagResourceResult.h>
#include <aws/robomaker/model/UpdateRobotApplicationRequest.h>
#include <aws/robomaker/model/UpdateRobotApplicationResult.h>
#include <aws/robomaker/model/UpdateSimulationApplicationRequest.h>
#include <aws/robomaker/model/UpdateSimulationApplicationResult.h>
#include <aws/robomaker/model/UpdateWorldTemplateRequest.h>
#include <aws/robomaker/model/UpdateWorldTemplateResult.h>
#include <aws/robomaker/model/UploadBehavior.h>
#include <aws/robomaker/model/UploadConfiguration.h>
#include <aws/robomaker/model/VPCConfig.h>
#include <aws/robomaker/model/VPCConfigResponse.h>
#include <aws/robomaker/model/WorldConfig.h>
#include <aws/robomaker/model/WorldCount.h>
#include <aws/robomaker/model/WorldExportJobErrorCode.h>
#include <aws/robomaker/model/WorldExportJobStatus.h>
#include <aws/robomaker/model/WorldExportJobSummary.h>
#include <aws/robomaker/model/WorldFailure.h>
#include <aws/robomaker/model/WorldGenerationJobErrorCode.h>
#include <aws/robomaker/model/WorldGenerationJobStatus.h>
#include <aws/robomaker/model/WorldGenerationJobSummary.h>
#include <aws/robomaker/model/WorldSummary.h>

using RoboMakerIncludeTest = ::testing::Test;

TEST_F(RoboMakerIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::RoboMaker::RoboMakerClient>("RoboMakerIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
