/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/route53resolver/Route53ResolverClient.h>
#include <aws/route53resolver/Route53ResolverEndpointProvider.h>
#include <aws/route53resolver/Route53ResolverEndpointRules.h>
#include <aws/route53resolver/Route53ResolverErrorMarshaller.h>
#include <aws/route53resolver/Route53ResolverErrors.h>
#include <aws/route53resolver/Route53ResolverRequest.h>
#include <aws/route53resolver/Route53ResolverServiceClientModel.h>
#include <aws/route53resolver/Route53Resolver_EXPORTS.h>
#include <aws/route53resolver/model/Action.h>
#include <aws/route53resolver/model/AssociateFirewallRuleGroupRequest.h>
#include <aws/route53resolver/model/AssociateFirewallRuleGroupResult.h>
#include <aws/route53resolver/model/AssociateResolverEndpointIpAddressRequest.h>
#include <aws/route53resolver/model/AssociateResolverEndpointIpAddressResult.h>
#include <aws/route53resolver/model/AssociateResolverQueryLogConfigRequest.h>
#include <aws/route53resolver/model/AssociateResolverQueryLogConfigResult.h>
#include <aws/route53resolver/model/AssociateResolverRuleRequest.h>
#include <aws/route53resolver/model/AssociateResolverRuleResult.h>
#include <aws/route53resolver/model/AutodefinedReverseFlag.h>
#include <aws/route53resolver/model/BlockOverrideDnsType.h>
#include <aws/route53resolver/model/BlockResponse.h>
#include <aws/route53resolver/model/ConfidenceThreshold.h>
#include <aws/route53resolver/model/CreateFirewallDomainListRequest.h>
#include <aws/route53resolver/model/CreateFirewallDomainListResult.h>
#include <aws/route53resolver/model/CreateFirewallRuleGroupRequest.h>
#include <aws/route53resolver/model/CreateFirewallRuleGroupResult.h>
#include <aws/route53resolver/model/CreateFirewallRuleRequest.h>
#include <aws/route53resolver/model/CreateFirewallRuleResult.h>
#include <aws/route53resolver/model/CreateOutpostResolverRequest.h>
#include <aws/route53resolver/model/CreateOutpostResolverResult.h>
#include <aws/route53resolver/model/CreateResolverEndpointRequest.h>
#include <aws/route53resolver/model/CreateResolverEndpointResult.h>
#include <aws/route53resolver/model/CreateResolverQueryLogConfigRequest.h>
#include <aws/route53resolver/model/CreateResolverQueryLogConfigResult.h>
#include <aws/route53resolver/model/CreateResolverRuleRequest.h>
#include <aws/route53resolver/model/CreateResolverRuleResult.h>
#include <aws/route53resolver/model/DeleteFirewallDomainListRequest.h>
#include <aws/route53resolver/model/DeleteFirewallDomainListResult.h>
#include <aws/route53resolver/model/DeleteFirewallRuleGroupRequest.h>
#include <aws/route53resolver/model/DeleteFirewallRuleGroupResult.h>
#include <aws/route53resolver/model/DeleteFirewallRuleRequest.h>
#include <aws/route53resolver/model/DeleteFirewallRuleResult.h>
#include <aws/route53resolver/model/DeleteOutpostResolverRequest.h>
#include <aws/route53resolver/model/DeleteOutpostResolverResult.h>
#include <aws/route53resolver/model/DeleteResolverEndpointRequest.h>
#include <aws/route53resolver/model/DeleteResolverEndpointResult.h>
#include <aws/route53resolver/model/DeleteResolverQueryLogConfigRequest.h>
#include <aws/route53resolver/model/DeleteResolverQueryLogConfigResult.h>
#include <aws/route53resolver/model/DeleteResolverRuleRequest.h>
#include <aws/route53resolver/model/DeleteResolverRuleResult.h>
#include <aws/route53resolver/model/DisassociateFirewallRuleGroupRequest.h>
#include <aws/route53resolver/model/DisassociateFirewallRuleGroupResult.h>
#include <aws/route53resolver/model/DisassociateResolverEndpointIpAddressRequest.h>
#include <aws/route53resolver/model/DisassociateResolverEndpointIpAddressResult.h>
#include <aws/route53resolver/model/DisassociateResolverQueryLogConfigRequest.h>
#include <aws/route53resolver/model/DisassociateResolverQueryLogConfigResult.h>
#include <aws/route53resolver/model/DisassociateResolverRuleRequest.h>
#include <aws/route53resolver/model/DisassociateResolverRuleResult.h>
#include <aws/route53resolver/model/DnsThreatProtection.h>
#include <aws/route53resolver/model/Filter.h>
#include <aws/route53resolver/model/FirewallConfig.h>
#include <aws/route53resolver/model/FirewallDomainImportOperation.h>
#include <aws/route53resolver/model/FirewallDomainList.h>
#include <aws/route53resolver/model/FirewallDomainListMetadata.h>
#include <aws/route53resolver/model/FirewallDomainListStatus.h>
#include <aws/route53resolver/model/FirewallDomainRedirectionAction.h>
#include <aws/route53resolver/model/FirewallDomainUpdateOperation.h>
#include <aws/route53resolver/model/FirewallFailOpenStatus.h>
#include <aws/route53resolver/model/FirewallRule.h>
#include <aws/route53resolver/model/FirewallRuleGroup.h>
#include <aws/route53resolver/model/FirewallRuleGroupAssociation.h>
#include <aws/route53resolver/model/FirewallRuleGroupAssociationStatus.h>
#include <aws/route53resolver/model/FirewallRuleGroupMetadata.h>
#include <aws/route53resolver/model/FirewallRuleGroupStatus.h>
#include <aws/route53resolver/model/GetFirewallConfigRequest.h>
#include <aws/route53resolver/model/GetFirewallConfigResult.h>
#include <aws/route53resolver/model/GetFirewallDomainListRequest.h>
#include <aws/route53resolver/model/GetFirewallDomainListResult.h>
#include <aws/route53resolver/model/GetFirewallRuleGroupAssociationRequest.h>
#include <aws/route53resolver/model/GetFirewallRuleGroupAssociationResult.h>
#include <aws/route53resolver/model/GetFirewallRuleGroupPolicyRequest.h>
#include <aws/route53resolver/model/GetFirewallRuleGroupPolicyResult.h>
#include <aws/route53resolver/model/GetFirewallRuleGroupRequest.h>
#include <aws/route53resolver/model/GetFirewallRuleGroupResult.h>
#include <aws/route53resolver/model/GetOutpostResolverRequest.h>
#include <aws/route53resolver/model/GetOutpostResolverResult.h>
#include <aws/route53resolver/model/GetResolverConfigRequest.h>
#include <aws/route53resolver/model/GetResolverConfigResult.h>
#include <aws/route53resolver/model/GetResolverDnssecConfigRequest.h>
#include <aws/route53resolver/model/GetResolverDnssecConfigResult.h>
#include <aws/route53resolver/model/GetResolverEndpointRequest.h>
#include <aws/route53resolver/model/GetResolverEndpointResult.h>
#include <aws/route53resolver/model/GetResolverQueryLogConfigAssociationRequest.h>
#include <aws/route53resolver/model/GetResolverQueryLogConfigAssociationResult.h>
#include <aws/route53resolver/model/GetResolverQueryLogConfigPolicyRequest.h>
#include <aws/route53resolver/model/GetResolverQueryLogConfigPolicyResult.h>
#include <aws/route53resolver/model/GetResolverQueryLogConfigRequest.h>
#include <aws/route53resolver/model/GetResolverQueryLogConfigResult.h>
#include <aws/route53resolver/model/GetResolverRuleAssociationRequest.h>
#include <aws/route53resolver/model/GetResolverRuleAssociationResult.h>
#include <aws/route53resolver/model/GetResolverRulePolicyRequest.h>
#include <aws/route53resolver/model/GetResolverRulePolicyResult.h>
#include <aws/route53resolver/model/GetResolverRuleRequest.h>
#include <aws/route53resolver/model/GetResolverRuleResult.h>
#include <aws/route53resolver/model/ImportFirewallDomainsRequest.h>
#include <aws/route53resolver/model/ImportFirewallDomainsResult.h>
#include <aws/route53resolver/model/InvalidParameterException.h>
#include <aws/route53resolver/model/IpAddressRequest.h>
#include <aws/route53resolver/model/IpAddressResponse.h>
#include <aws/route53resolver/model/IpAddressStatus.h>
#include <aws/route53resolver/model/IpAddressUpdate.h>
#include <aws/route53resolver/model/LimitExceededException.h>
#include <aws/route53resolver/model/ListFirewallConfigsRequest.h>
#include <aws/route53resolver/model/ListFirewallConfigsResult.h>
#include <aws/route53resolver/model/ListFirewallDomainListsRequest.h>
#include <aws/route53resolver/model/ListFirewallDomainListsResult.h>
#include <aws/route53resolver/model/ListFirewallDomainsRequest.h>
#include <aws/route53resolver/model/ListFirewallDomainsResult.h>
#include <aws/route53resolver/model/ListFirewallRuleGroupAssociationsRequest.h>
#include <aws/route53resolver/model/ListFirewallRuleGroupAssociationsResult.h>
#include <aws/route53resolver/model/ListFirewallRuleGroupsRequest.h>
#include <aws/route53resolver/model/ListFirewallRuleGroupsResult.h>
#include <aws/route53resolver/model/ListFirewallRulesRequest.h>
#include <aws/route53resolver/model/ListFirewallRulesResult.h>
#include <aws/route53resolver/model/ListOutpostResolversRequest.h>
#include <aws/route53resolver/model/ListOutpostResolversResult.h>
#include <aws/route53resolver/model/ListResolverConfigsRequest.h>
#include <aws/route53resolver/model/ListResolverConfigsResult.h>
#include <aws/route53resolver/model/ListResolverDnssecConfigsRequest.h>
#include <aws/route53resolver/model/ListResolverDnssecConfigsResult.h>
#include <aws/route53resolver/model/ListResolverEndpointIpAddressesRequest.h>
#include <aws/route53resolver/model/ListResolverEndpointIpAddressesResult.h>
#include <aws/route53resolver/model/ListResolverEndpointsRequest.h>
#include <aws/route53resolver/model/ListResolverEndpointsResult.h>
#include <aws/route53resolver/model/ListResolverQueryLogConfigAssociationsRequest.h>
#include <aws/route53resolver/model/ListResolverQueryLogConfigAssociationsResult.h>
#include <aws/route53resolver/model/ListResolverQueryLogConfigsRequest.h>
#include <aws/route53resolver/model/ListResolverQueryLogConfigsResult.h>
#include <aws/route53resolver/model/ListResolverRuleAssociationsRequest.h>
#include <aws/route53resolver/model/ListResolverRuleAssociationsResult.h>
#include <aws/route53resolver/model/ListResolverRulesRequest.h>
#include <aws/route53resolver/model/ListResolverRulesResult.h>
#include <aws/route53resolver/model/ListTagsForResourceRequest.h>
#include <aws/route53resolver/model/ListTagsForResourceResult.h>
#include <aws/route53resolver/model/MutationProtectionStatus.h>
#include <aws/route53resolver/model/OutpostResolver.h>
#include <aws/route53resolver/model/OutpostResolverStatus.h>
#include <aws/route53resolver/model/Protocol.h>
#include <aws/route53resolver/model/PutFirewallRuleGroupPolicyRequest.h>
#include <aws/route53resolver/model/PutFirewallRuleGroupPolicyResult.h>
#include <aws/route53resolver/model/PutResolverQueryLogConfigPolicyRequest.h>
#include <aws/route53resolver/model/PutResolverQueryLogConfigPolicyResult.h>
#include <aws/route53resolver/model/PutResolverRulePolicyRequest.h>
#include <aws/route53resolver/model/PutResolverRulePolicyResult.h>
#include <aws/route53resolver/model/ResolverAutodefinedReverseStatus.h>
#include <aws/route53resolver/model/ResolverConfig.h>
#include <aws/route53resolver/model/ResolverDNSSECValidationStatus.h>
#include <aws/route53resolver/model/ResolverDnssecConfig.h>
#include <aws/route53resolver/model/ResolverEndpoint.h>
#include <aws/route53resolver/model/ResolverEndpointDirection.h>
#include <aws/route53resolver/model/ResolverEndpointStatus.h>
#include <aws/route53resolver/model/ResolverEndpointType.h>
#include <aws/route53resolver/model/ResolverQueryLogConfig.h>
#include <aws/route53resolver/model/ResolverQueryLogConfigAssociation.h>
#include <aws/route53resolver/model/ResolverQueryLogConfigAssociationError.h>
#include <aws/route53resolver/model/ResolverQueryLogConfigAssociationStatus.h>
#include <aws/route53resolver/model/ResolverQueryLogConfigStatus.h>
#include <aws/route53resolver/model/ResolverRule.h>
#include <aws/route53resolver/model/ResolverRuleAssociation.h>
#include <aws/route53resolver/model/ResolverRuleAssociationStatus.h>
#include <aws/route53resolver/model/ResolverRuleConfig.h>
#include <aws/route53resolver/model/ResolverRuleStatus.h>
#include <aws/route53resolver/model/ResourceExistsException.h>
#include <aws/route53resolver/model/ResourceInUseException.h>
#include <aws/route53resolver/model/ResourceNotFoundException.h>
#include <aws/route53resolver/model/ResourceUnavailableException.h>
#include <aws/route53resolver/model/RuleTypeOption.h>
#include <aws/route53resolver/model/ShareStatus.h>
#include <aws/route53resolver/model/SortOrder.h>
#include <aws/route53resolver/model/Tag.h>
#include <aws/route53resolver/model/TagResourceRequest.h>
#include <aws/route53resolver/model/TagResourceResult.h>
#include <aws/route53resolver/model/TargetAddress.h>
#include <aws/route53resolver/model/UntagResourceRequest.h>
#include <aws/route53resolver/model/UntagResourceResult.h>
#include <aws/route53resolver/model/UpdateFirewallConfigRequest.h>
#include <aws/route53resolver/model/UpdateFirewallConfigResult.h>
#include <aws/route53resolver/model/UpdateFirewallDomainsRequest.h>
#include <aws/route53resolver/model/UpdateFirewallDomainsResult.h>
#include <aws/route53resolver/model/UpdateFirewallRuleGroupAssociationRequest.h>
#include <aws/route53resolver/model/UpdateFirewallRuleGroupAssociationResult.h>
#include <aws/route53resolver/model/UpdateFirewallRuleRequest.h>
#include <aws/route53resolver/model/UpdateFirewallRuleResult.h>
#include <aws/route53resolver/model/UpdateIpAddress.h>
#include <aws/route53resolver/model/UpdateOutpostResolverRequest.h>
#include <aws/route53resolver/model/UpdateOutpostResolverResult.h>
#include <aws/route53resolver/model/UpdateResolverConfigRequest.h>
#include <aws/route53resolver/model/UpdateResolverConfigResult.h>
#include <aws/route53resolver/model/UpdateResolverDnssecConfigRequest.h>
#include <aws/route53resolver/model/UpdateResolverDnssecConfigResult.h>
#include <aws/route53resolver/model/UpdateResolverEndpointRequest.h>
#include <aws/route53resolver/model/UpdateResolverEndpointResult.h>
#include <aws/route53resolver/model/UpdateResolverRuleRequest.h>
#include <aws/route53resolver/model/UpdateResolverRuleResult.h>
#include <aws/route53resolver/model/Validation.h>

using Route53ResolverIncludeTest = ::testing::Test;

TEST_F(Route53ResolverIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Route53Resolver::Route53ResolverClient>("Route53ResolverIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
