/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/s3-crt/ClientConfiguration.h>
#include <aws/s3-crt/S3CrtClient.h>
#include <aws/s3-crt/S3CrtClientConfiguration.h>
#include <aws/s3-crt/S3CrtEndpointProvider.h>
#include <aws/s3-crt/S3CrtEndpointRules.h>
#include <aws/s3-crt/S3CrtErrorMarshaller.h>
#include <aws/s3-crt/S3CrtErrors.h>
#include <aws/s3-crt/S3CrtIdentityProviderAdapter.h>
#include <aws/s3-crt/S3CrtRequest.h>
#include <aws/s3-crt/S3CrtServiceClientModel.h>
#include <aws/s3-crt/S3Crt_EXPORTS.h>
#include <aws/s3-crt/S3ExpressIdentity.h>
#include <aws/s3-crt/S3ExpressIdentityProvider.h>
#include <aws/s3-crt/S3ExpressSigner.h>
#include <aws/s3-crt/S3ExpressSignerProvider.h>
#include <aws/s3-crt/model/AbortIncompleteMultipartUpload.h>
#include <aws/s3-crt/model/AbortMultipartUploadRequest.h>
#include <aws/s3-crt/model/AbortMultipartUploadResult.h>
#include <aws/s3-crt/model/AccelerateConfiguration.h>
#include <aws/s3-crt/model/AccessControlPolicy.h>
#include <aws/s3-crt/model/AccessControlTranslation.h>
#include <aws/s3-crt/model/AnalyticsAndOperator.h>
#include <aws/s3-crt/model/AnalyticsConfiguration.h>
#include <aws/s3-crt/model/AnalyticsExportDestination.h>
#include <aws/s3-crt/model/AnalyticsFilter.h>
#include <aws/s3-crt/model/AnalyticsS3BucketDestination.h>
#include <aws/s3-crt/model/AnalyticsS3ExportFileFormat.h>
#include <aws/s3-crt/model/ArchiveStatus.h>
#include <aws/s3-crt/model/Bucket.h>
#include <aws/s3-crt/model/BucketAccelerateStatus.h>
#include <aws/s3-crt/model/BucketCannedACL.h>
#include <aws/s3-crt/model/BucketInfo.h>
#include <aws/s3-crt/model/BucketLifecycleConfiguration.h>
#include <aws/s3-crt/model/BucketLocationConstraint.h>
#include <aws/s3-crt/model/BucketLoggingStatus.h>
#include <aws/s3-crt/model/BucketLogsPermission.h>
#include <aws/s3-crt/model/BucketType.h>
#include <aws/s3-crt/model/BucketVersioningStatus.h>
#include <aws/s3-crt/model/CORSConfiguration.h>
#include <aws/s3-crt/model/CORSRule.h>
#include <aws/s3-crt/model/CSVInput.h>
#include <aws/s3-crt/model/CSVOutput.h>
#include <aws/s3-crt/model/Checksum.h>
#include <aws/s3-crt/model/ChecksumAlgorithm.h>
#include <aws/s3-crt/model/ChecksumMode.h>
#include <aws/s3-crt/model/ChecksumType.h>
#include <aws/s3-crt/model/CloudFunctionConfiguration.h>
#include <aws/s3-crt/model/CommonPrefix.h>
#include <aws/s3-crt/model/CompleteMultipartUploadRequest.h>
#include <aws/s3-crt/model/CompleteMultipartUploadResult.h>
#include <aws/s3-crt/model/CompletedMultipartUpload.h>
#include <aws/s3-crt/model/CompletedPart.h>
#include <aws/s3-crt/model/CompressionType.h>
#include <aws/s3-crt/model/Condition.h>
#include <aws/s3-crt/model/CopyObjectRequest.h>
#include <aws/s3-crt/model/CopyObjectResult.h>
#include <aws/s3-crt/model/CopyObjectResultDetails.h>
#include <aws/s3-crt/model/CopyPartResult.h>
#include <aws/s3-crt/model/CreateBucketConfiguration.h>
#include <aws/s3-crt/model/CreateBucketMetadataTableConfigurationRequest.h>
#include <aws/s3-crt/model/CreateBucketRequest.h>
#include <aws/s3-crt/model/CreateBucketResult.h>
#include <aws/s3-crt/model/CreateMultipartUploadRequest.h>
#include <aws/s3-crt/model/CreateMultipartUploadResult.h>
#include <aws/s3-crt/model/CreateSessionRequest.h>
#include <aws/s3-crt/model/CreateSessionResult.h>
#include <aws/s3-crt/model/DataRedundancy.h>
#include <aws/s3-crt/model/DefaultRetention.h>
#include <aws/s3-crt/model/Delete.h>
#include <aws/s3-crt/model/DeleteBucketAnalyticsConfigurationRequest.h>
#include <aws/s3-crt/model/DeleteBucketCorsRequest.h>
#include <aws/s3-crt/model/DeleteBucketEncryptionRequest.h>
#include <aws/s3-crt/model/DeleteBucketIntelligentTieringConfigurationRequest.h>
#include <aws/s3-crt/model/DeleteBucketInventoryConfigurationRequest.h>
#include <aws/s3-crt/model/DeleteBucketLifecycleRequest.h>
#include <aws/s3-crt/model/DeleteBucketMetadataTableConfigurationRequest.h>
#include <aws/s3-crt/model/DeleteBucketMetricsConfigurationRequest.h>
#include <aws/s3-crt/model/DeleteBucketOwnershipControlsRequest.h>
#include <aws/s3-crt/model/DeleteBucketPolicyRequest.h>
#include <aws/s3-crt/model/DeleteBucketReplicationRequest.h>
#include <aws/s3-crt/model/DeleteBucketRequest.h>
#include <aws/s3-crt/model/DeleteBucketTaggingRequest.h>
#include <aws/s3-crt/model/DeleteBucketWebsiteRequest.h>
#include <aws/s3-crt/model/DeleteMarkerEntry.h>
#include <aws/s3-crt/model/DeleteMarkerReplication.h>
#include <aws/s3-crt/model/DeleteMarkerReplicationStatus.h>
#include <aws/s3-crt/model/DeleteObjectRequest.h>
#include <aws/s3-crt/model/DeleteObjectResult.h>
#include <aws/s3-crt/model/DeleteObjectTaggingRequest.h>
#include <aws/s3-crt/model/DeleteObjectTaggingResult.h>
#include <aws/s3-crt/model/DeleteObjectsRequest.h>
#include <aws/s3-crt/model/DeleteObjectsResult.h>
#include <aws/s3-crt/model/DeletePublicAccessBlockRequest.h>
#include <aws/s3-crt/model/DeletedObject.h>
#include <aws/s3-crt/model/Destination.h>
#include <aws/s3-crt/model/EncodingType.h>
#include <aws/s3-crt/model/Encryption.h>
#include <aws/s3-crt/model/EncryptionConfiguration.h>
#include <aws/s3-crt/model/Error.h>
#include <aws/s3-crt/model/ErrorDetails.h>
#include <aws/s3-crt/model/ErrorDocument.h>
#include <aws/s3-crt/model/Event.h>
#include <aws/s3-crt/model/EventBridgeConfiguration.h>
#include <aws/s3-crt/model/ExistingObjectReplication.h>
#include <aws/s3-crt/model/ExistingObjectReplicationStatus.h>
#include <aws/s3-crt/model/ExpirationStatus.h>
#include <aws/s3-crt/model/ExpressionType.h>
#include <aws/s3-crt/model/FileHeaderInfo.h>
#include <aws/s3-crt/model/FilterRule.h>
#include <aws/s3-crt/model/FilterRuleName.h>
#include <aws/s3-crt/model/GetBucketAccelerateConfigurationRequest.h>
#include <aws/s3-crt/model/GetBucketAccelerateConfigurationResult.h>
#include <aws/s3-crt/model/GetBucketAclRequest.h>
#include <aws/s3-crt/model/GetBucketAclResult.h>
#include <aws/s3-crt/model/GetBucketAnalyticsConfigurationRequest.h>
#include <aws/s3-crt/model/GetBucketAnalyticsConfigurationResult.h>
#include <aws/s3-crt/model/GetBucketCorsRequest.h>
#include <aws/s3-crt/model/GetBucketCorsResult.h>
#include <aws/s3-crt/model/GetBucketEncryptionRequest.h>
#include <aws/s3-crt/model/GetBucketEncryptionResult.h>
#include <aws/s3-crt/model/GetBucketIntelligentTieringConfigurationRequest.h>
#include <aws/s3-crt/model/GetBucketIntelligentTieringConfigurationResult.h>
#include <aws/s3-crt/model/GetBucketInventoryConfigurationRequest.h>
#include <aws/s3-crt/model/GetBucketInventoryConfigurationResult.h>
#include <aws/s3-crt/model/GetBucketLifecycleConfigurationRequest.h>
#include <aws/s3-crt/model/GetBucketLifecycleConfigurationResult.h>
#include <aws/s3-crt/model/GetBucketLocationRequest.h>
#include <aws/s3-crt/model/GetBucketLocationResult.h>
#include <aws/s3-crt/model/GetBucketLoggingRequest.h>
#include <aws/s3-crt/model/GetBucketLoggingResult.h>
#include <aws/s3-crt/model/GetBucketMetadataTableConfigurationRequest.h>
#include <aws/s3-crt/model/GetBucketMetadataTableConfigurationResult.h>
#include <aws/s3-crt/model/GetBucketMetadataTableConfigurationSdkResult.h>
#include <aws/s3-crt/model/GetBucketMetricsConfigurationRequest.h>
#include <aws/s3-crt/model/GetBucketMetricsConfigurationResult.h>
#include <aws/s3-crt/model/GetBucketNotificationConfigurationRequest.h>
#include <aws/s3-crt/model/GetBucketNotificationConfigurationResult.h>
#include <aws/s3-crt/model/GetBucketOwnershipControlsRequest.h>
#include <aws/s3-crt/model/GetBucketOwnershipControlsResult.h>
#include <aws/s3-crt/model/GetBucketPolicyRequest.h>
#include <aws/s3-crt/model/GetBucketPolicyResult.h>
#include <aws/s3-crt/model/GetBucketPolicyStatusRequest.h>
#include <aws/s3-crt/model/GetBucketPolicyStatusResult.h>
#include <aws/s3-crt/model/GetBucketReplicationRequest.h>
#include <aws/s3-crt/model/GetBucketReplicationResult.h>
#include <aws/s3-crt/model/GetBucketRequestPaymentRequest.h>
#include <aws/s3-crt/model/GetBucketRequestPaymentResult.h>
#include <aws/s3-crt/model/GetBucketTaggingRequest.h>
#include <aws/s3-crt/model/GetBucketTaggingResult.h>
#include <aws/s3-crt/model/GetBucketVersioningRequest.h>
#include <aws/s3-crt/model/GetBucketVersioningResult.h>
#include <aws/s3-crt/model/GetBucketWebsiteRequest.h>
#include <aws/s3-crt/model/GetBucketWebsiteResult.h>
#include <aws/s3-crt/model/GetObjectAclRequest.h>
#include <aws/s3-crt/model/GetObjectAclResult.h>
#include <aws/s3-crt/model/GetObjectAttributesParts.h>
#include <aws/s3-crt/model/GetObjectAttributesRequest.h>
#include <aws/s3-crt/model/GetObjectAttributesResult.h>
#include <aws/s3-crt/model/GetObjectLegalHoldRequest.h>
#include <aws/s3-crt/model/GetObjectLegalHoldResult.h>
#include <aws/s3-crt/model/GetObjectLockConfigurationRequest.h>
#include <aws/s3-crt/model/GetObjectLockConfigurationResult.h>
#include <aws/s3-crt/model/GetObjectRequest.h>
#include <aws/s3-crt/model/GetObjectResult.h>
#include <aws/s3-crt/model/GetObjectRetentionRequest.h>
#include <aws/s3-crt/model/GetObjectRetentionResult.h>
#include <aws/s3-crt/model/GetObjectTaggingRequest.h>
#include <aws/s3-crt/model/GetObjectTaggingResult.h>
#include <aws/s3-crt/model/GetObjectTorrentRequest.h>
#include <aws/s3-crt/model/GetObjectTorrentResult.h>
#include <aws/s3-crt/model/GetPublicAccessBlockRequest.h>
#include <aws/s3-crt/model/GetPublicAccessBlockResult.h>
#include <aws/s3-crt/model/GlacierJobParameters.h>
#include <aws/s3-crt/model/Grant.h>
#include <aws/s3-crt/model/Grantee.h>
#include <aws/s3-crt/model/HeadBucketRequest.h>
#include <aws/s3-crt/model/HeadBucketResult.h>
#include <aws/s3-crt/model/HeadObjectRequest.h>
#include <aws/s3-crt/model/HeadObjectResult.h>
#include <aws/s3-crt/model/IndexDocument.h>
#include <aws/s3-crt/model/Initiator.h>
#include <aws/s3-crt/model/InputSerialization.h>
#include <aws/s3-crt/model/IntelligentTieringAccessTier.h>
#include <aws/s3-crt/model/IntelligentTieringAndOperator.h>
#include <aws/s3-crt/model/IntelligentTieringConfiguration.h>
#include <aws/s3-crt/model/IntelligentTieringFilter.h>
#include <aws/s3-crt/model/IntelligentTieringStatus.h>
#include <aws/s3-crt/model/InvalidObjectState.h>
#include <aws/s3-crt/model/InventoryConfiguration.h>
#include <aws/s3-crt/model/InventoryDestination.h>
#include <aws/s3-crt/model/InventoryEncryption.h>
#include <aws/s3-crt/model/InventoryFilter.h>
#include <aws/s3-crt/model/InventoryFormat.h>
#include <aws/s3-crt/model/InventoryFrequency.h>
#include <aws/s3-crt/model/InventoryIncludedObjectVersions.h>
#include <aws/s3-crt/model/InventoryOptionalField.h>
#include <aws/s3-crt/model/InventoryS3BucketDestination.h>
#include <aws/s3-crt/model/InventorySchedule.h>
#include <aws/s3-crt/model/JSONInput.h>
#include <aws/s3-crt/model/JSONOutput.h>
#include <aws/s3-crt/model/JSONType.h>
#include <aws/s3-crt/model/LambdaFunctionConfiguration.h>
#include <aws/s3-crt/model/LifecycleConfiguration.h>
#include <aws/s3-crt/model/LifecycleExpiration.h>
#include <aws/s3-crt/model/LifecycleRule.h>
#include <aws/s3-crt/model/LifecycleRuleAndOperator.h>
#include <aws/s3-crt/model/LifecycleRuleFilter.h>
#include <aws/s3-crt/model/ListBucketAnalyticsConfigurationsRequest.h>
#include <aws/s3-crt/model/ListBucketAnalyticsConfigurationsResult.h>
#include <aws/s3-crt/model/ListBucketIntelligentTieringConfigurationsRequest.h>
#include <aws/s3-crt/model/ListBucketIntelligentTieringConfigurationsResult.h>
#include <aws/s3-crt/model/ListBucketInventoryConfigurationsRequest.h>
#include <aws/s3-crt/model/ListBucketInventoryConfigurationsResult.h>
#include <aws/s3-crt/model/ListBucketMetricsConfigurationsRequest.h>
#include <aws/s3-crt/model/ListBucketMetricsConfigurationsResult.h>
#include <aws/s3-crt/model/ListBucketsRequest.h>
#include <aws/s3-crt/model/ListBucketsResult.h>
#include <aws/s3-crt/model/ListDirectoryBucketsRequest.h>
#include <aws/s3-crt/model/ListDirectoryBucketsResult.h>
#include <aws/s3-crt/model/ListMultipartUploadsRequest.h>
#include <aws/s3-crt/model/ListMultipartUploadsResult.h>
#include <aws/s3-crt/model/ListObjectVersionsRequest.h>
#include <aws/s3-crt/model/ListObjectVersionsResult.h>
#include <aws/s3-crt/model/ListObjectsRequest.h>
#include <aws/s3-crt/model/ListObjectsResult.h>
#include <aws/s3-crt/model/ListObjectsV2Request.h>
#include <aws/s3-crt/model/ListObjectsV2Result.h>
#include <aws/s3-crt/model/ListPartsRequest.h>
#include <aws/s3-crt/model/ListPartsResult.h>
#include <aws/s3-crt/model/LocationInfo.h>
#include <aws/s3-crt/model/LocationType.h>
#include <aws/s3-crt/model/LoggingEnabled.h>
#include <aws/s3-crt/model/MFADelete.h>
#include <aws/s3-crt/model/MFADeleteStatus.h>
#include <aws/s3-crt/model/MetadataDirective.h>
#include <aws/s3-crt/model/MetadataEntry.h>
#include <aws/s3-crt/model/MetadataTableConfiguration.h>
#include <aws/s3-crt/model/MetadataTableConfigurationResult.h>
#include <aws/s3-crt/model/Metrics.h>
#include <aws/s3-crt/model/MetricsAndOperator.h>
#include <aws/s3-crt/model/MetricsConfiguration.h>
#include <aws/s3-crt/model/MetricsFilter.h>
#include <aws/s3-crt/model/MetricsStatus.h>
#include <aws/s3-crt/model/MultipartUpload.h>
#include <aws/s3-crt/model/NoncurrentVersionExpiration.h>
#include <aws/s3-crt/model/NoncurrentVersionTransition.h>
#include <aws/s3-crt/model/NotificationConfiguration.h>
#include <aws/s3-crt/model/NotificationConfigurationDeprecated.h>
#include <aws/s3-crt/model/NotificationConfigurationFilter.h>
#include <aws/s3-crt/model/Object.h>
#include <aws/s3-crt/model/ObjectAttributes.h>
#include <aws/s3-crt/model/ObjectCannedACL.h>
#include <aws/s3-crt/model/ObjectIdentifier.h>
#include <aws/s3-crt/model/ObjectLockConfiguration.h>
#include <aws/s3-crt/model/ObjectLockEnabled.h>
#include <aws/s3-crt/model/ObjectLockLegalHold.h>
#include <aws/s3-crt/model/ObjectLockLegalHoldStatus.h>
#include <aws/s3-crt/model/ObjectLockMode.h>
#include <aws/s3-crt/model/ObjectLockRetention.h>
#include <aws/s3-crt/model/ObjectLockRetentionMode.h>
#include <aws/s3-crt/model/ObjectLockRule.h>
#include <aws/s3-crt/model/ObjectOwnership.h>
#include <aws/s3-crt/model/ObjectPart.h>
#include <aws/s3-crt/model/ObjectStorageClass.h>
#include <aws/s3-crt/model/ObjectVersion.h>
#include <aws/s3-crt/model/ObjectVersionStorageClass.h>
#include <aws/s3-crt/model/OptionalObjectAttributes.h>
#include <aws/s3-crt/model/OutputLocation.h>
#include <aws/s3-crt/model/OutputSerialization.h>
#include <aws/s3-crt/model/Owner.h>
#include <aws/s3-crt/model/OwnerOverride.h>
#include <aws/s3-crt/model/OwnershipControls.h>
#include <aws/s3-crt/model/OwnershipControlsRule.h>
#include <aws/s3-crt/model/ParquetInput.h>
#include <aws/s3-crt/model/Part.h>
#include <aws/s3-crt/model/PartitionDateSource.h>
#include <aws/s3-crt/model/PartitionedPrefix.h>
#include <aws/s3-crt/model/Payer.h>
#include <aws/s3-crt/model/Permission.h>
#include <aws/s3-crt/model/PolicyStatus.h>
#include <aws/s3-crt/model/Progress.h>
#include <aws/s3-crt/model/ProgressEvent.h>
#include <aws/s3-crt/model/Protocol.h>
#include <aws/s3-crt/model/PublicAccessBlockConfiguration.h>
#include <aws/s3-crt/model/PutBucketAccelerateConfigurationRequest.h>
#include <aws/s3-crt/model/PutBucketAclRequest.h>
#include <aws/s3-crt/model/PutBucketAnalyticsConfigurationRequest.h>
#include <aws/s3-crt/model/PutBucketCorsRequest.h>
#include <aws/s3-crt/model/PutBucketEncryptionRequest.h>
#include <aws/s3-crt/model/PutBucketIntelligentTieringConfigurationRequest.h>
#include <aws/s3-crt/model/PutBucketInventoryConfigurationRequest.h>
#include <aws/s3-crt/model/PutBucketLifecycleConfigurationRequest.h>
#include <aws/s3-crt/model/PutBucketLifecycleConfigurationResult.h>
#include <aws/s3-crt/model/PutBucketLoggingRequest.h>
#include <aws/s3-crt/model/PutBucketMetricsConfigurationRequest.h>
#include <aws/s3-crt/model/PutBucketNotificationConfigurationRequest.h>
#include <aws/s3-crt/model/PutBucketOwnershipControlsRequest.h>
#include <aws/s3-crt/model/PutBucketPolicyRequest.h>
#include <aws/s3-crt/model/PutBucketReplicationRequest.h>
#include <aws/s3-crt/model/PutBucketRequestPaymentRequest.h>
#include <aws/s3-crt/model/PutBucketTaggingRequest.h>
#include <aws/s3-crt/model/PutBucketVersioningRequest.h>
#include <aws/s3-crt/model/PutBucketWebsiteRequest.h>
#include <aws/s3-crt/model/PutObjectAclRequest.h>
#include <aws/s3-crt/model/PutObjectAclResult.h>
#include <aws/s3-crt/model/PutObjectLegalHoldRequest.h>
#include <aws/s3-crt/model/PutObjectLegalHoldResult.h>
#include <aws/s3-crt/model/PutObjectLockConfigurationRequest.h>
#include <aws/s3-crt/model/PutObjectLockConfigurationResult.h>
#include <aws/s3-crt/model/PutObjectRequest.h>
#include <aws/s3-crt/model/PutObjectResult.h>
#include <aws/s3-crt/model/PutObjectRetentionRequest.h>
#include <aws/s3-crt/model/PutObjectRetentionResult.h>
#include <aws/s3-crt/model/PutObjectTaggingRequest.h>
#include <aws/s3-crt/model/PutObjectTaggingResult.h>
#include <aws/s3-crt/model/PutPublicAccessBlockRequest.h>
#include <aws/s3-crt/model/QueueConfiguration.h>
#include <aws/s3-crt/model/QueueConfigurationDeprecated.h>
#include <aws/s3-crt/model/QuoteFields.h>
#include <aws/s3-crt/model/RecordsEvent.h>
#include <aws/s3-crt/model/Redirect.h>
#include <aws/s3-crt/model/RedirectAllRequestsTo.h>
#include <aws/s3-crt/model/RenameObjectRequest.h>
#include <aws/s3-crt/model/RenameObjectResult.h>
#include <aws/s3-crt/model/ReplicaModifications.h>
#include <aws/s3-crt/model/ReplicaModificationsStatus.h>
#include <aws/s3-crt/model/ReplicationConfiguration.h>
#include <aws/s3-crt/model/ReplicationRule.h>
#include <aws/s3-crt/model/ReplicationRuleAndOperator.h>
#include <aws/s3-crt/model/ReplicationRuleFilter.h>
#include <aws/s3-crt/model/ReplicationRuleStatus.h>
#include <aws/s3-crt/model/ReplicationStatus.h>
#include <aws/s3-crt/model/ReplicationTime.h>
#include <aws/s3-crt/model/ReplicationTimeStatus.h>
#include <aws/s3-crt/model/ReplicationTimeValue.h>
#include <aws/s3-crt/model/RequestCharged.h>
#include <aws/s3-crt/model/RequestPayer.h>
#include <aws/s3-crt/model/RequestPaymentConfiguration.h>
#include <aws/s3-crt/model/RequestProgress.h>
#include <aws/s3-crt/model/RestoreObjectRequest.h>
#include <aws/s3-crt/model/RestoreObjectResult.h>
#include <aws/s3-crt/model/RestoreRequest.h>
#include <aws/s3-crt/model/RestoreRequestType.h>
#include <aws/s3-crt/model/RestoreStatus.h>
#include <aws/s3-crt/model/RoutingRule.h>
#include <aws/s3-crt/model/Rule.h>
#include <aws/s3-crt/model/S3KeyFilter.h>
#include <aws/s3-crt/model/S3Location.h>
#include <aws/s3-crt/model/S3TablesDestination.h>
#include <aws/s3-crt/model/S3TablesDestinationResult.h>
#include <aws/s3-crt/model/SSEKMS.h>
#include <aws/s3-crt/model/SSES3.h>
#include <aws/s3-crt/model/ScanRange.h>
#include <aws/s3-crt/model/SelectObjectContentHandler.h>
#include <aws/s3-crt/model/SelectObjectContentInitialResponse.h>
#include <aws/s3-crt/model/SelectObjectContentRequest.h>
#include <aws/s3-crt/model/SelectParameters.h>
#include <aws/s3-crt/model/ServerSideEncryption.h>
#include <aws/s3-crt/model/ServerSideEncryptionByDefault.h>
#include <aws/s3-crt/model/ServerSideEncryptionConfiguration.h>
#include <aws/s3-crt/model/ServerSideEncryptionRule.h>
#include <aws/s3-crt/model/SessionCredentials.h>
#include <aws/s3-crt/model/SessionMode.h>
#include <aws/s3-crt/model/SimplePrefix.h>
#include <aws/s3-crt/model/SourceSelectionCriteria.h>
#include <aws/s3-crt/model/SseKmsEncryptedObjects.h>
#include <aws/s3-crt/model/SseKmsEncryptedObjectsStatus.h>
#include <aws/s3-crt/model/Stats.h>
#include <aws/s3-crt/model/StatsEvent.h>
#include <aws/s3-crt/model/StorageClass.h>
#include <aws/s3-crt/model/StorageClassAnalysis.h>
#include <aws/s3-crt/model/StorageClassAnalysisDataExport.h>
#include <aws/s3-crt/model/StorageClassAnalysisSchemaVersion.h>
#include <aws/s3-crt/model/Tag.h>
#include <aws/s3-crt/model/Tagging.h>
#include <aws/s3-crt/model/TaggingDirective.h>
#include <aws/s3-crt/model/TargetGrant.h>
#include <aws/s3-crt/model/TargetObjectKeyFormat.h>
#include <aws/s3-crt/model/Tier.h>
#include <aws/s3-crt/model/Tiering.h>
#include <aws/s3-crt/model/TopicConfiguration.h>
#include <aws/s3-crt/model/TopicConfigurationDeprecated.h>
#include <aws/s3-crt/model/Transition.h>
#include <aws/s3-crt/model/TransitionDefaultMinimumObjectSize.h>
#include <aws/s3-crt/model/TransitionStorageClass.h>
#include <aws/s3-crt/model/Type.h>
#include <aws/s3-crt/model/UploadPartCopyRequest.h>
#include <aws/s3-crt/model/UploadPartCopyResult.h>
#include <aws/s3-crt/model/UploadPartRequest.h>
#include <aws/s3-crt/model/UploadPartResult.h>
#include <aws/s3-crt/model/VersioningConfiguration.h>
#include <aws/s3-crt/model/WebsiteConfiguration.h>
#include <aws/s3-crt/model/WriteGetObjectResponseRequest.h>

using S3CrtIncludeTest = ::testing::Test;

TEST_F(S3CrtIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::S3Crt::S3CrtClient>("S3CrtIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
