/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/s3/S3Client.h>
#include <aws/s3/S3ClientConfiguration.h>
#include <aws/s3/S3EndpointProvider.h>
#include <aws/s3/S3EndpointRules.h>
#include <aws/s3/S3ErrorMarshaller.h>
#include <aws/s3/S3Errors.h>
#include <aws/s3/S3ExpressIdentity.h>
#include <aws/s3/S3ExpressIdentityProvider.h>
#include <aws/s3/S3ExpressSigner.h>
#include <aws/s3/S3ExpressSignerProvider.h>
#include <aws/s3/S3Request.h>
#include <aws/s3/S3ServiceClientModel.h>
#include <aws/s3/S3_EXPORTS.h>
#include <aws/s3/model/AbortIncompleteMultipartUpload.h>
#include <aws/s3/model/AbortMultipartUploadRequest.h>
#include <aws/s3/model/AbortMultipartUploadResult.h>
#include <aws/s3/model/AccelerateConfiguration.h>
#include <aws/s3/model/AccessControlPolicy.h>
#include <aws/s3/model/AccessControlTranslation.h>
#include <aws/s3/model/AnalyticsAndOperator.h>
#include <aws/s3/model/AnalyticsConfiguration.h>
#include <aws/s3/model/AnalyticsExportDestination.h>
#include <aws/s3/model/AnalyticsFilter.h>
#include <aws/s3/model/AnalyticsS3BucketDestination.h>
#include <aws/s3/model/AnalyticsS3ExportFileFormat.h>
#include <aws/s3/model/ArchiveStatus.h>
#include <aws/s3/model/Bucket.h>
#include <aws/s3/model/BucketAccelerateStatus.h>
#include <aws/s3/model/BucketCannedACL.h>
#include <aws/s3/model/BucketInfo.h>
#include <aws/s3/model/BucketLifecycleConfiguration.h>
#include <aws/s3/model/BucketLocationConstraint.h>
#include <aws/s3/model/BucketLoggingStatus.h>
#include <aws/s3/model/BucketLogsPermission.h>
#include <aws/s3/model/BucketType.h>
#include <aws/s3/model/BucketVersioningStatus.h>
#include <aws/s3/model/CORSConfiguration.h>
#include <aws/s3/model/CORSRule.h>
#include <aws/s3/model/CSVInput.h>
#include <aws/s3/model/CSVOutput.h>
#include <aws/s3/model/Checksum.h>
#include <aws/s3/model/ChecksumAlgorithm.h>
#include <aws/s3/model/ChecksumMode.h>
#include <aws/s3/model/ChecksumType.h>
#include <aws/s3/model/CloudFunctionConfiguration.h>
#include <aws/s3/model/CommonPrefix.h>
#include <aws/s3/model/CompleteMultipartUploadRequest.h>
#include <aws/s3/model/CompleteMultipartUploadResult.h>
#include <aws/s3/model/CompletedMultipartUpload.h>
#include <aws/s3/model/CompletedPart.h>
#include <aws/s3/model/CompressionType.h>
#include <aws/s3/model/Condition.h>
#include <aws/s3/model/CopyObjectRequest.h>
#include <aws/s3/model/CopyObjectResult.h>
#include <aws/s3/model/CopyObjectResultDetails.h>
#include <aws/s3/model/CopyPartResult.h>
#include <aws/s3/model/CreateBucketConfiguration.h>
#include <aws/s3/model/CreateBucketMetadataTableConfigurationRequest.h>
#include <aws/s3/model/CreateBucketRequest.h>
#include <aws/s3/model/CreateBucketResult.h>
#include <aws/s3/model/CreateMultipartUploadRequest.h>
#include <aws/s3/model/CreateMultipartUploadResult.h>
#include <aws/s3/model/CreateSessionRequest.h>
#include <aws/s3/model/CreateSessionResult.h>
#include <aws/s3/model/DataRedundancy.h>
#include <aws/s3/model/DefaultRetention.h>
#include <aws/s3/model/Delete.h>
#include <aws/s3/model/DeleteBucketAnalyticsConfigurationRequest.h>
#include <aws/s3/model/DeleteBucketCorsRequest.h>
#include <aws/s3/model/DeleteBucketEncryptionRequest.h>
#include <aws/s3/model/DeleteBucketIntelligentTieringConfigurationRequest.h>
#include <aws/s3/model/DeleteBucketInventoryConfigurationRequest.h>
#include <aws/s3/model/DeleteBucketLifecycleRequest.h>
#include <aws/s3/model/DeleteBucketMetadataTableConfigurationRequest.h>
#include <aws/s3/model/DeleteBucketMetricsConfigurationRequest.h>
#include <aws/s3/model/DeleteBucketOwnershipControlsRequest.h>
#include <aws/s3/model/DeleteBucketPolicyRequest.h>
#include <aws/s3/model/DeleteBucketReplicationRequest.h>
#include <aws/s3/model/DeleteBucketRequest.h>
#include <aws/s3/model/DeleteBucketTaggingRequest.h>
#include <aws/s3/model/DeleteBucketWebsiteRequest.h>
#include <aws/s3/model/DeleteMarkerEntry.h>
#include <aws/s3/model/DeleteMarkerReplication.h>
#include <aws/s3/model/DeleteMarkerReplicationStatus.h>
#include <aws/s3/model/DeleteObjectRequest.h>
#include <aws/s3/model/DeleteObjectResult.h>
#include <aws/s3/model/DeleteObjectTaggingRequest.h>
#include <aws/s3/model/DeleteObjectTaggingResult.h>
#include <aws/s3/model/DeleteObjectsRequest.h>
#include <aws/s3/model/DeleteObjectsResult.h>
#include <aws/s3/model/DeletePublicAccessBlockRequest.h>
#include <aws/s3/model/DeletedObject.h>
#include <aws/s3/model/Destination.h>
#include <aws/s3/model/EncodingType.h>
#include <aws/s3/model/Encryption.h>
#include <aws/s3/model/EncryptionConfiguration.h>
#include <aws/s3/model/Error.h>
#include <aws/s3/model/ErrorDetails.h>
#include <aws/s3/model/ErrorDocument.h>
#include <aws/s3/model/Event.h>
#include <aws/s3/model/EventBridgeConfiguration.h>
#include <aws/s3/model/ExistingObjectReplication.h>
#include <aws/s3/model/ExistingObjectReplicationStatus.h>
#include <aws/s3/model/ExpirationStatus.h>
#include <aws/s3/model/ExpressionType.h>
#include <aws/s3/model/FileHeaderInfo.h>
#include <aws/s3/model/FilterRule.h>
#include <aws/s3/model/FilterRuleName.h>
#include <aws/s3/model/GetBucketAccelerateConfigurationRequest.h>
#include <aws/s3/model/GetBucketAccelerateConfigurationResult.h>
#include <aws/s3/model/GetBucketAclRequest.h>
#include <aws/s3/model/GetBucketAclResult.h>
#include <aws/s3/model/GetBucketAnalyticsConfigurationRequest.h>
#include <aws/s3/model/GetBucketAnalyticsConfigurationResult.h>
#include <aws/s3/model/GetBucketCorsRequest.h>
#include <aws/s3/model/GetBucketCorsResult.h>
#include <aws/s3/model/GetBucketEncryptionRequest.h>
#include <aws/s3/model/GetBucketEncryptionResult.h>
#include <aws/s3/model/GetBucketIntelligentTieringConfigurationRequest.h>
#include <aws/s3/model/GetBucketIntelligentTieringConfigurationResult.h>
#include <aws/s3/model/GetBucketInventoryConfigurationRequest.h>
#include <aws/s3/model/GetBucketInventoryConfigurationResult.h>
#include <aws/s3/model/GetBucketLifecycleConfigurationRequest.h>
#include <aws/s3/model/GetBucketLifecycleConfigurationResult.h>
#include <aws/s3/model/GetBucketLocationRequest.h>
#include <aws/s3/model/GetBucketLocationResult.h>
#include <aws/s3/model/GetBucketLoggingRequest.h>
#include <aws/s3/model/GetBucketLoggingResult.h>
#include <aws/s3/model/GetBucketMetadataTableConfigurationRequest.h>
#include <aws/s3/model/GetBucketMetadataTableConfigurationResult.h>
#include <aws/s3/model/GetBucketMetadataTableConfigurationSdkResult.h>
#include <aws/s3/model/GetBucketMetricsConfigurationRequest.h>
#include <aws/s3/model/GetBucketMetricsConfigurationResult.h>
#include <aws/s3/model/GetBucketNotificationConfigurationRequest.h>
#include <aws/s3/model/GetBucketNotificationConfigurationResult.h>
#include <aws/s3/model/GetBucketOwnershipControlsRequest.h>
#include <aws/s3/model/GetBucketOwnershipControlsResult.h>
#include <aws/s3/model/GetBucketPolicyRequest.h>
#include <aws/s3/model/GetBucketPolicyResult.h>
#include <aws/s3/model/GetBucketPolicyStatusRequest.h>
#include <aws/s3/model/GetBucketPolicyStatusResult.h>
#include <aws/s3/model/GetBucketReplicationRequest.h>
#include <aws/s3/model/GetBucketReplicationResult.h>
#include <aws/s3/model/GetBucketRequestPaymentRequest.h>
#include <aws/s3/model/GetBucketRequestPaymentResult.h>
#include <aws/s3/model/GetBucketTaggingRequest.h>
#include <aws/s3/model/GetBucketTaggingResult.h>
#include <aws/s3/model/GetBucketVersioningRequest.h>
#include <aws/s3/model/GetBucketVersioningResult.h>
#include <aws/s3/model/GetBucketWebsiteRequest.h>
#include <aws/s3/model/GetBucketWebsiteResult.h>
#include <aws/s3/model/GetObjectAclRequest.h>
#include <aws/s3/model/GetObjectAclResult.h>
#include <aws/s3/model/GetObjectAttributesParts.h>
#include <aws/s3/model/GetObjectAttributesRequest.h>
#include <aws/s3/model/GetObjectAttributesResult.h>
#include <aws/s3/model/GetObjectLegalHoldRequest.h>
#include <aws/s3/model/GetObjectLegalHoldResult.h>
#include <aws/s3/model/GetObjectLockConfigurationRequest.h>
#include <aws/s3/model/GetObjectLockConfigurationResult.h>
#include <aws/s3/model/GetObjectRequest.h>
#include <aws/s3/model/GetObjectResult.h>
#include <aws/s3/model/GetObjectRetentionRequest.h>
#include <aws/s3/model/GetObjectRetentionResult.h>
#include <aws/s3/model/GetObjectTaggingRequest.h>
#include <aws/s3/model/GetObjectTaggingResult.h>
#include <aws/s3/model/GetObjectTorrentRequest.h>
#include <aws/s3/model/GetObjectTorrentResult.h>
#include <aws/s3/model/GetPublicAccessBlockRequest.h>
#include <aws/s3/model/GetPublicAccessBlockResult.h>
#include <aws/s3/model/GlacierJobParameters.h>
#include <aws/s3/model/Grant.h>
#include <aws/s3/model/Grantee.h>
#include <aws/s3/model/HeadBucketRequest.h>
#include <aws/s3/model/HeadBucketResult.h>
#include <aws/s3/model/HeadObjectRequest.h>
#include <aws/s3/model/HeadObjectResult.h>
#include <aws/s3/model/IndexDocument.h>
#include <aws/s3/model/Initiator.h>
#include <aws/s3/model/InputSerialization.h>
#include <aws/s3/model/IntelligentTieringAccessTier.h>
#include <aws/s3/model/IntelligentTieringAndOperator.h>
#include <aws/s3/model/IntelligentTieringConfiguration.h>
#include <aws/s3/model/IntelligentTieringFilter.h>
#include <aws/s3/model/IntelligentTieringStatus.h>
#include <aws/s3/model/InvalidObjectState.h>
#include <aws/s3/model/InventoryConfiguration.h>
#include <aws/s3/model/InventoryDestination.h>
#include <aws/s3/model/InventoryEncryption.h>
#include <aws/s3/model/InventoryFilter.h>
#include <aws/s3/model/InventoryFormat.h>
#include <aws/s3/model/InventoryFrequency.h>
#include <aws/s3/model/InventoryIncludedObjectVersions.h>
#include <aws/s3/model/InventoryOptionalField.h>
#include <aws/s3/model/InventoryS3BucketDestination.h>
#include <aws/s3/model/InventorySchedule.h>
#include <aws/s3/model/JSONInput.h>
#include <aws/s3/model/JSONOutput.h>
#include <aws/s3/model/JSONType.h>
#include <aws/s3/model/LambdaFunctionConfiguration.h>
#include <aws/s3/model/LifecycleConfiguration.h>
#include <aws/s3/model/LifecycleExpiration.h>
#include <aws/s3/model/LifecycleRule.h>
#include <aws/s3/model/LifecycleRuleAndOperator.h>
#include <aws/s3/model/LifecycleRuleFilter.h>
#include <aws/s3/model/ListBucketAnalyticsConfigurationsRequest.h>
#include <aws/s3/model/ListBucketAnalyticsConfigurationsResult.h>
#include <aws/s3/model/ListBucketIntelligentTieringConfigurationsRequest.h>
#include <aws/s3/model/ListBucketIntelligentTieringConfigurationsResult.h>
#include <aws/s3/model/ListBucketInventoryConfigurationsRequest.h>
#include <aws/s3/model/ListBucketInventoryConfigurationsResult.h>
#include <aws/s3/model/ListBucketMetricsConfigurationsRequest.h>
#include <aws/s3/model/ListBucketMetricsConfigurationsResult.h>
#include <aws/s3/model/ListBucketsRequest.h>
#include <aws/s3/model/ListBucketsResult.h>
#include <aws/s3/model/ListDirectoryBucketsRequest.h>
#include <aws/s3/model/ListDirectoryBucketsResult.h>
#include <aws/s3/model/ListMultipartUploadsRequest.h>
#include <aws/s3/model/ListMultipartUploadsResult.h>
#include <aws/s3/model/ListObjectVersionsRequest.h>
#include <aws/s3/model/ListObjectVersionsResult.h>
#include <aws/s3/model/ListObjectsRequest.h>
#include <aws/s3/model/ListObjectsResult.h>
#include <aws/s3/model/ListObjectsV2Request.h>
#include <aws/s3/model/ListObjectsV2Result.h>
#include <aws/s3/model/ListPartsRequest.h>
#include <aws/s3/model/ListPartsResult.h>
#include <aws/s3/model/LocationInfo.h>
#include <aws/s3/model/LocationType.h>
#include <aws/s3/model/LoggingEnabled.h>
#include <aws/s3/model/MFADelete.h>
#include <aws/s3/model/MFADeleteStatus.h>
#include <aws/s3/model/MetadataDirective.h>
#include <aws/s3/model/MetadataEntry.h>
#include <aws/s3/model/MetadataTableConfiguration.h>
#include <aws/s3/model/MetadataTableConfigurationResult.h>
#include <aws/s3/model/Metrics.h>
#include <aws/s3/model/MetricsAndOperator.h>
#include <aws/s3/model/MetricsConfiguration.h>
#include <aws/s3/model/MetricsFilter.h>
#include <aws/s3/model/MetricsStatus.h>
#include <aws/s3/model/MultipartUpload.h>
#include <aws/s3/model/NoncurrentVersionExpiration.h>
#include <aws/s3/model/NoncurrentVersionTransition.h>
#include <aws/s3/model/NotificationConfiguration.h>
#include <aws/s3/model/NotificationConfigurationDeprecated.h>
#include <aws/s3/model/NotificationConfigurationFilter.h>
#include <aws/s3/model/Object.h>
#include <aws/s3/model/ObjectAttributes.h>
#include <aws/s3/model/ObjectCannedACL.h>
#include <aws/s3/model/ObjectIdentifier.h>
#include <aws/s3/model/ObjectLockConfiguration.h>
#include <aws/s3/model/ObjectLockEnabled.h>
#include <aws/s3/model/ObjectLockLegalHold.h>
#include <aws/s3/model/ObjectLockLegalHoldStatus.h>
#include <aws/s3/model/ObjectLockMode.h>
#include <aws/s3/model/ObjectLockRetention.h>
#include <aws/s3/model/ObjectLockRetentionMode.h>
#include <aws/s3/model/ObjectLockRule.h>
#include <aws/s3/model/ObjectOwnership.h>
#include <aws/s3/model/ObjectPart.h>
#include <aws/s3/model/ObjectStorageClass.h>
#include <aws/s3/model/ObjectVersion.h>
#include <aws/s3/model/ObjectVersionStorageClass.h>
#include <aws/s3/model/OptionalObjectAttributes.h>
#include <aws/s3/model/OutputLocation.h>
#include <aws/s3/model/OutputSerialization.h>
#include <aws/s3/model/Owner.h>
#include <aws/s3/model/OwnerOverride.h>
#include <aws/s3/model/OwnershipControls.h>
#include <aws/s3/model/OwnershipControlsRule.h>
#include <aws/s3/model/ParquetInput.h>
#include <aws/s3/model/Part.h>
#include <aws/s3/model/PartitionDateSource.h>
#include <aws/s3/model/PartitionedPrefix.h>
#include <aws/s3/model/Payer.h>
#include <aws/s3/model/Permission.h>
#include <aws/s3/model/PolicyStatus.h>
#include <aws/s3/model/Progress.h>
#include <aws/s3/model/ProgressEvent.h>
#include <aws/s3/model/Protocol.h>
#include <aws/s3/model/PublicAccessBlockConfiguration.h>
#include <aws/s3/model/PutBucketAccelerateConfigurationRequest.h>
#include <aws/s3/model/PutBucketAclRequest.h>
#include <aws/s3/model/PutBucketAnalyticsConfigurationRequest.h>
#include <aws/s3/model/PutBucketCorsRequest.h>
#include <aws/s3/model/PutBucketEncryptionRequest.h>
#include <aws/s3/model/PutBucketIntelligentTieringConfigurationRequest.h>
#include <aws/s3/model/PutBucketInventoryConfigurationRequest.h>
#include <aws/s3/model/PutBucketLifecycleConfigurationRequest.h>
#include <aws/s3/model/PutBucketLifecycleConfigurationResult.h>
#include <aws/s3/model/PutBucketLoggingRequest.h>
#include <aws/s3/model/PutBucketMetricsConfigurationRequest.h>
#include <aws/s3/model/PutBucketNotificationConfigurationRequest.h>
#include <aws/s3/model/PutBucketOwnershipControlsRequest.h>
#include <aws/s3/model/PutBucketPolicyRequest.h>
#include <aws/s3/model/PutBucketReplicationRequest.h>
#include <aws/s3/model/PutBucketRequestPaymentRequest.h>
#include <aws/s3/model/PutBucketTaggingRequest.h>
#include <aws/s3/model/PutBucketVersioningRequest.h>
#include <aws/s3/model/PutBucketWebsiteRequest.h>
#include <aws/s3/model/PutObjectAclRequest.h>
#include <aws/s3/model/PutObjectAclResult.h>
#include <aws/s3/model/PutObjectLegalHoldRequest.h>
#include <aws/s3/model/PutObjectLegalHoldResult.h>
#include <aws/s3/model/PutObjectLockConfigurationRequest.h>
#include <aws/s3/model/PutObjectLockConfigurationResult.h>
#include <aws/s3/model/PutObjectRequest.h>
#include <aws/s3/model/PutObjectResult.h>
#include <aws/s3/model/PutObjectRetentionRequest.h>
#include <aws/s3/model/PutObjectRetentionResult.h>
#include <aws/s3/model/PutObjectTaggingRequest.h>
#include <aws/s3/model/PutObjectTaggingResult.h>
#include <aws/s3/model/PutPublicAccessBlockRequest.h>
#include <aws/s3/model/QueueConfiguration.h>
#include <aws/s3/model/QueueConfigurationDeprecated.h>
#include <aws/s3/model/QuoteFields.h>
#include <aws/s3/model/RecordsEvent.h>
#include <aws/s3/model/Redirect.h>
#include <aws/s3/model/RedirectAllRequestsTo.h>
#include <aws/s3/model/RenameObjectRequest.h>
#include <aws/s3/model/RenameObjectResult.h>
#include <aws/s3/model/ReplicaModifications.h>
#include <aws/s3/model/ReplicaModificationsStatus.h>
#include <aws/s3/model/ReplicationConfiguration.h>
#include <aws/s3/model/ReplicationRule.h>
#include <aws/s3/model/ReplicationRuleAndOperator.h>
#include <aws/s3/model/ReplicationRuleFilter.h>
#include <aws/s3/model/ReplicationRuleStatus.h>
#include <aws/s3/model/ReplicationStatus.h>
#include <aws/s3/model/ReplicationTime.h>
#include <aws/s3/model/ReplicationTimeStatus.h>
#include <aws/s3/model/ReplicationTimeValue.h>
#include <aws/s3/model/RequestCharged.h>
#include <aws/s3/model/RequestPayer.h>
#include <aws/s3/model/RequestPaymentConfiguration.h>
#include <aws/s3/model/RequestProgress.h>
#include <aws/s3/model/RestoreObjectRequest.h>
#include <aws/s3/model/RestoreObjectResult.h>
#include <aws/s3/model/RestoreRequest.h>
#include <aws/s3/model/RestoreRequestType.h>
#include <aws/s3/model/RestoreStatus.h>
#include <aws/s3/model/RoutingRule.h>
#include <aws/s3/model/Rule.h>
#include <aws/s3/model/S3KeyFilter.h>
#include <aws/s3/model/S3Location.h>
#include <aws/s3/model/S3TablesDestination.h>
#include <aws/s3/model/S3TablesDestinationResult.h>
#include <aws/s3/model/SSEKMS.h>
#include <aws/s3/model/SSES3.h>
#include <aws/s3/model/ScanRange.h>
#include <aws/s3/model/SelectObjectContentHandler.h>
#include <aws/s3/model/SelectObjectContentInitialResponse.h>
#include <aws/s3/model/SelectObjectContentRequest.h>
#include <aws/s3/model/SelectParameters.h>
#include <aws/s3/model/ServerSideEncryption.h>
#include <aws/s3/model/ServerSideEncryptionByDefault.h>
#include <aws/s3/model/ServerSideEncryptionConfiguration.h>
#include <aws/s3/model/ServerSideEncryptionRule.h>
#include <aws/s3/model/SessionCredentials.h>
#include <aws/s3/model/SessionMode.h>
#include <aws/s3/model/SimplePrefix.h>
#include <aws/s3/model/SourceSelectionCriteria.h>
#include <aws/s3/model/SseKmsEncryptedObjects.h>
#include <aws/s3/model/SseKmsEncryptedObjectsStatus.h>
#include <aws/s3/model/Stats.h>
#include <aws/s3/model/StatsEvent.h>
#include <aws/s3/model/StorageClass.h>
#include <aws/s3/model/StorageClassAnalysis.h>
#include <aws/s3/model/StorageClassAnalysisDataExport.h>
#include <aws/s3/model/StorageClassAnalysisSchemaVersion.h>
#include <aws/s3/model/Tag.h>
#include <aws/s3/model/Tagging.h>
#include <aws/s3/model/TaggingDirective.h>
#include <aws/s3/model/TargetGrant.h>
#include <aws/s3/model/TargetObjectKeyFormat.h>
#include <aws/s3/model/Tier.h>
#include <aws/s3/model/Tiering.h>
#include <aws/s3/model/TopicConfiguration.h>
#include <aws/s3/model/TopicConfigurationDeprecated.h>
#include <aws/s3/model/Transition.h>
#include <aws/s3/model/TransitionDefaultMinimumObjectSize.h>
#include <aws/s3/model/TransitionStorageClass.h>
#include <aws/s3/model/Type.h>
#include <aws/s3/model/UploadPartCopyRequest.h>
#include <aws/s3/model/UploadPartCopyResult.h>
#include <aws/s3/model/UploadPartRequest.h>
#include <aws/s3/model/UploadPartResult.h>
#include <aws/s3/model/VersioningConfiguration.h>
#include <aws/s3/model/WebsiteConfiguration.h>
#include <aws/s3/model/WriteGetObjectResponseRequest.h>

using S3IncludeTest = ::testing::Test;

TEST_F(S3IncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::S3::S3Client>("S3IncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
