/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/s3control/S3ControlClient.h>
#include <aws/s3control/S3ControlClientConfiguration.h>
#include <aws/s3control/S3ControlEndpointProvider.h>
#include <aws/s3control/S3ControlEndpointRules.h>
#include <aws/s3control/S3ControlErrorMarshaller.h>
#include <aws/s3control/S3ControlErrors.h>
#include <aws/s3control/S3ControlRequest.h>
#include <aws/s3control/S3ControlServiceClientModel.h>
#include <aws/s3control/S3Control_EXPORTS.h>
#include <aws/s3control/model/AbortIncompleteMultipartUpload.h>
#include <aws/s3control/model/AccessControlTranslation.h>
#include <aws/s3control/model/AccessGrantsLocationConfiguration.h>
#include <aws/s3control/model/AccessPoint.h>
#include <aws/s3control/model/AccountLevel.h>
#include <aws/s3control/model/ActivityMetrics.h>
#include <aws/s3control/model/AdvancedCostOptimizationMetrics.h>
#include <aws/s3control/model/AdvancedDataProtectionMetrics.h>
#include <aws/s3control/model/AssociateAccessGrantsIdentityCenterRequest.h>
#include <aws/s3control/model/AsyncErrorDetails.h>
#include <aws/s3control/model/AsyncOperation.h>
#include <aws/s3control/model/AsyncOperationName.h>
#include <aws/s3control/model/AsyncRequestParameters.h>
#include <aws/s3control/model/AsyncResponseDetails.h>
#include <aws/s3control/model/AwsLambdaTransformation.h>
#include <aws/s3control/model/BucketCannedACL.h>
#include <aws/s3control/model/BucketLevel.h>
#include <aws/s3control/model/BucketLocationConstraint.h>
#include <aws/s3control/model/BucketVersioningStatus.h>
#include <aws/s3control/model/CloudWatchMetrics.h>
#include <aws/s3control/model/CreateAccessGrantRequest.h>
#include <aws/s3control/model/CreateAccessGrantResult.h>
#include <aws/s3control/model/CreateAccessGrantsInstanceRequest.h>
#include <aws/s3control/model/CreateAccessGrantsInstanceResult.h>
#include <aws/s3control/model/CreateAccessGrantsLocationRequest.h>
#include <aws/s3control/model/CreateAccessGrantsLocationResult.h>
#include <aws/s3control/model/CreateAccessPointForObjectLambdaRequest.h>
#include <aws/s3control/model/CreateAccessPointForObjectLambdaResult.h>
#include <aws/s3control/model/CreateAccessPointRequest.h>
#include <aws/s3control/model/CreateAccessPointResult.h>
#include <aws/s3control/model/CreateBucketConfiguration.h>
#include <aws/s3control/model/CreateBucketRequest.h>
#include <aws/s3control/model/CreateBucketResult.h>
#include <aws/s3control/model/CreateJobRequest.h>
#include <aws/s3control/model/CreateJobResult.h>
#include <aws/s3control/model/CreateMultiRegionAccessPointInput.h>
#include <aws/s3control/model/CreateMultiRegionAccessPointRequest.h>
#include <aws/s3control/model/CreateMultiRegionAccessPointResult.h>
#include <aws/s3control/model/CreateStorageLensGroupRequest.h>
#include <aws/s3control/model/Credentials.h>
#include <aws/s3control/model/DeleteAccessGrantRequest.h>
#include <aws/s3control/model/DeleteAccessGrantsInstanceRequest.h>
#include <aws/s3control/model/DeleteAccessGrantsInstanceResourcePolicyRequest.h>
#include <aws/s3control/model/DeleteAccessGrantsLocationRequest.h>
#include <aws/s3control/model/DeleteAccessPointForObjectLambdaRequest.h>
#include <aws/s3control/model/DeleteAccessPointPolicyForObjectLambdaRequest.h>
#include <aws/s3control/model/DeleteAccessPointPolicyRequest.h>
#include <aws/s3control/model/DeleteAccessPointRequest.h>
#include <aws/s3control/model/DeleteAccessPointScopeRequest.h>
#include <aws/s3control/model/DeleteBucketLifecycleConfigurationRequest.h>
#include <aws/s3control/model/DeleteBucketPolicyRequest.h>
#include <aws/s3control/model/DeleteBucketReplicationRequest.h>
#include <aws/s3control/model/DeleteBucketRequest.h>
#include <aws/s3control/model/DeleteBucketTaggingRequest.h>
#include <aws/s3control/model/DeleteJobTaggingRequest.h>
#include <aws/s3control/model/DeleteJobTaggingResult.h>
#include <aws/s3control/model/DeleteMarkerReplication.h>
#include <aws/s3control/model/DeleteMarkerReplicationStatus.h>
#include <aws/s3control/model/DeleteMultiRegionAccessPointInput.h>
#include <aws/s3control/model/DeleteMultiRegionAccessPointRequest.h>
#include <aws/s3control/model/DeleteMultiRegionAccessPointResult.h>
#include <aws/s3control/model/DeletePublicAccessBlockRequest.h>
#include <aws/s3control/model/DeleteStorageLensConfigurationRequest.h>
#include <aws/s3control/model/DeleteStorageLensConfigurationTaggingRequest.h>
#include <aws/s3control/model/DeleteStorageLensConfigurationTaggingResult.h>
#include <aws/s3control/model/DeleteStorageLensGroupRequest.h>
#include <aws/s3control/model/DescribeJobRequest.h>
#include <aws/s3control/model/DescribeJobResult.h>
#include <aws/s3control/model/DescribeMultiRegionAccessPointOperationRequest.h>
#include <aws/s3control/model/DescribeMultiRegionAccessPointOperationResult.h>
#include <aws/s3control/model/Destination.h>
#include <aws/s3control/model/DetailedStatusCodesMetrics.h>
#include <aws/s3control/model/DissociateAccessGrantsIdentityCenterRequest.h>
#include <aws/s3control/model/EncryptionConfiguration.h>
#include <aws/s3control/model/EstablishedMultiRegionAccessPointPolicy.h>
#include <aws/s3control/model/Exclude.h>
#include <aws/s3control/model/ExistingObjectReplication.h>
#include <aws/s3control/model/ExistingObjectReplicationStatus.h>
#include <aws/s3control/model/ExpirationStatus.h>
#include <aws/s3control/model/Format.h>
#include <aws/s3control/model/GeneratedManifestEncryption.h>
#include <aws/s3control/model/GeneratedManifestFormat.h>
#include <aws/s3control/model/GetAccessGrantRequest.h>
#include <aws/s3control/model/GetAccessGrantResult.h>
#include <aws/s3control/model/GetAccessGrantsInstanceForPrefixRequest.h>
#include <aws/s3control/model/GetAccessGrantsInstanceForPrefixResult.h>
#include <aws/s3control/model/GetAccessGrantsInstanceRequest.h>
#include <aws/s3control/model/GetAccessGrantsInstanceResourcePolicyRequest.h>
#include <aws/s3control/model/GetAccessGrantsInstanceResourcePolicyResult.h>
#include <aws/s3control/model/GetAccessGrantsInstanceResult.h>
#include <aws/s3control/model/GetAccessGrantsLocationRequest.h>
#include <aws/s3control/model/GetAccessGrantsLocationResult.h>
#include <aws/s3control/model/GetAccessPointConfigurationForObjectLambdaRequest.h>
#include <aws/s3control/model/GetAccessPointConfigurationForObjectLambdaResult.h>
#include <aws/s3control/model/GetAccessPointForObjectLambdaRequest.h>
#include <aws/s3control/model/GetAccessPointForObjectLambdaResult.h>
#include <aws/s3control/model/GetAccessPointPolicyForObjectLambdaRequest.h>
#include <aws/s3control/model/GetAccessPointPolicyForObjectLambdaResult.h>
#include <aws/s3control/model/GetAccessPointPolicyRequest.h>
#include <aws/s3control/model/GetAccessPointPolicyResult.h>
#include <aws/s3control/model/GetAccessPointPolicyStatusForObjectLambdaRequest.h>
#include <aws/s3control/model/GetAccessPointPolicyStatusForObjectLambdaResult.h>
#include <aws/s3control/model/GetAccessPointPolicyStatusRequest.h>
#include <aws/s3control/model/GetAccessPointPolicyStatusResult.h>
#include <aws/s3control/model/GetAccessPointRequest.h>
#include <aws/s3control/model/GetAccessPointResult.h>
#include <aws/s3control/model/GetAccessPointScopeRequest.h>
#include <aws/s3control/model/GetAccessPointScopeResult.h>
#include <aws/s3control/model/GetBucketLifecycleConfigurationRequest.h>
#include <aws/s3control/model/GetBucketLifecycleConfigurationResult.h>
#include <aws/s3control/model/GetBucketPolicyRequest.h>
#include <aws/s3control/model/GetBucketPolicyResult.h>
#include <aws/s3control/model/GetBucketReplicationRequest.h>
#include <aws/s3control/model/GetBucketReplicationResult.h>
#include <aws/s3control/model/GetBucketRequest.h>
#include <aws/s3control/model/GetBucketResult.h>
#include <aws/s3control/model/GetBucketTaggingRequest.h>
#include <aws/s3control/model/GetBucketTaggingResult.h>
#include <aws/s3control/model/GetBucketVersioningRequest.h>
#include <aws/s3control/model/GetBucketVersioningResult.h>
#include <aws/s3control/model/GetDataAccessRequest.h>
#include <aws/s3control/model/GetDataAccessResult.h>
#include <aws/s3control/model/GetJobTaggingRequest.h>
#include <aws/s3control/model/GetJobTaggingResult.h>
#include <aws/s3control/model/GetMultiRegionAccessPointPolicyRequest.h>
#include <aws/s3control/model/GetMultiRegionAccessPointPolicyResult.h>
#include <aws/s3control/model/GetMultiRegionAccessPointPolicyStatusRequest.h>
#include <aws/s3control/model/GetMultiRegionAccessPointPolicyStatusResult.h>
#include <aws/s3control/model/GetMultiRegionAccessPointRequest.h>
#include <aws/s3control/model/GetMultiRegionAccessPointResult.h>
#include <aws/s3control/model/GetMultiRegionAccessPointRoutesRequest.h>
#include <aws/s3control/model/GetMultiRegionAccessPointRoutesResult.h>
#include <aws/s3control/model/GetPublicAccessBlockRequest.h>
#include <aws/s3control/model/GetPublicAccessBlockResult.h>
#include <aws/s3control/model/GetStorageLensConfigurationRequest.h>
#include <aws/s3control/model/GetStorageLensConfigurationResult.h>
#include <aws/s3control/model/GetStorageLensConfigurationTaggingRequest.h>
#include <aws/s3control/model/GetStorageLensConfigurationTaggingResult.h>
#include <aws/s3control/model/GetStorageLensGroupRequest.h>
#include <aws/s3control/model/GetStorageLensGroupResult.h>
#include <aws/s3control/model/Grantee.h>
#include <aws/s3control/model/GranteeType.h>
#include <aws/s3control/model/Include.h>
#include <aws/s3control/model/JobDescriptor.h>
#include <aws/s3control/model/JobFailure.h>
#include <aws/s3control/model/JobListDescriptor.h>
#include <aws/s3control/model/JobManifest.h>
#include <aws/s3control/model/JobManifestFieldName.h>
#include <aws/s3control/model/JobManifestFormat.h>
#include <aws/s3control/model/JobManifestGenerator.h>
#include <aws/s3control/model/JobManifestGeneratorFilter.h>
#include <aws/s3control/model/JobManifestLocation.h>
#include <aws/s3control/model/JobManifestSpec.h>
#include <aws/s3control/model/JobOperation.h>
#include <aws/s3control/model/JobProgressSummary.h>
#include <aws/s3control/model/JobReport.h>
#include <aws/s3control/model/JobReportFormat.h>
#include <aws/s3control/model/JobReportScope.h>
#include <aws/s3control/model/JobStatus.h>
#include <aws/s3control/model/JobTimers.h>
#include <aws/s3control/model/KeyNameConstraint.h>
#include <aws/s3control/model/LambdaInvokeOperation.h>
#include <aws/s3control/model/LifecycleConfiguration.h>
#include <aws/s3control/model/LifecycleExpiration.h>
#include <aws/s3control/model/LifecycleRule.h>
#include <aws/s3control/model/LifecycleRuleAndOperator.h>
#include <aws/s3control/model/LifecycleRuleFilter.h>
#include <aws/s3control/model/ListAccessGrantEntry.h>
#include <aws/s3control/model/ListAccessGrantsInstanceEntry.h>
#include <aws/s3control/model/ListAccessGrantsInstancesRequest.h>
#include <aws/s3control/model/ListAccessGrantsInstancesResult.h>
#include <aws/s3control/model/ListAccessGrantsLocationsEntry.h>
#include <aws/s3control/model/ListAccessGrantsLocationsRequest.h>
#include <aws/s3control/model/ListAccessGrantsLocationsResult.h>
#include <aws/s3control/model/ListAccessGrantsRequest.h>
#include <aws/s3control/model/ListAccessGrantsResult.h>
#include <aws/s3control/model/ListAccessPointsForDirectoryBucketsRequest.h>
#include <aws/s3control/model/ListAccessPointsForDirectoryBucketsResult.h>
#include <aws/s3control/model/ListAccessPointsForObjectLambdaRequest.h>
#include <aws/s3control/model/ListAccessPointsForObjectLambdaResult.h>
#include <aws/s3control/model/ListAccessPointsRequest.h>
#include <aws/s3control/model/ListAccessPointsResult.h>
#include <aws/s3control/model/ListCallerAccessGrantsEntry.h>
#include <aws/s3control/model/ListCallerAccessGrantsRequest.h>
#include <aws/s3control/model/ListCallerAccessGrantsResult.h>
#include <aws/s3control/model/ListJobsRequest.h>
#include <aws/s3control/model/ListJobsResult.h>
#include <aws/s3control/model/ListMultiRegionAccessPointsRequest.h>
#include <aws/s3control/model/ListMultiRegionAccessPointsResult.h>
#include <aws/s3control/model/ListRegionalBucketsRequest.h>
#include <aws/s3control/model/ListRegionalBucketsResult.h>
#include <aws/s3control/model/ListStorageLensConfigurationEntry.h>
#include <aws/s3control/model/ListStorageLensConfigurationsRequest.h>
#include <aws/s3control/model/ListStorageLensConfigurationsResult.h>
#include <aws/s3control/model/ListStorageLensGroupEntry.h>
#include <aws/s3control/model/ListStorageLensGroupsRequest.h>
#include <aws/s3control/model/ListStorageLensGroupsResult.h>
#include <aws/s3control/model/ListTagsForResourceRequest.h>
#include <aws/s3control/model/ListTagsForResourceResult.h>
#include <aws/s3control/model/MFADelete.h>
#include <aws/s3control/model/MFADeleteStatus.h>
#include <aws/s3control/model/MatchObjectAge.h>
#include <aws/s3control/model/MatchObjectSize.h>
#include <aws/s3control/model/Metrics.h>
#include <aws/s3control/model/MetricsStatus.h>
#include <aws/s3control/model/MultiRegionAccessPointPolicyDocument.h>
#include <aws/s3control/model/MultiRegionAccessPointRegionalResponse.h>
#include <aws/s3control/model/MultiRegionAccessPointReport.h>
#include <aws/s3control/model/MultiRegionAccessPointRoute.h>
#include <aws/s3control/model/MultiRegionAccessPointStatus.h>
#include <aws/s3control/model/MultiRegionAccessPointsAsyncResponse.h>
#include <aws/s3control/model/NetworkOrigin.h>
#include <aws/s3control/model/NoncurrentVersionExpiration.h>
#include <aws/s3control/model/NoncurrentVersionTransition.h>
#include <aws/s3control/model/ObjectLambdaAccessPoint.h>
#include <aws/s3control/model/ObjectLambdaAccessPointAlias.h>
#include <aws/s3control/model/ObjectLambdaAccessPointAliasStatus.h>
#include <aws/s3control/model/ObjectLambdaAllowedFeature.h>
#include <aws/s3control/model/ObjectLambdaConfiguration.h>
#include <aws/s3control/model/ObjectLambdaContentTransformation.h>
#include <aws/s3control/model/ObjectLambdaTransformationConfiguration.h>
#include <aws/s3control/model/ObjectLambdaTransformationConfigurationAction.h>
#include <aws/s3control/model/OperationName.h>
#include <aws/s3control/model/OutputSchemaVersion.h>
#include <aws/s3control/model/OwnerOverride.h>
#include <aws/s3control/model/Permission.h>
#include <aws/s3control/model/PolicyStatus.h>
#include <aws/s3control/model/PrefixLevel.h>
#include <aws/s3control/model/PrefixLevelStorageMetrics.h>
#include <aws/s3control/model/Privilege.h>
#include <aws/s3control/model/ProposedMultiRegionAccessPointPolicy.h>
#include <aws/s3control/model/PublicAccessBlockConfiguration.h>
#include <aws/s3control/model/PutAccessGrantsInstanceResourcePolicyRequest.h>
#include <aws/s3control/model/PutAccessGrantsInstanceResourcePolicyResult.h>
#include <aws/s3control/model/PutAccessPointConfigurationForObjectLambdaRequest.h>
#include <aws/s3control/model/PutAccessPointPolicyForObjectLambdaRequest.h>
#include <aws/s3control/model/PutAccessPointPolicyRequest.h>
#include <aws/s3control/model/PutAccessPointScopeRequest.h>
#include <aws/s3control/model/PutBucketLifecycleConfigurationRequest.h>
#include <aws/s3control/model/PutBucketPolicyRequest.h>
#include <aws/s3control/model/PutBucketReplicationRequest.h>
#include <aws/s3control/model/PutBucketTaggingRequest.h>
#include <aws/s3control/model/PutBucketVersioningRequest.h>
#include <aws/s3control/model/PutJobTaggingRequest.h>
#include <aws/s3control/model/PutJobTaggingResult.h>
#include <aws/s3control/model/PutMultiRegionAccessPointPolicyInput.h>
#include <aws/s3control/model/PutMultiRegionAccessPointPolicyRequest.h>
#include <aws/s3control/model/PutMultiRegionAccessPointPolicyResult.h>
#include <aws/s3control/model/PutPublicAccessBlockRequest.h>
#include <aws/s3control/model/PutStorageLensConfigurationRequest.h>
#include <aws/s3control/model/PutStorageLensConfigurationTaggingRequest.h>
#include <aws/s3control/model/PutStorageLensConfigurationTaggingResult.h>
#include <aws/s3control/model/Region.h>
#include <aws/s3control/model/RegionReport.h>
#include <aws/s3control/model/RegionalBucket.h>
#include <aws/s3control/model/ReplicaModifications.h>
#include <aws/s3control/model/ReplicaModificationsStatus.h>
#include <aws/s3control/model/ReplicationConfiguration.h>
#include <aws/s3control/model/ReplicationRule.h>
#include <aws/s3control/model/ReplicationRuleAndOperator.h>
#include <aws/s3control/model/ReplicationRuleFilter.h>
#include <aws/s3control/model/ReplicationRuleStatus.h>
#include <aws/s3control/model/ReplicationStatus.h>
#include <aws/s3control/model/ReplicationStorageClass.h>
#include <aws/s3control/model/ReplicationTime.h>
#include <aws/s3control/model/ReplicationTimeStatus.h>
#include <aws/s3control/model/ReplicationTimeValue.h>
#include <aws/s3control/model/RequestedJobStatus.h>
#include <aws/s3control/model/S3AccessControlList.h>
#include <aws/s3control/model/S3AccessControlPolicy.h>
#include <aws/s3control/model/S3BucketDestination.h>
#include <aws/s3control/model/S3CannedAccessControlList.h>
#include <aws/s3control/model/S3ChecksumAlgorithm.h>
#include <aws/s3control/model/S3CopyObjectOperation.h>
#include <aws/s3control/model/S3DeleteObjectTaggingOperation.h>
#include <aws/s3control/model/S3GeneratedManifestDescriptor.h>
#include <aws/s3control/model/S3GlacierJobTier.h>
#include <aws/s3control/model/S3Grant.h>
#include <aws/s3control/model/S3Grantee.h>
#include <aws/s3control/model/S3GranteeTypeIdentifier.h>
#include <aws/s3control/model/S3InitiateRestoreObjectOperation.h>
#include <aws/s3control/model/S3JobManifestGenerator.h>
#include <aws/s3control/model/S3ManifestOutputLocation.h>
#include <aws/s3control/model/S3MetadataDirective.h>
#include <aws/s3control/model/S3ObjectLockLegalHold.h>
#include <aws/s3control/model/S3ObjectLockLegalHoldStatus.h>
#include <aws/s3control/model/S3ObjectLockMode.h>
#include <aws/s3control/model/S3ObjectLockRetentionMode.h>
#include <aws/s3control/model/S3ObjectMetadata.h>
#include <aws/s3control/model/S3ObjectOwner.h>
#include <aws/s3control/model/S3Permission.h>
#include <aws/s3control/model/S3PrefixType.h>
#include <aws/s3control/model/S3ReplicateObjectOperation.h>
#include <aws/s3control/model/S3Retention.h>
#include <aws/s3control/model/S3SSEAlgorithm.h>
#include <aws/s3control/model/S3SetObjectAclOperation.h>
#include <aws/s3control/model/S3SetObjectLegalHoldOperation.h>
#include <aws/s3control/model/S3SetObjectRetentionOperation.h>
#include <aws/s3control/model/S3SetObjectTaggingOperation.h>
#include <aws/s3control/model/S3StorageClass.h>
#include <aws/s3control/model/S3Tag.h>
#include <aws/s3control/model/SSEKMS.h>
#include <aws/s3control/model/SSEKMSEncryption.h>
#include <aws/s3control/model/SSES3.h>
#include <aws/s3control/model/SSES3Encryption.h>
#include <aws/s3control/model/Scope.h>
#include <aws/s3control/model/ScopePermission.h>
#include <aws/s3control/model/SelectionCriteria.h>
#include <aws/s3control/model/SourceSelectionCriteria.h>
#include <aws/s3control/model/SseKmsEncryptedObjects.h>
#include <aws/s3control/model/SseKmsEncryptedObjectsStatus.h>
#include <aws/s3control/model/StorageLensAwsOrg.h>
#include <aws/s3control/model/StorageLensConfiguration.h>
#include <aws/s3control/model/StorageLensDataExport.h>
#include <aws/s3control/model/StorageLensDataExportEncryption.h>
#include <aws/s3control/model/StorageLensGroup.h>
#include <aws/s3control/model/StorageLensGroupAndOperator.h>
#include <aws/s3control/model/StorageLensGroupFilter.h>
#include <aws/s3control/model/StorageLensGroupLevel.h>
#include <aws/s3control/model/StorageLensGroupLevelSelectionCriteria.h>
#include <aws/s3control/model/StorageLensGroupOrOperator.h>
#include <aws/s3control/model/StorageLensTag.h>
#include <aws/s3control/model/SubmitMultiRegionAccessPointRoutesRequest.h>
#include <aws/s3control/model/SubmitMultiRegionAccessPointRoutesResult.h>
#include <aws/s3control/model/Tag.h>
#include <aws/s3control/model/TagResourceRequest.h>
#include <aws/s3control/model/TagResourceResult.h>
#include <aws/s3control/model/Tagging.h>
#include <aws/s3control/model/Transition.h>
#include <aws/s3control/model/TransitionStorageClass.h>
#include <aws/s3control/model/UntagResourceRequest.h>
#include <aws/s3control/model/UntagResourceResult.h>
#include <aws/s3control/model/UpdateAccessGrantsLocationRequest.h>
#include <aws/s3control/model/UpdateAccessGrantsLocationResult.h>
#include <aws/s3control/model/UpdateJobPriorityRequest.h>
#include <aws/s3control/model/UpdateJobPriorityResult.h>
#include <aws/s3control/model/UpdateJobStatusRequest.h>
#include <aws/s3control/model/UpdateJobStatusResult.h>
#include <aws/s3control/model/UpdateStorageLensGroupRequest.h>
#include <aws/s3control/model/VersioningConfiguration.h>
#include <aws/s3control/model/VpcConfiguration.h>

using S3ControlIncludeTest = ::testing::Test;

TEST_F(S3ControlIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::S3Control::S3ControlClient>("S3ControlIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
