/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/sagemaker/SageMakerClient.h>
#include <aws/sagemaker/SageMakerEndpointProvider.h>
#include <aws/sagemaker/SageMakerEndpointRules.h>
#include <aws/sagemaker/SageMakerErrorMarshaller.h>
#include <aws/sagemaker/SageMakerErrors.h>
#include <aws/sagemaker/SageMakerRequest.h>
#include <aws/sagemaker/SageMakerServiceClientModel.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/ActionSource.h>
#include <aws/sagemaker/model/ActionStatus.h>
#include <aws/sagemaker/model/ActionSummary.h>
#include <aws/sagemaker/model/ActivationState.h>
#include <aws/sagemaker/model/AddAssociationRequest.h>
#include <aws/sagemaker/model/AddAssociationResult.h>
#include <aws/sagemaker/model/AddTagsRequest.h>
#include <aws/sagemaker/model/AddTagsResult.h>
#include <aws/sagemaker/model/AdditionalInferenceSpecificationDefinition.h>
#include <aws/sagemaker/model/AdditionalModelDataSource.h>
#include <aws/sagemaker/model/AdditionalS3DataSource.h>
#include <aws/sagemaker/model/AdditionalS3DataSourceDataType.h>
#include <aws/sagemaker/model/AgentVersion.h>
#include <aws/sagemaker/model/AggregationTransformationValue.h>
#include <aws/sagemaker/model/Alarm.h>
#include <aws/sagemaker/model/AlarmDetails.h>
#include <aws/sagemaker/model/AlgorithmSortBy.h>
#include <aws/sagemaker/model/AlgorithmSpecification.h>
#include <aws/sagemaker/model/AlgorithmStatus.h>
#include <aws/sagemaker/model/AlgorithmStatusDetails.h>
#include <aws/sagemaker/model/AlgorithmStatusItem.h>
#include <aws/sagemaker/model/AlgorithmSummary.h>
#include <aws/sagemaker/model/AlgorithmValidationProfile.h>
#include <aws/sagemaker/model/AlgorithmValidationSpecification.h>
#include <aws/sagemaker/model/AmazonQSettings.h>
#include <aws/sagemaker/model/AnnotationConsolidationConfig.h>
#include <aws/sagemaker/model/AppDetails.h>
#include <aws/sagemaker/model/AppImageConfigDetails.h>
#include <aws/sagemaker/model/AppImageConfigSortKey.h>
#include <aws/sagemaker/model/AppInstanceType.h>
#include <aws/sagemaker/model/AppLifecycleManagement.h>
#include <aws/sagemaker/model/AppNetworkAccessType.h>
#include <aws/sagemaker/model/AppSecurityGroupManagement.h>
#include <aws/sagemaker/model/AppSortKey.h>
#include <aws/sagemaker/model/AppSpecification.h>
#include <aws/sagemaker/model/AppStatus.h>
#include <aws/sagemaker/model/AppType.h>
#include <aws/sagemaker/model/ArtifactSource.h>
#include <aws/sagemaker/model/ArtifactSourceIdType.h>
#include <aws/sagemaker/model/ArtifactSourceType.h>
#include <aws/sagemaker/model/ArtifactSummary.h>
#include <aws/sagemaker/model/AssemblyType.h>
#include <aws/sagemaker/model/AssociateTrialComponentRequest.h>
#include <aws/sagemaker/model/AssociateTrialComponentResult.h>
#include <aws/sagemaker/model/AssociationEdgeType.h>
#include <aws/sagemaker/model/AssociationSummary.h>
#include <aws/sagemaker/model/AsyncInferenceClientConfig.h>
#include <aws/sagemaker/model/AsyncInferenceConfig.h>
#include <aws/sagemaker/model/AsyncInferenceNotificationConfig.h>
#include <aws/sagemaker/model/AsyncInferenceOutputConfig.h>
#include <aws/sagemaker/model/AsyncNotificationTopicTypes.h>
#include <aws/sagemaker/model/AthenaDatasetDefinition.h>
#include <aws/sagemaker/model/AthenaResultCompressionType.h>
#include <aws/sagemaker/model/AthenaResultFormat.h>
#include <aws/sagemaker/model/AuthMode.h>
#include <aws/sagemaker/model/AutoMLAlgorithm.h>
#include <aws/sagemaker/model/AutoMLAlgorithmConfig.h>
#include <aws/sagemaker/model/AutoMLCandidate.h>
#include <aws/sagemaker/model/AutoMLCandidateGenerationConfig.h>
#include <aws/sagemaker/model/AutoMLCandidateStep.h>
#include <aws/sagemaker/model/AutoMLChannel.h>
#include <aws/sagemaker/model/AutoMLChannelType.h>
#include <aws/sagemaker/model/AutoMLComputeConfig.h>
#include <aws/sagemaker/model/AutoMLContainerDefinition.h>
#include <aws/sagemaker/model/AutoMLDataSource.h>
#include <aws/sagemaker/model/AutoMLDataSplitConfig.h>
#include <aws/sagemaker/model/AutoMLJobArtifacts.h>
#include <aws/sagemaker/model/AutoMLJobChannel.h>
#include <aws/sagemaker/model/AutoMLJobCompletionCriteria.h>
#include <aws/sagemaker/model/AutoMLJobConfig.h>
#include <aws/sagemaker/model/AutoMLJobObjective.h>
#include <aws/sagemaker/model/AutoMLJobObjectiveType.h>
#include <aws/sagemaker/model/AutoMLJobSecondaryStatus.h>
#include <aws/sagemaker/model/AutoMLJobStatus.h>
#include <aws/sagemaker/model/AutoMLJobStepMetadata.h>
#include <aws/sagemaker/model/AutoMLJobSummary.h>
#include <aws/sagemaker/model/AutoMLMetricEnum.h>
#include <aws/sagemaker/model/AutoMLMetricExtendedEnum.h>
#include <aws/sagemaker/model/AutoMLMode.h>
#include <aws/sagemaker/model/AutoMLOutputDataConfig.h>
#include <aws/sagemaker/model/AutoMLPartialFailureReason.h>
#include <aws/sagemaker/model/AutoMLProblemTypeConfig.h>
#include <aws/sagemaker/model/AutoMLProblemTypeConfigName.h>
#include <aws/sagemaker/model/AutoMLProblemTypeResolvedAttributes.h>
#include <aws/sagemaker/model/AutoMLProcessingUnit.h>
#include <aws/sagemaker/model/AutoMLResolvedAttributes.h>
#include <aws/sagemaker/model/AutoMLS3DataSource.h>
#include <aws/sagemaker/model/AutoMLS3DataType.h>
#include <aws/sagemaker/model/AutoMLSecurityConfig.h>
#include <aws/sagemaker/model/AutoMLSortBy.h>
#include <aws/sagemaker/model/AutoMLSortOrder.h>
#include <aws/sagemaker/model/AutoMountHomeEFS.h>
#include <aws/sagemaker/model/AutoParameter.h>
#include <aws/sagemaker/model/AutoRollbackConfig.h>
#include <aws/sagemaker/model/Autotune.h>
#include <aws/sagemaker/model/AutotuneMode.h>
#include <aws/sagemaker/model/AwsManagedHumanLoopRequestSource.h>
#include <aws/sagemaker/model/BatchDataCaptureConfig.h>
#include <aws/sagemaker/model/BatchDeleteClusterNodesError.h>
#include <aws/sagemaker/model/BatchDeleteClusterNodesErrorCode.h>
#include <aws/sagemaker/model/BatchDeleteClusterNodesRequest.h>
#include <aws/sagemaker/model/BatchDeleteClusterNodesResult.h>
#include <aws/sagemaker/model/BatchDescribeModelPackageError.h>
#include <aws/sagemaker/model/BatchDescribeModelPackageRequest.h>
#include <aws/sagemaker/model/BatchDescribeModelPackageResult.h>
#include <aws/sagemaker/model/BatchDescribeModelPackageSummary.h>
#include <aws/sagemaker/model/BatchStrategy.h>
#include <aws/sagemaker/model/BatchTransformInput.h>
#include <aws/sagemaker/model/BestObjectiveNotImproving.h>
#include <aws/sagemaker/model/Bias.h>
#include <aws/sagemaker/model/BlueGreenUpdatePolicy.h>
#include <aws/sagemaker/model/BooleanOperator.h>
#include <aws/sagemaker/model/CacheHitResult.h>
#include <aws/sagemaker/model/CallbackStepMetadata.h>
#include <aws/sagemaker/model/CandidateArtifactLocations.h>
#include <aws/sagemaker/model/CandidateGenerationConfig.h>
#include <aws/sagemaker/model/CandidateProperties.h>
#include <aws/sagemaker/model/CandidateSortBy.h>
#include <aws/sagemaker/model/CandidateStatus.h>
#include <aws/sagemaker/model/CandidateStepType.h>
#include <aws/sagemaker/model/CanvasAppSettings.h>
#include <aws/sagemaker/model/CapacityReservationPreference.h>
#include <aws/sagemaker/model/CapacitySize.h>
#include <aws/sagemaker/model/CapacitySizeConfig.h>
#include <aws/sagemaker/model/CapacitySizeType.h>
#include <aws/sagemaker/model/CaptureContentTypeHeader.h>
#include <aws/sagemaker/model/CaptureMode.h>
#include <aws/sagemaker/model/CaptureOption.h>
#include <aws/sagemaker/model/CaptureStatus.h>
#include <aws/sagemaker/model/CategoricalParameter.h>
#include <aws/sagemaker/model/CategoricalParameterRange.h>
#include <aws/sagemaker/model/CategoricalParameterRangeSpecification.h>
#include <aws/sagemaker/model/CfnCreateTemplateProvider.h>
#include <aws/sagemaker/model/CfnStackCreateParameter.h>
#include <aws/sagemaker/model/CfnStackDetail.h>
#include <aws/sagemaker/model/CfnStackParameter.h>
#include <aws/sagemaker/model/CfnStackUpdateParameter.h>
#include <aws/sagemaker/model/CfnTemplateProviderDetail.h>
#include <aws/sagemaker/model/CfnUpdateTemplateProvider.h>
#include <aws/sagemaker/model/Channel.h>
#include <aws/sagemaker/model/ChannelSpecification.h>
#include <aws/sagemaker/model/CheckpointConfig.h>
#include <aws/sagemaker/model/ClarifyCheckStepMetadata.h>
#include <aws/sagemaker/model/ClarifyExplainerConfig.h>
#include <aws/sagemaker/model/ClarifyFeatureType.h>
#include <aws/sagemaker/model/ClarifyInferenceConfig.h>
#include <aws/sagemaker/model/ClarifyShapBaselineConfig.h>
#include <aws/sagemaker/model/ClarifyShapConfig.h>
#include <aws/sagemaker/model/ClarifyTextConfig.h>
#include <aws/sagemaker/model/ClarifyTextGranularity.h>
#include <aws/sagemaker/model/ClarifyTextLanguage.h>
#include <aws/sagemaker/model/ClusterEbsVolumeConfig.h>
#include <aws/sagemaker/model/ClusterInstanceGroupDetails.h>
#include <aws/sagemaker/model/ClusterInstanceGroupSpecification.h>
#include <aws/sagemaker/model/ClusterInstancePlacement.h>
#include <aws/sagemaker/model/ClusterInstanceStatus.h>
#include <aws/sagemaker/model/ClusterInstanceStatusDetails.h>
#include <aws/sagemaker/model/ClusterInstanceStorageConfig.h>
#include <aws/sagemaker/model/ClusterInstanceType.h>
#include <aws/sagemaker/model/ClusterLifeCycleConfig.h>
#include <aws/sagemaker/model/ClusterNodeDetails.h>
#include <aws/sagemaker/model/ClusterNodeRecovery.h>
#include <aws/sagemaker/model/ClusterNodeSummary.h>
#include <aws/sagemaker/model/ClusterOrchestrator.h>
#include <aws/sagemaker/model/ClusterOrchestratorEksConfig.h>
#include <aws/sagemaker/model/ClusterSchedulerConfigSummary.h>
#include <aws/sagemaker/model/ClusterSortBy.h>
#include <aws/sagemaker/model/ClusterStatus.h>
#include <aws/sagemaker/model/ClusterSummary.h>
#include <aws/sagemaker/model/CodeEditorAppImageConfig.h>
#include <aws/sagemaker/model/CodeEditorAppSettings.h>
#include <aws/sagemaker/model/CodeRepository.h>
#include <aws/sagemaker/model/CodeRepositorySortBy.h>
#include <aws/sagemaker/model/CodeRepositorySortOrder.h>
#include <aws/sagemaker/model/CodeRepositorySummary.h>
#include <aws/sagemaker/model/CognitoConfig.h>
#include <aws/sagemaker/model/CognitoMemberDefinition.h>
#include <aws/sagemaker/model/CollectionConfig.h>
#include <aws/sagemaker/model/CollectionConfiguration.h>
#include <aws/sagemaker/model/CollectionType.h>
#include <aws/sagemaker/model/CompilationJobStatus.h>
#include <aws/sagemaker/model/CompilationJobSummary.h>
#include <aws/sagemaker/model/CompleteOnConvergence.h>
#include <aws/sagemaker/model/CompressionType.h>
#include <aws/sagemaker/model/ComputeQuotaConfig.h>
#include <aws/sagemaker/model/ComputeQuotaResourceConfig.h>
#include <aws/sagemaker/model/ComputeQuotaSummary.h>
#include <aws/sagemaker/model/ComputeQuotaTarget.h>
#include <aws/sagemaker/model/ConditionOutcome.h>
#include <aws/sagemaker/model/ConditionStepMetadata.h>
#include <aws/sagemaker/model/ContainerConfig.h>
#include <aws/sagemaker/model/ContainerDefinition.h>
#include <aws/sagemaker/model/ContainerMode.h>
#include <aws/sagemaker/model/ContentClassifier.h>
#include <aws/sagemaker/model/ContextSource.h>
#include <aws/sagemaker/model/ContextSummary.h>
#include <aws/sagemaker/model/ContinuousParameterRange.h>
#include <aws/sagemaker/model/ContinuousParameterRangeSpecification.h>
#include <aws/sagemaker/model/ConvergenceDetected.h>
#include <aws/sagemaker/model/CreateActionRequest.h>
#include <aws/sagemaker/model/CreateActionResult.h>
#include <aws/sagemaker/model/CreateAlgorithmRequest.h>
#include <aws/sagemaker/model/CreateAlgorithmResult.h>
#include <aws/sagemaker/model/CreateAppImageConfigRequest.h>
#include <aws/sagemaker/model/CreateAppImageConfigResult.h>
#include <aws/sagemaker/model/CreateAppRequest.h>
#include <aws/sagemaker/model/CreateAppResult.h>
#include <aws/sagemaker/model/CreateArtifactRequest.h>
#include <aws/sagemaker/model/CreateArtifactResult.h>
#include <aws/sagemaker/model/CreateAutoMLJobRequest.h>
#include <aws/sagemaker/model/CreateAutoMLJobResult.h>
#include <aws/sagemaker/model/CreateAutoMLJobV2Request.h>
#include <aws/sagemaker/model/CreateAutoMLJobV2Result.h>
#include <aws/sagemaker/model/CreateClusterRequest.h>
#include <aws/sagemaker/model/CreateClusterResult.h>
#include <aws/sagemaker/model/CreateClusterSchedulerConfigRequest.h>
#include <aws/sagemaker/model/CreateClusterSchedulerConfigResult.h>
#include <aws/sagemaker/model/CreateCodeRepositoryRequest.h>
#include <aws/sagemaker/model/CreateCodeRepositoryResult.h>
#include <aws/sagemaker/model/CreateCompilationJobRequest.h>
#include <aws/sagemaker/model/CreateCompilationJobResult.h>
#include <aws/sagemaker/model/CreateComputeQuotaRequest.h>
#include <aws/sagemaker/model/CreateComputeQuotaResult.h>
#include <aws/sagemaker/model/CreateContextRequest.h>
#include <aws/sagemaker/model/CreateContextResult.h>
#include <aws/sagemaker/model/CreateDataQualityJobDefinitionRequest.h>
#include <aws/sagemaker/model/CreateDataQualityJobDefinitionResult.h>
#include <aws/sagemaker/model/CreateDeviceFleetRequest.h>
#include <aws/sagemaker/model/CreateDomainRequest.h>
#include <aws/sagemaker/model/CreateDomainResult.h>
#include <aws/sagemaker/model/CreateEdgeDeploymentPlanRequest.h>
#include <aws/sagemaker/model/CreateEdgeDeploymentPlanResult.h>
#include <aws/sagemaker/model/CreateEdgeDeploymentStageRequest.h>
#include <aws/sagemaker/model/CreateEdgePackagingJobRequest.h>
#include <aws/sagemaker/model/CreateEndpointConfigRequest.h>
#include <aws/sagemaker/model/CreateEndpointConfigResult.h>
#include <aws/sagemaker/model/CreateEndpointRequest.h>
#include <aws/sagemaker/model/CreateEndpointResult.h>
#include <aws/sagemaker/model/CreateExperimentRequest.h>
#include <aws/sagemaker/model/CreateExperimentResult.h>
#include <aws/sagemaker/model/CreateFeatureGroupRequest.h>
#include <aws/sagemaker/model/CreateFeatureGroupResult.h>
#include <aws/sagemaker/model/CreateFlowDefinitionRequest.h>
#include <aws/sagemaker/model/CreateFlowDefinitionResult.h>
#include <aws/sagemaker/model/CreateHubContentReferenceRequest.h>
#include <aws/sagemaker/model/CreateHubContentReferenceResult.h>
#include <aws/sagemaker/model/CreateHubRequest.h>
#include <aws/sagemaker/model/CreateHubResult.h>
#include <aws/sagemaker/model/CreateHumanTaskUiRequest.h>
#include <aws/sagemaker/model/CreateHumanTaskUiResult.h>
#include <aws/sagemaker/model/CreateHyperParameterTuningJobRequest.h>
#include <aws/sagemaker/model/CreateHyperParameterTuningJobResult.h>
#include <aws/sagemaker/model/CreateImageRequest.h>
#include <aws/sagemaker/model/CreateImageResult.h>
#include <aws/sagemaker/model/CreateImageVersionRequest.h>
#include <aws/sagemaker/model/CreateImageVersionResult.h>
#include <aws/sagemaker/model/CreateInferenceComponentRequest.h>
#include <aws/sagemaker/model/CreateInferenceComponentResult.h>
#include <aws/sagemaker/model/CreateInferenceExperimentRequest.h>
#include <aws/sagemaker/model/CreateInferenceExperimentResult.h>
#include <aws/sagemaker/model/CreateInferenceRecommendationsJobRequest.h>
#include <aws/sagemaker/model/CreateInferenceRecommendationsJobResult.h>
#include <aws/sagemaker/model/CreateLabelingJobRequest.h>
#include <aws/sagemaker/model/CreateLabelingJobResult.h>
#include <aws/sagemaker/model/CreateMlflowTrackingServerRequest.h>
#include <aws/sagemaker/model/CreateMlflowTrackingServerResult.h>
#include <aws/sagemaker/model/CreateModelBiasJobDefinitionRequest.h>
#include <aws/sagemaker/model/CreateModelBiasJobDefinitionResult.h>
#include <aws/sagemaker/model/CreateModelCardExportJobRequest.h>
#include <aws/sagemaker/model/CreateModelCardExportJobResult.h>
#include <aws/sagemaker/model/CreateModelCardRequest.h>
#include <aws/sagemaker/model/CreateModelCardResult.h>
#include <aws/sagemaker/model/CreateModelExplainabilityJobDefinitionRequest.h>
#include <aws/sagemaker/model/CreateModelExplainabilityJobDefinitionResult.h>
#include <aws/sagemaker/model/CreateModelPackageGroupRequest.h>
#include <aws/sagemaker/model/CreateModelPackageGroupResult.h>
#include <aws/sagemaker/model/CreateModelPackageRequest.h>
#include <aws/sagemaker/model/CreateModelPackageResult.h>
#include <aws/sagemaker/model/CreateModelQualityJobDefinitionRequest.h>
#include <aws/sagemaker/model/CreateModelQualityJobDefinitionResult.h>
#include <aws/sagemaker/model/CreateModelRequest.h>
#include <aws/sagemaker/model/CreateModelResult.h>
#include <aws/sagemaker/model/CreateMonitoringScheduleRequest.h>
#include <aws/sagemaker/model/CreateMonitoringScheduleResult.h>
#include <aws/sagemaker/model/CreateNotebookInstanceLifecycleConfigRequest.h>
#include <aws/sagemaker/model/CreateNotebookInstanceLifecycleConfigResult.h>
#include <aws/sagemaker/model/CreateNotebookInstanceRequest.h>
#include <aws/sagemaker/model/CreateNotebookInstanceResult.h>
#include <aws/sagemaker/model/CreateOptimizationJobRequest.h>
#include <aws/sagemaker/model/CreateOptimizationJobResult.h>
#include <aws/sagemaker/model/CreatePartnerAppPresignedUrlRequest.h>
#include <aws/sagemaker/model/CreatePartnerAppPresignedUrlResult.h>
#include <aws/sagemaker/model/CreatePartnerAppRequest.h>
#include <aws/sagemaker/model/CreatePartnerAppResult.h>
#include <aws/sagemaker/model/CreatePipelineRequest.h>
#include <aws/sagemaker/model/CreatePipelineResult.h>
#include <aws/sagemaker/model/CreatePresignedDomainUrlRequest.h>
#include <aws/sagemaker/model/CreatePresignedDomainUrlResult.h>
#include <aws/sagemaker/model/CreatePresignedMlflowTrackingServerUrlRequest.h>
#include <aws/sagemaker/model/CreatePresignedMlflowTrackingServerUrlResult.h>
#include <aws/sagemaker/model/CreatePresignedNotebookInstanceUrlRequest.h>
#include <aws/sagemaker/model/CreatePresignedNotebookInstanceUrlResult.h>
#include <aws/sagemaker/model/CreateProcessingJobRequest.h>
#include <aws/sagemaker/model/CreateProcessingJobResult.h>
#include <aws/sagemaker/model/CreateProjectRequest.h>
#include <aws/sagemaker/model/CreateProjectResult.h>
#include <aws/sagemaker/model/CreateSpaceRequest.h>
#include <aws/sagemaker/model/CreateSpaceResult.h>
#include <aws/sagemaker/model/CreateStudioLifecycleConfigRequest.h>
#include <aws/sagemaker/model/CreateStudioLifecycleConfigResult.h>
#include <aws/sagemaker/model/CreateTemplateProvider.h>
#include <aws/sagemaker/model/CreateTrainingJobRequest.h>
#include <aws/sagemaker/model/CreateTrainingJobResult.h>
#include <aws/sagemaker/model/CreateTrainingPlanRequest.h>
#include <aws/sagemaker/model/CreateTrainingPlanResult.h>
#include <aws/sagemaker/model/CreateTransformJobRequest.h>
#include <aws/sagemaker/model/CreateTransformJobResult.h>
#include <aws/sagemaker/model/CreateTrialComponentRequest.h>
#include <aws/sagemaker/model/CreateTrialComponentResult.h>
#include <aws/sagemaker/model/CreateTrialRequest.h>
#include <aws/sagemaker/model/CreateTrialResult.h>
#include <aws/sagemaker/model/CreateUserProfileRequest.h>
#include <aws/sagemaker/model/CreateUserProfileResult.h>
#include <aws/sagemaker/model/CreateWorkforceRequest.h>
#include <aws/sagemaker/model/CreateWorkforceResult.h>
#include <aws/sagemaker/model/CreateWorkteamRequest.h>
#include <aws/sagemaker/model/CreateWorkteamResult.h>
#include <aws/sagemaker/model/CrossAccountFilterOption.h>
#include <aws/sagemaker/model/CustomFileSystem.h>
#include <aws/sagemaker/model/CustomFileSystemConfig.h>
#include <aws/sagemaker/model/CustomImage.h>
#include <aws/sagemaker/model/CustomPosixUserConfig.h>
#include <aws/sagemaker/model/CustomizedMetricSpecification.h>
#include <aws/sagemaker/model/DataCaptureConfig.h>
#include <aws/sagemaker/model/DataCaptureConfigSummary.h>
#include <aws/sagemaker/model/DataCatalogConfig.h>
#include <aws/sagemaker/model/DataDistributionType.h>
#include <aws/sagemaker/model/DataProcessing.h>
#include <aws/sagemaker/model/DataQualityAppSpecification.h>
#include <aws/sagemaker/model/DataQualityBaselineConfig.h>
#include <aws/sagemaker/model/DataQualityJobInput.h>
#include <aws/sagemaker/model/DataSource.h>
#include <aws/sagemaker/model/DataSourceName.h>
#include <aws/sagemaker/model/DatasetDefinition.h>
#include <aws/sagemaker/model/DebugHookConfig.h>
#include <aws/sagemaker/model/DebugRuleConfiguration.h>
#include <aws/sagemaker/model/DebugRuleEvaluationStatus.h>
#include <aws/sagemaker/model/DeepHealthCheckType.h>
#include <aws/sagemaker/model/DefaultEbsStorageSettings.h>
#include <aws/sagemaker/model/DefaultSpaceSettings.h>
#include <aws/sagemaker/model/DefaultSpaceStorageSettings.h>
#include <aws/sagemaker/model/DeleteActionRequest.h>
#include <aws/sagemaker/model/DeleteActionResult.h>
#include <aws/sagemaker/model/DeleteAlgorithmRequest.h>
#include <aws/sagemaker/model/DeleteAppImageConfigRequest.h>
#include <aws/sagemaker/model/DeleteAppRequest.h>
#include <aws/sagemaker/model/DeleteArtifactRequest.h>
#include <aws/sagemaker/model/DeleteArtifactResult.h>
#include <aws/sagemaker/model/DeleteAssociationRequest.h>
#include <aws/sagemaker/model/DeleteAssociationResult.h>
#include <aws/sagemaker/model/DeleteClusterRequest.h>
#include <aws/sagemaker/model/DeleteClusterResult.h>
#include <aws/sagemaker/model/DeleteClusterSchedulerConfigRequest.h>
#include <aws/sagemaker/model/DeleteCodeRepositoryRequest.h>
#include <aws/sagemaker/model/DeleteCompilationJobRequest.h>
#include <aws/sagemaker/model/DeleteComputeQuotaRequest.h>
#include <aws/sagemaker/model/DeleteContextRequest.h>
#include <aws/sagemaker/model/DeleteContextResult.h>
#include <aws/sagemaker/model/DeleteDataQualityJobDefinitionRequest.h>
#include <aws/sagemaker/model/DeleteDeviceFleetRequest.h>
#include <aws/sagemaker/model/DeleteDomainRequest.h>
#include <aws/sagemaker/model/DeleteEdgeDeploymentPlanRequest.h>
#include <aws/sagemaker/model/DeleteEdgeDeploymentStageRequest.h>
#include <aws/sagemaker/model/DeleteEndpointConfigRequest.h>
#include <aws/sagemaker/model/DeleteEndpointRequest.h>
#include <aws/sagemaker/model/DeleteExperimentRequest.h>
#include <aws/sagemaker/model/DeleteExperimentResult.h>
#include <aws/sagemaker/model/DeleteFeatureGroupRequest.h>
#include <aws/sagemaker/model/DeleteFlowDefinitionRequest.h>
#include <aws/sagemaker/model/DeleteFlowDefinitionResult.h>
#include <aws/sagemaker/model/DeleteHubContentReferenceRequest.h>
#include <aws/sagemaker/model/DeleteHubContentRequest.h>
#include <aws/sagemaker/model/DeleteHubRequest.h>
#include <aws/sagemaker/model/DeleteHumanTaskUiRequest.h>
#include <aws/sagemaker/model/DeleteHumanTaskUiResult.h>
#include <aws/sagemaker/model/DeleteHyperParameterTuningJobRequest.h>
#include <aws/sagemaker/model/DeleteImageRequest.h>
#include <aws/sagemaker/model/DeleteImageResult.h>
#include <aws/sagemaker/model/DeleteImageVersionRequest.h>
#include <aws/sagemaker/model/DeleteImageVersionResult.h>
#include <aws/sagemaker/model/DeleteInferenceComponentRequest.h>
#include <aws/sagemaker/model/DeleteInferenceExperimentRequest.h>
#include <aws/sagemaker/model/DeleteInferenceExperimentResult.h>
#include <aws/sagemaker/model/DeleteMlflowTrackingServerRequest.h>
#include <aws/sagemaker/model/DeleteMlflowTrackingServerResult.h>
#include <aws/sagemaker/model/DeleteModelBiasJobDefinitionRequest.h>
#include <aws/sagemaker/model/DeleteModelCardRequest.h>
#include <aws/sagemaker/model/DeleteModelExplainabilityJobDefinitionRequest.h>
#include <aws/sagemaker/model/DeleteModelPackageGroupPolicyRequest.h>
#include <aws/sagemaker/model/DeleteModelPackageGroupRequest.h>
#include <aws/sagemaker/model/DeleteModelPackageRequest.h>
#include <aws/sagemaker/model/DeleteModelQualityJobDefinitionRequest.h>
#include <aws/sagemaker/model/DeleteModelRequest.h>
#include <aws/sagemaker/model/DeleteMonitoringScheduleRequest.h>
#include <aws/sagemaker/model/DeleteNotebookInstanceLifecycleConfigRequest.h>
#include <aws/sagemaker/model/DeleteNotebookInstanceRequest.h>
#include <aws/sagemaker/model/DeleteOptimizationJobRequest.h>
#include <aws/sagemaker/model/DeletePartnerAppRequest.h>
#include <aws/sagemaker/model/DeletePartnerAppResult.h>
#include <aws/sagemaker/model/DeletePipelineRequest.h>
#include <aws/sagemaker/model/DeletePipelineResult.h>
#include <aws/sagemaker/model/DeleteProjectRequest.h>
#include <aws/sagemaker/model/DeleteSpaceRequest.h>
#include <aws/sagemaker/model/DeleteStudioLifecycleConfigRequest.h>
#include <aws/sagemaker/model/DeleteTagsRequest.h>
#include <aws/sagemaker/model/DeleteTagsResult.h>
#include <aws/sagemaker/model/DeleteTrialComponentRequest.h>
#include <aws/sagemaker/model/DeleteTrialComponentResult.h>
#include <aws/sagemaker/model/DeleteTrialRequest.h>
#include <aws/sagemaker/model/DeleteTrialResult.h>
#include <aws/sagemaker/model/DeleteUserProfileRequest.h>
#include <aws/sagemaker/model/DeleteWorkforceRequest.h>
#include <aws/sagemaker/model/DeleteWorkforceResult.h>
#include <aws/sagemaker/model/DeleteWorkteamRequest.h>
#include <aws/sagemaker/model/DeleteWorkteamResult.h>
#include <aws/sagemaker/model/DeployedImage.h>
#include <aws/sagemaker/model/DeploymentConfig.h>
#include <aws/sagemaker/model/DeploymentConfiguration.h>
#include <aws/sagemaker/model/DeploymentRecommendation.h>
#include <aws/sagemaker/model/DeploymentStage.h>
#include <aws/sagemaker/model/DeploymentStageStatusSummary.h>
#include <aws/sagemaker/model/DeregisterDevicesRequest.h>
#include <aws/sagemaker/model/DerivedInformation.h>
#include <aws/sagemaker/model/DescribeActionRequest.h>
#include <aws/sagemaker/model/DescribeActionResult.h>
#include <aws/sagemaker/model/DescribeAlgorithmRequest.h>
#include <aws/sagemaker/model/DescribeAlgorithmResult.h>
#include <aws/sagemaker/model/DescribeAppImageConfigRequest.h>
#include <aws/sagemaker/model/DescribeAppImageConfigResult.h>
#include <aws/sagemaker/model/DescribeAppRequest.h>
#include <aws/sagemaker/model/DescribeAppResult.h>
#include <aws/sagemaker/model/DescribeArtifactRequest.h>
#include <aws/sagemaker/model/DescribeArtifactResult.h>
#include <aws/sagemaker/model/DescribeAutoMLJobRequest.h>
#include <aws/sagemaker/model/DescribeAutoMLJobResult.h>
#include <aws/sagemaker/model/DescribeAutoMLJobV2Request.h>
#include <aws/sagemaker/model/DescribeAutoMLJobV2Result.h>
#include <aws/sagemaker/model/DescribeClusterNodeRequest.h>
#include <aws/sagemaker/model/DescribeClusterNodeResult.h>
#include <aws/sagemaker/model/DescribeClusterRequest.h>
#include <aws/sagemaker/model/DescribeClusterResult.h>
#include <aws/sagemaker/model/DescribeClusterSchedulerConfigRequest.h>
#include <aws/sagemaker/model/DescribeClusterSchedulerConfigResult.h>
#include <aws/sagemaker/model/DescribeCodeRepositoryRequest.h>
#include <aws/sagemaker/model/DescribeCodeRepositoryResult.h>
#include <aws/sagemaker/model/DescribeCompilationJobRequest.h>
#include <aws/sagemaker/model/DescribeCompilationJobResult.h>
#include <aws/sagemaker/model/DescribeComputeQuotaRequest.h>
#include <aws/sagemaker/model/DescribeComputeQuotaResult.h>
#include <aws/sagemaker/model/DescribeContextRequest.h>
#include <aws/sagemaker/model/DescribeContextResult.h>
#include <aws/sagemaker/model/DescribeDataQualityJobDefinitionRequest.h>
#include <aws/sagemaker/model/DescribeDataQualityJobDefinitionResult.h>
#include <aws/sagemaker/model/DescribeDeviceFleetRequest.h>
#include <aws/sagemaker/model/DescribeDeviceFleetResult.h>
#include <aws/sagemaker/model/DescribeDeviceRequest.h>
#include <aws/sagemaker/model/DescribeDeviceResult.h>
#include <aws/sagemaker/model/DescribeDomainRequest.h>
#include <aws/sagemaker/model/DescribeDomainResult.h>
#include <aws/sagemaker/model/DescribeEdgeDeploymentPlanRequest.h>
#include <aws/sagemaker/model/DescribeEdgeDeploymentPlanResult.h>
#include <aws/sagemaker/model/DescribeEdgePackagingJobRequest.h>
#include <aws/sagemaker/model/DescribeEdgePackagingJobResult.h>
#include <aws/sagemaker/model/DescribeEndpointConfigRequest.h>
#include <aws/sagemaker/model/DescribeEndpointConfigResult.h>
#include <aws/sagemaker/model/DescribeEndpointRequest.h>
#include <aws/sagemaker/model/DescribeEndpointResult.h>
#include <aws/sagemaker/model/DescribeExperimentRequest.h>
#include <aws/sagemaker/model/DescribeExperimentResult.h>
#include <aws/sagemaker/model/DescribeFeatureGroupRequest.h>
#include <aws/sagemaker/model/DescribeFeatureGroupResult.h>
#include <aws/sagemaker/model/DescribeFeatureMetadataRequest.h>
#include <aws/sagemaker/model/DescribeFeatureMetadataResult.h>
#include <aws/sagemaker/model/DescribeFlowDefinitionRequest.h>
#include <aws/sagemaker/model/DescribeFlowDefinitionResult.h>
#include <aws/sagemaker/model/DescribeHubContentRequest.h>
#include <aws/sagemaker/model/DescribeHubContentResult.h>
#include <aws/sagemaker/model/DescribeHubRequest.h>
#include <aws/sagemaker/model/DescribeHubResult.h>
#include <aws/sagemaker/model/DescribeHumanTaskUiRequest.h>
#include <aws/sagemaker/model/DescribeHumanTaskUiResult.h>
#include <aws/sagemaker/model/DescribeHyperParameterTuningJobRequest.h>
#include <aws/sagemaker/model/DescribeHyperParameterTuningJobResult.h>
#include <aws/sagemaker/model/DescribeImageRequest.h>
#include <aws/sagemaker/model/DescribeImageResult.h>
#include <aws/sagemaker/model/DescribeImageVersionRequest.h>
#include <aws/sagemaker/model/DescribeImageVersionResult.h>
#include <aws/sagemaker/model/DescribeInferenceComponentRequest.h>
#include <aws/sagemaker/model/DescribeInferenceComponentResult.h>
#include <aws/sagemaker/model/DescribeInferenceExperimentRequest.h>
#include <aws/sagemaker/model/DescribeInferenceExperimentResult.h>
#include <aws/sagemaker/model/DescribeInferenceRecommendationsJobRequest.h>
#include <aws/sagemaker/model/DescribeInferenceRecommendationsJobResult.h>
#include <aws/sagemaker/model/DescribeLabelingJobRequest.h>
#include <aws/sagemaker/model/DescribeLabelingJobResult.h>
#include <aws/sagemaker/model/DescribeLineageGroupRequest.h>
#include <aws/sagemaker/model/DescribeLineageGroupResult.h>
#include <aws/sagemaker/model/DescribeMlflowTrackingServerRequest.h>
#include <aws/sagemaker/model/DescribeMlflowTrackingServerResult.h>
#include <aws/sagemaker/model/DescribeModelBiasJobDefinitionRequest.h>
#include <aws/sagemaker/model/DescribeModelBiasJobDefinitionResult.h>
#include <aws/sagemaker/model/DescribeModelCardExportJobRequest.h>
#include <aws/sagemaker/model/DescribeModelCardExportJobResult.h>
#include <aws/sagemaker/model/DescribeModelCardRequest.h>
#include <aws/sagemaker/model/DescribeModelCardResult.h>
#include <aws/sagemaker/model/DescribeModelExplainabilityJobDefinitionRequest.h>
#include <aws/sagemaker/model/DescribeModelExplainabilityJobDefinitionResult.h>
#include <aws/sagemaker/model/DescribeModelPackageGroupRequest.h>
#include <aws/sagemaker/model/DescribeModelPackageGroupResult.h>
#include <aws/sagemaker/model/DescribeModelPackageRequest.h>
#include <aws/sagemaker/model/DescribeModelPackageResult.h>
#include <aws/sagemaker/model/DescribeModelQualityJobDefinitionRequest.h>
#include <aws/sagemaker/model/DescribeModelQualityJobDefinitionResult.h>
#include <aws/sagemaker/model/DescribeModelRequest.h>
#include <aws/sagemaker/model/DescribeModelResult.h>
#include <aws/sagemaker/model/DescribeMonitoringScheduleRequest.h>
#include <aws/sagemaker/model/DescribeMonitoringScheduleResult.h>
#include <aws/sagemaker/model/DescribeNotebookInstanceLifecycleConfigRequest.h>
#include <aws/sagemaker/model/DescribeNotebookInstanceLifecycleConfigResult.h>
#include <aws/sagemaker/model/DescribeNotebookInstanceRequest.h>
#include <aws/sagemaker/model/DescribeNotebookInstanceResult.h>
#include <aws/sagemaker/model/DescribeOptimizationJobRequest.h>
#include <aws/sagemaker/model/DescribeOptimizationJobResult.h>
#include <aws/sagemaker/model/DescribePartnerAppRequest.h>
#include <aws/sagemaker/model/DescribePartnerAppResult.h>
#include <aws/sagemaker/model/DescribePipelineDefinitionForExecutionRequest.h>
#include <aws/sagemaker/model/DescribePipelineDefinitionForExecutionResult.h>
#include <aws/sagemaker/model/DescribePipelineExecutionRequest.h>
#include <aws/sagemaker/model/DescribePipelineExecutionResult.h>
#include <aws/sagemaker/model/DescribePipelineRequest.h>
#include <aws/sagemaker/model/DescribePipelineResult.h>
#include <aws/sagemaker/model/DescribeProcessingJobRequest.h>
#include <aws/sagemaker/model/DescribeProcessingJobResult.h>
#include <aws/sagemaker/model/DescribeProjectRequest.h>
#include <aws/sagemaker/model/DescribeProjectResult.h>
#include <aws/sagemaker/model/DescribeSpaceRequest.h>
#include <aws/sagemaker/model/DescribeSpaceResult.h>
#include <aws/sagemaker/model/DescribeStudioLifecycleConfigRequest.h>
#include <aws/sagemaker/model/DescribeStudioLifecycleConfigResult.h>
#include <aws/sagemaker/model/DescribeSubscribedWorkteamRequest.h>
#include <aws/sagemaker/model/DescribeSubscribedWorkteamResult.h>
#include <aws/sagemaker/model/DescribeTrainingJobRequest.h>
#include <aws/sagemaker/model/DescribeTrainingJobResult.h>
#include <aws/sagemaker/model/DescribeTrainingPlanRequest.h>
#include <aws/sagemaker/model/DescribeTrainingPlanResult.h>
#include <aws/sagemaker/model/DescribeTransformJobRequest.h>
#include <aws/sagemaker/model/DescribeTransformJobResult.h>
#include <aws/sagemaker/model/DescribeTrialComponentRequest.h>
#include <aws/sagemaker/model/DescribeTrialComponentResult.h>
#include <aws/sagemaker/model/DescribeTrialRequest.h>
#include <aws/sagemaker/model/DescribeTrialResult.h>
#include <aws/sagemaker/model/DescribeUserProfileRequest.h>
#include <aws/sagemaker/model/DescribeUserProfileResult.h>
#include <aws/sagemaker/model/DescribeWorkforceRequest.h>
#include <aws/sagemaker/model/DescribeWorkforceResult.h>
#include <aws/sagemaker/model/DescribeWorkteamRequest.h>
#include <aws/sagemaker/model/DescribeWorkteamResult.h>
#include <aws/sagemaker/model/DesiredWeightAndCapacity.h>
#include <aws/sagemaker/model/DetailedAlgorithmStatus.h>
#include <aws/sagemaker/model/DetailedModelPackageStatus.h>
#include <aws/sagemaker/model/Device.h>
#include <aws/sagemaker/model/DeviceDeploymentStatus.h>
#include <aws/sagemaker/model/DeviceDeploymentSummary.h>
#include <aws/sagemaker/model/DeviceFleetSummary.h>
#include <aws/sagemaker/model/DeviceSelectionConfig.h>
#include <aws/sagemaker/model/DeviceStats.h>
#include <aws/sagemaker/model/DeviceSubsetType.h>
#include <aws/sagemaker/model/DeviceSummary.h>
#include <aws/sagemaker/model/DirectDeploySettings.h>
#include <aws/sagemaker/model/DirectInternetAccess.h>
#include <aws/sagemaker/model/Direction.h>
#include <aws/sagemaker/model/DisableSagemakerServicecatalogPortfolioRequest.h>
#include <aws/sagemaker/model/DisableSagemakerServicecatalogPortfolioResult.h>
#include <aws/sagemaker/model/DisassociateTrialComponentRequest.h>
#include <aws/sagemaker/model/DisassociateTrialComponentResult.h>
#include <aws/sagemaker/model/DockerSettings.h>
#include <aws/sagemaker/model/DomainDetails.h>
#include <aws/sagemaker/model/DomainSettings.h>
#include <aws/sagemaker/model/DomainSettingsForUpdate.h>
#include <aws/sagemaker/model/DomainStatus.h>
#include <aws/sagemaker/model/DriftCheckBaselines.h>
#include <aws/sagemaker/model/DriftCheckBias.h>
#include <aws/sagemaker/model/DriftCheckExplainability.h>
#include <aws/sagemaker/model/DriftCheckModelDataQuality.h>
#include <aws/sagemaker/model/DriftCheckModelQuality.h>
#include <aws/sagemaker/model/DynamicScalingConfiguration.h>
#include <aws/sagemaker/model/EFSFileSystem.h>
#include <aws/sagemaker/model/EFSFileSystemConfig.h>
#include <aws/sagemaker/model/EMRStepMetadata.h>
#include <aws/sagemaker/model/EbsStorageSettings.h>
#include <aws/sagemaker/model/Ec2CapacityReservation.h>
#include <aws/sagemaker/model/Edge.h>
#include <aws/sagemaker/model/EdgeDeploymentConfig.h>
#include <aws/sagemaker/model/EdgeDeploymentModelConfig.h>
#include <aws/sagemaker/model/EdgeDeploymentPlanSummary.h>
#include <aws/sagemaker/model/EdgeDeploymentStatus.h>
#include <aws/sagemaker/model/EdgeModel.h>
#include <aws/sagemaker/model/EdgeModelStat.h>
#include <aws/sagemaker/model/EdgeModelSummary.h>
#include <aws/sagemaker/model/EdgeOutputConfig.h>
#include <aws/sagemaker/model/EdgePackagingJobStatus.h>
#include <aws/sagemaker/model/EdgePackagingJobSummary.h>
#include <aws/sagemaker/model/EdgePresetDeploymentOutput.h>
#include <aws/sagemaker/model/EdgePresetDeploymentStatus.h>
#include <aws/sagemaker/model/EdgePresetDeploymentType.h>
#include <aws/sagemaker/model/EmrServerlessComputeConfig.h>
#include <aws/sagemaker/model/EmrServerlessSettings.h>
#include <aws/sagemaker/model/EmrSettings.h>
#include <aws/sagemaker/model/EnableSagemakerServicecatalogPortfolioRequest.h>
#include <aws/sagemaker/model/EnableSagemakerServicecatalogPortfolioResult.h>
#include <aws/sagemaker/model/EnabledOrDisabled.h>
#include <aws/sagemaker/model/Endpoint.h>
#include <aws/sagemaker/model/EndpointConfigSortKey.h>
#include <aws/sagemaker/model/EndpointConfigStepMetadata.h>
#include <aws/sagemaker/model/EndpointConfigSummary.h>
#include <aws/sagemaker/model/EndpointInfo.h>
#include <aws/sagemaker/model/EndpointInput.h>
#include <aws/sagemaker/model/EndpointInputConfiguration.h>
#include <aws/sagemaker/model/EndpointMetadata.h>
#include <aws/sagemaker/model/EndpointOutputConfiguration.h>
#include <aws/sagemaker/model/EndpointPerformance.h>
#include <aws/sagemaker/model/EndpointSortKey.h>
#include <aws/sagemaker/model/EndpointStatus.h>
#include <aws/sagemaker/model/EndpointStepMetadata.h>
#include <aws/sagemaker/model/EndpointSummary.h>
#include <aws/sagemaker/model/EnvironmentParameter.h>
#include <aws/sagemaker/model/EnvironmentParameterRanges.h>
#include <aws/sagemaker/model/ErrorInfo.h>
#include <aws/sagemaker/model/ExecutionRoleIdentityConfig.h>
#include <aws/sagemaker/model/ExecutionStatus.h>
#include <aws/sagemaker/model/Experiment.h>
#include <aws/sagemaker/model/ExperimentConfig.h>
#include <aws/sagemaker/model/ExperimentSource.h>
#include <aws/sagemaker/model/ExperimentSummary.h>
#include <aws/sagemaker/model/Explainability.h>
#include <aws/sagemaker/model/ExplainerConfig.h>
#include <aws/sagemaker/model/FSxLustreFileSystem.h>
#include <aws/sagemaker/model/FSxLustreFileSystemConfig.h>
#include <aws/sagemaker/model/FailStepMetadata.h>
#include <aws/sagemaker/model/FailureHandlingPolicy.h>
#include <aws/sagemaker/model/FairShare.h>
#include <aws/sagemaker/model/FeatureDefinition.h>
#include <aws/sagemaker/model/FeatureGroup.h>
#include <aws/sagemaker/model/FeatureGroupSortBy.h>
#include <aws/sagemaker/model/FeatureGroupSortOrder.h>
#include <aws/sagemaker/model/FeatureGroupStatus.h>
#include <aws/sagemaker/model/FeatureGroupSummary.h>
#include <aws/sagemaker/model/FeatureMetadata.h>
#include <aws/sagemaker/model/FeatureParameter.h>
#include <aws/sagemaker/model/FeatureStatus.h>
#include <aws/sagemaker/model/FeatureType.h>
#include <aws/sagemaker/model/FileSource.h>
#include <aws/sagemaker/model/FileSystemAccessMode.h>
#include <aws/sagemaker/model/FileSystemConfig.h>
#include <aws/sagemaker/model/FileSystemDataSource.h>
#include <aws/sagemaker/model/FileSystemType.h>
#include <aws/sagemaker/model/FillingType.h>
#include <aws/sagemaker/model/Filter.h>
#include <aws/sagemaker/model/FinalAutoMLJobObjectiveMetric.h>
#include <aws/sagemaker/model/FinalHyperParameterTuningJobObjectiveMetric.h>
#include <aws/sagemaker/model/FlatInvocations.h>
#include <aws/sagemaker/model/FlowDefinitionOutputConfig.h>
#include <aws/sagemaker/model/FlowDefinitionStatus.h>
#include <aws/sagemaker/model/FlowDefinitionSummary.h>
#include <aws/sagemaker/model/Framework.h>
#include <aws/sagemaker/model/GenerativeAiSettings.h>
#include <aws/sagemaker/model/GetDeviceFleetReportRequest.h>
#include <aws/sagemaker/model/GetDeviceFleetReportResult.h>
#include <aws/sagemaker/model/GetLineageGroupPolicyRequest.h>
#include <aws/sagemaker/model/GetLineageGroupPolicyResult.h>
#include <aws/sagemaker/model/GetModelPackageGroupPolicyRequest.h>
#include <aws/sagemaker/model/GetModelPackageGroupPolicyResult.h>
#include <aws/sagemaker/model/GetSagemakerServicecatalogPortfolioStatusRequest.h>
#include <aws/sagemaker/model/GetSagemakerServicecatalogPortfolioStatusResult.h>
#include <aws/sagemaker/model/GetScalingConfigurationRecommendationRequest.h>
#include <aws/sagemaker/model/GetScalingConfigurationRecommendationResult.h>
#include <aws/sagemaker/model/GetSearchSuggestionsRequest.h>
#include <aws/sagemaker/model/GetSearchSuggestionsResult.h>
#include <aws/sagemaker/model/GitConfig.h>
#include <aws/sagemaker/model/GitConfigForUpdate.h>
#include <aws/sagemaker/model/HiddenSageMakerImage.h>
#include <aws/sagemaker/model/HolidayConfigAttributes.h>
#include <aws/sagemaker/model/HubAccessConfig.h>
#include <aws/sagemaker/model/HubContentDependency.h>
#include <aws/sagemaker/model/HubContentInfo.h>
#include <aws/sagemaker/model/HubContentSortBy.h>
#include <aws/sagemaker/model/HubContentStatus.h>
#include <aws/sagemaker/model/HubContentSupportStatus.h>
#include <aws/sagemaker/model/HubContentType.h>
#include <aws/sagemaker/model/HubInfo.h>
#include <aws/sagemaker/model/HubS3StorageConfig.h>
#include <aws/sagemaker/model/HubSortBy.h>
#include <aws/sagemaker/model/HubStatus.h>
#include <aws/sagemaker/model/HumanLoopActivationConditionsConfig.h>
#include <aws/sagemaker/model/HumanLoopActivationConfig.h>
#include <aws/sagemaker/model/HumanLoopConfig.h>
#include <aws/sagemaker/model/HumanLoopRequestSource.h>
#include <aws/sagemaker/model/HumanTaskConfig.h>
#include <aws/sagemaker/model/HumanTaskUiStatus.h>
#include <aws/sagemaker/model/HumanTaskUiSummary.h>
#include <aws/sagemaker/model/HyperParameterAlgorithmSpecification.h>
#include <aws/sagemaker/model/HyperParameterScalingType.h>
#include <aws/sagemaker/model/HyperParameterSpecification.h>
#include <aws/sagemaker/model/HyperParameterTrainingJobDefinition.h>
#include <aws/sagemaker/model/HyperParameterTrainingJobSummary.h>
#include <aws/sagemaker/model/HyperParameterTuningAllocationStrategy.h>
#include <aws/sagemaker/model/HyperParameterTuningInstanceConfig.h>
#include <aws/sagemaker/model/HyperParameterTuningJobCompletionDetails.h>
#include <aws/sagemaker/model/HyperParameterTuningJobConfig.h>
#include <aws/sagemaker/model/HyperParameterTuningJobConsumedResources.h>
#include <aws/sagemaker/model/HyperParameterTuningJobObjective.h>
#include <aws/sagemaker/model/HyperParameterTuningJobObjectiveType.h>
#include <aws/sagemaker/model/HyperParameterTuningJobSearchEntity.h>
#include <aws/sagemaker/model/HyperParameterTuningJobSortByOptions.h>
#include <aws/sagemaker/model/HyperParameterTuningJobStatus.h>
#include <aws/sagemaker/model/HyperParameterTuningJobStrategyConfig.h>
#include <aws/sagemaker/model/HyperParameterTuningJobStrategyType.h>
#include <aws/sagemaker/model/HyperParameterTuningJobSummary.h>
#include <aws/sagemaker/model/HyperParameterTuningJobWarmStartConfig.h>
#include <aws/sagemaker/model/HyperParameterTuningJobWarmStartType.h>
#include <aws/sagemaker/model/HyperParameterTuningResourceConfig.h>
#include <aws/sagemaker/model/HyperbandStrategyConfig.h>
#include <aws/sagemaker/model/IamIdentity.h>
#include <aws/sagemaker/model/IamPolicyConstraints.h>
#include <aws/sagemaker/model/IdentityProviderOAuthSetting.h>
#include <aws/sagemaker/model/IdleSettings.h>
#include <aws/sagemaker/model/Image.h>
#include <aws/sagemaker/model/ImageClassificationJobConfig.h>
#include <aws/sagemaker/model/ImageConfig.h>
#include <aws/sagemaker/model/ImageSortBy.h>
#include <aws/sagemaker/model/ImageSortOrder.h>
#include <aws/sagemaker/model/ImageStatus.h>
#include <aws/sagemaker/model/ImageVersion.h>
#include <aws/sagemaker/model/ImageVersionSortBy.h>
#include <aws/sagemaker/model/ImageVersionSortOrder.h>
#include <aws/sagemaker/model/ImageVersionStatus.h>
#include <aws/sagemaker/model/ImportHubContentRequest.h>
#include <aws/sagemaker/model/ImportHubContentResult.h>
#include <aws/sagemaker/model/InferenceComponentCapacitySize.h>
#include <aws/sagemaker/model/InferenceComponentCapacitySizeType.h>
#include <aws/sagemaker/model/InferenceComponentComputeResourceRequirements.h>
#include <aws/sagemaker/model/InferenceComponentContainerSpecification.h>
#include <aws/sagemaker/model/InferenceComponentContainerSpecificationSummary.h>
#include <aws/sagemaker/model/InferenceComponentDeploymentConfig.h>
#include <aws/sagemaker/model/InferenceComponentRollingUpdatePolicy.h>
#include <aws/sagemaker/model/InferenceComponentRuntimeConfig.h>
#include <aws/sagemaker/model/InferenceComponentRuntimeConfigSummary.h>
#include <aws/sagemaker/model/InferenceComponentSortKey.h>
#include <aws/sagemaker/model/InferenceComponentSpecification.h>
#include <aws/sagemaker/model/InferenceComponentSpecificationSummary.h>
#include <aws/sagemaker/model/InferenceComponentStartupParameters.h>
#include <aws/sagemaker/model/InferenceComponentStatus.h>
#include <aws/sagemaker/model/InferenceComponentSummary.h>
#include <aws/sagemaker/model/InferenceExecutionConfig.h>
#include <aws/sagemaker/model/InferenceExecutionMode.h>
#include <aws/sagemaker/model/InferenceExperimentDataStorageConfig.h>
#include <aws/sagemaker/model/InferenceExperimentSchedule.h>
#include <aws/sagemaker/model/InferenceExperimentStatus.h>
#include <aws/sagemaker/model/InferenceExperimentStopDesiredState.h>
#include <aws/sagemaker/model/InferenceExperimentSummary.h>
#include <aws/sagemaker/model/InferenceExperimentType.h>
#include <aws/sagemaker/model/InferenceHubAccessConfig.h>
#include <aws/sagemaker/model/InferenceMetrics.h>
#include <aws/sagemaker/model/InferenceRecommendation.h>
#include <aws/sagemaker/model/InferenceRecommendationsJob.h>
#include <aws/sagemaker/model/InferenceRecommendationsJobStep.h>
#include <aws/sagemaker/model/InferenceSpecification.h>
#include <aws/sagemaker/model/InfraCheckConfig.h>
#include <aws/sagemaker/model/InputConfig.h>
#include <aws/sagemaker/model/InputMode.h>
#include <aws/sagemaker/model/InstanceGroup.h>
#include <aws/sagemaker/model/InstanceGroupStatus.h>
#include <aws/sagemaker/model/InstanceMetadataServiceConfiguration.h>
#include <aws/sagemaker/model/InstanceType.h>
#include <aws/sagemaker/model/IntegerParameterRange.h>
#include <aws/sagemaker/model/IntegerParameterRangeSpecification.h>
#include <aws/sagemaker/model/IsTrackingServerActive.h>
#include <aws/sagemaker/model/JobType.h>
#include <aws/sagemaker/model/JoinSource.h>
#include <aws/sagemaker/model/JupyterLabAppImageConfig.h>
#include <aws/sagemaker/model/JupyterLabAppSettings.h>
#include <aws/sagemaker/model/JupyterServerAppSettings.h>
#include <aws/sagemaker/model/KendraSettings.h>
#include <aws/sagemaker/model/KernelGatewayAppSettings.h>
#include <aws/sagemaker/model/KernelGatewayImageConfig.h>
#include <aws/sagemaker/model/KernelSpec.h>
#include <aws/sagemaker/model/LabelCounters.h>
#include <aws/sagemaker/model/LabelCountersForWorkteam.h>
#include <aws/sagemaker/model/LabelingJobAlgorithmsConfig.h>
#include <aws/sagemaker/model/LabelingJobDataAttributes.h>
#include <aws/sagemaker/model/LabelingJobDataSource.h>
#include <aws/sagemaker/model/LabelingJobForWorkteamSummary.h>
#include <aws/sagemaker/model/LabelingJobInputConfig.h>
#include <aws/sagemaker/model/LabelingJobOutput.h>
#include <aws/sagemaker/model/LabelingJobOutputConfig.h>
#include <aws/sagemaker/model/LabelingJobResourceConfig.h>
#include <aws/sagemaker/model/LabelingJobS3DataSource.h>
#include <aws/sagemaker/model/LabelingJobSnsDataSource.h>
#include <aws/sagemaker/model/LabelingJobStatus.h>
#include <aws/sagemaker/model/LabelingJobStoppingConditions.h>
#include <aws/sagemaker/model/LabelingJobSummary.h>
#include <aws/sagemaker/model/LambdaStepMetadata.h>
#include <aws/sagemaker/model/LastUpdateStatus.h>
#include <aws/sagemaker/model/LastUpdateStatusValue.h>
#include <aws/sagemaker/model/LifecycleManagement.h>
#include <aws/sagemaker/model/LineageGroupSummary.h>
#include <aws/sagemaker/model/LineageType.h>
#include <aws/sagemaker/model/ListActionsRequest.h>
#include <aws/sagemaker/model/ListActionsResult.h>
#include <aws/sagemaker/model/ListAlgorithmsRequest.h>
#include <aws/sagemaker/model/ListAlgorithmsResult.h>
#include <aws/sagemaker/model/ListAliasesRequest.h>
#include <aws/sagemaker/model/ListAliasesResult.h>
#include <aws/sagemaker/model/ListAppImageConfigsRequest.h>
#include <aws/sagemaker/model/ListAppImageConfigsResult.h>
#include <aws/sagemaker/model/ListAppsRequest.h>
#include <aws/sagemaker/model/ListAppsResult.h>
#include <aws/sagemaker/model/ListArtifactsRequest.h>
#include <aws/sagemaker/model/ListArtifactsResult.h>
#include <aws/sagemaker/model/ListAssociationsRequest.h>
#include <aws/sagemaker/model/ListAssociationsResult.h>
#include <aws/sagemaker/model/ListAutoMLJobsRequest.h>
#include <aws/sagemaker/model/ListAutoMLJobsResult.h>
#include <aws/sagemaker/model/ListCandidatesForAutoMLJobRequest.h>
#include <aws/sagemaker/model/ListCandidatesForAutoMLJobResult.h>
#include <aws/sagemaker/model/ListClusterNodesRequest.h>
#include <aws/sagemaker/model/ListClusterNodesResult.h>
#include <aws/sagemaker/model/ListClusterSchedulerConfigsRequest.h>
#include <aws/sagemaker/model/ListClusterSchedulerConfigsResult.h>
#include <aws/sagemaker/model/ListClustersRequest.h>
#include <aws/sagemaker/model/ListClustersResult.h>
#include <aws/sagemaker/model/ListCodeRepositoriesRequest.h>
#include <aws/sagemaker/model/ListCodeRepositoriesResult.h>
#include <aws/sagemaker/model/ListCompilationJobsRequest.h>
#include <aws/sagemaker/model/ListCompilationJobsResult.h>
#include <aws/sagemaker/model/ListCompilationJobsSortBy.h>
#include <aws/sagemaker/model/ListComputeQuotasRequest.h>
#include <aws/sagemaker/model/ListComputeQuotasResult.h>
#include <aws/sagemaker/model/ListContextsRequest.h>
#include <aws/sagemaker/model/ListContextsResult.h>
#include <aws/sagemaker/model/ListDataQualityJobDefinitionsRequest.h>
#include <aws/sagemaker/model/ListDataQualityJobDefinitionsResult.h>
#include <aws/sagemaker/model/ListDeviceFleetsRequest.h>
#include <aws/sagemaker/model/ListDeviceFleetsResult.h>
#include <aws/sagemaker/model/ListDeviceFleetsSortBy.h>
#include <aws/sagemaker/model/ListDevicesRequest.h>
#include <aws/sagemaker/model/ListDevicesResult.h>
#include <aws/sagemaker/model/ListDomainsRequest.h>
#include <aws/sagemaker/model/ListDomainsResult.h>
#include <aws/sagemaker/model/ListEdgeDeploymentPlansRequest.h>
#include <aws/sagemaker/model/ListEdgeDeploymentPlansResult.h>
#include <aws/sagemaker/model/ListEdgeDeploymentPlansSortBy.h>
#include <aws/sagemaker/model/ListEdgePackagingJobsRequest.h>
#include <aws/sagemaker/model/ListEdgePackagingJobsResult.h>
#include <aws/sagemaker/model/ListEdgePackagingJobsSortBy.h>
#include <aws/sagemaker/model/ListEndpointConfigsRequest.h>
#include <aws/sagemaker/model/ListEndpointConfigsResult.h>
#include <aws/sagemaker/model/ListEndpointsRequest.h>
#include <aws/sagemaker/model/ListEndpointsResult.h>
#include <aws/sagemaker/model/ListExperimentsRequest.h>
#include <aws/sagemaker/model/ListExperimentsResult.h>
#include <aws/sagemaker/model/ListFeatureGroupsRequest.h>
#include <aws/sagemaker/model/ListFeatureGroupsResult.h>
#include <aws/sagemaker/model/ListFlowDefinitionsRequest.h>
#include <aws/sagemaker/model/ListFlowDefinitionsResult.h>
#include <aws/sagemaker/model/ListHubContentVersionsRequest.h>
#include <aws/sagemaker/model/ListHubContentVersionsResult.h>
#include <aws/sagemaker/model/ListHubContentsRequest.h>
#include <aws/sagemaker/model/ListHubContentsResult.h>
#include <aws/sagemaker/model/ListHubsRequest.h>
#include <aws/sagemaker/model/ListHubsResult.h>
#include <aws/sagemaker/model/ListHumanTaskUisRequest.h>
#include <aws/sagemaker/model/ListHumanTaskUisResult.h>
#include <aws/sagemaker/model/ListHyperParameterTuningJobsRequest.h>
#include <aws/sagemaker/model/ListHyperParameterTuningJobsResult.h>
#include <aws/sagemaker/model/ListImageVersionsRequest.h>
#include <aws/sagemaker/model/ListImageVersionsResult.h>
#include <aws/sagemaker/model/ListImagesRequest.h>
#include <aws/sagemaker/model/ListImagesResult.h>
#include <aws/sagemaker/model/ListInferenceComponentsRequest.h>
#include <aws/sagemaker/model/ListInferenceComponentsResult.h>
#include <aws/sagemaker/model/ListInferenceExperimentsRequest.h>
#include <aws/sagemaker/model/ListInferenceExperimentsResult.h>
#include <aws/sagemaker/model/ListInferenceRecommendationsJobStepsRequest.h>
#include <aws/sagemaker/model/ListInferenceRecommendationsJobStepsResult.h>
#include <aws/sagemaker/model/ListInferenceRecommendationsJobsRequest.h>
#include <aws/sagemaker/model/ListInferenceRecommendationsJobsResult.h>
#include <aws/sagemaker/model/ListInferenceRecommendationsJobsSortBy.h>
#include <aws/sagemaker/model/ListLabelingJobsForWorkteamRequest.h>
#include <aws/sagemaker/model/ListLabelingJobsForWorkteamResult.h>
#include <aws/sagemaker/model/ListLabelingJobsForWorkteamSortByOptions.h>
#include <aws/sagemaker/model/ListLabelingJobsRequest.h>
#include <aws/sagemaker/model/ListLabelingJobsResult.h>
#include <aws/sagemaker/model/ListLineageGroupsRequest.h>
#include <aws/sagemaker/model/ListLineageGroupsResult.h>
#include <aws/sagemaker/model/ListMlflowTrackingServersRequest.h>
#include <aws/sagemaker/model/ListMlflowTrackingServersResult.h>
#include <aws/sagemaker/model/ListModelBiasJobDefinitionsRequest.h>
#include <aws/sagemaker/model/ListModelBiasJobDefinitionsResult.h>
#include <aws/sagemaker/model/ListModelCardExportJobsRequest.h>
#include <aws/sagemaker/model/ListModelCardExportJobsResult.h>
#include <aws/sagemaker/model/ListModelCardVersionsRequest.h>
#include <aws/sagemaker/model/ListModelCardVersionsResult.h>
#include <aws/sagemaker/model/ListModelCardsRequest.h>
#include <aws/sagemaker/model/ListModelCardsResult.h>
#include <aws/sagemaker/model/ListModelExplainabilityJobDefinitionsRequest.h>
#include <aws/sagemaker/model/ListModelExplainabilityJobDefinitionsResult.h>
#include <aws/sagemaker/model/ListModelMetadataRequest.h>
#include <aws/sagemaker/model/ListModelMetadataResult.h>
#include <aws/sagemaker/model/ListModelPackageGroupsRequest.h>
#include <aws/sagemaker/model/ListModelPackageGroupsResult.h>
#include <aws/sagemaker/model/ListModelPackagesRequest.h>
#include <aws/sagemaker/model/ListModelPackagesResult.h>
#include <aws/sagemaker/model/ListModelQualityJobDefinitionsRequest.h>
#include <aws/sagemaker/model/ListModelQualityJobDefinitionsResult.h>
#include <aws/sagemaker/model/ListModelsRequest.h>
#include <aws/sagemaker/model/ListModelsResult.h>
#include <aws/sagemaker/model/ListMonitoringAlertHistoryRequest.h>
#include <aws/sagemaker/model/ListMonitoringAlertHistoryResult.h>
#include <aws/sagemaker/model/ListMonitoringAlertsRequest.h>
#include <aws/sagemaker/model/ListMonitoringAlertsResult.h>
#include <aws/sagemaker/model/ListMonitoringExecutionsRequest.h>
#include <aws/sagemaker/model/ListMonitoringExecutionsResult.h>
#include <aws/sagemaker/model/ListMonitoringSchedulesRequest.h>
#include <aws/sagemaker/model/ListMonitoringSchedulesResult.h>
#include <aws/sagemaker/model/ListNotebookInstanceLifecycleConfigsRequest.h>
#include <aws/sagemaker/model/ListNotebookInstanceLifecycleConfigsResult.h>
#include <aws/sagemaker/model/ListNotebookInstancesRequest.h>
#include <aws/sagemaker/model/ListNotebookInstancesResult.h>
#include <aws/sagemaker/model/ListOptimizationJobsRequest.h>
#include <aws/sagemaker/model/ListOptimizationJobsResult.h>
#include <aws/sagemaker/model/ListOptimizationJobsSortBy.h>
#include <aws/sagemaker/model/ListPartnerAppsRequest.h>
#include <aws/sagemaker/model/ListPartnerAppsResult.h>
#include <aws/sagemaker/model/ListPipelineExecutionStepsRequest.h>
#include <aws/sagemaker/model/ListPipelineExecutionStepsResult.h>
#include <aws/sagemaker/model/ListPipelineExecutionsRequest.h>
#include <aws/sagemaker/model/ListPipelineExecutionsResult.h>
#include <aws/sagemaker/model/ListPipelineParametersForExecutionRequest.h>
#include <aws/sagemaker/model/ListPipelineParametersForExecutionResult.h>
#include <aws/sagemaker/model/ListPipelinesRequest.h>
#include <aws/sagemaker/model/ListPipelinesResult.h>
#include <aws/sagemaker/model/ListProcessingJobsRequest.h>
#include <aws/sagemaker/model/ListProcessingJobsResult.h>
#include <aws/sagemaker/model/ListProjectsRequest.h>
#include <aws/sagemaker/model/ListProjectsResult.h>
#include <aws/sagemaker/model/ListResourceCatalogsRequest.h>
#include <aws/sagemaker/model/ListResourceCatalogsResult.h>
#include <aws/sagemaker/model/ListSpacesRequest.h>
#include <aws/sagemaker/model/ListSpacesResult.h>
#include <aws/sagemaker/model/ListStageDevicesRequest.h>
#include <aws/sagemaker/model/ListStageDevicesResult.h>
#include <aws/sagemaker/model/ListStudioLifecycleConfigsRequest.h>
#include <aws/sagemaker/model/ListStudioLifecycleConfigsResult.h>
#include <aws/sagemaker/model/ListSubscribedWorkteamsRequest.h>
#include <aws/sagemaker/model/ListSubscribedWorkteamsResult.h>
#include <aws/sagemaker/model/ListTagsRequest.h>
#include <aws/sagemaker/model/ListTagsResult.h>
#include <aws/sagemaker/model/ListTrainingJobsForHyperParameterTuningJobRequest.h>
#include <aws/sagemaker/model/ListTrainingJobsForHyperParameterTuningJobResult.h>
#include <aws/sagemaker/model/ListTrainingJobsRequest.h>
#include <aws/sagemaker/model/ListTrainingJobsResult.h>
#include <aws/sagemaker/model/ListTrainingPlansRequest.h>
#include <aws/sagemaker/model/ListTrainingPlansResult.h>
#include <aws/sagemaker/model/ListTransformJobsRequest.h>
#include <aws/sagemaker/model/ListTransformJobsResult.h>
#include <aws/sagemaker/model/ListTrialComponentsRequest.h>
#include <aws/sagemaker/model/ListTrialComponentsResult.h>
#include <aws/sagemaker/model/ListTrialsRequest.h>
#include <aws/sagemaker/model/ListTrialsResult.h>
#include <aws/sagemaker/model/ListUserProfilesRequest.h>
#include <aws/sagemaker/model/ListUserProfilesResult.h>
#include <aws/sagemaker/model/ListWorkforcesRequest.h>
#include <aws/sagemaker/model/ListWorkforcesResult.h>
#include <aws/sagemaker/model/ListWorkforcesSortByOptions.h>
#include <aws/sagemaker/model/ListWorkteamsRequest.h>
#include <aws/sagemaker/model/ListWorkteamsResult.h>
#include <aws/sagemaker/model/ListWorkteamsSortByOptions.h>
#include <aws/sagemaker/model/ManagedInstanceScalingStatus.h>
#include <aws/sagemaker/model/MemberDefinition.h>
#include <aws/sagemaker/model/MetadataProperties.h>
#include <aws/sagemaker/model/MetricData.h>
#include <aws/sagemaker/model/MetricDatum.h>
#include <aws/sagemaker/model/MetricDefinition.h>
#include <aws/sagemaker/model/MetricSetSource.h>
#include <aws/sagemaker/model/MetricSpecification.h>
#include <aws/sagemaker/model/MetricsSource.h>
#include <aws/sagemaker/model/MlTools.h>
#include <aws/sagemaker/model/Model.h>
#include <aws/sagemaker/model/ModelAccessConfig.h>
#include <aws/sagemaker/model/ModelApprovalStatus.h>
#include <aws/sagemaker/model/ModelArtifacts.h>
#include <aws/sagemaker/model/ModelBiasAppSpecification.h>
#include <aws/sagemaker/model/ModelBiasBaselineConfig.h>
#include <aws/sagemaker/model/ModelBiasJobInput.h>
#include <aws/sagemaker/model/ModelCacheSetting.h>
#include <aws/sagemaker/model/ModelCard.h>
#include <aws/sagemaker/model/ModelCardExportArtifacts.h>
#include <aws/sagemaker/model/ModelCardExportJobSortBy.h>
#include <aws/sagemaker/model/ModelCardExportJobSortOrder.h>
#include <aws/sagemaker/model/ModelCardExportJobStatus.h>
#include <aws/sagemaker/model/ModelCardExportJobSummary.h>
#include <aws/sagemaker/model/ModelCardExportOutputConfig.h>
#include <aws/sagemaker/model/ModelCardProcessingStatus.h>
#include <aws/sagemaker/model/ModelCardSecurityConfig.h>
#include <aws/sagemaker/model/ModelCardSortBy.h>
#include <aws/sagemaker/model/ModelCardSortOrder.h>
#include <aws/sagemaker/model/ModelCardStatus.h>
#include <aws/sagemaker/model/ModelCardSummary.h>
#include <aws/sagemaker/model/ModelCardVersionSortBy.h>
#include <aws/sagemaker/model/ModelCardVersionSummary.h>
#include <aws/sagemaker/model/ModelClientConfig.h>
#include <aws/sagemaker/model/ModelCompilationConfig.h>
#include <aws/sagemaker/model/ModelCompressionType.h>
#include <aws/sagemaker/model/ModelConfiguration.h>
#include <aws/sagemaker/model/ModelDashboardEndpoint.h>
#include <aws/sagemaker/model/ModelDashboardIndicatorAction.h>
#include <aws/sagemaker/model/ModelDashboardModel.h>
#include <aws/sagemaker/model/ModelDashboardModelCard.h>
#include <aws/sagemaker/model/ModelDashboardMonitoringSchedule.h>
#include <aws/sagemaker/model/ModelDataQuality.h>
#include <aws/sagemaker/model/ModelDataSource.h>
#include <aws/sagemaker/model/ModelDeployConfig.h>
#include <aws/sagemaker/model/ModelDeployResult.h>
#include <aws/sagemaker/model/ModelDigests.h>
#include <aws/sagemaker/model/ModelExplainabilityAppSpecification.h>
#include <aws/sagemaker/model/ModelExplainabilityBaselineConfig.h>
#include <aws/sagemaker/model/ModelExplainabilityJobInput.h>
#include <aws/sagemaker/model/ModelInfrastructureConfig.h>
#include <aws/sagemaker/model/ModelInfrastructureType.h>
#include <aws/sagemaker/model/ModelInput.h>
#include <aws/sagemaker/model/ModelLatencyThreshold.h>
#include <aws/sagemaker/model/ModelLifeCycle.h>
#include <aws/sagemaker/model/ModelMetadataFilter.h>
#include <aws/sagemaker/model/ModelMetadataFilterType.h>
#include <aws/sagemaker/model/ModelMetadataSearchExpression.h>
#include <aws/sagemaker/model/ModelMetadataSummary.h>
#include <aws/sagemaker/model/ModelMetrics.h>
#include <aws/sagemaker/model/ModelPackage.h>
#include <aws/sagemaker/model/ModelPackageContainerDefinition.h>
#include <aws/sagemaker/model/ModelPackageGroup.h>
#include <aws/sagemaker/model/ModelPackageGroupSortBy.h>
#include <aws/sagemaker/model/ModelPackageGroupStatus.h>
#include <aws/sagemaker/model/ModelPackageGroupSummary.h>
#include <aws/sagemaker/model/ModelPackageModelCard.h>
#include <aws/sagemaker/model/ModelPackageSecurityConfig.h>
#include <aws/sagemaker/model/ModelPackageSortBy.h>
#include <aws/sagemaker/model/ModelPackageStatus.h>
#include <aws/sagemaker/model/ModelPackageStatusDetails.h>
#include <aws/sagemaker/model/ModelPackageStatusItem.h>
#include <aws/sagemaker/model/ModelPackageSummary.h>
#include <aws/sagemaker/model/ModelPackageType.h>
#include <aws/sagemaker/model/ModelPackageValidationProfile.h>
#include <aws/sagemaker/model/ModelPackageValidationSpecification.h>
#include <aws/sagemaker/model/ModelQuality.h>
#include <aws/sagemaker/model/ModelQualityAppSpecification.h>
#include <aws/sagemaker/model/ModelQualityBaselineConfig.h>
#include <aws/sagemaker/model/ModelQualityJobInput.h>
#include <aws/sagemaker/model/ModelQuantizationConfig.h>
#include <aws/sagemaker/model/ModelRegisterSettings.h>
#include <aws/sagemaker/model/ModelShardingConfig.h>
#include <aws/sagemaker/model/ModelSortKey.h>
#include <aws/sagemaker/model/ModelStepMetadata.h>
#include <aws/sagemaker/model/ModelSummary.h>
#include <aws/sagemaker/model/ModelVariantAction.h>
#include <aws/sagemaker/model/ModelVariantConfig.h>
#include <aws/sagemaker/model/ModelVariantConfigSummary.h>
#include <aws/sagemaker/model/ModelVariantStatus.h>
#include <aws/sagemaker/model/MonitoringAlertActions.h>
#include <aws/sagemaker/model/MonitoringAlertHistorySortKey.h>
#include <aws/sagemaker/model/MonitoringAlertHistorySummary.h>
#include <aws/sagemaker/model/MonitoringAlertStatus.h>
#include <aws/sagemaker/model/MonitoringAlertSummary.h>
#include <aws/sagemaker/model/MonitoringAppSpecification.h>
#include <aws/sagemaker/model/MonitoringBaselineConfig.h>
#include <aws/sagemaker/model/MonitoringClusterConfig.h>
#include <aws/sagemaker/model/MonitoringConstraintsResource.h>
#include <aws/sagemaker/model/MonitoringCsvDatasetFormat.h>
#include <aws/sagemaker/model/MonitoringDatasetFormat.h>
#include <aws/sagemaker/model/MonitoringExecutionSortKey.h>
#include <aws/sagemaker/model/MonitoringExecutionSummary.h>
#include <aws/sagemaker/model/MonitoringGroundTruthS3Input.h>
#include <aws/sagemaker/model/MonitoringInput.h>
#include <aws/sagemaker/model/MonitoringJobDefinition.h>
#include <aws/sagemaker/model/MonitoringJobDefinitionSortKey.h>
#include <aws/sagemaker/model/MonitoringJobDefinitionSummary.h>
#include <aws/sagemaker/model/MonitoringJsonDatasetFormat.h>
#include <aws/sagemaker/model/MonitoringNetworkConfig.h>
#include <aws/sagemaker/model/MonitoringOutput.h>
#include <aws/sagemaker/model/MonitoringOutputConfig.h>
#include <aws/sagemaker/model/MonitoringParquetDatasetFormat.h>
#include <aws/sagemaker/model/MonitoringProblemType.h>
#include <aws/sagemaker/model/MonitoringResources.h>
#include <aws/sagemaker/model/MonitoringS3Output.h>
#include <aws/sagemaker/model/MonitoringSchedule.h>
#include <aws/sagemaker/model/MonitoringScheduleConfig.h>
#include <aws/sagemaker/model/MonitoringScheduleSortKey.h>
#include <aws/sagemaker/model/MonitoringScheduleSummary.h>
#include <aws/sagemaker/model/MonitoringStatisticsResource.h>
#include <aws/sagemaker/model/MonitoringStoppingCondition.h>
#include <aws/sagemaker/model/MonitoringType.h>
#include <aws/sagemaker/model/MultiModelConfig.h>
#include <aws/sagemaker/model/NeoVpcConfig.h>
#include <aws/sagemaker/model/NestedFilters.h>
#include <aws/sagemaker/model/NetworkConfig.h>
#include <aws/sagemaker/model/NodeUnavailabilityType.h>
#include <aws/sagemaker/model/NotebookInstanceAcceleratorType.h>
#include <aws/sagemaker/model/NotebookInstanceLifecycleConfigSortKey.h>
#include <aws/sagemaker/model/NotebookInstanceLifecycleConfigSortOrder.h>
#include <aws/sagemaker/model/NotebookInstanceLifecycleConfigSummary.h>
#include <aws/sagemaker/model/NotebookInstanceLifecycleHook.h>
#include <aws/sagemaker/model/NotebookInstanceSortKey.h>
#include <aws/sagemaker/model/NotebookInstanceSortOrder.h>
#include <aws/sagemaker/model/NotebookInstanceStatus.h>
#include <aws/sagemaker/model/NotebookInstanceSummary.h>
#include <aws/sagemaker/model/NotebookOutputOption.h>
#include <aws/sagemaker/model/NotificationConfiguration.h>
#include <aws/sagemaker/model/ObjectiveStatus.h>
#include <aws/sagemaker/model/ObjectiveStatusCounters.h>
#include <aws/sagemaker/model/OfflineStoreConfig.h>
#include <aws/sagemaker/model/OfflineStoreStatus.h>
#include <aws/sagemaker/model/OfflineStoreStatusValue.h>
#include <aws/sagemaker/model/OidcConfig.h>
#include <aws/sagemaker/model/OidcConfigForResponse.h>
#include <aws/sagemaker/model/OidcMemberDefinition.h>
#include <aws/sagemaker/model/OnlineStoreConfig.h>
#include <aws/sagemaker/model/OnlineStoreConfigUpdate.h>
#include <aws/sagemaker/model/OnlineStoreSecurityConfig.h>
#include <aws/sagemaker/model/Operator.h>
#include <aws/sagemaker/model/OptimizationConfig.h>
#include <aws/sagemaker/model/OptimizationJobDeploymentInstanceType.h>
#include <aws/sagemaker/model/OptimizationJobModelSource.h>
#include <aws/sagemaker/model/OptimizationJobModelSourceS3.h>
#include <aws/sagemaker/model/OptimizationJobOutputConfig.h>
#include <aws/sagemaker/model/OptimizationJobStatus.h>
#include <aws/sagemaker/model/OptimizationJobSummary.h>
#include <aws/sagemaker/model/OptimizationModelAccessConfig.h>
#include <aws/sagemaker/model/OptimizationOutput.h>
#include <aws/sagemaker/model/OptimizationVpcConfig.h>
#include <aws/sagemaker/model/OrderKey.h>
#include <aws/sagemaker/model/OutputCompressionType.h>
#include <aws/sagemaker/model/OutputConfig.h>
#include <aws/sagemaker/model/OutputDataConfig.h>
#include <aws/sagemaker/model/OutputParameter.h>
#include <aws/sagemaker/model/OwnershipSettings.h>
#include <aws/sagemaker/model/OwnershipSettingsSummary.h>
#include <aws/sagemaker/model/ParallelismConfiguration.h>
#include <aws/sagemaker/model/Parameter.h>
#include <aws/sagemaker/model/ParameterRange.h>
#include <aws/sagemaker/model/ParameterRanges.h>
#include <aws/sagemaker/model/ParameterType.h>
#include <aws/sagemaker/model/Parent.h>
#include <aws/sagemaker/model/ParentHyperParameterTuningJob.h>
#include <aws/sagemaker/model/PartnerAppAuthType.h>
#include <aws/sagemaker/model/PartnerAppConfig.h>
#include <aws/sagemaker/model/PartnerAppMaintenanceConfig.h>
#include <aws/sagemaker/model/PartnerAppStatus.h>
#include <aws/sagemaker/model/PartnerAppSummary.h>
#include <aws/sagemaker/model/PartnerAppType.h>
#include <aws/sagemaker/model/PendingDeploymentSummary.h>
#include <aws/sagemaker/model/PendingProductionVariantSummary.h>
#include <aws/sagemaker/model/Phase.h>
#include <aws/sagemaker/model/Pipeline.h>
#include <aws/sagemaker/model/PipelineDefinitionS3Location.h>
#include <aws/sagemaker/model/PipelineExecution.h>
#include <aws/sagemaker/model/PipelineExecutionStatus.h>
#include <aws/sagemaker/model/PipelineExecutionStep.h>
#include <aws/sagemaker/model/PipelineExecutionStepMetadata.h>
#include <aws/sagemaker/model/PipelineExecutionSummary.h>
#include <aws/sagemaker/model/PipelineExperimentConfig.h>
#include <aws/sagemaker/model/PipelineStatus.h>
#include <aws/sagemaker/model/PipelineSummary.h>
#include <aws/sagemaker/model/PredefinedMetricSpecification.h>
#include <aws/sagemaker/model/PreemptTeamTasks.h>
#include <aws/sagemaker/model/PriorityClass.h>
#include <aws/sagemaker/model/ProblemType.h>
#include <aws/sagemaker/model/ProcessingClusterConfig.h>
#include <aws/sagemaker/model/ProcessingFeatureStoreOutput.h>
#include <aws/sagemaker/model/ProcessingInput.h>
#include <aws/sagemaker/model/ProcessingInstanceType.h>
#include <aws/sagemaker/model/ProcessingJob.h>
#include <aws/sagemaker/model/ProcessingJobStatus.h>
#include <aws/sagemaker/model/ProcessingJobStepMetadata.h>
#include <aws/sagemaker/model/ProcessingJobSummary.h>
#include <aws/sagemaker/model/ProcessingOutput.h>
#include <aws/sagemaker/model/ProcessingOutputConfig.h>
#include <aws/sagemaker/model/ProcessingResources.h>
#include <aws/sagemaker/model/ProcessingS3CompressionType.h>
#include <aws/sagemaker/model/ProcessingS3DataDistributionType.h>
#include <aws/sagemaker/model/ProcessingS3DataType.h>
#include <aws/sagemaker/model/ProcessingS3Input.h>
#include <aws/sagemaker/model/ProcessingS3InputMode.h>
#include <aws/sagemaker/model/ProcessingS3Output.h>
#include <aws/sagemaker/model/ProcessingS3UploadMode.h>
#include <aws/sagemaker/model/ProcessingStoppingCondition.h>
#include <aws/sagemaker/model/Processor.h>
#include <aws/sagemaker/model/ProductionVariant.h>
#include <aws/sagemaker/model/ProductionVariantAcceleratorType.h>
#include <aws/sagemaker/model/ProductionVariantCapacityReservationConfig.h>
#include <aws/sagemaker/model/ProductionVariantCapacityReservationSummary.h>
#include <aws/sagemaker/model/ProductionVariantCoreDumpConfig.h>
#include <aws/sagemaker/model/ProductionVariantInferenceAmiVersion.h>
#include <aws/sagemaker/model/ProductionVariantInstanceType.h>
#include <aws/sagemaker/model/ProductionVariantManagedInstanceScaling.h>
#include <aws/sagemaker/model/ProductionVariantRoutingConfig.h>
#include <aws/sagemaker/model/ProductionVariantServerlessConfig.h>
#include <aws/sagemaker/model/ProductionVariantServerlessUpdateConfig.h>
#include <aws/sagemaker/model/ProductionVariantStatus.h>
#include <aws/sagemaker/model/ProductionVariantSummary.h>
#include <aws/sagemaker/model/ProfilerConfig.h>
#include <aws/sagemaker/model/ProfilerConfigForUpdate.h>
#include <aws/sagemaker/model/ProfilerRuleConfiguration.h>
#include <aws/sagemaker/model/ProfilerRuleEvaluationStatus.h>
#include <aws/sagemaker/model/ProfilingStatus.h>
#include <aws/sagemaker/model/Project.h>
#include <aws/sagemaker/model/ProjectSortBy.h>
#include <aws/sagemaker/model/ProjectSortOrder.h>
#include <aws/sagemaker/model/ProjectStatus.h>
#include <aws/sagemaker/model/ProjectSummary.h>
#include <aws/sagemaker/model/PropertyNameQuery.h>
#include <aws/sagemaker/model/PropertyNameSuggestion.h>
#include <aws/sagemaker/model/ProvisioningParameter.h>
#include <aws/sagemaker/model/PublicWorkforceTaskPrice.h>
#include <aws/sagemaker/model/PutModelPackageGroupPolicyRequest.h>
#include <aws/sagemaker/model/PutModelPackageGroupPolicyResult.h>
#include <aws/sagemaker/model/QualityCheckStepMetadata.h>
#include <aws/sagemaker/model/QueryFilters.h>
#include <aws/sagemaker/model/QueryLineageRequest.h>
#include <aws/sagemaker/model/QueryLineageResult.h>
#include <aws/sagemaker/model/RSessionAppSettings.h>
#include <aws/sagemaker/model/RStudioServerProAccessStatus.h>
#include <aws/sagemaker/model/RStudioServerProAppSettings.h>
#include <aws/sagemaker/model/RStudioServerProDomainSettings.h>
#include <aws/sagemaker/model/RStudioServerProDomainSettingsForUpdate.h>
#include <aws/sagemaker/model/RStudioServerProUserGroup.h>
#include <aws/sagemaker/model/RealTimeInferenceConfig.h>
#include <aws/sagemaker/model/RealTimeInferenceRecommendation.h>
#include <aws/sagemaker/model/RecommendationJobCompiledOutputConfig.h>
#include <aws/sagemaker/model/RecommendationJobContainerConfig.h>
#include <aws/sagemaker/model/RecommendationJobInferenceBenchmark.h>
#include <aws/sagemaker/model/RecommendationJobInputConfig.h>
#include <aws/sagemaker/model/RecommendationJobOutputConfig.h>
#include <aws/sagemaker/model/RecommendationJobPayloadConfig.h>
#include <aws/sagemaker/model/RecommendationJobResourceLimit.h>
#include <aws/sagemaker/model/RecommendationJobStatus.h>
#include <aws/sagemaker/model/RecommendationJobStoppingConditions.h>
#include <aws/sagemaker/model/RecommendationJobSupportedEndpointType.h>
#include <aws/sagemaker/model/RecommendationJobType.h>
#include <aws/sagemaker/model/RecommendationJobVpcConfig.h>
#include <aws/sagemaker/model/RecommendationMetrics.h>
#include <aws/sagemaker/model/RecommendationStatus.h>
#include <aws/sagemaker/model/RecommendationStepType.h>
#include <aws/sagemaker/model/RecordWrapper.h>
#include <aws/sagemaker/model/RedshiftDatasetDefinition.h>
#include <aws/sagemaker/model/RedshiftResultCompressionType.h>
#include <aws/sagemaker/model/RedshiftResultFormat.h>
#include <aws/sagemaker/model/RegisterDevicesRequest.h>
#include <aws/sagemaker/model/RegisterModelStepMetadata.h>
#include <aws/sagemaker/model/Relation.h>
#include <aws/sagemaker/model/RemoteDebugConfig.h>
#include <aws/sagemaker/model/RemoteDebugConfigForUpdate.h>
#include <aws/sagemaker/model/RenderUiTemplateRequest.h>
#include <aws/sagemaker/model/RenderUiTemplateResult.h>
#include <aws/sagemaker/model/RenderableTask.h>
#include <aws/sagemaker/model/RenderingError.h>
#include <aws/sagemaker/model/RepositoryAccessMode.h>
#include <aws/sagemaker/model/RepositoryAuthConfig.h>
#include <aws/sagemaker/model/ReservedCapacityInstanceType.h>
#include <aws/sagemaker/model/ReservedCapacityOffering.h>
#include <aws/sagemaker/model/ReservedCapacityStatus.h>
#include <aws/sagemaker/model/ReservedCapacitySummary.h>
#include <aws/sagemaker/model/ResolvedAttributes.h>
#include <aws/sagemaker/model/ResourceCatalog.h>
#include <aws/sagemaker/model/ResourceCatalogSortBy.h>
#include <aws/sagemaker/model/ResourceCatalogSortOrder.h>
#include <aws/sagemaker/model/ResourceConfig.h>
#include <aws/sagemaker/model/ResourceConfigForUpdate.h>
#include <aws/sagemaker/model/ResourceLimits.h>
#include <aws/sagemaker/model/ResourceSharingConfig.h>
#include <aws/sagemaker/model/ResourceSharingStrategy.h>
#include <aws/sagemaker/model/ResourceSpec.h>
#include <aws/sagemaker/model/ResourceType.h>
#include <aws/sagemaker/model/RetentionPolicy.h>
#include <aws/sagemaker/model/RetentionType.h>
#include <aws/sagemaker/model/RetryPipelineExecutionRequest.h>
#include <aws/sagemaker/model/RetryPipelineExecutionResult.h>
#include <aws/sagemaker/model/RetryStrategy.h>
#include <aws/sagemaker/model/RollingDeploymentPolicy.h>
#include <aws/sagemaker/model/RollingUpdatePolicy.h>
#include <aws/sagemaker/model/RootAccess.h>
#include <aws/sagemaker/model/RoutingStrategy.h>
#include <aws/sagemaker/model/RuleEvaluationStatus.h>
#include <aws/sagemaker/model/S3DataDistribution.h>
#include <aws/sagemaker/model/S3DataSource.h>
#include <aws/sagemaker/model/S3DataType.h>
#include <aws/sagemaker/model/S3ModelDataSource.h>
#include <aws/sagemaker/model/S3ModelDataType.h>
#include <aws/sagemaker/model/S3Presign.h>
#include <aws/sagemaker/model/S3StorageConfig.h>
#include <aws/sagemaker/model/SageMakerImageName.h>
#include <aws/sagemaker/model/SageMakerResourceName.h>
#include <aws/sagemaker/model/SagemakerServicecatalogStatus.h>
#include <aws/sagemaker/model/ScalingPolicy.h>
#include <aws/sagemaker/model/ScalingPolicyMetric.h>
#include <aws/sagemaker/model/ScalingPolicyObjective.h>
#include <aws/sagemaker/model/ScheduleConfig.h>
#include <aws/sagemaker/model/ScheduleStatus.h>
#include <aws/sagemaker/model/ScheduledUpdateConfig.h>
#include <aws/sagemaker/model/SchedulerConfig.h>
#include <aws/sagemaker/model/SchedulerResourceStatus.h>
#include <aws/sagemaker/model/SearchExpression.h>
#include <aws/sagemaker/model/SearchRecord.h>
#include <aws/sagemaker/model/SearchRequest.h>
#include <aws/sagemaker/model/SearchResult.h>
#include <aws/sagemaker/model/SearchSortOrder.h>
#include <aws/sagemaker/model/SearchTrainingPlanOfferingsRequest.h>
#include <aws/sagemaker/model/SearchTrainingPlanOfferingsResult.h>
#include <aws/sagemaker/model/SecondaryStatus.h>
#include <aws/sagemaker/model/SecondaryStatusTransition.h>
#include <aws/sagemaker/model/SelectedStep.h>
#include <aws/sagemaker/model/SelectiveExecutionConfig.h>
#include <aws/sagemaker/model/SelectiveExecutionResult.h>
#include <aws/sagemaker/model/SendPipelineExecutionStepFailureRequest.h>
#include <aws/sagemaker/model/SendPipelineExecutionStepFailureResult.h>
#include <aws/sagemaker/model/SendPipelineExecutionStepSuccessRequest.h>
#include <aws/sagemaker/model/SendPipelineExecutionStepSuccessResult.h>
#include <aws/sagemaker/model/ServiceCatalogProvisionedProductDetails.h>
#include <aws/sagemaker/model/ServiceCatalogProvisioningDetails.h>
#include <aws/sagemaker/model/ServiceCatalogProvisioningUpdateDetails.h>
#include <aws/sagemaker/model/SessionChainingConfig.h>
#include <aws/sagemaker/model/ShadowModeConfig.h>
#include <aws/sagemaker/model/ShadowModelVariantConfig.h>
#include <aws/sagemaker/model/SharingSettings.h>
#include <aws/sagemaker/model/SharingType.h>
#include <aws/sagemaker/model/ShuffleConfig.h>
#include <aws/sagemaker/model/SkipModelValidation.h>
#include <aws/sagemaker/model/SortActionsBy.h>
#include <aws/sagemaker/model/SortArtifactsBy.h>
#include <aws/sagemaker/model/SortAssociationsBy.h>
#include <aws/sagemaker/model/SortBy.h>
#include <aws/sagemaker/model/SortClusterSchedulerConfigBy.h>
#include <aws/sagemaker/model/SortContextsBy.h>
#include <aws/sagemaker/model/SortExperimentsBy.h>
#include <aws/sagemaker/model/SortInferenceExperimentsBy.h>
#include <aws/sagemaker/model/SortLineageGroupsBy.h>
#include <aws/sagemaker/model/SortOrder.h>
#include <aws/sagemaker/model/SortPipelineExecutionsBy.h>
#include <aws/sagemaker/model/SortPipelinesBy.h>
#include <aws/sagemaker/model/SortQuotaBy.h>
#include <aws/sagemaker/model/SortTrackingServerBy.h>
#include <aws/sagemaker/model/SortTrialComponentsBy.h>
#include <aws/sagemaker/model/SortTrialsBy.h>
#include <aws/sagemaker/model/SourceAlgorithm.h>
#include <aws/sagemaker/model/SourceAlgorithmSpecification.h>
#include <aws/sagemaker/model/SourceIpConfig.h>
#include <aws/sagemaker/model/SpaceAppLifecycleManagement.h>
#include <aws/sagemaker/model/SpaceCodeEditorAppSettings.h>
#include <aws/sagemaker/model/SpaceDetails.h>
#include <aws/sagemaker/model/SpaceIdleSettings.h>
#include <aws/sagemaker/model/SpaceJupyterLabAppSettings.h>
#include <aws/sagemaker/model/SpaceSettings.h>
#include <aws/sagemaker/model/SpaceSettingsSummary.h>
#include <aws/sagemaker/model/SpaceSharingSettings.h>
#include <aws/sagemaker/model/SpaceSharingSettingsSummary.h>
#include <aws/sagemaker/model/SpaceSortKey.h>
#include <aws/sagemaker/model/SpaceStatus.h>
#include <aws/sagemaker/model/SpaceStorageSettings.h>
#include <aws/sagemaker/model/SplitType.h>
#include <aws/sagemaker/model/StageStatus.h>
#include <aws/sagemaker/model/Stairs.h>
#include <aws/sagemaker/model/StartEdgeDeploymentStageRequest.h>
#include <aws/sagemaker/model/StartInferenceExperimentRequest.h>
#include <aws/sagemaker/model/StartInferenceExperimentResult.h>
#include <aws/sagemaker/model/StartMlflowTrackingServerRequest.h>
#include <aws/sagemaker/model/StartMlflowTrackingServerResult.h>
#include <aws/sagemaker/model/StartMonitoringScheduleRequest.h>
#include <aws/sagemaker/model/StartNotebookInstanceRequest.h>
#include <aws/sagemaker/model/StartPipelineExecutionRequest.h>
#include <aws/sagemaker/model/StartPipelineExecutionResult.h>
#include <aws/sagemaker/model/Statistic.h>
#include <aws/sagemaker/model/StepStatus.h>
#include <aws/sagemaker/model/StopAutoMLJobRequest.h>
#include <aws/sagemaker/model/StopCompilationJobRequest.h>
#include <aws/sagemaker/model/StopEdgeDeploymentStageRequest.h>
#include <aws/sagemaker/model/StopEdgePackagingJobRequest.h>
#include <aws/sagemaker/model/StopHyperParameterTuningJobRequest.h>
#include <aws/sagemaker/model/StopInferenceExperimentRequest.h>
#include <aws/sagemaker/model/StopInferenceExperimentResult.h>
#include <aws/sagemaker/model/StopInferenceRecommendationsJobRequest.h>
#include <aws/sagemaker/model/StopLabelingJobRequest.h>
#include <aws/sagemaker/model/StopMlflowTrackingServerRequest.h>
#include <aws/sagemaker/model/StopMlflowTrackingServerResult.h>
#include <aws/sagemaker/model/StopMonitoringScheduleRequest.h>
#include <aws/sagemaker/model/StopNotebookInstanceRequest.h>
#include <aws/sagemaker/model/StopOptimizationJobRequest.h>
#include <aws/sagemaker/model/StopPipelineExecutionRequest.h>
#include <aws/sagemaker/model/StopPipelineExecutionResult.h>
#include <aws/sagemaker/model/StopProcessingJobRequest.h>
#include <aws/sagemaker/model/StopTrainingJobRequest.h>
#include <aws/sagemaker/model/StopTransformJobRequest.h>
#include <aws/sagemaker/model/StoppingCondition.h>
#include <aws/sagemaker/model/StorageType.h>
#include <aws/sagemaker/model/StudioLifecycleConfigAppType.h>
#include <aws/sagemaker/model/StudioLifecycleConfigDetails.h>
#include <aws/sagemaker/model/StudioLifecycleConfigSortKey.h>
#include <aws/sagemaker/model/StudioWebPortal.h>
#include <aws/sagemaker/model/StudioWebPortalSettings.h>
#include <aws/sagemaker/model/SubscribedWorkteam.h>
#include <aws/sagemaker/model/SuggestionQuery.h>
#include <aws/sagemaker/model/TableFormat.h>
#include <aws/sagemaker/model/TabularJobConfig.h>
#include <aws/sagemaker/model/TabularResolvedAttributes.h>
#include <aws/sagemaker/model/Tag.h>
#include <aws/sagemaker/model/TagPropagation.h>
#include <aws/sagemaker/model/TargetDevice.h>
#include <aws/sagemaker/model/TargetPlatform.h>
#include <aws/sagemaker/model/TargetPlatformAccelerator.h>
#include <aws/sagemaker/model/TargetPlatformArch.h>
#include <aws/sagemaker/model/TargetPlatformOs.h>
#include <aws/sagemaker/model/TargetTrackingScalingPolicyConfiguration.h>
#include <aws/sagemaker/model/TemplateProviderDetail.h>
#include <aws/sagemaker/model/TensorBoardAppSettings.h>
#include <aws/sagemaker/model/TensorBoardOutputConfig.h>
#include <aws/sagemaker/model/TextClassificationJobConfig.h>
#include <aws/sagemaker/model/TextGenerationJobConfig.h>
#include <aws/sagemaker/model/TextGenerationResolvedAttributes.h>
#include <aws/sagemaker/model/ThroughputConfig.h>
#include <aws/sagemaker/model/ThroughputConfigDescription.h>
#include <aws/sagemaker/model/ThroughputConfigUpdate.h>
#include <aws/sagemaker/model/ThroughputMode.h>
#include <aws/sagemaker/model/TimeSeriesConfig.h>
#include <aws/sagemaker/model/TimeSeriesForecastingJobConfig.h>
#include <aws/sagemaker/model/TimeSeriesForecastingSettings.h>
#include <aws/sagemaker/model/TimeSeriesTransformations.h>
#include <aws/sagemaker/model/TotalHits.h>
#include <aws/sagemaker/model/TrackingServerMaintenanceStatus.h>
#include <aws/sagemaker/model/TrackingServerSize.h>
#include <aws/sagemaker/model/TrackingServerStatus.h>
#include <aws/sagemaker/model/TrackingServerSummary.h>
#include <aws/sagemaker/model/TrafficPattern.h>
#include <aws/sagemaker/model/TrafficRoutingConfig.h>
#include <aws/sagemaker/model/TrafficRoutingConfigType.h>
#include <aws/sagemaker/model/TrafficType.h>
#include <aws/sagemaker/model/TrainingImageConfig.h>
#include <aws/sagemaker/model/TrainingInputMode.h>
#include <aws/sagemaker/model/TrainingInstanceType.h>
#include <aws/sagemaker/model/TrainingJob.h>
#include <aws/sagemaker/model/TrainingJobDefinition.h>
#include <aws/sagemaker/model/TrainingJobEarlyStoppingType.h>
#include <aws/sagemaker/model/TrainingJobSortByOptions.h>
#include <aws/sagemaker/model/TrainingJobStatus.h>
#include <aws/sagemaker/model/TrainingJobStatusCounters.h>
#include <aws/sagemaker/model/TrainingJobStepMetadata.h>
#include <aws/sagemaker/model/TrainingJobSummary.h>
#include <aws/sagemaker/model/TrainingPlanFilter.h>
#include <aws/sagemaker/model/TrainingPlanFilterName.h>
#include <aws/sagemaker/model/TrainingPlanOffering.h>
#include <aws/sagemaker/model/TrainingPlanSortBy.h>
#include <aws/sagemaker/model/TrainingPlanSortOrder.h>
#include <aws/sagemaker/model/TrainingPlanStatus.h>
#include <aws/sagemaker/model/TrainingPlanSummary.h>
#include <aws/sagemaker/model/TrainingRepositoryAccessMode.h>
#include <aws/sagemaker/model/TrainingRepositoryAuthConfig.h>
#include <aws/sagemaker/model/TrainingSpecification.h>
#include <aws/sagemaker/model/TransformDataSource.h>
#include <aws/sagemaker/model/TransformInput.h>
#include <aws/sagemaker/model/TransformInstanceType.h>
#include <aws/sagemaker/model/TransformJob.h>
#include <aws/sagemaker/model/TransformJobDefinition.h>
#include <aws/sagemaker/model/TransformJobStatus.h>
#include <aws/sagemaker/model/TransformJobStepMetadata.h>
#include <aws/sagemaker/model/TransformJobSummary.h>
#include <aws/sagemaker/model/TransformOutput.h>
#include <aws/sagemaker/model/TransformResources.h>
#include <aws/sagemaker/model/TransformS3DataSource.h>
#include <aws/sagemaker/model/Trial.h>
#include <aws/sagemaker/model/TrialComponent.h>
#include <aws/sagemaker/model/TrialComponentArtifact.h>
#include <aws/sagemaker/model/TrialComponentMetricSummary.h>
#include <aws/sagemaker/model/TrialComponentParameterValue.h>
#include <aws/sagemaker/model/TrialComponentPrimaryStatus.h>
#include <aws/sagemaker/model/TrialComponentSimpleSummary.h>
#include <aws/sagemaker/model/TrialComponentSource.h>
#include <aws/sagemaker/model/TrialComponentSourceDetail.h>
#include <aws/sagemaker/model/TrialComponentStatus.h>
#include <aws/sagemaker/model/TrialComponentSummary.h>
#include <aws/sagemaker/model/TrialSource.h>
#include <aws/sagemaker/model/TrialSummary.h>
#include <aws/sagemaker/model/TtlDuration.h>
#include <aws/sagemaker/model/TtlDurationUnit.h>
#include <aws/sagemaker/model/TuningJobCompletionCriteria.h>
#include <aws/sagemaker/model/TuningJobStepMetaData.h>
#include <aws/sagemaker/model/USD.h>
#include <aws/sagemaker/model/UiConfig.h>
#include <aws/sagemaker/model/UiTemplate.h>
#include <aws/sagemaker/model/UiTemplateInfo.h>
#include <aws/sagemaker/model/UnifiedStudioSettings.h>
#include <aws/sagemaker/model/UpdateActionRequest.h>
#include <aws/sagemaker/model/UpdateActionResult.h>
#include <aws/sagemaker/model/UpdateAppImageConfigRequest.h>
#include <aws/sagemaker/model/UpdateAppImageConfigResult.h>
#include <aws/sagemaker/model/UpdateArtifactRequest.h>
#include <aws/sagemaker/model/UpdateArtifactResult.h>
#include <aws/sagemaker/model/UpdateClusterRequest.h>
#include <aws/sagemaker/model/UpdateClusterResult.h>
#include <aws/sagemaker/model/UpdateClusterSchedulerConfigRequest.h>
#include <aws/sagemaker/model/UpdateClusterSchedulerConfigResult.h>
#include <aws/sagemaker/model/UpdateClusterSoftwareInstanceGroupSpecification.h>
#include <aws/sagemaker/model/UpdateClusterSoftwareRequest.h>
#include <aws/sagemaker/model/UpdateClusterSoftwareResult.h>
#include <aws/sagemaker/model/UpdateCodeRepositoryRequest.h>
#include <aws/sagemaker/model/UpdateCodeRepositoryResult.h>
#include <aws/sagemaker/model/UpdateComputeQuotaRequest.h>
#include <aws/sagemaker/model/UpdateComputeQuotaResult.h>
#include <aws/sagemaker/model/UpdateContextRequest.h>
#include <aws/sagemaker/model/UpdateContextResult.h>
#include <aws/sagemaker/model/UpdateDeviceFleetRequest.h>
#include <aws/sagemaker/model/UpdateDevicesRequest.h>
#include <aws/sagemaker/model/UpdateDomainRequest.h>
#include <aws/sagemaker/model/UpdateDomainResult.h>
#include <aws/sagemaker/model/UpdateEndpointRequest.h>
#include <aws/sagemaker/model/UpdateEndpointResult.h>
#include <aws/sagemaker/model/UpdateEndpointWeightsAndCapacitiesRequest.h>
#include <aws/sagemaker/model/UpdateEndpointWeightsAndCapacitiesResult.h>
#include <aws/sagemaker/model/UpdateExperimentRequest.h>
#include <aws/sagemaker/model/UpdateExperimentResult.h>
#include <aws/sagemaker/model/UpdateFeatureGroupRequest.h>
#include <aws/sagemaker/model/UpdateFeatureGroupResult.h>
#include <aws/sagemaker/model/UpdateFeatureMetadataRequest.h>
#include <aws/sagemaker/model/UpdateHubContentReferenceRequest.h>
#include <aws/sagemaker/model/UpdateHubContentReferenceResult.h>
#include <aws/sagemaker/model/UpdateHubContentRequest.h>
#include <aws/sagemaker/model/UpdateHubContentResult.h>
#include <aws/sagemaker/model/UpdateHubRequest.h>
#include <aws/sagemaker/model/UpdateHubResult.h>
#include <aws/sagemaker/model/UpdateImageRequest.h>
#include <aws/sagemaker/model/UpdateImageResult.h>
#include <aws/sagemaker/model/UpdateImageVersionRequest.h>
#include <aws/sagemaker/model/UpdateImageVersionResult.h>
#include <aws/sagemaker/model/UpdateInferenceComponentRequest.h>
#include <aws/sagemaker/model/UpdateInferenceComponentResult.h>
#include <aws/sagemaker/model/UpdateInferenceComponentRuntimeConfigRequest.h>
#include <aws/sagemaker/model/UpdateInferenceComponentRuntimeConfigResult.h>
#include <aws/sagemaker/model/UpdateInferenceExperimentRequest.h>
#include <aws/sagemaker/model/UpdateInferenceExperimentResult.h>
#include <aws/sagemaker/model/UpdateMlflowTrackingServerRequest.h>
#include <aws/sagemaker/model/UpdateMlflowTrackingServerResult.h>
#include <aws/sagemaker/model/UpdateModelCardRequest.h>
#include <aws/sagemaker/model/UpdateModelCardResult.h>
#include <aws/sagemaker/model/UpdateModelPackageRequest.h>
#include <aws/sagemaker/model/UpdateModelPackageResult.h>
#include <aws/sagemaker/model/UpdateMonitoringAlertRequest.h>
#include <aws/sagemaker/model/UpdateMonitoringAlertResult.h>
#include <aws/sagemaker/model/UpdateMonitoringScheduleRequest.h>
#include <aws/sagemaker/model/UpdateMonitoringScheduleResult.h>
#include <aws/sagemaker/model/UpdateNotebookInstanceLifecycleConfigRequest.h>
#include <aws/sagemaker/model/UpdateNotebookInstanceLifecycleConfigResult.h>
#include <aws/sagemaker/model/UpdateNotebookInstanceRequest.h>
#include <aws/sagemaker/model/UpdateNotebookInstanceResult.h>
#include <aws/sagemaker/model/UpdatePartnerAppRequest.h>
#include <aws/sagemaker/model/UpdatePartnerAppResult.h>
#include <aws/sagemaker/model/UpdatePipelineExecutionRequest.h>
#include <aws/sagemaker/model/UpdatePipelineExecutionResult.h>
#include <aws/sagemaker/model/UpdatePipelineRequest.h>
#include <aws/sagemaker/model/UpdatePipelineResult.h>
#include <aws/sagemaker/model/UpdateProjectRequest.h>
#include <aws/sagemaker/model/UpdateProjectResult.h>
#include <aws/sagemaker/model/UpdateSpaceRequest.h>
#include <aws/sagemaker/model/UpdateSpaceResult.h>
#include <aws/sagemaker/model/UpdateTemplateProvider.h>
#include <aws/sagemaker/model/UpdateTrainingJobRequest.h>
#include <aws/sagemaker/model/UpdateTrainingJobResult.h>
#include <aws/sagemaker/model/UpdateTrialComponentRequest.h>
#include <aws/sagemaker/model/UpdateTrialComponentResult.h>
#include <aws/sagemaker/model/UpdateTrialRequest.h>
#include <aws/sagemaker/model/UpdateTrialResult.h>
#include <aws/sagemaker/model/UpdateUserProfileRequest.h>
#include <aws/sagemaker/model/UpdateUserProfileResult.h>
#include <aws/sagemaker/model/UpdateWorkforceRequest.h>
#include <aws/sagemaker/model/UpdateWorkforceResult.h>
#include <aws/sagemaker/model/UpdateWorkteamRequest.h>
#include <aws/sagemaker/model/UpdateWorkteamResult.h>
#include <aws/sagemaker/model/UserContext.h>
#include <aws/sagemaker/model/UserProfileDetails.h>
#include <aws/sagemaker/model/UserProfileSortKey.h>
#include <aws/sagemaker/model/UserProfileStatus.h>
#include <aws/sagemaker/model/UserSettings.h>
#include <aws/sagemaker/model/VariantProperty.h>
#include <aws/sagemaker/model/VariantPropertyType.h>
#include <aws/sagemaker/model/VariantStatus.h>
#include <aws/sagemaker/model/VectorConfig.h>
#include <aws/sagemaker/model/VendorGuidance.h>
#include <aws/sagemaker/model/Vertex.h>
#include <aws/sagemaker/model/VisibilityConditions.h>
#include <aws/sagemaker/model/VpcConfig.h>
#include <aws/sagemaker/model/WarmPoolResourceStatus.h>
#include <aws/sagemaker/model/WarmPoolStatus.h>
#include <aws/sagemaker/model/WorkerAccessConfiguration.h>
#include <aws/sagemaker/model/Workforce.h>
#include <aws/sagemaker/model/WorkforceStatus.h>
#include <aws/sagemaker/model/WorkforceVpcConfigRequest.h>
#include <aws/sagemaker/model/WorkforceVpcConfigResponse.h>
#include <aws/sagemaker/model/WorkspaceSettings.h>
#include <aws/sagemaker/model/Workteam.h>

using SageMakerIncludeTest = ::testing::Test;

TEST_F(SageMakerIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::SageMaker::SageMakerClient>("SageMakerIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
