/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/securityhub/SecurityHubClient.h>
#include <aws/securityhub/SecurityHubEndpointProvider.h>
#include <aws/securityhub/SecurityHubEndpointRules.h>
#include <aws/securityhub/SecurityHubErrorMarshaller.h>
#include <aws/securityhub/SecurityHubErrors.h>
#include <aws/securityhub/SecurityHubRequest.h>
#include <aws/securityhub/SecurityHubServiceClientModel.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/securityhub/model/AcceptAdministratorInvitationRequest.h>
#include <aws/securityhub/model/AcceptAdministratorInvitationResult.h>
#include <aws/securityhub/model/AccessDeniedException.h>
#include <aws/securityhub/model/AccountDetails.h>
#include <aws/securityhub/model/Action.h>
#include <aws/securityhub/model/ActionLocalIpDetails.h>
#include <aws/securityhub/model/ActionLocalPortDetails.h>
#include <aws/securityhub/model/ActionRemoteIpDetails.h>
#include <aws/securityhub/model/ActionRemotePortDetails.h>
#include <aws/securityhub/model/ActionTarget.h>
#include <aws/securityhub/model/Actor.h>
#include <aws/securityhub/model/ActorSession.h>
#include <aws/securityhub/model/ActorSessionMfaStatus.h>
#include <aws/securityhub/model/ActorUser.h>
#include <aws/securityhub/model/Adjustment.h>
#include <aws/securityhub/model/AdminAccount.h>
#include <aws/securityhub/model/AdminStatus.h>
#include <aws/securityhub/model/AggregatorV2.h>
#include <aws/securityhub/model/AllowedOperators.h>
#include <aws/securityhub/model/AssociatedStandard.h>
#include <aws/securityhub/model/AssociationFilters.h>
#include <aws/securityhub/model/AssociationSetDetails.h>
#include <aws/securityhub/model/AssociationStateDetails.h>
#include <aws/securityhub/model/AssociationStatus.h>
#include <aws/securityhub/model/AssociationType.h>
#include <aws/securityhub/model/AutoEnableStandards.h>
#include <aws/securityhub/model/AutomationRulesAction.h>
#include <aws/securityhub/model/AutomationRulesActionType.h>
#include <aws/securityhub/model/AutomationRulesActionTypeObjectV2.h>
#include <aws/securityhub/model/AutomationRulesActionTypeV2.h>
#include <aws/securityhub/model/AutomationRulesActionV2.h>
#include <aws/securityhub/model/AutomationRulesConfig.h>
#include <aws/securityhub/model/AutomationRulesFindingFieldsUpdate.h>
#include <aws/securityhub/model/AutomationRulesFindingFieldsUpdateV2.h>
#include <aws/securityhub/model/AutomationRulesFindingFilters.h>
#include <aws/securityhub/model/AutomationRulesMetadata.h>
#include <aws/securityhub/model/AutomationRulesMetadataV2.h>
#include <aws/securityhub/model/AvailabilityZone.h>
#include <aws/securityhub/model/AwsAmazonMqBrokerDetails.h>
#include <aws/securityhub/model/AwsAmazonMqBrokerEncryptionOptionsDetails.h>
#include <aws/securityhub/model/AwsAmazonMqBrokerLdapServerMetadataDetails.h>
#include <aws/securityhub/model/AwsAmazonMqBrokerLogsDetails.h>
#include <aws/securityhub/model/AwsAmazonMqBrokerLogsPendingDetails.h>
#include <aws/securityhub/model/AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.h>
#include <aws/securityhub/model/AwsAmazonMqBrokerUsersDetails.h>
#include <aws/securityhub/model/AwsApiCallAction.h>
#include <aws/securityhub/model/AwsApiCallActionDomainDetails.h>
#include <aws/securityhub/model/AwsApiGatewayAccessLogSettings.h>
#include <aws/securityhub/model/AwsApiGatewayCanarySettings.h>
#include <aws/securityhub/model/AwsApiGatewayEndpointConfiguration.h>
#include <aws/securityhub/model/AwsApiGatewayMethodSettings.h>
#include <aws/securityhub/model/AwsApiGatewayRestApiDetails.h>
#include <aws/securityhub/model/AwsApiGatewayStageDetails.h>
#include <aws/securityhub/model/AwsApiGatewayV2ApiDetails.h>
#include <aws/securityhub/model/AwsApiGatewayV2RouteSettings.h>
#include <aws/securityhub/model/AwsApiGatewayV2StageDetails.h>
#include <aws/securityhub/model/AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.h>
#include <aws/securityhub/model/AwsAppSyncGraphQlApiDetails.h>
#include <aws/securityhub/model/AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.h>
#include <aws/securityhub/model/AwsAppSyncGraphQlApiLogConfigDetails.h>
#include <aws/securityhub/model/AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.h>
#include <aws/securityhub/model/AwsAppSyncGraphQlApiUserPoolConfigDetails.h>
#include <aws/securityhub/model/AwsAthenaWorkGroupConfigurationDetails.h>
#include <aws/securityhub/model/AwsAthenaWorkGroupConfigurationResultConfigurationDetails.h>
#include <aws/securityhub/model/AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails.h>
#include <aws/securityhub/model/AwsAthenaWorkGroupDetails.h>
#include <aws/securityhub/model/AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.h>
#include <aws/securityhub/model/AwsAutoScalingAutoScalingGroupDetails.h>
#include <aws/securityhub/model/AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.h>
#include <aws/securityhub/model/AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.h>
#include <aws/securityhub/model/AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.h>
#include <aws/securityhub/model/AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.h>
#include <aws/securityhub/model/AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.h>
#include <aws/securityhub/model/AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.h>
#include <aws/securityhub/model/AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.h>
#include <aws/securityhub/model/AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.h>
#include <aws/securityhub/model/AwsAutoScalingLaunchConfigurationDetails.h>
#include <aws/securityhub/model/AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.h>
#include <aws/securityhub/model/AwsAutoScalingLaunchConfigurationMetadataOptions.h>
#include <aws/securityhub/model/AwsBackupBackupPlanAdvancedBackupSettingsDetails.h>
#include <aws/securityhub/model/AwsBackupBackupPlanBackupPlanDetails.h>
#include <aws/securityhub/model/AwsBackupBackupPlanDetails.h>
#include <aws/securityhub/model/AwsBackupBackupPlanLifecycleDetails.h>
#include <aws/securityhub/model/AwsBackupBackupPlanRuleCopyActionsDetails.h>
#include <aws/securityhub/model/AwsBackupBackupPlanRuleDetails.h>
#include <aws/securityhub/model/AwsBackupBackupVaultDetails.h>
#include <aws/securityhub/model/AwsBackupBackupVaultNotificationsDetails.h>
#include <aws/securityhub/model/AwsBackupRecoveryPointCalculatedLifecycleDetails.h>
#include <aws/securityhub/model/AwsBackupRecoveryPointCreatedByDetails.h>
#include <aws/securityhub/model/AwsBackupRecoveryPointDetails.h>
#include <aws/securityhub/model/AwsBackupRecoveryPointLifecycleDetails.h>
#include <aws/securityhub/model/AwsCertificateManagerCertificateDetails.h>
#include <aws/securityhub/model/AwsCertificateManagerCertificateDomainValidationOption.h>
#include <aws/securityhub/model/AwsCertificateManagerCertificateExtendedKeyUsage.h>
#include <aws/securityhub/model/AwsCertificateManagerCertificateKeyUsage.h>
#include <aws/securityhub/model/AwsCertificateManagerCertificateOptions.h>
#include <aws/securityhub/model/AwsCertificateManagerCertificateRenewalSummary.h>
#include <aws/securityhub/model/AwsCertificateManagerCertificateResourceRecord.h>
#include <aws/securityhub/model/AwsCloudFormationStackDetails.h>
#include <aws/securityhub/model/AwsCloudFormationStackDriftInformationDetails.h>
#include <aws/securityhub/model/AwsCloudFormationStackOutputsDetails.h>
#include <aws/securityhub/model/AwsCloudFrontDistributionCacheBehavior.h>
#include <aws/securityhub/model/AwsCloudFrontDistributionCacheBehaviors.h>
#include <aws/securityhub/model/AwsCloudFrontDistributionDefaultCacheBehavior.h>
#include <aws/securityhub/model/AwsCloudFrontDistributionDetails.h>
#include <aws/securityhub/model/AwsCloudFrontDistributionLogging.h>
#include <aws/securityhub/model/AwsCloudFrontDistributionOriginCustomOriginConfig.h>
#include <aws/securityhub/model/AwsCloudFrontDistributionOriginGroup.h>
#include <aws/securityhub/model/AwsCloudFrontDistributionOriginGroupFailover.h>
#include <aws/securityhub/model/AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.h>
#include <aws/securityhub/model/AwsCloudFrontDistributionOriginGroups.h>
#include <aws/securityhub/model/AwsCloudFrontDistributionOriginItem.h>
#include <aws/securityhub/model/AwsCloudFrontDistributionOriginS3OriginConfig.h>
#include <aws/securityhub/model/AwsCloudFrontDistributionOriginSslProtocols.h>
#include <aws/securityhub/model/AwsCloudFrontDistributionOrigins.h>
#include <aws/securityhub/model/AwsCloudFrontDistributionViewerCertificate.h>
#include <aws/securityhub/model/AwsCloudTrailTrailDetails.h>
#include <aws/securityhub/model/AwsCloudWatchAlarmDetails.h>
#include <aws/securityhub/model/AwsCloudWatchAlarmDimensionsDetails.h>
#include <aws/securityhub/model/AwsCodeBuildProjectArtifactsDetails.h>
#include <aws/securityhub/model/AwsCodeBuildProjectDetails.h>
#include <aws/securityhub/model/AwsCodeBuildProjectEnvironment.h>
#include <aws/securityhub/model/AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.h>
#include <aws/securityhub/model/AwsCodeBuildProjectEnvironmentRegistryCredential.h>
#include <aws/securityhub/model/AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.h>
#include <aws/securityhub/model/AwsCodeBuildProjectLogsConfigDetails.h>
#include <aws/securityhub/model/AwsCodeBuildProjectLogsConfigS3LogsDetails.h>
#include <aws/securityhub/model/AwsCodeBuildProjectSource.h>
#include <aws/securityhub/model/AwsCodeBuildProjectVpcConfig.h>
#include <aws/securityhub/model/AwsCorsConfiguration.h>
#include <aws/securityhub/model/AwsDmsEndpointDetails.h>
#include <aws/securityhub/model/AwsDmsReplicationInstanceDetails.h>
#include <aws/securityhub/model/AwsDmsReplicationInstanceReplicationSubnetGroupDetails.h>
#include <aws/securityhub/model/AwsDmsReplicationInstanceVpcSecurityGroupsDetails.h>
#include <aws/securityhub/model/AwsDmsReplicationTaskDetails.h>
#include <aws/securityhub/model/AwsDynamoDbTableAttributeDefinition.h>
#include <aws/securityhub/model/AwsDynamoDbTableBillingModeSummary.h>
#include <aws/securityhub/model/AwsDynamoDbTableDetails.h>
#include <aws/securityhub/model/AwsDynamoDbTableGlobalSecondaryIndex.h>
#include <aws/securityhub/model/AwsDynamoDbTableKeySchema.h>
#include <aws/securityhub/model/AwsDynamoDbTableLocalSecondaryIndex.h>
#include <aws/securityhub/model/AwsDynamoDbTableProjection.h>
#include <aws/securityhub/model/AwsDynamoDbTableProvisionedThroughput.h>
#include <aws/securityhub/model/AwsDynamoDbTableProvisionedThroughputOverride.h>
#include <aws/securityhub/model/AwsDynamoDbTableReplica.h>
#include <aws/securityhub/model/AwsDynamoDbTableReplicaGlobalSecondaryIndex.h>
#include <aws/securityhub/model/AwsDynamoDbTableRestoreSummary.h>
#include <aws/securityhub/model/AwsDynamoDbTableSseDescription.h>
#include <aws/securityhub/model/AwsDynamoDbTableStreamSpecification.h>
#include <aws/securityhub/model/AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails.h>
#include <aws/securityhub/model/AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.h>
#include <aws/securityhub/model/AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails.h>
#include <aws/securityhub/model/AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails.h>
#include <aws/securityhub/model/AwsEc2ClientVpnEndpointClientConnectOptionsDetails.h>
#include <aws/securityhub/model/AwsEc2ClientVpnEndpointClientConnectOptionsStatusDetails.h>
#include <aws/securityhub/model/AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails.h>
#include <aws/securityhub/model/AwsEc2ClientVpnEndpointConnectionLogOptionsDetails.h>
#include <aws/securityhub/model/AwsEc2ClientVpnEndpointDetails.h>
#include <aws/securityhub/model/AwsEc2EipDetails.h>
#include <aws/securityhub/model/AwsEc2InstanceDetails.h>
#include <aws/securityhub/model/AwsEc2InstanceMetadataOptions.h>
#include <aws/securityhub/model/AwsEc2InstanceMonitoringDetails.h>
#include <aws/securityhub/model/AwsEc2InstanceNetworkInterfacesDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataCpuOptionsDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataCreditSpecificationDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataEnclaveOptionsDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataHibernationOptionsDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataIamInstanceProfileDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataInstanceRequirementsDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataLicenseSetDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataMetadataOptionsDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataMonitoringDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataPlacementDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.h>
#include <aws/securityhub/model/AwsEc2LaunchTemplateDetails.h>
#include <aws/securityhub/model/AwsEc2NetworkAclAssociation.h>
#include <aws/securityhub/model/AwsEc2NetworkAclDetails.h>
#include <aws/securityhub/model/AwsEc2NetworkAclEntry.h>
#include <aws/securityhub/model/AwsEc2NetworkInterfaceAttachment.h>
#include <aws/securityhub/model/AwsEc2NetworkInterfaceDetails.h>
#include <aws/securityhub/model/AwsEc2NetworkInterfaceIpV6AddressDetail.h>
#include <aws/securityhub/model/AwsEc2NetworkInterfacePrivateIpAddressDetail.h>
#include <aws/securityhub/model/AwsEc2NetworkInterfaceSecurityGroup.h>
#include <aws/securityhub/model/AwsEc2RouteTableDetails.h>
#include <aws/securityhub/model/AwsEc2SecurityGroupDetails.h>
#include <aws/securityhub/model/AwsEc2SecurityGroupIpPermission.h>
#include <aws/securityhub/model/AwsEc2SecurityGroupIpRange.h>
#include <aws/securityhub/model/AwsEc2SecurityGroupIpv6Range.h>
#include <aws/securityhub/model/AwsEc2SecurityGroupPrefixListId.h>
#include <aws/securityhub/model/AwsEc2SecurityGroupUserIdGroupPair.h>
#include <aws/securityhub/model/AwsEc2SubnetDetails.h>
#include <aws/securityhub/model/AwsEc2TransitGatewayDetails.h>
#include <aws/securityhub/model/AwsEc2VolumeAttachment.h>
#include <aws/securityhub/model/AwsEc2VolumeDetails.h>
#include <aws/securityhub/model/AwsEc2VpcDetails.h>
#include <aws/securityhub/model/AwsEc2VpcEndpointServiceDetails.h>
#include <aws/securityhub/model/AwsEc2VpcEndpointServiceServiceTypeDetails.h>
#include <aws/securityhub/model/AwsEc2VpcPeeringConnectionDetails.h>
#include <aws/securityhub/model/AwsEc2VpcPeeringConnectionStatusDetails.h>
#include <aws/securityhub/model/AwsEc2VpcPeeringConnectionVpcInfoDetails.h>
#include <aws/securityhub/model/AwsEc2VpnConnectionDetails.h>
#include <aws/securityhub/model/AwsEc2VpnConnectionOptionsDetails.h>
#include <aws/securityhub/model/AwsEc2VpnConnectionOptionsTunnelOptionsDetails.h>
#include <aws/securityhub/model/AwsEc2VpnConnectionRoutesDetails.h>
#include <aws/securityhub/model/AwsEc2VpnConnectionVgwTelemetryDetails.h>
#include <aws/securityhub/model/AwsEcrContainerImageDetails.h>
#include <aws/securityhub/model/AwsEcrRepositoryDetails.h>
#include <aws/securityhub/model/AwsEcrRepositoryImageScanningConfigurationDetails.h>
#include <aws/securityhub/model/AwsEcrRepositoryLifecyclePolicyDetails.h>
#include <aws/securityhub/model/AwsEcsClusterClusterSettingsDetails.h>
#include <aws/securityhub/model/AwsEcsClusterConfigurationDetails.h>
#include <aws/securityhub/model/AwsEcsClusterConfigurationExecuteCommandConfigurationDetails.h>
#include <aws/securityhub/model/AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.h>
#include <aws/securityhub/model/AwsEcsClusterDefaultCapacityProviderStrategyDetails.h>
#include <aws/securityhub/model/AwsEcsClusterDetails.h>
#include <aws/securityhub/model/AwsEcsContainerDetails.h>
#include <aws/securityhub/model/AwsEcsServiceCapacityProviderStrategyDetails.h>
#include <aws/securityhub/model/AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.h>
#include <aws/securityhub/model/AwsEcsServiceDeploymentConfigurationDetails.h>
#include <aws/securityhub/model/AwsEcsServiceDeploymentControllerDetails.h>
#include <aws/securityhub/model/AwsEcsServiceDetails.h>
#include <aws/securityhub/model/AwsEcsServiceLoadBalancersDetails.h>
#include <aws/securityhub/model/AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.h>
#include <aws/securityhub/model/AwsEcsServiceNetworkConfigurationDetails.h>
#include <aws/securityhub/model/AwsEcsServicePlacementConstraintsDetails.h>
#include <aws/securityhub/model/AwsEcsServicePlacementStrategiesDetails.h>
#include <aws/securityhub/model/AwsEcsServiceServiceRegistriesDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionInferenceAcceleratorsDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionPlacementConstraintsDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionProxyConfigurationDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionVolumesDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDefinitionVolumesHostDetails.h>
#include <aws/securityhub/model/AwsEcsTaskDetails.h>
#include <aws/securityhub/model/AwsEcsTaskVolumeDetails.h>
#include <aws/securityhub/model/AwsEcsTaskVolumeHostDetails.h>
#include <aws/securityhub/model/AwsEfsAccessPointDetails.h>
#include <aws/securityhub/model/AwsEfsAccessPointPosixUserDetails.h>
#include <aws/securityhub/model/AwsEfsAccessPointRootDirectoryCreationInfoDetails.h>
#include <aws/securityhub/model/AwsEfsAccessPointRootDirectoryDetails.h>
#include <aws/securityhub/model/AwsEksClusterDetails.h>
#include <aws/securityhub/model/AwsEksClusterLoggingClusterLoggingDetails.h>
#include <aws/securityhub/model/AwsEksClusterLoggingDetails.h>
#include <aws/securityhub/model/AwsEksClusterResourcesVpcConfigDetails.h>
#include <aws/securityhub/model/AwsElasticBeanstalkEnvironmentDetails.h>
#include <aws/securityhub/model/AwsElasticBeanstalkEnvironmentEnvironmentLink.h>
#include <aws/securityhub/model/AwsElasticBeanstalkEnvironmentOptionSetting.h>
#include <aws/securityhub/model/AwsElasticBeanstalkEnvironmentTier.h>
#include <aws/securityhub/model/AwsElasticsearchDomainDetails.h>
#include <aws/securityhub/model/AwsElasticsearchDomainDomainEndpointOptions.h>
#include <aws/securityhub/model/AwsElasticsearchDomainElasticsearchClusterConfigDetails.h>
#include <aws/securityhub/model/AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails.h>
#include <aws/securityhub/model/AwsElasticsearchDomainEncryptionAtRestOptions.h>
#include <aws/securityhub/model/AwsElasticsearchDomainLogPublishingOptions.h>
#include <aws/securityhub/model/AwsElasticsearchDomainLogPublishingOptionsLogConfig.h>
#include <aws/securityhub/model/AwsElasticsearchDomainNodeToNodeEncryptionOptions.h>
#include <aws/securityhub/model/AwsElasticsearchDomainServiceSoftwareOptions.h>
#include <aws/securityhub/model/AwsElasticsearchDomainVPCOptions.h>
#include <aws/securityhub/model/AwsElbAppCookieStickinessPolicy.h>
#include <aws/securityhub/model/AwsElbLbCookieStickinessPolicy.h>
#include <aws/securityhub/model/AwsElbLoadBalancerAccessLog.h>
#include <aws/securityhub/model/AwsElbLoadBalancerAdditionalAttribute.h>
#include <aws/securityhub/model/AwsElbLoadBalancerAttributes.h>
#include <aws/securityhub/model/AwsElbLoadBalancerBackendServerDescription.h>
#include <aws/securityhub/model/AwsElbLoadBalancerConnectionDraining.h>
#include <aws/securityhub/model/AwsElbLoadBalancerConnectionSettings.h>
#include <aws/securityhub/model/AwsElbLoadBalancerCrossZoneLoadBalancing.h>
#include <aws/securityhub/model/AwsElbLoadBalancerDetails.h>
#include <aws/securityhub/model/AwsElbLoadBalancerHealthCheck.h>
#include <aws/securityhub/model/AwsElbLoadBalancerInstance.h>
#include <aws/securityhub/model/AwsElbLoadBalancerListener.h>
#include <aws/securityhub/model/AwsElbLoadBalancerListenerDescription.h>
#include <aws/securityhub/model/AwsElbLoadBalancerPolicies.h>
#include <aws/securityhub/model/AwsElbLoadBalancerSourceSecurityGroup.h>
#include <aws/securityhub/model/AwsElbv2LoadBalancerAttribute.h>
#include <aws/securityhub/model/AwsElbv2LoadBalancerDetails.h>
#include <aws/securityhub/model/AwsEventSchemasRegistryDetails.h>
#include <aws/securityhub/model/AwsEventsEndpointDetails.h>
#include <aws/securityhub/model/AwsEventsEndpointEventBusesDetails.h>
#include <aws/securityhub/model/AwsEventsEndpointReplicationConfigDetails.h>
#include <aws/securityhub/model/AwsEventsEndpointRoutingConfigDetails.h>
#include <aws/securityhub/model/AwsEventsEndpointRoutingConfigFailoverConfigDetails.h>
#include <aws/securityhub/model/AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails.h>
#include <aws/securityhub/model/AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.h>
#include <aws/securityhub/model/AwsEventsEventbusDetails.h>
#include <aws/securityhub/model/AwsGuardDutyDetectorDataSourcesCloudTrailDetails.h>
#include <aws/securityhub/model/AwsGuardDutyDetectorDataSourcesDetails.h>
#include <aws/securityhub/model/AwsGuardDutyDetectorDataSourcesDnsLogsDetails.h>
#include <aws/securityhub/model/AwsGuardDutyDetectorDataSourcesFlowLogsDetails.h>
#include <aws/securityhub/model/AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails.h>
#include <aws/securityhub/model/AwsGuardDutyDetectorDataSourcesKubernetesDetails.h>
#include <aws/securityhub/model/AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.h>
#include <aws/securityhub/model/AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails.h>
#include <aws/securityhub/model/AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails.h>
#include <aws/securityhub/model/AwsGuardDutyDetectorDataSourcesS3LogsDetails.h>
#include <aws/securityhub/model/AwsGuardDutyDetectorDetails.h>
#include <aws/securityhub/model/AwsGuardDutyDetectorFeaturesDetails.h>
#include <aws/securityhub/model/AwsIamAccessKeyDetails.h>
#include <aws/securityhub/model/AwsIamAccessKeySessionContext.h>
#include <aws/securityhub/model/AwsIamAccessKeySessionContextAttributes.h>
#include <aws/securityhub/model/AwsIamAccessKeySessionContextSessionIssuer.h>
#include <aws/securityhub/model/AwsIamAccessKeyStatus.h>
#include <aws/securityhub/model/AwsIamAttachedManagedPolicy.h>
#include <aws/securityhub/model/AwsIamGroupDetails.h>
#include <aws/securityhub/model/AwsIamGroupPolicy.h>
#include <aws/securityhub/model/AwsIamInstanceProfile.h>
#include <aws/securityhub/model/AwsIamInstanceProfileRole.h>
#include <aws/securityhub/model/AwsIamPermissionsBoundary.h>
#include <aws/securityhub/model/AwsIamPolicyDetails.h>
#include <aws/securityhub/model/AwsIamPolicyVersion.h>
#include <aws/securityhub/model/AwsIamRoleDetails.h>
#include <aws/securityhub/model/AwsIamRolePolicy.h>
#include <aws/securityhub/model/AwsIamUserDetails.h>
#include <aws/securityhub/model/AwsIamUserPolicy.h>
#include <aws/securityhub/model/AwsKinesisStreamDetails.h>
#include <aws/securityhub/model/AwsKinesisStreamStreamEncryptionDetails.h>
#include <aws/securityhub/model/AwsKmsKeyDetails.h>
#include <aws/securityhub/model/AwsLambdaFunctionCode.h>
#include <aws/securityhub/model/AwsLambdaFunctionDeadLetterConfig.h>
#include <aws/securityhub/model/AwsLambdaFunctionDetails.h>
#include <aws/securityhub/model/AwsLambdaFunctionEnvironment.h>
#include <aws/securityhub/model/AwsLambdaFunctionEnvironmentError.h>
#include <aws/securityhub/model/AwsLambdaFunctionLayer.h>
#include <aws/securityhub/model/AwsLambdaFunctionTracingConfig.h>
#include <aws/securityhub/model/AwsLambdaFunctionVpcConfig.h>
#include <aws/securityhub/model/AwsLambdaLayerVersionDetails.h>
#include <aws/securityhub/model/AwsMountPoint.h>
#include <aws/securityhub/model/AwsMskClusterClusterInfoClientAuthenticationDetails.h>
#include <aws/securityhub/model/AwsMskClusterClusterInfoClientAuthenticationSaslDetails.h>
#include <aws/securityhub/model/AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails.h>
#include <aws/securityhub/model/AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails.h>
#include <aws/securityhub/model/AwsMskClusterClusterInfoClientAuthenticationTlsDetails.h>
#include <aws/securityhub/model/AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails.h>
#include <aws/securityhub/model/AwsMskClusterClusterInfoDetails.h>
#include <aws/securityhub/model/AwsMskClusterClusterInfoEncryptionInfoDetails.h>
#include <aws/securityhub/model/AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.h>
#include <aws/securityhub/model/AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails.h>
#include <aws/securityhub/model/AwsMskClusterDetails.h>
#include <aws/securityhub/model/AwsNetworkFirewallFirewallDetails.h>
#include <aws/securityhub/model/AwsNetworkFirewallFirewallPolicyDetails.h>
#include <aws/securityhub/model/AwsNetworkFirewallFirewallSubnetMappingsDetails.h>
#include <aws/securityhub/model/AwsNetworkFirewallRuleGroupDetails.h>
#include <aws/securityhub/model/AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.h>
#include <aws/securityhub/model/AwsOpenSearchServiceDomainClusterConfigDetails.h>
#include <aws/securityhub/model/AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.h>
#include <aws/securityhub/model/AwsOpenSearchServiceDomainDetails.h>
#include <aws/securityhub/model/AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.h>
#include <aws/securityhub/model/AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.h>
#include <aws/securityhub/model/AwsOpenSearchServiceDomainLogPublishingOption.h>
#include <aws/securityhub/model/AwsOpenSearchServiceDomainLogPublishingOptionsDetails.h>
#include <aws/securityhub/model/AwsOpenSearchServiceDomainMasterUserOptionsDetails.h>
#include <aws/securityhub/model/AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.h>
#include <aws/securityhub/model/AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.h>
#include <aws/securityhub/model/AwsOpenSearchServiceDomainVpcOptionsDetails.h>
#include <aws/securityhub/model/AwsRdsDbClusterAssociatedRole.h>
#include <aws/securityhub/model/AwsRdsDbClusterDetails.h>
#include <aws/securityhub/model/AwsRdsDbClusterMember.h>
#include <aws/securityhub/model/AwsRdsDbClusterOptionGroupMembership.h>
#include <aws/securityhub/model/AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.h>
#include <aws/securityhub/model/AwsRdsDbClusterSnapshotDetails.h>
#include <aws/securityhub/model/AwsRdsDbDomainMembership.h>
#include <aws/securityhub/model/AwsRdsDbInstanceAssociatedRole.h>
#include <aws/securityhub/model/AwsRdsDbInstanceDetails.h>
#include <aws/securityhub/model/AwsRdsDbInstanceEndpoint.h>
#include <aws/securityhub/model/AwsRdsDbInstanceVpcSecurityGroup.h>
#include <aws/securityhub/model/AwsRdsDbOptionGroupMembership.h>
#include <aws/securityhub/model/AwsRdsDbParameterGroup.h>
#include <aws/securityhub/model/AwsRdsDbPendingModifiedValues.h>
#include <aws/securityhub/model/AwsRdsDbProcessorFeature.h>
#include <aws/securityhub/model/AwsRdsDbSecurityGroupDetails.h>
#include <aws/securityhub/model/AwsRdsDbSecurityGroupEc2SecurityGroup.h>
#include <aws/securityhub/model/AwsRdsDbSecurityGroupIpRange.h>
#include <aws/securityhub/model/AwsRdsDbSnapshotDetails.h>
#include <aws/securityhub/model/AwsRdsDbStatusInfo.h>
#include <aws/securityhub/model/AwsRdsDbSubnetGroup.h>
#include <aws/securityhub/model/AwsRdsDbSubnetGroupSubnet.h>
#include <aws/securityhub/model/AwsRdsDbSubnetGroupSubnetAvailabilityZone.h>
#include <aws/securityhub/model/AwsRdsEventSubscriptionDetails.h>
#include <aws/securityhub/model/AwsRdsPendingCloudWatchLogsExports.h>
#include <aws/securityhub/model/AwsRedshiftClusterClusterNode.h>
#include <aws/securityhub/model/AwsRedshiftClusterClusterParameterGroup.h>
#include <aws/securityhub/model/AwsRedshiftClusterClusterParameterStatus.h>
#include <aws/securityhub/model/AwsRedshiftClusterClusterSecurityGroup.h>
#include <aws/securityhub/model/AwsRedshiftClusterClusterSnapshotCopyStatus.h>
#include <aws/securityhub/model/AwsRedshiftClusterDeferredMaintenanceWindow.h>
#include <aws/securityhub/model/AwsRedshiftClusterDetails.h>
#include <aws/securityhub/model/AwsRedshiftClusterElasticIpStatus.h>
#include <aws/securityhub/model/AwsRedshiftClusterEndpoint.h>
#include <aws/securityhub/model/AwsRedshiftClusterHsmStatus.h>
#include <aws/securityhub/model/AwsRedshiftClusterIamRole.h>
#include <aws/securityhub/model/AwsRedshiftClusterLoggingStatus.h>
#include <aws/securityhub/model/AwsRedshiftClusterPendingModifiedValues.h>
#include <aws/securityhub/model/AwsRedshiftClusterResizeInfo.h>
#include <aws/securityhub/model/AwsRedshiftClusterRestoreStatus.h>
#include <aws/securityhub/model/AwsRedshiftClusterVpcSecurityGroup.h>
#include <aws/securityhub/model/AwsRoute53HostedZoneConfigDetails.h>
#include <aws/securityhub/model/AwsRoute53HostedZoneDetails.h>
#include <aws/securityhub/model/AwsRoute53HostedZoneObjectDetails.h>
#include <aws/securityhub/model/AwsRoute53HostedZoneVpcDetails.h>
#include <aws/securityhub/model/AwsRoute53QueryLoggingConfigDetails.h>
#include <aws/securityhub/model/AwsS3AccessPointDetails.h>
#include <aws/securityhub/model/AwsS3AccessPointVpcConfigurationDetails.h>
#include <aws/securityhub/model/AwsS3AccountPublicAccessBlockDetails.h>
#include <aws/securityhub/model/AwsS3BucketBucketLifecycleConfigurationDetails.h>
#include <aws/securityhub/model/AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.h>
#include <aws/securityhub/model/AwsS3BucketBucketLifecycleConfigurationRulesDetails.h>
#include <aws/securityhub/model/AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.h>
#include <aws/securityhub/model/AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.h>
#include <aws/securityhub/model/AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.h>
#include <aws/securityhub/model/AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails.h>
#include <aws/securityhub/model/AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.h>
#include <aws/securityhub/model/AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.h>
#include <aws/securityhub/model/AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.h>
#include <aws/securityhub/model/AwsS3BucketBucketVersioningConfiguration.h>
#include <aws/securityhub/model/AwsS3BucketDetails.h>
#include <aws/securityhub/model/AwsS3BucketLoggingConfiguration.h>
#include <aws/securityhub/model/AwsS3BucketNotificationConfiguration.h>
#include <aws/securityhub/model/AwsS3BucketNotificationConfigurationDetail.h>
#include <aws/securityhub/model/AwsS3BucketNotificationConfigurationFilter.h>
#include <aws/securityhub/model/AwsS3BucketNotificationConfigurationS3KeyFilter.h>
#include <aws/securityhub/model/AwsS3BucketNotificationConfigurationS3KeyFilterRule.h>
#include <aws/securityhub/model/AwsS3BucketNotificationConfigurationS3KeyFilterRuleName.h>
#include <aws/securityhub/model/AwsS3BucketObjectLockConfiguration.h>
#include <aws/securityhub/model/AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.h>
#include <aws/securityhub/model/AwsS3BucketObjectLockConfigurationRuleDetails.h>
#include <aws/securityhub/model/AwsS3BucketServerSideEncryptionByDefault.h>
#include <aws/securityhub/model/AwsS3BucketServerSideEncryptionConfiguration.h>
#include <aws/securityhub/model/AwsS3BucketServerSideEncryptionRule.h>
#include <aws/securityhub/model/AwsS3BucketWebsiteConfiguration.h>
#include <aws/securityhub/model/AwsS3BucketWebsiteConfigurationRedirectTo.h>
#include <aws/securityhub/model/AwsS3BucketWebsiteConfigurationRoutingRule.h>
#include <aws/securityhub/model/AwsS3BucketWebsiteConfigurationRoutingRuleCondition.h>
#include <aws/securityhub/model/AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.h>
#include <aws/securityhub/model/AwsS3ObjectDetails.h>
#include <aws/securityhub/model/AwsSageMakerNotebookInstanceDetails.h>
#include <aws/securityhub/model/AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.h>
#include <aws/securityhub/model/AwsSecretsManagerSecretDetails.h>
#include <aws/securityhub/model/AwsSecretsManagerSecretRotationRules.h>
#include <aws/securityhub/model/AwsSecurityFinding.h>
#include <aws/securityhub/model/AwsSecurityFindingFilters.h>
#include <aws/securityhub/model/AwsSecurityFindingIdentifier.h>
#include <aws/securityhub/model/AwsSnsTopicDetails.h>
#include <aws/securityhub/model/AwsSnsTopicSubscription.h>
#include <aws/securityhub/model/AwsSqsQueueDetails.h>
#include <aws/securityhub/model/AwsSsmComplianceSummary.h>
#include <aws/securityhub/model/AwsSsmPatch.h>
#include <aws/securityhub/model/AwsSsmPatchComplianceDetails.h>
#include <aws/securityhub/model/AwsStepFunctionStateMachineDetails.h>
#include <aws/securityhub/model/AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails.h>
#include <aws/securityhub/model/AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails.h>
#include <aws/securityhub/model/AwsStepFunctionStateMachineLoggingConfigurationDetails.h>
#include <aws/securityhub/model/AwsStepFunctionStateMachineTracingConfigurationDetails.h>
#include <aws/securityhub/model/AwsWafRateBasedRuleDetails.h>
#include <aws/securityhub/model/AwsWafRateBasedRuleMatchPredicate.h>
#include <aws/securityhub/model/AwsWafRegionalRateBasedRuleDetails.h>
#include <aws/securityhub/model/AwsWafRegionalRateBasedRuleMatchPredicate.h>
#include <aws/securityhub/model/AwsWafRegionalRuleDetails.h>
#include <aws/securityhub/model/AwsWafRegionalRuleGroupDetails.h>
#include <aws/securityhub/model/AwsWafRegionalRuleGroupRulesActionDetails.h>
#include <aws/securityhub/model/AwsWafRegionalRuleGroupRulesDetails.h>
#include <aws/securityhub/model/AwsWafRegionalRulePredicateListDetails.h>
#include <aws/securityhub/model/AwsWafRegionalWebAclDetails.h>
#include <aws/securityhub/model/AwsWafRegionalWebAclRulesListActionDetails.h>
#include <aws/securityhub/model/AwsWafRegionalWebAclRulesListDetails.h>
#include <aws/securityhub/model/AwsWafRegionalWebAclRulesListOverrideActionDetails.h>
#include <aws/securityhub/model/AwsWafRuleDetails.h>
#include <aws/securityhub/model/AwsWafRuleGroupDetails.h>
#include <aws/securityhub/model/AwsWafRuleGroupRulesActionDetails.h>
#include <aws/securityhub/model/AwsWafRuleGroupRulesDetails.h>
#include <aws/securityhub/model/AwsWafRulePredicateListDetails.h>
#include <aws/securityhub/model/AwsWafWebAclDetails.h>
#include <aws/securityhub/model/AwsWafWebAclRule.h>
#include <aws/securityhub/model/AwsWafv2ActionAllowDetails.h>
#include <aws/securityhub/model/AwsWafv2ActionBlockDetails.h>
#include <aws/securityhub/model/AwsWafv2CustomHttpHeader.h>
#include <aws/securityhub/model/AwsWafv2CustomRequestHandlingDetails.h>
#include <aws/securityhub/model/AwsWafv2CustomResponseDetails.h>
#include <aws/securityhub/model/AwsWafv2RuleGroupDetails.h>
#include <aws/securityhub/model/AwsWafv2RulesActionCaptchaDetails.h>
#include <aws/securityhub/model/AwsWafv2RulesActionCountDetails.h>
#include <aws/securityhub/model/AwsWafv2RulesActionDetails.h>
#include <aws/securityhub/model/AwsWafv2RulesDetails.h>
#include <aws/securityhub/model/AwsWafv2VisibilityConfigDetails.h>
#include <aws/securityhub/model/AwsWafv2WebAclActionDetails.h>
#include <aws/securityhub/model/AwsWafv2WebAclCaptchaConfigDetails.h>
#include <aws/securityhub/model/AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.h>
#include <aws/securityhub/model/AwsWafv2WebAclDetails.h>
#include <aws/securityhub/model/AwsXrayEncryptionConfigDetails.h>
#include <aws/securityhub/model/BatchDeleteAutomationRulesRequest.h>
#include <aws/securityhub/model/BatchDeleteAutomationRulesResult.h>
#include <aws/securityhub/model/BatchDisableStandardsRequest.h>
#include <aws/securityhub/model/BatchDisableStandardsResult.h>
#include <aws/securityhub/model/BatchEnableStandardsRequest.h>
#include <aws/securityhub/model/BatchEnableStandardsResult.h>
#include <aws/securityhub/model/BatchGetAutomationRulesRequest.h>
#include <aws/securityhub/model/BatchGetAutomationRulesResult.h>
#include <aws/securityhub/model/BatchGetConfigurationPolicyAssociationsRequest.h>
#include <aws/securityhub/model/BatchGetConfigurationPolicyAssociationsResult.h>
#include <aws/securityhub/model/BatchGetSecurityControlsRequest.h>
#include <aws/securityhub/model/BatchGetSecurityControlsResult.h>
#include <aws/securityhub/model/BatchGetStandardsControlAssociationsRequest.h>
#include <aws/securityhub/model/BatchGetStandardsControlAssociationsResult.h>
#include <aws/securityhub/model/BatchImportFindingsRequest.h>
#include <aws/securityhub/model/BatchImportFindingsResult.h>
#include <aws/securityhub/model/BatchUpdateAutomationRulesRequest.h>
#include <aws/securityhub/model/BatchUpdateAutomationRulesResult.h>
#include <aws/securityhub/model/BatchUpdateFindingsRequest.h>
#include <aws/securityhub/model/BatchUpdateFindingsResult.h>
#include <aws/securityhub/model/BatchUpdateFindingsUnprocessedFinding.h>
#include <aws/securityhub/model/BatchUpdateFindingsV2ProcessedFinding.h>
#include <aws/securityhub/model/BatchUpdateFindingsV2Request.h>
#include <aws/securityhub/model/BatchUpdateFindingsV2Result.h>
#include <aws/securityhub/model/BatchUpdateFindingsV2UnprocessedFinding.h>
#include <aws/securityhub/model/BatchUpdateFindingsV2UnprocessedFindingErrorCode.h>
#include <aws/securityhub/model/BatchUpdateStandardsControlAssociationsRequest.h>
#include <aws/securityhub/model/BatchUpdateStandardsControlAssociationsResult.h>
#include <aws/securityhub/model/BooleanConfigurationOptions.h>
#include <aws/securityhub/model/BooleanFilter.h>
#include <aws/securityhub/model/Cell.h>
#include <aws/securityhub/model/CidrBlockAssociation.h>
#include <aws/securityhub/model/City.h>
#include <aws/securityhub/model/ClassificationResult.h>
#include <aws/securityhub/model/ClassificationStatus.h>
#include <aws/securityhub/model/CloudWatchLogsLogGroupArnConfigDetails.h>
#include <aws/securityhub/model/CodeVulnerabilitiesFilePath.h>
#include <aws/securityhub/model/Compliance.h>
#include <aws/securityhub/model/ComplianceStatus.h>
#include <aws/securityhub/model/CompositeFilter.h>
#include <aws/securityhub/model/ConfigurationOptions.h>
#include <aws/securityhub/model/ConfigurationPolicyAssociation.h>
#include <aws/securityhub/model/ConfigurationPolicyAssociationStatus.h>
#include <aws/securityhub/model/ConfigurationPolicyAssociationSummary.h>
#include <aws/securityhub/model/ConfigurationPolicySummary.h>
#include <aws/securityhub/model/ConflictException.h>
#include <aws/securityhub/model/ConnectionDirection.h>
#include <aws/securityhub/model/ConnectorAuthStatus.h>
#include <aws/securityhub/model/ConnectorProviderName.h>
#include <aws/securityhub/model/ConnectorRegistrationsV2Request.h>
#include <aws/securityhub/model/ConnectorRegistrationsV2Result.h>
#include <aws/securityhub/model/ConnectorStatus.h>
#include <aws/securityhub/model/ConnectorSummary.h>
#include <aws/securityhub/model/ContainerDetails.h>
#include <aws/securityhub/model/ControlFindingGenerator.h>
#include <aws/securityhub/model/ControlStatus.h>
#include <aws/securityhub/model/Country.h>
#include <aws/securityhub/model/CreateActionTargetRequest.h>
#include <aws/securityhub/model/CreateActionTargetResult.h>
#include <aws/securityhub/model/CreateAggregatorV2Request.h>
#include <aws/securityhub/model/CreateAggregatorV2Result.h>
#include <aws/securityhub/model/CreateAutomationRuleRequest.h>
#include <aws/securityhub/model/CreateAutomationRuleResult.h>
#include <aws/securityhub/model/CreateAutomationRuleV2Request.h>
#include <aws/securityhub/model/CreateAutomationRuleV2Result.h>
#include <aws/securityhub/model/CreateConfigurationPolicyRequest.h>
#include <aws/securityhub/model/CreateConfigurationPolicyResult.h>
#include <aws/securityhub/model/CreateConnectorV2Request.h>
#include <aws/securityhub/model/CreateConnectorV2Result.h>
#include <aws/securityhub/model/CreateFindingAggregatorRequest.h>
#include <aws/securityhub/model/CreateFindingAggregatorResult.h>
#include <aws/securityhub/model/CreateInsightRequest.h>
#include <aws/securityhub/model/CreateInsightResult.h>
#include <aws/securityhub/model/CreateMembersRequest.h>
#include <aws/securityhub/model/CreateMembersResult.h>
#include <aws/securityhub/model/CreateTicketV2Request.h>
#include <aws/securityhub/model/CreateTicketV2Result.h>
#include <aws/securityhub/model/Criteria.h>
#include <aws/securityhub/model/CustomDataIdentifiersDetections.h>
#include <aws/securityhub/model/CustomDataIdentifiersResult.h>
#include <aws/securityhub/model/Cvss.h>
#include <aws/securityhub/model/DataClassificationDetails.h>
#include <aws/securityhub/model/DateFilter.h>
#include <aws/securityhub/model/DateRange.h>
#include <aws/securityhub/model/DateRangeUnit.h>
#include <aws/securityhub/model/DeclineInvitationsRequest.h>
#include <aws/securityhub/model/DeclineInvitationsResult.h>
#include <aws/securityhub/model/DeleteActionTargetRequest.h>
#include <aws/securityhub/model/DeleteActionTargetResult.h>
#include <aws/securityhub/model/DeleteAggregatorV2Request.h>
#include <aws/securityhub/model/DeleteAggregatorV2Result.h>
#include <aws/securityhub/model/DeleteAutomationRuleV2Request.h>
#include <aws/securityhub/model/DeleteAutomationRuleV2Result.h>
#include <aws/securityhub/model/DeleteConfigurationPolicyRequest.h>
#include <aws/securityhub/model/DeleteConfigurationPolicyResult.h>
#include <aws/securityhub/model/DeleteConnectorV2Request.h>
#include <aws/securityhub/model/DeleteConnectorV2Result.h>
#include <aws/securityhub/model/DeleteFindingAggregatorRequest.h>
#include <aws/securityhub/model/DeleteFindingAggregatorResult.h>
#include <aws/securityhub/model/DeleteInsightRequest.h>
#include <aws/securityhub/model/DeleteInsightResult.h>
#include <aws/securityhub/model/DeleteInvitationsRequest.h>
#include <aws/securityhub/model/DeleteInvitationsResult.h>
#include <aws/securityhub/model/DeleteMembersRequest.h>
#include <aws/securityhub/model/DeleteMembersResult.h>
#include <aws/securityhub/model/DescribeActionTargetsRequest.h>
#include <aws/securityhub/model/DescribeActionTargetsResult.h>
#include <aws/securityhub/model/DescribeHubRequest.h>
#include <aws/securityhub/model/DescribeHubResult.h>
#include <aws/securityhub/model/DescribeOrganizationConfigurationRequest.h>
#include <aws/securityhub/model/DescribeOrganizationConfigurationResult.h>
#include <aws/securityhub/model/DescribeProductsRequest.h>
#include <aws/securityhub/model/DescribeProductsResult.h>
#include <aws/securityhub/model/DescribeProductsV2Request.h>
#include <aws/securityhub/model/DescribeProductsV2Result.h>
#include <aws/securityhub/model/DescribeSecurityHubV2Request.h>
#include <aws/securityhub/model/DescribeSecurityHubV2Result.h>
#include <aws/securityhub/model/DescribeStandardsControlsRequest.h>
#include <aws/securityhub/model/DescribeStandardsControlsResult.h>
#include <aws/securityhub/model/DescribeStandardsRequest.h>
#include <aws/securityhub/model/DescribeStandardsResult.h>
#include <aws/securityhub/model/Detection.h>
#include <aws/securityhub/model/DisableImportFindingsForProductRequest.h>
#include <aws/securityhub/model/DisableImportFindingsForProductResult.h>
#include <aws/securityhub/model/DisableOrganizationAdminAccountRequest.h>
#include <aws/securityhub/model/DisableOrganizationAdminAccountResult.h>
#include <aws/securityhub/model/DisableSecurityHubRequest.h>
#include <aws/securityhub/model/DisableSecurityHubResult.h>
#include <aws/securityhub/model/DisableSecurityHubV2Request.h>
#include <aws/securityhub/model/DisableSecurityHubV2Result.h>
#include <aws/securityhub/model/DisassociateFromAdministratorAccountRequest.h>
#include <aws/securityhub/model/DisassociateFromAdministratorAccountResult.h>
#include <aws/securityhub/model/DisassociateMembersRequest.h>
#include <aws/securityhub/model/DisassociateMembersResult.h>
#include <aws/securityhub/model/DnsRequestAction.h>
#include <aws/securityhub/model/DoubleConfigurationOptions.h>
#include <aws/securityhub/model/EnableImportFindingsForProductRequest.h>
#include <aws/securityhub/model/EnableImportFindingsForProductResult.h>
#include <aws/securityhub/model/EnableOrganizationAdminAccountRequest.h>
#include <aws/securityhub/model/EnableOrganizationAdminAccountResult.h>
#include <aws/securityhub/model/EnableSecurityHubRequest.h>
#include <aws/securityhub/model/EnableSecurityHubResult.h>
#include <aws/securityhub/model/EnableSecurityHubV2Request.h>
#include <aws/securityhub/model/EnableSecurityHubV2Result.h>
#include <aws/securityhub/model/EnumConfigurationOptions.h>
#include <aws/securityhub/model/EnumListConfigurationOptions.h>
#include <aws/securityhub/model/ExternalIntegrationConfiguration.h>
#include <aws/securityhub/model/FilePaths.h>
#include <aws/securityhub/model/FindingAggregator.h>
#include <aws/securityhub/model/FindingHistoryRecord.h>
#include <aws/securityhub/model/FindingHistoryUpdate.h>
#include <aws/securityhub/model/FindingHistoryUpdateSource.h>
#include <aws/securityhub/model/FindingHistoryUpdateSourceType.h>
#include <aws/securityhub/model/FindingProviderFields.h>
#include <aws/securityhub/model/FindingProviderSeverity.h>
#include <aws/securityhub/model/FirewallPolicyDetails.h>
#include <aws/securityhub/model/FirewallPolicyStatefulRuleGroupReferencesDetails.h>
#include <aws/securityhub/model/FirewallPolicyStatelessCustomActionsDetails.h>
#include <aws/securityhub/model/FirewallPolicyStatelessRuleGroupReferencesDetails.h>
#include <aws/securityhub/model/GeneratorDetails.h>
#include <aws/securityhub/model/GeoLocation.h>
#include <aws/securityhub/model/GetAdministratorAccountRequest.h>
#include <aws/securityhub/model/GetAdministratorAccountResult.h>
#include <aws/securityhub/model/GetAggregatorV2Request.h>
#include <aws/securityhub/model/GetAggregatorV2Result.h>
#include <aws/securityhub/model/GetAutomationRuleV2Request.h>
#include <aws/securityhub/model/GetAutomationRuleV2Result.h>
#include <aws/securityhub/model/GetConfigurationPolicyAssociationRequest.h>
#include <aws/securityhub/model/GetConfigurationPolicyAssociationResult.h>
#include <aws/securityhub/model/GetConfigurationPolicyRequest.h>
#include <aws/securityhub/model/GetConfigurationPolicyResult.h>
#include <aws/securityhub/model/GetConnectorV2Request.h>
#include <aws/securityhub/model/GetConnectorV2Result.h>
#include <aws/securityhub/model/GetEnabledStandardsRequest.h>
#include <aws/securityhub/model/GetEnabledStandardsResult.h>
#include <aws/securityhub/model/GetFindingAggregatorRequest.h>
#include <aws/securityhub/model/GetFindingAggregatorResult.h>
#include <aws/securityhub/model/GetFindingHistoryRequest.h>
#include <aws/securityhub/model/GetFindingHistoryResult.h>
#include <aws/securityhub/model/GetFindingStatisticsV2Request.h>
#include <aws/securityhub/model/GetFindingStatisticsV2Result.h>
#include <aws/securityhub/model/GetFindingsRequest.h>
#include <aws/securityhub/model/GetFindingsResult.h>
#include <aws/securityhub/model/GetFindingsV2Request.h>
#include <aws/securityhub/model/GetFindingsV2Result.h>
#include <aws/securityhub/model/GetInsightResultsRequest.h>
#include <aws/securityhub/model/GetInsightResultsResult.h>
#include <aws/securityhub/model/GetInsightsRequest.h>
#include <aws/securityhub/model/GetInsightsResult.h>
#include <aws/securityhub/model/GetInvitationsCountRequest.h>
#include <aws/securityhub/model/GetInvitationsCountResult.h>
#include <aws/securityhub/model/GetMembersRequest.h>
#include <aws/securityhub/model/GetMembersResult.h>
#include <aws/securityhub/model/GetResourcesStatisticsV2Request.h>
#include <aws/securityhub/model/GetResourcesStatisticsV2Result.h>
#include <aws/securityhub/model/GetResourcesV2Request.h>
#include <aws/securityhub/model/GetResourcesV2Result.h>
#include <aws/securityhub/model/GetSecurityControlDefinitionRequest.h>
#include <aws/securityhub/model/GetSecurityControlDefinitionResult.h>
#include <aws/securityhub/model/GroupByField.h>
#include <aws/securityhub/model/GroupByResult.h>
#include <aws/securityhub/model/GroupByRule.h>
#include <aws/securityhub/model/GroupByValue.h>
#include <aws/securityhub/model/HealthCheck.h>
#include <aws/securityhub/model/IcmpTypeCode.h>
#include <aws/securityhub/model/ImportFindingsError.h>
#include <aws/securityhub/model/Indicator.h>
#include <aws/securityhub/model/Insight.h>
#include <aws/securityhub/model/InsightResultValue.h>
#include <aws/securityhub/model/InsightResults.h>
#include <aws/securityhub/model/IntegerConfigurationOptions.h>
#include <aws/securityhub/model/IntegerListConfigurationOptions.h>
#include <aws/securityhub/model/IntegrationType.h>
#include <aws/securityhub/model/IntegrationV2Type.h>
#include <aws/securityhub/model/InternalException.h>
#include <aws/securityhub/model/InternalServerException.h>
#include <aws/securityhub/model/InvalidAccessException.h>
#include <aws/securityhub/model/InvalidInputException.h>
#include <aws/securityhub/model/Invitation.h>
#include <aws/securityhub/model/InviteMembersRequest.h>
#include <aws/securityhub/model/InviteMembersResult.h>
#include <aws/securityhub/model/IpFilter.h>
#include <aws/securityhub/model/IpOrganizationDetails.h>
#include <aws/securityhub/model/Ipv6CidrBlockAssociation.h>
#include <aws/securityhub/model/JiraCloudDetail.h>
#include <aws/securityhub/model/JiraCloudProviderConfiguration.h>
#include <aws/securityhub/model/JiraCloudUpdateConfiguration.h>
#include <aws/securityhub/model/KeywordFilter.h>
#include <aws/securityhub/model/LimitExceededException.h>
#include <aws/securityhub/model/ListAggregatorsV2Request.h>
#include <aws/securityhub/model/ListAggregatorsV2Result.h>
#include <aws/securityhub/model/ListAutomationRulesRequest.h>
#include <aws/securityhub/model/ListAutomationRulesResult.h>
#include <aws/securityhub/model/ListAutomationRulesV2Request.h>
#include <aws/securityhub/model/ListAutomationRulesV2Result.h>
#include <aws/securityhub/model/ListConfigurationPoliciesRequest.h>
#include <aws/securityhub/model/ListConfigurationPoliciesResult.h>
#include <aws/securityhub/model/ListConfigurationPolicyAssociationsRequest.h>
#include <aws/securityhub/model/ListConfigurationPolicyAssociationsResult.h>
#include <aws/securityhub/model/ListConnectorsV2Request.h>
#include <aws/securityhub/model/ListConnectorsV2Result.h>
#include <aws/securityhub/model/ListEnabledProductsForImportRequest.h>
#include <aws/securityhub/model/ListEnabledProductsForImportResult.h>
#include <aws/securityhub/model/ListFindingAggregatorsRequest.h>
#include <aws/securityhub/model/ListFindingAggregatorsResult.h>
#include <aws/securityhub/model/ListInvitationsRequest.h>
#include <aws/securityhub/model/ListInvitationsResult.h>
#include <aws/securityhub/model/ListMembersRequest.h>
#include <aws/securityhub/model/ListMembersResult.h>
#include <aws/securityhub/model/ListOrganizationAdminAccountsRequest.h>
#include <aws/securityhub/model/ListOrganizationAdminAccountsResult.h>
#include <aws/securityhub/model/ListSecurityControlDefinitionsRequest.h>
#include <aws/securityhub/model/ListSecurityControlDefinitionsResult.h>
#include <aws/securityhub/model/ListStandardsControlAssociationsRequest.h>
#include <aws/securityhub/model/ListStandardsControlAssociationsResult.h>
#include <aws/securityhub/model/ListTagsForResourceRequest.h>
#include <aws/securityhub/model/ListTagsForResourceResult.h>
#include <aws/securityhub/model/LoadBalancerState.h>
#include <aws/securityhub/model/Malware.h>
#include <aws/securityhub/model/MalwareState.h>
#include <aws/securityhub/model/MalwareType.h>
#include <aws/securityhub/model/MapFilter.h>
#include <aws/securityhub/model/MapFilterComparison.h>
#include <aws/securityhub/model/Member.h>
#include <aws/securityhub/model/Network.h>
#include <aws/securityhub/model/NetworkAutonomousSystem.h>
#include <aws/securityhub/model/NetworkConnection.h>
#include <aws/securityhub/model/NetworkConnectionAction.h>
#include <aws/securityhub/model/NetworkDirection.h>
#include <aws/securityhub/model/NetworkEndpoint.h>
#include <aws/securityhub/model/NetworkGeoLocation.h>
#include <aws/securityhub/model/NetworkHeader.h>
#include <aws/securityhub/model/NetworkPathComponent.h>
#include <aws/securityhub/model/NetworkPathComponentDetails.h>
#include <aws/securityhub/model/Note.h>
#include <aws/securityhub/model/NoteUpdate.h>
#include <aws/securityhub/model/NumberFilter.h>
#include <aws/securityhub/model/Occurrences.h>
#include <aws/securityhub/model/OcsfBooleanField.h>
#include <aws/securityhub/model/OcsfBooleanFilter.h>
#include <aws/securityhub/model/OcsfDateField.h>
#include <aws/securityhub/model/OcsfDateFilter.h>
#include <aws/securityhub/model/OcsfFindingFilters.h>
#include <aws/securityhub/model/OcsfFindingIdentifier.h>
#include <aws/securityhub/model/OcsfMapField.h>
#include <aws/securityhub/model/OcsfMapFilter.h>
#include <aws/securityhub/model/OcsfNumberField.h>
#include <aws/securityhub/model/OcsfNumberFilter.h>
#include <aws/securityhub/model/OcsfStringField.h>
#include <aws/securityhub/model/OcsfStringFilter.h>
#include <aws/securityhub/model/OrganizationConfiguration.h>
#include <aws/securityhub/model/OrganizationConfigurationConfigurationType.h>
#include <aws/securityhub/model/OrganizationConfigurationStatus.h>
#include <aws/securityhub/model/Page.h>
#include <aws/securityhub/model/ParameterConfiguration.h>
#include <aws/securityhub/model/ParameterDefinition.h>
#include <aws/securityhub/model/ParameterValue.h>
#include <aws/securityhub/model/ParameterValueType.h>
#include <aws/securityhub/model/Partition.h>
#include <aws/securityhub/model/PatchSummary.h>
#include <aws/securityhub/model/Policy.h>
#include <aws/securityhub/model/PortProbeAction.h>
#include <aws/securityhub/model/PortProbeDetail.h>
#include <aws/securityhub/model/PortRange.h>
#include <aws/securityhub/model/PortRangeFromTo.h>
#include <aws/securityhub/model/ProcessDetails.h>
#include <aws/securityhub/model/Product.h>
#include <aws/securityhub/model/ProductV2.h>
#include <aws/securityhub/model/PropagatingVgwSetDetails.h>
#include <aws/securityhub/model/ProviderConfiguration.h>
#include <aws/securityhub/model/ProviderDetail.h>
#include <aws/securityhub/model/ProviderSummary.h>
#include <aws/securityhub/model/ProviderUpdateConfiguration.h>
#include <aws/securityhub/model/Range.h>
#include <aws/securityhub/model/Recommendation.h>
#include <aws/securityhub/model/Record.h>
#include <aws/securityhub/model/RecordState.h>
#include <aws/securityhub/model/RegionAvailabilityStatus.h>
#include <aws/securityhub/model/RelatedFinding.h>
#include <aws/securityhub/model/Remediation.h>
#include <aws/securityhub/model/Resource.h>
#include <aws/securityhub/model/ResourceCategory.h>
#include <aws/securityhub/model/ResourceConflictException.h>
#include <aws/securityhub/model/ResourceDetails.h>
#include <aws/securityhub/model/ResourceFindingsSummary.h>
#include <aws/securityhub/model/ResourceGroupByField.h>
#include <aws/securityhub/model/ResourceGroupByRule.h>
#include <aws/securityhub/model/ResourceInUseException.h>
#include <aws/securityhub/model/ResourceNotFoundException.h>
#include <aws/securityhub/model/ResourceResult.h>
#include <aws/securityhub/model/ResourceSeverityBreakdown.h>
#include <aws/securityhub/model/ResourceTag.h>
#include <aws/securityhub/model/ResourcesCompositeFilter.h>
#include <aws/securityhub/model/ResourcesDateField.h>
#include <aws/securityhub/model/ResourcesDateFilter.h>
#include <aws/securityhub/model/ResourcesFilters.h>
#include <aws/securityhub/model/ResourcesMapField.h>
#include <aws/securityhub/model/ResourcesMapFilter.h>
#include <aws/securityhub/model/ResourcesNumberField.h>
#include <aws/securityhub/model/ResourcesNumberFilter.h>
#include <aws/securityhub/model/ResourcesStringField.h>
#include <aws/securityhub/model/ResourcesStringFilter.h>
#include <aws/securityhub/model/Result.h>
#include <aws/securityhub/model/RouteSetDetails.h>
#include <aws/securityhub/model/RuleGroupDetails.h>
#include <aws/securityhub/model/RuleGroupSource.h>
#include <aws/securityhub/model/RuleGroupSourceCustomActionsDetails.h>
#include <aws/securityhub/model/RuleGroupSourceListDetails.h>
#include <aws/securityhub/model/RuleGroupSourceStatefulRulesDetails.h>
#include <aws/securityhub/model/RuleGroupSourceStatefulRulesHeaderDetails.h>
#include <aws/securityhub/model/RuleGroupSourceStatefulRulesOptionsDetails.h>
#include <aws/securityhub/model/RuleGroupSourceStatelessRuleDefinition.h>
#include <aws/securityhub/model/RuleGroupSourceStatelessRuleMatchAttributes.h>
#include <aws/securityhub/model/RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts.h>
#include <aws/securityhub/model/RuleGroupSourceStatelessRuleMatchAttributesDestinations.h>
#include <aws/securityhub/model/RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.h>
#include <aws/securityhub/model/RuleGroupSourceStatelessRuleMatchAttributesSources.h>
#include <aws/securityhub/model/RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.h>
#include <aws/securityhub/model/RuleGroupSourceStatelessRulesAndCustomActionsDetails.h>
#include <aws/securityhub/model/RuleGroupSourceStatelessRulesDetails.h>
#include <aws/securityhub/model/RuleGroupVariables.h>
#include <aws/securityhub/model/RuleGroupVariablesIpSetsDetails.h>
#include <aws/securityhub/model/RuleGroupVariablesPortSetsDetails.h>
#include <aws/securityhub/model/RuleStatus.h>
#include <aws/securityhub/model/RuleStatusV2.h>
#include <aws/securityhub/model/SecurityControl.h>
#include <aws/securityhub/model/SecurityControlCustomParameter.h>
#include <aws/securityhub/model/SecurityControlDefinition.h>
#include <aws/securityhub/model/SecurityControlParameter.h>
#include <aws/securityhub/model/SecurityControlProperty.h>
#include <aws/securityhub/model/SecurityControlsConfiguration.h>
#include <aws/securityhub/model/SecurityHubFeature.h>
#include <aws/securityhub/model/SecurityHubPolicy.h>
#include <aws/securityhub/model/SensitiveDataDetections.h>
#include <aws/securityhub/model/SensitiveDataResult.h>
#include <aws/securityhub/model/Sequence.h>
#include <aws/securityhub/model/ServiceNowDetail.h>
#include <aws/securityhub/model/ServiceNowProviderConfiguration.h>
#include <aws/securityhub/model/Severity.h>
#include <aws/securityhub/model/SeverityLabel.h>
#include <aws/securityhub/model/SeverityRating.h>
#include <aws/securityhub/model/SeverityUpdate.h>
#include <aws/securityhub/model/Signal.h>
#include <aws/securityhub/model/SoftwarePackage.h>
#include <aws/securityhub/model/SortCriterion.h>
#include <aws/securityhub/model/SortOrder.h>
#include <aws/securityhub/model/Standard.h>
#include <aws/securityhub/model/StandardsControl.h>
#include <aws/securityhub/model/StandardsControlAssociationDetail.h>
#include <aws/securityhub/model/StandardsControlAssociationId.h>
#include <aws/securityhub/model/StandardsControlAssociationSummary.h>
#include <aws/securityhub/model/StandardsControlAssociationUpdate.h>
#include <aws/securityhub/model/StandardsControlsUpdatable.h>
#include <aws/securityhub/model/StandardsManagedBy.h>
#include <aws/securityhub/model/StandardsStatus.h>
#include <aws/securityhub/model/StandardsStatusReason.h>
#include <aws/securityhub/model/StandardsSubscription.h>
#include <aws/securityhub/model/StandardsSubscriptionRequest.h>
#include <aws/securityhub/model/StartConfigurationPolicyAssociationRequest.h>
#include <aws/securityhub/model/StartConfigurationPolicyAssociationResult.h>
#include <aws/securityhub/model/StartConfigurationPolicyDisassociationRequest.h>
#include <aws/securityhub/model/StartConfigurationPolicyDisassociationResult.h>
#include <aws/securityhub/model/StatelessCustomActionDefinition.h>
#include <aws/securityhub/model/StatelessCustomPublishMetricAction.h>
#include <aws/securityhub/model/StatelessCustomPublishMetricActionDimension.h>
#include <aws/securityhub/model/StatusReason.h>
#include <aws/securityhub/model/StatusReasonCode.h>
#include <aws/securityhub/model/StringConfigurationOptions.h>
#include <aws/securityhub/model/StringFilter.h>
#include <aws/securityhub/model/StringFilterComparison.h>
#include <aws/securityhub/model/StringListConfigurationOptions.h>
#include <aws/securityhub/model/TagResourceRequest.h>
#include <aws/securityhub/model/TagResourceResult.h>
#include <aws/securityhub/model/Target.h>
#include <aws/securityhub/model/TargetType.h>
#include <aws/securityhub/model/Threat.h>
#include <aws/securityhub/model/ThreatIntelIndicator.h>
#include <aws/securityhub/model/ThreatIntelIndicatorCategory.h>
#include <aws/securityhub/model/ThreatIntelIndicatorType.h>
#include <aws/securityhub/model/ThrottlingException.h>
#include <aws/securityhub/model/UnprocessedAutomationRule.h>
#include <aws/securityhub/model/UnprocessedConfigurationPolicyAssociation.h>
#include <aws/securityhub/model/UnprocessedErrorCode.h>
#include <aws/securityhub/model/UnprocessedSecurityControl.h>
#include <aws/securityhub/model/UnprocessedStandardsControlAssociation.h>
#include <aws/securityhub/model/UnprocessedStandardsControlAssociationUpdate.h>
#include <aws/securityhub/model/UntagResourceRequest.h>
#include <aws/securityhub/model/UntagResourceResult.h>
#include <aws/securityhub/model/UpdateActionTargetRequest.h>
#include <aws/securityhub/model/UpdateActionTargetResult.h>
#include <aws/securityhub/model/UpdateAggregatorV2Request.h>
#include <aws/securityhub/model/UpdateAggregatorV2Result.h>
#include <aws/securityhub/model/UpdateAutomationRuleV2Request.h>
#include <aws/securityhub/model/UpdateAutomationRuleV2Result.h>
#include <aws/securityhub/model/UpdateAutomationRulesRequestItem.h>
#include <aws/securityhub/model/UpdateConfigurationPolicyRequest.h>
#include <aws/securityhub/model/UpdateConfigurationPolicyResult.h>
#include <aws/securityhub/model/UpdateConnectorV2Request.h>
#include <aws/securityhub/model/UpdateConnectorV2Result.h>
#include <aws/securityhub/model/UpdateFindingAggregatorRequest.h>
#include <aws/securityhub/model/UpdateFindingAggregatorResult.h>
#include <aws/securityhub/model/UpdateFindingsRequest.h>
#include <aws/securityhub/model/UpdateFindingsResult.h>
#include <aws/securityhub/model/UpdateInsightRequest.h>
#include <aws/securityhub/model/UpdateInsightResult.h>
#include <aws/securityhub/model/UpdateOrganizationConfigurationRequest.h>
#include <aws/securityhub/model/UpdateOrganizationConfigurationResult.h>
#include <aws/securityhub/model/UpdateSecurityControlRequest.h>
#include <aws/securityhub/model/UpdateSecurityControlResult.h>
#include <aws/securityhub/model/UpdateSecurityHubConfigurationRequest.h>
#include <aws/securityhub/model/UpdateSecurityHubConfigurationResult.h>
#include <aws/securityhub/model/UpdateStandardsControlRequest.h>
#include <aws/securityhub/model/UpdateStandardsControlResult.h>
#include <aws/securityhub/model/UpdateStatus.h>
#include <aws/securityhub/model/UserAccount.h>
#include <aws/securityhub/model/ValidationException.h>
#include <aws/securityhub/model/VerificationState.h>
#include <aws/securityhub/model/VolumeMount.h>
#include <aws/securityhub/model/VpcInfoCidrBlockSetDetails.h>
#include <aws/securityhub/model/VpcInfoIpv6CidrBlockSetDetails.h>
#include <aws/securityhub/model/VpcInfoPeeringOptionsDetails.h>
#include <aws/securityhub/model/Vulnerability.h>
#include <aws/securityhub/model/VulnerabilityCodeVulnerabilities.h>
#include <aws/securityhub/model/VulnerabilityExploitAvailable.h>
#include <aws/securityhub/model/VulnerabilityFixAvailable.h>
#include <aws/securityhub/model/VulnerabilityVendor.h>
#include <aws/securityhub/model/WafAction.h>
#include <aws/securityhub/model/WafExcludedRule.h>
#include <aws/securityhub/model/WafOverrideAction.h>
#include <aws/securityhub/model/Workflow.h>
#include <aws/securityhub/model/WorkflowState.h>
#include <aws/securityhub/model/WorkflowStatus.h>
#include <aws/securityhub/model/WorkflowUpdate.h>

using SecurityHubIncludeTest = ::testing::Test;

TEST_F(SecurityHubIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::SecurityHub::SecurityHubClient>("SecurityHubIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
