/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/servicecatalog/ServiceCatalogClient.h>
#include <aws/servicecatalog/ServiceCatalogEndpointProvider.h>
#include <aws/servicecatalog/ServiceCatalogEndpointRules.h>
#include <aws/servicecatalog/ServiceCatalogErrorMarshaller.h>
#include <aws/servicecatalog/ServiceCatalogErrors.h>
#include <aws/servicecatalog/ServiceCatalogRequest.h>
#include <aws/servicecatalog/ServiceCatalogServiceClientModel.h>
#include <aws/servicecatalog/ServiceCatalog_EXPORTS.h>
#include <aws/servicecatalog/model/AcceptPortfolioShareRequest.h>
#include <aws/servicecatalog/model/AcceptPortfolioShareResult.h>
#include <aws/servicecatalog/model/AccessLevelFilter.h>
#include <aws/servicecatalog/model/AccessLevelFilterKey.h>
#include <aws/servicecatalog/model/AccessStatus.h>
#include <aws/servicecatalog/model/AssociateBudgetWithResourceRequest.h>
#include <aws/servicecatalog/model/AssociateBudgetWithResourceResult.h>
#include <aws/servicecatalog/model/AssociatePrincipalWithPortfolioRequest.h>
#include <aws/servicecatalog/model/AssociatePrincipalWithPortfolioResult.h>
#include <aws/servicecatalog/model/AssociateProductWithPortfolioRequest.h>
#include <aws/servicecatalog/model/AssociateProductWithPortfolioResult.h>
#include <aws/servicecatalog/model/AssociateServiceActionWithProvisioningArtifactRequest.h>
#include <aws/servicecatalog/model/AssociateServiceActionWithProvisioningArtifactResult.h>
#include <aws/servicecatalog/model/AssociateTagOptionWithResourceRequest.h>
#include <aws/servicecatalog/model/AssociateTagOptionWithResourceResult.h>
#include <aws/servicecatalog/model/BatchAssociateServiceActionWithProvisioningArtifactRequest.h>
#include <aws/servicecatalog/model/BatchAssociateServiceActionWithProvisioningArtifactResult.h>
#include <aws/servicecatalog/model/BatchDisassociateServiceActionFromProvisioningArtifactRequest.h>
#include <aws/servicecatalog/model/BatchDisassociateServiceActionFromProvisioningArtifactResult.h>
#include <aws/servicecatalog/model/BudgetDetail.h>
#include <aws/servicecatalog/model/ChangeAction.h>
#include <aws/servicecatalog/model/CloudWatchDashboard.h>
#include <aws/servicecatalog/model/CodeStarParameters.h>
#include <aws/servicecatalog/model/ConstraintDetail.h>
#include <aws/servicecatalog/model/ConstraintSummary.h>
#include <aws/servicecatalog/model/CopyOption.h>
#include <aws/servicecatalog/model/CopyProductRequest.h>
#include <aws/servicecatalog/model/CopyProductResult.h>
#include <aws/servicecatalog/model/CopyProductStatus.h>
#include <aws/servicecatalog/model/CreateConstraintRequest.h>
#include <aws/servicecatalog/model/CreateConstraintResult.h>
#include <aws/servicecatalog/model/CreatePortfolioRequest.h>
#include <aws/servicecatalog/model/CreatePortfolioResult.h>
#include <aws/servicecatalog/model/CreatePortfolioShareRequest.h>
#include <aws/servicecatalog/model/CreatePortfolioShareResult.h>
#include <aws/servicecatalog/model/CreateProductRequest.h>
#include <aws/servicecatalog/model/CreateProductResult.h>
#include <aws/servicecatalog/model/CreateProvisionedProductPlanRequest.h>
#include <aws/servicecatalog/model/CreateProvisionedProductPlanResult.h>
#include <aws/servicecatalog/model/CreateProvisioningArtifactRequest.h>
#include <aws/servicecatalog/model/CreateProvisioningArtifactResult.h>
#include <aws/servicecatalog/model/CreateServiceActionRequest.h>
#include <aws/servicecatalog/model/CreateServiceActionResult.h>
#include <aws/servicecatalog/model/CreateTagOptionRequest.h>
#include <aws/servicecatalog/model/CreateTagOptionResult.h>
#include <aws/servicecatalog/model/DeleteConstraintRequest.h>
#include <aws/servicecatalog/model/DeleteConstraintResult.h>
#include <aws/servicecatalog/model/DeletePortfolioRequest.h>
#include <aws/servicecatalog/model/DeletePortfolioResult.h>
#include <aws/servicecatalog/model/DeletePortfolioShareRequest.h>
#include <aws/servicecatalog/model/DeletePortfolioShareResult.h>
#include <aws/servicecatalog/model/DeleteProductRequest.h>
#include <aws/servicecatalog/model/DeleteProductResult.h>
#include <aws/servicecatalog/model/DeleteProvisionedProductPlanRequest.h>
#include <aws/servicecatalog/model/DeleteProvisionedProductPlanResult.h>
#include <aws/servicecatalog/model/DeleteProvisioningArtifactRequest.h>
#include <aws/servicecatalog/model/DeleteProvisioningArtifactResult.h>
#include <aws/servicecatalog/model/DeleteServiceActionRequest.h>
#include <aws/servicecatalog/model/DeleteServiceActionResult.h>
#include <aws/servicecatalog/model/DeleteTagOptionRequest.h>
#include <aws/servicecatalog/model/DeleteTagOptionResult.h>
#include <aws/servicecatalog/model/DescribeConstraintRequest.h>
#include <aws/servicecatalog/model/DescribeConstraintResult.h>
#include <aws/servicecatalog/model/DescribeCopyProductStatusRequest.h>
#include <aws/servicecatalog/model/DescribeCopyProductStatusResult.h>
#include <aws/servicecatalog/model/DescribePortfolioRequest.h>
#include <aws/servicecatalog/model/DescribePortfolioResult.h>
#include <aws/servicecatalog/model/DescribePortfolioShareStatusRequest.h>
#include <aws/servicecatalog/model/DescribePortfolioShareStatusResult.h>
#include <aws/servicecatalog/model/DescribePortfolioShareType.h>
#include <aws/servicecatalog/model/DescribePortfolioSharesRequest.h>
#include <aws/servicecatalog/model/DescribePortfolioSharesResult.h>
#include <aws/servicecatalog/model/DescribeProductAsAdminRequest.h>
#include <aws/servicecatalog/model/DescribeProductAsAdminResult.h>
#include <aws/servicecatalog/model/DescribeProductRequest.h>
#include <aws/servicecatalog/model/DescribeProductResult.h>
#include <aws/servicecatalog/model/DescribeProductViewRequest.h>
#include <aws/servicecatalog/model/DescribeProductViewResult.h>
#include <aws/servicecatalog/model/DescribeProvisionedProductPlanRequest.h>
#include <aws/servicecatalog/model/DescribeProvisionedProductPlanResult.h>
#include <aws/servicecatalog/model/DescribeProvisionedProductRequest.h>
#include <aws/servicecatalog/model/DescribeProvisionedProductResult.h>
#include <aws/servicecatalog/model/DescribeProvisioningArtifactRequest.h>
#include <aws/servicecatalog/model/DescribeProvisioningArtifactResult.h>
#include <aws/servicecatalog/model/DescribeProvisioningParametersRequest.h>
#include <aws/servicecatalog/model/DescribeProvisioningParametersResult.h>
#include <aws/servicecatalog/model/DescribeRecordRequest.h>
#include <aws/servicecatalog/model/DescribeRecordResult.h>
#include <aws/servicecatalog/model/DescribeServiceActionExecutionParametersRequest.h>
#include <aws/servicecatalog/model/DescribeServiceActionExecutionParametersResult.h>
#include <aws/servicecatalog/model/DescribeServiceActionRequest.h>
#include <aws/servicecatalog/model/DescribeServiceActionResult.h>
#include <aws/servicecatalog/model/DescribeTagOptionRequest.h>
#include <aws/servicecatalog/model/DescribeTagOptionResult.h>
#include <aws/servicecatalog/model/DisableAWSOrganizationsAccessRequest.h>
#include <aws/servicecatalog/model/DisableAWSOrganizationsAccessResult.h>
#include <aws/servicecatalog/model/DisassociateBudgetFromResourceRequest.h>
#include <aws/servicecatalog/model/DisassociateBudgetFromResourceResult.h>
#include <aws/servicecatalog/model/DisassociatePrincipalFromPortfolioRequest.h>
#include <aws/servicecatalog/model/DisassociatePrincipalFromPortfolioResult.h>
#include <aws/servicecatalog/model/DisassociateProductFromPortfolioRequest.h>
#include <aws/servicecatalog/model/DisassociateProductFromPortfolioResult.h>
#include <aws/servicecatalog/model/DisassociateServiceActionFromProvisioningArtifactRequest.h>
#include <aws/servicecatalog/model/DisassociateServiceActionFromProvisioningArtifactResult.h>
#include <aws/servicecatalog/model/DisassociateTagOptionFromResourceRequest.h>
#include <aws/servicecatalog/model/DisassociateTagOptionFromResourceResult.h>
#include <aws/servicecatalog/model/EnableAWSOrganizationsAccessRequest.h>
#include <aws/servicecatalog/model/EnableAWSOrganizationsAccessResult.h>
#include <aws/servicecatalog/model/EngineWorkflowResourceIdentifier.h>
#include <aws/servicecatalog/model/EngineWorkflowStatus.h>
#include <aws/servicecatalog/model/EvaluationType.h>
#include <aws/servicecatalog/model/ExecuteProvisionedProductPlanRequest.h>
#include <aws/servicecatalog/model/ExecuteProvisionedProductPlanResult.h>
#include <aws/servicecatalog/model/ExecuteProvisionedProductServiceActionRequest.h>
#include <aws/servicecatalog/model/ExecuteProvisionedProductServiceActionResult.h>
#include <aws/servicecatalog/model/ExecutionParameter.h>
#include <aws/servicecatalog/model/FailedServiceActionAssociation.h>
#include <aws/servicecatalog/model/GetAWSOrganizationsAccessStatusRequest.h>
#include <aws/servicecatalog/model/GetAWSOrganizationsAccessStatusResult.h>
#include <aws/servicecatalog/model/GetProvisionedProductOutputsRequest.h>
#include <aws/servicecatalog/model/GetProvisionedProductOutputsResult.h>
#include <aws/servicecatalog/model/ImportAsProvisionedProductRequest.h>
#include <aws/servicecatalog/model/ImportAsProvisionedProductResult.h>
#include <aws/servicecatalog/model/LastSync.h>
#include <aws/servicecatalog/model/LastSyncStatus.h>
#include <aws/servicecatalog/model/LaunchPath.h>
#include <aws/servicecatalog/model/LaunchPathSummary.h>
#include <aws/servicecatalog/model/ListAcceptedPortfolioSharesRequest.h>
#include <aws/servicecatalog/model/ListAcceptedPortfolioSharesResult.h>
#include <aws/servicecatalog/model/ListBudgetsForResourceRequest.h>
#include <aws/servicecatalog/model/ListBudgetsForResourceResult.h>
#include <aws/servicecatalog/model/ListConstraintsForPortfolioRequest.h>
#include <aws/servicecatalog/model/ListConstraintsForPortfolioResult.h>
#include <aws/servicecatalog/model/ListLaunchPathsRequest.h>
#include <aws/servicecatalog/model/ListLaunchPathsResult.h>
#include <aws/servicecatalog/model/ListOrganizationPortfolioAccessRequest.h>
#include <aws/servicecatalog/model/ListOrganizationPortfolioAccessResult.h>
#include <aws/servicecatalog/model/ListPortfolioAccessRequest.h>
#include <aws/servicecatalog/model/ListPortfolioAccessResult.h>
#include <aws/servicecatalog/model/ListPortfoliosForProductRequest.h>
#include <aws/servicecatalog/model/ListPortfoliosForProductResult.h>
#include <aws/servicecatalog/model/ListPortfoliosRequest.h>
#include <aws/servicecatalog/model/ListPortfoliosResult.h>
#include <aws/servicecatalog/model/ListPrincipalsForPortfolioRequest.h>
#include <aws/servicecatalog/model/ListPrincipalsForPortfolioResult.h>
#include <aws/servicecatalog/model/ListProvisionedProductPlansRequest.h>
#include <aws/servicecatalog/model/ListProvisionedProductPlansResult.h>
#include <aws/servicecatalog/model/ListProvisioningArtifactsForServiceActionRequest.h>
#include <aws/servicecatalog/model/ListProvisioningArtifactsForServiceActionResult.h>
#include <aws/servicecatalog/model/ListProvisioningArtifactsRequest.h>
#include <aws/servicecatalog/model/ListProvisioningArtifactsResult.h>
#include <aws/servicecatalog/model/ListRecordHistoryRequest.h>
#include <aws/servicecatalog/model/ListRecordHistoryResult.h>
#include <aws/servicecatalog/model/ListRecordHistorySearchFilter.h>
#include <aws/servicecatalog/model/ListResourcesForTagOptionRequest.h>
#include <aws/servicecatalog/model/ListResourcesForTagOptionResult.h>
#include <aws/servicecatalog/model/ListServiceActionsForProvisioningArtifactRequest.h>
#include <aws/servicecatalog/model/ListServiceActionsForProvisioningArtifactResult.h>
#include <aws/servicecatalog/model/ListServiceActionsRequest.h>
#include <aws/servicecatalog/model/ListServiceActionsResult.h>
#include <aws/servicecatalog/model/ListStackInstancesForProvisionedProductRequest.h>
#include <aws/servicecatalog/model/ListStackInstancesForProvisionedProductResult.h>
#include <aws/servicecatalog/model/ListTagOptionsFilters.h>
#include <aws/servicecatalog/model/ListTagOptionsRequest.h>
#include <aws/servicecatalog/model/ListTagOptionsResult.h>
#include <aws/servicecatalog/model/NotifyProvisionProductEngineWorkflowResultRequest.h>
#include <aws/servicecatalog/model/NotifyProvisionProductEngineWorkflowResultResult.h>
#include <aws/servicecatalog/model/NotifyTerminateProvisionedProductEngineWorkflowResultRequest.h>
#include <aws/servicecatalog/model/NotifyTerminateProvisionedProductEngineWorkflowResultResult.h>
#include <aws/servicecatalog/model/NotifyUpdateProvisionedProductEngineWorkflowResultRequest.h>
#include <aws/servicecatalog/model/NotifyUpdateProvisionedProductEngineWorkflowResultResult.h>
#include <aws/servicecatalog/model/OrganizationNode.h>
#include <aws/servicecatalog/model/OrganizationNodeType.h>
#include <aws/servicecatalog/model/ParameterConstraints.h>
#include <aws/servicecatalog/model/PortfolioDetail.h>
#include <aws/servicecatalog/model/PortfolioShareDetail.h>
#include <aws/servicecatalog/model/PortfolioShareType.h>
#include <aws/servicecatalog/model/Principal.h>
#include <aws/servicecatalog/model/PrincipalType.h>
#include <aws/servicecatalog/model/ProductSource.h>
#include <aws/servicecatalog/model/ProductType.h>
#include <aws/servicecatalog/model/ProductViewAggregationValue.h>
#include <aws/servicecatalog/model/ProductViewDetail.h>
#include <aws/servicecatalog/model/ProductViewFilterBy.h>
#include <aws/servicecatalog/model/ProductViewSortBy.h>
#include <aws/servicecatalog/model/ProductViewSummary.h>
#include <aws/servicecatalog/model/PropertyKey.h>
#include <aws/servicecatalog/model/ProvisionProductRequest.h>
#include <aws/servicecatalog/model/ProvisionProductResult.h>
#include <aws/servicecatalog/model/ProvisionedProductAttribute.h>
#include <aws/servicecatalog/model/ProvisionedProductDetail.h>
#include <aws/servicecatalog/model/ProvisionedProductPlanDetails.h>
#include <aws/servicecatalog/model/ProvisionedProductPlanStatus.h>
#include <aws/servicecatalog/model/ProvisionedProductPlanSummary.h>
#include <aws/servicecatalog/model/ProvisionedProductPlanType.h>
#include <aws/servicecatalog/model/ProvisionedProductStatus.h>
#include <aws/servicecatalog/model/ProvisionedProductViewFilterBy.h>
#include <aws/servicecatalog/model/ProvisioningArtifact.h>
#include <aws/servicecatalog/model/ProvisioningArtifactDetail.h>
#include <aws/servicecatalog/model/ProvisioningArtifactGuidance.h>
#include <aws/servicecatalog/model/ProvisioningArtifactOutput.h>
#include <aws/servicecatalog/model/ProvisioningArtifactParameter.h>
#include <aws/servicecatalog/model/ProvisioningArtifactPreferences.h>
#include <aws/servicecatalog/model/ProvisioningArtifactProperties.h>
#include <aws/servicecatalog/model/ProvisioningArtifactPropertyName.h>
#include <aws/servicecatalog/model/ProvisioningArtifactSummary.h>
#include <aws/servicecatalog/model/ProvisioningArtifactType.h>
#include <aws/servicecatalog/model/ProvisioningArtifactView.h>
#include <aws/servicecatalog/model/ProvisioningParameter.h>
#include <aws/servicecatalog/model/ProvisioningPreferences.h>
#include <aws/servicecatalog/model/RecordDetail.h>
#include <aws/servicecatalog/model/RecordError.h>
#include <aws/servicecatalog/model/RecordOutput.h>
#include <aws/servicecatalog/model/RecordStatus.h>
#include <aws/servicecatalog/model/RecordTag.h>
#include <aws/servicecatalog/model/RejectPortfolioShareRequest.h>
#include <aws/servicecatalog/model/RejectPortfolioShareResult.h>
#include <aws/servicecatalog/model/Replacement.h>
#include <aws/servicecatalog/model/RequiresRecreation.h>
#include <aws/servicecatalog/model/ResourceAttribute.h>
#include <aws/servicecatalog/model/ResourceChange.h>
#include <aws/servicecatalog/model/ResourceChangeDetail.h>
#include <aws/servicecatalog/model/ResourceDetail.h>
#include <aws/servicecatalog/model/ResourceTargetDefinition.h>
#include <aws/servicecatalog/model/ScanProvisionedProductsRequest.h>
#include <aws/servicecatalog/model/ScanProvisionedProductsResult.h>
#include <aws/servicecatalog/model/SearchProductsAsAdminRequest.h>
#include <aws/servicecatalog/model/SearchProductsAsAdminResult.h>
#include <aws/servicecatalog/model/SearchProductsRequest.h>
#include <aws/servicecatalog/model/SearchProductsResult.h>
#include <aws/servicecatalog/model/SearchProvisionedProductsRequest.h>
#include <aws/servicecatalog/model/SearchProvisionedProductsResult.h>
#include <aws/servicecatalog/model/ServiceActionAssociation.h>
#include <aws/servicecatalog/model/ServiceActionAssociationErrorCode.h>
#include <aws/servicecatalog/model/ServiceActionDefinitionKey.h>
#include <aws/servicecatalog/model/ServiceActionDefinitionType.h>
#include <aws/servicecatalog/model/ServiceActionDetail.h>
#include <aws/servicecatalog/model/ServiceActionSummary.h>
#include <aws/servicecatalog/model/ShareDetails.h>
#include <aws/servicecatalog/model/ShareError.h>
#include <aws/servicecatalog/model/ShareStatus.h>
#include <aws/servicecatalog/model/SortOrder.h>
#include <aws/servicecatalog/model/SourceConnection.h>
#include <aws/servicecatalog/model/SourceConnectionDetail.h>
#include <aws/servicecatalog/model/SourceConnectionParameters.h>
#include <aws/servicecatalog/model/SourceType.h>
#include <aws/servicecatalog/model/StackInstance.h>
#include <aws/servicecatalog/model/StackInstanceStatus.h>
#include <aws/servicecatalog/model/StackSetOperationType.h>
#include <aws/servicecatalog/model/Status.h>
#include <aws/servicecatalog/model/Tag.h>
#include <aws/servicecatalog/model/TagOptionDetail.h>
#include <aws/servicecatalog/model/TagOptionSummary.h>
#include <aws/servicecatalog/model/TerminateProvisionedProductRequest.h>
#include <aws/servicecatalog/model/TerminateProvisionedProductResult.h>
#include <aws/servicecatalog/model/UniqueTagResourceIdentifier.h>
#include <aws/servicecatalog/model/UpdateConstraintRequest.h>
#include <aws/servicecatalog/model/UpdateConstraintResult.h>
#include <aws/servicecatalog/model/UpdatePortfolioRequest.h>
#include <aws/servicecatalog/model/UpdatePortfolioResult.h>
#include <aws/servicecatalog/model/UpdatePortfolioShareRequest.h>
#include <aws/servicecatalog/model/UpdatePortfolioShareResult.h>
#include <aws/servicecatalog/model/UpdateProductRequest.h>
#include <aws/servicecatalog/model/UpdateProductResult.h>
#include <aws/servicecatalog/model/UpdateProvisionedProductPropertiesRequest.h>
#include <aws/servicecatalog/model/UpdateProvisionedProductPropertiesResult.h>
#include <aws/servicecatalog/model/UpdateProvisionedProductRequest.h>
#include <aws/servicecatalog/model/UpdateProvisionedProductResult.h>
#include <aws/servicecatalog/model/UpdateProvisioningArtifactRequest.h>
#include <aws/servicecatalog/model/UpdateProvisioningArtifactResult.h>
#include <aws/servicecatalog/model/UpdateProvisioningParameter.h>
#include <aws/servicecatalog/model/UpdateProvisioningPreferences.h>
#include <aws/servicecatalog/model/UpdateServiceActionRequest.h>
#include <aws/servicecatalog/model/UpdateServiceActionResult.h>
#include <aws/servicecatalog/model/UpdateTagOptionRequest.h>
#include <aws/servicecatalog/model/UpdateTagOptionResult.h>
#include <aws/servicecatalog/model/UsageInstruction.h>

using ServiceCatalogIncludeTest = ::testing::Test;

TEST_F(ServiceCatalogIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::ServiceCatalog::ServiceCatalogClient>("ServiceCatalogIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
