/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/sesv2/SESV2Client.h>
#include <aws/sesv2/SESV2EndpointProvider.h>
#include <aws/sesv2/SESV2EndpointRules.h>
#include <aws/sesv2/SESV2ErrorMarshaller.h>
#include <aws/sesv2/SESV2Errors.h>
#include <aws/sesv2/SESV2Request.h>
#include <aws/sesv2/SESV2ServiceClientModel.h>
#include <aws/sesv2/SESV2_EXPORTS.h>
#include <aws/sesv2/model/AccountDetails.h>
#include <aws/sesv2/model/ArchivingOptions.h>
#include <aws/sesv2/model/Attachment.h>
#include <aws/sesv2/model/AttachmentContentDisposition.h>
#include <aws/sesv2/model/AttachmentContentTransferEncoding.h>
#include <aws/sesv2/model/BatchGetMetricDataQuery.h>
#include <aws/sesv2/model/BatchGetMetricDataRequest.h>
#include <aws/sesv2/model/BatchGetMetricDataResult.h>
#include <aws/sesv2/model/BehaviorOnMxFailure.h>
#include <aws/sesv2/model/BlacklistEntry.h>
#include <aws/sesv2/model/Body.h>
#include <aws/sesv2/model/Bounce.h>
#include <aws/sesv2/model/BounceType.h>
#include <aws/sesv2/model/BulkEmailContent.h>
#include <aws/sesv2/model/BulkEmailEntry.h>
#include <aws/sesv2/model/BulkEmailEntryResult.h>
#include <aws/sesv2/model/BulkEmailStatus.h>
#include <aws/sesv2/model/CancelExportJobRequest.h>
#include <aws/sesv2/model/CancelExportJobResult.h>
#include <aws/sesv2/model/CloudWatchDestination.h>
#include <aws/sesv2/model/CloudWatchDimensionConfiguration.h>
#include <aws/sesv2/model/Complaint.h>
#include <aws/sesv2/model/Contact.h>
#include <aws/sesv2/model/ContactLanguage.h>
#include <aws/sesv2/model/ContactList.h>
#include <aws/sesv2/model/ContactListDestination.h>
#include <aws/sesv2/model/ContactListImportAction.h>
#include <aws/sesv2/model/Content.h>
#include <aws/sesv2/model/CreateConfigurationSetEventDestinationRequest.h>
#include <aws/sesv2/model/CreateConfigurationSetEventDestinationResult.h>
#include <aws/sesv2/model/CreateConfigurationSetRequest.h>
#include <aws/sesv2/model/CreateConfigurationSetResult.h>
#include <aws/sesv2/model/CreateContactListRequest.h>
#include <aws/sesv2/model/CreateContactListResult.h>
#include <aws/sesv2/model/CreateContactRequest.h>
#include <aws/sesv2/model/CreateContactResult.h>
#include <aws/sesv2/model/CreateCustomVerificationEmailTemplateRequest.h>
#include <aws/sesv2/model/CreateCustomVerificationEmailTemplateResult.h>
#include <aws/sesv2/model/CreateDedicatedIpPoolRequest.h>
#include <aws/sesv2/model/CreateDedicatedIpPoolResult.h>
#include <aws/sesv2/model/CreateDeliverabilityTestReportRequest.h>
#include <aws/sesv2/model/CreateDeliverabilityTestReportResult.h>
#include <aws/sesv2/model/CreateEmailIdentityPolicyRequest.h>
#include <aws/sesv2/model/CreateEmailIdentityPolicyResult.h>
#include <aws/sesv2/model/CreateEmailIdentityRequest.h>
#include <aws/sesv2/model/CreateEmailIdentityResult.h>
#include <aws/sesv2/model/CreateEmailTemplateRequest.h>
#include <aws/sesv2/model/CreateEmailTemplateResult.h>
#include <aws/sesv2/model/CreateExportJobRequest.h>
#include <aws/sesv2/model/CreateExportJobResult.h>
#include <aws/sesv2/model/CreateImportJobRequest.h>
#include <aws/sesv2/model/CreateImportJobResult.h>
#include <aws/sesv2/model/CreateMultiRegionEndpointRequest.h>
#include <aws/sesv2/model/CreateMultiRegionEndpointResult.h>
#include <aws/sesv2/model/CustomVerificationEmailTemplateMetadata.h>
#include <aws/sesv2/model/DailyVolume.h>
#include <aws/sesv2/model/DashboardAttributes.h>
#include <aws/sesv2/model/DashboardOptions.h>
#include <aws/sesv2/model/DataFormat.h>
#include <aws/sesv2/model/DedicatedIp.h>
#include <aws/sesv2/model/DedicatedIpPool.h>
#include <aws/sesv2/model/DeleteConfigurationSetEventDestinationRequest.h>
#include <aws/sesv2/model/DeleteConfigurationSetEventDestinationResult.h>
#include <aws/sesv2/model/DeleteConfigurationSetRequest.h>
#include <aws/sesv2/model/DeleteConfigurationSetResult.h>
#include <aws/sesv2/model/DeleteContactListRequest.h>
#include <aws/sesv2/model/DeleteContactListResult.h>
#include <aws/sesv2/model/DeleteContactRequest.h>
#include <aws/sesv2/model/DeleteContactResult.h>
#include <aws/sesv2/model/DeleteCustomVerificationEmailTemplateRequest.h>
#include <aws/sesv2/model/DeleteCustomVerificationEmailTemplateResult.h>
#include <aws/sesv2/model/DeleteDedicatedIpPoolRequest.h>
#include <aws/sesv2/model/DeleteDedicatedIpPoolResult.h>
#include <aws/sesv2/model/DeleteEmailIdentityPolicyRequest.h>
#include <aws/sesv2/model/DeleteEmailIdentityPolicyResult.h>
#include <aws/sesv2/model/DeleteEmailIdentityRequest.h>
#include <aws/sesv2/model/DeleteEmailIdentityResult.h>
#include <aws/sesv2/model/DeleteEmailTemplateRequest.h>
#include <aws/sesv2/model/DeleteEmailTemplateResult.h>
#include <aws/sesv2/model/DeleteMultiRegionEndpointRequest.h>
#include <aws/sesv2/model/DeleteMultiRegionEndpointResult.h>
#include <aws/sesv2/model/DeleteSuppressedDestinationRequest.h>
#include <aws/sesv2/model/DeleteSuppressedDestinationResult.h>
#include <aws/sesv2/model/DeliverabilityDashboardAccountStatus.h>
#include <aws/sesv2/model/DeliverabilityTestReport.h>
#include <aws/sesv2/model/DeliverabilityTestStatus.h>
#include <aws/sesv2/model/DeliveryEventType.h>
#include <aws/sesv2/model/DeliveryOptions.h>
#include <aws/sesv2/model/Destination.h>
#include <aws/sesv2/model/Details.h>
#include <aws/sesv2/model/DimensionValueSource.h>
#include <aws/sesv2/model/DkimAttributes.h>
#include <aws/sesv2/model/DkimSigningAttributes.h>
#include <aws/sesv2/model/DkimSigningAttributesOrigin.h>
#include <aws/sesv2/model/DkimSigningKeyLength.h>
#include <aws/sesv2/model/DkimStatus.h>
#include <aws/sesv2/model/DomainDeliverabilityCampaign.h>
#include <aws/sesv2/model/DomainDeliverabilityTrackingOption.h>
#include <aws/sesv2/model/DomainIspPlacement.h>
#include <aws/sesv2/model/EmailContent.h>
#include <aws/sesv2/model/EmailInsights.h>
#include <aws/sesv2/model/EmailTemplateContent.h>
#include <aws/sesv2/model/EmailTemplateMetadata.h>
#include <aws/sesv2/model/EngagementEventType.h>
#include <aws/sesv2/model/EventBridgeDestination.h>
#include <aws/sesv2/model/EventDestination.h>
#include <aws/sesv2/model/EventDestinationDefinition.h>
#include <aws/sesv2/model/EventDetails.h>
#include <aws/sesv2/model/EventType.h>
#include <aws/sesv2/model/ExportDataSource.h>
#include <aws/sesv2/model/ExportDestination.h>
#include <aws/sesv2/model/ExportJobSummary.h>
#include <aws/sesv2/model/ExportMetric.h>
#include <aws/sesv2/model/ExportSourceType.h>
#include <aws/sesv2/model/ExportStatistics.h>
#include <aws/sesv2/model/FailureInfo.h>
#include <aws/sesv2/model/FeatureStatus.h>
#include <aws/sesv2/model/GetAccountRequest.h>
#include <aws/sesv2/model/GetAccountResult.h>
#include <aws/sesv2/model/GetBlacklistReportsRequest.h>
#include <aws/sesv2/model/GetBlacklistReportsResult.h>
#include <aws/sesv2/model/GetConfigurationSetEventDestinationsRequest.h>
#include <aws/sesv2/model/GetConfigurationSetEventDestinationsResult.h>
#include <aws/sesv2/model/GetConfigurationSetRequest.h>
#include <aws/sesv2/model/GetConfigurationSetResult.h>
#include <aws/sesv2/model/GetContactListRequest.h>
#include <aws/sesv2/model/GetContactListResult.h>
#include <aws/sesv2/model/GetContactRequest.h>
#include <aws/sesv2/model/GetContactResult.h>
#include <aws/sesv2/model/GetCustomVerificationEmailTemplateRequest.h>
#include <aws/sesv2/model/GetCustomVerificationEmailTemplateResult.h>
#include <aws/sesv2/model/GetDedicatedIpPoolRequest.h>
#include <aws/sesv2/model/GetDedicatedIpPoolResult.h>
#include <aws/sesv2/model/GetDedicatedIpRequest.h>
#include <aws/sesv2/model/GetDedicatedIpResult.h>
#include <aws/sesv2/model/GetDedicatedIpsRequest.h>
#include <aws/sesv2/model/GetDedicatedIpsResult.h>
#include <aws/sesv2/model/GetDeliverabilityDashboardOptionsRequest.h>
#include <aws/sesv2/model/GetDeliverabilityDashboardOptionsResult.h>
#include <aws/sesv2/model/GetDeliverabilityTestReportRequest.h>
#include <aws/sesv2/model/GetDeliverabilityTestReportResult.h>
#include <aws/sesv2/model/GetDomainDeliverabilityCampaignRequest.h>
#include <aws/sesv2/model/GetDomainDeliverabilityCampaignResult.h>
#include <aws/sesv2/model/GetDomainStatisticsReportRequest.h>
#include <aws/sesv2/model/GetDomainStatisticsReportResult.h>
#include <aws/sesv2/model/GetEmailIdentityPoliciesRequest.h>
#include <aws/sesv2/model/GetEmailIdentityPoliciesResult.h>
#include <aws/sesv2/model/GetEmailIdentityRequest.h>
#include <aws/sesv2/model/GetEmailIdentityResult.h>
#include <aws/sesv2/model/GetEmailTemplateRequest.h>
#include <aws/sesv2/model/GetEmailTemplateResult.h>
#include <aws/sesv2/model/GetExportJobRequest.h>
#include <aws/sesv2/model/GetExportJobResult.h>
#include <aws/sesv2/model/GetImportJobRequest.h>
#include <aws/sesv2/model/GetImportJobResult.h>
#include <aws/sesv2/model/GetMessageInsightsRequest.h>
#include <aws/sesv2/model/GetMessageInsightsResult.h>
#include <aws/sesv2/model/GetMultiRegionEndpointRequest.h>
#include <aws/sesv2/model/GetMultiRegionEndpointResult.h>
#include <aws/sesv2/model/GetSuppressedDestinationRequest.h>
#include <aws/sesv2/model/GetSuppressedDestinationResult.h>
#include <aws/sesv2/model/GuardianAttributes.h>
#include <aws/sesv2/model/GuardianOptions.h>
#include <aws/sesv2/model/HttpsPolicy.h>
#include <aws/sesv2/model/IdentityInfo.h>
#include <aws/sesv2/model/IdentityType.h>
#include <aws/sesv2/model/ImportDataSource.h>
#include <aws/sesv2/model/ImportDestination.h>
#include <aws/sesv2/model/ImportDestinationType.h>
#include <aws/sesv2/model/ImportJobSummary.h>
#include <aws/sesv2/model/InboxPlacementTrackingOption.h>
#include <aws/sesv2/model/InsightsEvent.h>
#include <aws/sesv2/model/IspPlacement.h>
#include <aws/sesv2/model/JobStatus.h>
#include <aws/sesv2/model/KinesisFirehoseDestination.h>
#include <aws/sesv2/model/ListConfigurationSetsRequest.h>
#include <aws/sesv2/model/ListConfigurationSetsResult.h>
#include <aws/sesv2/model/ListContactListsRequest.h>
#include <aws/sesv2/model/ListContactListsResult.h>
#include <aws/sesv2/model/ListContactsFilter.h>
#include <aws/sesv2/model/ListContactsRequest.h>
#include <aws/sesv2/model/ListContactsResult.h>
#include <aws/sesv2/model/ListCustomVerificationEmailTemplatesRequest.h>
#include <aws/sesv2/model/ListCustomVerificationEmailTemplatesResult.h>
#include <aws/sesv2/model/ListDedicatedIpPoolsRequest.h>
#include <aws/sesv2/model/ListDedicatedIpPoolsResult.h>
#include <aws/sesv2/model/ListDeliverabilityTestReportsRequest.h>
#include <aws/sesv2/model/ListDeliverabilityTestReportsResult.h>
#include <aws/sesv2/model/ListDomainDeliverabilityCampaignsRequest.h>
#include <aws/sesv2/model/ListDomainDeliverabilityCampaignsResult.h>
#include <aws/sesv2/model/ListEmailIdentitiesRequest.h>
#include <aws/sesv2/model/ListEmailIdentitiesResult.h>
#include <aws/sesv2/model/ListEmailTemplatesRequest.h>
#include <aws/sesv2/model/ListEmailTemplatesResult.h>
#include <aws/sesv2/model/ListExportJobsRequest.h>
#include <aws/sesv2/model/ListExportJobsResult.h>
#include <aws/sesv2/model/ListImportJobsRequest.h>
#include <aws/sesv2/model/ListImportJobsResult.h>
#include <aws/sesv2/model/ListManagementOptions.h>
#include <aws/sesv2/model/ListMultiRegionEndpointsRequest.h>
#include <aws/sesv2/model/ListMultiRegionEndpointsResult.h>
#include <aws/sesv2/model/ListRecommendationsFilterKey.h>
#include <aws/sesv2/model/ListRecommendationsRequest.h>
#include <aws/sesv2/model/ListRecommendationsResult.h>
#include <aws/sesv2/model/ListSuppressedDestinationsRequest.h>
#include <aws/sesv2/model/ListSuppressedDestinationsResult.h>
#include <aws/sesv2/model/ListTagsForResourceRequest.h>
#include <aws/sesv2/model/ListTagsForResourceResult.h>
#include <aws/sesv2/model/MailFromAttributes.h>
#include <aws/sesv2/model/MailFromDomainStatus.h>
#include <aws/sesv2/model/MailType.h>
#include <aws/sesv2/model/Message.h>
#include <aws/sesv2/model/MessageHeader.h>
#include <aws/sesv2/model/MessageInsightsDataSource.h>
#include <aws/sesv2/model/MessageInsightsFilters.h>
#include <aws/sesv2/model/MessageTag.h>
#include <aws/sesv2/model/Metric.h>
#include <aws/sesv2/model/MetricAggregation.h>
#include <aws/sesv2/model/MetricDataError.h>
#include <aws/sesv2/model/MetricDataResult.h>
#include <aws/sesv2/model/MetricDimensionName.h>
#include <aws/sesv2/model/MetricNamespace.h>
#include <aws/sesv2/model/MetricsDataSource.h>
#include <aws/sesv2/model/MultiRegionEndpoint.h>
#include <aws/sesv2/model/OverallVolume.h>
#include <aws/sesv2/model/PinpointDestination.h>
#include <aws/sesv2/model/PlacementStatistics.h>
#include <aws/sesv2/model/PutAccountDedicatedIpWarmupAttributesRequest.h>
#include <aws/sesv2/model/PutAccountDedicatedIpWarmupAttributesResult.h>
#include <aws/sesv2/model/PutAccountDetailsRequest.h>
#include <aws/sesv2/model/PutAccountDetailsResult.h>
#include <aws/sesv2/model/PutAccountSendingAttributesRequest.h>
#include <aws/sesv2/model/PutAccountSendingAttributesResult.h>
#include <aws/sesv2/model/PutAccountSuppressionAttributesRequest.h>
#include <aws/sesv2/model/PutAccountSuppressionAttributesResult.h>
#include <aws/sesv2/model/PutAccountVdmAttributesRequest.h>
#include <aws/sesv2/model/PutAccountVdmAttributesResult.h>
#include <aws/sesv2/model/PutConfigurationSetArchivingOptionsRequest.h>
#include <aws/sesv2/model/PutConfigurationSetArchivingOptionsResult.h>
#include <aws/sesv2/model/PutConfigurationSetDeliveryOptionsRequest.h>
#include <aws/sesv2/model/PutConfigurationSetDeliveryOptionsResult.h>
#include <aws/sesv2/model/PutConfigurationSetReputationOptionsRequest.h>
#include <aws/sesv2/model/PutConfigurationSetReputationOptionsResult.h>
#include <aws/sesv2/model/PutConfigurationSetSendingOptionsRequest.h>
#include <aws/sesv2/model/PutConfigurationSetSendingOptionsResult.h>
#include <aws/sesv2/model/PutConfigurationSetSuppressionOptionsRequest.h>
#include <aws/sesv2/model/PutConfigurationSetSuppressionOptionsResult.h>
#include <aws/sesv2/model/PutConfigurationSetTrackingOptionsRequest.h>
#include <aws/sesv2/model/PutConfigurationSetTrackingOptionsResult.h>
#include <aws/sesv2/model/PutConfigurationSetVdmOptionsRequest.h>
#include <aws/sesv2/model/PutConfigurationSetVdmOptionsResult.h>
#include <aws/sesv2/model/PutDedicatedIpInPoolRequest.h>
#include <aws/sesv2/model/PutDedicatedIpInPoolResult.h>
#include <aws/sesv2/model/PutDedicatedIpPoolScalingAttributesRequest.h>
#include <aws/sesv2/model/PutDedicatedIpPoolScalingAttributesResult.h>
#include <aws/sesv2/model/PutDedicatedIpWarmupAttributesRequest.h>
#include <aws/sesv2/model/PutDedicatedIpWarmupAttributesResult.h>
#include <aws/sesv2/model/PutDeliverabilityDashboardOptionRequest.h>
#include <aws/sesv2/model/PutDeliverabilityDashboardOptionResult.h>
#include <aws/sesv2/model/PutEmailIdentityConfigurationSetAttributesRequest.h>
#include <aws/sesv2/model/PutEmailIdentityConfigurationSetAttributesResult.h>
#include <aws/sesv2/model/PutEmailIdentityDkimAttributesRequest.h>
#include <aws/sesv2/model/PutEmailIdentityDkimAttributesResult.h>
#include <aws/sesv2/model/PutEmailIdentityDkimSigningAttributesRequest.h>
#include <aws/sesv2/model/PutEmailIdentityDkimSigningAttributesResult.h>
#include <aws/sesv2/model/PutEmailIdentityFeedbackAttributesRequest.h>
#include <aws/sesv2/model/PutEmailIdentityFeedbackAttributesResult.h>
#include <aws/sesv2/model/PutEmailIdentityMailFromAttributesRequest.h>
#include <aws/sesv2/model/PutEmailIdentityMailFromAttributesResult.h>
#include <aws/sesv2/model/PutSuppressedDestinationRequest.h>
#include <aws/sesv2/model/PutSuppressedDestinationResult.h>
#include <aws/sesv2/model/QueryErrorCode.h>
#include <aws/sesv2/model/RawMessage.h>
#include <aws/sesv2/model/Recommendation.h>
#include <aws/sesv2/model/RecommendationImpact.h>
#include <aws/sesv2/model/RecommendationStatus.h>
#include <aws/sesv2/model/RecommendationType.h>
#include <aws/sesv2/model/ReplacementEmailContent.h>
#include <aws/sesv2/model/ReplacementTemplate.h>
#include <aws/sesv2/model/ReputationOptions.h>
#include <aws/sesv2/model/ReviewDetails.h>
#include <aws/sesv2/model/ReviewStatus.h>
#include <aws/sesv2/model/Route.h>
#include <aws/sesv2/model/RouteDetails.h>
#include <aws/sesv2/model/SOARecord.h>
#include <aws/sesv2/model/ScalingMode.h>
#include <aws/sesv2/model/SendBulkEmailRequest.h>
#include <aws/sesv2/model/SendBulkEmailResult.h>
#include <aws/sesv2/model/SendCustomVerificationEmailRequest.h>
#include <aws/sesv2/model/SendCustomVerificationEmailResult.h>
#include <aws/sesv2/model/SendEmailRequest.h>
#include <aws/sesv2/model/SendEmailResult.h>
#include <aws/sesv2/model/SendQuota.h>
#include <aws/sesv2/model/SendingOptions.h>
#include <aws/sesv2/model/SnsDestination.h>
#include <aws/sesv2/model/Status.h>
#include <aws/sesv2/model/SubscriptionStatus.h>
#include <aws/sesv2/model/SuppressedDestination.h>
#include <aws/sesv2/model/SuppressedDestinationAttributes.h>
#include <aws/sesv2/model/SuppressedDestinationSummary.h>
#include <aws/sesv2/model/SuppressionAttributes.h>
#include <aws/sesv2/model/SuppressionListDestination.h>
#include <aws/sesv2/model/SuppressionListImportAction.h>
#include <aws/sesv2/model/SuppressionListReason.h>
#include <aws/sesv2/model/SuppressionOptions.h>
#include <aws/sesv2/model/Tag.h>
#include <aws/sesv2/model/TagResourceRequest.h>
#include <aws/sesv2/model/TagResourceResult.h>
#include <aws/sesv2/model/Template.h>
#include <aws/sesv2/model/TestRenderEmailTemplateRequest.h>
#include <aws/sesv2/model/TestRenderEmailTemplateResult.h>
#include <aws/sesv2/model/TlsPolicy.h>
#include <aws/sesv2/model/Topic.h>
#include <aws/sesv2/model/TopicFilter.h>
#include <aws/sesv2/model/TopicPreference.h>
#include <aws/sesv2/model/TrackingOptions.h>
#include <aws/sesv2/model/UntagResourceRequest.h>
#include <aws/sesv2/model/UntagResourceResult.h>
#include <aws/sesv2/model/UpdateConfigurationSetEventDestinationRequest.h>
#include <aws/sesv2/model/UpdateConfigurationSetEventDestinationResult.h>
#include <aws/sesv2/model/UpdateContactListRequest.h>
#include <aws/sesv2/model/UpdateContactListResult.h>
#include <aws/sesv2/model/UpdateContactRequest.h>
#include <aws/sesv2/model/UpdateContactResult.h>
#include <aws/sesv2/model/UpdateCustomVerificationEmailTemplateRequest.h>
#include <aws/sesv2/model/UpdateCustomVerificationEmailTemplateResult.h>
#include <aws/sesv2/model/UpdateEmailIdentityPolicyRequest.h>
#include <aws/sesv2/model/UpdateEmailIdentityPolicyResult.h>
#include <aws/sesv2/model/UpdateEmailTemplateRequest.h>
#include <aws/sesv2/model/UpdateEmailTemplateResult.h>
#include <aws/sesv2/model/VdmAttributes.h>
#include <aws/sesv2/model/VdmOptions.h>
#include <aws/sesv2/model/VerificationError.h>
#include <aws/sesv2/model/VerificationInfo.h>
#include <aws/sesv2/model/VerificationStatus.h>
#include <aws/sesv2/model/VolumeStatistics.h>
#include <aws/sesv2/model/WarmupStatus.h>

using SESV2IncludeTest = ::testing::Test;

TEST_F(SESV2IncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::SESV2::SESV2Client>("SESV2IncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
