/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/ssm/SSMClient.h>
#include <aws/ssm/SSMEndpointProvider.h>
#include <aws/ssm/SSMEndpointRules.h>
#include <aws/ssm/SSMErrorMarshaller.h>
#include <aws/ssm/SSMErrors.h>
#include <aws/ssm/SSMRequest.h>
#include <aws/ssm/SSMServiceClientModel.h>
#include <aws/ssm/SSM_EXPORTS.h>
#include <aws/ssm/model/AccessRequestStatus.h>
#include <aws/ssm/model/AccountSharingInfo.h>
#include <aws/ssm/model/Activation.h>
#include <aws/ssm/model/AddTagsToResourceRequest.h>
#include <aws/ssm/model/AddTagsToResourceResult.h>
#include <aws/ssm/model/Alarm.h>
#include <aws/ssm/model/AlarmConfiguration.h>
#include <aws/ssm/model/AlarmStateInformation.h>
#include <aws/ssm/model/AssociateOpsItemRelatedItemRequest.h>
#include <aws/ssm/model/AssociateOpsItemRelatedItemResult.h>
#include <aws/ssm/model/Association.h>
#include <aws/ssm/model/AssociationComplianceSeverity.h>
#include <aws/ssm/model/AssociationDescription.h>
#include <aws/ssm/model/AssociationExecution.h>
#include <aws/ssm/model/AssociationExecutionFilter.h>
#include <aws/ssm/model/AssociationExecutionFilterKey.h>
#include <aws/ssm/model/AssociationExecutionTarget.h>
#include <aws/ssm/model/AssociationExecutionTargetsFilter.h>
#include <aws/ssm/model/AssociationExecutionTargetsFilterKey.h>
#include <aws/ssm/model/AssociationFilter.h>
#include <aws/ssm/model/AssociationFilterKey.h>
#include <aws/ssm/model/AssociationFilterOperatorType.h>
#include <aws/ssm/model/AssociationOverview.h>
#include <aws/ssm/model/AssociationStatus.h>
#include <aws/ssm/model/AssociationStatusName.h>
#include <aws/ssm/model/AssociationSyncCompliance.h>
#include <aws/ssm/model/AssociationVersionInfo.h>
#include <aws/ssm/model/AttachmentContent.h>
#include <aws/ssm/model/AttachmentHashType.h>
#include <aws/ssm/model/AttachmentInformation.h>
#include <aws/ssm/model/AttachmentsSource.h>
#include <aws/ssm/model/AttachmentsSourceKey.h>
#include <aws/ssm/model/AutomationExecution.h>
#include <aws/ssm/model/AutomationExecutionFilter.h>
#include <aws/ssm/model/AutomationExecutionFilterKey.h>
#include <aws/ssm/model/AutomationExecutionInputs.h>
#include <aws/ssm/model/AutomationExecutionMetadata.h>
#include <aws/ssm/model/AutomationExecutionPreview.h>
#include <aws/ssm/model/AutomationExecutionStatus.h>
#include <aws/ssm/model/AutomationSubtype.h>
#include <aws/ssm/model/AutomationType.h>
#include <aws/ssm/model/BaselineOverride.h>
#include <aws/ssm/model/CalendarState.h>
#include <aws/ssm/model/CancelCommandRequest.h>
#include <aws/ssm/model/CancelCommandResult.h>
#include <aws/ssm/model/CancelMaintenanceWindowExecutionRequest.h>
#include <aws/ssm/model/CancelMaintenanceWindowExecutionResult.h>
#include <aws/ssm/model/CloudWatchOutputConfig.h>
#include <aws/ssm/model/Command.h>
#include <aws/ssm/model/CommandFilter.h>
#include <aws/ssm/model/CommandFilterKey.h>
#include <aws/ssm/model/CommandInvocation.h>
#include <aws/ssm/model/CommandInvocationStatus.h>
#include <aws/ssm/model/CommandPlugin.h>
#include <aws/ssm/model/CommandPluginStatus.h>
#include <aws/ssm/model/CommandStatus.h>
#include <aws/ssm/model/ComplianceExecutionSummary.h>
#include <aws/ssm/model/ComplianceItem.h>
#include <aws/ssm/model/ComplianceItemEntry.h>
#include <aws/ssm/model/ComplianceQueryOperatorType.h>
#include <aws/ssm/model/ComplianceSeverity.h>
#include <aws/ssm/model/ComplianceStatus.h>
#include <aws/ssm/model/ComplianceStringFilter.h>
#include <aws/ssm/model/ComplianceSummaryItem.h>
#include <aws/ssm/model/ComplianceUploadType.h>
#include <aws/ssm/model/CompliantSummary.h>
#include <aws/ssm/model/ConnectionStatus.h>
#include <aws/ssm/model/CreateActivationRequest.h>
#include <aws/ssm/model/CreateActivationResult.h>
#include <aws/ssm/model/CreateAssociationBatchRequest.h>
#include <aws/ssm/model/CreateAssociationBatchRequestEntry.h>
#include <aws/ssm/model/CreateAssociationBatchResult.h>
#include <aws/ssm/model/CreateAssociationRequest.h>
#include <aws/ssm/model/CreateAssociationResult.h>
#include <aws/ssm/model/CreateDocumentRequest.h>
#include <aws/ssm/model/CreateDocumentResult.h>
#include <aws/ssm/model/CreateMaintenanceWindowRequest.h>
#include <aws/ssm/model/CreateMaintenanceWindowResult.h>
#include <aws/ssm/model/CreateOpsItemRequest.h>
#include <aws/ssm/model/CreateOpsItemResult.h>
#include <aws/ssm/model/CreateOpsMetadataRequest.h>
#include <aws/ssm/model/CreateOpsMetadataResult.h>
#include <aws/ssm/model/CreatePatchBaselineRequest.h>
#include <aws/ssm/model/CreatePatchBaselineResult.h>
#include <aws/ssm/model/CreateResourceDataSyncRequest.h>
#include <aws/ssm/model/CreateResourceDataSyncResult.h>
#include <aws/ssm/model/Credentials.h>
#include <aws/ssm/model/DeleteActivationRequest.h>
#include <aws/ssm/model/DeleteActivationResult.h>
#include <aws/ssm/model/DeleteAssociationRequest.h>
#include <aws/ssm/model/DeleteAssociationResult.h>
#include <aws/ssm/model/DeleteDocumentRequest.h>
#include <aws/ssm/model/DeleteDocumentResult.h>
#include <aws/ssm/model/DeleteInventoryRequest.h>
#include <aws/ssm/model/DeleteInventoryResult.h>
#include <aws/ssm/model/DeleteMaintenanceWindowRequest.h>
#include <aws/ssm/model/DeleteMaintenanceWindowResult.h>
#include <aws/ssm/model/DeleteOpsItemRequest.h>
#include <aws/ssm/model/DeleteOpsItemResult.h>
#include <aws/ssm/model/DeleteOpsMetadataRequest.h>
#include <aws/ssm/model/DeleteOpsMetadataResult.h>
#include <aws/ssm/model/DeleteParameterRequest.h>
#include <aws/ssm/model/DeleteParameterResult.h>
#include <aws/ssm/model/DeleteParametersRequest.h>
#include <aws/ssm/model/DeleteParametersResult.h>
#include <aws/ssm/model/DeletePatchBaselineRequest.h>
#include <aws/ssm/model/DeletePatchBaselineResult.h>
#include <aws/ssm/model/DeleteResourceDataSyncRequest.h>
#include <aws/ssm/model/DeleteResourceDataSyncResult.h>
#include <aws/ssm/model/DeleteResourcePolicyRequest.h>
#include <aws/ssm/model/DeleteResourcePolicyResult.h>
#include <aws/ssm/model/DeregisterManagedInstanceRequest.h>
#include <aws/ssm/model/DeregisterManagedInstanceResult.h>
#include <aws/ssm/model/DeregisterPatchBaselineForPatchGroupRequest.h>
#include <aws/ssm/model/DeregisterPatchBaselineForPatchGroupResult.h>
#include <aws/ssm/model/DeregisterTargetFromMaintenanceWindowRequest.h>
#include <aws/ssm/model/DeregisterTargetFromMaintenanceWindowResult.h>
#include <aws/ssm/model/DeregisterTaskFromMaintenanceWindowRequest.h>
#include <aws/ssm/model/DeregisterTaskFromMaintenanceWindowResult.h>
#include <aws/ssm/model/DescribeActivationsFilter.h>
#include <aws/ssm/model/DescribeActivationsFilterKeys.h>
#include <aws/ssm/model/DescribeActivationsRequest.h>
#include <aws/ssm/model/DescribeActivationsResult.h>
#include <aws/ssm/model/DescribeAssociationExecutionTargetsRequest.h>
#include <aws/ssm/model/DescribeAssociationExecutionTargetsResult.h>
#include <aws/ssm/model/DescribeAssociationExecutionsRequest.h>
#include <aws/ssm/model/DescribeAssociationExecutionsResult.h>
#include <aws/ssm/model/DescribeAssociationRequest.h>
#include <aws/ssm/model/DescribeAssociationResult.h>
#include <aws/ssm/model/DescribeAutomationExecutionsRequest.h>
#include <aws/ssm/model/DescribeAutomationExecutionsResult.h>
#include <aws/ssm/model/DescribeAutomationStepExecutionsRequest.h>
#include <aws/ssm/model/DescribeAutomationStepExecutionsResult.h>
#include <aws/ssm/model/DescribeAvailablePatchesRequest.h>
#include <aws/ssm/model/DescribeAvailablePatchesResult.h>
#include <aws/ssm/model/DescribeDocumentPermissionRequest.h>
#include <aws/ssm/model/DescribeDocumentPermissionResult.h>
#include <aws/ssm/model/DescribeDocumentRequest.h>
#include <aws/ssm/model/DescribeDocumentResult.h>
#include <aws/ssm/model/DescribeEffectiveInstanceAssociationsRequest.h>
#include <aws/ssm/model/DescribeEffectiveInstanceAssociationsResult.h>
#include <aws/ssm/model/DescribeEffectivePatchesForPatchBaselineRequest.h>
#include <aws/ssm/model/DescribeEffectivePatchesForPatchBaselineResult.h>
#include <aws/ssm/model/DescribeInstanceAssociationsStatusRequest.h>
#include <aws/ssm/model/DescribeInstanceAssociationsStatusResult.h>
#include <aws/ssm/model/DescribeInstanceInformationRequest.h>
#include <aws/ssm/model/DescribeInstanceInformationResult.h>
#include <aws/ssm/model/DescribeInstancePatchStatesForPatchGroupRequest.h>
#include <aws/ssm/model/DescribeInstancePatchStatesForPatchGroupResult.h>
#include <aws/ssm/model/DescribeInstancePatchStatesRequest.h>
#include <aws/ssm/model/DescribeInstancePatchStatesResult.h>
#include <aws/ssm/model/DescribeInstancePatchesRequest.h>
#include <aws/ssm/model/DescribeInstancePatchesResult.h>
#include <aws/ssm/model/DescribeInstancePropertiesRequest.h>
#include <aws/ssm/model/DescribeInstancePropertiesResult.h>
#include <aws/ssm/model/DescribeInventoryDeletionsRequest.h>
#include <aws/ssm/model/DescribeInventoryDeletionsResult.h>
#include <aws/ssm/model/DescribeMaintenanceWindowExecutionTaskInvocationsRequest.h>
#include <aws/ssm/model/DescribeMaintenanceWindowExecutionTaskInvocationsResult.h>
#include <aws/ssm/model/DescribeMaintenanceWindowExecutionTasksRequest.h>
#include <aws/ssm/model/DescribeMaintenanceWindowExecutionTasksResult.h>
#include <aws/ssm/model/DescribeMaintenanceWindowExecutionsRequest.h>
#include <aws/ssm/model/DescribeMaintenanceWindowExecutionsResult.h>
#include <aws/ssm/model/DescribeMaintenanceWindowScheduleRequest.h>
#include <aws/ssm/model/DescribeMaintenanceWindowScheduleResult.h>
#include <aws/ssm/model/DescribeMaintenanceWindowTargetsRequest.h>
#include <aws/ssm/model/DescribeMaintenanceWindowTargetsResult.h>
#include <aws/ssm/model/DescribeMaintenanceWindowTasksRequest.h>
#include <aws/ssm/model/DescribeMaintenanceWindowTasksResult.h>
#include <aws/ssm/model/DescribeMaintenanceWindowsForTargetRequest.h>
#include <aws/ssm/model/DescribeMaintenanceWindowsForTargetResult.h>
#include <aws/ssm/model/DescribeMaintenanceWindowsRequest.h>
#include <aws/ssm/model/DescribeMaintenanceWindowsResult.h>
#include <aws/ssm/model/DescribeOpsItemsRequest.h>
#include <aws/ssm/model/DescribeOpsItemsResult.h>
#include <aws/ssm/model/DescribeParametersRequest.h>
#include <aws/ssm/model/DescribeParametersResult.h>
#include <aws/ssm/model/DescribePatchBaselinesRequest.h>
#include <aws/ssm/model/DescribePatchBaselinesResult.h>
#include <aws/ssm/model/DescribePatchGroupStateRequest.h>
#include <aws/ssm/model/DescribePatchGroupStateResult.h>
#include <aws/ssm/model/DescribePatchGroupsRequest.h>
#include <aws/ssm/model/DescribePatchGroupsResult.h>
#include <aws/ssm/model/DescribePatchPropertiesRequest.h>
#include <aws/ssm/model/DescribePatchPropertiesResult.h>
#include <aws/ssm/model/DescribeSessionsRequest.h>
#include <aws/ssm/model/DescribeSessionsResult.h>
#include <aws/ssm/model/DisassociateOpsItemRelatedItemRequest.h>
#include <aws/ssm/model/DisassociateOpsItemRelatedItemResult.h>
#include <aws/ssm/model/DocumentDefaultVersionDescription.h>
#include <aws/ssm/model/DocumentDescription.h>
#include <aws/ssm/model/DocumentFilter.h>
#include <aws/ssm/model/DocumentFilterKey.h>
#include <aws/ssm/model/DocumentFormat.h>
#include <aws/ssm/model/DocumentHashType.h>
#include <aws/ssm/model/DocumentIdentifier.h>
#include <aws/ssm/model/DocumentKeyValuesFilter.h>
#include <aws/ssm/model/DocumentMetadataEnum.h>
#include <aws/ssm/model/DocumentMetadataResponseInfo.h>
#include <aws/ssm/model/DocumentParameter.h>
#include <aws/ssm/model/DocumentParameterType.h>
#include <aws/ssm/model/DocumentPermissionType.h>
#include <aws/ssm/model/DocumentRequires.h>
#include <aws/ssm/model/DocumentReviewAction.h>
#include <aws/ssm/model/DocumentReviewCommentSource.h>
#include <aws/ssm/model/DocumentReviewCommentType.h>
#include <aws/ssm/model/DocumentReviewerResponseSource.h>
#include <aws/ssm/model/DocumentReviews.h>
#include <aws/ssm/model/DocumentStatus.h>
#include <aws/ssm/model/DocumentType.h>
#include <aws/ssm/model/DocumentVersionInfo.h>
#include <aws/ssm/model/EffectivePatch.h>
#include <aws/ssm/model/ExecutionInputs.h>
#include <aws/ssm/model/ExecutionMode.h>
#include <aws/ssm/model/ExecutionPreview.h>
#include <aws/ssm/model/ExecutionPreviewStatus.h>
#include <aws/ssm/model/ExternalAlarmState.h>
#include <aws/ssm/model/FailedCreateAssociation.h>
#include <aws/ssm/model/FailureDetails.h>
#include <aws/ssm/model/Fault.h>
#include <aws/ssm/model/GetAccessTokenRequest.h>
#include <aws/ssm/model/GetAccessTokenResult.h>
#include <aws/ssm/model/GetAutomationExecutionRequest.h>
#include <aws/ssm/model/GetAutomationExecutionResult.h>
#include <aws/ssm/model/GetCalendarStateRequest.h>
#include <aws/ssm/model/GetCalendarStateResult.h>
#include <aws/ssm/model/GetCommandInvocationRequest.h>
#include <aws/ssm/model/GetCommandInvocationResult.h>
#include <aws/ssm/model/GetConnectionStatusRequest.h>
#include <aws/ssm/model/GetConnectionStatusResult.h>
#include <aws/ssm/model/GetDefaultPatchBaselineRequest.h>
#include <aws/ssm/model/GetDefaultPatchBaselineResult.h>
#include <aws/ssm/model/GetDeployablePatchSnapshotForInstanceRequest.h>
#include <aws/ssm/model/GetDeployablePatchSnapshotForInstanceResult.h>
#include <aws/ssm/model/GetDocumentRequest.h>
#include <aws/ssm/model/GetDocumentResult.h>
#include <aws/ssm/model/GetExecutionPreviewRequest.h>
#include <aws/ssm/model/GetExecutionPreviewResult.h>
#include <aws/ssm/model/GetInventoryRequest.h>
#include <aws/ssm/model/GetInventoryResult.h>
#include <aws/ssm/model/GetInventorySchemaRequest.h>
#include <aws/ssm/model/GetInventorySchemaResult.h>
#include <aws/ssm/model/GetMaintenanceWindowExecutionRequest.h>
#include <aws/ssm/model/GetMaintenanceWindowExecutionResult.h>
#include <aws/ssm/model/GetMaintenanceWindowExecutionTaskInvocationRequest.h>
#include <aws/ssm/model/GetMaintenanceWindowExecutionTaskInvocationResult.h>
#include <aws/ssm/model/GetMaintenanceWindowExecutionTaskRequest.h>
#include <aws/ssm/model/GetMaintenanceWindowExecutionTaskResult.h>
#include <aws/ssm/model/GetMaintenanceWindowRequest.h>
#include <aws/ssm/model/GetMaintenanceWindowResult.h>
#include <aws/ssm/model/GetMaintenanceWindowTaskRequest.h>
#include <aws/ssm/model/GetMaintenanceWindowTaskResult.h>
#include <aws/ssm/model/GetOpsItemRequest.h>
#include <aws/ssm/model/GetOpsItemResult.h>
#include <aws/ssm/model/GetOpsMetadataRequest.h>
#include <aws/ssm/model/GetOpsMetadataResult.h>
#include <aws/ssm/model/GetOpsSummaryRequest.h>
#include <aws/ssm/model/GetOpsSummaryResult.h>
#include <aws/ssm/model/GetParameterHistoryRequest.h>
#include <aws/ssm/model/GetParameterHistoryResult.h>
#include <aws/ssm/model/GetParameterRequest.h>
#include <aws/ssm/model/GetParameterResult.h>
#include <aws/ssm/model/GetParametersByPathRequest.h>
#include <aws/ssm/model/GetParametersByPathResult.h>
#include <aws/ssm/model/GetParametersRequest.h>
#include <aws/ssm/model/GetParametersResult.h>
#include <aws/ssm/model/GetPatchBaselineForPatchGroupRequest.h>
#include <aws/ssm/model/GetPatchBaselineForPatchGroupResult.h>
#include <aws/ssm/model/GetPatchBaselineRequest.h>
#include <aws/ssm/model/GetPatchBaselineResult.h>
#include <aws/ssm/model/GetResourcePoliciesRequest.h>
#include <aws/ssm/model/GetResourcePoliciesResponseEntry.h>
#include <aws/ssm/model/GetResourcePoliciesResult.h>
#include <aws/ssm/model/GetServiceSettingRequest.h>
#include <aws/ssm/model/GetServiceSettingResult.h>
#include <aws/ssm/model/ImpactType.h>
#include <aws/ssm/model/InstanceAggregatedAssociationOverview.h>
#include <aws/ssm/model/InstanceAssociation.h>
#include <aws/ssm/model/InstanceAssociationOutputLocation.h>
#include <aws/ssm/model/InstanceAssociationOutputUrl.h>
#include <aws/ssm/model/InstanceAssociationStatusInfo.h>
#include <aws/ssm/model/InstanceInfo.h>
#include <aws/ssm/model/InstanceInformation.h>
#include <aws/ssm/model/InstanceInformationFilter.h>
#include <aws/ssm/model/InstanceInformationFilterKey.h>
#include <aws/ssm/model/InstanceInformationStringFilter.h>
#include <aws/ssm/model/InstancePatchState.h>
#include <aws/ssm/model/InstancePatchStateFilter.h>
#include <aws/ssm/model/InstancePatchStateOperatorType.h>
#include <aws/ssm/model/InstanceProperty.h>
#include <aws/ssm/model/InstancePropertyFilter.h>
#include <aws/ssm/model/InstancePropertyFilterKey.h>
#include <aws/ssm/model/InstancePropertyFilterOperator.h>
#include <aws/ssm/model/InstancePropertyStringFilter.h>
#include <aws/ssm/model/InvalidItemContentException.h>
#include <aws/ssm/model/InventoryAggregator.h>
#include <aws/ssm/model/InventoryAttributeDataType.h>
#include <aws/ssm/model/InventoryDeletionStatus.h>
#include <aws/ssm/model/InventoryDeletionStatusItem.h>
#include <aws/ssm/model/InventoryDeletionSummary.h>
#include <aws/ssm/model/InventoryDeletionSummaryItem.h>
#include <aws/ssm/model/InventoryFilter.h>
#include <aws/ssm/model/InventoryGroup.h>
#include <aws/ssm/model/InventoryItem.h>
#include <aws/ssm/model/InventoryItemAttribute.h>
#include <aws/ssm/model/InventoryItemSchema.h>
#include <aws/ssm/model/InventoryQueryOperatorType.h>
#include <aws/ssm/model/InventoryResultEntity.h>
#include <aws/ssm/model/InventoryResultItem.h>
#include <aws/ssm/model/InventorySchemaDeleteOption.h>
#include <aws/ssm/model/ItemContentMismatchException.h>
#include <aws/ssm/model/ItemSizeLimitExceededException.h>
#include <aws/ssm/model/LabelParameterVersionRequest.h>
#include <aws/ssm/model/LabelParameterVersionResult.h>
#include <aws/ssm/model/LastResourceDataSyncStatus.h>
#include <aws/ssm/model/ListAssociationVersionsRequest.h>
#include <aws/ssm/model/ListAssociationVersionsResult.h>
#include <aws/ssm/model/ListAssociationsRequest.h>
#include <aws/ssm/model/ListAssociationsResult.h>
#include <aws/ssm/model/ListCommandInvocationsRequest.h>
#include <aws/ssm/model/ListCommandInvocationsResult.h>
#include <aws/ssm/model/ListCommandsRequest.h>
#include <aws/ssm/model/ListCommandsResult.h>
#include <aws/ssm/model/ListComplianceItemsRequest.h>
#include <aws/ssm/model/ListComplianceItemsResult.h>
#include <aws/ssm/model/ListComplianceSummariesRequest.h>
#include <aws/ssm/model/ListComplianceSummariesResult.h>
#include <aws/ssm/model/ListDocumentMetadataHistoryRequest.h>
#include <aws/ssm/model/ListDocumentMetadataHistoryResult.h>
#include <aws/ssm/model/ListDocumentVersionsRequest.h>
#include <aws/ssm/model/ListDocumentVersionsResult.h>
#include <aws/ssm/model/ListDocumentsRequest.h>
#include <aws/ssm/model/ListDocumentsResult.h>
#include <aws/ssm/model/ListInventoryEntriesRequest.h>
#include <aws/ssm/model/ListInventoryEntriesResult.h>
#include <aws/ssm/model/ListNodesRequest.h>
#include <aws/ssm/model/ListNodesResult.h>
#include <aws/ssm/model/ListNodesSummaryRequest.h>
#include <aws/ssm/model/ListNodesSummaryResult.h>
#include <aws/ssm/model/ListOpsItemEventsRequest.h>
#include <aws/ssm/model/ListOpsItemEventsResult.h>
#include <aws/ssm/model/ListOpsItemRelatedItemsRequest.h>
#include <aws/ssm/model/ListOpsItemRelatedItemsResult.h>
#include <aws/ssm/model/ListOpsMetadataRequest.h>
#include <aws/ssm/model/ListOpsMetadataResult.h>
#include <aws/ssm/model/ListResourceComplianceSummariesRequest.h>
#include <aws/ssm/model/ListResourceComplianceSummariesResult.h>
#include <aws/ssm/model/ListResourceDataSyncRequest.h>
#include <aws/ssm/model/ListResourceDataSyncResult.h>
#include <aws/ssm/model/ListTagsForResourceRequest.h>
#include <aws/ssm/model/ListTagsForResourceResult.h>
#include <aws/ssm/model/LoggingInfo.h>
#include <aws/ssm/model/MaintenanceWindowAutomationParameters.h>
#include <aws/ssm/model/MaintenanceWindowExecution.h>
#include <aws/ssm/model/MaintenanceWindowExecutionStatus.h>
#include <aws/ssm/model/MaintenanceWindowExecutionTaskIdentity.h>
#include <aws/ssm/model/MaintenanceWindowExecutionTaskInvocationIdentity.h>
#include <aws/ssm/model/MaintenanceWindowFilter.h>
#include <aws/ssm/model/MaintenanceWindowIdentity.h>
#include <aws/ssm/model/MaintenanceWindowIdentityForTarget.h>
#include <aws/ssm/model/MaintenanceWindowLambdaParameters.h>
#include <aws/ssm/model/MaintenanceWindowResourceType.h>
#include <aws/ssm/model/MaintenanceWindowRunCommandParameters.h>
#include <aws/ssm/model/MaintenanceWindowStepFunctionsParameters.h>
#include <aws/ssm/model/MaintenanceWindowTarget.h>
#include <aws/ssm/model/MaintenanceWindowTask.h>
#include <aws/ssm/model/MaintenanceWindowTaskCutoffBehavior.h>
#include <aws/ssm/model/MaintenanceWindowTaskInvocationParameters.h>
#include <aws/ssm/model/MaintenanceWindowTaskParameterValueExpression.h>
#include <aws/ssm/model/MaintenanceWindowTaskType.h>
#include <aws/ssm/model/ManagedStatus.h>
#include <aws/ssm/model/MetadataValue.h>
#include <aws/ssm/model/ModifyDocumentPermissionRequest.h>
#include <aws/ssm/model/ModifyDocumentPermissionResult.h>
#include <aws/ssm/model/Node.h>
#include <aws/ssm/model/NodeAggregator.h>
#include <aws/ssm/model/NodeAggregatorType.h>
#include <aws/ssm/model/NodeAttributeName.h>
#include <aws/ssm/model/NodeFilter.h>
#include <aws/ssm/model/NodeFilterKey.h>
#include <aws/ssm/model/NodeFilterOperatorType.h>
#include <aws/ssm/model/NodeOwnerInfo.h>
#include <aws/ssm/model/NodeType.h>
#include <aws/ssm/model/NodeTypeName.h>
#include <aws/ssm/model/NonCompliantSummary.h>
#include <aws/ssm/model/NotificationConfig.h>
#include <aws/ssm/model/NotificationEvent.h>
#include <aws/ssm/model/NotificationType.h>
#include <aws/ssm/model/OperatingSystem.h>
#include <aws/ssm/model/OpsAggregator.h>
#include <aws/ssm/model/OpsEntity.h>
#include <aws/ssm/model/OpsEntityItem.h>
#include <aws/ssm/model/OpsFilter.h>
#include <aws/ssm/model/OpsFilterOperatorType.h>
#include <aws/ssm/model/OpsItem.h>
#include <aws/ssm/model/OpsItemAlreadyExistsException.h>
#include <aws/ssm/model/OpsItemDataType.h>
#include <aws/ssm/model/OpsItemDataValue.h>
#include <aws/ssm/model/OpsItemEventFilter.h>
#include <aws/ssm/model/OpsItemEventFilterKey.h>
#include <aws/ssm/model/OpsItemEventFilterOperator.h>
#include <aws/ssm/model/OpsItemEventSummary.h>
#include <aws/ssm/model/OpsItemFilter.h>
#include <aws/ssm/model/OpsItemFilterKey.h>
#include <aws/ssm/model/OpsItemFilterOperator.h>
#include <aws/ssm/model/OpsItemIdentity.h>
#include <aws/ssm/model/OpsItemInvalidParameterException.h>
#include <aws/ssm/model/OpsItemLimitExceededException.h>
#include <aws/ssm/model/OpsItemNotification.h>
#include <aws/ssm/model/OpsItemRelatedItemAlreadyExistsException.h>
#include <aws/ssm/model/OpsItemRelatedItemSummary.h>
#include <aws/ssm/model/OpsItemRelatedItemsFilter.h>
#include <aws/ssm/model/OpsItemRelatedItemsFilterKey.h>
#include <aws/ssm/model/OpsItemRelatedItemsFilterOperator.h>
#include <aws/ssm/model/OpsItemStatus.h>
#include <aws/ssm/model/OpsItemSummary.h>
#include <aws/ssm/model/OpsMetadata.h>
#include <aws/ssm/model/OpsMetadataFilter.h>
#include <aws/ssm/model/OpsResultAttribute.h>
#include <aws/ssm/model/OutputSource.h>
#include <aws/ssm/model/Parameter.h>
#include <aws/ssm/model/ParameterHistory.h>
#include <aws/ssm/model/ParameterInlinePolicy.h>
#include <aws/ssm/model/ParameterMetadata.h>
#include <aws/ssm/model/ParameterStringFilter.h>
#include <aws/ssm/model/ParameterTier.h>
#include <aws/ssm/model/ParameterType.h>
#include <aws/ssm/model/ParametersFilter.h>
#include <aws/ssm/model/ParametersFilterKey.h>
#include <aws/ssm/model/ParentStepDetails.h>
#include <aws/ssm/model/Patch.h>
#include <aws/ssm/model/PatchAction.h>
#include <aws/ssm/model/PatchBaselineIdentity.h>
#include <aws/ssm/model/PatchComplianceData.h>
#include <aws/ssm/model/PatchComplianceDataState.h>
#include <aws/ssm/model/PatchComplianceLevel.h>
#include <aws/ssm/model/PatchComplianceStatus.h>
#include <aws/ssm/model/PatchDeploymentStatus.h>
#include <aws/ssm/model/PatchFilter.h>
#include <aws/ssm/model/PatchFilterGroup.h>
#include <aws/ssm/model/PatchFilterKey.h>
#include <aws/ssm/model/PatchGroupPatchBaselineMapping.h>
#include <aws/ssm/model/PatchOperationType.h>
#include <aws/ssm/model/PatchOrchestratorFilter.h>
#include <aws/ssm/model/PatchProperty.h>
#include <aws/ssm/model/PatchRule.h>
#include <aws/ssm/model/PatchRuleGroup.h>
#include <aws/ssm/model/PatchSet.h>
#include <aws/ssm/model/PatchSource.h>
#include <aws/ssm/model/PatchStatus.h>
#include <aws/ssm/model/PingStatus.h>
#include <aws/ssm/model/PlatformType.h>
#include <aws/ssm/model/ProgressCounters.h>
#include <aws/ssm/model/PutComplianceItemsRequest.h>
#include <aws/ssm/model/PutComplianceItemsResult.h>
#include <aws/ssm/model/PutInventoryRequest.h>
#include <aws/ssm/model/PutInventoryResult.h>
#include <aws/ssm/model/PutParameterRequest.h>
#include <aws/ssm/model/PutParameterResult.h>
#include <aws/ssm/model/PutResourcePolicyRequest.h>
#include <aws/ssm/model/PutResourcePolicyResult.h>
#include <aws/ssm/model/RebootOption.h>
#include <aws/ssm/model/RegisterDefaultPatchBaselineRequest.h>
#include <aws/ssm/model/RegisterDefaultPatchBaselineResult.h>
#include <aws/ssm/model/RegisterPatchBaselineForPatchGroupRequest.h>
#include <aws/ssm/model/RegisterPatchBaselineForPatchGroupResult.h>
#include <aws/ssm/model/RegisterTargetWithMaintenanceWindowRequest.h>
#include <aws/ssm/model/RegisterTargetWithMaintenanceWindowResult.h>
#include <aws/ssm/model/RegisterTaskWithMaintenanceWindowRequest.h>
#include <aws/ssm/model/RegisterTaskWithMaintenanceWindowResult.h>
#include <aws/ssm/model/RegistrationMetadataItem.h>
#include <aws/ssm/model/RelatedOpsItem.h>
#include <aws/ssm/model/RemoveTagsFromResourceRequest.h>
#include <aws/ssm/model/RemoveTagsFromResourceResult.h>
#include <aws/ssm/model/ResetServiceSettingRequest.h>
#include <aws/ssm/model/ResetServiceSettingResult.h>
#include <aws/ssm/model/ResolvedTargets.h>
#include <aws/ssm/model/ResourceComplianceSummaryItem.h>
#include <aws/ssm/model/ResourceDataSyncAlreadyExistsException.h>
#include <aws/ssm/model/ResourceDataSyncAwsOrganizationsSource.h>
#include <aws/ssm/model/ResourceDataSyncDestinationDataSharing.h>
#include <aws/ssm/model/ResourceDataSyncItem.h>
#include <aws/ssm/model/ResourceDataSyncNotFoundException.h>
#include <aws/ssm/model/ResourceDataSyncOrganizationalUnit.h>
#include <aws/ssm/model/ResourceDataSyncS3Destination.h>
#include <aws/ssm/model/ResourceDataSyncS3Format.h>
#include <aws/ssm/model/ResourceDataSyncSource.h>
#include <aws/ssm/model/ResourceDataSyncSourceWithState.h>
#include <aws/ssm/model/ResourcePolicyInvalidParameterException.h>
#include <aws/ssm/model/ResourcePolicyLimitExceededException.h>
#include <aws/ssm/model/ResourceType.h>
#include <aws/ssm/model/ResourceTypeForTagging.h>
#include <aws/ssm/model/ResultAttribute.h>
#include <aws/ssm/model/ResumeSessionRequest.h>
#include <aws/ssm/model/ResumeSessionResult.h>
#include <aws/ssm/model/ReviewInformation.h>
#include <aws/ssm/model/ReviewStatus.h>
#include <aws/ssm/model/Runbook.h>
#include <aws/ssm/model/S3OutputLocation.h>
#include <aws/ssm/model/S3OutputUrl.h>
#include <aws/ssm/model/ScheduledWindowExecution.h>
#include <aws/ssm/model/SendAutomationSignalRequest.h>
#include <aws/ssm/model/SendAutomationSignalResult.h>
#include <aws/ssm/model/SendCommandRequest.h>
#include <aws/ssm/model/SendCommandResult.h>
#include <aws/ssm/model/ServiceQuotaExceededException.h>
#include <aws/ssm/model/ServiceSetting.h>
#include <aws/ssm/model/Session.h>
#include <aws/ssm/model/SessionFilter.h>
#include <aws/ssm/model/SessionFilterKey.h>
#include <aws/ssm/model/SessionManagerOutputUrl.h>
#include <aws/ssm/model/SessionState.h>
#include <aws/ssm/model/SessionStatus.h>
#include <aws/ssm/model/SeveritySummary.h>
#include <aws/ssm/model/SignalType.h>
#include <aws/ssm/model/SourceType.h>
#include <aws/ssm/model/StartAccessRequestRequest.h>
#include <aws/ssm/model/StartAccessRequestResult.h>
#include <aws/ssm/model/StartAssociationsOnceRequest.h>
#include <aws/ssm/model/StartAssociationsOnceResult.h>
#include <aws/ssm/model/StartAutomationExecutionRequest.h>
#include <aws/ssm/model/StartAutomationExecutionResult.h>
#include <aws/ssm/model/StartChangeRequestExecutionRequest.h>
#include <aws/ssm/model/StartChangeRequestExecutionResult.h>
#include <aws/ssm/model/StartExecutionPreviewRequest.h>
#include <aws/ssm/model/StartExecutionPreviewResult.h>
#include <aws/ssm/model/StartSessionRequest.h>
#include <aws/ssm/model/StartSessionResult.h>
#include <aws/ssm/model/StepExecution.h>
#include <aws/ssm/model/StepExecutionFilter.h>
#include <aws/ssm/model/StepExecutionFilterKey.h>
#include <aws/ssm/model/StopAutomationExecutionRequest.h>
#include <aws/ssm/model/StopAutomationExecutionResult.h>
#include <aws/ssm/model/StopType.h>
#include <aws/ssm/model/Tag.h>
#include <aws/ssm/model/Target.h>
#include <aws/ssm/model/TargetLocation.h>
#include <aws/ssm/model/TargetPreview.h>
#include <aws/ssm/model/TerminateSessionRequest.h>
#include <aws/ssm/model/TerminateSessionResult.h>
#include <aws/ssm/model/ThrottlingException.h>
#include <aws/ssm/model/UnlabelParameterVersionRequest.h>
#include <aws/ssm/model/UnlabelParameterVersionResult.h>
#include <aws/ssm/model/UnsupportedInventoryItemContextException.h>
#include <aws/ssm/model/UpdateAssociationRequest.h>
#include <aws/ssm/model/UpdateAssociationResult.h>
#include <aws/ssm/model/UpdateAssociationStatusRequest.h>
#include <aws/ssm/model/UpdateAssociationStatusResult.h>
#include <aws/ssm/model/UpdateDocumentDefaultVersionRequest.h>
#include <aws/ssm/model/UpdateDocumentDefaultVersionResult.h>
#include <aws/ssm/model/UpdateDocumentMetadataRequest.h>
#include <aws/ssm/model/UpdateDocumentMetadataResult.h>
#include <aws/ssm/model/UpdateDocumentRequest.h>
#include <aws/ssm/model/UpdateDocumentResult.h>
#include <aws/ssm/model/UpdateMaintenanceWindowRequest.h>
#include <aws/ssm/model/UpdateMaintenanceWindowResult.h>
#include <aws/ssm/model/UpdateMaintenanceWindowTargetRequest.h>
#include <aws/ssm/model/UpdateMaintenanceWindowTargetResult.h>
#include <aws/ssm/model/UpdateMaintenanceWindowTaskRequest.h>
#include <aws/ssm/model/UpdateMaintenanceWindowTaskResult.h>
#include <aws/ssm/model/UpdateManagedInstanceRoleRequest.h>
#include <aws/ssm/model/UpdateManagedInstanceRoleResult.h>
#include <aws/ssm/model/UpdateOpsItemRequest.h>
#include <aws/ssm/model/UpdateOpsItemResult.h>
#include <aws/ssm/model/UpdateOpsMetadataRequest.h>
#include <aws/ssm/model/UpdateOpsMetadataResult.h>
#include <aws/ssm/model/UpdatePatchBaselineRequest.h>
#include <aws/ssm/model/UpdatePatchBaselineResult.h>
#include <aws/ssm/model/UpdateResourceDataSyncRequest.h>
#include <aws/ssm/model/UpdateResourceDataSyncResult.h>
#include <aws/ssm/model/UpdateServiceSettingRequest.h>
#include <aws/ssm/model/UpdateServiceSettingResult.h>
#include <aws/ssm/model/ValidationException.h>

using SSMIncludeTest = ::testing::Test;

TEST_F(SSMIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::SSM::SSMClient>("SSMIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
