/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/sso-admin/SSOAdminClient.h>
#include <aws/sso-admin/SSOAdminEndpointProvider.h>
#include <aws/sso-admin/SSOAdminEndpointRules.h>
#include <aws/sso-admin/SSOAdminErrorMarshaller.h>
#include <aws/sso-admin/SSOAdminErrors.h>
#include <aws/sso-admin/SSOAdminRequest.h>
#include <aws/sso-admin/SSOAdminServiceClientModel.h>
#include <aws/sso-admin/SSOAdmin_EXPORTS.h>
#include <aws/sso-admin/model/AccessControlAttribute.h>
#include <aws/sso-admin/model/AccessControlAttributeValue.h>
#include <aws/sso-admin/model/AccountAssignment.h>
#include <aws/sso-admin/model/AccountAssignmentForPrincipal.h>
#include <aws/sso-admin/model/AccountAssignmentOperationStatus.h>
#include <aws/sso-admin/model/AccountAssignmentOperationStatusMetadata.h>
#include <aws/sso-admin/model/Application.h>
#include <aws/sso-admin/model/ApplicationAssignment.h>
#include <aws/sso-admin/model/ApplicationAssignmentForPrincipal.h>
#include <aws/sso-admin/model/ApplicationProvider.h>
#include <aws/sso-admin/model/ApplicationStatus.h>
#include <aws/sso-admin/model/ApplicationVisibility.h>
#include <aws/sso-admin/model/AttachCustomerManagedPolicyReferenceToPermissionSetRequest.h>
#include <aws/sso-admin/model/AttachCustomerManagedPolicyReferenceToPermissionSetResult.h>
#include <aws/sso-admin/model/AttachManagedPolicyToPermissionSetRequest.h>
#include <aws/sso-admin/model/AttachManagedPolicyToPermissionSetResult.h>
#include <aws/sso-admin/model/AttachedManagedPolicy.h>
#include <aws/sso-admin/model/AuthenticationMethod.h>
#include <aws/sso-admin/model/AuthenticationMethodItem.h>
#include <aws/sso-admin/model/AuthenticationMethodType.h>
#include <aws/sso-admin/model/AuthorizationCodeGrant.h>
#include <aws/sso-admin/model/AuthorizedTokenIssuer.h>
#include <aws/sso-admin/model/CreateAccountAssignmentRequest.h>
#include <aws/sso-admin/model/CreateAccountAssignmentResult.h>
#include <aws/sso-admin/model/CreateApplicationAssignmentRequest.h>
#include <aws/sso-admin/model/CreateApplicationAssignmentResult.h>
#include <aws/sso-admin/model/CreateApplicationRequest.h>
#include <aws/sso-admin/model/CreateApplicationResult.h>
#include <aws/sso-admin/model/CreateInstanceAccessControlAttributeConfigurationRequest.h>
#include <aws/sso-admin/model/CreateInstanceAccessControlAttributeConfigurationResult.h>
#include <aws/sso-admin/model/CreateInstanceRequest.h>
#include <aws/sso-admin/model/CreateInstanceResult.h>
#include <aws/sso-admin/model/CreatePermissionSetRequest.h>
#include <aws/sso-admin/model/CreatePermissionSetResult.h>
#include <aws/sso-admin/model/CreateTrustedTokenIssuerRequest.h>
#include <aws/sso-admin/model/CreateTrustedTokenIssuerResult.h>
#include <aws/sso-admin/model/CustomerManagedPolicyReference.h>
#include <aws/sso-admin/model/DeleteAccountAssignmentRequest.h>
#include <aws/sso-admin/model/DeleteAccountAssignmentResult.h>
#include <aws/sso-admin/model/DeleteApplicationAccessScopeRequest.h>
#include <aws/sso-admin/model/DeleteApplicationAssignmentRequest.h>
#include <aws/sso-admin/model/DeleteApplicationAssignmentResult.h>
#include <aws/sso-admin/model/DeleteApplicationAuthenticationMethodRequest.h>
#include <aws/sso-admin/model/DeleteApplicationGrantRequest.h>
#include <aws/sso-admin/model/DeleteApplicationRequest.h>
#include <aws/sso-admin/model/DeleteApplicationResult.h>
#include <aws/sso-admin/model/DeleteInlinePolicyFromPermissionSetRequest.h>
#include <aws/sso-admin/model/DeleteInlinePolicyFromPermissionSetResult.h>
#include <aws/sso-admin/model/DeleteInstanceAccessControlAttributeConfigurationRequest.h>
#include <aws/sso-admin/model/DeleteInstanceAccessControlAttributeConfigurationResult.h>
#include <aws/sso-admin/model/DeleteInstanceRequest.h>
#include <aws/sso-admin/model/DeleteInstanceResult.h>
#include <aws/sso-admin/model/DeletePermissionSetRequest.h>
#include <aws/sso-admin/model/DeletePermissionSetResult.h>
#include <aws/sso-admin/model/DeletePermissionsBoundaryFromPermissionSetRequest.h>
#include <aws/sso-admin/model/DeletePermissionsBoundaryFromPermissionSetResult.h>
#include <aws/sso-admin/model/DeleteTrustedTokenIssuerRequest.h>
#include <aws/sso-admin/model/DeleteTrustedTokenIssuerResult.h>
#include <aws/sso-admin/model/DescribeAccountAssignmentCreationStatusRequest.h>
#include <aws/sso-admin/model/DescribeAccountAssignmentCreationStatusResult.h>
#include <aws/sso-admin/model/DescribeAccountAssignmentDeletionStatusRequest.h>
#include <aws/sso-admin/model/DescribeAccountAssignmentDeletionStatusResult.h>
#include <aws/sso-admin/model/DescribeApplicationAssignmentRequest.h>
#include <aws/sso-admin/model/DescribeApplicationAssignmentResult.h>
#include <aws/sso-admin/model/DescribeApplicationProviderRequest.h>
#include <aws/sso-admin/model/DescribeApplicationProviderResult.h>
#include <aws/sso-admin/model/DescribeApplicationRequest.h>
#include <aws/sso-admin/model/DescribeApplicationResult.h>
#include <aws/sso-admin/model/DescribeInstanceAccessControlAttributeConfigurationRequest.h>
#include <aws/sso-admin/model/DescribeInstanceAccessControlAttributeConfigurationResult.h>
#include <aws/sso-admin/model/DescribeInstanceRequest.h>
#include <aws/sso-admin/model/DescribeInstanceResult.h>
#include <aws/sso-admin/model/DescribePermissionSetProvisioningStatusRequest.h>
#include <aws/sso-admin/model/DescribePermissionSetProvisioningStatusResult.h>
#include <aws/sso-admin/model/DescribePermissionSetRequest.h>
#include <aws/sso-admin/model/DescribePermissionSetResult.h>
#include <aws/sso-admin/model/DescribeTrustedTokenIssuerRequest.h>
#include <aws/sso-admin/model/DescribeTrustedTokenIssuerResult.h>
#include <aws/sso-admin/model/DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.h>
#include <aws/sso-admin/model/DetachCustomerManagedPolicyReferenceFromPermissionSetResult.h>
#include <aws/sso-admin/model/DetachManagedPolicyFromPermissionSetRequest.h>
#include <aws/sso-admin/model/DetachManagedPolicyFromPermissionSetResult.h>
#include <aws/sso-admin/model/DisplayData.h>
#include <aws/sso-admin/model/FederationProtocol.h>
#include <aws/sso-admin/model/GetApplicationAccessScopeRequest.h>
#include <aws/sso-admin/model/GetApplicationAccessScopeResult.h>
#include <aws/sso-admin/model/GetApplicationAssignmentConfigurationRequest.h>
#include <aws/sso-admin/model/GetApplicationAssignmentConfigurationResult.h>
#include <aws/sso-admin/model/GetApplicationAuthenticationMethodRequest.h>
#include <aws/sso-admin/model/GetApplicationAuthenticationMethodResult.h>
#include <aws/sso-admin/model/GetApplicationGrantRequest.h>
#include <aws/sso-admin/model/GetApplicationGrantResult.h>
#include <aws/sso-admin/model/GetInlinePolicyForPermissionSetRequest.h>
#include <aws/sso-admin/model/GetInlinePolicyForPermissionSetResult.h>
#include <aws/sso-admin/model/GetPermissionsBoundaryForPermissionSetRequest.h>
#include <aws/sso-admin/model/GetPermissionsBoundaryForPermissionSetResult.h>
#include <aws/sso-admin/model/Grant.h>
#include <aws/sso-admin/model/GrantItem.h>
#include <aws/sso-admin/model/GrantType.h>
#include <aws/sso-admin/model/IamAuthenticationMethod.h>
#include <aws/sso-admin/model/InstanceAccessControlAttributeConfiguration.h>
#include <aws/sso-admin/model/InstanceAccessControlAttributeConfigurationStatus.h>
#include <aws/sso-admin/model/InstanceMetadata.h>
#include <aws/sso-admin/model/InstanceStatus.h>
#include <aws/sso-admin/model/JwksRetrievalOption.h>
#include <aws/sso-admin/model/JwtBearerGrant.h>
#include <aws/sso-admin/model/ListAccountAssignmentCreationStatusRequest.h>
#include <aws/sso-admin/model/ListAccountAssignmentCreationStatusResult.h>
#include <aws/sso-admin/model/ListAccountAssignmentDeletionStatusRequest.h>
#include <aws/sso-admin/model/ListAccountAssignmentDeletionStatusResult.h>
#include <aws/sso-admin/model/ListAccountAssignmentsFilter.h>
#include <aws/sso-admin/model/ListAccountAssignmentsForPrincipalRequest.h>
#include <aws/sso-admin/model/ListAccountAssignmentsForPrincipalResult.h>
#include <aws/sso-admin/model/ListAccountAssignmentsRequest.h>
#include <aws/sso-admin/model/ListAccountAssignmentsResult.h>
#include <aws/sso-admin/model/ListAccountsForProvisionedPermissionSetRequest.h>
#include <aws/sso-admin/model/ListAccountsForProvisionedPermissionSetResult.h>
#include <aws/sso-admin/model/ListApplicationAccessScopesRequest.h>
#include <aws/sso-admin/model/ListApplicationAccessScopesResult.h>
#include <aws/sso-admin/model/ListApplicationAssignmentsFilter.h>
#include <aws/sso-admin/model/ListApplicationAssignmentsForPrincipalRequest.h>
#include <aws/sso-admin/model/ListApplicationAssignmentsForPrincipalResult.h>
#include <aws/sso-admin/model/ListApplicationAssignmentsRequest.h>
#include <aws/sso-admin/model/ListApplicationAssignmentsResult.h>
#include <aws/sso-admin/model/ListApplicationAuthenticationMethodsRequest.h>
#include <aws/sso-admin/model/ListApplicationAuthenticationMethodsResult.h>
#include <aws/sso-admin/model/ListApplicationGrantsRequest.h>
#include <aws/sso-admin/model/ListApplicationGrantsResult.h>
#include <aws/sso-admin/model/ListApplicationProvidersRequest.h>
#include <aws/sso-admin/model/ListApplicationProvidersResult.h>
#include <aws/sso-admin/model/ListApplicationsFilter.h>
#include <aws/sso-admin/model/ListApplicationsRequest.h>
#include <aws/sso-admin/model/ListApplicationsResult.h>
#include <aws/sso-admin/model/ListCustomerManagedPolicyReferencesInPermissionSetRequest.h>
#include <aws/sso-admin/model/ListCustomerManagedPolicyReferencesInPermissionSetResult.h>
#include <aws/sso-admin/model/ListInstancesRequest.h>
#include <aws/sso-admin/model/ListInstancesResult.h>
#include <aws/sso-admin/model/ListManagedPoliciesInPermissionSetRequest.h>
#include <aws/sso-admin/model/ListManagedPoliciesInPermissionSetResult.h>
#include <aws/sso-admin/model/ListPermissionSetProvisioningStatusRequest.h>
#include <aws/sso-admin/model/ListPermissionSetProvisioningStatusResult.h>
#include <aws/sso-admin/model/ListPermissionSetsProvisionedToAccountRequest.h>
#include <aws/sso-admin/model/ListPermissionSetsProvisionedToAccountResult.h>
#include <aws/sso-admin/model/ListPermissionSetsRequest.h>
#include <aws/sso-admin/model/ListPermissionSetsResult.h>
#include <aws/sso-admin/model/ListTagsForResourceRequest.h>
#include <aws/sso-admin/model/ListTagsForResourceResult.h>
#include <aws/sso-admin/model/ListTrustedTokenIssuersRequest.h>
#include <aws/sso-admin/model/ListTrustedTokenIssuersResult.h>
#include <aws/sso-admin/model/OidcJwtConfiguration.h>
#include <aws/sso-admin/model/OidcJwtUpdateConfiguration.h>
#include <aws/sso-admin/model/OperationStatusFilter.h>
#include <aws/sso-admin/model/PermissionSet.h>
#include <aws/sso-admin/model/PermissionSetProvisioningStatus.h>
#include <aws/sso-admin/model/PermissionSetProvisioningStatusMetadata.h>
#include <aws/sso-admin/model/PermissionsBoundary.h>
#include <aws/sso-admin/model/PortalOptions.h>
#include <aws/sso-admin/model/PrincipalType.h>
#include <aws/sso-admin/model/ProvisionPermissionSetRequest.h>
#include <aws/sso-admin/model/ProvisionPermissionSetResult.h>
#include <aws/sso-admin/model/ProvisionTargetType.h>
#include <aws/sso-admin/model/ProvisioningStatus.h>
#include <aws/sso-admin/model/PutApplicationAccessScopeRequest.h>
#include <aws/sso-admin/model/PutApplicationAssignmentConfigurationRequest.h>
#include <aws/sso-admin/model/PutApplicationAssignmentConfigurationResult.h>
#include <aws/sso-admin/model/PutApplicationAuthenticationMethodRequest.h>
#include <aws/sso-admin/model/PutApplicationGrantRequest.h>
#include <aws/sso-admin/model/PutInlinePolicyToPermissionSetRequest.h>
#include <aws/sso-admin/model/PutInlinePolicyToPermissionSetResult.h>
#include <aws/sso-admin/model/PutPermissionsBoundaryToPermissionSetRequest.h>
#include <aws/sso-admin/model/PutPermissionsBoundaryToPermissionSetResult.h>
#include <aws/sso-admin/model/RefreshTokenGrant.h>
#include <aws/sso-admin/model/ResourceServerConfig.h>
#include <aws/sso-admin/model/ResourceServerScopeDetails.h>
#include <aws/sso-admin/model/ScopeDetails.h>
#include <aws/sso-admin/model/SignInOptions.h>
#include <aws/sso-admin/model/SignInOrigin.h>
#include <aws/sso-admin/model/StatusValues.h>
#include <aws/sso-admin/model/Tag.h>
#include <aws/sso-admin/model/TagResourceRequest.h>
#include <aws/sso-admin/model/TagResourceResult.h>
#include <aws/sso-admin/model/TargetType.h>
#include <aws/sso-admin/model/TokenExchangeGrant.h>
#include <aws/sso-admin/model/TrustedTokenIssuerConfiguration.h>
#include <aws/sso-admin/model/TrustedTokenIssuerMetadata.h>
#include <aws/sso-admin/model/TrustedTokenIssuerType.h>
#include <aws/sso-admin/model/TrustedTokenIssuerUpdateConfiguration.h>
#include <aws/sso-admin/model/UntagResourceRequest.h>
#include <aws/sso-admin/model/UntagResourceResult.h>
#include <aws/sso-admin/model/UpdateApplicationPortalOptions.h>
#include <aws/sso-admin/model/UpdateApplicationRequest.h>
#include <aws/sso-admin/model/UpdateApplicationResult.h>
#include <aws/sso-admin/model/UpdateInstanceAccessControlAttributeConfigurationRequest.h>
#include <aws/sso-admin/model/UpdateInstanceAccessControlAttributeConfigurationResult.h>
#include <aws/sso-admin/model/UpdateInstanceRequest.h>
#include <aws/sso-admin/model/UpdateInstanceResult.h>
#include <aws/sso-admin/model/UpdatePermissionSetRequest.h>
#include <aws/sso-admin/model/UpdatePermissionSetResult.h>
#include <aws/sso-admin/model/UpdateTrustedTokenIssuerRequest.h>
#include <aws/sso-admin/model/UpdateTrustedTokenIssuerResult.h>

using SSOAdminIncludeTest = ::testing::Test;

TEST_F(SSOAdminIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::SSOAdmin::SSOAdminClient>("SSOAdminIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
