/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/states/SFNClient.h>
#include <aws/states/SFNEndpointProvider.h>
#include <aws/states/SFNEndpointRules.h>
#include <aws/states/SFNErrorMarshaller.h>
#include <aws/states/SFNErrors.h>
#include <aws/states/SFNRequest.h>
#include <aws/states/SFNServiceClientModel.h>
#include <aws/states/SFN_EXPORTS.h>
#include <aws/states/model/ActivityFailedEventDetails.h>
#include <aws/states/model/ActivityListItem.h>
#include <aws/states/model/ActivityScheduleFailedEventDetails.h>
#include <aws/states/model/ActivityScheduledEventDetails.h>
#include <aws/states/model/ActivityStartedEventDetails.h>
#include <aws/states/model/ActivitySucceededEventDetails.h>
#include <aws/states/model/ActivityTimedOutEventDetails.h>
#include <aws/states/model/AssignedVariablesDetails.h>
#include <aws/states/model/BillingDetails.h>
#include <aws/states/model/CloudWatchEventsExecutionDataDetails.h>
#include <aws/states/model/CloudWatchLogsLogGroup.h>
#include <aws/states/model/CreateActivityRequest.h>
#include <aws/states/model/CreateActivityResult.h>
#include <aws/states/model/CreateStateMachineAliasRequest.h>
#include <aws/states/model/CreateStateMachineAliasResult.h>
#include <aws/states/model/CreateStateMachineRequest.h>
#include <aws/states/model/CreateStateMachineResult.h>
#include <aws/states/model/DeleteActivityRequest.h>
#include <aws/states/model/DeleteActivityResult.h>
#include <aws/states/model/DeleteStateMachineAliasRequest.h>
#include <aws/states/model/DeleteStateMachineAliasResult.h>
#include <aws/states/model/DeleteStateMachineRequest.h>
#include <aws/states/model/DeleteStateMachineResult.h>
#include <aws/states/model/DeleteStateMachineVersionRequest.h>
#include <aws/states/model/DeleteStateMachineVersionResult.h>
#include <aws/states/model/DescribeActivityRequest.h>
#include <aws/states/model/DescribeActivityResult.h>
#include <aws/states/model/DescribeExecutionRequest.h>
#include <aws/states/model/DescribeExecutionResult.h>
#include <aws/states/model/DescribeMapRunRequest.h>
#include <aws/states/model/DescribeMapRunResult.h>
#include <aws/states/model/DescribeStateMachineAliasRequest.h>
#include <aws/states/model/DescribeStateMachineAliasResult.h>
#include <aws/states/model/DescribeStateMachineForExecutionRequest.h>
#include <aws/states/model/DescribeStateMachineForExecutionResult.h>
#include <aws/states/model/DescribeStateMachineRequest.h>
#include <aws/states/model/DescribeStateMachineResult.h>
#include <aws/states/model/EncryptionConfiguration.h>
#include <aws/states/model/EncryptionType.h>
#include <aws/states/model/EvaluationFailedEventDetails.h>
#include <aws/states/model/ExecutionAbortedEventDetails.h>
#include <aws/states/model/ExecutionFailedEventDetails.h>
#include <aws/states/model/ExecutionListItem.h>
#include <aws/states/model/ExecutionRedriveFilter.h>
#include <aws/states/model/ExecutionRedriveStatus.h>
#include <aws/states/model/ExecutionRedrivenEventDetails.h>
#include <aws/states/model/ExecutionStartedEventDetails.h>
#include <aws/states/model/ExecutionStatus.h>
#include <aws/states/model/ExecutionSucceededEventDetails.h>
#include <aws/states/model/ExecutionTimedOutEventDetails.h>
#include <aws/states/model/GetActivityTaskRequest.h>
#include <aws/states/model/GetActivityTaskResult.h>
#include <aws/states/model/GetExecutionHistoryRequest.h>
#include <aws/states/model/GetExecutionHistoryResult.h>
#include <aws/states/model/HistoryEvent.h>
#include <aws/states/model/HistoryEventExecutionDataDetails.h>
#include <aws/states/model/HistoryEventType.h>
#include <aws/states/model/IncludedData.h>
#include <aws/states/model/InspectionData.h>
#include <aws/states/model/InspectionDataRequest.h>
#include <aws/states/model/InspectionDataResponse.h>
#include <aws/states/model/InspectionLevel.h>
#include <aws/states/model/KmsInvalidStateException.h>
#include <aws/states/model/KmsKeyState.h>
#include <aws/states/model/LambdaFunctionFailedEventDetails.h>
#include <aws/states/model/LambdaFunctionScheduleFailedEventDetails.h>
#include <aws/states/model/LambdaFunctionScheduledEventDetails.h>
#include <aws/states/model/LambdaFunctionStartFailedEventDetails.h>
#include <aws/states/model/LambdaFunctionSucceededEventDetails.h>
#include <aws/states/model/LambdaFunctionTimedOutEventDetails.h>
#include <aws/states/model/ListActivitiesRequest.h>
#include <aws/states/model/ListActivitiesResult.h>
#include <aws/states/model/ListExecutionsRequest.h>
#include <aws/states/model/ListExecutionsResult.h>
#include <aws/states/model/ListMapRunsRequest.h>
#include <aws/states/model/ListMapRunsResult.h>
#include <aws/states/model/ListStateMachineAliasesRequest.h>
#include <aws/states/model/ListStateMachineAliasesResult.h>
#include <aws/states/model/ListStateMachineVersionsRequest.h>
#include <aws/states/model/ListStateMachineVersionsResult.h>
#include <aws/states/model/ListStateMachinesRequest.h>
#include <aws/states/model/ListStateMachinesResult.h>
#include <aws/states/model/ListTagsForResourceRequest.h>
#include <aws/states/model/ListTagsForResourceResult.h>
#include <aws/states/model/LogDestination.h>
#include <aws/states/model/LogLevel.h>
#include <aws/states/model/LoggingConfiguration.h>
#include <aws/states/model/MapIterationEventDetails.h>
#include <aws/states/model/MapRunExecutionCounts.h>
#include <aws/states/model/MapRunFailedEventDetails.h>
#include <aws/states/model/MapRunItemCounts.h>
#include <aws/states/model/MapRunListItem.h>
#include <aws/states/model/MapRunRedrivenEventDetails.h>
#include <aws/states/model/MapRunStartedEventDetails.h>
#include <aws/states/model/MapRunStatus.h>
#include <aws/states/model/MapStateStartedEventDetails.h>
#include <aws/states/model/PublishStateMachineVersionRequest.h>
#include <aws/states/model/PublishStateMachineVersionResult.h>
#include <aws/states/model/RedriveExecutionRequest.h>
#include <aws/states/model/RedriveExecutionResult.h>
#include <aws/states/model/ResourceNotFound.h>
#include <aws/states/model/RoutingConfigurationListItem.h>
#include <aws/states/model/SendTaskFailureRequest.h>
#include <aws/states/model/SendTaskFailureResult.h>
#include <aws/states/model/SendTaskHeartbeatRequest.h>
#include <aws/states/model/SendTaskHeartbeatResult.h>
#include <aws/states/model/SendTaskSuccessRequest.h>
#include <aws/states/model/SendTaskSuccessResult.h>
#include <aws/states/model/StartExecutionRequest.h>
#include <aws/states/model/StartExecutionResult.h>
#include <aws/states/model/StartSyncExecutionRequest.h>
#include <aws/states/model/StartSyncExecutionResult.h>
#include <aws/states/model/StateEnteredEventDetails.h>
#include <aws/states/model/StateExitedEventDetails.h>
#include <aws/states/model/StateMachineAliasListItem.h>
#include <aws/states/model/StateMachineListItem.h>
#include <aws/states/model/StateMachineStatus.h>
#include <aws/states/model/StateMachineType.h>
#include <aws/states/model/StateMachineVersionListItem.h>
#include <aws/states/model/StopExecutionRequest.h>
#include <aws/states/model/StopExecutionResult.h>
#include <aws/states/model/SyncExecutionStatus.h>
#include <aws/states/model/Tag.h>
#include <aws/states/model/TagResourceRequest.h>
#include <aws/states/model/TagResourceResult.h>
#include <aws/states/model/TaskCredentials.h>
#include <aws/states/model/TaskFailedEventDetails.h>
#include <aws/states/model/TaskScheduledEventDetails.h>
#include <aws/states/model/TaskStartFailedEventDetails.h>
#include <aws/states/model/TaskStartedEventDetails.h>
#include <aws/states/model/TaskSubmitFailedEventDetails.h>
#include <aws/states/model/TaskSubmittedEventDetails.h>
#include <aws/states/model/TaskSucceededEventDetails.h>
#include <aws/states/model/TaskTimedOutEventDetails.h>
#include <aws/states/model/TestExecutionStatus.h>
#include <aws/states/model/TestStateRequest.h>
#include <aws/states/model/TestStateResult.h>
#include <aws/states/model/TooManyTags.h>
#include <aws/states/model/TracingConfiguration.h>
#include <aws/states/model/UntagResourceRequest.h>
#include <aws/states/model/UntagResourceResult.h>
#include <aws/states/model/UpdateMapRunRequest.h>
#include <aws/states/model/UpdateMapRunResult.h>
#include <aws/states/model/UpdateStateMachineAliasRequest.h>
#include <aws/states/model/UpdateStateMachineAliasResult.h>
#include <aws/states/model/UpdateStateMachineRequest.h>
#include <aws/states/model/UpdateStateMachineResult.h>
#include <aws/states/model/ValidateStateMachineDefinitionDiagnostic.h>
#include <aws/states/model/ValidateStateMachineDefinitionRequest.h>
#include <aws/states/model/ValidateStateMachineDefinitionResult.h>
#include <aws/states/model/ValidateStateMachineDefinitionResultCode.h>
#include <aws/states/model/ValidateStateMachineDefinitionSeverity.h>
#include <aws/states/model/ValidationException.h>
#include <aws/states/model/ValidationExceptionReason.h>

using SFNIncludeTest = ::testing::Test;

TEST_F(SFNIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::SFN::SFNClient>("SFNIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
