/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/swf/SWFClient.h>
#include <aws/swf/SWFEndpointProvider.h>
#include <aws/swf/SWFEndpointRules.h>
#include <aws/swf/SWFErrorMarshaller.h>
#include <aws/swf/SWFErrors.h>
#include <aws/swf/SWFRequest.h>
#include <aws/swf/SWFServiceClientModel.h>
#include <aws/swf/SWF_EXPORTS.h>
#include <aws/swf/model/ActivityTaskCancelRequestedEventAttributes.h>
#include <aws/swf/model/ActivityTaskCanceledEventAttributes.h>
#include <aws/swf/model/ActivityTaskCompletedEventAttributes.h>
#include <aws/swf/model/ActivityTaskFailedEventAttributes.h>
#include <aws/swf/model/ActivityTaskScheduledEventAttributes.h>
#include <aws/swf/model/ActivityTaskStartedEventAttributes.h>
#include <aws/swf/model/ActivityTaskTimedOutEventAttributes.h>
#include <aws/swf/model/ActivityTaskTimeoutType.h>
#include <aws/swf/model/ActivityType.h>
#include <aws/swf/model/ActivityTypeConfiguration.h>
#include <aws/swf/model/ActivityTypeInfo.h>
#include <aws/swf/model/CancelTimerDecisionAttributes.h>
#include <aws/swf/model/CancelTimerFailedCause.h>
#include <aws/swf/model/CancelTimerFailedEventAttributes.h>
#include <aws/swf/model/CancelWorkflowExecutionDecisionAttributes.h>
#include <aws/swf/model/CancelWorkflowExecutionFailedCause.h>
#include <aws/swf/model/CancelWorkflowExecutionFailedEventAttributes.h>
#include <aws/swf/model/ChildPolicy.h>
#include <aws/swf/model/ChildWorkflowExecutionCanceledEventAttributes.h>
#include <aws/swf/model/ChildWorkflowExecutionCompletedEventAttributes.h>
#include <aws/swf/model/ChildWorkflowExecutionFailedEventAttributes.h>
#include <aws/swf/model/ChildWorkflowExecutionStartedEventAttributes.h>
#include <aws/swf/model/ChildWorkflowExecutionTerminatedEventAttributes.h>
#include <aws/swf/model/ChildWorkflowExecutionTimedOutEventAttributes.h>
#include <aws/swf/model/CloseStatus.h>
#include <aws/swf/model/CloseStatusFilter.h>
#include <aws/swf/model/CompleteWorkflowExecutionDecisionAttributes.h>
#include <aws/swf/model/CompleteWorkflowExecutionFailedCause.h>
#include <aws/swf/model/CompleteWorkflowExecutionFailedEventAttributes.h>
#include <aws/swf/model/ContinueAsNewWorkflowExecutionDecisionAttributes.h>
#include <aws/swf/model/ContinueAsNewWorkflowExecutionFailedCause.h>
#include <aws/swf/model/ContinueAsNewWorkflowExecutionFailedEventAttributes.h>
#include <aws/swf/model/CountClosedWorkflowExecutionsRequest.h>
#include <aws/swf/model/CountClosedWorkflowExecutionsResult.h>
#include <aws/swf/model/CountOpenWorkflowExecutionsRequest.h>
#include <aws/swf/model/CountOpenWorkflowExecutionsResult.h>
#include <aws/swf/model/CountPendingActivityTasksRequest.h>
#include <aws/swf/model/CountPendingActivityTasksResult.h>
#include <aws/swf/model/CountPendingDecisionTasksRequest.h>
#include <aws/swf/model/CountPendingDecisionTasksResult.h>
#include <aws/swf/model/Decision.h>
#include <aws/swf/model/DecisionTaskCompletedEventAttributes.h>
#include <aws/swf/model/DecisionTaskScheduledEventAttributes.h>
#include <aws/swf/model/DecisionTaskStartedEventAttributes.h>
#include <aws/swf/model/DecisionTaskTimedOutEventAttributes.h>
#include <aws/swf/model/DecisionTaskTimeoutType.h>
#include <aws/swf/model/DecisionType.h>
#include <aws/swf/model/DeleteActivityTypeRequest.h>
#include <aws/swf/model/DeleteWorkflowTypeRequest.h>
#include <aws/swf/model/DeprecateActivityTypeRequest.h>
#include <aws/swf/model/DeprecateDomainRequest.h>
#include <aws/swf/model/DeprecateWorkflowTypeRequest.h>
#include <aws/swf/model/DescribeActivityTypeRequest.h>
#include <aws/swf/model/DescribeActivityTypeResult.h>
#include <aws/swf/model/DescribeDomainRequest.h>
#include <aws/swf/model/DescribeDomainResult.h>
#include <aws/swf/model/DescribeWorkflowExecutionRequest.h>
#include <aws/swf/model/DescribeWorkflowExecutionResult.h>
#include <aws/swf/model/DescribeWorkflowTypeRequest.h>
#include <aws/swf/model/DescribeWorkflowTypeResult.h>
#include <aws/swf/model/DomainConfiguration.h>
#include <aws/swf/model/DomainInfo.h>
#include <aws/swf/model/EventType.h>
#include <aws/swf/model/ExecutionStatus.h>
#include <aws/swf/model/ExecutionTimeFilter.h>
#include <aws/swf/model/ExternalWorkflowExecutionCancelRequestedEventAttributes.h>
#include <aws/swf/model/ExternalWorkflowExecutionSignaledEventAttributes.h>
#include <aws/swf/model/FailWorkflowExecutionDecisionAttributes.h>
#include <aws/swf/model/FailWorkflowExecutionFailedCause.h>
#include <aws/swf/model/FailWorkflowExecutionFailedEventAttributes.h>
#include <aws/swf/model/GetWorkflowExecutionHistoryRequest.h>
#include <aws/swf/model/GetWorkflowExecutionHistoryResult.h>
#include <aws/swf/model/HistoryEvent.h>
#include <aws/swf/model/LambdaFunctionCompletedEventAttributes.h>
#include <aws/swf/model/LambdaFunctionFailedEventAttributes.h>
#include <aws/swf/model/LambdaFunctionScheduledEventAttributes.h>
#include <aws/swf/model/LambdaFunctionStartedEventAttributes.h>
#include <aws/swf/model/LambdaFunctionTimedOutEventAttributes.h>
#include <aws/swf/model/LambdaFunctionTimeoutType.h>
#include <aws/swf/model/ListActivityTypesRequest.h>
#include <aws/swf/model/ListActivityTypesResult.h>
#include <aws/swf/model/ListClosedWorkflowExecutionsRequest.h>
#include <aws/swf/model/ListClosedWorkflowExecutionsResult.h>
#include <aws/swf/model/ListDomainsRequest.h>
#include <aws/swf/model/ListDomainsResult.h>
#include <aws/swf/model/ListOpenWorkflowExecutionsRequest.h>
#include <aws/swf/model/ListOpenWorkflowExecutionsResult.h>
#include <aws/swf/model/ListTagsForResourceRequest.h>
#include <aws/swf/model/ListTagsForResourceResult.h>
#include <aws/swf/model/ListWorkflowTypesRequest.h>
#include <aws/swf/model/ListWorkflowTypesResult.h>
#include <aws/swf/model/MarkerRecordedEventAttributes.h>
#include <aws/swf/model/PollForActivityTaskRequest.h>
#include <aws/swf/model/PollForActivityTaskResult.h>
#include <aws/swf/model/PollForDecisionTaskRequest.h>
#include <aws/swf/model/PollForDecisionTaskResult.h>
#include <aws/swf/model/RecordActivityTaskHeartbeatRequest.h>
#include <aws/swf/model/RecordActivityTaskHeartbeatResult.h>
#include <aws/swf/model/RecordMarkerDecisionAttributes.h>
#include <aws/swf/model/RecordMarkerFailedCause.h>
#include <aws/swf/model/RecordMarkerFailedEventAttributes.h>
#include <aws/swf/model/RegisterActivityTypeRequest.h>
#include <aws/swf/model/RegisterDomainRequest.h>
#include <aws/swf/model/RegisterWorkflowTypeRequest.h>
#include <aws/swf/model/RegistrationStatus.h>
#include <aws/swf/model/RequestCancelActivityTaskDecisionAttributes.h>
#include <aws/swf/model/RequestCancelActivityTaskFailedCause.h>
#include <aws/swf/model/RequestCancelActivityTaskFailedEventAttributes.h>
#include <aws/swf/model/RequestCancelExternalWorkflowExecutionDecisionAttributes.h>
#include <aws/swf/model/RequestCancelExternalWorkflowExecutionFailedCause.h>
#include <aws/swf/model/RequestCancelExternalWorkflowExecutionFailedEventAttributes.h>
#include <aws/swf/model/RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.h>
#include <aws/swf/model/RequestCancelWorkflowExecutionRequest.h>
#include <aws/swf/model/ResourceTag.h>
#include <aws/swf/model/RespondActivityTaskCanceledRequest.h>
#include <aws/swf/model/RespondActivityTaskCompletedRequest.h>
#include <aws/swf/model/RespondActivityTaskFailedRequest.h>
#include <aws/swf/model/RespondDecisionTaskCompletedRequest.h>
#include <aws/swf/model/ScheduleActivityTaskDecisionAttributes.h>
#include <aws/swf/model/ScheduleActivityTaskFailedCause.h>
#include <aws/swf/model/ScheduleActivityTaskFailedEventAttributes.h>
#include <aws/swf/model/ScheduleLambdaFunctionDecisionAttributes.h>
#include <aws/swf/model/ScheduleLambdaFunctionFailedCause.h>
#include <aws/swf/model/ScheduleLambdaFunctionFailedEventAttributes.h>
#include <aws/swf/model/SignalExternalWorkflowExecutionDecisionAttributes.h>
#include <aws/swf/model/SignalExternalWorkflowExecutionFailedCause.h>
#include <aws/swf/model/SignalExternalWorkflowExecutionFailedEventAttributes.h>
#include <aws/swf/model/SignalExternalWorkflowExecutionInitiatedEventAttributes.h>
#include <aws/swf/model/SignalWorkflowExecutionRequest.h>
#include <aws/swf/model/StartChildWorkflowExecutionDecisionAttributes.h>
#include <aws/swf/model/StartChildWorkflowExecutionFailedCause.h>
#include <aws/swf/model/StartChildWorkflowExecutionFailedEventAttributes.h>
#include <aws/swf/model/StartChildWorkflowExecutionInitiatedEventAttributes.h>
#include <aws/swf/model/StartLambdaFunctionFailedCause.h>
#include <aws/swf/model/StartLambdaFunctionFailedEventAttributes.h>
#include <aws/swf/model/StartTimerDecisionAttributes.h>
#include <aws/swf/model/StartTimerFailedCause.h>
#include <aws/swf/model/StartTimerFailedEventAttributes.h>
#include <aws/swf/model/StartWorkflowExecutionRequest.h>
#include <aws/swf/model/StartWorkflowExecutionResult.h>
#include <aws/swf/model/TagFilter.h>
#include <aws/swf/model/TagResourceRequest.h>
#include <aws/swf/model/TaskList.h>
#include <aws/swf/model/TerminateWorkflowExecutionRequest.h>
#include <aws/swf/model/TimerCanceledEventAttributes.h>
#include <aws/swf/model/TimerFiredEventAttributes.h>
#include <aws/swf/model/TimerStartedEventAttributes.h>
#include <aws/swf/model/UndeprecateActivityTypeRequest.h>
#include <aws/swf/model/UndeprecateDomainRequest.h>
#include <aws/swf/model/UndeprecateWorkflowTypeRequest.h>
#include <aws/swf/model/UntagResourceRequest.h>
#include <aws/swf/model/WorkflowExecution.h>
#include <aws/swf/model/WorkflowExecutionCancelRequestedCause.h>
#include <aws/swf/model/WorkflowExecutionCancelRequestedEventAttributes.h>
#include <aws/swf/model/WorkflowExecutionCanceledEventAttributes.h>
#include <aws/swf/model/WorkflowExecutionCompletedEventAttributes.h>
#include <aws/swf/model/WorkflowExecutionConfiguration.h>
#include <aws/swf/model/WorkflowExecutionContinuedAsNewEventAttributes.h>
#include <aws/swf/model/WorkflowExecutionFailedEventAttributes.h>
#include <aws/swf/model/WorkflowExecutionFilter.h>
#include <aws/swf/model/WorkflowExecutionInfo.h>
#include <aws/swf/model/WorkflowExecutionOpenCounts.h>
#include <aws/swf/model/WorkflowExecutionSignaledEventAttributes.h>
#include <aws/swf/model/WorkflowExecutionStartedEventAttributes.h>
#include <aws/swf/model/WorkflowExecutionTerminatedCause.h>
#include <aws/swf/model/WorkflowExecutionTerminatedEventAttributes.h>
#include <aws/swf/model/WorkflowExecutionTimedOutEventAttributes.h>
#include <aws/swf/model/WorkflowExecutionTimeoutType.h>
#include <aws/swf/model/WorkflowType.h>
#include <aws/swf/model/WorkflowTypeConfiguration.h>
#include <aws/swf/model/WorkflowTypeFilter.h>
#include <aws/swf/model/WorkflowTypeInfo.h>

using SWFIncludeTest = ::testing::Test;

TEST_F(SWFIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::SWF::SWFClient>("SWFIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
