/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/transcribe/TranscribeServiceClient.h>
#include <aws/transcribe/TranscribeServiceEndpointProvider.h>
#include <aws/transcribe/TranscribeServiceEndpointRules.h>
#include <aws/transcribe/TranscribeServiceErrorMarshaller.h>
#include <aws/transcribe/TranscribeServiceErrors.h>
#include <aws/transcribe/TranscribeServiceRequest.h>
#include <aws/transcribe/TranscribeServiceServiceClientModel.h>
#include <aws/transcribe/TranscribeService_EXPORTS.h>
#include <aws/transcribe/model/AbsoluteTimeRange.h>
#include <aws/transcribe/model/BaseModelName.h>
#include <aws/transcribe/model/CLMLanguageCode.h>
#include <aws/transcribe/model/CallAnalyticsFeature.h>
#include <aws/transcribe/model/CallAnalyticsJob.h>
#include <aws/transcribe/model/CallAnalyticsJobDetails.h>
#include <aws/transcribe/model/CallAnalyticsJobSettings.h>
#include <aws/transcribe/model/CallAnalyticsJobStatus.h>
#include <aws/transcribe/model/CallAnalyticsJobSummary.h>
#include <aws/transcribe/model/CallAnalyticsSkippedFeature.h>
#include <aws/transcribe/model/CallAnalyticsSkippedReasonCode.h>
#include <aws/transcribe/model/CategoryProperties.h>
#include <aws/transcribe/model/ChannelDefinition.h>
#include <aws/transcribe/model/ClinicalNoteGenerationSettings.h>
#include <aws/transcribe/model/ContentRedaction.h>
#include <aws/transcribe/model/CreateCallAnalyticsCategoryRequest.h>
#include <aws/transcribe/model/CreateCallAnalyticsCategoryResult.h>
#include <aws/transcribe/model/CreateLanguageModelRequest.h>
#include <aws/transcribe/model/CreateLanguageModelResult.h>
#include <aws/transcribe/model/CreateMedicalVocabularyRequest.h>
#include <aws/transcribe/model/CreateMedicalVocabularyResult.h>
#include <aws/transcribe/model/CreateVocabularyFilterRequest.h>
#include <aws/transcribe/model/CreateVocabularyFilterResult.h>
#include <aws/transcribe/model/CreateVocabularyRequest.h>
#include <aws/transcribe/model/CreateVocabularyResult.h>
#include <aws/transcribe/model/DeleteCallAnalyticsCategoryRequest.h>
#include <aws/transcribe/model/DeleteCallAnalyticsCategoryResult.h>
#include <aws/transcribe/model/DeleteCallAnalyticsJobRequest.h>
#include <aws/transcribe/model/DeleteCallAnalyticsJobResult.h>
#include <aws/transcribe/model/DeleteLanguageModelRequest.h>
#include <aws/transcribe/model/DeleteMedicalScribeJobRequest.h>
#include <aws/transcribe/model/DeleteMedicalTranscriptionJobRequest.h>
#include <aws/transcribe/model/DeleteMedicalVocabularyRequest.h>
#include <aws/transcribe/model/DeleteTranscriptionJobRequest.h>
#include <aws/transcribe/model/DeleteVocabularyFilterRequest.h>
#include <aws/transcribe/model/DeleteVocabularyRequest.h>
#include <aws/transcribe/model/DescribeLanguageModelRequest.h>
#include <aws/transcribe/model/DescribeLanguageModelResult.h>
#include <aws/transcribe/model/GetCallAnalyticsCategoryRequest.h>
#include <aws/transcribe/model/GetCallAnalyticsCategoryResult.h>
#include <aws/transcribe/model/GetCallAnalyticsJobRequest.h>
#include <aws/transcribe/model/GetCallAnalyticsJobResult.h>
#include <aws/transcribe/model/GetMedicalScribeJobRequest.h>
#include <aws/transcribe/model/GetMedicalScribeJobResult.h>
#include <aws/transcribe/model/GetMedicalTranscriptionJobRequest.h>
#include <aws/transcribe/model/GetMedicalTranscriptionJobResult.h>
#include <aws/transcribe/model/GetMedicalVocabularyRequest.h>
#include <aws/transcribe/model/GetMedicalVocabularyResult.h>
#include <aws/transcribe/model/GetTranscriptionJobRequest.h>
#include <aws/transcribe/model/GetTranscriptionJobResult.h>
#include <aws/transcribe/model/GetVocabularyFilterRequest.h>
#include <aws/transcribe/model/GetVocabularyFilterResult.h>
#include <aws/transcribe/model/GetVocabularyRequest.h>
#include <aws/transcribe/model/GetVocabularyResult.h>
#include <aws/transcribe/model/InputDataConfig.h>
#include <aws/transcribe/model/InputType.h>
#include <aws/transcribe/model/InterruptionFilter.h>
#include <aws/transcribe/model/JobExecutionSettings.h>
#include <aws/transcribe/model/LanguageCode.h>
#include <aws/transcribe/model/LanguageCodeItem.h>
#include <aws/transcribe/model/LanguageIdSettings.h>
#include <aws/transcribe/model/LanguageModel.h>
#include <aws/transcribe/model/ListCallAnalyticsCategoriesRequest.h>
#include <aws/transcribe/model/ListCallAnalyticsCategoriesResult.h>
#include <aws/transcribe/model/ListCallAnalyticsJobsRequest.h>
#include <aws/transcribe/model/ListCallAnalyticsJobsResult.h>
#include <aws/transcribe/model/ListLanguageModelsRequest.h>
#include <aws/transcribe/model/ListLanguageModelsResult.h>
#include <aws/transcribe/model/ListMedicalScribeJobsRequest.h>
#include <aws/transcribe/model/ListMedicalScribeJobsResult.h>
#include <aws/transcribe/model/ListMedicalTranscriptionJobsRequest.h>
#include <aws/transcribe/model/ListMedicalTranscriptionJobsResult.h>
#include <aws/transcribe/model/ListMedicalVocabulariesRequest.h>
#include <aws/transcribe/model/ListMedicalVocabulariesResult.h>
#include <aws/transcribe/model/ListTagsForResourceRequest.h>
#include <aws/transcribe/model/ListTagsForResourceResult.h>
#include <aws/transcribe/model/ListTranscriptionJobsRequest.h>
#include <aws/transcribe/model/ListTranscriptionJobsResult.h>
#include <aws/transcribe/model/ListVocabulariesRequest.h>
#include <aws/transcribe/model/ListVocabulariesResult.h>
#include <aws/transcribe/model/ListVocabularyFiltersRequest.h>
#include <aws/transcribe/model/ListVocabularyFiltersResult.h>
#include <aws/transcribe/model/Media.h>
#include <aws/transcribe/model/MediaFormat.h>
#include <aws/transcribe/model/MedicalContentIdentificationType.h>
#include <aws/transcribe/model/MedicalScribeChannelDefinition.h>
#include <aws/transcribe/model/MedicalScribeJob.h>
#include <aws/transcribe/model/MedicalScribeJobStatus.h>
#include <aws/transcribe/model/MedicalScribeJobSummary.h>
#include <aws/transcribe/model/MedicalScribeLanguageCode.h>
#include <aws/transcribe/model/MedicalScribeNoteTemplate.h>
#include <aws/transcribe/model/MedicalScribeOutput.h>
#include <aws/transcribe/model/MedicalScribeParticipantRole.h>
#include <aws/transcribe/model/MedicalScribeSettings.h>
#include <aws/transcribe/model/MedicalTranscript.h>
#include <aws/transcribe/model/MedicalTranscriptionJob.h>
#include <aws/transcribe/model/MedicalTranscriptionJobSummary.h>
#include <aws/transcribe/model/MedicalTranscriptionSetting.h>
#include <aws/transcribe/model/ModelSettings.h>
#include <aws/transcribe/model/ModelStatus.h>
#include <aws/transcribe/model/NonTalkTimeFilter.h>
#include <aws/transcribe/model/OutputLocationType.h>
#include <aws/transcribe/model/ParticipantRole.h>
#include <aws/transcribe/model/PiiEntityType.h>
#include <aws/transcribe/model/RedactionOutput.h>
#include <aws/transcribe/model/RedactionType.h>
#include <aws/transcribe/model/RelativeTimeRange.h>
#include <aws/transcribe/model/Rule.h>
#include <aws/transcribe/model/SentimentFilter.h>
#include <aws/transcribe/model/SentimentValue.h>
#include <aws/transcribe/model/Settings.h>
#include <aws/transcribe/model/Specialty.h>
#include <aws/transcribe/model/StartCallAnalyticsJobRequest.h>
#include <aws/transcribe/model/StartCallAnalyticsJobResult.h>
#include <aws/transcribe/model/StartMedicalScribeJobRequest.h>
#include <aws/transcribe/model/StartMedicalScribeJobResult.h>
#include <aws/transcribe/model/StartMedicalTranscriptionJobRequest.h>
#include <aws/transcribe/model/StartMedicalTranscriptionJobResult.h>
#include <aws/transcribe/model/StartTranscriptionJobRequest.h>
#include <aws/transcribe/model/StartTranscriptionJobResult.h>
#include <aws/transcribe/model/SubtitleFormat.h>
#include <aws/transcribe/model/Subtitles.h>
#include <aws/transcribe/model/SubtitlesOutput.h>
#include <aws/transcribe/model/Summarization.h>
#include <aws/transcribe/model/Tag.h>
#include <aws/transcribe/model/TagResourceRequest.h>
#include <aws/transcribe/model/TagResourceResult.h>
#include <aws/transcribe/model/ToxicityCategory.h>
#include <aws/transcribe/model/ToxicityDetectionSettings.h>
#include <aws/transcribe/model/Transcript.h>
#include <aws/transcribe/model/TranscriptFilter.h>
#include <aws/transcribe/model/TranscriptFilterType.h>
#include <aws/transcribe/model/TranscriptionJob.h>
#include <aws/transcribe/model/TranscriptionJobStatus.h>
#include <aws/transcribe/model/TranscriptionJobSummary.h>
#include <aws/transcribe/model/Type.h>
#include <aws/transcribe/model/UntagResourceRequest.h>
#include <aws/transcribe/model/UntagResourceResult.h>
#include <aws/transcribe/model/UpdateCallAnalyticsCategoryRequest.h>
#include <aws/transcribe/model/UpdateCallAnalyticsCategoryResult.h>
#include <aws/transcribe/model/UpdateMedicalVocabularyRequest.h>
#include <aws/transcribe/model/UpdateMedicalVocabularyResult.h>
#include <aws/transcribe/model/UpdateVocabularyFilterRequest.h>
#include <aws/transcribe/model/UpdateVocabularyFilterResult.h>
#include <aws/transcribe/model/UpdateVocabularyRequest.h>
#include <aws/transcribe/model/UpdateVocabularyResult.h>
#include <aws/transcribe/model/VocabularyFilterInfo.h>
#include <aws/transcribe/model/VocabularyFilterMethod.h>
#include <aws/transcribe/model/VocabularyInfo.h>
#include <aws/transcribe/model/VocabularyState.h>

using TranscribeServiceIncludeTest = ::testing::Test;

TEST_F(TranscribeServiceIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::TranscribeService::TranscribeServiceClient>("TranscribeServiceIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
