/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/vpc-lattice/VPCLatticeClient.h>
#include <aws/vpc-lattice/VPCLatticeEndpointProvider.h>
#include <aws/vpc-lattice/VPCLatticeEndpointRules.h>
#include <aws/vpc-lattice/VPCLatticeErrorMarshaller.h>
#include <aws/vpc-lattice/VPCLatticeErrors.h>
#include <aws/vpc-lattice/VPCLatticeRequest.h>
#include <aws/vpc-lattice/VPCLatticeServiceClientModel.h>
#include <aws/vpc-lattice/VPCLattice_EXPORTS.h>
#include <aws/vpc-lattice/model/AccessLogSubscriptionSummary.h>
#include <aws/vpc-lattice/model/ArnResource.h>
#include <aws/vpc-lattice/model/AuthPolicyState.h>
#include <aws/vpc-lattice/model/AuthType.h>
#include <aws/vpc-lattice/model/BatchUpdateRuleRequest.h>
#include <aws/vpc-lattice/model/BatchUpdateRuleResult.h>
#include <aws/vpc-lattice/model/ConflictException.h>
#include <aws/vpc-lattice/model/CreateAccessLogSubscriptionRequest.h>
#include <aws/vpc-lattice/model/CreateAccessLogSubscriptionResult.h>
#include <aws/vpc-lattice/model/CreateListenerRequest.h>
#include <aws/vpc-lattice/model/CreateListenerResult.h>
#include <aws/vpc-lattice/model/CreateResourceConfigurationRequest.h>
#include <aws/vpc-lattice/model/CreateResourceConfigurationResult.h>
#include <aws/vpc-lattice/model/CreateResourceGatewayRequest.h>
#include <aws/vpc-lattice/model/CreateResourceGatewayResult.h>
#include <aws/vpc-lattice/model/CreateRuleRequest.h>
#include <aws/vpc-lattice/model/CreateRuleResult.h>
#include <aws/vpc-lattice/model/CreateServiceNetworkRequest.h>
#include <aws/vpc-lattice/model/CreateServiceNetworkResourceAssociationRequest.h>
#include <aws/vpc-lattice/model/CreateServiceNetworkResourceAssociationResult.h>
#include <aws/vpc-lattice/model/CreateServiceNetworkResult.h>
#include <aws/vpc-lattice/model/CreateServiceNetworkServiceAssociationRequest.h>
#include <aws/vpc-lattice/model/CreateServiceNetworkServiceAssociationResult.h>
#include <aws/vpc-lattice/model/CreateServiceNetworkVpcAssociationRequest.h>
#include <aws/vpc-lattice/model/CreateServiceNetworkVpcAssociationResult.h>
#include <aws/vpc-lattice/model/CreateServiceRequest.h>
#include <aws/vpc-lattice/model/CreateServiceResult.h>
#include <aws/vpc-lattice/model/CreateTargetGroupRequest.h>
#include <aws/vpc-lattice/model/CreateTargetGroupResult.h>
#include <aws/vpc-lattice/model/DeleteAccessLogSubscriptionRequest.h>
#include <aws/vpc-lattice/model/DeleteAccessLogSubscriptionResult.h>
#include <aws/vpc-lattice/model/DeleteAuthPolicyRequest.h>
#include <aws/vpc-lattice/model/DeleteAuthPolicyResult.h>
#include <aws/vpc-lattice/model/DeleteListenerRequest.h>
#include <aws/vpc-lattice/model/DeleteListenerResult.h>
#include <aws/vpc-lattice/model/DeleteResourceConfigurationRequest.h>
#include <aws/vpc-lattice/model/DeleteResourceConfigurationResult.h>
#include <aws/vpc-lattice/model/DeleteResourceEndpointAssociationRequest.h>
#include <aws/vpc-lattice/model/DeleteResourceEndpointAssociationResult.h>
#include <aws/vpc-lattice/model/DeleteResourceGatewayRequest.h>
#include <aws/vpc-lattice/model/DeleteResourceGatewayResult.h>
#include <aws/vpc-lattice/model/DeleteResourcePolicyRequest.h>
#include <aws/vpc-lattice/model/DeleteResourcePolicyResult.h>
#include <aws/vpc-lattice/model/DeleteRuleRequest.h>
#include <aws/vpc-lattice/model/DeleteRuleResult.h>
#include <aws/vpc-lattice/model/DeleteServiceNetworkRequest.h>
#include <aws/vpc-lattice/model/DeleteServiceNetworkResourceAssociationRequest.h>
#include <aws/vpc-lattice/model/DeleteServiceNetworkResourceAssociationResult.h>
#include <aws/vpc-lattice/model/DeleteServiceNetworkResult.h>
#include <aws/vpc-lattice/model/DeleteServiceNetworkServiceAssociationRequest.h>
#include <aws/vpc-lattice/model/DeleteServiceNetworkServiceAssociationResult.h>
#include <aws/vpc-lattice/model/DeleteServiceNetworkVpcAssociationRequest.h>
#include <aws/vpc-lattice/model/DeleteServiceNetworkVpcAssociationResult.h>
#include <aws/vpc-lattice/model/DeleteServiceRequest.h>
#include <aws/vpc-lattice/model/DeleteServiceResult.h>
#include <aws/vpc-lattice/model/DeleteTargetGroupRequest.h>
#include <aws/vpc-lattice/model/DeleteTargetGroupResult.h>
#include <aws/vpc-lattice/model/DeregisterTargetsRequest.h>
#include <aws/vpc-lattice/model/DeregisterTargetsResult.h>
#include <aws/vpc-lattice/model/DnsEntry.h>
#include <aws/vpc-lattice/model/DnsResource.h>
#include <aws/vpc-lattice/model/FixedResponseAction.h>
#include <aws/vpc-lattice/model/ForwardAction.h>
#include <aws/vpc-lattice/model/GetAccessLogSubscriptionRequest.h>
#include <aws/vpc-lattice/model/GetAccessLogSubscriptionResult.h>
#include <aws/vpc-lattice/model/GetAuthPolicyRequest.h>
#include <aws/vpc-lattice/model/GetAuthPolicyResult.h>
#include <aws/vpc-lattice/model/GetListenerRequest.h>
#include <aws/vpc-lattice/model/GetListenerResult.h>
#include <aws/vpc-lattice/model/GetResourceConfigurationRequest.h>
#include <aws/vpc-lattice/model/GetResourceConfigurationResult.h>
#include <aws/vpc-lattice/model/GetResourceGatewayRequest.h>
#include <aws/vpc-lattice/model/GetResourceGatewayResult.h>
#include <aws/vpc-lattice/model/GetResourcePolicyRequest.h>
#include <aws/vpc-lattice/model/GetResourcePolicyResult.h>
#include <aws/vpc-lattice/model/GetRuleRequest.h>
#include <aws/vpc-lattice/model/GetRuleResult.h>
#include <aws/vpc-lattice/model/GetServiceNetworkRequest.h>
#include <aws/vpc-lattice/model/GetServiceNetworkResourceAssociationRequest.h>
#include <aws/vpc-lattice/model/GetServiceNetworkResourceAssociationResult.h>
#include <aws/vpc-lattice/model/GetServiceNetworkResult.h>
#include <aws/vpc-lattice/model/GetServiceNetworkServiceAssociationRequest.h>
#include <aws/vpc-lattice/model/GetServiceNetworkServiceAssociationResult.h>
#include <aws/vpc-lattice/model/GetServiceNetworkVpcAssociationRequest.h>
#include <aws/vpc-lattice/model/GetServiceNetworkVpcAssociationResult.h>
#include <aws/vpc-lattice/model/GetServiceRequest.h>
#include <aws/vpc-lattice/model/GetServiceResult.h>
#include <aws/vpc-lattice/model/GetTargetGroupRequest.h>
#include <aws/vpc-lattice/model/GetTargetGroupResult.h>
#include <aws/vpc-lattice/model/HeaderMatch.h>
#include <aws/vpc-lattice/model/HeaderMatchType.h>
#include <aws/vpc-lattice/model/HealthCheckConfig.h>
#include <aws/vpc-lattice/model/HealthCheckProtocolVersion.h>
#include <aws/vpc-lattice/model/HttpMatch.h>
#include <aws/vpc-lattice/model/InternalServerException.h>
#include <aws/vpc-lattice/model/IpAddressType.h>
#include <aws/vpc-lattice/model/IpResource.h>
#include <aws/vpc-lattice/model/LambdaEventStructureVersion.h>
#include <aws/vpc-lattice/model/ListAccessLogSubscriptionsRequest.h>
#include <aws/vpc-lattice/model/ListAccessLogSubscriptionsResult.h>
#include <aws/vpc-lattice/model/ListListenersRequest.h>
#include <aws/vpc-lattice/model/ListListenersResult.h>
#include <aws/vpc-lattice/model/ListResourceConfigurationsRequest.h>
#include <aws/vpc-lattice/model/ListResourceConfigurationsResult.h>
#include <aws/vpc-lattice/model/ListResourceEndpointAssociationsRequest.h>
#include <aws/vpc-lattice/model/ListResourceEndpointAssociationsResult.h>
#include <aws/vpc-lattice/model/ListResourceGatewaysRequest.h>
#include <aws/vpc-lattice/model/ListResourceGatewaysResult.h>
#include <aws/vpc-lattice/model/ListRulesRequest.h>
#include <aws/vpc-lattice/model/ListRulesResult.h>
#include <aws/vpc-lattice/model/ListServiceNetworkResourceAssociationsRequest.h>
#include <aws/vpc-lattice/model/ListServiceNetworkResourceAssociationsResult.h>
#include <aws/vpc-lattice/model/ListServiceNetworkServiceAssociationsRequest.h>
#include <aws/vpc-lattice/model/ListServiceNetworkServiceAssociationsResult.h>
#include <aws/vpc-lattice/model/ListServiceNetworkVpcAssociationsRequest.h>
#include <aws/vpc-lattice/model/ListServiceNetworkVpcAssociationsResult.h>
#include <aws/vpc-lattice/model/ListServiceNetworkVpcEndpointAssociationsRequest.h>
#include <aws/vpc-lattice/model/ListServiceNetworkVpcEndpointAssociationsResult.h>
#include <aws/vpc-lattice/model/ListServiceNetworksRequest.h>
#include <aws/vpc-lattice/model/ListServiceNetworksResult.h>
#include <aws/vpc-lattice/model/ListServicesRequest.h>
#include <aws/vpc-lattice/model/ListServicesResult.h>
#include <aws/vpc-lattice/model/ListTagsForResourceRequest.h>
#include <aws/vpc-lattice/model/ListTagsForResourceResult.h>
#include <aws/vpc-lattice/model/ListTargetGroupsRequest.h>
#include <aws/vpc-lattice/model/ListTargetGroupsResult.h>
#include <aws/vpc-lattice/model/ListTargetsRequest.h>
#include <aws/vpc-lattice/model/ListTargetsResult.h>
#include <aws/vpc-lattice/model/ListenerProtocol.h>
#include <aws/vpc-lattice/model/ListenerSummary.h>
#include <aws/vpc-lattice/model/Matcher.h>
#include <aws/vpc-lattice/model/PathMatch.h>
#include <aws/vpc-lattice/model/PathMatchType.h>
#include <aws/vpc-lattice/model/ProtocolType.h>
#include <aws/vpc-lattice/model/PutAuthPolicyRequest.h>
#include <aws/vpc-lattice/model/PutAuthPolicyResult.h>
#include <aws/vpc-lattice/model/PutResourcePolicyRequest.h>
#include <aws/vpc-lattice/model/PutResourcePolicyResult.h>
#include <aws/vpc-lattice/model/RegisterTargetsRequest.h>
#include <aws/vpc-lattice/model/RegisterTargetsResult.h>
#include <aws/vpc-lattice/model/ResourceConfigurationDefinition.h>
#include <aws/vpc-lattice/model/ResourceConfigurationIpAddressType.h>
#include <aws/vpc-lattice/model/ResourceConfigurationStatus.h>
#include <aws/vpc-lattice/model/ResourceConfigurationSummary.h>
#include <aws/vpc-lattice/model/ResourceConfigurationType.h>
#include <aws/vpc-lattice/model/ResourceEndpointAssociationSummary.h>
#include <aws/vpc-lattice/model/ResourceGatewayIpAddressType.h>
#include <aws/vpc-lattice/model/ResourceGatewayStatus.h>
#include <aws/vpc-lattice/model/ResourceGatewaySummary.h>
#include <aws/vpc-lattice/model/ResourceNotFoundException.h>
#include <aws/vpc-lattice/model/RuleAction.h>
#include <aws/vpc-lattice/model/RuleMatch.h>
#include <aws/vpc-lattice/model/RuleSummary.h>
#include <aws/vpc-lattice/model/RuleUpdate.h>
#include <aws/vpc-lattice/model/RuleUpdateFailure.h>
#include <aws/vpc-lattice/model/RuleUpdateSuccess.h>
#include <aws/vpc-lattice/model/ServiceNetworkEndpointAssociation.h>
#include <aws/vpc-lattice/model/ServiceNetworkLogType.h>
#include <aws/vpc-lattice/model/ServiceNetworkResourceAssociationStatus.h>
#include <aws/vpc-lattice/model/ServiceNetworkResourceAssociationSummary.h>
#include <aws/vpc-lattice/model/ServiceNetworkServiceAssociationStatus.h>
#include <aws/vpc-lattice/model/ServiceNetworkServiceAssociationSummary.h>
#include <aws/vpc-lattice/model/ServiceNetworkSummary.h>
#include <aws/vpc-lattice/model/ServiceNetworkVpcAssociationStatus.h>
#include <aws/vpc-lattice/model/ServiceNetworkVpcAssociationSummary.h>
#include <aws/vpc-lattice/model/ServiceQuotaExceededException.h>
#include <aws/vpc-lattice/model/ServiceStatus.h>
#include <aws/vpc-lattice/model/ServiceSummary.h>
#include <aws/vpc-lattice/model/SharingConfig.h>
#include <aws/vpc-lattice/model/TagResourceRequest.h>
#include <aws/vpc-lattice/model/TagResourceResult.h>
#include <aws/vpc-lattice/model/Target.h>
#include <aws/vpc-lattice/model/TargetFailure.h>
#include <aws/vpc-lattice/model/TargetGroupConfig.h>
#include <aws/vpc-lattice/model/TargetGroupProtocol.h>
#include <aws/vpc-lattice/model/TargetGroupProtocolVersion.h>
#include <aws/vpc-lattice/model/TargetGroupStatus.h>
#include <aws/vpc-lattice/model/TargetGroupSummary.h>
#include <aws/vpc-lattice/model/TargetGroupType.h>
#include <aws/vpc-lattice/model/TargetStatus.h>
#include <aws/vpc-lattice/model/TargetSummary.h>
#include <aws/vpc-lattice/model/ThrottlingException.h>
#include <aws/vpc-lattice/model/UntagResourceRequest.h>
#include <aws/vpc-lattice/model/UntagResourceResult.h>
#include <aws/vpc-lattice/model/UpdateAccessLogSubscriptionRequest.h>
#include <aws/vpc-lattice/model/UpdateAccessLogSubscriptionResult.h>
#include <aws/vpc-lattice/model/UpdateListenerRequest.h>
#include <aws/vpc-lattice/model/UpdateListenerResult.h>
#include <aws/vpc-lattice/model/UpdateResourceConfigurationRequest.h>
#include <aws/vpc-lattice/model/UpdateResourceConfigurationResult.h>
#include <aws/vpc-lattice/model/UpdateResourceGatewayRequest.h>
#include <aws/vpc-lattice/model/UpdateResourceGatewayResult.h>
#include <aws/vpc-lattice/model/UpdateRuleRequest.h>
#include <aws/vpc-lattice/model/UpdateRuleResult.h>
#include <aws/vpc-lattice/model/UpdateServiceNetworkRequest.h>
#include <aws/vpc-lattice/model/UpdateServiceNetworkResult.h>
#include <aws/vpc-lattice/model/UpdateServiceNetworkVpcAssociationRequest.h>
#include <aws/vpc-lattice/model/UpdateServiceNetworkVpcAssociationResult.h>
#include <aws/vpc-lattice/model/UpdateServiceRequest.h>
#include <aws/vpc-lattice/model/UpdateServiceResult.h>
#include <aws/vpc-lattice/model/UpdateTargetGroupRequest.h>
#include <aws/vpc-lattice/model/UpdateTargetGroupResult.h>
#include <aws/vpc-lattice/model/ValidationException.h>
#include <aws/vpc-lattice/model/ValidationExceptionField.h>
#include <aws/vpc-lattice/model/ValidationExceptionReason.h>
#include <aws/vpc-lattice/model/WeightedTargetGroup.h>

using VPCLatticeIncludeTest = ::testing::Test;

TEST_F(VPCLatticeIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::VPCLattice::VPCLatticeClient>("VPCLatticeIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
