/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/waf-regional/WAFRegionalClient.h>
#include <aws/waf-regional/WAFRegionalEndpointProvider.h>
#include <aws/waf-regional/WAFRegionalEndpointRules.h>
#include <aws/waf-regional/WAFRegionalErrorMarshaller.h>
#include <aws/waf-regional/WAFRegionalErrors.h>
#include <aws/waf-regional/WAFRegionalRequest.h>
#include <aws/waf-regional/WAFRegionalServiceClientModel.h>
#include <aws/waf-regional/WAFRegional_EXPORTS.h>
#include <aws/waf-regional/model/ActivatedRule.h>
#include <aws/waf-regional/model/AssociateWebACLRequest.h>
#include <aws/waf-regional/model/AssociateWebACLResult.h>
#include <aws/waf-regional/model/ByteMatchSet.h>
#include <aws/waf-regional/model/ByteMatchSetSummary.h>
#include <aws/waf-regional/model/ByteMatchSetUpdate.h>
#include <aws/waf-regional/model/ByteMatchTuple.h>
#include <aws/waf-regional/model/ChangeAction.h>
#include <aws/waf-regional/model/ChangeTokenStatus.h>
#include <aws/waf-regional/model/ComparisonOperator.h>
#include <aws/waf-regional/model/CreateByteMatchSetRequest.h>
#include <aws/waf-regional/model/CreateByteMatchSetResult.h>
#include <aws/waf-regional/model/CreateGeoMatchSetRequest.h>
#include <aws/waf-regional/model/CreateGeoMatchSetResult.h>
#include <aws/waf-regional/model/CreateIPSetRequest.h>
#include <aws/waf-regional/model/CreateIPSetResult.h>
#include <aws/waf-regional/model/CreateRateBasedRuleRequest.h>
#include <aws/waf-regional/model/CreateRateBasedRuleResult.h>
#include <aws/waf-regional/model/CreateRegexMatchSetRequest.h>
#include <aws/waf-regional/model/CreateRegexMatchSetResult.h>
#include <aws/waf-regional/model/CreateRegexPatternSetRequest.h>
#include <aws/waf-regional/model/CreateRegexPatternSetResult.h>
#include <aws/waf-regional/model/CreateRuleGroupRequest.h>
#include <aws/waf-regional/model/CreateRuleGroupResult.h>
#include <aws/waf-regional/model/CreateRuleRequest.h>
#include <aws/waf-regional/model/CreateRuleResult.h>
#include <aws/waf-regional/model/CreateSizeConstraintSetRequest.h>
#include <aws/waf-regional/model/CreateSizeConstraintSetResult.h>
#include <aws/waf-regional/model/CreateSqlInjectionMatchSetRequest.h>
#include <aws/waf-regional/model/CreateSqlInjectionMatchSetResult.h>
#include <aws/waf-regional/model/CreateWebACLMigrationStackRequest.h>
#include <aws/waf-regional/model/CreateWebACLMigrationStackResult.h>
#include <aws/waf-regional/model/CreateWebACLRequest.h>
#include <aws/waf-regional/model/CreateWebACLResult.h>
#include <aws/waf-regional/model/CreateXssMatchSetRequest.h>
#include <aws/waf-regional/model/CreateXssMatchSetResult.h>
#include <aws/waf-regional/model/DeleteByteMatchSetRequest.h>
#include <aws/waf-regional/model/DeleteByteMatchSetResult.h>
#include <aws/waf-regional/model/DeleteGeoMatchSetRequest.h>
#include <aws/waf-regional/model/DeleteGeoMatchSetResult.h>
#include <aws/waf-regional/model/DeleteIPSetRequest.h>
#include <aws/waf-regional/model/DeleteIPSetResult.h>
#include <aws/waf-regional/model/DeleteLoggingConfigurationRequest.h>
#include <aws/waf-regional/model/DeleteLoggingConfigurationResult.h>
#include <aws/waf-regional/model/DeletePermissionPolicyRequest.h>
#include <aws/waf-regional/model/DeletePermissionPolicyResult.h>
#include <aws/waf-regional/model/DeleteRateBasedRuleRequest.h>
#include <aws/waf-regional/model/DeleteRateBasedRuleResult.h>
#include <aws/waf-regional/model/DeleteRegexMatchSetRequest.h>
#include <aws/waf-regional/model/DeleteRegexMatchSetResult.h>
#include <aws/waf-regional/model/DeleteRegexPatternSetRequest.h>
#include <aws/waf-regional/model/DeleteRegexPatternSetResult.h>
#include <aws/waf-regional/model/DeleteRuleGroupRequest.h>
#include <aws/waf-regional/model/DeleteRuleGroupResult.h>
#include <aws/waf-regional/model/DeleteRuleRequest.h>
#include <aws/waf-regional/model/DeleteRuleResult.h>
#include <aws/waf-regional/model/DeleteSizeConstraintSetRequest.h>
#include <aws/waf-regional/model/DeleteSizeConstraintSetResult.h>
#include <aws/waf-regional/model/DeleteSqlInjectionMatchSetRequest.h>
#include <aws/waf-regional/model/DeleteSqlInjectionMatchSetResult.h>
#include <aws/waf-regional/model/DeleteWebACLRequest.h>
#include <aws/waf-regional/model/DeleteWebACLResult.h>
#include <aws/waf-regional/model/DeleteXssMatchSetRequest.h>
#include <aws/waf-regional/model/DeleteXssMatchSetResult.h>
#include <aws/waf-regional/model/DisassociateWebACLRequest.h>
#include <aws/waf-regional/model/DisassociateWebACLResult.h>
#include <aws/waf-regional/model/ExcludedRule.h>
#include <aws/waf-regional/model/FieldToMatch.h>
#include <aws/waf-regional/model/GeoMatchConstraint.h>
#include <aws/waf-regional/model/GeoMatchConstraintType.h>
#include <aws/waf-regional/model/GeoMatchConstraintValue.h>
#include <aws/waf-regional/model/GeoMatchSet.h>
#include <aws/waf-regional/model/GeoMatchSetSummary.h>
#include <aws/waf-regional/model/GeoMatchSetUpdate.h>
#include <aws/waf-regional/model/GetByteMatchSetRequest.h>
#include <aws/waf-regional/model/GetByteMatchSetResult.h>
#include <aws/waf-regional/model/GetChangeTokenRequest.h>
#include <aws/waf-regional/model/GetChangeTokenResult.h>
#include <aws/waf-regional/model/GetChangeTokenStatusRequest.h>
#include <aws/waf-regional/model/GetChangeTokenStatusResult.h>
#include <aws/waf-regional/model/GetGeoMatchSetRequest.h>
#include <aws/waf-regional/model/GetGeoMatchSetResult.h>
#include <aws/waf-regional/model/GetIPSetRequest.h>
#include <aws/waf-regional/model/GetIPSetResult.h>
#include <aws/waf-regional/model/GetLoggingConfigurationRequest.h>
#include <aws/waf-regional/model/GetLoggingConfigurationResult.h>
#include <aws/waf-regional/model/GetPermissionPolicyRequest.h>
#include <aws/waf-regional/model/GetPermissionPolicyResult.h>
#include <aws/waf-regional/model/GetRateBasedRuleManagedKeysRequest.h>
#include <aws/waf-regional/model/GetRateBasedRuleManagedKeysResult.h>
#include <aws/waf-regional/model/GetRateBasedRuleRequest.h>
#include <aws/waf-regional/model/GetRateBasedRuleResult.h>
#include <aws/waf-regional/model/GetRegexMatchSetRequest.h>
#include <aws/waf-regional/model/GetRegexMatchSetResult.h>
#include <aws/waf-regional/model/GetRegexPatternSetRequest.h>
#include <aws/waf-regional/model/GetRegexPatternSetResult.h>
#include <aws/waf-regional/model/GetRuleGroupRequest.h>
#include <aws/waf-regional/model/GetRuleGroupResult.h>
#include <aws/waf-regional/model/GetRuleRequest.h>
#include <aws/waf-regional/model/GetRuleResult.h>
#include <aws/waf-regional/model/GetSampledRequestsRequest.h>
#include <aws/waf-regional/model/GetSampledRequestsResult.h>
#include <aws/waf-regional/model/GetSizeConstraintSetRequest.h>
#include <aws/waf-regional/model/GetSizeConstraintSetResult.h>
#include <aws/waf-regional/model/GetSqlInjectionMatchSetRequest.h>
#include <aws/waf-regional/model/GetSqlInjectionMatchSetResult.h>
#include <aws/waf-regional/model/GetWebACLForResourceRequest.h>
#include <aws/waf-regional/model/GetWebACLForResourceResult.h>
#include <aws/waf-regional/model/GetWebACLRequest.h>
#include <aws/waf-regional/model/GetWebACLResult.h>
#include <aws/waf-regional/model/GetXssMatchSetRequest.h>
#include <aws/waf-regional/model/GetXssMatchSetResult.h>
#include <aws/waf-regional/model/HTTPHeader.h>
#include <aws/waf-regional/model/HTTPRequest.h>
#include <aws/waf-regional/model/IPSet.h>
#include <aws/waf-regional/model/IPSetDescriptor.h>
#include <aws/waf-regional/model/IPSetDescriptorType.h>
#include <aws/waf-regional/model/IPSetSummary.h>
#include <aws/waf-regional/model/IPSetUpdate.h>
#include <aws/waf-regional/model/ListActivatedRulesInRuleGroupRequest.h>
#include <aws/waf-regional/model/ListActivatedRulesInRuleGroupResult.h>
#include <aws/waf-regional/model/ListByteMatchSetsRequest.h>
#include <aws/waf-regional/model/ListByteMatchSetsResult.h>
#include <aws/waf-regional/model/ListGeoMatchSetsRequest.h>
#include <aws/waf-regional/model/ListGeoMatchSetsResult.h>
#include <aws/waf-regional/model/ListIPSetsRequest.h>
#include <aws/waf-regional/model/ListIPSetsResult.h>
#include <aws/waf-regional/model/ListLoggingConfigurationsRequest.h>
#include <aws/waf-regional/model/ListLoggingConfigurationsResult.h>
#include <aws/waf-regional/model/ListRateBasedRulesRequest.h>
#include <aws/waf-regional/model/ListRateBasedRulesResult.h>
#include <aws/waf-regional/model/ListRegexMatchSetsRequest.h>
#include <aws/waf-regional/model/ListRegexMatchSetsResult.h>
#include <aws/waf-regional/model/ListRegexPatternSetsRequest.h>
#include <aws/waf-regional/model/ListRegexPatternSetsResult.h>
#include <aws/waf-regional/model/ListResourcesForWebACLRequest.h>
#include <aws/waf-regional/model/ListResourcesForWebACLResult.h>
#include <aws/waf-regional/model/ListRuleGroupsRequest.h>
#include <aws/waf-regional/model/ListRuleGroupsResult.h>
#include <aws/waf-regional/model/ListRulesRequest.h>
#include <aws/waf-regional/model/ListRulesResult.h>
#include <aws/waf-regional/model/ListSizeConstraintSetsRequest.h>
#include <aws/waf-regional/model/ListSizeConstraintSetsResult.h>
#include <aws/waf-regional/model/ListSqlInjectionMatchSetsRequest.h>
#include <aws/waf-regional/model/ListSqlInjectionMatchSetsResult.h>
#include <aws/waf-regional/model/ListSubscribedRuleGroupsRequest.h>
#include <aws/waf-regional/model/ListSubscribedRuleGroupsResult.h>
#include <aws/waf-regional/model/ListTagsForResourceRequest.h>
#include <aws/waf-regional/model/ListTagsForResourceResult.h>
#include <aws/waf-regional/model/ListWebACLsRequest.h>
#include <aws/waf-regional/model/ListWebACLsResult.h>
#include <aws/waf-regional/model/ListXssMatchSetsRequest.h>
#include <aws/waf-regional/model/ListXssMatchSetsResult.h>
#include <aws/waf-regional/model/LoggingConfiguration.h>
#include <aws/waf-regional/model/MatchFieldType.h>
#include <aws/waf-regional/model/MigrationErrorType.h>
#include <aws/waf-regional/model/ParameterExceptionField.h>
#include <aws/waf-regional/model/ParameterExceptionReason.h>
#include <aws/waf-regional/model/PositionalConstraint.h>
#include <aws/waf-regional/model/Predicate.h>
#include <aws/waf-regional/model/PredicateType.h>
#include <aws/waf-regional/model/PutLoggingConfigurationRequest.h>
#include <aws/waf-regional/model/PutLoggingConfigurationResult.h>
#include <aws/waf-regional/model/PutPermissionPolicyRequest.h>
#include <aws/waf-regional/model/PutPermissionPolicyResult.h>
#include <aws/waf-regional/model/RateBasedRule.h>
#include <aws/waf-regional/model/RateKey.h>
#include <aws/waf-regional/model/RegexMatchSet.h>
#include <aws/waf-regional/model/RegexMatchSetSummary.h>
#include <aws/waf-regional/model/RegexMatchSetUpdate.h>
#include <aws/waf-regional/model/RegexMatchTuple.h>
#include <aws/waf-regional/model/RegexPatternSet.h>
#include <aws/waf-regional/model/RegexPatternSetSummary.h>
#include <aws/waf-regional/model/RegexPatternSetUpdate.h>
#include <aws/waf-regional/model/ResourceType.h>
#include <aws/waf-regional/model/Rule.h>
#include <aws/waf-regional/model/RuleGroup.h>
#include <aws/waf-regional/model/RuleGroupSummary.h>
#include <aws/waf-regional/model/RuleGroupUpdate.h>
#include <aws/waf-regional/model/RuleSummary.h>
#include <aws/waf-regional/model/RuleUpdate.h>
#include <aws/waf-regional/model/SampledHTTPRequest.h>
#include <aws/waf-regional/model/SizeConstraint.h>
#include <aws/waf-regional/model/SizeConstraintSet.h>
#include <aws/waf-regional/model/SizeConstraintSetSummary.h>
#include <aws/waf-regional/model/SizeConstraintSetUpdate.h>
#include <aws/waf-regional/model/SqlInjectionMatchSet.h>
#include <aws/waf-regional/model/SqlInjectionMatchSetSummary.h>
#include <aws/waf-regional/model/SqlInjectionMatchSetUpdate.h>
#include <aws/waf-regional/model/SqlInjectionMatchTuple.h>
#include <aws/waf-regional/model/SubscribedRuleGroupSummary.h>
#include <aws/waf-regional/model/Tag.h>
#include <aws/waf-regional/model/TagInfoForResource.h>
#include <aws/waf-regional/model/TagResourceRequest.h>
#include <aws/waf-regional/model/TagResourceResult.h>
#include <aws/waf-regional/model/TextTransformation.h>
#include <aws/waf-regional/model/TimeWindow.h>
#include <aws/waf-regional/model/UntagResourceRequest.h>
#include <aws/waf-regional/model/UntagResourceResult.h>
#include <aws/waf-regional/model/UpdateByteMatchSetRequest.h>
#include <aws/waf-regional/model/UpdateByteMatchSetResult.h>
#include <aws/waf-regional/model/UpdateGeoMatchSetRequest.h>
#include <aws/waf-regional/model/UpdateGeoMatchSetResult.h>
#include <aws/waf-regional/model/UpdateIPSetRequest.h>
#include <aws/waf-regional/model/UpdateIPSetResult.h>
#include <aws/waf-regional/model/UpdateRateBasedRuleRequest.h>
#include <aws/waf-regional/model/UpdateRateBasedRuleResult.h>
#include <aws/waf-regional/model/UpdateRegexMatchSetRequest.h>
#include <aws/waf-regional/model/UpdateRegexMatchSetResult.h>
#include <aws/waf-regional/model/UpdateRegexPatternSetRequest.h>
#include <aws/waf-regional/model/UpdateRegexPatternSetResult.h>
#include <aws/waf-regional/model/UpdateRuleGroupRequest.h>
#include <aws/waf-regional/model/UpdateRuleGroupResult.h>
#include <aws/waf-regional/model/UpdateRuleRequest.h>
#include <aws/waf-regional/model/UpdateRuleResult.h>
#include <aws/waf-regional/model/UpdateSizeConstraintSetRequest.h>
#include <aws/waf-regional/model/UpdateSizeConstraintSetResult.h>
#include <aws/waf-regional/model/UpdateSqlInjectionMatchSetRequest.h>
#include <aws/waf-regional/model/UpdateSqlInjectionMatchSetResult.h>
#include <aws/waf-regional/model/UpdateWebACLRequest.h>
#include <aws/waf-regional/model/UpdateWebACLResult.h>
#include <aws/waf-regional/model/UpdateXssMatchSetRequest.h>
#include <aws/waf-regional/model/UpdateXssMatchSetResult.h>
#include <aws/waf-regional/model/WAFEntityMigrationException.h>
#include <aws/waf-regional/model/WAFInvalidParameterException.h>
#include <aws/waf-regional/model/WafAction.h>
#include <aws/waf-regional/model/WafActionType.h>
#include <aws/waf-regional/model/WafOverrideAction.h>
#include <aws/waf-regional/model/WafOverrideActionType.h>
#include <aws/waf-regional/model/WafRuleType.h>
#include <aws/waf-regional/model/WebACL.h>
#include <aws/waf-regional/model/WebACLSummary.h>
#include <aws/waf-regional/model/WebACLUpdate.h>
#include <aws/waf-regional/model/XssMatchSet.h>
#include <aws/waf-regional/model/XssMatchSetSummary.h>
#include <aws/waf-regional/model/XssMatchSetUpdate.h>
#include <aws/waf-regional/model/XssMatchTuple.h>

using WAFRegionalIncludeTest = ::testing::Test;

TEST_F(WAFRegionalIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::WAFRegional::WAFRegionalClient>("WAFRegionalIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
