/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/wafv2/WAFV2Client.h>
#include <aws/wafv2/WAFV2EndpointProvider.h>
#include <aws/wafv2/WAFV2EndpointRules.h>
#include <aws/wafv2/WAFV2ErrorMarshaller.h>
#include <aws/wafv2/WAFV2Errors.h>
#include <aws/wafv2/WAFV2Request.h>
#include <aws/wafv2/WAFV2ServiceClientModel.h>
#include <aws/wafv2/WAFV2_EXPORTS.h>
#include <aws/wafv2/model/APIKeySummary.h>
#include <aws/wafv2/model/AWSManagedRulesACFPRuleSet.h>
#include <aws/wafv2/model/AWSManagedRulesATPRuleSet.h>
#include <aws/wafv2/model/AWSManagedRulesAntiDDoSRuleSet.h>
#include <aws/wafv2/model/AWSManagedRulesBotControlRuleSet.h>
#include <aws/wafv2/model/ActionCondition.h>
#include <aws/wafv2/model/ActionValue.h>
#include <aws/wafv2/model/AddressField.h>
#include <aws/wafv2/model/All.h>
#include <aws/wafv2/model/AllQueryArguments.h>
#include <aws/wafv2/model/AllowAction.h>
#include <aws/wafv2/model/AndStatement.h>
#include <aws/wafv2/model/ApplicationAttribute.h>
#include <aws/wafv2/model/ApplicationConfig.h>
#include <aws/wafv2/model/AsnMatchStatement.h>
#include <aws/wafv2/model/AssociateWebACLRequest.h>
#include <aws/wafv2/model/AssociateWebACLResult.h>
#include <aws/wafv2/model/AssociatedResourceType.h>
#include <aws/wafv2/model/AssociationConfig.h>
#include <aws/wafv2/model/BlockAction.h>
#include <aws/wafv2/model/Body.h>
#include <aws/wafv2/model/BodyParsingFallbackBehavior.h>
#include <aws/wafv2/model/ByteMatchStatement.h>
#include <aws/wafv2/model/CaptchaAction.h>
#include <aws/wafv2/model/CaptchaConfig.h>
#include <aws/wafv2/model/CaptchaResponse.h>
#include <aws/wafv2/model/ChallengeAction.h>
#include <aws/wafv2/model/ChallengeConfig.h>
#include <aws/wafv2/model/ChallengeResponse.h>
#include <aws/wafv2/model/CheckCapacityRequest.h>
#include <aws/wafv2/model/CheckCapacityResult.h>
#include <aws/wafv2/model/ClientSideAction.h>
#include <aws/wafv2/model/ClientSideActionConfig.h>
#include <aws/wafv2/model/ComparisonOperator.h>
#include <aws/wafv2/model/Condition.h>
#include <aws/wafv2/model/CookieMatchPattern.h>
#include <aws/wafv2/model/Cookies.h>
#include <aws/wafv2/model/CountAction.h>
#include <aws/wafv2/model/CountryCode.h>
#include <aws/wafv2/model/CreateAPIKeyRequest.h>
#include <aws/wafv2/model/CreateAPIKeyResult.h>
#include <aws/wafv2/model/CreateIPSetRequest.h>
#include <aws/wafv2/model/CreateIPSetResult.h>
#include <aws/wafv2/model/CreateRegexPatternSetRequest.h>
#include <aws/wafv2/model/CreateRegexPatternSetResult.h>
#include <aws/wafv2/model/CreateRuleGroupRequest.h>
#include <aws/wafv2/model/CreateRuleGroupResult.h>
#include <aws/wafv2/model/CreateWebACLRequest.h>
#include <aws/wafv2/model/CreateWebACLResult.h>
#include <aws/wafv2/model/CustomHTTPHeader.h>
#include <aws/wafv2/model/CustomRequestHandling.h>
#include <aws/wafv2/model/CustomResponse.h>
#include <aws/wafv2/model/CustomResponseBody.h>
#include <aws/wafv2/model/DataProtection.h>
#include <aws/wafv2/model/DataProtectionAction.h>
#include <aws/wafv2/model/DataProtectionConfig.h>
#include <aws/wafv2/model/DefaultAction.h>
#include <aws/wafv2/model/DeleteAPIKeyRequest.h>
#include <aws/wafv2/model/DeleteAPIKeyResult.h>
#include <aws/wafv2/model/DeleteFirewallManagerRuleGroupsRequest.h>
#include <aws/wafv2/model/DeleteFirewallManagerRuleGroupsResult.h>
#include <aws/wafv2/model/DeleteIPSetRequest.h>
#include <aws/wafv2/model/DeleteIPSetResult.h>
#include <aws/wafv2/model/DeleteLoggingConfigurationRequest.h>
#include <aws/wafv2/model/DeleteLoggingConfigurationResult.h>
#include <aws/wafv2/model/DeletePermissionPolicyRequest.h>
#include <aws/wafv2/model/DeletePermissionPolicyResult.h>
#include <aws/wafv2/model/DeleteRegexPatternSetRequest.h>
#include <aws/wafv2/model/DeleteRegexPatternSetResult.h>
#include <aws/wafv2/model/DeleteRuleGroupRequest.h>
#include <aws/wafv2/model/DeleteRuleGroupResult.h>
#include <aws/wafv2/model/DeleteWebACLRequest.h>
#include <aws/wafv2/model/DeleteWebACLResult.h>
#include <aws/wafv2/model/DescribeAllManagedProductsRequest.h>
#include <aws/wafv2/model/DescribeAllManagedProductsResult.h>
#include <aws/wafv2/model/DescribeManagedProductsByVendorRequest.h>
#include <aws/wafv2/model/DescribeManagedProductsByVendorResult.h>
#include <aws/wafv2/model/DescribeManagedRuleGroupRequest.h>
#include <aws/wafv2/model/DescribeManagedRuleGroupResult.h>
#include <aws/wafv2/model/DisassociateWebACLRequest.h>
#include <aws/wafv2/model/DisassociateWebACLResult.h>
#include <aws/wafv2/model/EmailField.h>
#include <aws/wafv2/model/ExcludedRule.h>
#include <aws/wafv2/model/FailureReason.h>
#include <aws/wafv2/model/FallbackBehavior.h>
#include <aws/wafv2/model/FieldToMatch.h>
#include <aws/wafv2/model/FieldToProtect.h>
#include <aws/wafv2/model/FieldToProtectType.h>
#include <aws/wafv2/model/Filter.h>
#include <aws/wafv2/model/FilterBehavior.h>
#include <aws/wafv2/model/FilterRequirement.h>
#include <aws/wafv2/model/FirewallManagerRuleGroup.h>
#include <aws/wafv2/model/FirewallManagerStatement.h>
#include <aws/wafv2/model/ForwardedIPConfig.h>
#include <aws/wafv2/model/ForwardedIPPosition.h>
#include <aws/wafv2/model/GenerateMobileSdkReleaseUrlRequest.h>
#include <aws/wafv2/model/GenerateMobileSdkReleaseUrlResult.h>
#include <aws/wafv2/model/GeoMatchStatement.h>
#include <aws/wafv2/model/GetDecryptedAPIKeyRequest.h>
#include <aws/wafv2/model/GetDecryptedAPIKeyResult.h>
#include <aws/wafv2/model/GetIPSetRequest.h>
#include <aws/wafv2/model/GetIPSetResult.h>
#include <aws/wafv2/model/GetLoggingConfigurationRequest.h>
#include <aws/wafv2/model/GetLoggingConfigurationResult.h>
#include <aws/wafv2/model/GetManagedRuleSetRequest.h>
#include <aws/wafv2/model/GetManagedRuleSetResult.h>
#include <aws/wafv2/model/GetMobileSdkReleaseRequest.h>
#include <aws/wafv2/model/GetMobileSdkReleaseResult.h>
#include <aws/wafv2/model/GetPermissionPolicyRequest.h>
#include <aws/wafv2/model/GetPermissionPolicyResult.h>
#include <aws/wafv2/model/GetRateBasedStatementManagedKeysRequest.h>
#include <aws/wafv2/model/GetRateBasedStatementManagedKeysResult.h>
#include <aws/wafv2/model/GetRegexPatternSetRequest.h>
#include <aws/wafv2/model/GetRegexPatternSetResult.h>
#include <aws/wafv2/model/GetRuleGroupRequest.h>
#include <aws/wafv2/model/GetRuleGroupResult.h>
#include <aws/wafv2/model/GetSampledRequestsRequest.h>
#include <aws/wafv2/model/GetSampledRequestsResult.h>
#include <aws/wafv2/model/GetWebACLForResourceRequest.h>
#include <aws/wafv2/model/GetWebACLForResourceResult.h>
#include <aws/wafv2/model/GetWebACLRequest.h>
#include <aws/wafv2/model/GetWebACLResult.h>
#include <aws/wafv2/model/HTTPHeader.h>
#include <aws/wafv2/model/HTTPRequest.h>
#include <aws/wafv2/model/HeaderMatchPattern.h>
#include <aws/wafv2/model/HeaderOrder.h>
#include <aws/wafv2/model/Headers.h>
#include <aws/wafv2/model/IPAddressVersion.h>
#include <aws/wafv2/model/IPSet.h>
#include <aws/wafv2/model/IPSetForwardedIPConfig.h>
#include <aws/wafv2/model/IPSetReferenceStatement.h>
#include <aws/wafv2/model/IPSetSummary.h>
#include <aws/wafv2/model/ImmunityTimeProperty.h>
#include <aws/wafv2/model/InspectionLevel.h>
#include <aws/wafv2/model/JA3Fingerprint.h>
#include <aws/wafv2/model/JA4Fingerprint.h>
#include <aws/wafv2/model/JsonBody.h>
#include <aws/wafv2/model/JsonMatchPattern.h>
#include <aws/wafv2/model/JsonMatchScope.h>
#include <aws/wafv2/model/Label.h>
#include <aws/wafv2/model/LabelMatchScope.h>
#include <aws/wafv2/model/LabelMatchStatement.h>
#include <aws/wafv2/model/LabelNameCondition.h>
#include <aws/wafv2/model/LabelSummary.h>
#include <aws/wafv2/model/ListAPIKeysRequest.h>
#include <aws/wafv2/model/ListAPIKeysResult.h>
#include <aws/wafv2/model/ListAvailableManagedRuleGroupVersionsRequest.h>
#include <aws/wafv2/model/ListAvailableManagedRuleGroupVersionsResult.h>
#include <aws/wafv2/model/ListAvailableManagedRuleGroupsRequest.h>
#include <aws/wafv2/model/ListAvailableManagedRuleGroupsResult.h>
#include <aws/wafv2/model/ListIPSetsRequest.h>
#include <aws/wafv2/model/ListIPSetsResult.h>
#include <aws/wafv2/model/ListLoggingConfigurationsRequest.h>
#include <aws/wafv2/model/ListLoggingConfigurationsResult.h>
#include <aws/wafv2/model/ListManagedRuleSetsRequest.h>
#include <aws/wafv2/model/ListManagedRuleSetsResult.h>
#include <aws/wafv2/model/ListMobileSdkReleasesRequest.h>
#include <aws/wafv2/model/ListMobileSdkReleasesResult.h>
#include <aws/wafv2/model/ListRegexPatternSetsRequest.h>
#include <aws/wafv2/model/ListRegexPatternSetsResult.h>
#include <aws/wafv2/model/ListResourcesForWebACLRequest.h>
#include <aws/wafv2/model/ListResourcesForWebACLResult.h>
#include <aws/wafv2/model/ListRuleGroupsRequest.h>
#include <aws/wafv2/model/ListRuleGroupsResult.h>
#include <aws/wafv2/model/ListTagsForResourceRequest.h>
#include <aws/wafv2/model/ListTagsForResourceResult.h>
#include <aws/wafv2/model/ListWebACLsRequest.h>
#include <aws/wafv2/model/ListWebACLsResult.h>
#include <aws/wafv2/model/LogScope.h>
#include <aws/wafv2/model/LogType.h>
#include <aws/wafv2/model/LoggingConfiguration.h>
#include <aws/wafv2/model/LoggingFilter.h>
#include <aws/wafv2/model/LowReputationMode.h>
#include <aws/wafv2/model/ManagedProductDescriptor.h>
#include <aws/wafv2/model/ManagedRuleGroupConfig.h>
#include <aws/wafv2/model/ManagedRuleGroupStatement.h>
#include <aws/wafv2/model/ManagedRuleGroupSummary.h>
#include <aws/wafv2/model/ManagedRuleGroupVersion.h>
#include <aws/wafv2/model/ManagedRuleSet.h>
#include <aws/wafv2/model/ManagedRuleSetSummary.h>
#include <aws/wafv2/model/ManagedRuleSetVersion.h>
#include <aws/wafv2/model/MapMatchScope.h>
#include <aws/wafv2/model/Method.h>
#include <aws/wafv2/model/MobileSdkRelease.h>
#include <aws/wafv2/model/NoneAction.h>
#include <aws/wafv2/model/NotStatement.h>
#include <aws/wafv2/model/OnSourceDDoSProtectionConfig.h>
#include <aws/wafv2/model/OrStatement.h>
#include <aws/wafv2/model/OverrideAction.h>
#include <aws/wafv2/model/OversizeHandling.h>
#include <aws/wafv2/model/ParameterExceptionField.h>
#include <aws/wafv2/model/PasswordField.h>
#include <aws/wafv2/model/PayloadType.h>
#include <aws/wafv2/model/PhoneNumberField.h>
#include <aws/wafv2/model/Platform.h>
#include <aws/wafv2/model/PositionalConstraint.h>
#include <aws/wafv2/model/PutLoggingConfigurationRequest.h>
#include <aws/wafv2/model/PutLoggingConfigurationResult.h>
#include <aws/wafv2/model/PutManagedRuleSetVersionsRequest.h>
#include <aws/wafv2/model/PutManagedRuleSetVersionsResult.h>
#include <aws/wafv2/model/PutPermissionPolicyRequest.h>
#include <aws/wafv2/model/PutPermissionPolicyResult.h>
#include <aws/wafv2/model/QueryString.h>
#include <aws/wafv2/model/RateBasedStatement.h>
#include <aws/wafv2/model/RateBasedStatementAggregateKeyType.h>
#include <aws/wafv2/model/RateBasedStatementCustomKey.h>
#include <aws/wafv2/model/RateBasedStatementManagedKeysIPSet.h>
#include <aws/wafv2/model/RateLimitAsn.h>
#include <aws/wafv2/model/RateLimitCookie.h>
#include <aws/wafv2/model/RateLimitForwardedIP.h>
#include <aws/wafv2/model/RateLimitHTTPMethod.h>
#include <aws/wafv2/model/RateLimitHeader.h>
#include <aws/wafv2/model/RateLimitIP.h>
#include <aws/wafv2/model/RateLimitJA3Fingerprint.h>
#include <aws/wafv2/model/RateLimitJA4Fingerprint.h>
#include <aws/wafv2/model/RateLimitLabelNamespace.h>
#include <aws/wafv2/model/RateLimitQueryArgument.h>
#include <aws/wafv2/model/RateLimitQueryString.h>
#include <aws/wafv2/model/RateLimitUriPath.h>
#include <aws/wafv2/model/Regex.h>
#include <aws/wafv2/model/RegexMatchStatement.h>
#include <aws/wafv2/model/RegexPatternSet.h>
#include <aws/wafv2/model/RegexPatternSetReferenceStatement.h>
#include <aws/wafv2/model/RegexPatternSetSummary.h>
#include <aws/wafv2/model/ReleaseSummary.h>
#include <aws/wafv2/model/RequestBodyAssociatedResourceTypeConfig.h>
#include <aws/wafv2/model/RequestInspection.h>
#include <aws/wafv2/model/RequestInspectionACFP.h>
#include <aws/wafv2/model/ResourceType.h>
#include <aws/wafv2/model/ResponseContentType.h>
#include <aws/wafv2/model/ResponseInspection.h>
#include <aws/wafv2/model/ResponseInspectionBodyContains.h>
#include <aws/wafv2/model/ResponseInspectionHeader.h>
#include <aws/wafv2/model/ResponseInspectionJson.h>
#include <aws/wafv2/model/ResponseInspectionStatusCode.h>
#include <aws/wafv2/model/Rule.h>
#include <aws/wafv2/model/RuleAction.h>
#include <aws/wafv2/model/RuleActionOverride.h>
#include <aws/wafv2/model/RuleGroup.h>
#include <aws/wafv2/model/RuleGroupReferenceStatement.h>
#include <aws/wafv2/model/RuleGroupSummary.h>
#include <aws/wafv2/model/RuleSummary.h>
#include <aws/wafv2/model/SampledHTTPRequest.h>
#include <aws/wafv2/model/Scope.h>
#include <aws/wafv2/model/SensitivityLevel.h>
#include <aws/wafv2/model/SensitivityToAct.h>
#include <aws/wafv2/model/SingleHeader.h>
#include <aws/wafv2/model/SingleQueryArgument.h>
#include <aws/wafv2/model/SizeConstraintStatement.h>
#include <aws/wafv2/model/SizeInspectionLimit.h>
#include <aws/wafv2/model/SqliMatchStatement.h>
#include <aws/wafv2/model/Statement.h>
#include <aws/wafv2/model/Tag.h>
#include <aws/wafv2/model/TagInfoForResource.h>
#include <aws/wafv2/model/TagResourceRequest.h>
#include <aws/wafv2/model/TagResourceResult.h>
#include <aws/wafv2/model/TextTransformation.h>
#include <aws/wafv2/model/TextTransformationType.h>
#include <aws/wafv2/model/TimeWindow.h>
#include <aws/wafv2/model/UntagResourceRequest.h>
#include <aws/wafv2/model/UntagResourceResult.h>
#include <aws/wafv2/model/UpdateIPSetRequest.h>
#include <aws/wafv2/model/UpdateIPSetResult.h>
#include <aws/wafv2/model/UpdateManagedRuleSetVersionExpiryDateRequest.h>
#include <aws/wafv2/model/UpdateManagedRuleSetVersionExpiryDateResult.h>
#include <aws/wafv2/model/UpdateRegexPatternSetRequest.h>
#include <aws/wafv2/model/UpdateRegexPatternSetResult.h>
#include <aws/wafv2/model/UpdateRuleGroupRequest.h>
#include <aws/wafv2/model/UpdateRuleGroupResult.h>
#include <aws/wafv2/model/UpdateWebACLRequest.h>
#include <aws/wafv2/model/UpdateWebACLResult.h>
#include <aws/wafv2/model/UriFragment.h>
#include <aws/wafv2/model/UriPath.h>
#include <aws/wafv2/model/UsageOfAction.h>
#include <aws/wafv2/model/UsernameField.h>
#include <aws/wafv2/model/VersionToPublish.h>
#include <aws/wafv2/model/VisibilityConfig.h>
#include <aws/wafv2/model/WAFInvalidParameterException.h>
#include <aws/wafv2/model/WAFLimitsExceededException.h>
#include <aws/wafv2/model/WebACL.h>
#include <aws/wafv2/model/WebACLSummary.h>
#include <aws/wafv2/model/XssMatchStatement.h>

using WAFV2IncludeTest = ::testing::Test;

TEST_F(WAFV2IncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::WAFV2::WAFV2Client>("WAFV2IncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
