/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/wellarchitected/WellArchitectedClient.h>
#include <aws/wellarchitected/WellArchitectedEndpointProvider.h>
#include <aws/wellarchitected/WellArchitectedEndpointRules.h>
#include <aws/wellarchitected/WellArchitectedErrorMarshaller.h>
#include <aws/wellarchitected/WellArchitectedErrors.h>
#include <aws/wellarchitected/WellArchitectedRequest.h>
#include <aws/wellarchitected/WellArchitectedServiceClientModel.h>
#include <aws/wellarchitected/WellArchitected_EXPORTS.h>
#include <aws/wellarchitected/model/AccountJiraConfigurationInput.h>
#include <aws/wellarchitected/model/AccountJiraConfigurationOutput.h>
#include <aws/wellarchitected/model/AccountJiraIssueManagementStatus.h>
#include <aws/wellarchitected/model/AdditionalResourceType.h>
#include <aws/wellarchitected/model/AdditionalResources.h>
#include <aws/wellarchitected/model/Answer.h>
#include <aws/wellarchitected/model/AnswerReason.h>
#include <aws/wellarchitected/model/AnswerSummary.h>
#include <aws/wellarchitected/model/AssociateLensesRequest.h>
#include <aws/wellarchitected/model/AssociateProfilesRequest.h>
#include <aws/wellarchitected/model/BestPractice.h>
#include <aws/wellarchitected/model/CheckDetail.h>
#include <aws/wellarchitected/model/CheckFailureReason.h>
#include <aws/wellarchitected/model/CheckProvider.h>
#include <aws/wellarchitected/model/CheckStatus.h>
#include <aws/wellarchitected/model/CheckSummary.h>
#include <aws/wellarchitected/model/Choice.h>
#include <aws/wellarchitected/model/ChoiceAnswer.h>
#include <aws/wellarchitected/model/ChoiceAnswerSummary.h>
#include <aws/wellarchitected/model/ChoiceContent.h>
#include <aws/wellarchitected/model/ChoiceImprovementPlan.h>
#include <aws/wellarchitected/model/ChoiceReason.h>
#include <aws/wellarchitected/model/ChoiceStatus.h>
#include <aws/wellarchitected/model/ChoiceUpdate.h>
#include <aws/wellarchitected/model/ConflictException.h>
#include <aws/wellarchitected/model/ConsolidatedReportMetric.h>
#include <aws/wellarchitected/model/CreateLensShareRequest.h>
#include <aws/wellarchitected/model/CreateLensShareResult.h>
#include <aws/wellarchitected/model/CreateLensVersionRequest.h>
#include <aws/wellarchitected/model/CreateLensVersionResult.h>
#include <aws/wellarchitected/model/CreateMilestoneRequest.h>
#include <aws/wellarchitected/model/CreateMilestoneResult.h>
#include <aws/wellarchitected/model/CreateProfileRequest.h>
#include <aws/wellarchitected/model/CreateProfileResult.h>
#include <aws/wellarchitected/model/CreateProfileShareRequest.h>
#include <aws/wellarchitected/model/CreateProfileShareResult.h>
#include <aws/wellarchitected/model/CreateReviewTemplateRequest.h>
#include <aws/wellarchitected/model/CreateReviewTemplateResult.h>
#include <aws/wellarchitected/model/CreateTemplateShareRequest.h>
#include <aws/wellarchitected/model/CreateTemplateShareResult.h>
#include <aws/wellarchitected/model/CreateWorkloadRequest.h>
#include <aws/wellarchitected/model/CreateWorkloadResult.h>
#include <aws/wellarchitected/model/CreateWorkloadShareRequest.h>
#include <aws/wellarchitected/model/CreateWorkloadShareResult.h>
#include <aws/wellarchitected/model/DefinitionType.h>
#include <aws/wellarchitected/model/DeleteLensRequest.h>
#include <aws/wellarchitected/model/DeleteLensShareRequest.h>
#include <aws/wellarchitected/model/DeleteProfileRequest.h>
#include <aws/wellarchitected/model/DeleteProfileShareRequest.h>
#include <aws/wellarchitected/model/DeleteReviewTemplateRequest.h>
#include <aws/wellarchitected/model/DeleteTemplateShareRequest.h>
#include <aws/wellarchitected/model/DeleteWorkloadRequest.h>
#include <aws/wellarchitected/model/DeleteWorkloadShareRequest.h>
#include <aws/wellarchitected/model/DifferenceStatus.h>
#include <aws/wellarchitected/model/DisassociateLensesRequest.h>
#include <aws/wellarchitected/model/DisassociateProfilesRequest.h>
#include <aws/wellarchitected/model/DiscoveryIntegrationStatus.h>
#include <aws/wellarchitected/model/ExportLensRequest.h>
#include <aws/wellarchitected/model/ExportLensResult.h>
#include <aws/wellarchitected/model/GetAnswerRequest.h>
#include <aws/wellarchitected/model/GetAnswerResult.h>
#include <aws/wellarchitected/model/GetConsolidatedReportRequest.h>
#include <aws/wellarchitected/model/GetConsolidatedReportResult.h>
#include <aws/wellarchitected/model/GetGlobalSettingsRequest.h>
#include <aws/wellarchitected/model/GetGlobalSettingsResult.h>
#include <aws/wellarchitected/model/GetLensRequest.h>
#include <aws/wellarchitected/model/GetLensResult.h>
#include <aws/wellarchitected/model/GetLensReviewReportRequest.h>
#include <aws/wellarchitected/model/GetLensReviewReportResult.h>
#include <aws/wellarchitected/model/GetLensReviewRequest.h>
#include <aws/wellarchitected/model/GetLensReviewResult.h>
#include <aws/wellarchitected/model/GetLensVersionDifferenceRequest.h>
#include <aws/wellarchitected/model/GetLensVersionDifferenceResult.h>
#include <aws/wellarchitected/model/GetMilestoneRequest.h>
#include <aws/wellarchitected/model/GetMilestoneResult.h>
#include <aws/wellarchitected/model/GetProfileRequest.h>
#include <aws/wellarchitected/model/GetProfileResult.h>
#include <aws/wellarchitected/model/GetProfileTemplateRequest.h>
#include <aws/wellarchitected/model/GetProfileTemplateResult.h>
#include <aws/wellarchitected/model/GetReviewTemplateAnswerRequest.h>
#include <aws/wellarchitected/model/GetReviewTemplateAnswerResult.h>
#include <aws/wellarchitected/model/GetReviewTemplateLensReviewRequest.h>
#include <aws/wellarchitected/model/GetReviewTemplateLensReviewResult.h>
#include <aws/wellarchitected/model/GetReviewTemplateRequest.h>
#include <aws/wellarchitected/model/GetReviewTemplateResult.h>
#include <aws/wellarchitected/model/GetWorkloadRequest.h>
#include <aws/wellarchitected/model/GetWorkloadResult.h>
#include <aws/wellarchitected/model/ImportLensRequest.h>
#include <aws/wellarchitected/model/ImportLensResult.h>
#include <aws/wellarchitected/model/ImportLensStatus.h>
#include <aws/wellarchitected/model/ImprovementSummary.h>
#include <aws/wellarchitected/model/IntegratingService.h>
#include <aws/wellarchitected/model/IntegrationStatus.h>
#include <aws/wellarchitected/model/IntegrationStatusInput.h>
#include <aws/wellarchitected/model/IssueManagementType.h>
#include <aws/wellarchitected/model/JiraConfiguration.h>
#include <aws/wellarchitected/model/JiraSelectedQuestionConfiguration.h>
#include <aws/wellarchitected/model/Lens.h>
#include <aws/wellarchitected/model/LensMetric.h>
#include <aws/wellarchitected/model/LensReview.h>
#include <aws/wellarchitected/model/LensReviewReport.h>
#include <aws/wellarchitected/model/LensReviewSummary.h>
#include <aws/wellarchitected/model/LensShareSummary.h>
#include <aws/wellarchitected/model/LensStatus.h>
#include <aws/wellarchitected/model/LensStatusType.h>
#include <aws/wellarchitected/model/LensSummary.h>
#include <aws/wellarchitected/model/LensType.h>
#include <aws/wellarchitected/model/LensUpgradeSummary.h>
#include <aws/wellarchitected/model/ListAnswersRequest.h>
#include <aws/wellarchitected/model/ListAnswersResult.h>
#include <aws/wellarchitected/model/ListCheckDetailsRequest.h>
#include <aws/wellarchitected/model/ListCheckDetailsResult.h>
#include <aws/wellarchitected/model/ListCheckSummariesRequest.h>
#include <aws/wellarchitected/model/ListCheckSummariesResult.h>
#include <aws/wellarchitected/model/ListLensReviewImprovementsRequest.h>
#include <aws/wellarchitected/model/ListLensReviewImprovementsResult.h>
#include <aws/wellarchitected/model/ListLensReviewsRequest.h>
#include <aws/wellarchitected/model/ListLensReviewsResult.h>
#include <aws/wellarchitected/model/ListLensSharesRequest.h>
#include <aws/wellarchitected/model/ListLensSharesResult.h>
#include <aws/wellarchitected/model/ListLensesRequest.h>
#include <aws/wellarchitected/model/ListLensesResult.h>
#include <aws/wellarchitected/model/ListMilestonesRequest.h>
#include <aws/wellarchitected/model/ListMilestonesResult.h>
#include <aws/wellarchitected/model/ListNotificationsRequest.h>
#include <aws/wellarchitected/model/ListNotificationsResult.h>
#include <aws/wellarchitected/model/ListProfileNotificationsRequest.h>
#include <aws/wellarchitected/model/ListProfileNotificationsResult.h>
#include <aws/wellarchitected/model/ListProfileSharesRequest.h>
#include <aws/wellarchitected/model/ListProfileSharesResult.h>
#include <aws/wellarchitected/model/ListProfilesRequest.h>
#include <aws/wellarchitected/model/ListProfilesResult.h>
#include <aws/wellarchitected/model/ListReviewTemplateAnswersRequest.h>
#include <aws/wellarchitected/model/ListReviewTemplateAnswersResult.h>
#include <aws/wellarchitected/model/ListReviewTemplatesRequest.h>
#include <aws/wellarchitected/model/ListReviewTemplatesResult.h>
#include <aws/wellarchitected/model/ListShareInvitationsRequest.h>
#include <aws/wellarchitected/model/ListShareInvitationsResult.h>
#include <aws/wellarchitected/model/ListTagsForResourceRequest.h>
#include <aws/wellarchitected/model/ListTagsForResourceResult.h>
#include <aws/wellarchitected/model/ListTemplateSharesRequest.h>
#include <aws/wellarchitected/model/ListTemplateSharesResult.h>
#include <aws/wellarchitected/model/ListWorkloadSharesRequest.h>
#include <aws/wellarchitected/model/ListWorkloadSharesResult.h>
#include <aws/wellarchitected/model/ListWorkloadsRequest.h>
#include <aws/wellarchitected/model/ListWorkloadsResult.h>
#include <aws/wellarchitected/model/MetricType.h>
#include <aws/wellarchitected/model/Milestone.h>
#include <aws/wellarchitected/model/MilestoneSummary.h>
#include <aws/wellarchitected/model/NotificationSummary.h>
#include <aws/wellarchitected/model/NotificationType.h>
#include <aws/wellarchitected/model/OrganizationSharingStatus.h>
#include <aws/wellarchitected/model/PermissionType.h>
#include <aws/wellarchitected/model/PillarDifference.h>
#include <aws/wellarchitected/model/PillarMetric.h>
#include <aws/wellarchitected/model/PillarReviewSummary.h>
#include <aws/wellarchitected/model/Profile.h>
#include <aws/wellarchitected/model/ProfileChoice.h>
#include <aws/wellarchitected/model/ProfileNotificationSummary.h>
#include <aws/wellarchitected/model/ProfileNotificationType.h>
#include <aws/wellarchitected/model/ProfileOwnerType.h>
#include <aws/wellarchitected/model/ProfileQuestion.h>
#include <aws/wellarchitected/model/ProfileQuestionUpdate.h>
#include <aws/wellarchitected/model/ProfileShareSummary.h>
#include <aws/wellarchitected/model/ProfileSummary.h>
#include <aws/wellarchitected/model/ProfileTemplate.h>
#include <aws/wellarchitected/model/ProfileTemplateChoice.h>
#include <aws/wellarchitected/model/ProfileTemplateQuestion.h>
#include <aws/wellarchitected/model/Question.h>
#include <aws/wellarchitected/model/QuestionDifference.h>
#include <aws/wellarchitected/model/QuestionMetric.h>
#include <aws/wellarchitected/model/QuestionPriority.h>
#include <aws/wellarchitected/model/QuestionType.h>
#include <aws/wellarchitected/model/ReportFormat.h>
#include <aws/wellarchitected/model/ResourceNotFoundException.h>
#include <aws/wellarchitected/model/ReviewTemplate.h>
#include <aws/wellarchitected/model/ReviewTemplateAnswer.h>
#include <aws/wellarchitected/model/ReviewTemplateAnswerStatus.h>
#include <aws/wellarchitected/model/ReviewTemplateAnswerSummary.h>
#include <aws/wellarchitected/model/ReviewTemplateLensReview.h>
#include <aws/wellarchitected/model/ReviewTemplatePillarReviewSummary.h>
#include <aws/wellarchitected/model/ReviewTemplateSummary.h>
#include <aws/wellarchitected/model/ReviewTemplateUpdateStatus.h>
#include <aws/wellarchitected/model/Risk.h>
#include <aws/wellarchitected/model/SelectedPillar.h>
#include <aws/wellarchitected/model/ServiceQuotaExceededException.h>
#include <aws/wellarchitected/model/ShareInvitation.h>
#include <aws/wellarchitected/model/ShareInvitationAction.h>
#include <aws/wellarchitected/model/ShareInvitationSummary.h>
#include <aws/wellarchitected/model/ShareResourceType.h>
#include <aws/wellarchitected/model/ShareStatus.h>
#include <aws/wellarchitected/model/TagResourceRequest.h>
#include <aws/wellarchitected/model/TagResourceResult.h>
#include <aws/wellarchitected/model/TemplateShareSummary.h>
#include <aws/wellarchitected/model/ThrottlingException.h>
#include <aws/wellarchitected/model/TrustedAdvisorIntegrationStatus.h>
#include <aws/wellarchitected/model/UntagResourceRequest.h>
#include <aws/wellarchitected/model/UntagResourceResult.h>
#include <aws/wellarchitected/model/UpdateAnswerRequest.h>
#include <aws/wellarchitected/model/UpdateAnswerResult.h>
#include <aws/wellarchitected/model/UpdateGlobalSettingsRequest.h>
#include <aws/wellarchitected/model/UpdateIntegrationRequest.h>
#include <aws/wellarchitected/model/UpdateLensReviewRequest.h>
#include <aws/wellarchitected/model/UpdateLensReviewResult.h>
#include <aws/wellarchitected/model/UpdateProfileRequest.h>
#include <aws/wellarchitected/model/UpdateProfileResult.h>
#include <aws/wellarchitected/model/UpdateReviewTemplateAnswerRequest.h>
#include <aws/wellarchitected/model/UpdateReviewTemplateAnswerResult.h>
#include <aws/wellarchitected/model/UpdateReviewTemplateLensReviewRequest.h>
#include <aws/wellarchitected/model/UpdateReviewTemplateLensReviewResult.h>
#include <aws/wellarchitected/model/UpdateReviewTemplateRequest.h>
#include <aws/wellarchitected/model/UpdateReviewTemplateResult.h>
#include <aws/wellarchitected/model/UpdateShareInvitationRequest.h>
#include <aws/wellarchitected/model/UpdateShareInvitationResult.h>
#include <aws/wellarchitected/model/UpdateWorkloadRequest.h>
#include <aws/wellarchitected/model/UpdateWorkloadResult.h>
#include <aws/wellarchitected/model/UpdateWorkloadShareRequest.h>
#include <aws/wellarchitected/model/UpdateWorkloadShareResult.h>
#include <aws/wellarchitected/model/UpgradeLensReviewRequest.h>
#include <aws/wellarchitected/model/UpgradeProfileVersionRequest.h>
#include <aws/wellarchitected/model/UpgradeReviewTemplateLensReviewRequest.h>
#include <aws/wellarchitected/model/ValidationException.h>
#include <aws/wellarchitected/model/ValidationExceptionField.h>
#include <aws/wellarchitected/model/ValidationExceptionReason.h>
#include <aws/wellarchitected/model/VersionDifferences.h>
#include <aws/wellarchitected/model/Workload.h>
#include <aws/wellarchitected/model/WorkloadDiscoveryConfig.h>
#include <aws/wellarchitected/model/WorkloadEnvironment.h>
#include <aws/wellarchitected/model/WorkloadImprovementStatus.h>
#include <aws/wellarchitected/model/WorkloadIssueManagementStatus.h>
#include <aws/wellarchitected/model/WorkloadJiraConfigurationInput.h>
#include <aws/wellarchitected/model/WorkloadJiraConfigurationOutput.h>
#include <aws/wellarchitected/model/WorkloadProfile.h>
#include <aws/wellarchitected/model/WorkloadShare.h>
#include <aws/wellarchitected/model/WorkloadShareSummary.h>
#include <aws/wellarchitected/model/WorkloadSummary.h>

using WellArchitectedIncludeTest = ::testing::Test;

TEST_F(WellArchitectedIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::WellArchitected::WellArchitectedClient>("WellArchitectedIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
