/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/wisdom/ConnectWisdomServiceClient.h>
#include <aws/wisdom/ConnectWisdomServiceEndpointProvider.h>
#include <aws/wisdom/ConnectWisdomServiceEndpointRules.h>
#include <aws/wisdom/ConnectWisdomServiceErrorMarshaller.h>
#include <aws/wisdom/ConnectWisdomServiceErrors.h>
#include <aws/wisdom/ConnectWisdomServiceRequest.h>
#include <aws/wisdom/ConnectWisdomServiceServiceClientModel.h>
#include <aws/wisdom/ConnectWisdomService_EXPORTS.h>
#include <aws/wisdom/model/AppIntegrationsConfiguration.h>
#include <aws/wisdom/model/AssistantAssociationData.h>
#include <aws/wisdom/model/AssistantAssociationInputData.h>
#include <aws/wisdom/model/AssistantAssociationOutputData.h>
#include <aws/wisdom/model/AssistantAssociationSummary.h>
#include <aws/wisdom/model/AssistantData.h>
#include <aws/wisdom/model/AssistantIntegrationConfiguration.h>
#include <aws/wisdom/model/AssistantStatus.h>
#include <aws/wisdom/model/AssistantSummary.h>
#include <aws/wisdom/model/AssistantType.h>
#include <aws/wisdom/model/AssociationType.h>
#include <aws/wisdom/model/Configuration.h>
#include <aws/wisdom/model/ConnectConfiguration.h>
#include <aws/wisdom/model/ContentData.h>
#include <aws/wisdom/model/ContentReference.h>
#include <aws/wisdom/model/ContentStatus.h>
#include <aws/wisdom/model/ContentSummary.h>
#include <aws/wisdom/model/CreateAssistantAssociationRequest.h>
#include <aws/wisdom/model/CreateAssistantAssociationResult.h>
#include <aws/wisdom/model/CreateAssistantRequest.h>
#include <aws/wisdom/model/CreateAssistantResult.h>
#include <aws/wisdom/model/CreateContentRequest.h>
#include <aws/wisdom/model/CreateContentResult.h>
#include <aws/wisdom/model/CreateKnowledgeBaseRequest.h>
#include <aws/wisdom/model/CreateKnowledgeBaseResult.h>
#include <aws/wisdom/model/CreateQuickResponseRequest.h>
#include <aws/wisdom/model/CreateQuickResponseResult.h>
#include <aws/wisdom/model/CreateSessionRequest.h>
#include <aws/wisdom/model/CreateSessionResult.h>
#include <aws/wisdom/model/DeleteAssistantAssociationRequest.h>
#include <aws/wisdom/model/DeleteAssistantAssociationResult.h>
#include <aws/wisdom/model/DeleteAssistantRequest.h>
#include <aws/wisdom/model/DeleteAssistantResult.h>
#include <aws/wisdom/model/DeleteContentRequest.h>
#include <aws/wisdom/model/DeleteContentResult.h>
#include <aws/wisdom/model/DeleteImportJobRequest.h>
#include <aws/wisdom/model/DeleteImportJobResult.h>
#include <aws/wisdom/model/DeleteKnowledgeBaseRequest.h>
#include <aws/wisdom/model/DeleteKnowledgeBaseResult.h>
#include <aws/wisdom/model/DeleteQuickResponseRequest.h>
#include <aws/wisdom/model/DeleteQuickResponseResult.h>
#include <aws/wisdom/model/Document.h>
#include <aws/wisdom/model/DocumentText.h>
#include <aws/wisdom/model/ExternalSource.h>
#include <aws/wisdom/model/ExternalSourceConfiguration.h>
#include <aws/wisdom/model/Filter.h>
#include <aws/wisdom/model/FilterField.h>
#include <aws/wisdom/model/FilterOperator.h>
#include <aws/wisdom/model/GetAssistantAssociationRequest.h>
#include <aws/wisdom/model/GetAssistantAssociationResult.h>
#include <aws/wisdom/model/GetAssistantRequest.h>
#include <aws/wisdom/model/GetAssistantResult.h>
#include <aws/wisdom/model/GetContentRequest.h>
#include <aws/wisdom/model/GetContentResult.h>
#include <aws/wisdom/model/GetContentSummaryRequest.h>
#include <aws/wisdom/model/GetContentSummaryResult.h>
#include <aws/wisdom/model/GetImportJobRequest.h>
#include <aws/wisdom/model/GetImportJobResult.h>
#include <aws/wisdom/model/GetKnowledgeBaseRequest.h>
#include <aws/wisdom/model/GetKnowledgeBaseResult.h>
#include <aws/wisdom/model/GetQuickResponseRequest.h>
#include <aws/wisdom/model/GetQuickResponseResult.h>
#include <aws/wisdom/model/GetSessionRequest.h>
#include <aws/wisdom/model/GetSessionResult.h>
#include <aws/wisdom/model/GroupingConfiguration.h>
#include <aws/wisdom/model/Highlight.h>
#include <aws/wisdom/model/ImportJobData.h>
#include <aws/wisdom/model/ImportJobStatus.h>
#include <aws/wisdom/model/ImportJobSummary.h>
#include <aws/wisdom/model/ImportJobType.h>
#include <aws/wisdom/model/KnowledgeBaseAssociationData.h>
#include <aws/wisdom/model/KnowledgeBaseData.h>
#include <aws/wisdom/model/KnowledgeBaseStatus.h>
#include <aws/wisdom/model/KnowledgeBaseSummary.h>
#include <aws/wisdom/model/KnowledgeBaseType.h>
#include <aws/wisdom/model/ListAssistantAssociationsRequest.h>
#include <aws/wisdom/model/ListAssistantAssociationsResult.h>
#include <aws/wisdom/model/ListAssistantsRequest.h>
#include <aws/wisdom/model/ListAssistantsResult.h>
#include <aws/wisdom/model/ListContentsRequest.h>
#include <aws/wisdom/model/ListContentsResult.h>
#include <aws/wisdom/model/ListImportJobsRequest.h>
#include <aws/wisdom/model/ListImportJobsResult.h>
#include <aws/wisdom/model/ListKnowledgeBasesRequest.h>
#include <aws/wisdom/model/ListKnowledgeBasesResult.h>
#include <aws/wisdom/model/ListQuickResponsesRequest.h>
#include <aws/wisdom/model/ListQuickResponsesResult.h>
#include <aws/wisdom/model/ListTagsForResourceRequest.h>
#include <aws/wisdom/model/ListTagsForResourceResult.h>
#include <aws/wisdom/model/NotifyRecommendationsReceivedError.h>
#include <aws/wisdom/model/NotifyRecommendationsReceivedRequest.h>
#include <aws/wisdom/model/NotifyRecommendationsReceivedResult.h>
#include <aws/wisdom/model/Order.h>
#include <aws/wisdom/model/Priority.h>
#include <aws/wisdom/model/QueryRecommendationTriggerData.h>
#include <aws/wisdom/model/QuickResponseContentProvider.h>
#include <aws/wisdom/model/QuickResponseContents.h>
#include <aws/wisdom/model/QuickResponseData.h>
#include <aws/wisdom/model/QuickResponseDataProvider.h>
#include <aws/wisdom/model/QuickResponseFilterField.h>
#include <aws/wisdom/model/QuickResponseFilterOperator.h>
#include <aws/wisdom/model/QuickResponseOrderField.h>
#include <aws/wisdom/model/QuickResponseQueryField.h>
#include <aws/wisdom/model/QuickResponseQueryOperator.h>
#include <aws/wisdom/model/QuickResponseSearchExpression.h>
#include <aws/wisdom/model/QuickResponseSearchResultData.h>
#include <aws/wisdom/model/QuickResponseStatus.h>
#include <aws/wisdom/model/QuickResponseSummary.h>
#include <aws/wisdom/model/RecommendationData.h>
#include <aws/wisdom/model/RecommendationSourceType.h>
#include <aws/wisdom/model/RecommendationTrigger.h>
#include <aws/wisdom/model/RecommendationTriggerData.h>
#include <aws/wisdom/model/RecommendationTriggerType.h>
#include <aws/wisdom/model/RecommendationType.h>
#include <aws/wisdom/model/RelevanceLevel.h>
#include <aws/wisdom/model/RemoveKnowledgeBaseTemplateUriRequest.h>
#include <aws/wisdom/model/RemoveKnowledgeBaseTemplateUriResult.h>
#include <aws/wisdom/model/RenderingConfiguration.h>
#include <aws/wisdom/model/ResourceNotFoundException.h>
#include <aws/wisdom/model/ResultData.h>
#include <aws/wisdom/model/SearchContentRequest.h>
#include <aws/wisdom/model/SearchContentResult.h>
#include <aws/wisdom/model/SearchExpression.h>
#include <aws/wisdom/model/SearchQuickResponsesRequest.h>
#include <aws/wisdom/model/SearchQuickResponsesResult.h>
#include <aws/wisdom/model/SearchSessionsRequest.h>
#include <aws/wisdom/model/SearchSessionsResult.h>
#include <aws/wisdom/model/ServerSideEncryptionConfiguration.h>
#include <aws/wisdom/model/SessionData.h>
#include <aws/wisdom/model/SessionIntegrationConfiguration.h>
#include <aws/wisdom/model/SessionSummary.h>
#include <aws/wisdom/model/SourceConfiguration.h>
#include <aws/wisdom/model/StartContentUploadRequest.h>
#include <aws/wisdom/model/StartContentUploadResult.h>
#include <aws/wisdom/model/StartImportJobRequest.h>
#include <aws/wisdom/model/StartImportJobResult.h>
#include <aws/wisdom/model/TagResourceRequest.h>
#include <aws/wisdom/model/TagResourceResult.h>
#include <aws/wisdom/model/TooManyTagsException.h>
#include <aws/wisdom/model/UntagResourceRequest.h>
#include <aws/wisdom/model/UntagResourceResult.h>
#include <aws/wisdom/model/UpdateContentRequest.h>
#include <aws/wisdom/model/UpdateContentResult.h>
#include <aws/wisdom/model/UpdateKnowledgeBaseTemplateUriRequest.h>
#include <aws/wisdom/model/UpdateKnowledgeBaseTemplateUriResult.h>
#include <aws/wisdom/model/UpdateQuickResponseRequest.h>
#include <aws/wisdom/model/UpdateQuickResponseResult.h>

using ConnectWisdomServiceIncludeTest = ::testing::Test;

TEST_F(ConnectWisdomServiceIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::ConnectWisdomService::ConnectWisdomServiceClient>("ConnectWisdomServiceIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
