/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/workmail/WorkMailClient.h>
#include <aws/workmail/WorkMailEndpointProvider.h>
#include <aws/workmail/WorkMailEndpointRules.h>
#include <aws/workmail/WorkMailErrorMarshaller.h>
#include <aws/workmail/WorkMailErrors.h>
#include <aws/workmail/WorkMailRequest.h>
#include <aws/workmail/WorkMailServiceClientModel.h>
#include <aws/workmail/WorkMail_EXPORTS.h>
#include <aws/workmail/model/AccessControlRule.h>
#include <aws/workmail/model/AccessControlRuleEffect.h>
#include <aws/workmail/model/AccessEffect.h>
#include <aws/workmail/model/AssociateDelegateToResourceRequest.h>
#include <aws/workmail/model/AssociateDelegateToResourceResult.h>
#include <aws/workmail/model/AssociateMemberToGroupRequest.h>
#include <aws/workmail/model/AssociateMemberToGroupResult.h>
#include <aws/workmail/model/AssumeImpersonationRoleRequest.h>
#include <aws/workmail/model/AssumeImpersonationRoleResult.h>
#include <aws/workmail/model/AvailabilityConfiguration.h>
#include <aws/workmail/model/AvailabilityProviderType.h>
#include <aws/workmail/model/BookingOptions.h>
#include <aws/workmail/model/CancelMailboxExportJobRequest.h>
#include <aws/workmail/model/CancelMailboxExportJobResult.h>
#include <aws/workmail/model/CreateAliasRequest.h>
#include <aws/workmail/model/CreateAliasResult.h>
#include <aws/workmail/model/CreateAvailabilityConfigurationRequest.h>
#include <aws/workmail/model/CreateAvailabilityConfigurationResult.h>
#include <aws/workmail/model/CreateGroupRequest.h>
#include <aws/workmail/model/CreateGroupResult.h>
#include <aws/workmail/model/CreateIdentityCenterApplicationRequest.h>
#include <aws/workmail/model/CreateIdentityCenterApplicationResult.h>
#include <aws/workmail/model/CreateImpersonationRoleRequest.h>
#include <aws/workmail/model/CreateImpersonationRoleResult.h>
#include <aws/workmail/model/CreateMobileDeviceAccessRuleRequest.h>
#include <aws/workmail/model/CreateMobileDeviceAccessRuleResult.h>
#include <aws/workmail/model/CreateOrganizationRequest.h>
#include <aws/workmail/model/CreateOrganizationResult.h>
#include <aws/workmail/model/CreateResourceRequest.h>
#include <aws/workmail/model/CreateResourceResult.h>
#include <aws/workmail/model/CreateUserRequest.h>
#include <aws/workmail/model/CreateUserResult.h>
#include <aws/workmail/model/Delegate.h>
#include <aws/workmail/model/DeleteAccessControlRuleRequest.h>
#include <aws/workmail/model/DeleteAccessControlRuleResult.h>
#include <aws/workmail/model/DeleteAliasRequest.h>
#include <aws/workmail/model/DeleteAliasResult.h>
#include <aws/workmail/model/DeleteAvailabilityConfigurationRequest.h>
#include <aws/workmail/model/DeleteAvailabilityConfigurationResult.h>
#include <aws/workmail/model/DeleteEmailMonitoringConfigurationRequest.h>
#include <aws/workmail/model/DeleteEmailMonitoringConfigurationResult.h>
#include <aws/workmail/model/DeleteGroupRequest.h>
#include <aws/workmail/model/DeleteGroupResult.h>
#include <aws/workmail/model/DeleteIdentityCenterApplicationRequest.h>
#include <aws/workmail/model/DeleteIdentityCenterApplicationResult.h>
#include <aws/workmail/model/DeleteIdentityProviderConfigurationRequest.h>
#include <aws/workmail/model/DeleteIdentityProviderConfigurationResult.h>
#include <aws/workmail/model/DeleteImpersonationRoleRequest.h>
#include <aws/workmail/model/DeleteImpersonationRoleResult.h>
#include <aws/workmail/model/DeleteMailboxPermissionsRequest.h>
#include <aws/workmail/model/DeleteMailboxPermissionsResult.h>
#include <aws/workmail/model/DeleteMobileDeviceAccessOverrideRequest.h>
#include <aws/workmail/model/DeleteMobileDeviceAccessOverrideResult.h>
#include <aws/workmail/model/DeleteMobileDeviceAccessRuleRequest.h>
#include <aws/workmail/model/DeleteMobileDeviceAccessRuleResult.h>
#include <aws/workmail/model/DeleteOrganizationRequest.h>
#include <aws/workmail/model/DeleteOrganizationResult.h>
#include <aws/workmail/model/DeletePersonalAccessTokenRequest.h>
#include <aws/workmail/model/DeletePersonalAccessTokenResult.h>
#include <aws/workmail/model/DeleteResourceRequest.h>
#include <aws/workmail/model/DeleteResourceResult.h>
#include <aws/workmail/model/DeleteRetentionPolicyRequest.h>
#include <aws/workmail/model/DeleteRetentionPolicyResult.h>
#include <aws/workmail/model/DeleteUserRequest.h>
#include <aws/workmail/model/DeleteUserResult.h>
#include <aws/workmail/model/DeregisterFromWorkMailRequest.h>
#include <aws/workmail/model/DeregisterFromWorkMailResult.h>
#include <aws/workmail/model/DeregisterMailDomainRequest.h>
#include <aws/workmail/model/DeregisterMailDomainResult.h>
#include <aws/workmail/model/DescribeEmailMonitoringConfigurationRequest.h>
#include <aws/workmail/model/DescribeEmailMonitoringConfigurationResult.h>
#include <aws/workmail/model/DescribeEntityRequest.h>
#include <aws/workmail/model/DescribeEntityResult.h>
#include <aws/workmail/model/DescribeGroupRequest.h>
#include <aws/workmail/model/DescribeGroupResult.h>
#include <aws/workmail/model/DescribeIdentityProviderConfigurationRequest.h>
#include <aws/workmail/model/DescribeIdentityProviderConfigurationResult.h>
#include <aws/workmail/model/DescribeInboundDmarcSettingsRequest.h>
#include <aws/workmail/model/DescribeInboundDmarcSettingsResult.h>
#include <aws/workmail/model/DescribeMailboxExportJobRequest.h>
#include <aws/workmail/model/DescribeMailboxExportJobResult.h>
#include <aws/workmail/model/DescribeOrganizationRequest.h>
#include <aws/workmail/model/DescribeOrganizationResult.h>
#include <aws/workmail/model/DescribeResourceRequest.h>
#include <aws/workmail/model/DescribeResourceResult.h>
#include <aws/workmail/model/DescribeUserRequest.h>
#include <aws/workmail/model/DescribeUserResult.h>
#include <aws/workmail/model/DisassociateDelegateFromResourceRequest.h>
#include <aws/workmail/model/DisassociateDelegateFromResourceResult.h>
#include <aws/workmail/model/DisassociateMemberFromGroupRequest.h>
#include <aws/workmail/model/DisassociateMemberFromGroupResult.h>
#include <aws/workmail/model/DnsRecord.h>
#include <aws/workmail/model/DnsRecordVerificationStatus.h>
#include <aws/workmail/model/Domain.h>
#include <aws/workmail/model/EntityState.h>
#include <aws/workmail/model/EntityType.h>
#include <aws/workmail/model/EwsAvailabilityProvider.h>
#include <aws/workmail/model/FolderConfiguration.h>
#include <aws/workmail/model/FolderName.h>
#include <aws/workmail/model/GetAccessControlEffectRequest.h>
#include <aws/workmail/model/GetAccessControlEffectResult.h>
#include <aws/workmail/model/GetDefaultRetentionPolicyRequest.h>
#include <aws/workmail/model/GetDefaultRetentionPolicyResult.h>
#include <aws/workmail/model/GetImpersonationRoleEffectRequest.h>
#include <aws/workmail/model/GetImpersonationRoleEffectResult.h>
#include <aws/workmail/model/GetImpersonationRoleRequest.h>
#include <aws/workmail/model/GetImpersonationRoleResult.h>
#include <aws/workmail/model/GetMailDomainRequest.h>
#include <aws/workmail/model/GetMailDomainResult.h>
#include <aws/workmail/model/GetMailboxDetailsRequest.h>
#include <aws/workmail/model/GetMailboxDetailsResult.h>
#include <aws/workmail/model/GetMobileDeviceAccessEffectRequest.h>
#include <aws/workmail/model/GetMobileDeviceAccessEffectResult.h>
#include <aws/workmail/model/GetMobileDeviceAccessOverrideRequest.h>
#include <aws/workmail/model/GetMobileDeviceAccessOverrideResult.h>
#include <aws/workmail/model/GetPersonalAccessTokenMetadataRequest.h>
#include <aws/workmail/model/GetPersonalAccessTokenMetadataResult.h>
#include <aws/workmail/model/Group.h>
#include <aws/workmail/model/GroupIdentifier.h>
#include <aws/workmail/model/IdentityCenterConfiguration.h>
#include <aws/workmail/model/IdentityProviderAuthenticationMode.h>
#include <aws/workmail/model/ImpersonationMatchedRule.h>
#include <aws/workmail/model/ImpersonationRole.h>
#include <aws/workmail/model/ImpersonationRoleType.h>
#include <aws/workmail/model/ImpersonationRule.h>
#include <aws/workmail/model/LambdaAvailabilityProvider.h>
#include <aws/workmail/model/ListAccessControlRulesRequest.h>
#include <aws/workmail/model/ListAccessControlRulesResult.h>
#include <aws/workmail/model/ListAliasesRequest.h>
#include <aws/workmail/model/ListAliasesResult.h>
#include <aws/workmail/model/ListAvailabilityConfigurationsRequest.h>
#include <aws/workmail/model/ListAvailabilityConfigurationsResult.h>
#include <aws/workmail/model/ListGroupMembersRequest.h>
#include <aws/workmail/model/ListGroupMembersResult.h>
#include <aws/workmail/model/ListGroupsFilters.h>
#include <aws/workmail/model/ListGroupsForEntityFilters.h>
#include <aws/workmail/model/ListGroupsForEntityRequest.h>
#include <aws/workmail/model/ListGroupsForEntityResult.h>
#include <aws/workmail/model/ListGroupsRequest.h>
#include <aws/workmail/model/ListGroupsResult.h>
#include <aws/workmail/model/ListImpersonationRolesRequest.h>
#include <aws/workmail/model/ListImpersonationRolesResult.h>
#include <aws/workmail/model/ListMailDomainsRequest.h>
#include <aws/workmail/model/ListMailDomainsResult.h>
#include <aws/workmail/model/ListMailboxExportJobsRequest.h>
#include <aws/workmail/model/ListMailboxExportJobsResult.h>
#include <aws/workmail/model/ListMailboxPermissionsRequest.h>
#include <aws/workmail/model/ListMailboxPermissionsResult.h>
#include <aws/workmail/model/ListMobileDeviceAccessOverridesRequest.h>
#include <aws/workmail/model/ListMobileDeviceAccessOverridesResult.h>
#include <aws/workmail/model/ListMobileDeviceAccessRulesRequest.h>
#include <aws/workmail/model/ListMobileDeviceAccessRulesResult.h>
#include <aws/workmail/model/ListOrganizationsRequest.h>
#include <aws/workmail/model/ListOrganizationsResult.h>
#include <aws/workmail/model/ListPersonalAccessTokensRequest.h>
#include <aws/workmail/model/ListPersonalAccessTokensResult.h>
#include <aws/workmail/model/ListResourceDelegatesRequest.h>
#include <aws/workmail/model/ListResourceDelegatesResult.h>
#include <aws/workmail/model/ListResourcesFilters.h>
#include <aws/workmail/model/ListResourcesRequest.h>
#include <aws/workmail/model/ListResourcesResult.h>
#include <aws/workmail/model/ListTagsForResourceRequest.h>
#include <aws/workmail/model/ListTagsForResourceResult.h>
#include <aws/workmail/model/ListUsersFilters.h>
#include <aws/workmail/model/ListUsersRequest.h>
#include <aws/workmail/model/ListUsersResult.h>
#include <aws/workmail/model/MailDomainSummary.h>
#include <aws/workmail/model/MailboxExportJob.h>
#include <aws/workmail/model/MailboxExportJobState.h>
#include <aws/workmail/model/Member.h>
#include <aws/workmail/model/MemberType.h>
#include <aws/workmail/model/MobileDeviceAccessMatchedRule.h>
#include <aws/workmail/model/MobileDeviceAccessOverride.h>
#include <aws/workmail/model/MobileDeviceAccessRule.h>
#include <aws/workmail/model/MobileDeviceAccessRuleEffect.h>
#include <aws/workmail/model/OrganizationSummary.h>
#include <aws/workmail/model/Permission.h>
#include <aws/workmail/model/PermissionType.h>
#include <aws/workmail/model/PersonalAccessTokenConfiguration.h>
#include <aws/workmail/model/PersonalAccessTokenConfigurationStatus.h>
#include <aws/workmail/model/PersonalAccessTokenSummary.h>
#include <aws/workmail/model/PutAccessControlRuleRequest.h>
#include <aws/workmail/model/PutAccessControlRuleResult.h>
#include <aws/workmail/model/PutEmailMonitoringConfigurationRequest.h>
#include <aws/workmail/model/PutEmailMonitoringConfigurationResult.h>
#include <aws/workmail/model/PutIdentityProviderConfigurationRequest.h>
#include <aws/workmail/model/PutIdentityProviderConfigurationResult.h>
#include <aws/workmail/model/PutInboundDmarcSettingsRequest.h>
#include <aws/workmail/model/PutInboundDmarcSettingsResult.h>
#include <aws/workmail/model/PutMailboxPermissionsRequest.h>
#include <aws/workmail/model/PutMailboxPermissionsResult.h>
#include <aws/workmail/model/PutMobileDeviceAccessOverrideRequest.h>
#include <aws/workmail/model/PutMobileDeviceAccessOverrideResult.h>
#include <aws/workmail/model/PutRetentionPolicyRequest.h>
#include <aws/workmail/model/PutRetentionPolicyResult.h>
#include <aws/workmail/model/RedactedEwsAvailabilityProvider.h>
#include <aws/workmail/model/RegisterMailDomainRequest.h>
#include <aws/workmail/model/RegisterMailDomainResult.h>
#include <aws/workmail/model/RegisterToWorkMailRequest.h>
#include <aws/workmail/model/RegisterToWorkMailResult.h>
#include <aws/workmail/model/ResetPasswordRequest.h>
#include <aws/workmail/model/ResetPasswordResult.h>
#include <aws/workmail/model/Resource.h>
#include <aws/workmail/model/ResourceType.h>
#include <aws/workmail/model/RetentionAction.h>
#include <aws/workmail/model/StartMailboxExportJobRequest.h>
#include <aws/workmail/model/StartMailboxExportJobResult.h>
#include <aws/workmail/model/Tag.h>
#include <aws/workmail/model/TagResourceRequest.h>
#include <aws/workmail/model/TagResourceResult.h>
#include <aws/workmail/model/TestAvailabilityConfigurationRequest.h>
#include <aws/workmail/model/TestAvailabilityConfigurationResult.h>
#include <aws/workmail/model/UntagResourceRequest.h>
#include <aws/workmail/model/UntagResourceResult.h>
#include <aws/workmail/model/UpdateAvailabilityConfigurationRequest.h>
#include <aws/workmail/model/UpdateAvailabilityConfigurationResult.h>
#include <aws/workmail/model/UpdateDefaultMailDomainRequest.h>
#include <aws/workmail/model/UpdateDefaultMailDomainResult.h>
#include <aws/workmail/model/UpdateGroupRequest.h>
#include <aws/workmail/model/UpdateGroupResult.h>
#include <aws/workmail/model/UpdateImpersonationRoleRequest.h>
#include <aws/workmail/model/UpdateImpersonationRoleResult.h>
#include <aws/workmail/model/UpdateMailboxQuotaRequest.h>
#include <aws/workmail/model/UpdateMailboxQuotaResult.h>
#include <aws/workmail/model/UpdateMobileDeviceAccessRuleRequest.h>
#include <aws/workmail/model/UpdateMobileDeviceAccessRuleResult.h>
#include <aws/workmail/model/UpdatePrimaryEmailAddressRequest.h>
#include <aws/workmail/model/UpdatePrimaryEmailAddressResult.h>
#include <aws/workmail/model/UpdateResourceRequest.h>
#include <aws/workmail/model/UpdateResourceResult.h>
#include <aws/workmail/model/UpdateUserRequest.h>
#include <aws/workmail/model/UpdateUserResult.h>
#include <aws/workmail/model/User.h>
#include <aws/workmail/model/UserRole.h>

using WorkMailIncludeTest = ::testing::Test;

TEST_F(WorkMailIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::WorkMail::WorkMailClient>("WorkMailIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
