/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/workspaces/WorkSpacesClient.h>
#include <aws/workspaces/WorkSpacesEndpointProvider.h>
#include <aws/workspaces/WorkSpacesEndpointRules.h>
#include <aws/workspaces/WorkSpacesErrorMarshaller.h>
#include <aws/workspaces/WorkSpacesErrors.h>
#include <aws/workspaces/WorkSpacesRequest.h>
#include <aws/workspaces/WorkSpacesServiceClientModel.h>
#include <aws/workspaces/WorkSpaces_EXPORTS.h>
#include <aws/workspaces/model/AGAModeForDirectoryEnum.h>
#include <aws/workspaces/model/AGAModeForWorkSpaceEnum.h>
#include <aws/workspaces/model/AGAPreferredProtocolForDirectory.h>
#include <aws/workspaces/model/AGAPreferredProtocolForWorkSpace.h>
#include <aws/workspaces/model/AcceptAccountLinkInvitationRequest.h>
#include <aws/workspaces/model/AcceptAccountLinkInvitationResult.h>
#include <aws/workspaces/model/AccessEndpoint.h>
#include <aws/workspaces/model/AccessEndpointConfig.h>
#include <aws/workspaces/model/AccessEndpointType.h>
#include <aws/workspaces/model/AccessPropertyValue.h>
#include <aws/workspaces/model/AccountLink.h>
#include <aws/workspaces/model/AccountLinkStatusEnum.h>
#include <aws/workspaces/model/AccountModification.h>
#include <aws/workspaces/model/ActiveDirectoryConfig.h>
#include <aws/workspaces/model/Application.h>
#include <aws/workspaces/model/ApplicationAssociatedResourceType.h>
#include <aws/workspaces/model/ApplicationResourceAssociation.h>
#include <aws/workspaces/model/ApplicationSettingsRequest.h>
#include <aws/workspaces/model/ApplicationSettingsResponse.h>
#include <aws/workspaces/model/ApplicationSettingsStatusEnum.h>
#include <aws/workspaces/model/AssociateConnectionAliasRequest.h>
#include <aws/workspaces/model/AssociateConnectionAliasResult.h>
#include <aws/workspaces/model/AssociateIpGroupsRequest.h>
#include <aws/workspaces/model/AssociateIpGroupsResult.h>
#include <aws/workspaces/model/AssociateWorkspaceApplicationRequest.h>
#include <aws/workspaces/model/AssociateWorkspaceApplicationResult.h>
#include <aws/workspaces/model/AssociationErrorCode.h>
#include <aws/workspaces/model/AssociationState.h>
#include <aws/workspaces/model/AssociationStateReason.h>
#include <aws/workspaces/model/AssociationStatus.h>
#include <aws/workspaces/model/AuthenticationType.h>
#include <aws/workspaces/model/AuthorizeIpRulesRequest.h>
#include <aws/workspaces/model/AuthorizeIpRulesResult.h>
#include <aws/workspaces/model/BundleAssociatedResourceType.h>
#include <aws/workspaces/model/BundleResourceAssociation.h>
#include <aws/workspaces/model/BundleType.h>
#include <aws/workspaces/model/Capacity.h>
#include <aws/workspaces/model/CapacityStatus.h>
#include <aws/workspaces/model/CertificateBasedAuthProperties.h>
#include <aws/workspaces/model/CertificateBasedAuthStatusEnum.h>
#include <aws/workspaces/model/ClientDeviceType.h>
#include <aws/workspaces/model/ClientProperties.h>
#include <aws/workspaces/model/ClientPropertiesResult.h>
#include <aws/workspaces/model/Compute.h>
#include <aws/workspaces/model/ComputeType.h>
#include <aws/workspaces/model/ConnectClientAddIn.h>
#include <aws/workspaces/model/ConnectionAlias.h>
#include <aws/workspaces/model/ConnectionAliasAssociation.h>
#include <aws/workspaces/model/ConnectionAliasPermission.h>
#include <aws/workspaces/model/ConnectionAliasState.h>
#include <aws/workspaces/model/ConnectionState.h>
#include <aws/workspaces/model/CopyWorkspaceImageRequest.h>
#include <aws/workspaces/model/CopyWorkspaceImageResult.h>
#include <aws/workspaces/model/CreateAccountLinkInvitationRequest.h>
#include <aws/workspaces/model/CreateAccountLinkInvitationResult.h>
#include <aws/workspaces/model/CreateConnectClientAddInRequest.h>
#include <aws/workspaces/model/CreateConnectClientAddInResult.h>
#include <aws/workspaces/model/CreateConnectionAliasRequest.h>
#include <aws/workspaces/model/CreateConnectionAliasResult.h>
#include <aws/workspaces/model/CreateIpGroupRequest.h>
#include <aws/workspaces/model/CreateIpGroupResult.h>
#include <aws/workspaces/model/CreateStandbyWorkspacesRequest.h>
#include <aws/workspaces/model/CreateStandbyWorkspacesResult.h>
#include <aws/workspaces/model/CreateTagsRequest.h>
#include <aws/workspaces/model/CreateTagsResult.h>
#include <aws/workspaces/model/CreateUpdatedWorkspaceImageRequest.h>
#include <aws/workspaces/model/CreateUpdatedWorkspaceImageResult.h>
#include <aws/workspaces/model/CreateWorkspaceBundleRequest.h>
#include <aws/workspaces/model/CreateWorkspaceBundleResult.h>
#include <aws/workspaces/model/CreateWorkspaceImageRequest.h>
#include <aws/workspaces/model/CreateWorkspaceImageResult.h>
#include <aws/workspaces/model/CreateWorkspacesPoolRequest.h>
#include <aws/workspaces/model/CreateWorkspacesPoolResult.h>
#include <aws/workspaces/model/CreateWorkspacesRequest.h>
#include <aws/workspaces/model/CreateWorkspacesResult.h>
#include <aws/workspaces/model/DataReplication.h>
#include <aws/workspaces/model/DataReplicationSettings.h>
#include <aws/workspaces/model/DedicatedTenancyAccountType.h>
#include <aws/workspaces/model/DedicatedTenancyModificationStateEnum.h>
#include <aws/workspaces/model/DedicatedTenancySupportEnum.h>
#include <aws/workspaces/model/DedicatedTenancySupportResultEnum.h>
#include <aws/workspaces/model/DefaultClientBrandingAttributes.h>
#include <aws/workspaces/model/DefaultImportClientBrandingAttributes.h>
#include <aws/workspaces/model/DefaultWorkspaceCreationProperties.h>
#include <aws/workspaces/model/DeletableCertificateBasedAuthProperty.h>
#include <aws/workspaces/model/DeletableSamlProperty.h>
#include <aws/workspaces/model/DeleteAccountLinkInvitationRequest.h>
#include <aws/workspaces/model/DeleteAccountLinkInvitationResult.h>
#include <aws/workspaces/model/DeleteClientBrandingRequest.h>
#include <aws/workspaces/model/DeleteClientBrandingResult.h>
#include <aws/workspaces/model/DeleteConnectClientAddInRequest.h>
#include <aws/workspaces/model/DeleteConnectClientAddInResult.h>
#include <aws/workspaces/model/DeleteConnectionAliasRequest.h>
#include <aws/workspaces/model/DeleteConnectionAliasResult.h>
#include <aws/workspaces/model/DeleteIpGroupRequest.h>
#include <aws/workspaces/model/DeleteIpGroupResult.h>
#include <aws/workspaces/model/DeleteTagsRequest.h>
#include <aws/workspaces/model/DeleteTagsResult.h>
#include <aws/workspaces/model/DeleteWorkspaceBundleRequest.h>
#include <aws/workspaces/model/DeleteWorkspaceBundleResult.h>
#include <aws/workspaces/model/DeleteWorkspaceImageRequest.h>
#include <aws/workspaces/model/DeleteWorkspaceImageResult.h>
#include <aws/workspaces/model/DeployWorkspaceApplicationsRequest.h>
#include <aws/workspaces/model/DeployWorkspaceApplicationsResult.h>
#include <aws/workspaces/model/DeregisterWorkspaceDirectoryRequest.h>
#include <aws/workspaces/model/DeregisterWorkspaceDirectoryResult.h>
#include <aws/workspaces/model/DescribeAccountModificationsRequest.h>
#include <aws/workspaces/model/DescribeAccountModificationsResult.h>
#include <aws/workspaces/model/DescribeAccountRequest.h>
#include <aws/workspaces/model/DescribeAccountResult.h>
#include <aws/workspaces/model/DescribeApplicationAssociationsRequest.h>
#include <aws/workspaces/model/DescribeApplicationAssociationsResult.h>
#include <aws/workspaces/model/DescribeApplicationsRequest.h>
#include <aws/workspaces/model/DescribeApplicationsResult.h>
#include <aws/workspaces/model/DescribeBundleAssociationsRequest.h>
#include <aws/workspaces/model/DescribeBundleAssociationsResult.h>
#include <aws/workspaces/model/DescribeClientBrandingRequest.h>
#include <aws/workspaces/model/DescribeClientBrandingResult.h>
#include <aws/workspaces/model/DescribeClientPropertiesRequest.h>
#include <aws/workspaces/model/DescribeClientPropertiesResult.h>
#include <aws/workspaces/model/DescribeConnectClientAddInsRequest.h>
#include <aws/workspaces/model/DescribeConnectClientAddInsResult.h>
#include <aws/workspaces/model/DescribeConnectionAliasPermissionsRequest.h>
#include <aws/workspaces/model/DescribeConnectionAliasPermissionsResult.h>
#include <aws/workspaces/model/DescribeConnectionAliasesRequest.h>
#include <aws/workspaces/model/DescribeConnectionAliasesResult.h>
#include <aws/workspaces/model/DescribeImageAssociationsRequest.h>
#include <aws/workspaces/model/DescribeImageAssociationsResult.h>
#include <aws/workspaces/model/DescribeIpGroupsRequest.h>
#include <aws/workspaces/model/DescribeIpGroupsResult.h>
#include <aws/workspaces/model/DescribeTagsRequest.h>
#include <aws/workspaces/model/DescribeTagsResult.h>
#include <aws/workspaces/model/DescribeWorkspaceAssociationsRequest.h>
#include <aws/workspaces/model/DescribeWorkspaceAssociationsResult.h>
#include <aws/workspaces/model/DescribeWorkspaceBundlesRequest.h>
#include <aws/workspaces/model/DescribeWorkspaceBundlesResult.h>
#include <aws/workspaces/model/DescribeWorkspaceDirectoriesFilter.h>
#include <aws/workspaces/model/DescribeWorkspaceDirectoriesFilterName.h>
#include <aws/workspaces/model/DescribeWorkspaceDirectoriesRequest.h>
#include <aws/workspaces/model/DescribeWorkspaceDirectoriesResult.h>
#include <aws/workspaces/model/DescribeWorkspaceImagePermissionsRequest.h>
#include <aws/workspaces/model/DescribeWorkspaceImagePermissionsResult.h>
#include <aws/workspaces/model/DescribeWorkspaceImagesRequest.h>
#include <aws/workspaces/model/DescribeWorkspaceImagesResult.h>
#include <aws/workspaces/model/DescribeWorkspaceSnapshotsRequest.h>
#include <aws/workspaces/model/DescribeWorkspaceSnapshotsResult.h>
#include <aws/workspaces/model/DescribeWorkspacesConnectionStatusRequest.h>
#include <aws/workspaces/model/DescribeWorkspacesConnectionStatusResult.h>
#include <aws/workspaces/model/DescribeWorkspacesPoolSessionsRequest.h>
#include <aws/workspaces/model/DescribeWorkspacesPoolSessionsResult.h>
#include <aws/workspaces/model/DescribeWorkspacesPoolsFilter.h>
#include <aws/workspaces/model/DescribeWorkspacesPoolsFilterName.h>
#include <aws/workspaces/model/DescribeWorkspacesPoolsFilterOperator.h>
#include <aws/workspaces/model/DescribeWorkspacesPoolsRequest.h>
#include <aws/workspaces/model/DescribeWorkspacesPoolsResult.h>
#include <aws/workspaces/model/DescribeWorkspacesRequest.h>
#include <aws/workspaces/model/DescribeWorkspacesResult.h>
#include <aws/workspaces/model/DisassociateConnectionAliasRequest.h>
#include <aws/workspaces/model/DisassociateConnectionAliasResult.h>
#include <aws/workspaces/model/DisassociateIpGroupsRequest.h>
#include <aws/workspaces/model/DisassociateIpGroupsResult.h>
#include <aws/workspaces/model/DisassociateWorkspaceApplicationRequest.h>
#include <aws/workspaces/model/DisassociateWorkspaceApplicationResult.h>
#include <aws/workspaces/model/EndpointEncryptionMode.h>
#include <aws/workspaces/model/ErrorDetails.h>
#include <aws/workspaces/model/FailedCreateStandbyWorkspacesRequest.h>
#include <aws/workspaces/model/FailedCreateWorkspaceRequest.h>
#include <aws/workspaces/model/FailedWorkspaceChangeRequest.h>
#include <aws/workspaces/model/GetAccountLinkRequest.h>
#include <aws/workspaces/model/GetAccountLinkResult.h>
#include <aws/workspaces/model/GlobalAcceleratorForDirectory.h>
#include <aws/workspaces/model/GlobalAcceleratorForWorkSpace.h>
#include <aws/workspaces/model/IDCConfig.h>
#include <aws/workspaces/model/ImageAssociatedResourceType.h>
#include <aws/workspaces/model/ImagePermission.h>
#include <aws/workspaces/model/ImageResourceAssociation.h>
#include <aws/workspaces/model/ImageType.h>
#include <aws/workspaces/model/ImportClientBrandingRequest.h>
#include <aws/workspaces/model/ImportClientBrandingResult.h>
#include <aws/workspaces/model/ImportWorkspaceImageRequest.h>
#include <aws/workspaces/model/ImportWorkspaceImageResult.h>
#include <aws/workspaces/model/InternetFallbackProtocol.h>
#include <aws/workspaces/model/IosClientBrandingAttributes.h>
#include <aws/workspaces/model/IosImportClientBrandingAttributes.h>
#include <aws/workspaces/model/IpRuleItem.h>
#include <aws/workspaces/model/ListAccountLinksRequest.h>
#include <aws/workspaces/model/ListAccountLinksResult.h>
#include <aws/workspaces/model/ListAvailableManagementCidrRangesRequest.h>
#include <aws/workspaces/model/ListAvailableManagementCidrRangesResult.h>
#include <aws/workspaces/model/LogUploadEnum.h>
#include <aws/workspaces/model/MicrosoftEntraConfig.h>
#include <aws/workspaces/model/MigrateWorkspaceRequest.h>
#include <aws/workspaces/model/MigrateWorkspaceResult.h>
#include <aws/workspaces/model/ModificationResourceEnum.h>
#include <aws/workspaces/model/ModificationState.h>
#include <aws/workspaces/model/ModificationStateEnum.h>
#include <aws/workspaces/model/ModifyAccountRequest.h>
#include <aws/workspaces/model/ModifyAccountResult.h>
#include <aws/workspaces/model/ModifyCertificateBasedAuthPropertiesRequest.h>
#include <aws/workspaces/model/ModifyCertificateBasedAuthPropertiesResult.h>
#include <aws/workspaces/model/ModifyClientPropertiesRequest.h>
#include <aws/workspaces/model/ModifyClientPropertiesResult.h>
#include <aws/workspaces/model/ModifyEndpointEncryptionModeRequest.h>
#include <aws/workspaces/model/ModifyEndpointEncryptionModeResult.h>
#include <aws/workspaces/model/ModifySamlPropertiesRequest.h>
#include <aws/workspaces/model/ModifySamlPropertiesResult.h>
#include <aws/workspaces/model/ModifySelfservicePermissionsRequest.h>
#include <aws/workspaces/model/ModifySelfservicePermissionsResult.h>
#include <aws/workspaces/model/ModifyStreamingPropertiesRequest.h>
#include <aws/workspaces/model/ModifyStreamingPropertiesResult.h>
#include <aws/workspaces/model/ModifyWorkspaceAccessPropertiesRequest.h>
#include <aws/workspaces/model/ModifyWorkspaceAccessPropertiesResult.h>
#include <aws/workspaces/model/ModifyWorkspaceCreationPropertiesRequest.h>
#include <aws/workspaces/model/ModifyWorkspaceCreationPropertiesResult.h>
#include <aws/workspaces/model/ModifyWorkspacePropertiesRequest.h>
#include <aws/workspaces/model/ModifyWorkspacePropertiesResult.h>
#include <aws/workspaces/model/ModifyWorkspaceStateRequest.h>
#include <aws/workspaces/model/ModifyWorkspaceStateResult.h>
#include <aws/workspaces/model/NetworkAccessConfiguration.h>
#include <aws/workspaces/model/OperatingSystem.h>
#include <aws/workspaces/model/OperatingSystemName.h>
#include <aws/workspaces/model/OperatingSystemType.h>
#include <aws/workspaces/model/OperationNotSupportedException.h>
#include <aws/workspaces/model/PendingCreateStandbyWorkspacesRequest.h>
#include <aws/workspaces/model/PoolsRunningMode.h>
#include <aws/workspaces/model/Protocol.h>
#include <aws/workspaces/model/RebootRequest.h>
#include <aws/workspaces/model/RebootWorkspacesRequest.h>
#include <aws/workspaces/model/RebootWorkspacesResult.h>
#include <aws/workspaces/model/RebuildRequest.h>
#include <aws/workspaces/model/RebuildWorkspacesRequest.h>
#include <aws/workspaces/model/RebuildWorkspacesResult.h>
#include <aws/workspaces/model/ReconnectEnum.h>
#include <aws/workspaces/model/RegisterWorkspaceDirectoryRequest.h>
#include <aws/workspaces/model/RegisterWorkspaceDirectoryResult.h>
#include <aws/workspaces/model/RejectAccountLinkInvitationRequest.h>
#include <aws/workspaces/model/RejectAccountLinkInvitationResult.h>
#include <aws/workspaces/model/RelatedWorkspaceProperties.h>
#include <aws/workspaces/model/ResourceInUseException.h>
#include <aws/workspaces/model/ResourceNotFoundException.h>
#include <aws/workspaces/model/ResourceUnavailableException.h>
#include <aws/workspaces/model/RestoreWorkspaceRequest.h>
#include <aws/workspaces/model/RestoreWorkspaceResult.h>
#include <aws/workspaces/model/RevokeIpRulesRequest.h>
#include <aws/workspaces/model/RevokeIpRulesResult.h>
#include <aws/workspaces/model/RootStorage.h>
#include <aws/workspaces/model/RunningMode.h>
#include <aws/workspaces/model/SamlProperties.h>
#include <aws/workspaces/model/SamlStatusEnum.h>
#include <aws/workspaces/model/SelfservicePermissions.h>
#include <aws/workspaces/model/SessionConnectionState.h>
#include <aws/workspaces/model/Snapshot.h>
#include <aws/workspaces/model/StandbyWorkspace.h>
#include <aws/workspaces/model/StandbyWorkspaceRelationshipType.h>
#include <aws/workspaces/model/StandbyWorkspacesProperties.h>
#include <aws/workspaces/model/StartRequest.h>
#include <aws/workspaces/model/StartWorkspacesPoolRequest.h>
#include <aws/workspaces/model/StartWorkspacesPoolResult.h>
#include <aws/workspaces/model/StartWorkspacesRequest.h>
#include <aws/workspaces/model/StartWorkspacesResult.h>
#include <aws/workspaces/model/StopRequest.h>
#include <aws/workspaces/model/StopWorkspacesPoolRequest.h>
#include <aws/workspaces/model/StopWorkspacesPoolResult.h>
#include <aws/workspaces/model/StopWorkspacesRequest.h>
#include <aws/workspaces/model/StopWorkspacesResult.h>
#include <aws/workspaces/model/StorageConnector.h>
#include <aws/workspaces/model/StorageConnectorStatusEnum.h>
#include <aws/workspaces/model/StorageConnectorTypeEnum.h>
#include <aws/workspaces/model/StreamingExperiencePreferredProtocolEnum.h>
#include <aws/workspaces/model/StreamingProperties.h>
#include <aws/workspaces/model/Tag.h>
#include <aws/workspaces/model/TargetWorkspaceState.h>
#include <aws/workspaces/model/Tenancy.h>
#include <aws/workspaces/model/TerminateRequest.h>
#include <aws/workspaces/model/TerminateWorkspacesPoolRequest.h>
#include <aws/workspaces/model/TerminateWorkspacesPoolResult.h>
#include <aws/workspaces/model/TerminateWorkspacesPoolSessionRequest.h>
#include <aws/workspaces/model/TerminateWorkspacesPoolSessionResult.h>
#include <aws/workspaces/model/TerminateWorkspacesRequest.h>
#include <aws/workspaces/model/TerminateWorkspacesResult.h>
#include <aws/workspaces/model/TimeoutSettings.h>
#include <aws/workspaces/model/UpdateConnectClientAddInRequest.h>
#include <aws/workspaces/model/UpdateConnectClientAddInResult.h>
#include <aws/workspaces/model/UpdateConnectionAliasPermissionRequest.h>
#include <aws/workspaces/model/UpdateConnectionAliasPermissionResult.h>
#include <aws/workspaces/model/UpdateResult.h>
#include <aws/workspaces/model/UpdateRulesOfIpGroupRequest.h>
#include <aws/workspaces/model/UpdateRulesOfIpGroupResult.h>
#include <aws/workspaces/model/UpdateWorkspaceBundleRequest.h>
#include <aws/workspaces/model/UpdateWorkspaceBundleResult.h>
#include <aws/workspaces/model/UpdateWorkspaceImagePermissionRequest.h>
#include <aws/workspaces/model/UpdateWorkspaceImagePermissionResult.h>
#include <aws/workspaces/model/UpdateWorkspacesPoolRequest.h>
#include <aws/workspaces/model/UpdateWorkspacesPoolResult.h>
#include <aws/workspaces/model/UserIdentityType.h>
#include <aws/workspaces/model/UserSetting.h>
#include <aws/workspaces/model/UserSettingActionEnum.h>
#include <aws/workspaces/model/UserSettingPermissionEnum.h>
#include <aws/workspaces/model/UserStorage.h>
#include <aws/workspaces/model/WorkSpaceApplication.h>
#include <aws/workspaces/model/WorkSpaceApplicationDeployment.h>
#include <aws/workspaces/model/WorkSpaceApplicationLicenseType.h>
#include <aws/workspaces/model/WorkSpaceApplicationState.h>
#include <aws/workspaces/model/WorkSpaceAssociatedResourceType.h>
#include <aws/workspaces/model/Workspace.h>
#include <aws/workspaces/model/WorkspaceAccessProperties.h>
#include <aws/workspaces/model/WorkspaceBundle.h>
#include <aws/workspaces/model/WorkspaceBundleState.h>
#include <aws/workspaces/model/WorkspaceConnectionStatus.h>
#include <aws/workspaces/model/WorkspaceCreationProperties.h>
#include <aws/workspaces/model/WorkspaceDirectory.h>
#include <aws/workspaces/model/WorkspaceDirectoryState.h>
#include <aws/workspaces/model/WorkspaceDirectoryType.h>
#include <aws/workspaces/model/WorkspaceImage.h>
#include <aws/workspaces/model/WorkspaceImageErrorDetailCode.h>
#include <aws/workspaces/model/WorkspaceImageIngestionProcess.h>
#include <aws/workspaces/model/WorkspaceImageRequiredTenancy.h>
#include <aws/workspaces/model/WorkspaceImageState.h>
#include <aws/workspaces/model/WorkspaceProperties.h>
#include <aws/workspaces/model/WorkspaceRequest.h>
#include <aws/workspaces/model/WorkspaceResourceAssociation.h>
#include <aws/workspaces/model/WorkspaceState.h>
#include <aws/workspaces/model/WorkspaceType.h>
#include <aws/workspaces/model/WorkspacesIpGroup.h>
#include <aws/workspaces/model/WorkspacesPool.h>
#include <aws/workspaces/model/WorkspacesPoolError.h>
#include <aws/workspaces/model/WorkspacesPoolErrorCode.h>
#include <aws/workspaces/model/WorkspacesPoolSession.h>
#include <aws/workspaces/model/WorkspacesPoolState.h>

using WorkSpacesIncludeTest = ::testing::Test;

TEST_F(WorkSpacesIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::WorkSpaces::WorkSpacesClient>("WorkSpacesIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
