/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/workspaces-web/WorkSpacesWebClient.h>
#include <aws/workspaces-web/WorkSpacesWebEndpointProvider.h>
#include <aws/workspaces-web/WorkSpacesWebEndpointRules.h>
#include <aws/workspaces-web/WorkSpacesWebErrorMarshaller.h>
#include <aws/workspaces-web/WorkSpacesWebErrors.h>
#include <aws/workspaces-web/WorkSpacesWebRequest.h>
#include <aws/workspaces-web/WorkSpacesWebServiceClientModel.h>
#include <aws/workspaces-web/WorkSpacesWeb_EXPORTS.h>
#include <aws/workspaces-web/model/AssociateBrowserSettingsRequest.h>
#include <aws/workspaces-web/model/AssociateBrowserSettingsResult.h>
#include <aws/workspaces-web/model/AssociateDataProtectionSettingsRequest.h>
#include <aws/workspaces-web/model/AssociateDataProtectionSettingsResult.h>
#include <aws/workspaces-web/model/AssociateIpAccessSettingsRequest.h>
#include <aws/workspaces-web/model/AssociateIpAccessSettingsResult.h>
#include <aws/workspaces-web/model/AssociateNetworkSettingsRequest.h>
#include <aws/workspaces-web/model/AssociateNetworkSettingsResult.h>
#include <aws/workspaces-web/model/AssociateTrustStoreRequest.h>
#include <aws/workspaces-web/model/AssociateTrustStoreResult.h>
#include <aws/workspaces-web/model/AssociateUserAccessLoggingSettingsRequest.h>
#include <aws/workspaces-web/model/AssociateUserAccessLoggingSettingsResult.h>
#include <aws/workspaces-web/model/AssociateUserSettingsRequest.h>
#include <aws/workspaces-web/model/AssociateUserSettingsResult.h>
#include <aws/workspaces-web/model/AuthenticationType.h>
#include <aws/workspaces-web/model/BrowserSettings.h>
#include <aws/workspaces-web/model/BrowserSettingsSummary.h>
#include <aws/workspaces-web/model/BrowserType.h>
#include <aws/workspaces-web/model/Certificate.h>
#include <aws/workspaces-web/model/CertificateSummary.h>
#include <aws/workspaces-web/model/ConflictException.h>
#include <aws/workspaces-web/model/CookieSpecification.h>
#include <aws/workspaces-web/model/CookieSynchronizationConfiguration.h>
#include <aws/workspaces-web/model/CreateBrowserSettingsRequest.h>
#include <aws/workspaces-web/model/CreateBrowserSettingsResult.h>
#include <aws/workspaces-web/model/CreateDataProtectionSettingsRequest.h>
#include <aws/workspaces-web/model/CreateDataProtectionSettingsResult.h>
#include <aws/workspaces-web/model/CreateIdentityProviderRequest.h>
#include <aws/workspaces-web/model/CreateIdentityProviderResult.h>
#include <aws/workspaces-web/model/CreateIpAccessSettingsRequest.h>
#include <aws/workspaces-web/model/CreateIpAccessSettingsResult.h>
#include <aws/workspaces-web/model/CreateNetworkSettingsRequest.h>
#include <aws/workspaces-web/model/CreateNetworkSettingsResult.h>
#include <aws/workspaces-web/model/CreatePortalRequest.h>
#include <aws/workspaces-web/model/CreatePortalResult.h>
#include <aws/workspaces-web/model/CreateTrustStoreRequest.h>
#include <aws/workspaces-web/model/CreateTrustStoreResult.h>
#include <aws/workspaces-web/model/CreateUserAccessLoggingSettingsRequest.h>
#include <aws/workspaces-web/model/CreateUserAccessLoggingSettingsResult.h>
#include <aws/workspaces-web/model/CreateUserSettingsRequest.h>
#include <aws/workspaces-web/model/CreateUserSettingsResult.h>
#include <aws/workspaces-web/model/CustomPattern.h>
#include <aws/workspaces-web/model/DataProtectionSettings.h>
#include <aws/workspaces-web/model/DataProtectionSettingsSummary.h>
#include <aws/workspaces-web/model/DeleteBrowserSettingsRequest.h>
#include <aws/workspaces-web/model/DeleteBrowserSettingsResult.h>
#include <aws/workspaces-web/model/DeleteDataProtectionSettingsRequest.h>
#include <aws/workspaces-web/model/DeleteDataProtectionSettingsResult.h>
#include <aws/workspaces-web/model/DeleteIdentityProviderRequest.h>
#include <aws/workspaces-web/model/DeleteIdentityProviderResult.h>
#include <aws/workspaces-web/model/DeleteIpAccessSettingsRequest.h>
#include <aws/workspaces-web/model/DeleteIpAccessSettingsResult.h>
#include <aws/workspaces-web/model/DeleteNetworkSettingsRequest.h>
#include <aws/workspaces-web/model/DeleteNetworkSettingsResult.h>
#include <aws/workspaces-web/model/DeletePortalRequest.h>
#include <aws/workspaces-web/model/DeletePortalResult.h>
#include <aws/workspaces-web/model/DeleteTrustStoreRequest.h>
#include <aws/workspaces-web/model/DeleteTrustStoreResult.h>
#include <aws/workspaces-web/model/DeleteUserAccessLoggingSettingsRequest.h>
#include <aws/workspaces-web/model/DeleteUserAccessLoggingSettingsResult.h>
#include <aws/workspaces-web/model/DeleteUserSettingsRequest.h>
#include <aws/workspaces-web/model/DeleteUserSettingsResult.h>
#include <aws/workspaces-web/model/DisassociateBrowserSettingsRequest.h>
#include <aws/workspaces-web/model/DisassociateBrowserSettingsResult.h>
#include <aws/workspaces-web/model/DisassociateDataProtectionSettingsRequest.h>
#include <aws/workspaces-web/model/DisassociateDataProtectionSettingsResult.h>
#include <aws/workspaces-web/model/DisassociateIpAccessSettingsRequest.h>
#include <aws/workspaces-web/model/DisassociateIpAccessSettingsResult.h>
#include <aws/workspaces-web/model/DisassociateNetworkSettingsRequest.h>
#include <aws/workspaces-web/model/DisassociateNetworkSettingsResult.h>
#include <aws/workspaces-web/model/DisassociateTrustStoreRequest.h>
#include <aws/workspaces-web/model/DisassociateTrustStoreResult.h>
#include <aws/workspaces-web/model/DisassociateUserAccessLoggingSettingsRequest.h>
#include <aws/workspaces-web/model/DisassociateUserAccessLoggingSettingsResult.h>
#include <aws/workspaces-web/model/DisassociateUserSettingsRequest.h>
#include <aws/workspaces-web/model/DisassociateUserSettingsResult.h>
#include <aws/workspaces-web/model/EnabledType.h>
#include <aws/workspaces-web/model/ExpireSessionRequest.h>
#include <aws/workspaces-web/model/ExpireSessionResult.h>
#include <aws/workspaces-web/model/GetBrowserSettingsRequest.h>
#include <aws/workspaces-web/model/GetBrowserSettingsResult.h>
#include <aws/workspaces-web/model/GetDataProtectionSettingsRequest.h>
#include <aws/workspaces-web/model/GetDataProtectionSettingsResult.h>
#include <aws/workspaces-web/model/GetIdentityProviderRequest.h>
#include <aws/workspaces-web/model/GetIdentityProviderResult.h>
#include <aws/workspaces-web/model/GetIpAccessSettingsRequest.h>
#include <aws/workspaces-web/model/GetIpAccessSettingsResult.h>
#include <aws/workspaces-web/model/GetNetworkSettingsRequest.h>
#include <aws/workspaces-web/model/GetNetworkSettingsResult.h>
#include <aws/workspaces-web/model/GetPortalRequest.h>
#include <aws/workspaces-web/model/GetPortalResult.h>
#include <aws/workspaces-web/model/GetPortalServiceProviderMetadataRequest.h>
#include <aws/workspaces-web/model/GetPortalServiceProviderMetadataResult.h>
#include <aws/workspaces-web/model/GetSessionRequest.h>
#include <aws/workspaces-web/model/GetSessionResult.h>
#include <aws/workspaces-web/model/GetTrustStoreCertificateRequest.h>
#include <aws/workspaces-web/model/GetTrustStoreCertificateResult.h>
#include <aws/workspaces-web/model/GetTrustStoreRequest.h>
#include <aws/workspaces-web/model/GetTrustStoreResult.h>
#include <aws/workspaces-web/model/GetUserAccessLoggingSettingsRequest.h>
#include <aws/workspaces-web/model/GetUserAccessLoggingSettingsResult.h>
#include <aws/workspaces-web/model/GetUserSettingsRequest.h>
#include <aws/workspaces-web/model/GetUserSettingsResult.h>
#include <aws/workspaces-web/model/IdentityProvider.h>
#include <aws/workspaces-web/model/IdentityProviderSummary.h>
#include <aws/workspaces-web/model/IdentityProviderType.h>
#include <aws/workspaces-web/model/InlineRedactionConfiguration.h>
#include <aws/workspaces-web/model/InlineRedactionPattern.h>
#include <aws/workspaces-web/model/InstanceType.h>
#include <aws/workspaces-web/model/InternalServerException.h>
#include <aws/workspaces-web/model/IpAccessSettings.h>
#include <aws/workspaces-web/model/IpAccessSettingsSummary.h>
#include <aws/workspaces-web/model/IpRule.h>
#include <aws/workspaces-web/model/ListBrowserSettingsRequest.h>
#include <aws/workspaces-web/model/ListBrowserSettingsResult.h>
#include <aws/workspaces-web/model/ListDataProtectionSettingsRequest.h>
#include <aws/workspaces-web/model/ListDataProtectionSettingsResult.h>
#include <aws/workspaces-web/model/ListIdentityProvidersRequest.h>
#include <aws/workspaces-web/model/ListIdentityProvidersResult.h>
#include <aws/workspaces-web/model/ListIpAccessSettingsRequest.h>
#include <aws/workspaces-web/model/ListIpAccessSettingsResult.h>
#include <aws/workspaces-web/model/ListNetworkSettingsRequest.h>
#include <aws/workspaces-web/model/ListNetworkSettingsResult.h>
#include <aws/workspaces-web/model/ListPortalsRequest.h>
#include <aws/workspaces-web/model/ListPortalsResult.h>
#include <aws/workspaces-web/model/ListSessionsRequest.h>
#include <aws/workspaces-web/model/ListSessionsResult.h>
#include <aws/workspaces-web/model/ListTagsForResourceRequest.h>
#include <aws/workspaces-web/model/ListTagsForResourceResult.h>
#include <aws/workspaces-web/model/ListTrustStoreCertificatesRequest.h>
#include <aws/workspaces-web/model/ListTrustStoreCertificatesResult.h>
#include <aws/workspaces-web/model/ListTrustStoresRequest.h>
#include <aws/workspaces-web/model/ListTrustStoresResult.h>
#include <aws/workspaces-web/model/ListUserAccessLoggingSettingsRequest.h>
#include <aws/workspaces-web/model/ListUserAccessLoggingSettingsResult.h>
#include <aws/workspaces-web/model/ListUserSettingsRequest.h>
#include <aws/workspaces-web/model/ListUserSettingsResult.h>
#include <aws/workspaces-web/model/MaxDisplayResolution.h>
#include <aws/workspaces-web/model/NetworkSettings.h>
#include <aws/workspaces-web/model/NetworkSettingsSummary.h>
#include <aws/workspaces-web/model/Portal.h>
#include <aws/workspaces-web/model/PortalStatus.h>
#include <aws/workspaces-web/model/PortalSummary.h>
#include <aws/workspaces-web/model/RedactionPlaceHolder.h>
#include <aws/workspaces-web/model/RedactionPlaceHolderType.h>
#include <aws/workspaces-web/model/RendererType.h>
#include <aws/workspaces-web/model/ResourceNotFoundException.h>
#include <aws/workspaces-web/model/ServiceQuotaExceededException.h>
#include <aws/workspaces-web/model/Session.h>
#include <aws/workspaces-web/model/SessionSortBy.h>
#include <aws/workspaces-web/model/SessionStatus.h>
#include <aws/workspaces-web/model/SessionSummary.h>
#include <aws/workspaces-web/model/Tag.h>
#include <aws/workspaces-web/model/TagResourceRequest.h>
#include <aws/workspaces-web/model/TagResourceResult.h>
#include <aws/workspaces-web/model/ThrottlingException.h>
#include <aws/workspaces-web/model/TooManyTagsException.h>
#include <aws/workspaces-web/model/ToolbarConfiguration.h>
#include <aws/workspaces-web/model/ToolbarItem.h>
#include <aws/workspaces-web/model/ToolbarType.h>
#include <aws/workspaces-web/model/TrustStore.h>
#include <aws/workspaces-web/model/TrustStoreSummary.h>
#include <aws/workspaces-web/model/UntagResourceRequest.h>
#include <aws/workspaces-web/model/UntagResourceResult.h>
#include <aws/workspaces-web/model/UpdateBrowserSettingsRequest.h>
#include <aws/workspaces-web/model/UpdateBrowserSettingsResult.h>
#include <aws/workspaces-web/model/UpdateDataProtectionSettingsRequest.h>
#include <aws/workspaces-web/model/UpdateDataProtectionSettingsResult.h>
#include <aws/workspaces-web/model/UpdateIdentityProviderRequest.h>
#include <aws/workspaces-web/model/UpdateIdentityProviderResult.h>
#include <aws/workspaces-web/model/UpdateIpAccessSettingsRequest.h>
#include <aws/workspaces-web/model/UpdateIpAccessSettingsResult.h>
#include <aws/workspaces-web/model/UpdateNetworkSettingsRequest.h>
#include <aws/workspaces-web/model/UpdateNetworkSettingsResult.h>
#include <aws/workspaces-web/model/UpdatePortalRequest.h>
#include <aws/workspaces-web/model/UpdatePortalResult.h>
#include <aws/workspaces-web/model/UpdateTrustStoreRequest.h>
#include <aws/workspaces-web/model/UpdateTrustStoreResult.h>
#include <aws/workspaces-web/model/UpdateUserAccessLoggingSettingsRequest.h>
#include <aws/workspaces-web/model/UpdateUserAccessLoggingSettingsResult.h>
#include <aws/workspaces-web/model/UpdateUserSettingsRequest.h>
#include <aws/workspaces-web/model/UpdateUserSettingsResult.h>
#include <aws/workspaces-web/model/UserAccessLoggingSettings.h>
#include <aws/workspaces-web/model/UserAccessLoggingSettingsSummary.h>
#include <aws/workspaces-web/model/UserSettings.h>
#include <aws/workspaces-web/model/UserSettingsSummary.h>
#include <aws/workspaces-web/model/ValidationException.h>
#include <aws/workspaces-web/model/ValidationExceptionField.h>
#include <aws/workspaces-web/model/ValidationExceptionReason.h>
#include <aws/workspaces-web/model/VisualMode.h>

using WorkSpacesWebIncludeTest = ::testing::Test;

TEST_F(WorkSpacesWebIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::WorkSpacesWeb::WorkSpacesWebClient>("WorkSpacesWebIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
