/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/xray/XRayClient.h>
#include <aws/xray/XRayEndpointProvider.h>
#include <aws/xray/XRayEndpointRules.h>
#include <aws/xray/XRayErrorMarshaller.h>
#include <aws/xray/XRayErrors.h>
#include <aws/xray/XRayRequest.h>
#include <aws/xray/XRayServiceClientModel.h>
#include <aws/xray/XRay_EXPORTS.h>
#include <aws/xray/model/Alias.h>
#include <aws/xray/model/AnnotationValue.h>
#include <aws/xray/model/AnomalousService.h>
#include <aws/xray/model/AvailabilityZoneDetail.h>
#include <aws/xray/model/BackendConnectionErrors.h>
#include <aws/xray/model/BatchGetTracesRequest.h>
#include <aws/xray/model/BatchGetTracesResult.h>
#include <aws/xray/model/CancelTraceRetrievalRequest.h>
#include <aws/xray/model/CancelTraceRetrievalResult.h>
#include <aws/xray/model/CreateGroupRequest.h>
#include <aws/xray/model/CreateGroupResult.h>
#include <aws/xray/model/CreateSamplingRuleRequest.h>
#include <aws/xray/model/CreateSamplingRuleResult.h>
#include <aws/xray/model/DeleteGroupRequest.h>
#include <aws/xray/model/DeleteGroupResult.h>
#include <aws/xray/model/DeleteResourcePolicyRequest.h>
#include <aws/xray/model/DeleteResourcePolicyResult.h>
#include <aws/xray/model/DeleteSamplingRuleRequest.h>
#include <aws/xray/model/DeleteSamplingRuleResult.h>
#include <aws/xray/model/Edge.h>
#include <aws/xray/model/EdgeStatistics.h>
#include <aws/xray/model/EncryptionConfig.h>
#include <aws/xray/model/EncryptionStatus.h>
#include <aws/xray/model/EncryptionType.h>
#include <aws/xray/model/ErrorRootCause.h>
#include <aws/xray/model/ErrorRootCauseEntity.h>
#include <aws/xray/model/ErrorRootCauseService.h>
#include <aws/xray/model/ErrorStatistics.h>
#include <aws/xray/model/FaultRootCause.h>
#include <aws/xray/model/FaultRootCauseEntity.h>
#include <aws/xray/model/FaultRootCauseService.h>
#include <aws/xray/model/FaultStatistics.h>
#include <aws/xray/model/ForecastStatistics.h>
#include <aws/xray/model/GetEncryptionConfigRequest.h>
#include <aws/xray/model/GetEncryptionConfigResult.h>
#include <aws/xray/model/GetGroupRequest.h>
#include <aws/xray/model/GetGroupResult.h>
#include <aws/xray/model/GetGroupsRequest.h>
#include <aws/xray/model/GetGroupsResult.h>
#include <aws/xray/model/GetIndexingRulesRequest.h>
#include <aws/xray/model/GetIndexingRulesResult.h>
#include <aws/xray/model/GetInsightEventsRequest.h>
#include <aws/xray/model/GetInsightEventsResult.h>
#include <aws/xray/model/GetInsightImpactGraphRequest.h>
#include <aws/xray/model/GetInsightImpactGraphResult.h>
#include <aws/xray/model/GetInsightRequest.h>
#include <aws/xray/model/GetInsightResult.h>
#include <aws/xray/model/GetInsightSummariesRequest.h>
#include <aws/xray/model/GetInsightSummariesResult.h>
#include <aws/xray/model/GetRetrievedTracesGraphRequest.h>
#include <aws/xray/model/GetRetrievedTracesGraphResult.h>
#include <aws/xray/model/GetSamplingRulesRequest.h>
#include <aws/xray/model/GetSamplingRulesResult.h>
#include <aws/xray/model/GetSamplingStatisticSummariesRequest.h>
#include <aws/xray/model/GetSamplingStatisticSummariesResult.h>
#include <aws/xray/model/GetSamplingTargetsRequest.h>
#include <aws/xray/model/GetSamplingTargetsResult.h>
#include <aws/xray/model/GetServiceGraphRequest.h>
#include <aws/xray/model/GetServiceGraphResult.h>
#include <aws/xray/model/GetTimeSeriesServiceStatisticsRequest.h>
#include <aws/xray/model/GetTimeSeriesServiceStatisticsResult.h>
#include <aws/xray/model/GetTraceGraphRequest.h>
#include <aws/xray/model/GetTraceGraphResult.h>
#include <aws/xray/model/GetTraceSegmentDestinationRequest.h>
#include <aws/xray/model/GetTraceSegmentDestinationResult.h>
#include <aws/xray/model/GetTraceSummariesRequest.h>
#include <aws/xray/model/GetTraceSummariesResult.h>
#include <aws/xray/model/GraphLink.h>
#include <aws/xray/model/Group.h>
#include <aws/xray/model/GroupSummary.h>
#include <aws/xray/model/HistogramEntry.h>
#include <aws/xray/model/Http.h>
#include <aws/xray/model/IndexingRule.h>
#include <aws/xray/model/IndexingRuleValue.h>
#include <aws/xray/model/IndexingRuleValueUpdate.h>
#include <aws/xray/model/Insight.h>
#include <aws/xray/model/InsightCategory.h>
#include <aws/xray/model/InsightEvent.h>
#include <aws/xray/model/InsightImpactGraphEdge.h>
#include <aws/xray/model/InsightImpactGraphService.h>
#include <aws/xray/model/InsightState.h>
#include <aws/xray/model/InsightSummary.h>
#include <aws/xray/model/InsightsConfiguration.h>
#include <aws/xray/model/InstanceIdDetail.h>
#include <aws/xray/model/ListResourcePoliciesRequest.h>
#include <aws/xray/model/ListResourcePoliciesResult.h>
#include <aws/xray/model/ListRetrievedTracesRequest.h>
#include <aws/xray/model/ListRetrievedTracesResult.h>
#include <aws/xray/model/ListTagsForResourceRequest.h>
#include <aws/xray/model/ListTagsForResourceResult.h>
#include <aws/xray/model/ProbabilisticRuleValue.h>
#include <aws/xray/model/ProbabilisticRuleValueUpdate.h>
#include <aws/xray/model/PutEncryptionConfigRequest.h>
#include <aws/xray/model/PutEncryptionConfigResult.h>
#include <aws/xray/model/PutResourcePolicyRequest.h>
#include <aws/xray/model/PutResourcePolicyResult.h>
#include <aws/xray/model/PutTelemetryRecordsRequest.h>
#include <aws/xray/model/PutTelemetryRecordsResult.h>
#include <aws/xray/model/PutTraceSegmentsRequest.h>
#include <aws/xray/model/PutTraceSegmentsResult.h>
#include <aws/xray/model/RequestImpactStatistics.h>
#include <aws/xray/model/ResourceARNDetail.h>
#include <aws/xray/model/ResourceNotFoundException.h>
#include <aws/xray/model/ResourcePolicy.h>
#include <aws/xray/model/ResponseTimeRootCause.h>
#include <aws/xray/model/ResponseTimeRootCauseEntity.h>
#include <aws/xray/model/ResponseTimeRootCauseService.h>
#include <aws/xray/model/RetrievalStatus.h>
#include <aws/xray/model/RetrievedService.h>
#include <aws/xray/model/RetrievedTrace.h>
#include <aws/xray/model/RootCauseException.h>
#include <aws/xray/model/SamplingRule.h>
#include <aws/xray/model/SamplingRuleRecord.h>
#include <aws/xray/model/SamplingRuleUpdate.h>
#include <aws/xray/model/SamplingStatisticSummary.h>
#include <aws/xray/model/SamplingStatisticsDocument.h>
#include <aws/xray/model/SamplingStrategy.h>
#include <aws/xray/model/SamplingStrategyName.h>
#include <aws/xray/model/SamplingTargetDocument.h>
#include <aws/xray/model/Segment.h>
#include <aws/xray/model/Service.h>
#include <aws/xray/model/ServiceId.h>
#include <aws/xray/model/ServiceStatistics.h>
#include <aws/xray/model/Span.h>
#include <aws/xray/model/StartTraceRetrievalRequest.h>
#include <aws/xray/model/StartTraceRetrievalResult.h>
#include <aws/xray/model/Tag.h>
#include <aws/xray/model/TagResourceRequest.h>
#include <aws/xray/model/TagResourceResult.h>
#include <aws/xray/model/TelemetryRecord.h>
#include <aws/xray/model/TimeRangeType.h>
#include <aws/xray/model/TimeSeriesServiceStatistics.h>
#include <aws/xray/model/TooManyTagsException.h>
#include <aws/xray/model/Trace.h>
#include <aws/xray/model/TraceFormatType.h>
#include <aws/xray/model/TraceSegmentDestination.h>
#include <aws/xray/model/TraceSegmentDestinationStatus.h>
#include <aws/xray/model/TraceSummary.h>
#include <aws/xray/model/TraceUser.h>
#include <aws/xray/model/UnprocessedStatistics.h>
#include <aws/xray/model/UnprocessedTraceSegment.h>
#include <aws/xray/model/UntagResourceRequest.h>
#include <aws/xray/model/UntagResourceResult.h>
#include <aws/xray/model/UpdateGroupRequest.h>
#include <aws/xray/model/UpdateGroupResult.h>
#include <aws/xray/model/UpdateIndexingRuleRequest.h>
#include <aws/xray/model/UpdateIndexingRuleResult.h>
#include <aws/xray/model/UpdateSamplingRuleRequest.h>
#include <aws/xray/model/UpdateSamplingRuleResult.h>
#include <aws/xray/model/UpdateTraceSegmentDestinationRequest.h>
#include <aws/xray/model/UpdateTraceSegmentDestinationResult.h>
#include <aws/xray/model/ValueWithServiceIds.h>

using XRayIncludeTest = ::testing::Test;

TEST_F(XRayIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::XRay::XRayClient>("XRayIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
