m4_include(`farversion.m4')m4_dnl
.Language=Russian,Russian (Русский)
.Options CtrlColorChar=\
.Options CtrlStartPosChar=^<wrap>

@Contents
$^#Программа управления файлами и архивами#
`$^#'FULLVERSIONNOBRACES`#'
`$^#©1996-2000 Eugene Roshal, ©2000-2016 FAR Group,' ©COPYRIGHTYEARS `FAR People'#
   ~Особенности FAR2L - начало работы~@Far2lGettingStarted@

   ~Индекс файла помощи~@Index@
   ~Как пользоваться помощью~@Help@

   ~Что такое FAR2L~@About@
   ~Лицензия~@License@

   ~Режимы интерфейса~@UIBackends@
   ~Параметры командной строки~@CmdLine@
   ~Клавиатурные команды~@KeyRef@
   ~Поддержка подключаемых модулей~@Plugins@
   ~Обзор возможностей подключаемых модулей~@PluginsReviews@
   ~Терминал~@Terminal@

   ~Панели:~@Panels@  ~Панель файлов~@FilePanel@
            ~Дерево папок~@TreePanel@
            ~Панель информации~@InfoPanel@
            ~Панель быстрого просмотра~@QViewPanel@
            ~Перетаскивание файлов~@DragAndDrop@
            ~Настройка режимов просмотра панели файлов~@PanelViewModes@
            ~Пометка файлов~@SelectFiles@

   ~Меню:~@Menus@    ~Меню левой и правой панелей~@LeftRightMenu@
            ~Меню файлов~@FilesMenu@
            ~Меню команд~@CmdMenu@
            ~Меню параметров~@OptMenu@

   ~Поиск файла~@FindFile@
   ~История команд~@History@
   ~Поиск папки~@FindFolder@
   ~Сравнение папок~@CompFolders@
   ~Меню пользователя~@UserMenu@
   ~Меню перехода~@DriveDlg@

   ~Ассоциации файлов~@FileAssoc@
   ~Команды операционной системы~@OSCommands@
   ~Закладки~@Bookmarks@
   ~Меню фильтров~@FiltersMenu@
   ~Переключение между экранами~@ScrSwitch@
   ~Список задач~@TaskList@

   ~Системные параметры~@SystemSettings@
   ~Настройки панели~@PanelSettings@
   ~Настройки интерфейса~@InterfSettings@
   ~Настройки ввода~@InputSettings@
   ~Настройки диалогов~@DialogSettings@
   ~Настройки меню~@VMenuSettings@
   ~Настройки командной строки~@CmdlineSettings@
   ~Настройки меню перехода~@ChangeLocationConfig@

   ~Раскраска файлов и группы сортировки~@Highlight@
   ~Описания файлов~@FileDiz@
   ~Настройки программы просмотра~@ViewerSettings@
   ~Настройки редактора~@EditorSettings@

   ~Копирование, перенос, переименование и создание ссылок~@CopyFiles@

   ~Встроенная программа просмотра~@Viewer@
   ~Встроенный редактор~@Editor@

   ~Маски файлов~@FileMasks@
   ~Клавиатурные макрокоманды~@KeyMacro@


@Help
$ # FAR: как пользоваться помощью#
    В оглавлении справочной системы имеются ссылки (они функционируют примерно
так же, как и гиперссылки, знакомые каждому пользователю Интернет), которые
указывают на разделы с более подробной информацией. Дополнительно на главной
странице находится "~Индекс файла помощи~@Index@", он показывает оглавления
всех страничек (топиков) имеющихся в файле помощи и, в ряде случаев, позволяет
быстрее найти необходимую информацию.

    Для перемещения между ссылками вы можете использовать #Tab# и #Shift-Tab#.
Нажатие #Enter# вызовет страницу, соответствующую выбранной ссылке. Этот же
результат можно получить нажав кнопку "мыши" на требуемой ссылке.

    Если текст помещается в окне помощи не полностью, то появляется полоса
прокрутки. В этом случае текст можно перемещать вверх и вниз с помощью #клавиш#
#управления курсором#.

    Нажатие #Alt-F1# или #BS# приводит к переходу на предыдущую страницу.
#Shift-F1# вызывает содержание помощи.

    Нажмите #F7# для поиска по помощи (отображает разделы справки, содержащие искомый фрагмент текста).

    Нажмите #Shift-F2#, чтобы получить помощь по ~внешним модулям~@Plugins@.

    По умолчанию "#Помощь#" показывается в свёрнутом окне, развернуть его можно
при помощи клавиши #F5# "#Размер#", повторное нажатие #F5# вернёт размер окна в
первоначальное состояние.

   #Ctrl-Alt-Shift#   Временно скрыть окно помощи (работает до тех пор, пока удерживаем эти клавиши).

@About
$ # FAR: что это такое#
    #FAR2L# - это работающая в текстовом режиме программа управления файлами, которая
имеет обширный набор дополнительных функций.

    #FAR2L# является #freeware# и #open source# программой, распространяемой
под GNU GPL v2 ~лицензией~@License@.

    #FAR2L# позволяет работать с #архивами#. При этом файлы в архивах
обрабатываются аналогично файлам в папках. #FAR2L# сам преобразует ваши команды в
соответствующие вызовы внешних архиваторов.

    #FAR2L# также обеспечивает значительное количество сервисных функций.

  - FAR2L официальный сайт
    ~http://github.com/elfmz/far2l~@http://github.com/elfmz/far2l@
  - Официальный сайт исходного проекта FAR Manager
    ~http://www.farmanager.com~@http://www.farmanager.com@

    См. также:
    ~Особенности FAR2L - начало работы~@Far2lGettingStarted@
    ~Лицензия~@License@

@Far2lGettingStarted
$ # Особенности FAR2L - начало работы#
    FAR2L - Linux порт FAR Manager v2 (см.: ~Что такое FAR2L~@About@)
    FAR2L официальный сайт: ~https://github.com/elfmz/far2l~@https://github.com/elfmz/far2l@

    Столкнулись с проблемой? Поищите решение в wiki сообщества:
~https://github.com/akruphi/far2l/wiki~@https://github.com/akruphi/far2l/wiki@

 #Режимы интерфейса#
    У FAR2L основные бекенды отрисовки (подробности в ~Режимы интерфейса~@UIBackends@):
        - #GUI# - на базе wxWidgets, работает в графическом режиме, #идеальный UX#
(возможны дополнительные зависимости к вашей desktop environment: wxWidgets toolkit и соответствующие пакеты);
        - #TTY|Xi# - работает в терминальном режиме, зависимости буквально от пары иксовых либ
(для поддержки буфера обмена и всех-всех сочетаний клавиш в окружениях X11), #почти идеальный UX#;
        - #TTY|X# - работает в терминальном режиме, через X11 поддержка буфера обмена, клавиатура через возможности терминала;
        - #TTY# - чистый терминальный режим, никаких иксовых зависимостей, #UX с некоторыми ограничениями#
(полноценно работает при запуске в эмуляторах терминалов,
предоставляющих возможность доступа к буферу обмена и расширенную информацию о клавиатурных событиях, см. список ниже).
    Версию FAR2L и используемый бекенд можно увидеть в заголовке окна или через ~псевдо-команду~@SpecCmd@ #far:about#.
    #TTY|Xi# не работает под Wayland из-за модели безопасности Wayland, при его запуске far2l переключается на #TTY|X# без i.
    Запуск far2l и выбор бекенда:
        - если у Вас установлена версия с собранным GUI бекендом, будет использоваться он;
        - для принудительного запуска терминального варианта TTY|Xi используйте в командной строке: #far2l --tty#;
        - для принудительного запуска терминального варианта TTY|X используйте в командной строке: #far2l --tty --nodetect=xi#;
        - для принудительного запуска минимального варианта TTY используйте в командной строке: #far2l --tty --nodetect=x#;
        - фоновый запуск FAR2L-GUI из командной строки без блокировки терминала: #far2l --notty &#
    (подробнее про ключи запуска в ~Параметры командной строки~@CmdLine@ или #far2l --help#).


 #Перехват комбинаций клавиш оболочками и терминалами#
    Многие комбинации клавиш #Alt-F1#, #Alt-F2#, #Alt-F7#, #Ctrl-стрелки# и т.п.
перехватываются оболочками GNOME, KDE, Xfce, macOS и т.п. Для работы отключайте их в настройках оболочек
(под GNOME можно использовать #dconf-editor org.gnome.desktop.wm.keybindings# для просмотра и изменения глобальных сочетаний клавиш).
    Эмуляторы терминалов также часто не передают запущенным в них консольным приложениям часть комбинаций клавиш, или не различают нажатие различных комбинаций модификаторов (#Ctrl#, #Alt# и т.п.).
    Также можно использовать лайфхаки FAR2L:
        - ~Липкие управляющие кнопки~@MiscCmd@ через #Ctrl-Space# или #Alt-Space#;
        - опцию Эксклюзивная обработка нажатий в ~параметрах ввода~@InputSettings@ (только в GUI режиме под X11).


 #Особенность клавиатур в macOS#
    - клавиши #Option# соответствуют модификаторам #Alt#;
    - far2l-GUI только: обе клавиши #Command# работают как левый #Ctrl#, обе клавиши #Ctrl# - как правый #Ctrl#;
    - клавиша #Clear# на цифровой клавиатуре переключает режим NumLock;
    - клавиша #0# на цифровой клавиатуре выполняет функцию #Insert#, когда NumLock выключен;
    - на внешних windows-клавиатурах macOS меняет местами #Alt# и #Win# (считая что ближняя к пробелу клавиша слева - это #Command#, как на клавиатуре макбука).


 #Решение для macOS#, если far2l регулярно запрашивает доступ к папкам
    После команды #sudo codesign --force --deep --sign - /Applications/far2l.app# достаточно один раз предоставить разрешение.


 #Изменение шрифта для FAR2L-GUI#
    - Меню(#F9#)->Параметры->Настройки интерфейса->[ Выбрать шрифт ]


 #Особенность вставки в терминалах#
    Есть комбинация #вставки терминала# (терминал имитирует ввод с клавиатуры через bracketed paste) и есть #вставка самого фара# (сам FAR2L делает paste). При этом комбинация вставки терминала в разных терминалах разная (и может перекрывать стандартные клавиши вставки FAR2L #Shift-Ins# или #Ctrl-V#).
    В версии без TTY|X (и без включенной поддержки OSC 52 как в FAR2L, так и в терминале) вставка самого фара использует его #внутренний буфер# (т.к. FAR2L не получает доступ к системному буферу обмена), а вставка терминала - #системный буфер обмена#.


 #Командная строка FAR2L & bash#
    Внутренняя командная строка FAR2L полноценно работает только через #bash#.
    Можно сменить оболочку через Меню(#F9#)->Параметры->~Настройки командной строки~@CmdlineSettings@->#Использовать шелл#, но тогда командная строка будет работать с значительными ограничениями/ошибками, особенно с собственными командами оболочки.
    Если в вашей системе нет #bash#, желательно установить его и использовать только bash в FAR2L.
    Если по умолчанию ваша системная оболочка не bash, возможно, вам будет удобно также прописать ваши переменные среды, алиасы и т.п. в файлах запуска bash.


 #Дистанционный доступ к FAR2L на удаленном компьютере#
    При обрыве сессии запущенный на удаленном FAR2L не умирает, а остается ждать переподключения (поведение изменяется ~параметрами командной строки~@CmdLine@ #--immortal# и #--mortal#), и при последующем запуске FAR2L найдёт предыдущий запущенный и попробует восстановиться.
    Для передачи на запущенный на удалённом компьютере FAR2L расширенных сочетаний клавиш и буфера обмена необходимо инициировать соединение из умеющих это клиентов (см. список ниже).


 #Специальные возможности конфигурирования FAR2L, запущенного в эмуляторах терминалов#
    - Меню(#F9#)->Параметры->Настройки интерфейса->#Исп. OSC52 для записи в буфер обмена#
(виден в диалоге только если FAR2L запущен в режиме TTY/TTY|X и все остальные варианты поддержки клипборда недоступны).
Вы можете запустить #far2l --tty --nodetect# для принудительного неиспользования других вариантов взаимодействия с буфером обмена.
    - Меню(#F9#)->Параметры->Настройки интерфейса->#Исп. свою палитру базовых цветов#
(виден в диалоге только если FAR2L запущен в режиме TTY/TTY|X) позволяет far2l настраивать цвета палитры терминала.
Если Ваш терминал не поддерживает последовательности OSC4, выключение данной опции позволяет избежать появления в терминале артефактов после выхода из far2l.


 #Полноценная работа с буфером обмена в чистой терминальной версии FAR2L TTY#
    Для взаимодействия с буфером обмена необходимо как не забыть включить #OSC 52# в #настройках FAR2L#
(см. подробности выше),
так и #разрешить OSC 52# в #настройках терминалов#
(по умолчанию OSC 52 отключен в части терминалов из соображений безопасности; OSC 52 в куче терминалов реализован только для режима copy, а paste из терминала идёт через т.н. bracketed paste mode).


 #Терминалы и ssh-клиенты, поддерживающие расширенные сочетания клавиш FAR2L для чистой терминальной версии FAR2L TTY#
    - Встроенный терминал #FAR2L-GUI# (Linux/BSD, macOS),
см. ~Режимы интерфейса~@UIBackends@ и в помощи #NetRocks plugin# раздел #Command line and remote FAR2L#
(~TTY|F режим~@UIBackends@: клавиши и буфер обмена через FAR2L TTY extensions support)
    - kovidgoyal's #kitty# (Linux/BSD, macOS): ~https://github.com/kovidgoyal/kitty~@https://github.com/kovidgoyal/kitty@ & ~https://sw.kovidgoyal.net/kitty~@https://sw.kovidgoyal.net/kitty@
(~TTY|k режим~@UIBackends@: клавиши через kovidgoyal's kitty keyboard protocol;
для взаимодействия с клипбордом включить OSC 52 и в kitty и в far2l)
    - #Alacritty# (Linux/BSD, macOS, Windows): ~https://github.com/alacritty/alacritty~@https://github.com/alacritty/alacritty@ & ~https://alacritty.org/~@https://alacritty.org/@
(~TTY|k режим~@UIBackends@: клавиши через kovidgoyal's kitty keyboard protocol;
для взаимодействия с клипбордом включить OSC 52 только в far2l)
[под Windows в системе должен быть conpty.dll]
    - #Rio Terminal# (Linux/BSD, macOS, Windows):  ~https://github.com/raphamorim/rio~@https://github.com/raphamorim/rio@ & ~https://raphamorim.io/rio/~@https://raphamorim.io/rio/@
(~TTY|k режим~@UIBackends@: клавиши через kovidgoyal's kitty keyboard protocol;
для взаимодействия с клипбордом включить OSC 52 только в far2l)
    - #Ghostty# (Linux, macOS): ~https://github.com/ghostty-org/ghostty~@https://github.com/ghostty-org/ghostty@ & ~https://ghostty.org/~@https://ghostty.org/@
(~TTY|k режим~@UIBackends@: клавиши через kovidgoyal's kitty keyboard protocol;
для взаимодействия с клипбордом включить OSC 52 только в far2l)
    - #Wez's Terminal Emulator# (Linux/BSD, Windows): ~https://github.com/wez/wezterm~@https://github.com/wez/wezterm@ & ~https://wezfurlong.org/wezterm~@https://wezfurlong.org/wezterm@
(~TTY|k режим~@UIBackends@: клавиши в Linux/BSD через kovidgoyal's kitty keyboard protocol;
~TTY|w режим~@UIBackends@: клавиши в Windows через win32-input-mode, который включен по умолчанию;
для взаимодействия с клипбордом включить OSC 52)
[в macOS и в Windows в wezterm поддержка режима kitty не работает]
    - #iTerm2# (macOS): ~https://gitlab.com/gnachman/iterm2~@https://gitlab.com/gnachman/iterm2@ & ~https://iterm2.com~@https://iterm2.com@
(~TTY|a режим~@UIBackends@: клавиши через iTerm2 "raw keyboard" protocol; для взаимодействия с клипбордом включить OSC 52)
    - #Windows Terminal# [в win11 стоит из коробки, в win10 надо ставить]
(~TTY|w режим~@UIBackends@: клавиши через win32-input-mode; для взаимодействия с клипбордом включить OSC 52;
присутствует баг с мышью: ~https://github.com/microsoft/terminal/issues/15083~@https://github.com/microsoft/terminal/issues/15083@)

  Оригинальный PuTTY не корректно пересылает в far2l некоторые клавиатурные комбинации.
Под Windows используйте специальные форки putty с поддержкой far2l TTY extensions support:
    - #putty4far2l# (Windows ssh-клиент): ~https://github.com/ivanshatsky/putty4far2l/releases~@https://github.com/ivanshatsky/putty4far2l/releases@ & ~https://github.com/unxed/putty4far2l~@https://github.com/unxed/putty4far2l@
(~TTY|F режим~@UIBackends@: клавиши и буфер обмена через FAR2L TTY extensions support)
    - cyd01's #KiTTY# (Windows ssh-клиент): ~https://github.com/cyd01/KiTTY~@https://github.com/cyd01/KiTTY@ & ~https://www.9bis.net/kitty~@https://www.9bis.net/kitty@
(~TTY|F режим~@UIBackends@: клавиши и буфер обмена через FAR2L TTY extensions support)
    - #putty-nd# (Windows ssh-клиент): ~https://sourceforge.net/projects/putty-nd~@https://sourceforge.net/projects/putty-nd@ & ~https://github.com/noodle1983/putty-nd~@https://github.com/noodle1983/putty-nd@
(~TTY|F режим~@UIBackends@: клавиши и буфер обмена через FAR2L TTY extensions support)
    - #PuTTY 0.82+#: начиная с версии 0.82 в ванильном PuTTY в настройках клавиатуры можно выставить #Xterm 216+# и #xterm-style bitmap# (см.: ~https://github.com/elfmz/far2l/issues/2630~@https://github.com/elfmz/far2l/issues/2630@),
но оригинальный PuTTY не может передавать буфер обмена.


 #Расположение персональных настроек FAR2L и истории#
    - по умолчанию FAR2L работает с настройками, хранящимися в #~~/.config/far2l/# или в #$XDG_CONFIG_HOME/far2l/#
    - при запуске ключ #-u# (или ~переменная окружения~@FAREnv@ #$FARSETTINGS#) позволяет указать путь к произвольному расположению настроек:
        #-u <path># - в #path/.config/# (если path или $FARSETTINGS является полным путем)
        #-u <identity># - в #~~/.config/far2l/custom/identity/# или в #$XDG_CONFIG_HOME/far2l/custom/identity/#
    - некоторые файлы настроек (могут отсутствовать): 
        - #settings/config.ini# - основной конфиг
        - #settings/colors.ini# - ~раскраска файлов и группы сортировки~@Highlight@ (настраиваются через F9->Параметры->Раскраска файлов и группы сортировки)
        - #settings/farcolors.ini# - цвета интерфейса (настраиваются через F9->~Параметры~@OptMenu@->Цвета)
        - #settings/key_macros.ini# - ~клавиатурные макрокоманды~@KeyMacro@
        - #settings/user_menu.ini# - главное ~меню пользователя~@UserMenu@ (настраиваются через F9->Команды->Меню пользователя; формат отличается от FarMenu.ini местных меню)
        - #settings/associations.ini# - ~ассоциации файлов~@FileAssoc@ (настраиваются через F9->Команды->Ассоциации файлов)
        - #settings/bookmarks.ini# - ~закладки~@Bookmarks@ на каталоги для быстрого перехода по RCtrl-0...9 или Ctrl-Alt-0...9 (настраиваются через F9->Команды->Закладки на папки)
        - #favorites# - закладки в ~меню перехода~@DriveDlg@, которое по Alt-F1/F2
        - #cp# - принудительное выставление OEM и ANSI кодировок (см. ~Определение кодировок ANSI и OEM~@CodePagesSet@)
        - #plugins# - плагины
            - #plugins/state.ini# - кэш плагинов
            - #plugins/NetRocks/sites.cfg# - NetRocks sites
            - #plugins/multiarc/custom.ini# - добавление архиваторов командной строки
        - #clipboard# - bash-скрипт (должен иметь права выполнения chmod +x) для работы с буфером обмена, если встроенные средства почему-то не получают доступ


    См. также:
    ~Что такое FAR2L~@About@
    ~Лицензия~@License@

    ~Индекс файла помощи~@Index@
    ~Как пользоваться помощью~@Help@

    ~Режимы интерфейса~@UIBackends@
    ~Параметры командной строки~@CmdLine@ или #far2l --help#
    ~Определение кодировок ANSI и OEM~@CodePagesSet@

@License
$ # FAR2L: Лицензия#
Проект распространяется под лицензией GNU GPL v2, при этом некоторые файлы
изначально лицензированы под 3-clause BSD лицензией.
Смотрите LICENSE.txt и LICENSE.Far2.txt в исходных файлах для деталей.

@CmdLine
$ # FAR2L: параметры командной строки#
  Актуальный список см. через #far2l -h# или #far2l --help#.

  Вы можете задавать следующие аргументы в командной строке.


 #Параметры режимов интерфейса FAR2L (backend-specific options)#
  #--tty#
  Запускает far2l сразу в ~режиме TTY~@UIBackends@ вместо автоматического определения возможности
работы в режиме GUI. Хотя GUI режим предпочтителен с точки зрения пользовательского
опыта, иногда может потребоваться запуск строго в терминальном режиме.

  #--notty#
  Не использовать терминальный режим при невозможности использовать ~GUI режим~@UIBackends@.

  #--nodetect#=[x|xi][f][w][a][k]
  По умолчанию far2l пытается на запуске определить, не работает ли он в терминале другого
far2l. В этом случае far2l автоматически использует режим TTY с расширениями терминала far2l. В
случае отсутствия таких расширений терминала - far2l проверяет наличие доступа к X11 сессии и
использует её для улучшения возможностей интерфейса, если был собран с опцией TTYX.
  Указание параметров позволяет отключать только отдельные ~расширения~@UIBackends@:
   - f  - выключение определения и использования расширений терминала far2l;
   - x  - выключение определения и использования X11 (и буфер обмена и клавиатура);
   - xi - выключение определения и использования клавитауры через X11;
   - a  - выключение определения и использования режима apple iTerm2;
   - k  - выключение определения и использования режима kovidgoyal's kitty;
   - w  - выключение определения и использования режима win32.
  Данный ключ без параметров выключает всю перечисленную функциональность, предотвращая автоопределение наличия
расширений, и разрешает к использованию лишь базовые возможности обычного терминала в TTY режиме.

  #--mortal#
  Этот аргумент применим только для far2l, который работает в режиме TTY. По умолчанию при закрытии
терминала far2l продолжает работать 'в фоне' и при последующем запуске другого far2l в режиме TTY
будет предложено активировать ушедший в фон far2l вместо запуска новой копии приложения. Этот ключ
командной строки полностью отключает данную функциональность, так что закрытие терминала будет приводить
к безусловному завершению работы far2l, работающего в нем.

  #--primary-selection#
  Использовать PRIMARY selection вместо CLIPBOARD X11 selection. Этот аргумент применим только для
far2l, который работает в режиме WX.


 #FAR2L command-line options:#
  #-a#
  Запрет отображения символов с кодами 0 - 31 и 255. Может быть полезно при
запуске FAR2L из telnet.

  #-ag#
  Запрет отображения псевдографических символов с кодами > 127.

  #-an#
  Вообще не отображать псевдографические символы.

  #-e[<строка>[:<позиция>]] <filename>#
  Редактирование указанного файла. После -e можно дополнительно указать строку
и позицию в строке, устанавливаемые после запуска редактора.
  Например: #far2l -e70:2 readme#.

  #-co#
  Заставляет FAR2L загружать внешние модули только из кэша. Загрузка при этом происходит
быстрее, но новые или изменённые модули не обнаруживаются. Имеет смысл применять
ТОЛЬКО при стабильном списке модулей. После добавления, замены или удаления модулей
надо загрузить FAR2L без этого параметра. Если кэша нет, то модули загружаться не будут.
  Если ключ -co не указан, то загрузятся плагины из основного каталога и из каталога,
указанного в параметре "~Путь к персональным плагинам~@PluginsManagerSettings@"

  #-m#
  При старте FAR2L не будет загружать макрокоманды из файла конфигурации.

  #-ma#
  При старте FAR2L не будет выполнять макрокоманды с опцией "Выполнять после запуска FAR2L".

  #-u <identity># или #-u <path>#
  Позволяет использовать раздельные настройки для различных пользователей
или указать расположение настроек в файловой системе (перекрывает значение ~переменной среды~@FAREnv@ #FARSETTINGS#).
  #-u <path>#: in path/.config/ (если path полный путь)
  #-u <identity>#: в ~~/.config/far2l/custom/identity/ или в $XDG_CONFIG_HOME/far2l/custom/identity/

  #-v <filename>#
  Просмотр указанного файла.
  #-v - <command line>#
  Запуск командной строки и открытие просмотра её stdout (стандартного выходного потока).
  Например, #far2l -v - ls# выведет результат работы команды ls.

  #-set:<parameter>=<value>#
  Изменение значения конфигурационного параметра. См. ~far:config~@FarConfig@.
  Пример: far2l -set:Language.Main=English -set:Screen.Clock=0 -set:XLat.Flags=0x10001 -set:System.FindFolders=false


  В командной строке можно указать не более двух путей (к каталогам, файлам, архивам)
или двух команд с префиксом плагина. Первый путь для активной панели, второй - для пассивной:
  - ^<wrap>для каталогов и архивов FAR2L покажет их содержимое;
  - ^<wrap>для файлов - произойдёт переход в каталог с файлом и позиционирование на указанный файл, если он существует;
  - ^<wrap>при указании префиксов плагинов (допускается смешанное использование с обычными путями) сначала выполняется
команда для пассивной панели (пассивная панель при этом временно активируется). Односимвольные префиксы игнорируются.
  Пример: far ma:Far20.7z "macro:post MsgBox(\\"FAR2L\\",\\"Successfully started\\")"


  Все параметры (кроме #-h# и #-u#) также могут быть установлены через переменную окружения #FAR2L_ARGS#
(например: #export FAR2L_ARGS="--tty --nodetect"# и затем просто #far2l# для принудительного запуска только режима TTY).


@KeyRef
$ #Клавиатурные команды#

 ~Команды управления панелями~@PanelCmd@

 ~Командная строка~@CmdLineCmd@

 ~Управление файлами и сервисные команды~@FuncCmd@

 ~Мышь: поддержка колеса~@MsWheel@

 ~Команды управления меню~@MenuCmd@

 ~Прочие команды~@MiscCmd@

 ~Специальные команды~@SpecCmd@

@MenuCmd
$ #Команды управления меню#
 #Общие команды для меню и выпадающих списков#

  Фильтровать элементы меню или списка                    #Ctrl-Alt-F#
   (показывать только пункты, содержащие вводимый текст)

  Зафиксировать фильтр                                    #Ctrl+Alt+L#

  Горизонтальная прокрутка длинного элемента       #Alt-Left#,#Alt-Right#
   (не работают с клавишами, расположенными         #Alt-Home#,#Alt-End#
   на цифровой клавиатуре)

  См. также список ~макроклавиш~@KeyMacroMenuList@, доступных в меню.

@PanelCmd
$ #Команды управления панелями#
 #Общие команды#

  Вертикальное/горизонтальное расположение панелей            #Ctrl-,#

  Изменить активную панель                                       #Tab#
  Поменять панели местами                                     #Ctrl-U#
  Перечитать содержимое панели                                #Ctrl-R#
  Убрать/показать информационную панель                       #Ctrl-L#
  Убрать/показать ~панель быстрого просмотра~@QViewPanel@                   #Ctrl-Q#
  Убрать/показать дерево папок                                #Ctrl-T#
  Убрать/показать обе панели                                  #Ctrl-O#
  Временно убрать обе панели                          #Ctrl-Alt-Shift#
   (работает до тех пор, пока удерживаем эти клавиши)
  Убрать/показать неактивную панель                           #Ctrl-P#
  Убрать/показать левую панель                               #Ctrl-F1#
  Убрать/показать правую панель                              #Ctrl-F2#
  Изменить высоту панелей                          #Ctrl-Up,Ctrl-Down#
  Изменить высоту текущей панели       #Ctrl-Shift-Up,Ctrl-Shift-Down#
  Изменить ширину (при пустой командной строке) #Ctrl-Left,Ctrl-Right#
  Восстановить ширину панелей по умолчанию              #Ctrl-Numpad5#
  Восстановить высоту панелей по умолчанию          #Ctrl-Alt-Numpad5#
  Спрятать/Показать линейку функциональных клавиш             #Ctrl-B#

 #Команды файловой панели#

  Пометить/снять пометку файла            #Ins, Shift-Клавиши курсора#
  Пометить группу                                             #Gray +#
  Снять пометку с группы                                      #Gray -#
  Инвертировать пометку                                       #Gray *#
  Пометить файлы с расширением как у текущего файла    #Ctrl-<Gray +>#
  Снять пометку с файлов с расширением, как у текущего #Ctrl-<Gray ->#
  Инвертировать пометку, включая папки                 #Ctrl-<Gray *>#
   (без учёта состояния командной строки)
  Пометить файлы с именем, как у текущего файла         #Alt-<Gray +>#
  Снять пометку с файлов с именем, как у текущего файла #Alt-<Gray ->#
  Пометить все файлы                                  #Shift-<Gray +>#
  Снять пометку со всех файлов                        #Shift-<Gray ->#
  Восстановить предыдущую пометку                             #Ctrl-M#

  Прокрутка длинных имён и описаний               #Alt-Left,Alt-Right#
                                                    #Alt-Home,Alt-End#

  Установить краткий режим просмотра                     #ЛевыйCtrl-1#
  Установить средний режим просмотра                     #ЛевыйCtrl-2#
  Установить полный режим просмотра                      #ЛевыйCtrl-3#
  Установить широкий режим просмотра                     #ЛевыйCtrl-4#
  Установить детальный режим просмотра                   #ЛевыйCtrl-5#
  Установить режим просмотра описаний                    #ЛевыйCtrl-6#
  Установить режим просмотра длинных описаний            #ЛевыйCtrl-7#
  Установить режим просмотра владельцев файлов           #ЛевыйCtrl-8#
  Установить режим просмотра ссылок файлов               #ЛевыйCtrl-9#
  Установить альтернативный полный режим просмотра       #ЛевыйCtrl-0#

  Убрать/показать файлы с атрибутом "Скрытый" и "Системный"   #Ctrl-H#
  Переключить отображение длинных/коротких имён файлов        #Ctrl-N#

  Настройка столбца Размер:
   cмена стиля имени для каталогов и символических ссылок #Ctrl-Alt-D#
   переключение для символических ссылок показа           #Ctrl-Alt-L#
    "Ссылка" или размер оригинального файла

  Маркеры ~раскрасок файлов~@Highlight@:
   убрать/показать/выровнять в списке файлов на панелях   #Ctrl-Alt-M#
   показать/спрятать маркеры в строке статуса             #Ctrl-Alt-N#

  Спрятать/Показать левую панель                             #Ctrl-F1#
  Спрятать/Показать правую панель                            #Ctrl-F2#

  Сортировать файлы активной панели по имени                 #Ctrl-F3#
  Сортировать файлы активной панели по расширению            #Ctrl-F4#
  Сортировать файлы активной панели по времени записи        #Ctrl-F5#
  Сортировать файлы активной панели по размеру               #Ctrl-F6#
  Не сортировать файлы активной панели                       #Ctrl-F7#
  Сортировать файлы активной панели по времени создания      #Ctrl-F8#
  Сортировать файлы активной панели по времени доступа       #Ctrl-F9#
  Сортировать файлы активной панели по описаниям            #Ctrl-F10#
  Сортировать файлы активной панели по владельцу            #Ctrl-F11#
  Вывести меню ~режимов сортировки~@PanelCmdSort@                           #Ctrl-F12#
  Использовать сортировку по группам                       #Shift-F11#
  Показывать помеченные файлы первыми                      #Shift-F12#

  Создать ~закладку~@Bookmarks@               #Ctrl-Shift-0# .. #Ctrl-Shift-9#
  Перейти по ссылке на папку            #ПравыйCtrl-0# .. #ПравыйCtrl-9#

    Если активная панель является ~панелью быстрого просмотра~@QViewPanel@,
    ~деревом каталогов~@TreePanel@ или ~информационной панелью~@InfoPanel@, то каталог
    меняется не на активной, а на пассивной панели.

  Поместить помеченные имена в Буфер Обмена                 #Ctrl-Ins#
   (при пустой командной строке)
  Поместить помеченные файлы в Буфер Обмена                   #Ctrl-C#
   (без учёта состояния командной строки)
  Поместить помеченные имена в Буфер Обмена           #Ctrl-Shift-Ins#
   (без учёта состояния командной строки)

  Поместить полные имена помеченных файлов             #Alt-Shift-Ins#
   в Буфер Обмена (без учёта состояния командной строки)
  Поместить полные имена помеченных файлов  (*3)        #Ctrl-Alt-Ins#
   в Буфер Обмена (без учёта состояния командной строки)

  См. также список ~макроклавиш~@KeyMacroShellList@, доступных в панелях.

  Примечания:

  1. ^<wrap>Если включена опция "Разрешить обратную сортировку" в диалоге
~Настроек панели~@PanelSettings@, то повторное нажатие одной и той же клавиши
сортировки файлов приводит к смене направления сортировки с возрастающей на убывающую и наоборот;

  2. ^<wrap>Комбинации Alt-Left and Alt-Right, используемые для прокрутки
длинных имён и описаний, не работают с клавишами Left и Right, расположенными
на цифровой клавиатуре, потому что эти клавиши используются для ввода символов
через их десятичные коды.

  3. ^<wrap>Комбинация клавиш #Ctrl-Alt-Ins# работает по следующим правилам:
     ^<wrap>Если в ~Настройках панели~@PanelSettings@ включена опция
"Классическое разрешение ссылок по хоткеям", то используется полное имя с раскрытием
~символических~@HardSymLink@ ссылок.

  4. ^<wrap>Комбинации клавиш #Ctrl-Ins#, #Alt-Shift-Ins# и #Ctrl-Alt-Ins# обрабатывают
имя "#..#" как имя текущей папки.


@PanelCmdSort
$ #Режимы сортировки#
    Меню режимов сортировки вызывается комбинацией #Ctrl-F12# и применяется для
активной в данный момент панели. Доступны следующие режимы сортировки панели:

  Сортировать файлы по имени                                 #Ctrl-F3#
  Сортировать файлы по расширению                            #Ctrl-F4#
  Сортировать файлы по времени записи                        #Ctrl-F5#
  Сортировать файлы по размеру                               #Ctrl-F6#
  Не сортировать файлы                                       #Ctrl-F7#
  Сортировать файлы по времени создания                      #Ctrl-F8#
  Сортировать файлы по времени доступа                       #Ctrl-F9#
  Сортировать файлы по описаниям                            #Ctrl-F10#
  Сортировать файлы по владельцу                            #Ctrl-F11#

  Клавиша #+# устанавливает прямую сортировку.
  Клавиша #-# устанавливает обратную сортировку.
  Клавиша #*# меняет сортировку на обратную.

  Использовать сортировку по группам                       #Shift-F11#
  Показывать помеченные файлы первыми                      #Shift-F12#
  Использовать числовую сортировку.
  Использовать сортировку с учётом регистра.

  #Замечания по числовой сортировке#

    Начиная с Windows XP алгоритм сортировки, используемый операционной системой
при выводе списка файлов, изменён со строкового на числовой -
#ведущие нули в имени файла не учитываются#.
FAR2L также позволяет использовать числовую сортировку.
Следующий пример показывает, как сортируются файлы:

    Режим выключен (Windows 2000)    Режим включён

    Ie4_01                           Ie4_01
    Ie4_128                          Ie4_128
    Ie401sp2                         Ie5
    Ie5                              Ie6
    Ie501sp2                         Ie401sp2
    Ie6                              Ie501sp2
    11.txt                           5.txt
    5.txt                            11.txt
    88.txt                           88.txt

  См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.


@FastFind
$ #Быстрый поиск в панелях#
    Для позиционирования на файл можно воспользоваться операцией #быстрого#
#поиска# по первым буквам имени. Для этого, удерживая клавишу #Alt# (или
#Alt-Shift#), набирайте имя требуемого файла, пока на него не переместится
курсор.

    С помощью #Ctrl-Enter# можно циклически перемещаться по элементам панели в
соответствии с введённой в строке файловой маской. #Ctrl-Shift-Enter# позволяет
перемещаться по элементам в обратном направлении.

    Кроме обычных символов в имени файла также можно использовать символы '#*#'
и '#?#'.

    Вставка содержимого буфера обмена (клавишами #Ctrl-V# или #Shift-Ins#) в
окно быстрого поиска производится до тех пор, пока есть совпадение.

    В процессе набора имени можно применять функцию транслитерации при
ошибочной раскладке клавиатуры. В этом случае FAR2L перекодирует набранный текст
и пытается найти первое совпадение нового имени. Подробнее о назначении клавиш
для транслитерации см. TechInfo##10.

   См. также список ~макроклавиш~@KeyMacroSearchList@, доступных в быстром поиске файла.


@CmdLineCmd
$ #Командная строка#
    #Общие команды#

  Символ влево                                           #Left,Ctrl-S#
  Символ вправо                                         #Right,Ctrl-D#
  Слово влево                                              #Ctrl-Left#
  Слово вправо                                            #Ctrl-Right#
  В начало строки                                          #Ctrl-Home#
  В конец строки                                            #Ctrl-End#
  Удалить символ                                                 #Del#
  Удалить символ слева                                            #BS#
  Удалить до конца строки                                     #Ctrl-K#
  Удалить слово слева                                        #Ctrl-BS#
  Удалить слово справа                                      #Ctrl-Del#
  Рассматривать следующую комбинацию клавиш как код           #Ctrl-Q#
  Копировать в Буфер Обмена                                 #Ctrl-Ins#
  Вставить из Буфера Обмена                                #Shift-Ins#
  Предыдущая команда                                          #Ctrl-E#
  Следующая команда                                           #Ctrl-X#
  Очистить командную строку                                   #Ctrl-Y#

    #Команды вставки#

  Вставить имя файла из активной панели            #Ctrl-J,Ctrl-Enter#

     В режиме ~быстрого поиска~@FastFind@ #Ctrl-Enter# не вставляет имя
     файла, а производит циклический обход по элементам
     файловой панели.

  Вставить имя файла из пассивной панели            #Ctrl-Shift-Enter#

  Вставить полное имя файла из активной панели                #Ctrl-F#
  Вставить полное имя файла из пассивной панели               #Ctrl-;#
  Вставить путь из левой панели                               #Ctrl-[#
  Вставить путь из правой панели                              #Ctrl-]#
  Вставить путь из активной панели                      #Ctrl-Shift-[#
  Вставить путь из пассивной панели                     #Ctrl-Shift-]#

  (*5)
  Вставить полное имя файла из активной панели            #Ctrl-Alt-F#
  Вставить полное имя файла из пассивной панели           #Ctrl-Alt-;#
  Вставить путь из левой панели                           #Ctrl-Alt-[#
  Вставить путь из правой панели                          #Ctrl-Alt-]#
  Вставить путь из активной панели                       #Alt-Shift-[#
  Вставить путь из пассивной панели                      #Alt-Shift-]#


  Примечания:

  1. ^<wrap>Если командная строка пуста, #Ctrl-Ins# будет копировать имена
выбранных в панели файлов в Буфер Обмена так же, как и #Ctrl-Shift-Ins#
(см. ~Команды управления панелями~@PanelCmd@);

  2. ^<wrap>#Ctrl-End#, нажатая в конце командной строки, заменяет её текущее
содержимое командой из ~истории команд~@History@, начинающейся с уже введённых
букв, если такая команда существует. Чтобы перейти к следующей такой команде,
вы можете нажать #Ctrl-End# повторно.

  3. ^<wrap>Большинство из описанных выше команд действительно для всех строк
редактирования, включая строки в диалогах и встроенный редактор.

  4. ^<wrap>#Alt-Shift-Left#, #Alt-Shift-Right#, #Alt-Shift-Home# и #Alt-Shift-End#
выделяют блок в командной строке независимо от состояния панелей.

  5. ^<wrap>Отмеченные комбинации клавиш работают по следующим правилам:
     ^<wrap>Если в ~Настройках панели~@PanelSettings@ включена опция
"Классическое разрешение ссылок по хоткеям", то используется полное имя с раскрытием
~символических~@HardSymLink@ ссылок.

  6. ^<wrap>Про кнопкосочетания и другие особенности встроенного эмулятора терминала ~читайте здесь~@Terminal@

    См. также: ~псевдокоманды~@SpecCmd@.

@FuncCmd
$ #Команды управления панелями - сервисные команды#
  Помощь                                                          #F1#

  Вызвать ~пользовательское меню~@UserMenu@                                   #F2#

  Просмотр                               #Ctrl-Shift-F3, Numpad 5, F3#

    Если #NumPad 5# или #F3# нажаты на файле, они вызывают
~встроенную~@Viewer@, внешнюю или ~ассоциированную~@FileAssoc@ программу
просмотра, в зависимости от типа файла и ~настроек программы просмотра~@ViewerSettings@.
    #Ctrl-Shift-F3# всегда вызывает встроенную программу просмотра, вне
зависимости от файловых ассоциаций.
    При нажатии любой из этих клавиш на папке вычисляются и показываются
размеры выбранных папок.

  Редактирование, Распаковка                       #Ctrl-Shift-F4, F4#

    #F4# вызывает ~встроенный~@Editor@, внешний или ~ассоциированный~@FileAssoc@
редактор, в зависимости от типа файла и ~настроек редактора~@EditorSettings@.
    #Ctrl-Shift-F4# всегда вызывает встроенный редактор, вне зависимости от
файловых ассоциаций.
    #F4# и #Ctrl-Shift-F4# для папок вызывают диалог смены файловых ~атрибутов~@FileAttrDlg@.

  ~Копирование~@CopyFiles@                                                     #F5#

    Копирует файлы и папки. Если вы хотите создать папку назначения перед
копированием, добавьте к её имени обратную черту (\\).

  ~Переименование или перенос~@CopyFiles@                                      #F6#

    Переименование или перенос файлов и папок. Если вы хотите создать папку
назначения перед переносом, добавьте к её имени обратную черту (\\).

  ~Создание новой папки~@MakeFolder@                                            #F7#

  ~Удаление файлов и папок~@DeleteFile@                    #Shift-Del, Shift-F8, F8#

  ~Уничтожение файлов и папок~@DeleteFile@                                 #Alt-Del#

  Показать горизонтальное ~меню~@Menus@                                    #F9#

  Завершить работу с FAR2L                                       #F10#

  Показать команды ~подключаемых модулей~@Plugins@                          #F11#

  Изменить путь в левой панели                                #Alt-F1#

  Изменить путь в правой панели                               #Alt-F2#

  Встроенная/внешняя программа просмотра                      #Alt-F3#

  Вызывает в зависимости от типа файла
~ассоциированную программу просмотра~@FileAssoc@ или внешнюю программу
просмотра, указанную в ~настройках~@ViewerSettings@, если по умолчанию
используется внутренняя, или внутреннюю, если по умолчанию используется
внешняя.

  Встроенный/внешний редактор                                 #Alt-F4#

    Вызывает в зависимости от типа файла ~ассоциированный редактор~@FileAssoc@
или внешний редактор, указанный в ~настройках~@EditorSettings@, если по
умолчанию используется внутренний, и внутренний, если по умолчанию используется
внешний.

  Печать файлов                                               #Alt-F5#

    Если установлен плагин "Print Manager", то печать выделенных файлов
осуществляется через него, иначе - средствами FAR2L.

  Создание ~ссылок~@HardSymLink@ файлов и папок                              #Alt-F6#

    Используя жёсткие ссылки файлов, вы можете иметь несколько различных имён
файлов, ссылающихся на одни и те же данные.

  Произвести ~поиск файла~@FindFile@                                      #Alt-F7#

  Показать ~историю команд~@History@                                     #Alt-F8#

  Изменение размеров окна FAR2L                               #Alt-F9#

    В оконном режиме переключение происходит с нормального до максимально
допустимого размера консольного окна и обратно.

  Настройка параметров подключаемых ~внешних модулей~@Plugins@     #Alt-Shift-F9#

  Произвести ~поиск папки~@FindFolder@                                     #Alt-F10#

  Показать историю ~просмотра и редактирования~@HistoryViews@                #Alt-F11#

  Показать ~историю папок~@HistoryFolders@                                     #Alt-F12#

  Добавить файлы к архиву                                   #Shift-F1#
  Извлечь файлы из архива                                   #Shift-F2#
  Выполнить команды управления архивом                      #Shift-F3#
  Редактировать ~новый файл~@FileOpenCreate@                                  #Shift-F4#

    При создании нового файла используется кодовая страница, выбранная в
последнем открытом редакторе. Если редактор открывается впервые в текущей
сессии FAR2L, используется кодовая страница по умолчанию.

  Копирование файла под курсором                            #Shift-F5#
  Переименование или перенос файла под курсором             #Shift-F6#

    Для папки: если заданный относительный или абсолютный путь соответствует
существующей папке, то происходит перемещение в эту папку. 

    Например, при перемещении #/folder1/# в #/folder2/#:
  - если #/folder2/# существует, то содержимое #/folder1/# переместится в
#/folder2/folder1/#;
  - в противном случае содержимое #/folder1/# переместится во
вновь созданную папку #/folder2/#.

  ~Удаление файла~@DeleteFile@ под курсором                               #Shift-F8#
  Сохранить конфигурацию                                    #Shift-F9#
  Выбрать последний выполненный пункт меню                 #Shift-F10#

  Запуск, смена папки, вход в архив                            #Enter#
  Запуск в отдельном окне                                #Shift-Enter#
  Запуск от имени администратора                      #Ctrl-Alt-Enter#

    #Shift-Enter# для папки вызывает системный графический файловый проводник
с показом содержимого выбранной папки. Для того, чтобы в проводнике показать
корневую папку, нужно нажать #Shift-Enter# на требуемой строке в меню ~перехода~@DriveDlg@.
#Shift-Enter# на папке с именем "#..#" открывает в проводнике текущую папку.

  Сменить папку на корневую (/)                                       #Ctrl-\\#

  Сменить каталог на точку монтирования                           #Ctrl-Alt-\\#
  файловой системы текущего каталога

  Сменить каталог на домашний (~~)                                     #Ctrl-`#

  Смена папки, вход в архив (также в SFX архив),           #Ctrl-[Shift-]PgDn#

    Если курсор указывает на папку, то производится смена текущей папки на
указываемую. Если курсор указывает на файл, то, в зависимости от типа файла,
выполняется ~ассоциированная команда~@FileAssoc@, или происходит вход в архив.
    #Ctrl-Shift-PgDn# всегда инициирует вход в архив, вне зависимости от
файловых ассоциаций.

  Для symlink переход к расположению оригинального файла     #Ctrl-Shift-PgDn#
   (в остальном действие как #Ctrl-PgDn#)

  Перейти в папку уровнем выше                                     #Ctrl-PgUp#

  На #Ctrl-PgUp# в корневой папке влияет опция
"~Использовать Ctrl-PgUp для выбора диска~@InterfSettings@".

  Возврат к symlink                                          #Ctrl-Shift-PgUp#
   (только если ранее был переход по #Ctrl-Shift-PgDn# на symlink)

  Создать закладку на текущую папку                   #Ctrl-Shift-0..9#
  Использовать закладку                               #ПравыйCtrl-0..9#

  Установить ~файловые атрибуты~@FileAttrDlg@                                #Ctrl-A#
  ~Применить команду~@ApplyCmd@ к помеченным файлам                       #Ctrl-G#
  Добавить ~описания~@FileDiz@ к помеченным файлам                       #Ctrl-Z#


@DeleteFile
$ #Удаление и уничтожение файлов и папок#
    Для удаления или уничтожения файлов и папок применяются следующие сочетания
клавиш:

    #F8#         - если на панели выбраны какие-либо файлы или
                 каталоги, то удаляется выбранная группа, иначе
                 удаляется текущий объект под курсором.

    #Shift-F8#   - удаление файла или папки только под курсором
                 (независимо от выбранных объектов на панели);

    #Shift-Del#  - удаление выбранных объектов минуя Корзину

    #Alt-Del#    - уничтожение файлов и папок.


    Примечания:

    1. ^<wrap>В зависимости от настроек в меню ~Системные параметры~@SystemSettings@
комбинации клавиш #F8# и #Shift-F8# перемещают или нет удаляемые файлы в
Корзину (Trash). Комбинация клавиш #Shift-Del# всегда удаляет файлы,
минуя Корзину.

    2. ^<wrap>В процессе уничтожения, файл перезаписывается нулями (можно задать
другой символ-заполнитель, System.WipeSymbol в ~far:config~@FarConfig@), усекается до нулевой длины,
переименовывается во временное имя и удаляется.

@MiscCmd
$ #Команды управления панелями - прочие команды#
  Копирование текста с экрана                                #Alt-Ins#

    Эта команда позволяет выбрать и поместить в Буфер Обмена любую область
экрана. Для перемещения курсора используйте #клавиши управления курсором# или
нажмите #левую кнопку мыши#. Для выбора текста используйте #клавиши управления#
#курсором# при нажатой #Shift# или нажатую #левую кнопку мыши#. #Enter#,
#Ctrl-Ins#, #правая кнопка мыши# или двойное нажатие #левой кнопки мыши#
копируют выбранный текст в Буфер Обмена, #Ctrl-<Gray +># добавляет его к
текущему содержанию Буфера Обмена, #Esc# отменяет пометку и завершает операцию.
Комбинация #Ctrl-U# снимает выделение.

  Записать ~клавиатурную макрокоманду~@KeyMacro@                        #Ctrl-<.>#

  История в строках редактирования диалогов       #Ctrl-Up, Ctrl-Down#

    В истории строк редактирования диалогов вы можете использовать #Enter# для
копирования текущего элемента в строку редактирования или #Ins# для отметки
элемента. Отмеченные элементы не вытесняются из истории новыми элементами, так
что вы можете отметить часто используемые строки, чтобы всё время держать их в
истории.

  Очистка истории в строках редактирования диалогов              #Del#

  Удаление текущего неотмеченного пункта истории
  в строках редактирования диалогов                        #Shift-Del#

  Вставить в диалог имя файла под курсором               #Shift-Enter#

  Поместить курсор в диалогах на элемент по умолчанию           #PgDn#

  Вставить в диалог имя файла пассивной панели      #Ctrl-Shift-Enter#

    Эта комбинация клавиш может быть использована во всех строках
редактирования кроме командной строки, включая диалоги и
~встроенный редактор~@Editor@.

    #Ctrl-Enter# в диалогах вызывает действие по умолчанию (нажатие на кнопку
по умолчанию или подобное по смыслу действие).

    В диалогах, когда текущим элементом управления является контрольный
переключатель (кнопка с независимой фиксацией или Check Box):

  - включить (#[x]#)                                          #Gray +#
  - выключить (#[ ]#)                                         #Gray -#
  - изменить состояние на неопределённое (#[?]#)              #Gray *#
    (если переключатель имеет трёхпозиционное состояние)

    Щелчок #левой клавишей мыши# за пределами диалога аналогичен нажатию
клавиши #Esc#.

    Щелчок #правой клавишей мыши# за пределами диалога аналогичен нажатию
клавиши #Enter#.

    Щелчок #средней клавишей мыши# с соответствующими модификаторами (#Ctrl#,
#Alt#, #Shift#) в ~панелях~@PanelCmd@ аналогичен нажатию клавиши #Enter#. Для
непустой ~командной строки~@CmdLineCmd@ будет исполнено её содержимое.

   FAR2L также умеет обрабатывать ~колесо мыши~@MsWheel@.

   Переместить диалог можно мышью или комбинацией #Ctrl-F5#.

    #Липкие управляющие кнопки# если ваше окружение не дает вам использовать
некоторые кнопкосочетания из-за ограничений TTY режима или если кнопкосочетание
занято внешней программой то вы можете использовать липкие управляющие кнопки.
Это означает кнопка, которая виртуально остается нажатой до нажатия следующей
не-управляющей (цифро-символьной) кнопки:
    #Ctrl+SPACE# дает липкий CONTROL
    #Alt+SPACE# дает липкий ALT
    #правый_Ctrl+SPACE# дает липкий правый CONTROL
    #правый_Alt+SPACE# дает липкий правый ALT
    Другим способом получить работоспособные горячие кнопки может быть
перенастройка общесистемных хоткеев в оболочках
или во внешних программах (с целью освободить нужные сочетания)
или же использование
опции эксклюзивной обработки нажатий в ~параметрах ввода~@InputSettings@
(только в GUI режиме под X11).

@SpecCmd
$ #Специальные команды#
  Специальные псевдокоманды FAR2L, обычно начинающиеся с префикса и двоеточия, обрабатываются
во внутренней ~Командной строке~@CmdLineCmd@, ~Ассоциациях файлов~@FileAssoc@, ~Меню пользователя~@UserMenu@ и действии ~Применить команду~@ApplyCmd@.

   #far:about#  - информация о far2l, список и информация о плагинах.

   #far:config# - ~редактор конфигурации~@FarConfig@.

   #view:file# или #far:view:file# или #far:view file# - открыть в просмотрщике существующий файл #file#.
   #view:<command# или #far:view:<command# или #far:view < command# - открыть в просмотрщике результат вывода команды #command# во временный файл.

   #edit:file# или #far:edit:file# или #far:edit file# - открыть в редакторе файл #file# (если #file# не существует, будет открыт пустой).
   #edit:# или #far:edit:# или #far:edit# - открыть в редакторе новый пустой файл.
   #edit:<command# или #far:edit:<command# или #far:edit < command# - открыть в редакторе результат вывода команды #command# во временный файл.

   #exit#       - завершение фоновой оболочки встроенного ~терминала~@Terminal@.

   #exit far#   - выход из far2l.

  Плагины могут определять свои собственные префиксы команд. Смотрите для каждого доступного плагина список префиксов команд через #far:about#.

  См. также: ~команды операционной системы~@OSCommands@

@FarConfig
$ #Редактор конфигурации#
 Запускается с помощью команды #Редактор конфигурации# в ~Меню команд~@CmdMenu@
или ~псевдокоманде~@SpecCmd@ #far:config# из внутренней командной строки far2l.

 Позволяет просмотреть и изменить все настройки Far Manager.

 Большинство настроек можно изменить через ~Меню параметров~@OptMenu@,
но некоторые доступны только отсюда или в конфигурационных ini-файлах.

 Параметры показаны в виде единого списка, состоящего из четырёх полей:
  #-# Имя в формате SectionName.ParamName (например Editor.TabSize)
  #-# Тип (boolean, integer, dword, string, binary или unknown)
  #-# Сохраняется ли данная опция при сохранении конфигурации Far (s) или нет (-)
  #-# Значение параметра (для типов integer или dword дополнительно отображается 16-ричное представление).
 Если значение параметра отличается от значения по умолчанию, он помечается символом ‘*’ слева от имени
(символ ‘?’ помечает параметр, не имеющий значение по умолчанию).

 Кроме клавиш перемещения по списку доступны следующие сочетания:

 #Enter# или #F4#      Редактировать значение.

 #Del#               Сбросить параметр в значение по умолчанию.

 #Ctrl-H#            Переключить отображение всех или только измененных параметров.

 #Ctrl-A#            Переключить выравнивание столбца имени по левому краю или по точке.

 #Ctrl-Alt-F#        Переключить режим быстрой фильтрации.

 #Esc# или #F10#       Закрыть.

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.

@MsWheel
$ #Мышь: поддержка колеса#

   #Панели#          Прокрутка списка при неизменной позиции курсора
                   на экране. Нажатие #средней кнопки# аналогично
                   нажатию #Enter#.

   #Редактор#        Прокрутка текста с постоянным позиционированием
                   курсора (аналогично #Ctrl-Up#/#Ctrl-Down#).

   #Встроенная#      Прокрутка всего текста.
   #программа#
   #просмотра#

   #Система помощи#  Прокрутка всего текста.


   #Меню#            Прокрутка колеса аналогична действию клавиш
                   #Up#/#Down#. Нажатие средней кнопки аналогично
                   нажатию #Enter#. Можно выбирать пункты, не двигая
                   курсор.

   #Диалоги#         В диалогах при прокрутке колеса для строки
                   редактирования с историей и комбинированного
                   списка раскрывается список. Внутри списка
                   прокрутка работает так же, как для меню.

    Вы можете задать количество строк для прокрутки в панелях, редакторе и во
встроенной программе просмотра (см. TechInfo##33).


@Plugins
$ #Поддержка подключаемых модулей#
    Внешние подключаемые модули (plugins) могут быть использованы для
создания новых команд FAR2L и поддержки дополнительных файловых систем. Например,
работа с архивами, FTP-клиент, временная панель и просмотр сети реализованы с
помощью эмулирующих файловые системы модулей.

    Все подключаемые модули хранятся в отдельных папках, размещённых в папке
'Plugins', которая находится в одной папке с исполняемым файлом far2l.
При обнаружении нового модуля FAR2L сохраняет информацию о нём и впоследствии
загружает его только при необходимости, так что неиспользуемые модули
не требуют дополнительной памяти. Тем не менее, если вы уверены, что
какие-либо модули вам не нужны, вы можете удалить их,
чтобы сохранить место на диске.

    Модули могут быть вызваны либо из ~Меню перехода~@DriveDlg@, либо из
меню ~Команды внешних модулей~@PluginCommands@, активизируемого с помощью #F11# или
соответствующего пункта ~Меню команд~@CmdMenu@. #F4# в меню "Команды внешних
модулей" позволяет назначить горячие клавиши для пунктов этого меню, что
упрощает их последующий вызов с помощью ~клавиатурных макрокоманд~@KeyMacro@.
Это меню доступно из файловых панелей, диалогов и из встроенной программы
просмотра и редактора. При вызове из диалогов, программы просмотра или редактора
будут показаны не все модули, а только те, которые специально созданы для работы
в этом режиме.

    Вы можете настроить параметры модулей, используя команду
~Параметры внешних модулей~@PluginsConfig@ из ~Меню параметров~@OptMenu@ либо
комбинацию клавиш #Alt-Shift-F9#.
    Операции обработки файлов (копирование, перенос, удаление,
редактирование, ~Поиска файла~@FindFile@ и т. п.) могут работать с модулями,
эмулирующими файловые системы, если эти модули обеспечивают соответствующую
функциональность.

    Модули имеют собственные файлы сообщений и помощи. Вы можете получить
список доступной помощи по модулям, нажав:

    #Shift-F2# - в основной помощи FAR2L
    #Shift-F1# - в списке плагинов (контекстно-зависимая помощь).

    Если плагин не имеет файла помощи, то помощь вызываться не будет.


@PluginCommands
$ #Команды внешних модулей#
    Данное меню - один из способов использования функциональности, которую
предоставляют внешние модули (о других способах см. ~"Поддержка подключаемых модулей"~@Plugins@).
Содержимое этого меню и действия, выполняемые при выборе пункта меню,
определяются внешними модулями.

    Меню может быть вызвано следующими способами:

  - нажатие #F11# в файловых панелях или выбор пункта #Команды внешних модулей#
    ~меню команд~@CmdMenu@, при этом показываются команды, предназначенные для
    вызова из файловых панелей;
  - нажатие #F11# в окне просмотра, редактора или диалоге, при этом показываются
только команды, предназначенные для текущей области вызова.

    Каждому пункту меню по #F4# может быть назначена горячая клавиша, отображаемая
слева от него. Данная возможность широко используется при создании
~клавиатурных макрокоманд~@KeyMacro@ вызова функций внешних модулей. Символ #A#
в крайней левой колонке меню означает, что соответствующий модуль разработан
для Far 1.x и не поддерживает всех возможностей Far 2 (в частности, символов
Unicode в именах файлов и в редакторе).

    Горячие клавиши меню #Команды внешних модулей#:

    #Shift-F1#    - помощь по использованию выделенного пункта меню.
                  Текст помощи берётся из HLF-файла, связанного с внешним
                  модулем, которому принадлежит выделенный пункт меню.
    #F4#          - назначить горячую клавишу выделенному пункту меню.
                  Если ввести пробел, Far установит горячую клавишу
                  автоматически.
    #Shift-F9#    - параметры выбранного модуля.
    #Alt-Shift-F9# - открыть меню ~"Конфигурация модулей"~@PluginsConfig@.

    См. также: ~Поддержка подключаемых модулей~@Plugins@.
               Клавиатурные команды, общие ~для всех меню~@MenuCmd@.


@PluginsConfig
$ #Параметры внешних модулей#
    Вы можете настроить параметры ~подключаемых модулей~@Plugins@,
используя команду #"Параметры внешних модулей"# из ~"Меню параметров"~@OptMenu@
или нажав комбинацию клавиш #Alt-Shift-F9# из меню ~перехода~@DriveDlg@
и меню команд подключаемых модулей.

    Вы можете получить информацию о конкретном модуле, нажав #Shift-F1# -
контекстно-зависимая помощь по настройке модуля. Если плагин не имеет файла
помощи, то помощь вызываться не будет.

    При вызове контекстной помощи FAR2L попытается показать тему с именем
#Config#. Если такой темы в файле помощи плагина нет, будет показана основная
тема помощи по данному плагину.

    Каждому пункту меню по #F4# может быть назначена горячая клавиша, отображаемая
слева от него; данная возможность широко используется при создании
~клавиатурных макрокоманд~@KeyMacro@ вызова функций внешних модулей. Символ #A#
в крайней левой колонке меню означает, что соответствующий плагин разработан
для Far 1.x и не поддерживает всех возможностей Far 2 (в частности, символов
Unicode в именах файлов и в редакторе).

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.

@PluginsReviews
$ #Обзор возможностей подключаемых модулей#
    Оболочка FAR2L настолько тесно слилась со своими плагинами, что
говорить о ней и не говорить о плагинах просто бессмысленно. Плагины неимоверно
расширяют возможности FAR2L, дополняя их и модифицируя.

@Panels
$ #Панели#
    Обычно FAR2L показывает две панели (левое и правое окна) с различной
информацией. Если вы хотите изменить тип отображаемой в панели информации,
используйте ~меню панелей~@LeftRightMenu@ или соответствующие
~клавиатурные команды~@KeyRef@.

    Для получения дополнительной информации о панелях прочитайте перечисленные
ниже темы:

     ~Панель файлов~@FilePanel@                ~Дерево папок~@TreePanel@
     ~Панель информации~@InfoPanel@            ~Панель быстрого просмотра~@QViewPanel@

     ~Перетаскивание файлов~@DragAndDrop@
     ~Пометка файлов~@SelectFiles@
     ~Настройка режимов просмотра панели файлов~@PanelViewModes@


@FilePanel
$ #Панель файлов#
    Панель файлов отображает содержимое текущей папки. Вы можете выбирать файлы
и папки, выполнять различные файловые и архивные операции. Команды управления
панелями описаны в теме ~Список команд~@KeyRef@.

    По умолчанию в панели файлов используются следующие режимы просмотра:

 #Краткий#        Имена файлов выводятся в три колонки.

 #Средний#        Имена файлов выводятся в две колонки.

 #Полный#         Выводятся имя, размер, дата и время файла.

 #Широкий#        Выводятся имя и размер файла.

 #Детальный#      Выводятся имена, размеры, упакованные размеры,
                время последней записи, создания, доступа
                и атрибуты файла. Полноэкранный режим.

 #Описания#       Имена и ~описания файлов~@FileDiz@

 #Длинные#        Имена, размеры и описания файлов.
 #описания#       Полноэкранный режим.

 #Владельцы#      Имена, размеры и владельцы файлов.
 #файлов#

 #Ссылки файлов#   Имена, размеры и количество жёстких ссылок файлов.

 #Альтернативный# Имя, размер (форматированный с помощью запятых)
 #полный#         и дата файла.

    Вы можете сами настроить ~режимы просмотра панели файлов~@PanelViewModes@.

    Физический размер показывает, сколько места реально используется для
хранения файла. Для обычных файлов этот размер равен логическому размеру файла,
округленному вверх согласно размеру кластера файловой системы. Но для сжатых
или разреженных файлов этот размер может быть меньше логического размера.

    Если вы хотите изменить режим просмотра панели, выберите желаемый из
~меню панелей~@LeftRightMenu@. После смены режима просмотра или использования
меню перехода тип любой панели автоматически меняется на панель файлов.

    Для позиционирования на файл можно воспользоваться операцией
~быстрого поиска~@FastFind@ по первым буквам имени.

    См. также список ~макроклавиш~@KeyMacroShellList@, доступных в панелях.

@TreePanel
$ #Дерево папок#
    Панель дерева папок отображает структуру папок файловой системы в виде
дерева. Это позволяет быстро сменить текущую папку, а также выполнять операции
над папками.

    FAR запоминает информацию о структуре папок в своей папке во временной директории
системы (/tmp, /var/tmp или заданной в переменной $TMPDIR). При необходимости можно
актуализировать состояние дерева сочетанием клавиш #Ctrl-R#.

    Для позиционирования на папку можно использовать операцию #быстрого#
#поиска#. Для этого, удерживая клавишу #Alt#, набирайте имя требуемой папки,
пока на неё не переместится курсор. С помощью #Ctrl-Enter#/#Ctrl-Shift-Enter#
можно переместиться на следующее/предыдущее имя, соответствующее введённой строке.

    #Gray +# и #Gray -# используются для быстрого перемещения вверх или вниз
по папкам одного уровня.

    См. также список ~макроклавиш~@KeyMacroTreeList@, доступных в панели дерева папок.

@InfoPanel
$ #Панель информации#
    Панель информации содержит следующие секции:

 1. ^<wrap>#Сетевые# имена компьютера и пользователя.

 2. ^<wrap>Сведения о текущем каталоге и его файловой системе.
    ^<wrap>Тип файловой системы, полный объём и объём пространства, доступный непривилегированному пользователю,
идентификатор файловой системы, текущий каталог и реальный путь к нему с учётом символических ссылок,
точка монтирования файловой системы текущего каталога, максимально допустимая длина имени файла для данного типа ФС,
и флаги, с которыми файловая система смонтирована.

 3. ^<wrap>Информация о состоянии памяти.
    ^<wrap>Уровень загрузки памяти (100% означает, что использована вся память), общий объем доступной оперативной
памяти, объем свободной памяти, объем разделяемой памяти, объем памяти, использованной под буферы, общий объем
области подкачки, объем свободного пространства в области подкачки.

 4. ^<wrap>Информация EditorConfig (если доступно).
    ^<wrap>Расположения корневого и ближайшего файлов #.editorconfig#, а также значения свойств #indent_style#,
#indent_size#, #end_of_line#, #charset#, #trim_trailing_whitespace#, #insert_final_newline# для маски #[*]#.
    ^<wrap>Подробнее об EditorConfig см. на оф. сайте: ~https://editorconfig.org/~@https://editorconfig.org/@.

 5. ^<wrap>Краткий статус Git (если доступно).
    ^<wrap>При нахождении в локальном репозитории/рабочем дереве Git будет показан адрес корневой директории Git
и вывод команды #git status -s -b#.

 6. ^<wrap>Файл #описания папки#.

    ^<wrap>Вы можете просмотреть содержимое этого файла в полноэкранном режиме, нажав
#F3# или #левую кнопку мыши#. Для редактирования или создания этого файла нажмите
#F4# или #правую кнопку мыши#. Вы также можете использовать многие команды
~встроенной программы просмотра~@Viewer@ (поиск, выбор кодовой страницы и т.д.) для
просмотра файла описания.

    ^<wrap>Список возможных имён файлов описания папок может быть задан с помощью
команды "Файлы описания папок" в ~Меню параметров~@OptMenu@.

 7. ^<wrap>Плагиновая панель.
    ^<wrap>Содержит информацию о противоположной плагиновой панели, если плагин предоставил такую информацию.

 См. также: ^<wrap>~Настройка информационной панели~@InfoPanelSettings@
            ^<wrap>~Список макроклавиш~@KeyMacroInfoList@, доступных в панели информации.

@QViewPanel
$ #Панель быстрого просмотра#
    Панель быстрого просмотра используется для получения информации о выбранном
элементе ~панели файлов~@FilePanel@ или ~дерева папок~@TreePanel@.

    Если выбранный элемент - файл, то отображается его содержимое. Для файла,
отображаемого в панели, доступны многие команды встроенной программы
~просмотра~@Viewer@. Для известных ОС типов файлов также выводится
название типа.

    Для папок в панели быстрого просмотра сообщается общий размер, общий
упакованный размер, количество файлов и вложенных папок, размер кластера
текущего диска, реальный размер файлов, включая неиспользуемые фрагменты
кластеров. Общий упакованный размер применим только для дисков с файловой
системой NTFS.

    Для ~символических ссылок~@HardSymLink@ отображается путь к исходным
объектам.

    Для папок общие размеры могут не соответствовать реальным значениям:

    1. ^<wrap>Если среди вложенных папок имеются символические ссылки и включена опция
"Сканировать символические ссылки" (диалог настройки ~системных параметров~@SystemSettings@).

    2. ^<wrap>Если внутри папки есть несколько жёстких ссылок на один и тот же файл.

    См. также список ~макроклавиш~@KeyMacroQViewList@, доступных в панели быстрого просмотра.

@DragAndDrop
$ #Копирование: перетаскивание файлов#
    Операции #копирования# и #переноса# файлов могут быть выполнены с помощью
#перетаскивания#. Нажмите #левую кнопку мыши# на исходном файле или папке,
перетащите его на другую панель и отпустите кнопку мыши.

    Если вы хотите обработать группу файлов или папок, пометьте их перед
перетаскиванием, нажмите #левую кнопку мыши# на исходной панели и перетащите
файлы на другую панель.

    Вы можете переключаться между копированием и переносом, нажимая #правую#
#кнопку мыши# во время перетаскивания. Для переноса файлов вы также можете
удерживать клавишу #Shift# в момент нажатия #левой кнопки мыши#.


@Menus
$ #Меню #
    Для активизации меню вы можете использовать #F9# или нажать #левую кнопку#
#мыши# на верхней строке экрана.

    При активизации по клавише #F9# автоматически выбирается меню,
соответствующее активной панели. При активном меню клавиша #Tab# позволяет
переключаться между меню левой и правой панелей. Если выбрано меню "Файлы",
"Команды" или "Параметры", клавиша #Tab# переключает на меню пассивной панели.

    Комбинация #Shift-F10# позволяет выбрать последний использованный пункт
меню.

    Описания конкретных меню можно прочесть в следующих темах:

     ~Меню левой и правой панелей~@LeftRightMenu@          ~Меню файлов~@FilesMenu@

     ~Меню команд~@CmdMenu@                          ~Меню параметров~@OptMenu@

    См. также список ~макроклавиш~@KeyMacroMainMenuList@, доступных в главном меню.

@LeftRightMenu
$ #Меню левой и правой панелей#
    Меню #Левая# и #Правая# позволяют изменить параметры левой и правой панели
соответственно. Эти меню включают следующие пункты:

   #Краткий#              Показывать файлы в три колонки.

   #Средний#              Показывать файлы в две колонки.

   #Полный#               Показывать имя, размер, дату и время файла.

   #Широкий#              Показывать имя и размер файла.

   #Детальный#            Показывать имя, размер, упакованный размер,
                        время записи, создания и доступа
                        и атрибуты файла. Полноэкранный режим.

   #Описания#             Имя и ~описание~@FileDiz@ файла.

   #Длинные описания#     Имя, размер и описание файла.
                        Полноэкранный режим.

   #Владельцы файлов#     Имя, размер и владелец файла.

   #Ссылки файлов#        Имя, размер и количество жёстких ссылок
                        файлов.

   #Альтернативный#       Имя, размер (форматированный с использованием
   #полный#               запятых) и дата файла.

   #Панель информации#    Сменить панель на ~панель информации~@InfoPanel@.

   #Дерево папок#         Сменить панель на ~дерево папок~@TreePanel@.

   #Быстрый просмотр#     Сменить панель на ~панель быстрого просмотра~@QViewPanel@.

   #Режимы сортировки#    Показать доступные режимы сортировки.

   #Панель Вкл/Выкл#      Показать/спрятать панель.

   #Перечитать#           Перечитать содержимое панели.

   #Меню перехода#        Вызвать диалог ~Меню перехода~@DriveDlg@ для смены расположения или открытия панели плагина.

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.


@FilesMenu
$ #Меню файлов#
   #Просмотр#             ~Просмотр файлов~@Viewer@, подсчёт размеров папок.

   #Редактирование#       ~Редактирование~@Editor@ файлов.

   #Копирование#          ~Копирование~@CopyFiles@ файлов и папок.

   #Перенос#              ~Переименование или перенос~@CopyFiles@ файлов и папок.

   #Ссылка#               ~Создание ссылок~@HardSymLink@ на файлы и папки.

   #Создание папки#       ~Создание~@MakeFolder@ новой папки.

   #Удаление#             Удаление файлов и папок.

   #Уничтожение#          Уничтожает файлы и папки. Перед удалением
                        файл перезаписывается нулями, усекается
                        до нулевой длины и переименовывается во
                        временное имя.

   #Архивировать#         Добавить выбранные файлы к архиву.

   #Распаковать#          Распаковать выбранные файлы из архива.

   #Атрибуты файлов#      ~Изменить атрибуты~@FileAttrDlg@ и время файла.

   #Применить команду#    ~Применить команду~@ApplyCmd@ к выбранным файлам.

   #Описание файлов#      Добавить ~описания~@FileDiz@ к выбранным файлам.

   #Пометить группу#      Пометить заданную маской группу файлов.

   #Снять пометку#        Снять пометку с соответствующей заданной
                        маске группы файлов.

   #Инверсия пометки#     Инвертировать текущую пометку файлов.

   #Восстановить пометку# Восстановить предыдущую пометку после
                        обработки файлов или операции пометки группы.

    Некоторые команды из этого меню также описаны в теме
~Управление файлами и сервисные команды~@FuncCmd@.

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.


@CmdMenu
$ #Меню команд#
   #Поиск файла#          Поиск файлов, удовлетворяющих заданной маске.
                        Эта команда описана подробнее
                        в теме ~Поиск файла~@FindFile@.

   #История команд#       Показать предыдущие команды. Эта команда
                        описана подробнее в теме ~История команд~@History@.

   #Видеорежим#           Выбрать количество строк на экране.

   #Поиск папки#          Поиск папки в дереве папок.
                        Дополнительная информация об этой команде
                        содержится в теме ~Поиск папки~@FindFolder@.

   #История просмотра#    Показать ~историю просмотра~@HistoryViews@ и редактирования
                        файлов.

   #История папок#        Показать ~историю смены папок~@HistoryFolders@.

                        Элементы истории просмотра и истории смены
                        папок после выбора передвигаются в конец
                        списка. Вы можете использовать #Shift-Enter#,
                        чтобы выбрать элемент без смены его позиции.

   #Поменять панели#      Поменять левую и правую панели местами.

   #Панели Вкл/Выкл#      Показать/спрятать обе панели.

   #Сравнение папок#      Сравнить содержимое папок.
                        Дополнительная информация об этой команде
                        содержится в теме ~Сравнение папок~@CompFolders@.

   #Меню пользователя#    Позволяет редактировать главное или местное
                        ~меню пользователя~@UserMenu@. Для вставки пункта
                        используется #Ins#, для удаления - #Del#,
                        для редактирования - #F4#.

   #Ассоциации файлов#    Показывает список ~ассоциаций файлов~@FileAssoc@.
                        Для вставки новой ассоциации может
                        использоваться #Ins#, для удаления - #Del#,
                        для редактирования - #F4#.

   #Закладки#             Показывает текущие ~закладки~@Bookmarks@.

   #Фильтр панели#        Позволяет управлять содержимым панели файлов.
   #файлов#               Дополнительная информация об этой команде
                        содержится в теме ~меню фильтров~@FiltersMenu@.

   #Команды#              Показывает список доступных
   #внешних модулей#      ~подключаемых модулей~@Plugins@.

   #Список экранов#       Показывает ~список открытых экранов~@ScrSwitch@.

   #Список задач#         Показывает ~список активных задач~@TaskList@.

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.


@OptMenu
$ #Меню параметров#
   #Системные параметры#  Вызывает ~диалог системных параметров~@SystemSettings@.

   #Настройки панели#     Вызывает ~диалог настроек панели~@PanelSettings@.

   #Настройки интерфейса# Вызывает ~диалог настроек интерфейса~@InterfSettings@.

   #Настройки ввода#      Вызывает ~диалог настроек ввода~@InputSettings@.

   #Настройки диалогов#   Вызывает ~диалог настроек диалогов~@DialogSettings@

   #Настройки меню#       Вызывает ~диалог настроек меню~@VMenuSettings@

   #Настройки командной#  Вызывает ~диалог настроек командной строки~@CmdlineSettings@
   #строки#

   #Группы масок файлов#  Управление ~группами масок файлов~@MaskGroupsSettings@.

   #Языки#                Выбор основного языка и языка помощи.
                        Используйте команду "Сохранить параметры",
                        чтобы сохранить выбранные языки.

   #Параметры#            Настройка параметров подключаемых
   #внешних модулей#      ~внешних модулей~@Plugins@.

   #Подтверждения#        Включение или выключение ~подтверждений~@ConfirmDlg@
                        для некоторых операций.

   #Режимы панели#        ~Настройка режимов просмотра~@PanelViewModes@ панели файлов.
   #файлов#

   #Описания файлов#      Режимы обновления и имена ~описаний файлов~@FileDiz@.

   #Файлы описания#       Имена или ~маски файлов~@FileMasks@, отображаемых
   #папок#                в ~панели информации~@InfoPanel@ в качестве описания
                        папки.

   #Настройки программы#  ~Настройки внешней программы просмотра~@ViewerSettings@.
   #просмотра#

   #Настройки редактора#  ~Настройки внешнего и встроенного редактора~@EditorSettings@.

   #Цвета#                Изменение цвета различных элементов
                        интерфейса или изменение всей палитры цветов
                        либо на чёрно-белую, либо на предлагаемую
                        по умолчанию.

   #Раскраска файлов#     Редактирование
   #и группы сортировки#  ~раскраски файлов и групп сортировки~@Highlight@.

   #Настройки#            Вызывает диалог ~Уведомления~@NotificationsSettings@.
   #уведомлений#

   #Сохранить параметры#  Сохранение текущей конфигурации, цветов
                        и внешнего вида экрана.

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.

@Terminal
$ #Терминал#
    #FAR2L# содержит встроенный эмулятор терминала, позволяющий исполнять приложения командной строки и управлять ими, наблюдая их вывод.
Для соблюдения привычного пользовательского опыта far2l запускает приложения внутри поддерживаемой интерактивной оболочки командной строки.
    #Автодополнение# FAR2L имеет два независимых механизма автоматического дополнения командной строки. Первый является механизмом автодополнения,
реализованным в оригинальном FAR, и работает, предлагая меню вариантов, пока вы печатаете команды. Второй работает на основе механизма автодополнения
командной оболочки bash и может быть активирован нажатием #SHIFT+двойной-TAB# (быстро дважды нажать TAB при нажатом SHIFT).
    #Поведение команды 'exit':# ввод команды 'exit' приведет к закрытию оболочки командной строки, но не закроет само приложение far2l, а последующий
запуск другой команды запустит новую оболочку. Это позволяет 'сбросить' окружение оболочки от измененных переменных оболочки и других её настроек.
Если же вы хотите закрыть far2l с командной строки: напечатайте ~псевдокоманду~@SpecCmd@ 'exit far' - она будет распознана far2l как команда закрытия.
    #Кнопкосочетания и скроллинг во время исполнения команды:# вы можете использовать кнопкосочетание #Ctrl+Shift+F3#, чтобы открыть историю
вывода терминала во встроенном просмотрщике, или #Ctrl+Shift+F4#, чтобы открыть её во встроенном редакторе. Это позволяет эффективно исследовать
вывод команд, используя возможности встроенного просмотрщика и редактора, такие как скроллинг, поиск подстрок и т.п. Вы также можете открыть
просмотрщик, проскроллив мышкой вверх, и закрыть его, проскроллив затем в самый конец истории.
Кнопкосочетания #Ctrl+C, Ctrl+Z# вызывают стандартные сигналы. Кстати, в случае полного зависания команды с игнорированием стандартных сигналов,
вы можете убить все запущенное в оболочке, нажав #Ctrl+Alt+C#. Учтите, что не рекомендуется злоупотреблять данным кнопкосочетанием, так как оно может
вызвать повреждение или несохранение данных убитого приложения. Вы также можете использовать сочетание #Ctrl+Alt+Z#, чтобы переключить исполнение команды, освободив терминал.
Вернуться к этой команде можно будет через меню ~Переключение между экранами~@ScrSwitch@ (#F12# в панелях).
    #Кнопкосочетания и скроллинг НЕ во время исполнения команды:# хотя вышеописанные #Ctrl+Shift+F3/F4# также функционируют, в таком режиме вы можете
вместо них использовать просто #F3/F4#. Также вы можете использовать кнопку #F8#, чтобы очистить буфер истории и экран. Переключение между терминалом и 
панелями возможно нажатием сочетания #Ctrl+O# или щелчком по левому верхнему углу окна.
    #Расширения терминала FAR2L#. Несмотря на то, что FAR2L сам по себе это приложение тeкстового режима, он способен работать в режиме вывода через подсистему
~GUI или TTY (терминал)~@UIBackends@. Хотя TTY режим может функционировать в обычном терминале, как xterm, или в терминале клиента SSH сессии,
но он так же может работать внутри терминала другого far2l, получая от этого дополнительные возможности, недоступные под 'обычными' терминалами,
такие как распознавание всех кнопок клавиатуры и событий нажатия/отпускания кнопок. Также 'хостовый' far2l может предоставлять доступ к буферу
обмена хоста и механизм уведомлений рабочего стола. Вы можете использовать эту функциональность, запуская TTY far2l на SSH сервере внутри SSH сессии
клиента, запущенного внутри терминала far2l, работающего в GUI режиме на хосте клиента. Или, что намного проще, используя плагин с возможностью
запуска команд на удаленном SSH сервере. Примером такого плагина является NetRocks, а точнее поддерживаемые им SFTP/SCP протоколы.

  Выделенный мышью текст автоматически копируется в буфер обмена.

  Предыдущая команда                                        #Up, Ctrl-E#
  Следующая команда                                       #Down, Ctrl-X#
  Очистить командную строку                                     #Ctrl-Y#
    (см. также ~Клавиатурные комбинации Командной строки~@CmdLineCmd@)

  Автодополнение (на основе FAR2L)                                 #Tab#
  Автодополнение (на основе bash)                        #Shift-Tab-Tab#

  Убрать/показать обе панели                                    #Ctrl-O#
  Убрать/показать левую панель                                 #Ctrl-F1#
  Убрать/показать правую панель                                #Ctrl-F2#

  Вставить имя файла из активной панели                     #Ctrl-Enter#
  Вставить имя файла из пассивной панели              #Ctrl-Shift-Enter#
  Вставить полное имя файла из активной панели                  #Ctrl-F#
  Вставить полное имя файла из пассивной панели                 #Ctrl-;#

  Терминал->Просмотр                                 #F3, Ctrl+Shift+F3#
    (вся история терминала в Просмотр - удобно для пролистывания длинного вывода)

  Терминал->Редактор                                 #F4, Ctrl+Shift+F4#
    (вся история вывода терминала в Редактор)

  Очистка истории терминала и экрана                                #F8#

  Стандартные сигналы терминала                         #Ctrl+C, Ctrl+Z#

  Убить все запущенное в оболочке                           #Ctrl+Alt+C#
    (не злоупотреблять во избежании повреждения / не сохранения данных)

  Отправить в фон выполняющуюся в терминале команду         #Ctrl+Alt+Z#

  См. также: ~псевдокоманды~@SpecCmd@
             ~команды операционной системы~@OSCommands@

@UIBackends
$ #Режимы интерфейса#
    В зависимости от настроек билда и доступных возможностей платформы #FAR2L# может выводить
свой интерфейс, используя следующие режимы:

    - #Режим GUI:# выводит интерфейс в свое собственное графическое окно, обеспечивая наиболее полную
поддержку клавиатурных комбинаций.
    - #Режим TTY:# выводит интерфейс в обычный терминал. Это наиболее совместимый способ, но он предоставляет
наименее полную поддержку клавиатурных комбинаций, не имеет общего буфера обмена и т.п.
    - #Режим TTY|X:# выводит интерфейс в обычный терминал, но использует X11 для доступа к буферу обмена и для получения
состояний клавиш-модификаторов. Это обеспечивает более удобное использование, но все еще некоторые клавиатурные
комбинации могут не поддерживаться.
    - #Режим TTY|Xi:# выводит интерфейс в обычный терминал, но использует X11 с расширениями Xi для доступа к буферу обмена
и для получения состояний всех клавиш клавиатуры. Это обеспечивает самое удобное использование в обычном терминале.
    - #Режим TTY|F:# выводит интерфейс в терминал, созданный другим экземпляром far2l. Это обеспечивает уровень
удобства использования, аналогичный режиму GUI (если терминал предоставлен GUI версией far2l).

    Если вы хотите запустить far2l удаленно с максимальным удобством, то рекомендуется либо запустить его из сессии
подключения NetRocks, что позволяет использовать TTY|F режим. Если же это невозможно - рекомендуется запускать far2l
в SSH сессии с включенным доверенным форвардингом протокола X11 и сжатием (ssh -Y -C ...), что позволяет использовать
режим TTY|Xi или хотя бы TTY|X. При этом
#крайне не рекомендуется использовать доверенный форвардинг X11 при подключении к недоверенному серверу#,
поскольку это открывает коду, исполняемому на удаленном сервере, неконтролируемую возможность прослушивания ваших
клавиатурных нажатий, копирования содержимого буфера обмена и скриншотов окон. Таким образом, TTY|F режим является
единственным безопасным методом удаленного запуска far2l на недоверенном сервере с поддержкой всех привычных
клавиатурных сочетаний и прочих удобств.

    - Терминал-специфичные бекенды (используют соответствующие расширения терминала для получения состояния всех клавиш клавиатуры;
в чистом TTY| для доступа к буферу обмена необходимо включить OSC 52 и в настройках FAR2L, и в настройках терминала;
TTY|X использует X11 для доступа к буферу обмена):
        - #TTY|a# или #TTY|Xa# бекенд: вывод интерфейса в терминал Apple iTerm2.
        - #TTY|k# или #TTY|Xk# бекенд: вывод интерфейса в kovidgoyal's Kitty (и любые другие терминалы, поддерживающие
соответствующий клавиатурный протокол).
        - #TTY|w# или #TTY|Xw# бекенд: вывод интерфейса в Windows Terminal (и прочие терминалы с поддержкой win32 input mode).
    Список и ссылки на поддерживаемые терминалы смотрите в разделе ~Особенности FAR2L - начало работы~@Far2lGettingStarted@.

@ConfirmDlg
$ #Подтверждения#
    В диалоге #Подтверждения# вы можете разрешить или запретить
подтверждения для следующих операций:

    - перезаписывание файлов во время копирования;

    - перезаписывание файлов во время переноса;

    - перезаписывание и удаление файлов с атрибутом "только для чтения";

    - ~перетаскивание~@DragAndDrop@ файлов;

    - удаление файлов;

    - удаление папок;

    - прерывание операций (нажали клавишу #Esc#);

    - ~отключение сетевого устройства~@DisconnectDrive@ из меню перехода;

    - очистка экрана и истории терминала нажатием F8;

    - отключение запоминающих устройство для USB из меню перехода;

    - ~повторное открытие~@EditorReload@ файла в редакторе;

    - очистка списка историй редактирования/просмотра, переходов и
      выполненных команд;

    - выход из FAR2L.


@PluginsManagerSettings
$ #Менеджер внешних модулей#

  #Путь к персональным плагинам#
  Укажите полный путь, где FAR2L будет искать "персональные" плагины в дополнение к "основным". Можно указать
несколько путей поиска, разделённых символом ';'. При указании пути поиска можно использовать переменные среды.
Персональные плагины не будут загружаться, если в параметрах ~командной строки~@CmdLine@ указан ключ -co.


@ChoosePluginMenu
$ #Меню выбора плагина#

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.


@MakeFolder
$ #Создание папки#
    Эта функция служит для создания папок. Вы можете использовать переменные
окружения в строке ввода, которые перед созданием папки преобразуются в
содержащееся в ней значение. Также существует возможность создавать несколько
вложенных папок за один раз: для этого отделите имена папок друг от друга
символом "/". Например:

    #$HOSTNAME/$USER/Папка3#

    Если включена опция "#Обрабатывать несколько имён папок#", то можно
создавать несколько папок за один раз. В этом случае имена папок должны быть
разделены символом-разделителем "#;#" или "#,#". Если эта опция включена и имя
папки содержит в себе символ "#;#" (или "#,#"), то оно должно быть взято в
кавычки. Например, если будет введено #Foo1;"foo,2;";foo3#, то
будут созданы папки с именами: "#Foo1#", "#foo,2;#" и "#foo3#".


@FindFile
$ #Поиск файла #
    Эта команда предназначена для поиска одного или нескольких файлов и папок в
дереве папок, в соответствии с одной или несколькими разделёнными запятыми или
точкой с запятой ~масками~@FileMasks@. Также она может быть использована с
файловыми системами, поддерживаемыми с помощью ~внешних модулей~@Plugins@.

    Дополнительно может быть указан текст, который должен содержаться в
искомых файлах. В этом случае параметр #Учитывать регистр# может быть
использован для проведения регистрозависимого поиска.

    Параметр #Только целые слова# позволит искать только текст, который отделён
от остального текста пробелом, знаком табуляции, возврата каретки, перевода
строки или стандартными разделителями:
#!%^&*()+|{}:"<>?`-=\\[];',./#.

    Установка параметра #Искать 16-ричный код# позволяет искать файлы,
содержащие шестнадцатеричную последовательность введённых байт. В этом случае
параметры #Учитывать регистр#, #Только целые слова#, #Используя кодовую страницу#
и #Искать папки# блокируются и их значения на процесс поиска не
влияют.

    Выпадающий список #Используя кодовую страницу# позволяет выбрать конкретную
кодовую страницу, применяемую для поиска текста. Если в выпадающем списке выбрать
пункт #Все кодовые страницы#, то FAR2L будет использовать для поиска все стандартные
и #Любимые# кодовые страницы (список #Любимых# кодовых страниц можно настроить в
меню выбора кодовой страницы редактора или программы просмотра). Если перечень
кодовых страниц, поиск по которым производится при выборе пункта #Все кодовые#
#страницы#, является для вас избыточным, то вы можете, при помощи клавиш #Ins# и
#Space#, выбрать из списка стандартных и #Любимых# кодовых страниц только те кодовые
страницы, по которым вам необходимо осуществлять поиск.

    Для поиска файлов и в архивах нужно установить опцию #Искать в архивах#. В
то же время, это существенно замедляет выполнение операции.
    Поиск во вложенных архивах не производится.

    Параметр #Искать папки# позволяет включать в список поиска папки,
совпадающие с маской поиска. При этом счётчик найденных файлов учитывает также
и найденные папки.

    Параметр #Искать в символических ссылках# позволяет искать файлы в
~символических ссылках~@HardSymLink@ наравне с обычными подкаталогами.

    Поиск может выполняться:

    - на всех дисках, кроме сменных;

    - на всех локальных дисках, кроме сменных и сетевых;

    - во всех папках, перечисленных в переменной окружения $PATH
      (без вложенных папок);

    - во всех папках, начиная с корневой, в диалоге поиска
      можно выбрать путь поиска (кнопка "Диск");

    - во всех папках, начиная с текущей папки;

    - только в текущей папке;

    - в отмеченных папках.

    Параметры поиска сохраняются в конфигурации.

    Для поиска файлов, попадающих под определённые условия, используйте переключатель
#Использовать фильтр#. Настройка условий ~фильтра~@FiltersMenu@ осуществляется
кнопкой #Фильтр#.

    С помощью кнопки #Дополнительно# вызывается диалог настройки
~дополнительных параметров поиска~@FindFileAdvanced@, которые используются для
настройки расширенного набора свойств поиска.


@FindFileAdvanced
$ #Дополнительные параметры поиска#
    Введённая в поле #Содержащих текст# (или в поле #Содержащих 16-ричный код#)
строка текста может разыскиваться не только во всём файле, но также в заданном
начальном диапазоне, определяемом свойством #Проводить поиск в первых#.
В случае если задано значение, которое меньше размера файла, то остаток файла
будет игнорироваться, даже если искомая последовательность будет там находиться.

    При задании размера можно использовать следующие суффиксы:
    B - для байтов (так же без суффикса);
    K - для килобайтов;
    M - для мегабайтов;
    G - для гигабайтов;
    T - для терабайтов;
    P - для петабайтов;
    E - для эксабайтов.

    #Типы колонок# - позволяет задавать формат вывода результатов поиска.
Типы колонок кодируются с помощью одной или нескольких букв, разделённых запятыми.
Допускаются следующие типы колонок:

    S[C,T,F,E] - размер файла
    P[C,T,F,E] - упакованный размер файла
    G[C,T,F,E] - размер потоков файла
                 где: C - форматировать размер файла;
                      T - использовать 1000 вместо 1024 как делитель;
                      F - показывать размер файла в стиле Windows
                          Explorer (т.е. 999 байт будут показаны
                          как 999, а 1000 байт как 0.97 K);
                      E - экономичный режим, не показывать пробел
                          перед суффиксом размера файла
                          (т.е. 0.97KB);

    D          - дата последней записи в файл
    T          - время последней записи в файл

    DM[B,M]    - дата и время последней записи в файл
    DC[B,M]    - дата и время создания файла
    DA[B,M]    - дата и время последнего доступа к файлу
    DE[B,M]    - дата и время изменения файла
                 где: B - краткий (Unix-стиль) формат времени файла;
                      M - использование текстовых имён месяцев;

    A          - атрибуты файла

    LN         - количество жёстких ссылок

    F          - количество потоков


    Windows атрибуты файла имеют следующие обозначения:
       #R#         - Только для чтения
       #S#         - Системный
       #H#         - Скрытый
       #A#         - Архивный
       #L#         - Связь или символическая ссылка
       #C# или #E#   - Сжатый или Зашифрованный
       #$#         - Разрежённый (sparse)
       #T#         - Временный
       #I#         - Неиндексируемый по содержимому
       #O#         - Автономный (offline)
       #V#         - Виртуальный

    Типы файлов Unix:
       #B#         - Битая (устаревшая) символическая ссылка
       #d#         - Каталог
       #c#         - Символьное устройство
       #b#         - Блочное устройство
       #p#         - FIFO (именованный канал)
       #s#         - Сокет
       #l#         - Символическая ссылка
       #-#         - Обычный файл

    Права доступа к файлам Unix (в каждой триаде для владельца, группы, других пользователей):
       #r# или #-#    - доступен для чтения или нет
       #w# или #-#    - доступен для записи или нет
       #x# или #-#    - исполняемый или нет
       #s# или #S#    - setuid/setgid, также исполняемый (#s#), или не исполняемый (#S#)
       #t# или #T#    - sticky, также исполняемый (#t#), или не исполняемый (#T#)

    Символ атрибута "Разрежённый" применяется только для файлов и ставится вместо 'L'.
Символ атрибута "Зашифрованный" ставится вместо 'C', т.к. файл/каталог не могут иметь
одновременно оба атрибута ("Сжатый" и "Зашифрованный").
    По умолчанию размер колонки атрибутов - 6 символов. Для отображения дополнительных
атрибутов 'T', 'I', 'O' и 'V' необходимо явно указать размер колонки в 10 символов.

    #Ширина колонок# - позволяет изменить ширину колонок результатов поиска.
Если ширина равна 0, то используется значение по умолчанию.

    Для использования 12-часового формата времени надо увеличить
на единицу стандартную ширину колонки времени файла или колонки
времени и даты файла. После дальнейшего увеличения в этих колонках
также будут показаны секунды и миллисекунды.

    Для показа года в 4-х символьном формате нужно увеличить ширину
колонки даты на 2.

    В отличии от режимов панелей, результат поиска может содержать только
одну колонку. Имя файла присутствует всегда - добавляется последней колонкой
автоматически.

    При указании колонок, отвечающих за показ ссылок и потоков (G, LN, и F), время
поиска увеличивается.

    Чтобы в результатах поиска отображать только имена файловых объектов без
дополнительных атрибутов, оставьте поле "Типы колонок" пустым.

    По умолчанию значения полей равны:
    "Типы колонок"   - D,S,A
    "Ширина колонок" - 14,13,0


@FindFileResult
$ #Поиск файла: клавиши управления#
    Во время или после завершения ~поиска~@FindFile@ вы можете использовать
клавиши управления курсором для передвижения по списку файлов и кнопки для
выполнения требуемых действий.

    Во время или после завершения поиска доступны следующие кнопки:

   #Новый поиск#     Начать новую операцию поиска.

   #Перейти#         Прервать поиск, сменить текущую папку и поместить
                   курсор на выбранный файл.

   #Смотреть#        Просмотр выбранного файла без прерывания поиска.

   #Панель#          Создать временную панель и заполнить её найденными
                   файлами.

   #Стоп#            Прервать поиск. Доступна во время поиска.

   #Отмена#          Прервать поиск и закрыть диалог.

    Для просмотра и редактирования найденных файлов могут быть использованы
#F3# и #F4#. Редактирование и просмотр поддерживаются также для файловых систем
подключаемых модулей. Заметьте, что сохранение изменений в редакторе по клавише
#F2# для файловых систем подключаемых модулей будет вызывать операцию
#Сохранить в# вместо обычного #Сохранить#.


@FindFolder
$ #Поиск папки#
    Эта команда предназначена для быстрого поиска нужной папки в дереве папок.

    Для выбора папки вы можете использовать клавиши управления курсором или
набрать несколько начальных символов имени папки.

    Нажмите #Enter# для перехода в выбранную папку.

    #Ctrl-R# и #F2# позволяют перечитать дерево папок.

    #Gray +# и #Gray -# используются для быстрого перемещения вверх или вниз
по папкам одного уровня.

    #F5# позволяет развернуть окно на весь экран, повторное нажатие #F5# вернёт
размер окна в первоначальное состояние.

    С помощью #Ctrl-Enter# можно циклически перемещаться по элементам дерева в
соответствии с введённой в строке файловой маской. #Ctrl-Shift-Enter# позволяет
перемещаться по элементам в обратном направлении.

    См. также список ~макроклавиш~@KeyMacroFindFolderList@, доступных в поиске папок.

@Filter
$ #Фильтр#
    Фильтр служит для обработки определённых групп файлов по заданным
пользователем параметрам, при соблюдении которых файл будет обработан
использующей его операцией. Фильтр может настраиваться по разным типам
параметров.

    Диалог фильтра состоит из следующих элементов:

   #Имя фильтра#     Название, которое будет отображаться в списке
                   фильтров. Вы можете оставить это поле пустым.

                   Данный элемент отсутствует, если фильтр вызван
                   из команды ~Раскраска файлов и группы сортировки~@Highlight@.


   #Маска#           Одна или несколько ~масок файлов~@FileMasks@.

                   Файл попадает в условия фильтра, если включён
                   анализ масок файла и его имя соответствует хотя бы
                   одной маске. Если анализ масок отключён, то имя
                   файла не имеет значения.


   #Размер#          Минимальный и максимальный размер файла.
                   При задании размера можно использовать следующие суффиксы:
                   B или без суффикса - для байтов;
                   K - для килобайтов;
                   M - для мегабайтов;
                   G - для гигабайтов;
                   T - для терабайтов;
                   P - для петабайтов;
                   E - для эксабайтов.

                   Файл попадает в условия фильтра, если включён
                   анализ размера файла и он входит в введённый
                   диапазон. Если в качестве одной или обеих границ
                   диапазона ничего не введено (пустая строка), тогда
                   размер по этому условию не ограничивается.

                   Например:
                   >= 1K - выбрать файлы больше или равные 1 килобайт
                   <= 1M - до меньше или равные 1 мегабайт


   #Дата/время#      Дата/время начала и окончания действия фильтра.
                   Можно указать дату последней #записи#, дату
                   #создания# файла, дату последнего #доступа# или
                   дату #изменения#.

                   Кнопка #Текущая# позволяет заполнить поля времени
                   файла текущим временем, после чего вы можете
                   поменять отдельную составляющую даты и времени,
                   например только месяц или только минуты.
                   #Сброс#, чтобы очистить поля с датами и временем.

                   Файл попадает в условия фильтра, если включён
                   анализ даты файла и она попадает в введённый
                   диапазон и соответствует установленному типу.
                   Если одно или оба поля с датами пусто, тогда дата
                   по этому полю не ограничивается.

                   Например:
                   <= 31.01.2010 - выбрать файлы в период до 31 числа
                   >= 01.01.2010 - но после 1 января 2010 года

                   Опция #Относительная# позволяет переключиться
                   на работу с датой в относительном времени.
                   Логика работы при данной опции аналогична
                   арифметике с отрицательными числами.

                   Например:
                   <= 0  - выбрать файлы в период от "сегодня"
                   >= 30 - и до 30-ти дней назад включительно

   #Атрибуты#        Атрибуты включения и атрибуты исключения.

                   Файл попадает в условия фильтра, если включён
                   анализ атрибутов файла и он имеет все атрибуты
                   включения и не имеет атрибутов исключения:
                   #[x]# - атрибут включения - файл должен иметь
                         указанный атрибут.
                   #[ ]# - атрибут исключения - файл не должен иметь
                         указанный атрибут.
                   #[?]# - указанный атрибут не влияет на фильтр.

                   Атрибуты #Сжатый#, #Зашифрованный#, #Неиндексируемый#,
                   #Разрежённый#, #Временный# и #Автономный# используются
                   только на дисках с файловой системой NTFS. Атрибут
                   #Виртуальный# не используется в Windows 2000/XP/2003.

    Для быстрого отключения одного или нескольких условий фильтра отключите
соответствующие опции. Клавиша #Очистить# сбросит все условия фильтра.

@HistoryCmd
$ #Общие команды списков историй#

  Очистить историю команд                                         #Del#

  Удалить текущий пункт из истории                          #Shift-Del#

  Установить/снять пометку блокировки пункту истории              #Ins#
   (заблокированный пункт не удаляется по #Del# или #Shift-Del#)

  Копировать содержимое текущего пункта истории                #Ctrl-C#
  в Буфер Обмена не закрывая списка                      или #Ctrl-Ins#

  Переключение вида истории:                                   #Ctrl-T#
             * с строками дат + колонка времени
             * с строками дат (как в far3)
             * просто история (как в far2)

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.

@History
$ #История команд#
    История команд показывает список выполненных ранее команд. Кроме клавиш
управления курсором доступны следующие клавиши:

  Повторно выполнить команду                                    #Enter#

  Повторно выполнить команду в отдельном окне             #Shift-Enter#

  Повторно выполнить команду от имени администратора   #Ctrl-Alt-Enter#

  Поместить команду в командную строку                     #Ctrl-Enter#

  Очистить историю команд                                         #Del#

  Удалить текущий пункт из истории                          #Shift-Del#

  Установить/снять пометку блокировки пункту истории              #Ins#

  Копировать содержимое текущего пункта истории                #Ctrl-C#
  в Буфер Обмена не закрывая списка                      или #Ctrl-Ins#

  Переключение вида истории:                                   #Ctrl-T#
             * с строками дат + колонка времени-пути
             * с строками дат (как в far3)
             * просто история (как в far2)

  Изменить ширину пути в колонке времени-пути    #Ctrl-Left,Ctrl-Right#

  Показать дополнительную информацию                               #F3#

  Быстрый переход на панели к каталогу команды               #Ctrl-F10#

    Для перехода к предыдущей или следующей команде непосредственно из
командной строки, можно использовать клавиши #Ctrl-E# или #Ctrl-X#
соответственно.

    Для выбора команды также можно использовать подсвеченные буквы.

    Для сохранения истории команд после выхода, используйте соответствующую
опцию из ~диалога системных параметров~@SystemSettings@.

    Отмеченные пункты не будут удаляться при очистке истории.

    Метод Удаления дубликатов можно выбрать в ~диалоге системных параметров~@SystemSettings@.

    Действия, заносимые в историю команд, настраиваются в ~Настройка автозавершения и истории~@AutoCompleteSettings@.

    Для автоматического исключения из истории смотри диалог ~Настройка автозавершения и истории~@AutoCompleteSettings@.

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.
               клавиатурные команды, общие ~для всех историй~@HistoryCmd@.

@HistoryViews
$ #История просмотра и редактирования#
    История просмотра и редактирования файлов показывает список просмотренных
или редактируемых ранее файлов. Кроме клавиш управления курсором доступны
следующие клавиши:

  Повторно открыть файл на просмотр                             #Enter#
  или редактирование

  Поместить имя файла в командную строку                   #Ctrl-Enter#

  Очистить список истории                                         #Del#

  Удалить текущий пункт из истории                          #Shift-Del#

  Установить/снять пометку блокировки пункту истории              #Ins#

  Обновить список, удалив недоступные файлы                    #Ctrl-R#

  Копировать содержимое текущего пункта истории                #Ctrl-C#
  в Буфер Обмена не закрывая списка                      или #Ctrl-Ins#

  Открыть файл в ~редакторе~@Editor@                                         #F4#

  Открыть файл в ~программе просмотра~@Viewer@                               #F3#
                                                        или  #Numpad 5#

  Переключение вида истории:                                   #Ctrl-T#
             * с строками дат + колонка времени
             * с строками дат (как в far3)
             * просто история (как в far2)

  Быстрый переход на панели к каталогу и файлу               #Ctrl-F10#

    Для выбора пункта в списке истории также можно использовать подсвеченные буквы.

    Элементы истории просмотра и редактирования после выбора передвигаются в
конец списка. Вы можете использовать #Shift-Enter#, чтобы выбрать элемент без
смены его позиции.

    Для сохранения истории просмотра и редактирования файлов после
выхода, используйте соответствующие опции из диалога ~системных параметров~@SystemSettings@.

  Примечания:

  1. ^<wrap>Операция обновления списка (#Ctrl-R#) может занять значительное время,
если файл находился на недоступном в данный момент сетевом ресурсе.

  2. ^<wrap>Отмеченные пункты не будут удаляться при очистке или обновлении истории.

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.
               клавиатурные команды, общие ~для всех историй~@HistoryCmd@.

@HistoryFolders
$ #История смены папок#
    История смены папок показывает список ранее посещаемых папок. Кроме клавиш
управления курсором доступны следующие клавиши:

  Перейти в указанную папку                                     #Enter#

  Перейти в указанную папку на пассивной панели      #Ctrl-Shift-Enter#

  Поместить имя папки в командную строку                   #Ctrl-Enter#

  Очистить список истории                                         #Del#

  Удалить текущий пункт из истории                          #Shift-Del#

  Установить/снять пометку блокировки пункту истории              #Ins#

  Обновить список, удалив недоступные папки                    #Ctrl-R#

  Копировать содержимое текущего пункта истории                #Ctrl-C#
  в Буфер Обмена не закрывая списка                      или #Ctrl-Ins#

  Переключение вида истории:                                   #Ctrl-T#
             * с строками дат + колонка времени
             * с строками дат (как в far3)
             * просто история (как в far2)

  Быстрый переход на панели к каталогу (здесь аналог #Enter#)  #Ctrl-F10#

    Для выбора пункта в списке истории также можно использовать подсвеченные буквы.

    Элементы истории смены папок после выбора передвигаются в конец списка. Вы
можете использовать #Shift-Enter#, чтобы выбрать элемент без смены его позиции.

    Для сохранения истории смены папок после выхода, используйте
соответствующую опцию из диалога ~системных параметров~@SystemSettings@.

  Примечания:

  1. ^<wrap>Операция обновления списка (#Ctrl-R#) может занять значительное время,
если каталог находился на недоступном в данный момент сетевом ресурсе.

  2. ^<wrap>Отмеченные пункты не будут удаляться при очистке или обновлении истории.

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.
               клавиатурные команды, общие ~для всех историй~@HistoryCmd@.

@TaskList
$ #Список задач#
    Список задач отображает активные задачи с использованием #htop# (если доступно)
или #top# в качестве запасного варианта.

@CompFolders
$ #Сравнение папок#
    Команду сравнения папок можно выполнять, только когда обе панели на экране
являются ~панелями файлов~@FilePanel@. Она сравнивает содержимое отображаемых в
этих панелях папок. Файлы, которые присутствуют только в одной панели, или
файлы с более поздней датой записи, чем у файлов с тем же именем в другой
панели, становятся помеченными.

    Вложенные папки не сравниваются. Для сравнения файлов используется их имя,
дата и время, но не содержимое.

    См. параметр #Учитывать регистр при сравнении или пометке# в диалоге
~Настроек панели~@PanelSettings@.


@UserMenu
$ #Меню пользователя#
    Меню пользователя предназначено для упрощения выполнения часто используемых
операций. Оно содержит заданные пользователем команды и последовательности
команд, которые могут быть выполнены с использованием этого меню. Меню
пользователя может включать вложенные меню. Специальные
~метасимволы~@MetaSymbols@ поддерживаются и в командах, и в заголовках команд
меню. Обратите внимание, что символ !?<title>?<init>! может быть использован
для ввода дополнительных параметров непосредственно перед выполнением команды.

    Вы можете изменить порядок пунктов меню нажимая #Ctrl-Up# и #Ctrl-Down#.

    Для редактирования или создания главного или местного меню пользователя
применяется команда #Меню пользователя# из ~Меню команд~@CmdMenu@. Главное меню
пользователя может быть только одно. Главное меню вызывается в том случае, если
для текущей папки отсутствует местное меню. Местное меню может быть расположено
в любой папке. Вы можете в любой момент переключиться между местным меню и
главным меню с помощью клавиш #Shift-F2#. Вы также можете вызвать местное меню
из родительской папки с помощью клавиши #BkSpace#.

    Для добавления разделителя в пользовательское меню нужно
добавить новый пункт меню (команду), в котором в качестве "Горячей клавиши"
указать "--". Удалить такой разделитель можно только через #Ctrl-F4#.

    Для выполнения команды из меню пользователя нужно выбрать её с помощью
клавиш управления курсором и нажать #Enter#. Также можно использовать
назначенную для данного пункта меню #горячую клавишу#.

    Вы можете удалить вложенное меню или пункт меню, используя клавишу #Del#,
вставить новое вложенное меню или пункт меню с помощью #Ins# и редактировать
существующее вложенное меню или пункт меню с помощью #F4#. Нажмите #Ctrl-F4# для
редактирования меню в виде текстового файла.

    В качестве горячих клавиш для обращения к пунктам меню могут использоваться
цифры, буквы и функциональные клавиши (#F1#..#F24#). Если использованы #F1# и #F4#,
их первоначальные функции теряются. В этом случае для редактирования меню может
применяться #Shift-F4#.

    При редактировании или создании пункта меню нужно ввести заголовок пункта,
который будет отображаться в меню, последовательность команд, выполняющихся при
выбора данного пункта меню, и, при необходимости, горячую клавишу для быстрого
доступа к этому пункту.

    При редактировании или создании вложенного меню достаточно ввести заголовок
вложенного меню и, при необходимости, горячую клавишу.

    Местные меню хранятся в текстовых файлах #FarMenu.ini#.
    Главное меню хранится в профиле в #~~/.config/far2l/settings/user_menu.ini#
(формат отличается от FarMenu.ini).
Если создать местное меню в папке FAR2L,
то оно будет использовано вместо хранящегося в профиле главного меню.

    Вы можете закрыть меню на любом уровне вложенности нажав #Shift-F10#.

    См. также:
      ~Псевдокоманды~@SpecCmd@.
      Список ~макроклавиш~@KeyMacroUserMenuList@, доступных в меню пользователя.
      Клавиатурные команды, общие ~для всех меню~@MenuCmd@.

@FileAssoc
$ #Ассоциации файлов#
    FAR2L поддерживает ассоциации файлов, которые позволяют задавать
разнообразные действия для запуска, редактирования и просмотра файлов, заданных
~маской~@FileMasks@.

    Вы можете добавить новые ассоциации с помощью команды #Ассоциации файлов# в
~Меню команд~@CmdMenu@.

    Вы можете задать несколько ассоциаций для одного типа файлов и выбирать
желаемую ассоциацию из меню.

    В списке ассоциаций доступны следующие действия:

    #Ins#        - ~добавить~@FileAssocModify@ новую ассоциацию

    #F4#         - ~изменить~@FileAssocModify@ настройки текущей ассоциации

    #Del#        - удалить текущую ассоциацию

    #Ctrl-Up#    - передвинуть ассоциацию вверх

    #Ctrl-Down#  - передвинуть ассоциацию вниз

    Если для данного файла отсутствуют ассоциированные команды запуска и
установлен параметр #Использовать стандартные типы# в ~Системных параметрах~@SystemSettings@,
то FAR2L пытается использовать ассоциации ОС для запуска этого типа
файлов.

    См. также:
      ~Псевдокоманды~@SpecCmd@.
      клавиатурные команды, общие ~для всех меню~@MenuCmd@.

@FileAssocModify
$ #Настройка ассоциации файлов#
    FAR2L позволяет задать шесть команд, ассоциированных с определённым типом
файла, заданным ~маской~@FileMasks@:

   #Команда запуска по Enter#      Выполняется при нажатии #Enter#

   #Команда запуска по Ctrl-PgDn#  Выполняется при нажатии #Ctrl-PgDn#

   #Команда просмотра#             Выполняется при нажатии #F3#

   #Альтернативная команда#        Выполняется при нажатии #Alt-F3#
   #просмотра#

   #Команда редактирования#        Выполняется при нажатии #F4#

   #Альтернативная команда#        Выполняется при нажатии #Alt-F4#
   #редактирования#

    Ассоциацию можно описать в поле #Описание ассоциации#.

    Если вы не хотите, чтобы перед выполнением ассоциированной команды гасились
панели, начните команду с символа '#@@#'.

    В ассоциированных командах могут использоваться специальные
~метасимволы~@MetaSymbols@.


@MetaSymbols
$ #Метасимволы#
    В ~ассоциированных командах~@FileAssoc@, ~пользовательском меню~@UserMenu@
и команде ~"Применить команду"~@ApplyCmd@ могут использоваться специальные
метасимволы:

    #!!#           символ '!'
    #!#            Имя файла без расширения
    #!`#           Расширение файла без имени (ext)
    #!.!#          Имя файла с расширением
    #!@@!# или #!$!#  Имя файла, содержащего имена помеченных файлов
    #!&#           Список помеченных файлов
    #!/#           Текущий путь
    #!=/#          Текущий путь с учётом ~символических ссылок~@HardSymLink@.

    #!?<title>?<init>!#
             При выполнении команды этот символ заменяется
             данными, введёнными пользователем. <title> и
             <init> - заголовок и исходный текст строки
             редактирования.

             Допускается использование нескольких таких символов
             в одной строке, например:

             grep !?Search for:?! !?In:?*.*!|far2l -v -

             В <title> можно указать имя истории для строки <init>.
             В этом случае команда имеет следующий формат:

             #!?$<history>$<title>?<init>!#

             например:

             grep !?#$GrepHist$#Search for:?! !?In:?*.*!|far2l -v -

             В <title> и <init> допускается использование прочих
             метасимволов, заключив их в круглые операторные скобки,
             например:

             grep !?В (!.!) найти:?! |far2l -v -

    #!###       Префикс "!##", указанный перед символом ассоциации
             файла, заставляет его (и все последующие) ссылаться
             на пассивную панель (см. примечание 4).
             Например, !##!.! обозначает имя текущего файла на
             пассивной панели.

    #!^#       Префикс "!^", указанный перед символом ассоциации
             файла, заставляет его (и все последующие) ссылаться
             на активную панель (см. примечание 4).
             Например, !^!.! обозначает имя текущего файла на
             активной панели, а конструкция !##!/!^!.! - файл на
             пассивной панели с таким же именем, как имя текущего
             файла на активной панели.

  Примечания:

    1. ^<wrap>FAR2L при обработке метасимволов подставляет только то, что они означают
(имя файла, расширение и т.д.). Никаких дополнительных символов (например,
кавычек или фамилий разработчиков FAR2L) не подставляется, и вы должны это сделать
сами, если потребуется. Например, если используемая в ассоциациях программа
требует, чтобы имя файла было в кавычках, то вы должны писать
#program "!.!"#, а не #program !.!#.

    2. ^<wrap>Для ассоциаций !@@! и !$! допускаются следующие модификаторы:

    'Q' - заключать имена с пробелами в кавычки;
    'S' - использовать '/' вместо '\\' в путях файлов;
    'F' - использовать полный путь;
    'A' - использовать кодовую страницу ANSI;
    'U' - использовать кодовую страницу UTF-8;
    'W' - использовать кодовую страницу UTF-16 (Little endian).

    Например, ассоциация #!@@AFQ!# - имя файла, содержащего имена помеченных
файлов с полным путём в кодовой странице ANSI; имена файлов, содержащие пробелы будут
заключены в кавычки.

    3. ^<wrap>Метасимволы !@@! и !$! в меню выбора (когда задано несколько ассоциаций)
показываются как есть, преобразование происходит в момент исполнения команды.

    4. ^<wrap>Префиксы "!##" и "!^" работают как переключатели для ассоциаций.
Действие этих префиксов распространяется до следующего подобного префикса.
Например:

    [ -f !##!/!^!.! ] && diff -c -p !##!/!^!.! !/!.!

    "Если на пассивной панели существует такой же файл, как и на
    активной под курсором, то показать расхождения между файлом
    на пассивной панели и файлом на активной панели, независимо
    от имени текущего файла на пассивной панели"


@SystemSettings
$ #Системные параметры#
  #Разрешить повышение привилегий#
  Если эта опция включена, FAR2L будет запрашивать пароль sudo при попытке доступа к файлам, требующим прав root.

  #Подтверждать все операции записи#
  Если эта опция включена, FAR2L будет запрашивать подтверждение для модифицирующих операций во время работы с повышением привилегий.

  #Удалять в Корзину#
  Разрешает удаление файлов с использованием Корзины (Trash). Операция удаления в
Корзину осуществляется только для локальных жёстких дисков.

  #Удалять символические ссылки#
  Перед удалением каталога в Корзину просканировать и удалить символические ссылки на подкаталоги.

  #Сканировать символические ссылки#
  Обрабатывать ~символические ссылки~@HardSymLink@ наравне с обычными подкаталогами при построении дерева
каталогов и определении суммарного размера файлов в подкаталогах.

  #Учитывать только размер файлов#
  Эта опция определяет, как FAR2L рассчитывает общий размер директории при построении дерева каталогов.
Значение используется во время таких файловых операций, таких как копирование, удаление, быстрый просмотр и т.д.
Включите, чтобы суммировать пространство, занимаемое только файлами. Отключите, чтобы учитывать также накладные
расходы на хранение метаданных самих директорий.

  #Время бездействия#
  Завершает работу FAR2L, если в течение указанного интервала не было нажатий клавиш мыши или клавиатуры,
FAR2L ожидал ввода из командной строки и отсутствовали фоновые экраны редактирования или просмотра.

  #Сохранять историю команд#
  Вызывает сохранение ~истории команд~@History@ перед завершением и её восстановление после запуска FAR2L.
Для просмотра содержимого истории команд нажмите #Alt-F8#.
  Эта опция доступна также в диалоге ~Настройка командной строки~@CmdlineSettings@.
  Действия, заносимые в историю команд, настраиваются в ~Настройка автозавершения и истории~@AutoCompleteSettings@.

  #Сохранять историю папок#
  Вызывает сохранение ~истории папок~@HistoryFolders@ перед завершением и её восстановление после запуска FAR2L.
Для просмотра содержимого истории папок нажмите #Alt-F12#.

  #Сохранять историю просмотра и редактора#
  Вызывает сохранение ~истории просмотра~@HistoryViews@ и редактора перед завершением и её восстановление
после запуска FAR2L. Для просмотра входящих в этот список файлов нажмите #Alt-F11#.

  #Удаление дубликатов в истории#
  Опция задаёт правила обработки списков истории и того, что именно считается дублирующимися записями.
  - никогда: история сохраняется полностью, одинаковые записи не удаляются.
  - по имени: сохраняется хронологически последняя запись (о просмотренном ~файле~@HistoryViews@, посещённой ~директории~@HistoryFolders@
или выполненной ~команде~@History@), а её более ранние вхождения из истории удаляются.
  - по имени и пути: то же, что "по имени", но для списка ~истории команд~@History@ учитывается также рабочая директория,
из которой команда была запущена; то есть, если одна и та же команда была запущена из двух разных директорий,
в истории сохранятся обе записи.

  #Автоподсветка в списках истории#
  Разрешить FAR2L автоматически назначать однокнопочные горячие клавиши для элементов в
~Истории команд~@History@, ~Истории папок~@HistoryFolders@ и ~Истории просмотра~@HistoryViews@.
Это может быть удобно, но также существует риск случайного выбора из-за непреднамеренных нажатий
в связи с динамической природой подобных списков. 
  Если вы не используете эту функцию или чувствуете себя некомфортно с ней, вы можете её отключить.

  #Автозапись конфигурации#
  Если эта опция включена, FAR2L будет автоматически сохранять конфигурацию.
Также будут сохраняться текущие папки обеих панелей.

@PanelSettings
$ #Настройка панели#
  #Показывать скрытые#      Разрешает показ файлов с атрибутами
  #и системные файлы#       Скрытый и Системный. Этот режим также
                          может быть переключён с помощью #Ctrl-H#.

  #Раскраска файлов#        Разрешает ~раскраску файлов~@Highlight@

  #Раскраска файлов#        Кнопка для открытия диалога
  # - Маркировка#           (работает только, если #Раскраска файлов# включена)
                          для настройки показа/выравнивания маркеров на панели
                          (также могут быть переключены из панели по
                          #Ctrl-Alt-N# и #Ctrl-Alt-M#).

  #Каталоги и симлинки#     Кнопка для открытия диалога, который
  #в колонке Размер#        также может быть открыт из панели по #Ctrl-Alt-D#.


  #Автосмена папки#         Если эта опция включена, то передвижения
                          курсора по ~дереву папок~@TreePanel@ будут вызывать
                          смену папки в другой панели. Если эта опция
                          выключена, то для смены папки из дерева
                          папок вы должны нажать #Enter#.

  #Пометка папок#           Разрешает пометку папок с использованием
                          #Gray +# и #Gray *#. В противном случае эти
                          команды работают только с файлами.

  #Учитывать регистр при#   Влияет на ~Сравнение папок~@CompFolders@
  #сравнении или пометке#   и ~Пометку файлов~@SelectFiles@.

  #Сортировать имена#       Применять режим сортировки по расширению
  #папок по расширению#     не только к файлам, но и к папкам. При
                          включённой опции сортировка по расширению
                          работает так же, как и в FAR2L 1.65.
                          Если опция выключена, то в режиме
                          сортировки по расширению папки будут
                          сортироваться так же как в режиме
                          сортировки по имени.

  #Разрешить обратную#      Если эта опция включена, и текущий режим
  #сортировку#              сортировки файловой панели выбран повторно,
                          то будет установлен режим обратной
                          сортировки.

  #Отключать#               Механизм автоматического обновления панели
  #автообновление#          при изменении состояния файловой системы
  #панелей...#              будет отключаться, если количество файловых
                          объектов превысит заданное значение.

    Значение параметра, равное нулю, соответствует состоянию "автоматическое
    обновление включено всегда". Для принудительного обновления панели
    используйте #Ctrl-R#.

  #Автообновление#          Опция включает механизм автоматического
  #сетевых дисков#          обновления панели при изменении состояния
                          файловой системы на сетевых дисках.
                          Отключение этой опции полезно на медленных
                          сетевых подключениях.

  #Классическое разрешение# Раскрывать ~символические~@HardSymLink@ ссылки при
  #ссылок по хоткеям#       использовании некоторых клавиатурных комбинаций,
                          см. подробнее: ~Команды управления панелями~@PanelCmd@
                          и ~Командная строка~@CmdLineCmd@.

  #Показывать заголовки#    Разрешает показ заголовков колонок
  #колонок#                 ~панели файлов~@FilePanel@.

  #Показывать строку#       Разрешает показ строки статуса
  #статуса#                 в панели файлов.

  #Показывать суммарную#    Разрешает показ суммарной информации
  #информацию#              в нижней строке панели файлов.

  #Показывать свободное#    Разрешает показ свободного места
  #место#                   на текущем диске.

  #Показывать полосу#       Разрешает показ полосы прокрутки в панели
  #прокрутки в панелях#     файлов и ~панели дерева папок~@TreePanel@.

  #Показывать количество#   Разрешает показ количества ~фоновых экранов~@ScrSwitch@.
  #фоновых экранов#

  #Показывать букву#        Показывать текущий режим сортировки
  #режима сортировки#       в верхнем левом углу панели.

@InputSettings
$ #Настройка ввода#
  #Мышь#
  Использовать мышь.

  #Правила транслитерации:#
  Выберите здесь правила транслитерации, которые соответствуют вашей обычной раскладке клавиатуры.
Доступные правила загружаются из файла #xlats.ini#, который определяет соответствие между латинскими
и не латинскими кнопка клавиатуры, что затем используется в #быстром поиске файла по Alt+ФАЙЛ#,
#горячих клавишах в диалоговой навигации# и некоторой внутренней функциональности.

  #Эксклюзивная обработка нажатий#
  Эта опция позволяет выбрать управляющие кнопки, использование которых в
комбинации кнопкосочетания будет заставлять FAR2L эксклюзивно захватывать
клавиатурный ввод, предотвращая таким образом перехват таких сочетаний другими
приложениями. Учтите, что данная опция работает только в GUI режиме под X11
(не работает под Wayland / xWayland).

@InterfSettings
$ #Настройка интерфейса#
  #Часы в панелях#
  Показывать часы в верхнем правом углу экрана.

  #Часы при редактировании и просмотре#
  Показывать часы при редактировании и просмотре файлов.

  #Показывать линейку клавиш#
  Показывать назначения функциональных клавиш в нижней строке экрана.
Эта опция также может переключаться по #Ctrl-B#.

  #Всегда показывать меню#
  Показывать меню вверху экрана, даже когда оно неактивно.

  #Сохранение экрана#
  Запуск программы сохранения экрана после заданного в минутах интервала
бездействия. Хранитель экрана также включается, если подвести указатель
мыши в правый верхний угол окна FAR2L (при выбранной опции).

  #Показывать общий индикатор копирования#
  Показывать общий индикатор во время выполнения операции копирования.
Это может потребовать дополнительного времени перед началом копирования
для подсчёта общего размера файлов.

  #Показывать информацию о времени копирования#
  Выводить информации о средней скорости копирования, времени копирования и
примерном времени до конца операции в диалоге копирования.
  Так как эта функция требует времени для сбора статистики, то на
небольших файлах при выключенном "общем индикаторе копирования"
вы можете ничего не увидеть.

  #Показывать общий индикатор удаления#
  Показывать общий индикатор во время выполнения операции удаления.
Это может потребовать дополнительного времени перед началом удаления
для подсчёта общего количества файлов и папок.

  #Использовать Ctrl+PgUp для меню перехода#
  Комбинация клавиш #Ctrl-PgUp# в корневой папке вызовет ~Меню перехода~@DriveDlg@.

  #Формат даты и времени#
  Здесь вы можете выбрать порядок отображения дня, месяца и года, а также задать
разделители для даты и времени в соответствии с вашими предпочтениями.
  Кнопка "Сброс по умолчанию" возвращает настройки к стандартным значениям,
предлагаемым far2l.
  Кнопка "Сброс к текущему" будет полезна, если вы хотите отменить изменения, которые
еще не были подтверждены, и вернуться к текущим настройкам far2l.
  Кнопка "Из системной локали" устанавливает формат даты и времени согласно настройкам
локали вашей операционной системы.

  #Интервал мигания курсора# (*только GUI-бекенд)
  Позволяет уменьшить или увеличить частоту мигания курсора; допустимый диапазон
значений - от 100 до 500 мс.

  #Выбрать шрифт# (*только GUI-бекенд)
  Показывает диалог выбора шрифта, используемого для отображения интерфейса far2l.

  #Отключить сглаживание# (*только GUI-бекенд)
  Отключение алгоритмов сглаживания может несколько ускорить рендеринг, но при этом ухудшить
визуальное восприятие текста.

  #Исп. OSC52 для записи в буфер обмена# (*только TTY-бекенд)
  OSC52 позволяет копировать из far2l, работающего в TTY-режиме (даже через подключение по SSH),
в буфер обмена вашей локальной системы.
  Некоторым терминалам также требуется включение OSC52 в их настройках.
  Если вы используете far2l на удалённой небезопасной системе, предоставление ей доступа на запись
в ваш буфер обмена может быть потенциально небезопасным.
  Примечание: опция отображается, если другие предпочтительные способы доступа к буферу
обмена (TTY|X, TTY|F) недоступны.

  #Исп. свою палитру базовых цветов# (*только TTY-бекенд)

  #Заголовок окна FAR#
  Информация, выводимая в заголовке окна консоли. Может содержать любой текст,
включая следующие переменные:
  - #%State# - текущее состояние FAR2L (ранее было заголовком окна по умолчанию);
  - #%Ver# - версия FAR2L;
  - #%Platform# - архитектура FAR2L;
  - #%Backend# - режим интерфейса FAR2L;
  - #%Host# - имя машины;
  - #%User# - имя пользователя;
  - #%Admin# - слово "Root", если FAR2L запущен от имени администратора, иначе пустая строка.


@DialogSettings
$ #Настройка диалогов#
  #История в строках#       Сохранять историю в строках ввода
  #ввода диалогов#          некоторых диалогов FAR2L. Список ранее
                          введённых строк может быть вызван с помощью
                          мыши или #Ctrl-Up# и #Ctrl-Down#. Если вы
                          не хотите вести такую историю, например,
                          по соображениям безопасности, выключите
                          эту опцию.

  #Постоянные блоки#        Не снимать выделение при перемещении
  #в строках ввода#         курсора в строках ввода.

  #Del удаляет блоки#       Клавиша Del удаляет выделенный блок
  #в строках ввода#         в строках ввода.

  #Автозавершение#          Разрешает использование функции
  #в строках ввода#         автозавершения в строках ввода, имеющих
                          историю или в комбинированных списках.
                          При отключённой опции для автозавершения
                          строк можно воспользоваться комбинацией
                          клавиш #Ctrl-End#. Операция автозавершения
                          не работает во время записи и исполнения
                          макроса.


  #Backspace удаляет#       Если опция включена, то нажатие клавиши
  #неизменённый текст#      BackSpace в неизменённой текстовой
                          строке удаляет всю строку, как если бы
                          нажали клавишу #Del#.

  #Клик мыши вне диалога#   Щелчок левой или правой клавишей мыши
  #закрывает диалог#        за пределами диалога закрывает диалог
                          (подробнее см. ~Прочие команды~@MiscCmd@).
                          Эта опция позволяет отключать указанную
                          функциональность.

  #Показывать символы » «#  Когда текст в поле ввода слишком длинный,
  #при переполнении текста# чтобы уместиться целиком, на краях поля
                          появляются маркеры » «, указывающие на
                          скрытое содержимое. Этот параметр позволяет
                          включить или отключить показ этих маркеров.

   См. также список ~макроклавиш~@KeyMacroDialogList@, доступных в диалогах.

@VMenuSettings
$ #Настройка меню#
  #Клик левой/правой/средней кнопки мыши вне меню#
  Вы можете выбрать действие кнопок мыши при клике вне поля меню:
  #Закрыть с отменой#, #Выполнить текущий пункт# или #Ничего не делать#.

  #Прокрутка списка по кругу#
  Включите эту опцию для циклической прокрутки вертикальных меню при удержании
клавиш стрелок. Достигнув верхнего или нижнего элемента, курсор автоматически
перескочит на противоположный конец списка.


@CmdlineSettings
$ #Настройка командной строки#
  #Сохранять историю команд#
  Вызывает сохранение ~истории команд~@History@ перед завершением и её восстановление после запуска FAR2L.
  Эта опция доступна также в диалоге ~Системные параметры~@SystemSettings@.
  Действия, заносимые в историю команд, настраиваются в ~Настройка автозавершения и истории~@AutoCompleteSettings@.
  
  #Постоянные блоки#
  Не снимать выделение при перемещении в командной строке.

  #Del удаляет блоки#
  Клавиша Del удаляет выделенный блок в командной строке.

  #Автозавершение#
  Разрешает использование функции автозавершения в командной строке.
  При отключённой опции для автозавершения можно воспользоваться комбинацией
клавиш #Ctrl-Shift-End#. Операция автозавершения не работает во время записи и
исполнения макроса.

  #Разделитель вывода команд#
  Включает отображение разделительных линий между выводом команд во встроенном ~терминале~@Terminal@.
  При успешном выполнении команды выводится зелёная линия из символов "-", а при ошибке —
жёлтая линия из символов "~~". Это делает вывод более структурированным и помогает быстрее
оценивать результаты выполнения команд.

  #Ожидать нажатие перед закрытием#
  Ждать нажатия любой клавиши после выполнения команды во встроенном ~терминале~@Terminal@ перед
показом панелей. Допустимые значения: Никогда/При ошибке/Всегда.

  #Установить формат командной строки#
  Эта опция позволяет изменить ~формат приглашения~@CommandPrompt@ командной строки.

  #Использовать шелл#
  Принудительно использовать указанную командную оболочку во встроенном ~терминале~@Terminal@.
  Если оболочка не задана, far2l попытается использовать системную (#$SHELL#). Если системная оболочка
не соответствует внутренним критериям far2l, то будет использоваться #bash#.
  Узнать текущую командную оболочку far2l можно с помощью ~псевдокоманды~@SpecCmd@ #far:about#.
  Обратите внимание, что на данный момент полноценная поддержка обеспечена только для #bash#,
работа с другими командными оболочками может происходить со значительными ограничениями или
ошибками.

@AutoCompleteSettings
$ #Настройка автозавершения и истории#
  #Показывать список#
  Показывать список с предложениями автозавершения.

  #Модальный режим#
  в режиме #[x] Модальный режим# выбранное в списке попадает в командную строку после #Enter#,
  в режиме #[ ] Модальный режим# текущий элемент списка сразу отображается в командной строке.

  #Подставлять первый подходящий вариант#
  Первый подходящий вариант сразу дополняет введенное в командной строке.

  #Шаблоны исключений# также влияют на сохранение команд в ~истории команд~@History@ far2l.
  Например, добавление #" *"# (обязательно в кавычках) исключает из запоминания в историю
  команд начинающихся с пробела (аналогично bash настройке #$HISTCONTROL=ignorespace#).
  Info: в far2l история работает как bash #$HISTCONTROL#
   с опциями #ignoredups# (не сохранять дубликаты подряд)
   и #erasedups# (вообще удалять дубликаты из истории).

  Действия, заносимые в ~истории команд~@History@:
    - Панели: файлы по системным типам (xdg-open);
    - Панели: файлы по ~ассоциациям типов far2l~@FileAssoc@;
    - Панели: исполняемые файлы;
    - Командная строка: любая набранная команда.
  Метод Удаления дубликатов можно выбрать в ~диалоге системных параметров~@SystemSettings@.

@InfoPanelSettings
$ #Настройка информационной панели#


@CommandPrompt
$ #Формат командной строки#
   FAR2L позволяет изменить формат приглашения командной строки.
Для этого в поле ввода #Установить формат командной строки# диалога
~Настроек командной строки~@CmdlineSettings@ необходимо ввести нужную
последовательность переменных и специальных кодов, которая позволит
показать дополнительную информацию в приглашении.

   Допускается использовать переменные окружения и следующие
специальные коды:

     $a - символ &
     $b - символ |
     $c - символ (
     $d - текущая дата (зависит от системных настроек)
     $f - символ )
     $g - символ >
     $h - удалить предыдущий символ
     $l - символ <
     $## - символ ## если FAR2L запущен под root, иначе $
     $p - текущий путь, с возможными сокращениями
     $r - текущий путь, без сокращений
     $u - имя залогиненного пользователя
     $n - имя компьютера
     $q - символ =
     $s - пробел
     $t - текущее время в формате HH:MM:SS
     $z - имя Git бранча окруженное '{' и '} '; или пустая строка, если не удалось получить имя бранча
     $$ - символ $
     $+ - глубина стека каталогов

     $@@xx - ^<wrap>"Администратор", если FAR2L запущен от имени администратора.
Вместо 'xx' необходимо указать два символа, которые будут обрамлять слово "Администратор".

   Примеры.

   1. ^<wrap>Приглашение формата #[$HOSTNAME]$S$P$### будет
содержать имя компьютера, текущий путь, ## или $

   2. ^<wrap>Приглашение формата #[$T$H$H$H]$S$P$G# перед текущем путём
выведет время в формате HH:MM

   3. ^<wrap>Код "$+" отображает нужное число знаков плюс (+) в зависимости
от текущей глубины стека каталогов ~PUSHD~@OSCommands@, по одному знаку на
каждый сохранённый путь.

@Viewer
$ #Программа просмотра: клавиши управления#
   Команды программы просмотра

    #Left#               Символ влево
    #Right#              Символ вправо
    #Up#                 Строку вверх
    #Down#               Строку вниз
    #Ctrl-Left#          20 символов влево
                       В 16-ричном режиме - на 1 позицию влево
    #Ctrl-Right#         20 символов вправо
                       В 16-ричном режиме - на 1 позицию вправо
    #PgUp#               Страницу вверх
    #PgDn#               Страницу вниз
    #Alt+PgUp#           Страницу вверх с увеличением скорости
    #Alt+PgDn#           Страницу вниз с увеличением скорости
    #Ctrl-Shift-Left#    В начало строк на экране
    #Ctrl-Shift-Right#   В конец строк на экране
    #Home, Ctrl-Home#    В начало файла
    #End, Ctrl-End#      В конец файла
    #Shift-Left/Right#   Увеличить существующее выделение влево/вправо

    #F1#                 Помощь
    #F2#                 Перенос строк (включён, выключен)
    #Shift-F2#           Вид переноса строк (по буквам, по словам)
    #F4#                 Переключить текстовый/16-ричный режим
     (16-ричный режим не поддерживает UTF-8 и прочие многобайтовые кодировки
      и переключает просмотр в однобайтовую кодовую страницу)
    #F5#                 Переключить сырой/обработанный режим
    #Alt-F5#             Печать файла (используется плагин
                       "Print Manager").
    #F6#                 Переключиться в ~редактор~@Editor@
    #F7#                 ~Поиск~@ViewerSearch@
    #Shift-F7, Space#    Продолжить поиск
    #Alt-F7#             Продолжить поиск в обратном направлении
    #Ctrl-F7#            ~Grep фильтр~@GrepFilter@
    #F8#                 Переключение UTF8/~ANSI/OEM~@CodePagesSet@ кодовой страницы
    #Shift-F8#           Выбор кодовой страницы
    #Alt-F8#             ~Изменить текущую позицию~@ViewerGotoPos@
    #Alt-F9#             Изменение размеров окна FAR2L
    #F9,Alt-Shift-F9#    Вызов диалога ~настройки программы просмотра~@ViewerSettings@
    #NumPad5,F3,F10,Esc# Выход
    #Ctrl-F10#           Позиционировать на текущий файл без выхода.
    #F11#                Вызвать меню "~Команды внешних модулей~@Plugins@"
    #Alt-F11#            Показать ~историю просмотра~@HistoryViews@
    #+#                  Перейти к следующему файлу
    #-#                  Перейти к предыдущему файлу
    #Ctrl-O#             Показать пользовательский экран
    #Ctrl-Alt-Shift#     Временно показать пользовательский экран
                       (работает до тех пор, пока удерживаем эти
                       клавиши)
    #Ctrl-B#             Спрятать/Показать линейку функциональных
                       клавиш
    #Ctrl-Shift-B#       Спрятать/Показать статусную строку
    #Ctrl-S#             Спрятать/Показать полосу прокрутки
    #Alt-BS, Ctrl-Z#     Возврат к предыдущей позиции
    #ПравыйCtrl-0..9#    Установить закладку 0..9 в текущей позиции
    #Ctrl-Shift-0..9#    Установить закладку 0..9 в текущей позиции
    #ЛевыйCtrl-0..9#     Перейти к позиции закладки 0..9

    #Ctrl-Ins, Ctrl-C#   Скопировать выделенный в результате поиска
                       текст в Буфер обмена.
    #Ctrl-U#             Сбросить выделение, полученное в результате
                       поиска.

    См. также список ~макроклавиш~@KeyMacroViewerList@, доступных в программе просмотра.

    Примечания:

    1. Для вызова диалога поиска вы также можете просто
       начать вводить предназначенный для поиска текст.

    2. !! Наследие Windows (не актуально в Linux/*BSD/Mac) !!

       Файл открывается в программе просмотра с разрешением на
       удаление его сторонним процессом. Если произойдёт такое
       удаление, то реально файл будет удалён из каталога только
       после закрытия программы просмотра, при этом он не будет
       доступен для обработки из любого процесса - это свойство
       MS Windows.

       !! Наследие Windows закончилось !!

    3. В текущей версии FAR2L существует ограничение на максимальное
       количество колонок в программе просмотра - их не может быть
       более 2048. Если в файле имеется строка длиной более
       этого числа, то она будет занимать на экране не одну
       строку, а несколько, даже если отключён режим переноса
       строк.

    4. FAR2L ~ищет~@ViewerSearch@ первое вхождение подстроки (#F7#) с начала видимой
       области экрана программы просмотра.

    5. Для автоматического скроллинга просматриваемого
       динамически обновляемого файла необходимо стать в
       конец файла (клавиша End).

    6. Нажатие Alt+PgUp/PgDn плавно увеличивает скорость скроллинга, последующее
       отпускание кнопки Alt при сохранении нажатым PgUp/PgDn продолжит скроллинг
       с выбранной скоростью. Скорость скроллинга сбрасывается в обычное значение
       при отпускании всех кнопок на продолжительное время или нажатии какой-либо иной кнопки.

@GrepFilter
    Здесь пользователь может временно отфильтровать содержимое просматриваемого файла, используя UNIX-овую утилиту #grep#.
    Вы можете указать образец, который должен совпасть (или несколько образцов разделенных #\|# - как в обычном grep),
и/или образец, который будет использован для исключения строк из вывода.
    Возможно также указать #количество строк до/после совпавшей строки#, которые так же будут включены в вывод.
    Также вы можете использовать #регистрозависимое# сравнение и/или учитывать только совпадения, являющиеся
#полными словами#, то есть с символами-разделителями до и после.

@ViewerGotoPos
$ #Программа просмотра: изменить текущую позицию#
    Этот диалог позволяет сменить позицию во встроенной программе просмотра

    Вы можете ввести значение в виде десятичного смещения, процентов, или
шестнадцатеричного значения.

    Также можете указать относительное значение - просто укажите знак + или -
перед числом.

    Шестнадцатеричные значения вводятся в одной из следующих форм:

     #0xNNNN#, #NNNNh#, #$NNNN#

    Десятичное смещение указывается в форме NNNNd.

    Примеры:

      #50%#                     Перейти на середину файла (50%)
      #-10%#                    Идти на 10% назад.
                              Если у вас было 50%, станет 40%
      #0x100#                   Идти на смещение 0x100 (256)
      #+0x300#                  Идти на 0x300 (768) байтов вперёд

    Если вы явно указали знак процента "%", или форму шестнадцатеричного
числа ('0x', 'h', '$'), или форму десятичного числа ('d') то отмеченные
радио-кнопки игнорируются.

@ViewerSearch
$ #Программа просмотра: поиск#
    Для поиска в ~программе просмотра~@Viewer@ вам доступны следующие режимы и
опции:

    #Искать текст#

      Поиск произвольного теста, набранного в строке #Искать#.
      В этом режиме доступны следующие опции:

        #Учитывать регистр#    - ^<wrap>при поиске будет учитываться регистр введённых символов.

        #Только целые слова#   - ^<wrap>при поиске будет произведён поиск только целого слова.

        #Регулярные выражения# - ^<wrap>рассматривать строку поиска, как ~регулярное выражение~@RegExp@.

    #Искать 16-ричный код#

      ^<wrap>Поиск фрагмента, соответствующего шестнадцатеричным кодам, набранного в строке #Искать#.

    #Обратный поиск#

      Изменить поиск на обратный - искать от конца файла к началу.


@Editor
$ #Редактор#
    Для редактирования выделенного курсором файла следует нажать #F4#. Может
использоваться как встроенный редактор, так и любой иной указанный
пользователем, выбор редактора осуществляется в меню
~Настройки редактора~@EditorSettings@.

    #Создание файлов с помощью редактора#

    Если после нажатия комбинации клавиш #Shift-F4# ввести имя файла, не
имеющегося на диске, то при этом будет создан новый файл.

    Примечания:

    1. ^<wrap>Если при открытии нового файла вы указали имя несуществующей папки, то
появится предупреждение: "~Путь к редактируемому файлу не существует~@WarnEditorPath@".

    2. ^<wrap>При попытке повторного открытия на редактирование файла, FAR2L выдаст
предупреждение: "~Повторное открытие файла~@EditorReload@".

    3. ^<wrap>Кодовую страницу, используемую при создании нового файла можно выбрать в меню
~Настройки редактора~@EditorSettings@.

    #Клавиши управления#

    Команды управления курсором

   #Left#                    Символ влево
   #Ctrl-S#                  ^<wrap>Символ влево, но курсор не будет переходить на предыдущую строку при достижении начала строки
   #Right#                   Символ вправо
   #Up#                      Строку вверх
   #Down#                    Строку вниз
   #Ctrl-Left#               Слово влево
   #Ctrl-Right#              Слово вправо
   #Ctrl-Up#                 Прокрутка экрана вверх
   #Ctrl-Down#               Прокрутка экрана вниз
   #PgUp#                    Страницу вверх
   #PgDn#                    Страницу вниз
   #Home#                    В начало строки
   #End#                     В конец строки
   #Ctrl-Home, Ctrl-PgUp#    В начало файла
   #Ctrl-End, Ctrl-PgDn#     В конец файла
   #Ctrl-N#                  В начало экрана
   #Ctrl-E#                  В конец экрана

  Удаление

   #Del#                     ^<wrap>Удалить символ (также может удалить блок, в зависимости от ~Настроек редактора~@EditorSettings@)
   #BS#                      Удалить символ слева
   #Ctrl-Y#                  Удалить строку
   #Ctrl-K, Alt-D#           Удалить до конца строки
   #Ctrl-BS#                 Удалить слово слева
   #Ctrl-T, Ctrl-Del#        Удалить слово справа

  Операции над блоками

   #Shift-Клавиши курсора#   Пометка блока
   #Ctrl-Shift-Клав.курсора# Пометка блока по словам
   #Alt-Клав.курсора#        Пометка вертикального блока
   #Alt-Shift-Клав.курсора#  Пометка вертикального блока (стрелки с NumLock)
   #Ctrl-A#                  Пометить весь текст
   #Ctrl-U#                  Снять пометку с блока
   #Shift-Ins, Ctrl-V#       Скопировать блок из Буфера Обмена
   #Shift-Del, Ctrl-X#       Переместить блок в Буфер Обмена
   #Ctrl-Ins, Ctrl-C#        Скопировать блок в Буфер Обмена
   #Ctrl-<Gray +>#           Добавить блок в Буфер Обмена
   #Ctrl-D#                  Удалить блок
   #Ctrl-P#                  ^<wrap>Копировать блок в текущую позицию курсора (только в режиме постоянных блоков, Буфер Обмена не изменяется)
   #Ctrl-M#                  ^<wrap>Перенести блок в текущую позицию курсора (только в режиме постоянных блоков, Буфер Обмена не изменяется)
   #Alt-U#                   Сдвинуть блок влево
   #Alt-I#                   Сдвинуть блок вправо
   #Shift-Tab#               Сдвинуть блок влево на Tab или на indent size (обрабатывается плагином SimpleIndent)
   #Tab#                     Сдвинуть блок вправо на Tab или на indent size (обрабатывается плагином SimpleIndent)

  Прочие операции

   #F1#                      Помощь
   #F2#                      Сохранить файл
   #Shift-F2#                ~Сохранить файл как...~@FileSaveAs@
   #Shift-F4#                Редактировать ~новый файл~@FileOpenCreate@
   #F5#                      Переключить отображение пробельных символов
   #Shift-F5#                Изменить ширину символа Tab
   #Ctrl-F5#                 Переключить преобразование Tab-ов в пробелы
   #Alt-F5#                  ^<wrap>Печать файла/выделенного блока (используется плагин "Print Manager").
   #F6#                      Переключиться в ~программу просмотра~@Viewer@
   #F7#                      ~Поиск~@EditorSearch@
   #Ctrl-F7#                 ~Замена~@EditorSearch@
   #Shift-F7#                Продолжить поиск/замену
   #Alt-F7#                  Продолжить поиск/замену в обратном направлении
   #F8#                      Переключение UTF8/~ANSI/OEM~@CodePagesSet@ кодовой страницы
   #Shift-F8#                Выбор кодовой страницы
   #Alt-F8#                  ~Перейти~@EditorGotoPos@ на указанную строку и позицию
   #Alt-F9#                  Изменение размеров окна FAR2L
   #F9,Alt-Shift-F9#         Вызов диалога ~настроек редактора~@EditorSettings@
   #F10, F4, Esc#            Выход
   #Shift-F10#               Сохранение и выход
   #Ctrl-F10#                ^<wrap>Позиционировать на текущий файл без выхода.
   #F11#                     Вызвать меню "~Команды внешних модулей~@Plugins@"
   #Alt-F11#                 Показать ~историю редактирования~@HistoryViews@
   #Alt-BS, Ctrl-Z#          Отмена действия (Undo)
   #Ctrl-Shift-Z#            Повтор действия (Redo)
   #Ctrl-L#                  ^<wrap>Запретить модификацию редактируемого текста
   #Ctrl-O#                  Показать пользовательский экран
   #Ctrl-Alt-Shift#          ^<wrap>Временно показать пользовательский экран (работает до тех пор, пока удерживаем эти клавиши)
   #Ctrl-Q#                  ^<wrap>Рассматривать следующую комбинацию клавиш как код символа
   #ПравыйCtrl-0..9#         Установить закладку 0..9 в текущей позиции
   #Ctrl-Shift-0..9#         Установить закладку 0..9 в текущей позиции
   #ЛевыйCtrl-0..9#          Перейти к позиции закладки 0..9
   #Shift-Enter#             ^<wrap>Вставить в позицию курсора имя текущего файла на панели.
   #Ctrl-Shift-Enter#        ^<wrap>Вставить в позицию курсора имя текущего файла на пассивной панели.
   #Ctrl-F#                  ^<wrap>Вставить в позицию курсора полное имя редактируемого файла.
   #Ctrl-B#                  ^<wrap>Спрятать/Показать линейку функциональных клавиш
   #Ctrl-Shift-B#            Спрятать/Показать статусную строку

   См. также список ~макроклавиш~@KeyMacroEditList@, доступных в редакторе.

   Примечания:

   1. #Alt-U#/#Alt-I# сдвигают текущую строку, если блок не выделен.

   2. ^<wrap>Alt-Код символа на дополнительной клавиатуре вставляет в
редактируемую строку символ с указанным кодом (0-65535).

   3. ^<wrap>Если блок не выделен, то #Ctrl-Ins#/#Ctrl-C# помечают текущую
строку как блок и копируют её в Буфер Обмена.

@EditorSearch
$ #Редактор: поиск и замена#
    Для поиска и замены в ~редакторе~@Editor@ вам доступны следующие режимы и опции:

      #Учитывать регистр#    - ^<wrap>при поиске будет учитываться регистр введённых символов.

      #Только целые слова#   - ^<wrap>при поиске будет произведён поиск только целого слова.

      #Обратный поиск#       - ^<wrap>изменить поиск на обратный - искать от конца файла к началу.

      #Регулярные выражения# - ^<wrap>использовать регулярные выражения для ~поиска~@RegExp@ и ~замены~@RegExpRepl@.

    В режиме поиска также доступна опция:

      #Выделять найденное#   - ^<wrap>найденные последовательности будут выделены.


@FileOpenCreate
$ #Редактор: Открыть/создать файл#
    С помощью комбинации #Shift-F4# можно открыть существующий или
создать новый файл.

    Для нового файла кодовая страница выбирается в зависимости от
~настроек редактора~@EditorSettings@. При необходимости из #списка#
можно выбрать другую кодовую страницу.

    Для существующего файла изменять опцию #Кодовая страница:# имеет
смысл тогда, когда при открытии она определилась неправильно.


@FileSaveAs
$ #Редактор: сохранить файл как...#
    Редактируемый файл можно сохранить под другим именем - нажать #Shift-F2# и
указать другое имя, кодовую страницу и формат представления символа перевода
строки.

    Если для сохраняемого файла выбрана одна из кодовых страниц: UTF-8,
UTF-16 (Little endian) или UTF-16 (Big endian), то при включённой опции #Добавить сигнатуру (BOM)#
в начало файла добавляется специальный маркер, позволяющий другим приложениям
однозначно идентифицировать этот файл.

    Вы можете также указать формат представления символа перевода строки:

    #Исходный формат#
    Не изменять символы перевода строк.

    #В формате DOS/Windows (CR LF)#
    В качестве последовательности перевода строк будут
    использоваться два символа - возврат каретки и перевод
    строки (CR LF), принятые в DOS/Windows.

    #В формате UNIX (LF)#
    В качестве последовательности перевода строк будет
    использоваться символ перевода строки (LF), принятый в
    UNIX.

    #В формате MAC (CR)#
    В качестве последовательности перевода строк будет
    использоваться символ возврата каретки (CR), принятый в
    MAC.


@EditorGotoPos
$ #Редактор: перейти на указанную позицию#
    В этом диалоге можно указать #строку# и #колонку# для перехода.

    Вы можете вводить два числа - строку и колонку. Разделитель чисел - одни из
набора символов: "#,.:;#" или пробел.

    Если вы введёте ",Колонка", то редактор перейдёт на указанную колонку в
текущей строке.

    Также есть возможность перехода по процентам. Введите #50%# и вы перейдёте
ровно в середину текста.


@EditorReload
$ #Редактор: повторное открытие файла#
    FAR2L отслеживает все попытки повторного открытия в редакторе уже
редактируемых файлов. Правила повторного открытия следующие:

    1. Если файл не был изменён, то при отключённой опции "Повторное открытие
файла в редакторе" в диалоге ~подтверждений~@ConfirmDlg@ происходит переход к
редактированию текущего файла без дополнительных запросов.

    2. Если файл был изменён или включена опция "Повторное открытие файла в
редакторе", то существует три варианта действий:

    #Текущий#     - Продолжить редактирование того же файла.

    #Новая копия# - Файл будет открыт для редактирования в новой
                  копии редактора. В этом случае будьте внимательны:
                  содержимое файла на диске будет соответствовать
                  тому, в какой из копий редактора последний раз
                  сохраняли этот файл.

    #Перегрузить# - Текущие изменения не сохраняются, и в редактор
                  загружается прежнее содержимое файла (с момента
                  последнего сохранения).



@WarnEditorPath
$ #Предупреждение: Путь к редактируемому файлу не существует#
    При открытии нового файла в ~редакторе~@Editor@ вы указали имя
несуществующей папки. Перед сохранением файла FAR2L создаст такую папку при
условии, что вами указан корректный путь и что вы имеете достаточно
полномочий на создание папки.


@WarnEditorPluginName
$ #Предупреждение: Имя редактируемого файла не может быть пустым#
    Для создания нового файла на активной панели плагина необходимо указать
имя файла.


@WarnEditorSavedEx
$ #Предупреждение: Файл был изменён внешней программой#
    Дата/время записи или размер редактируемого файла на диске не
совпадают с теми, которые FAR2L запомнил при последнем обращении к этому файлу.
Это означает, что другая программа, другой пользователь (или даже вы сами в
другом окне редактора) изменили содержимое файла на диске.

    Если вы нажмёте "Сохранить", файл будет перезаписан, и все изменения,
внесённые внешней программой, будут утеряны.


@CodePagesMenu
$ #Меню выбора кодовой страницы#
    Это меню позволяет выбрать кодовую страницу редактора или программы просмотра.

    Меню разделено на несколько частей:

    #Автоматическое определение# - определение правильной кодовой страницы;

    #Системные# - основные однобайтные системные кодовые страницы - ~ANSI и OEM~@CodePagesSet@;

    #Юникод# - юникодные кодовые страницы;

    #Избранные# - кодовые страницы, отмеченные пользователем;

    #Прочие# - все остальные установленные в системе кодовые страницы.

    Меню имеет два режима - полный, в котором раздел #Прочие# показывается, и
сокращённый, в котором он скрыт. Переключение режимов осуществляется сочетанием клавиш
#Ctrl-H#.

    Клавиша #Ins# перемещает кодовую страницу из раздела #Прочие# в раздел #Избранные#.
Клавиша #Del# производит обратное действие. Клавиша #F4# позволяет изменять отображаемые
имена для #любимых# и #прочих# кодовых страниц (кодовые страницы, для которых было
изменено имя, помечаются символом #*# перед именем).

    Диалог ~Изменение имени кодовой страницы~@EditCodePageNameDlg@

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.

@CodePagesSet
$ #Определение кодировок ANSI и OEM#
  Переключаемые по #F8# и #Shift-F8# OEM и ANSI кодовые страницы определяются на основе файла
  #~~/.config/far2l/cp# (первая строка - #OEM#, вторая - #ANSI#)
  или, при его отсутствии, по переменной среды #LC_CTYPE#

@EditCodePageNameDlg
$ #Изменение имени кодовой страницы#
    Диалог #Изменение имени кодовой страницы# позволяет изменить отображаемое имя для
#любимых# и #прочих# кодовых страниц.

    Примечания:

    - ^<wrap>Если ввести пустое имя кодовой страницы, то после подтверждения ввода
отображаемое имя кодовой страницы примет значение по умолчанию, то есть имя, полученное
от системы.
    - ^<wrap>Так же отображаемое имя кодовой страницы принимает значение по умолчанию
после нажатия кнопки #Сбросить#.

@DriveDlg
$ #Меню перехода#
    Это меню позволяет быстро перейти в другое место ФС, отмонтировать путь или 
открыть новую панель ~подключаемого модуля~@Plugins@.

    Выберите пункт меню с путем директории для смены текущей директории
или пункт с названием модуля, чтобы создать новую панель модуля. Если панель не
является ~панелью файлов~@FilePanel@, её тип будет изменён на панель файлов.

    Клавиша #F4# позволяет назначить горячую клавишу для подключаемого модуля.

    Клавиша #Del# может использоваться для:

    - ~отмонтирования~@DisconnectDrive@ файловой системы по заданному пути.

    - удаления закладки.

    Комбинация #Shift-Del# используется для безусловного отмонтирования и 
запрашивает привилегии суперпользователя.

    #F9# показывает ~диалог для настройки отображения этой информации~@ChangeLocationConfig@.

    Настройки меню перехода сохраняются в конфигурации FAR2L.

    При включённой опции "~Использовать Ctrl-PgUp для выбора диска~@InterfSettings@",
комбинация клавиш #Ctrl-PgUp# аналогична клавише #Esc# - закрыть меню перехода.

    #Shift-Enter# вызывает системный графический файловый проводник
с показом выбранного пути.

    #Ctrl-R# позволяет обновить меню перехода.

    #Alt-Shift-F9# позволяет ~настроить параметры~@PluginsConfig@ подключаемых внешних
модулей (работает, если включён показ имён подключаемых модулей).

    #Shift-F9# в области подключаемых внешних модулей вызывает диалог настройки
соответствующего модуля.

    #Shift-F1# в области подключаемых внешних модулей показывает соответствующую
модулю контекстно-зависимую подсказку (если у плагина есть файл помощи).

    Вы можете добавить дополнительные фиксированные или динамически определяемые
пункты в меню перехода путем создания текстового файла по данному
пути: #~~/.config/far2l/favorites# этот файл должен содержать строки, каждая из которых
может состоять из одной, двух или трех частей, разделенных символом <TAB>.
Первая часть представляет собой путь для перехода, вторая и третья являются
опциональными и представляют информацию, отображаемую в дополнительных столбцах меню.
Если первая часть будет представлять собой строку с одним лишь символом '-', то
в меню будет добавлен разделитель с опциональным заголовком от последней части.
Заметьте что файл favorites может содержать переменные среды окружения, обозначенные
символом $, например $HOME. Кроме того, поддерживается также стандартная подстановка
команд окружения, например $(/path/to/some/script.sh) запустит скрипт script.sh, и его
вывод будет вставлен в содержимое favorites файла при построении меню. Это позволяет
реализовать дополнительную логику динамического построения списка переходов.

    Если вы не видите смонтированной флешки в меню Перейти (#Alt-F1/F2#),
проверьте #список исключений# в ~Настройках меню перехода~@ChangeLocationConfig@ (#F9#).
Например, по умолчанию туда включен шаблон #/run/*#.
Если у вас udisks2 сконфигурирован монтировать съёмные устройства в папку #/run/media/$USER/#,
вам нужно удалить подстроку #/run/*# из списка исключений.
Затем вы можете добавить более узкие шаблоны, такие как #/run/user/*#,
чтобы спрятать ненужные мусорные точки подключений из меню перехода.

    См. также: Список ~макроклавиш~@KeyMacroDisksList@, доступных в меню перехода.
               Клавиатурные команды, общие ~для всех меню~@MenuCmd@.

@DisconnectDrive
$ #Отмонтирование пути#
    Отмонтировать файловую систему по заданному путю можно из ~Меню перехода~@DriveDlg@
клавишей #Del#.

    Выдачу подтверждения можно отключить в диалоге ~"Подтверждения"~@ConfirmDlg@


@Highlight
$ #Раскраска файлов и группы сортировки#
    Для более удобного и наглядного представления файлов и папок на панелях в
FAR2L предусмотрена возможность цветовыделения файловых объектов.
Файловые объекты можно объединять по разным критериям (~маски файлов~@FileMasks@,
файловые атрибуты) в группы и назначать собственные цвета.

    Раскраску файлов можно включить или отключить в диалоге
~настройки панелей~@PanelSettings@ (пункт "Параметры|Раскраска файлов").

    ~Изменить~@HighlightEdit@ параметры любой группы раскраски можно из меню
"~Параметры~@OptMenu@" (пункт "~Раскраска файлов и группы сортировки~@HighlightList@").


@HighlightList
$ #Раскраска файлов и группы сортировки: клавиши управления#
    Меню ~раскраски файлов и группы сортировки~@Highlight@ позволяет
манипулировать списком. Доступны следующие сочетания клавиш:

  #Пробел#       - (Де)Активировать текущую группу

  #Ins#          - Добавить новую группу раскраски

  #F5#           - Дублировать текущую группу

  #Del#          - Удалить текущую группу

  #Enter# или #F4# - ~Изменить параметры~@HighlightEdit@ текущей группы раскраски

  #F3#           - Показ для текущего элемента масок файлов после раскрытия всех групп масок

  #Ctrl-R#       - Восстановить предопределённые группы раскраски файлов

  #Ctrl-Up#      - Передвинуть группу вверх

  #Ctrl-Down#    - Передвинуть группу вниз

  #Ctrl-M#       - Переключение вида столбца аттрибутов: короткий/длинный

    Группы раскраски анализируются от начала к концу. Если обнаружено, что файл
принадлежит к какой-либо группе, то принадлежность к остальным группам не
проверяется, кроме случая включенного параметра
#[x] Продолжать обработку# в настройках группы
(см. последний индикатор #↓# в списке групп).

    Отображение маркеров управляется глобально галочкой
в диалоге ~Настройки панели~@PanelSettings@
или могут быть переключены через #Ctrl-Alt-M# на панелях.

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.

@HighlightEdit
$ #Раскраска файлов и группы сортировки: редактирование#
    Диалог #Редактирование раскраски файлов# позволяет изменить ~параметры~@Filter@
группы раскраски файлов. Каждое определение группы включает:

     - одну или несколько ~масок файлов~@FileMasks@;

     - атрибуты включения и исключения:
       #[x]# - атрибут включения - файл должен иметь
             указанный атрибут.
       #[ ]# - атрибут исключения - файл не должен иметь
             указанный атрибут.
       #[?]# - указанный атрибут не влияет на фильтр;

     - цвета обычного имени, помеченного имени, имени под курсором
       и помеченного имени под курсором. Если вы хотите использовать
       цвет по умолчанию, установите цвет в "Чёрный на чёрном";

     - опционально может быть указан любой символ для обозначения
       принадлежащих к группе файлов. Он может быть использован
       как вместе с цветовым выделением, так и вместо него.

    Если вы выключите опцию "#Совпадение с маской (масками)#", то маски файлов
будут исключены из анализа, а сравнение будет проводиться только по атрибутам.

    Файл принадлежит к группе раскраски, если:

     - включён анализ масок и его имя соответствует хотя бы
       одной маске (если анализ масок отключён, то имя файла не
       имеет значения);

     - он имеет все атрибуты включения;

     - он не имеет атрибутов исключения.

    Отображение маркеров управляется глобально галочкой
в диалоге ~Настройки панели~@PanelSettings@
или могут быть переключены через #Ctrl-Alt-M# на панелях.

    Атрибуты "Сжатый", "Зашифрованный", "Неиндексируемый", "Разрежённый",
"Временный", "Символическая ссылка", "Автономный" и "Виртуальный" используются
только на дисках с файловой системой NTFS. Атрибут "Виртуальный" не используется
в Windows 2000/XP/2003.


@NotificationsSettings
$ #Настройки уведомлений#

  #Уведомлять о завершении файловой операции#
  Отправлять уведомления на рабочий стол по завершении длительных операций, таких
как копирование, перемещение и поиск файлов.

  #Уведомлять о завершении консольной команды#
  Отправлять уведомление на рабочий стол об успешном выполнении команды во встроенном
~терминале~@Terminal@ или в случае её неудачи.

  #Уведомлять только когда в фоне#
  Отслеживать состояние окна far2l и посылать уведомления на рабочий стол только
тогда, когда оно не активно. Работает как в графической, так и в терминальной
версии far2l.


@ViewerSettings
$ #Настройка программы просмотра#
    В этом диалоге можно изменить параметры внешней и встроенной
~программы просмотра~@Viewer@.

    Внешняя программа просмотра



  #Запускать внешнюю#       Запускать внешнюю программу просмотра
  #программу просмотра#     по #F3# вместо #Alt-F3#.
  #по F3#

  #Команда просмотра#       Команда для запуска внешней программы
                          просмотра. Для указания имени
                          просматриваемого файла используйте
                          ~специальные символы~@MetaSymbols@.
                          Если вы не хотите, чтобы перед запуском
                          программы просмотра гасились панели,
                          начните команду с символа '@@'.

    Встроенная программа просмотра

  #Постоянное выделение#    Не удалять пометку блока при перемещении
                          курсора.

  #Показывать стрелки#      Если текст сдвигается влево, или справа
  #сдвига#                  остаётся текст, то окно просмотра будет
                          показывать сбоку стрелки, показывающие это.

  #Сохранять состояние#     Сохранять и восстанавливать позицию
  #файла#                   в недавно просмотренных файлах.
                          Эта опция также вызывает сохранение
                          кодовой страницы, использованной
                          при просмотре файла, если эта страница
                          была выбрана пользователем вручную,
                          а также режима просмотра файла
                          (шестнадцатеричного или нормального).
                          Отключение этой опции так же вызывает
                          сброс ранее сохраненного состояния
                          просматриваемого файла.

  #Сохранять закладки#      Сохранять и восстанавливать закладки на
                          текущие позиции в недавно просмотренных
                          файлах, сохранённых с использованием
                          #ПравыйCtrl-0..9# или #Ctrl-Shift-0..9#.

  #Размер табуляции#        Количество пробелов при показе символа
                          табуляции.

  #Показывать полосу#       Показывать полосу прокрутки во внутренней
  #прокрутки#               программе просмотра. Также эта опция может
                          переключаться нажатием #Ctrl-S# в окне
                          просмотра.

  #Автоопределение#         ~Автоопределение кодовой страницы~@CodePage@
  #кодовой страницы#        просматриваемого файла.

  #Использовать кодовую#    Использовать кодовую страницу ANSI при
  #страницу ANSI по#        просмотре файлов, иначе - OEM.
  #умолчанию#

    Если внешняя программа просмотра назначена на клавишу #F3#, она будет
запускаться только в том случае, если ~ассоциированная~@FileAssoc@ программа
просмотра для данного типа файлов отсутствует.

    Изменённые настройки не влияют на ранее открытые окна встроенной программы
просмотра.

    Диалог настройки также можно вызвать из ~программы просмотра~@Viewer@,
нажав #Alt-Shift-F9#. Изменения вступят в силу немедленно, но действовать будут
только на текущий сеанс работы.


@EditorSettings
$ #Настройка редактора#
    В этом диалоге можно изменить используемые по умолчанию параметры
внешнего и ~встроенного редакторов~@Editor@.

    Внешний редактор

  #Запускать внешний#       Запускать внешний редактор по #F4# вместо
  #редактор по F4#          #Alt-F4#.

  #Команда#                 Команда для запуска внешнего редактора.
  #редактирования#          Для указания имени просматриваемого файла
                          используйте ~специальные символы~@MetaSymbols@.
                          Если вы не хотите, чтобы перед запуском
                          редактора гасились панели, начните команду
                          с символа '@@'.

    Встроенный редактор

  #Преобразовывать#         (неизменяемо если файл в (под)каталоге
  #табуляцию#               с файлом .editorconfig, содержащим "indent_style")

  - #Не преобразовывать#    При редактировании документа символ #Tab#
    #табуляцию#             не преобразовывать в пробелы.

  - #Преобразовывать новые# При редактировании документа нововведённый
    #символы табуляции в#   символ #Tab# заменять на соответствующее
    #пробелы#               количество пробелов. Остальные символы
                          #Tab# не преобразовывать.

  - #Преобразовывать все#   При открытии документа в редакторе все
    #символы табуляции в#   символы #Tab# заменить на соответствующее
    #пробелы#               количество пробелов.

  #Постоянные блоки#        Не удалять пометку блока при перемещении
                          курсора.

  #Del удаляет блоки#       Если есть помеченный блок, #Del# будет
                          удалять этот блок, а не символ под
                          курсором.

  #Сохранять состояние#     Сохранять и восстанавливать позицию
  #файла#                   в недавно отредактированных файлах.
                          Эта опция также вызывает сохранение
                          кодовой страницы, использованной
                          при редактировании файла, если эта страница
                          была выбрана пользователем вручную и
                          изменения настроек поведения кнопки TAB.
                          Отключение этой опции так же вызывает
                          сброс ранее сохраненного состояния
                          редактируемого файла.

  #Сохранять закладки#      Сохранять и восстанавливать закладки на
                          текущие позиции в недавно просмотренных
                          файлах, сохранённых с использованием
                          #ПравыйCtrl-0..9# или #Ctrl-Shift-0..9#.

  #Автоотступ#              Включает режим автоотступа при вводе
                          текста.

  #Курсор за пределами#     Разрешить перемещение курсора за пределы
  #строки#                  строки.

  #Размер табуляции#        Количество пробелов при показе символа табуляции.
                          (неизменяемо если файл в (под)каталоге
                          с файлом .editorconfig, содержащим "indent_size")

  #Показывать полосу#       Показывать полосу прокрутки
  #прокрутки#

  #Слово под курсором#      При вызове диалога поиска/замены в строку
                          поиска будет подставляться слово, на
                          котором стоит курсор.

  #Использовать файлы#      Использование параметров из файлов .editorconfig
  #настроек .editorconfig#  (см. подробнее на ~https://editorconfig.org~@https://editorconfig.org@)

  #Блокировать#             При открытии на редактирование файла,
  #редактирование#          имеющего атрибут "только для чтения",
  #файла с атрибутом R/O#   редактор также переходит в режим запрета
                          модификации содержимого файла, как если
                          бы нажали #Ctrl-L#.

  #Предупреждать при#       Перед открытием на редактирование файла,
  #открытии файла с#        имеющего атрибут "только для чтения",
  #атрибутом R/O#           будет выдаваться предупреждающее сообщение.

  #Автоопределение#         ~Автоопределение кодовой страницы~@CodePage@
  #кодовой страницы#        редактируемого файла.

  #Выберите кодовую#        Кодовая страница для нового файла,
  #страницу по умолчанию#   обычно UTF-8.
  #умолчанию#

    Если внешний редактор назначен на клавишу #F4#, он будет запускаться только
в том случае, если ~ассоциированный~@FileAssoc@ редактор для данного типа
файлов отсутствует.

    Изменённые настройки не влияют на ранее открытые окна редактора.

    Диалог настройки также можно вызвать из ~редактора~@Editor@, нажав
#Alt-Shift-F9#. Изменения вступят в силу немедленно, но действовать будут
только на текущий сеанс работы.


@CodePage
$ #Автоопределение кодовой страницы#
    FAR2L постарается выбрать правильную кодовую страницу для просмотра/редактирования
файла. Заметьте, что корректное определение не гарантируется, особенно для
маленьких или нетипичных текстовых файлов.

@FileAttrDlg
$ #Атрибуты файлов#
    Эта команда может применяться как к отдельным файлам, так и к группам файлов
и папок, и позволяет просматривать и изменять права доступа, владельцев, временные
метки и некоторые файловые атрибуты.
    Если вам не нужно обрабатывать файлы во вложенных папках, отмените
параметр "Обрабатывать вложенные папки".

    Всего в диалоге 5 секций.

    1. ^<wrap>#Описание#
       ^<wrap>Тип текущего объекта, как его определяет команда #file#.
       ^<wrap>Если текущим объектом является символическая ссылка, то появляется
возможность переключаться между "описанием", значением символической ссылки ("#Ссылка#") и
её разрешённым абсолютным путём ("#Объект#"). Поле "Ссылка" доступно для редактирования.

    2. ^<wrap>#Владение#
       ^<wrap>Позволяет изменять пользователя и/или группу, владеющих выбранными файлами.
Выберите нужные имена из соответствующих выпадающих списков.

    3. ^<wrap>#Права доступа#
       ^<wrap>Позволяет изменять права доступа (чтение/запись/выполнение для 
владельца/группы/остальных) и специальные биты режима (setuid, setgid и sticky)
у выбранных файлов. Для удобства информация представлена и синхронно изменяется ​​в
двух видах записи: символьной и числовой (восьмеричной).

       ^<wrap>Для выделенных объектов (файлов и папок) контрольные переключатели имеют 3
состояния:

       ^<wrap> #[x]# - атрибут установлен для всех объектов
       ^<wrap>       (установить у всех)
       ^<wrap> #[ ]# - атрибут сброшен для всех объектов
       ^<wrap>       (сбросить у всех)
       ^<wrap> #[?]# - атрибут не у всех объектов
       ^<wrap>       (не изменять этот атрибут)

       ^<wrap>Если выделенные объекты имеют одинаковые атрибуты, то контрольные
переключатели будут 2-х позиционными - установить/сбросить. Исключение
составляет случай, когда среди выделенных объектов встречаются папки - в этом
случае все контрольные переключатели будут 3-х позиционными.
       ^<wrap>Если состояние контрольных переключателей на момент исполнения команды
установки атрибутов не изменилось (по сравнению с начальным состоянием), то
указанный атрибут меняться не будет.
       ^<wrap>Если среди выделенных объектов нет папок, то опция "Обрабатывать вложенные
папки" будет недоступна.

    4. ^<wrap>#Атрибуты / Флаги#
       ^<wrap>Позволяет установить или сбросить атрибуты "Неизменяемый", "Дополнение",
а также "Скрытый" (*только macOS и BSD) у выбранного файла.

    5. ^<wrap>#Дата и время#
       ^<wrap>Поддерживаются три различных времени файла:

       ^<wrap> - время последнего доступа (atime);
       ^<wrap> - время последней модификации (mtime);
       ^<wrap> - время изменения статуса (ctime);

       ^<wrap>Если вы не хотите изменять время файла, оставьте соответствующее поле
пустым. Вы можете нажать кнопку #Сброс#, чтобы очистить все поля с
датами и временем, после чего поменять отдельную составляющую даты и времени,
например только месяц или только минуты. Остальные значения полей остаются
неизменными. Кнопка #Текущее# позволяет заполнить поля времени файла текущим
временем. Кнопка #Исходное# заполняет поля времени файла оригинальными
значениями (доступна для одиночного файлового объекта).

       ^<wrap>Обратите внимание, что "время изменения статуса" предназначено только для
просмотра и не может быть изменено.
       ^<wrap>Для дисков с файловой системой FAT часы, минуты и секунды времени
последнего доступа всегда равны нулю.

    #Обратите внимание, что некоторые операции могут требовать прав суперпользователя.#
    Вы должны убедиться, что повышение привилегий разрешено в диалоге 
~Системных параметров~@SystemSettings@, либо far2l должен быть запущен от root.


@Bookmarks
$ #Закладки#
    Закладки позволяют обеспечить быстрый доступ к часто используемым
папкам. Для создания закладки на текущую папку нужно нажать #Ctrl-Shift-0..9#.
После этого, чтобы перейти в папку, записанную в ссылке, достаточно нажать
#ПравыйCtrl-0..9#. Если #ПравыйCtrl-0..9# нажат в строке редактирования, то
путь ссылки будет вставлен в эту строку. Закладки также доступны в меню
перехода.

    Пункт #Закладки# в ~Меню команд~@CmdMenu@ позволяет просматривать,
устанавливать, редактировать и удалять закладки на папки и их кнопкосочетания.

    Вы можете перемещать выделенную закладку вверх и вниз нажатием сочетаний
кнопок #Shift+Вверх# and #Shift+Вниз#.

    В режиме редактирования (#F4#) вы не можете сделать ссылку на плагиновую
панель.

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.

@FiltersMenu
$ #Меню фильтров#
    С помощью #Меню фильтров# вы можете определить набор типов файлов, с
заданным вами параметрами, при соблюдении которых файл будет обработан
использующей его операцией.

    Меню состоит из двух частей. В верхней части расположены #Фильтры#
#пользователя#, в нижней части меню находятся маски всех файлов, содержащихся в
данный момент в текущей панели файлов (а также маски файлов выбранные в
текущей области меню, даже если файлов подходящих к этим маскам нет в текущей
панели).

    Для #Фильтра пользователя# доступны следующие клавиши:

   #Ins#        Создать новый фильтр, откроется пустой диалог для
              задания параметров ~фильтра~@Filter@.

   #F4#         Изменить существующий ~фильтр~@Filter@.

   #F5#         Копировать ~фильтр~@Filter@.

   #Del#        Удалить фильтр.

   #Ctrl-Up#    Переместить фильтр на одну позицию вверх.

   #Ctrl-Down#  Переместить фильтр на одну позицию вниз.


    Управление, как #Фильтрами пользователя#, так и автоматически
сгенерированными фильтрами (маски файлов), осуществляется следующими клавишами:

   #Space#,              Элементы, выбранные с помощью #Space# или '#+#',
   #Plus#                помечаются символом '+'. Если такие элементы
                       присутствуют, то будут обработаны только
                       удовлетворяющие им файлы.

   #Minus#               Элементы, выбранные с помощью клавиши '#-#',
                       помечаются символом '-', и все удовлетворяющие
                       им файлы не будут обработаны.

   #I# и #X#               Подобны #Plus# и #Minus#, но имеют более
                       высокий приоритет при фильтрации.

   #Backspace#           Снять пометку с выбранного объекта.

   #Shift-Backspace#     Снять пометку со всех выбранных объектов.


    Пометка фильтров сохраняется в конфигурации.

    Когда фильтр используется в панели, это индицируется символом '*' после
буквы режима сортировки в верхнем левом углу панели.

    Меню фильтров используется в следующих областях:
     - ~Панель файлов~@FilePanel@;
     - ~Копирование, перенос, переименование и создание ссылок~@CopyFiles@;
     - ~Поиск файла~@FindFile@.

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.

@FileDiz
$ #Описания файлов#
    Описания могут быть использованы для того, чтобы связать с файлом текстовую
информацию. Описания файлов текущей папки хранятся в этой папке в специальном
файле - списке описаний. В нём в начале каждой строки содержится имя
описываемого файла, и отделённый от него пробелами текст описания.

    Описания можно посмотреть в соответствующих ~режимах просмотра~@PanelViewModes@
панели файлов. По умолчанию этими режимами являются #Описания# и #Длинные#
#описания#.

    Команда #Описание файлов# (#Ctrl-Z#) из ~Меню файлов~@FilesMenu@
предназначена для добавления описаний к выбранным файлам.

    Имена списков описаний могут быть изменены в диалоге #Описания файлов# из
меню ~Меню параметров~@OptMenu@. В этом диалоге также можно установить режим
обновления локальных описаний. Обновление может быть запрещено совсем,
разрешено, только если текущий режим просмотра файловой панели показывает
описания, или разрешено всегда. По умолчанию FAR2L устанавливает атрибут "Hidden"
на созданные списки описаний, но вы можете это запретить, выключив опцию
"Устанавливать атрибут "Hidden" на новые списки описаний" в этом же диалоге.
Также здесь вы можете указать позицию для выравнивания новых описаний в списке
описаний.

    Если файл с описаниями имеет атрибут "Только для чтения", то FAR2L не
обновляет описания и, после операций переименования/удаления файловых объектов,
будет выведено сообщение об ошибке. При включённой опции #Обновлять файл#
#описаний с атрибутом "Только для чтения"# FAR2L попытается корректно обновить
описания.

    Если это разрешено в конфигурации, FAR2L обновляет описания файлов при
копировании, переносе и удалении файлов. Но если команда обрабатывает и часть
файлов во вложенных папках, то для этих файлов описания не обновляются.


@PanelViewModes
$ #Настройка режимов просмотра панели файлов#
    ~Панель файлов~@FilePanel@ может выводить информацию, используя 10 заданных
заранее режимов: краткий, средний, полный, широкий, детальный, описания,
длинные описания, владельцы файлов, ссылки файлов, альтернативный полный. Обычно
этого достаточно, но, тем не менее, при желании можно изменить параметры этих
режимов или даже полностью заменить их на новые.

    Команда #Режимы панели файлов# из меню ~Меню параметров~@OptMenu@ позволяет
изменить параметры режимов просмотра. Сначала она предлагает выбрать требуемый
режим из списка. В этом списке режим 0 соответствует режиму просмотра,
вызываемому по #ЛевыйCtrl-0# (альтернативный полный), режим 1 соответствует
краткому режиму (#ЛевыйCtrl-1#), режим 2 соответствует среднему режиму
(#ЛевыйCtrl-2#) и так далее.
    #Enter# or #F4#      - редактирование выбранного режима
    #Ctrl+Enter#       - применить выбранный режим к активной панели
    #Ctrl+Shift+Enter# - применить выбранный режим к пассивной панели

    После выбора режима появляется диалог, в котором
можно изменить следующие параметры:

  - #Типы колонок# - типы колонок кодируются с помощью одной
или нескольких букв, разделённых запятыми. Допускаются следующие
типы колонок:

    N[M,O,R]   - имя файла
                 где: M - показывать символы пометки;
                      O - показывать имена без путей (предназначено
                          в основном для ~подключаемых модулей~@Plugins@);
                      R - выравнивать имена по правому краю;
                 Эти символы можно комбинировать, например NMR

    S[C,T,F,E,A] - размер файла
    P[C,T,F,E,A] - упакованный размер файла
    G[C,T,F,E,A] - размер потоков файла
                   где: C - форматировать размер файла;
                        T - использовать 1000 вместо 1024 как делитель;
                        F - показывать размер файла в стиле Windows
                            Explorer (т.е. 999 байт будут показаны
                            как 999, а 1000 байт как 0.97 K);
                        E - экономичный режим, не показывать пробел
                            перед суффиксом размера файла
                            (т.е. 0.97KB);
                        A - автоматическая ширина по максимальному числу
                            (работает только при 0 в "Ширина колонок");

    D          - дата последней записи в файл
    T          - время последней записи в файл

    DM[B,M]    - дата и время последней записи в файл
    DC[B,M]    - дата и время создания файла
    DA[B,M]    - дата и время последнего доступа к файлу
    DE[B,M]    - дата и время изменения файла
                 где: B - краткий (Unix-стиль) формат времени файла;
                      M - использование текстовых имён месяцев;

    A          - атрибуты файла
    Z          - описание файла

    O[L]       - владелец файла
                 где: L - отображать также имя домена;
    U          - группа файла

    LN         - количество жёстких ссылок

    F          - количество потоков

    Если описание типов колонок содержит более одной колонки имени
файла, панель файлов будет отображаться в многоколоночной форме.

    Windows атрибуты файла имеют следующие обозначения:
       #R#         - Только для чтения
       #S#         - Системный
       #H#         - Скрытый
       #A#         - Архивный
       #L#         - Связь или символическая ссылка
       #C# или #E#   - Сжатый или Зашифрованный
       #$#         - Разрежённый (sparse)
       #T#         - Временный
       #I#         - Неиндексируемый по содержимому
       #O#         - Автономный (offline)
       #V#         - Виртуальный

    Типы файлов Unix:
       #B#         - Битая (устаревшая) символическая ссылка
       #d#         - Каталог
       #c#         - Символьное устройство
       #b#         - Блочное устройство
       #p#         - FIFO (именованный канал)
       #s#         - Сокет
       #l#         - Символическая ссылка
       #-#         - Обычный файл

    Права доступа к файлам Unix (в каждой триаде для владельца, группы, других пользователей):
       #r# или #-#    - доступен для чтения или нет
       #w# или #-#    - доступен для записи или нет
       #x# или #-#    - исполняемый или нет
       #s# или #S#    - setuid/setgid, также исполняемый (#s#), или не исполняемый (#S#)
       #t# или #T#    - sticky, также исполняемый (#t#), или не исполняемый (#T#)

    Порядок отображения атрибутов - RSHALCTIOV. Символ атрибута
"Разрежённый" применяется только для файлов и ставится вместо 'L'.
Символ атрибута "Зашифрованный" ставится вместо 'C', т.к. файл/каталог не
могут иметь одновременно оба атрибута ("Сжатый" и "Зашифрованный"). По
умолчанию размер колонки атрибутов - 6 символов. Для отображения
дополнительных атрибутов 'T', 'I', 'O' и 'V' необходимо явно указать
размер колонки в 10 символов.

  - #Ширина колонок# - позволяет изменить ширину колонок панели.
Если ширина равна 0, то используется значение по умолчанию.
Если ширина колонки с именем, описанием или владельцем равна 0,
она будет подсчитана автоматически, в зависимости от ширины панели.
Для правильной работы с различной шириной экрана настоятельно
рекомендуется, чтобы в каждом режиме просмотра была хотя бы одна
колонка с автоматически вычисляемой шириной.
Ширину колонки также можно задать в процентах от свободного места
оставшегося после колонок с фиксированной шириной, для этого после
числового значения необходимо дописать знак %. Если суммарный размер
таких колонок больше 100%, то их размеры соответственно масштабируются.

    Для использования 12-часового формата времени надо увеличить
на единицу стандартную ширину колонки времени файла или колонки
времени и даты файла. После дальнейшего увеличения в этих колонках
также будут показаны секунды и миллисекунды.

    Для показа года в 4-х символьном формате нужно увеличить ширину
колонки даты на 2.

    При указании колонок, отвечающих за показ ссылок, потоков и владельцев (G, LN, F и O) время
отображения содержимого каталога увеличивается.

  - #Типы колонок строки статуса# и #Ширина колонок строки статуса# -
аналогично "Типам колонок" и "Ширине колонок", но для строки статуса
панели.

  - #Полноэкранный режим# - показывать панель во весь экран вместо
половины экрана.

  - #Выравнивать расширения файлов# - показывать расширения файлов
выровненными.

  - #Выравнивать расширения папок# - показывать расширения папок
выровненными.

  - #Показывать папки заглавными буквами# - показывать все имена папок
в верхнем регистре, вне зависимости от реального регистра.

  - #Показывать файлы строчными буквами# - показывать все имена файлов
в нижнем регистре, вне зависимости от реального регистра.

  - #Показывать имена файлов из заглавных букв строчными буквами# -
показывать все имена файлов, которые содержат только заглавные буквы,
строчными буквами. По умолчанию эта опция включена, но если вы хотите
всегда видеть настоящий регистр имени файла, выключите её, а также
#Показывать папки заглавными буквами# и #Показывать файлы строчными буквами#.
Все эти параметры влияют только на способ показа файлов, для их обработки
FAR2L всегда использует настоящий регистр.

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.

@SortGroups
$ #Группы сортировки#
    Группы сортировки могут применяться в ~панели файлов~@FilePanel@ совместно
с сортировкой #по имени# или #по расширению#. Они активизируются при нажатии
#Shift-F11# и позволяют задать правила сортировки файлов, дополняющие уже
действующие.

    Каждая группа сортировки состоит из одной или нескольких разделённых
запятыми ~масок файлов~@FileMasks@. Если позиция одной группы сортировки в
общем списке групп выше, чем у другой группы, то при сортировке по возрастанию
все принадлежащие к этой группе файлы будут выше, чем принадлежащие к другой
группе.

    Команда #Группы сортировки# из ~Меню команд~@CmdMenu@ позволяет удалять,
создавать и редактировать группы сортировки, используя клавиши #Del#, #Ins# и
#F4#. Группы, находящиеся выше разделителя меню, относятся к началу файловой
панели, и все файлы, попавшие в эти группы, будут расположены выше не попавших
в них файлов. Группы, находящиеся ниже разделителя меню, относятся к концу
файловой панели, и все файлы, попавшие в эти группы, будут расположены ниже не
попавших в них файлов.


@FileMasks
$ #Маски файлов#
    Маски файлов часто используются в командах FAR2L для выбора отдельных файлов
и папок или их групп. Маски могут включать обычные допустимые в именах файлов
символы, '*' и '?', а также специальные выражения:

    #*#           любое количество символов (в т.ч. ни одного);

    #?#           любой символ;

    #[c,x-z]#     любой символ из находящихся в квадратных скобках.
                Допускаются и отдельные символы, и их диапазоны.

    Например, файлы ftp.exe, fc.exe и f.ext могут быть выбраны с помощью маски
f*.ex?, маска *co* выберет и color.ini, и edit.com, маска [c-f,t]*.txt может
выбрать config.txt, demo.txt, faq.txt и tips.txt.

    Во многих командах FAR2L можно задать несколько разделённых запятыми или
точкой с запятой масок. Например, чтобы выбрать все документы, вы можете ввести
*.doc,*.txt,*.wri в команде "Пометить группу".

    Допускается заключать любую из масок (но не весь список) в двойные кавычки.
Например, это нужно делать, когда маска содержит один из символов-разделителей
(запятую или точку с запятой), чтобы такая маска не была спутана со списком.

    В масках можно использовать ~регулярные выражения~@RegExp@, при этом текст
регулярного выражения должен быть окружён символами #/#.

    Пример:
    #/(eng|rus)/i#  файлы, имена которых содержат строки “eng” или “rus”,
                  регистр символов не учитывается.

    В некоторых ситуациях (~поиск~@FindFile@ файлов, ~фильтр~@Filter@,
~меню фильтров~@FiltersMenu@,
~пометка~@SelectFiles@ файлов, ~ассоциации~@FileAssoc@ файлов
и ~раскраска и группы сортировки~@Highlight@ файлов) можно
использовать маски исключения. #Маска исключения# есть одна или несколько масок
файлов, которой не должны соответствовать имена требуемых файлов, она
отделяется от основной маски символом '#|#'.

^Примеры использования масок исключения:
 1. *.cpp
    Все файлы с расширением cpp.
 2. *|*.bak,*.tmp
    Все файлы, кроме файлов с расширением bak и tmp.
 3. *|
    Ошибка - введён спецсимвол |, но сама маска исключения не
    указана.
 4. *|*.bak|*.tmp
    Ошибка - спецсимвол | не может встречаться более одного раза.
 5. |*.bak
    Обрабатывается как *|*.bak
 6. *|/^pict\d{1,3}\.gif$/i
    Все файлы, кроме pict0.gif — pict999.gif, независимо от регистра символов.

    Через запятую (или точку с запятой) перечисляются маски файлов, а при
помощи '|' маски-включения отделяются от масок-исключения.


 Маски файлов могут быть объединены в ~группы~@MaskGroupsSettings@.


@MaskGroupsSettings
$ #Группы масок файлов#
 Произвольное количество ~масок файлов~@FileMasks@ можно объединить в группу и присвоить ей имя.

 В дальнейшем имя группы, заключённое в угловые скобки (#<#имя#>#), может использоваться везде, где используются сами маски.

 Группы могут содержать другие группы.

 Например, группа #<arc># содержит маски "*.rar,*.zip,*.[zj],*.[bg7]z,*.[bg]zip,*.tar".
Для ~раскраски~@Highlight@ всех архивов, кроме "*.rar", необходимо указать последовательность #<arc>|*.rar#.

 Клавиши управление списком.

 #Ctrl+R#      - ^<wrap>восстановить исходное значение для предопределённых групп

 #Ins#         - добавить новую группу

 #Del#         - удалить существующую группу

 #Enter#/#F4#    - изменить параметры группы

 #F3#          - просмотр группы с переносом длинных строк масок

 #F7#          - найти группы, содержащие маску

 См. также: ~Меню параметров~@OptMenu@.


@SelectFiles
$ #Пометка файлов#
    Для обработки файлов и папок ~панели файлов~@FilePanel@, они могут быть
выбраны несколькими различными способами. #Ins# помечает файл под курсором и
перемещает курсор вниз, #Shift-Клавиши курсора# позволяют перемещать курсор в
различных направлениях.

    #Gray +# и #Gray -# выбирают или снимают пометку с группы с использованием
одной или нескольких разделённых запятыми ~масок файлов~@FileMasks@. #Gray *#
инвертирует текущую пометку. Команда #Восстановить пометку# (#Ctrl-M#)
восстанавливает выбранную до этого группу.

    #Ctrl-<Gray +># и #Ctrl-<Gray -># выбирают или снимают пометку со всех
файлов с тем же расширением, что и у файла под курсором.

    #Alt-<Gray +># и #Alt-<Gray -># выбирают или снимают пометку со всех файлов
с тем же именем, что и у файла под курсором.

    #Ctrl-<Gray *># инвертирует текущую пометку, включая папки. Если параметр
#Пометка папок# в диалоге ~Настроек панели~@PanelSettings@ включена, это
работает аналогично #Gray *#.

    #Shift-<Gray +># и #Shift-<Gray -># выбирают или снимают пометку со всех
файлов.

    Если ни один файл не выбран, то будет обработан только файл под курсором.

    См. параметры #Пометка папок# и
#Учитывать регистр при сравнении или пометке# в диалоге
~Настроек панели~@PanelSettings@.


@CopyFiles
$ #Копирование, перенос, переименование и создание ссылок#
    Следующие команды могут быть использованы для копирования, переноса и
переименования файлов и папок:

  Копировать ~выбранные~@SelectFiles@ файлы                                    #F5#

  Копировать файл под курсором вне зависимости            #Shift-F5#
  от пометки

  Переименовать или перенести выбранные файлы                   #F6#

  Переименовать или перенести файл под курсором           #Shift-F6#
  вне зависимости от пометки

    Для папки: если путь, который мы задали (относительный или абсолютный),
соответствует существующей папке, то перемещает в эту папку; иначе изменяет
путь на заданный.
    Например, при перемещении #/folder1/# в #/folder2/#:
  - если #/folder2/# существует, то содержимое #/folder1/# переместится в
#/folder2/folder1/#;
  - в противном случае содержимое #/folder1/# переместится во
вновь созданную папку #/folder2/#.

  Создание ~ссылок~@HardSymLink@ файлов и папок                            #Alt-F6#

    Если включена опция "#Обрабатывать несколько имён файлов#", то в строке
ввода может указываться как одна цель для копирования или перемещения, так и
несколько. В последнем случае цели должны быть разделены символом-разделителем
"#;#" или "#,#". Если цель содержит в своём имени символ ";" (или ","), то эта
цель должна быть взята в кавычки.

    Если опция #Копировать режим доступа к файлам# включена, то копии файлов получат такие же
UNIX режимы доступа как у оригинальных файлов, за исключением битов отфильтрованных umask.

    Если опция #Копировать расширенные атрибуты# включена, то копии файлов получат такие же
расширенные атрибуты как у оригинальных файлов.

    Если опция #Выключить кэширование записи# включена, то копирование будет осуществляться
минуя кэш записи, если файловая система и ОС поддерживают режим O_DIRECT.

    Если опция #Создавать разреженные файлы# включена, то процедура копирования будет
включать в себя поиск заполненных только нулями регионов файлов размером 4КБ и более - на
месте таких регионов результирующие разреженные файлы будут содержать 'дырки'. Это позволяет
сэкономить место и ускорить копирование если файлы содержат большие области нулевых данных.
Потенциальным минусом является повышенная фрагментация файла, если в дальнейшем эти регионы
будут перезаписаны обычными данными.

    Если опция #Использовать копирование-при-записи если возможно# включена, то процедура
копирования будет использовать специальный API ядра, который копирует файлы таким образом,
что скопированный файл указывает на данные оригинального файла. Данные будут фактически
скопированы лишь в случае когда один из файлов будет модифицирован. Учтите, что эта
функциональность требует ядро Linux версии 4.5+ или MacOS v10.12+ и файловую систему,
которая поддерживает такие файлы. В противном случае файлы будут скопированы обычным способом.
В случае использования эта опция значительно ускоряет копирование и экономит место на диске.
Потенциальным минусом является повышенная фрагментация файла, если в дальнейшем этот файл
или же его первоначальная копия будут перезаписаны.

    Выпадающий список #Символические ссылки# предлагает три способа копирования
встреченных символических ссылок:
    - #Всегда копировать ссылку#
    Все символические ссылки копируются "как есть", без какой-либо адаптации к
новому расположению.
    - #Умно копировать ссылку или файл#
    Если ссылка указывает на файл, подлежащий копированию в рамках той же операции,
то при копировании она будет изменена так, чтобы ссылаться на новый экземпляр этого файла.
Иначе под именем ссылки будет скопирован оригинальный файл.
    - #Копировать как файл#
    Все символические ссылки будут преобразованы в обычные файлы, содержащие
точную копию файла, на который они указывают.

    Если вы хотите создать папку назначения перед копированием, добавьте к её
имени обратную черту. Также в диалоге копирования вы можете нажать #F10# для
выбора папки из дерева активной файловой панели или #Alt-F10# для выбора из
дерева пассивной файловой панели. #Shift-F10# позволяет открыть дерево с учётом
пути, содержащегося в строке ввода (если там перечислено несколько путей, то
учитывается только первый из них). Если включена опция "#Обрабатывать несколько#
#имён файлов#", то выбранная папка добавляется к содержимому строки ввода через
точку с запятой.

    Возможность копирования, переноса и переименования файлов для подключаемых
модулей зависит от функциональности конкретного модуля.

    Если файл, в который производится копирование, уже существует, то он может
быть перезаписан, пропущен, либо содержимое копируемого файла может быть
дописано в его конец.

    Если диск, на который производится копирование или перенос файлов, в ходе
операции заполнился, то можно либо отменить операцию, либо заменить диск и
выбрать пункт "Разделить", после чего копируемый файл будет разделён между
дисками.

    Параметр "Уже существующие файлы" определяет поведение FAR2L для случая,
когда одноимённый файл уже существует в папке-приёмнике.
    Возможные значения:
    #Запрос действия# - будет отображён ~диалог~@CopyAskOverwrite@ с запросом;
    #Вместо# - все существующие файлы будут заменены копируемыми;
    #Пропустить# - существующие файлы останутся без изменений;
    #Имя# - существующие файлы останутся без изменений, копируемым будут присвоены другие имена;
    #Дописать# - копируемые файлы будут дописаны в конец существующих;
    #Только новые/обновлённые файлы# - копировать только файлы с более новыми
датой и временем записи. Состояние этой опции не сохраняется на будущие сеансы копирования.
    #Запрос подтверждения для R/O файлов# - определяет, нужно ли дополнительное
подтверждение для файлов с установленным атрибутом "только для чтения".
    Если соответствующий пункт в ~Подтверждениях~@ConfirmDlg@ снят,
то "Уже существующие файлы" недоступен
и молча применяется действие #Вместо#.

    При переносе файлов для определения того, должна ли операция осуществляться
как копирование с последующим удалением или как прямой перенос (в пределах
одного физического диска), FAR2L учитывает ~символические ссылки~@HardSymLink@.

    Для копирования файлов, попадающих под определённые условия, используйте
переключатель #Использовать фильтр#. Настройка условий ~фильтра~@FiltersMenu@
осуществляется кнопкой #Фильтр#. Учтите, что если вы копируете каталог с
файлами, и ни один из них не попадает под условия фильтра, то пустой каталог в
место назначения скопирован не будет.


@CopyAskOverwrite
$ #Копирование: запрос действия#
    Если одноимённый файл уже существует в папке-приёмнике, FAR2L предложит на выбор
несколько возможных действий:

    #Вместо# - существующий файл будет заменён копируемым;

    #Пропустить# - существующий файл останется без изменений;

    #Имя# - существующие файлы останутся без изменений, копируемым будут присвоены другие имена;

    #Дописать# - копируемый файл будет дописан в конец существующего.

    Если отмечен переключатель #Запомнить выбор#, выбранное действие будет
использовано для всех существующих файлов в текущем сеансе копирования
и повторные запросы появляться не будут.

    Если для принятия решения вам недостаточно информации о размере и дате последней
записи файлов, вы также можете сравнить их содержимое при помощи встроенной программы просмотра.


@CopyRule
$ #Копирование: правила#
  При ~копировании/перемещении~@CopyFiles@ папок и
~символических ссылок~@HardSymLink@ соблюдаются следующие правила.


@HardSymLink
$ #Жёсткие ссылки, символические ссылки#

    Можно создавать #жёсткие ссылки# (HardLink) для файлов
(только внутри одного раздела),
и #символические ссылки# (SymLink) для файлов и
папок с помощью команды #Alt-F6#.


    #Жёсткие ссылки#

    Жёсткая ссылка (HardLink) - это просто ещё одна запись в папке для данного
файла.

    Когда создаётся жёсткая ссылка, сам файл не копируется физически, а только
появляется под ещё одним именем или в ещё одном месте, а его старые имя и
местонахождение остаются нетронутыми. С этого момента жёсткая ссылка
#неотличима# от первоначальной записи в папке.

    Когда меняется размер или дата файла, все соответствующие записи в папках
обновляются автоматически. При удалении файла он не удаляется физически до тех
пор, пока все жёсткие ссылки, указывающие на него, не будут удалены. Порядок их
удаления значения не имеет. При удалении жёсткой ссылки в корзину количество
ссылок у файла сохраняется.

    FAR2L умеет создавать жёсткие ссылки, отображать их количество для каждого
файла в отдельной колонке (по умолчанию это последняя колонка в 9-м режиме
панелей), а также сортировать файлы по количеству жёстких ссылок.

    Создавать жёсткие ссылки можно только на том же разделе, на котором расположен
исходный файл.


    #Символические ссылки#

    Символические ссылки (SymLink) [на NTFS поддерживаются, начиная с Windows Vista
(NT 6.0)] могут указывать как на папки, так и на файлы, как на локальные, так и на сетевые,
при этом поддерживаются относительные пути.


    #Предлагаемое по умолчанию# в поле #Тип ссылки# можно изменить в ~Системных параметрах~@SystemSettings@ на
    - Жёсткая для файлов, Символическая для каталогов
    - Символическая всегда

@ErrCopyItSelf
$ #Ошибка: копирование/перенос "в самого себя"#
    Вы не можете копировать/переносить файл или папку "в самого себя".

    Данная ошибка также возникает, если имеются две папки, одна из которых
является ~символической ссылкой~@HardSymLink@ на другую.


@ErrLoadPlugin
$ #Ошибка: плагин не загружен#
    Эта ошибка появляется в случаях, когда:

    1. Для нормальной работы модуля требуется динамическая
       библиотека, которая отсутствует в вашей системе.

    2. Модуль по какой-то причине вернул системе информацию о
       недопустимости дальнейшей загрузки.

    3. Модуль плагина испорчен.


@ScrSwitch
$ #Переключение между экранами#
    FAR2L позволяет открыть несколько копий встроенной программы просмотра и
редактора. Используйте #Ctrl-Tab#, #Ctrl-Shift-Tab# или #F12# для переключения
между панелями и экранами с этими копиями. #Ctrl-Tab# переключает на следующий
экран, #Ctrl-Shift-Tab# на предыдущий, #F12# выводит список всех доступных
экранов.

    Так же несколько команд терминала могут исполняться в фоне. Вы можете
посмотреть или активировать любую из них через меню, появляющееся по #F12#:
используйте #F3# для предварительного просмотра исполнения команды или Enter
чтобы переключиться на нее в терминале.

    Количество фоновых команд терминала, экранов редактирования и просмотра
отображается в верхнем левом углу левой панели. Вы можете запретить показ
количества экранов, используя диалог ~Настройки панели~@PanelSettings@.

    См. также: клавиатурные команды, общие ~для всех меню~@MenuCmd@.

@ApplyCmd
$ #Применить команду#
    Используя пункт #Применить команду# из ~Меню файлов~@FilesMenu@,
можно применить команду к каждому помеченному файлу. Для обозначения
имени файла должны использоваться те же ~символы~@MetaSymbols@, что
и в ~Ассоциациях файлов~@FileAssoc@.

    Например, 'cat !.!' будет выводить на экран все помеченные файлы по
очереди, а команда 'tar --remove-files -cvjf !.!.tar.bz2 !.!' перенесёт все отмеченные файлы в
одноимённые TAR/BZIP2-архивы.

    См. также: ~псевдокоманды~@SpecCmd@
               ~команды операционной системы~@OSCommands@


@OSCommands
$ #Команды операционной системы#
    FAR2L самостоятельно обрабатывает следующие команды операционной
системы:

    #reset#

    Очищает экран встроенного ~терминала~@Terminal@.

    #pushd path#

    Команда pushd сохраняет текущий каталог во внутреннем стеке и делает
текущим каталог path.

    #popd#

    Переходит в каталог, сохранённый командой pushd.

    #exit#

    Завершение фоновой оболочки встроенного ~терминала~@Terminal@.

    Примечания:

    1. ^<wrap>Если синтаксис команд отличается от указанных, то
FAR2L передаёт управление командному процессору
операционной системы.

    2. Перечисленные команды работают в:
       - ~Командной строке~@CmdLineCmd@
       - ~Применить команду~@ApplyCmd@
       - ~Меню пользователя~@UserMenu@
       - ~Ассоциациях файлов~@FileAssoc@

    См. также: ~псевдокоманды~@SpecCmd@


@FAREnv
$ #Переменные среды#
    После запуска FAR2L выставляет следующие переменные среды, доступные
дочерним процессам:

    #FARHOME#            каталог с ресурсами far2l (например, /usr/share/far2l).

    #FARLANG#            название текущего языка интерфейса

    #FARSETTINGS#        ^<wrap>имя пользователя, указанное в параметре -u ~командной строки~@CmdLine@

    #FARADMINMODE#       ^<wrap>равна "1", если FAR2L запущен от имени администратора (т.е. если его
эффективный идентификатор пользователя равен 0)

    #FARPID#             идентификатор процесса FAR2L

    См. также раздел ~FAR2L: параметры командной строки~@CmdLine@ о переменной окружения #FAR2L_ARGS#.


@RegExp
$ #Регулярные выражения для поиска#
    Синтаксис регулярных выражений почти полностью совпадает с перловыми регэкспами.

    Общий вид: #regexp# или /#regexp#/#options#.

    Опции (#options#):
    #i# - игнорировать регистр
    #s# - ^<wrap>рассматривать текст как одну строку, '.' совпадает с абсолютно любым знаком
    #m# - ^<wrap>рассматривать текст как много строк. ^ и $ совпадают с началом и концом
любой "внутренней" строки
    #x# - ^<wrap>просто пробельные знаки (без обратного слеша впереди) игнорируются -
полезно в сложных выражениях для структуризации

    #regexp# - последовательность знаков и метасимволов. К знакам
относятся буквы и цифры, всё остальное, если и не является метасимволом, может
им стать, поэтому всё, что не есть буква и не есть цифра, следует делать
знаком "насильственно". Для этого надо перед ним поставить обратный слеш -
#\#.

    Обратите внимание на то, что все слеши (и прямые, и обратные) в вашем
регулярном выражении должны писаться со спецсимволом #\# впереди, чтобы не
быть спутанными с другими спецсимволами или концом выражения. Пример: строка
"большое\белое/страшное" в виде регулярного выражения должна выглядеть так -
"большое\\белое\/страшное".

    #Метасимволы#

    #\#  - ^<wrap>следующий за ним знак будет рассмотрен именно как знак, а не как метасимвол
    #^#  - ^<wrap>начало строки
    #$#  - ^<wrap>конец строки
    #|#  - ^<wrap>альтернатива. Должно совпасть выражение до или после |.

          ^<wrap>Пример: "\d+\w+|Hello\d+" работает как "(\d+\w+)|(Hello\d+)", а не как "\d+(\w+|H)ello\d+".

    #()# - ^<wrap>группировка - группировка служит либо для использования
"ссылок", либо для использования попавшего в скобку фрагмента текста при замене.
    #[]# - ^<wrap>класс знаков - это метасимвол который совпадёт с любым из
перечисленных в #[]# знаком или диапазоном знаков. Диапазоны указываются например так: [a-z]
Метасимволы не учитываются в классах символов. Если первый знак класса - #^#, то это делается негативный класс. Если
хочется добавить в класс знак #^#, он либо не должен быть первым, либо перед ним должен быть #\#.

    Кроме группировки круглые скобки служат ещё для следующих операций:
    #(?:pattern)#  - ^<wrap>обычная группировка, но только эта скобка не получает "номера".
    #(?=pattern)#  - ^<wrap>просмотр вперёд. Совпадение продолжится с того же места, но только если pattern в этой скобке
совпал. Например, #\w+(?=\s)# совпадёт со словом, за которым идёт пробел, причём пробел не будет
включён в результат поиска.
    #(?!pattern)#  - ^<wrap>отрицание просмотра вперёд. Совпадение продолжится с того же места, если pattern НЕ
совпадёт. Например, #foo(?!bar)# совпадёт с любым вхождением "foo", которое встречается без
последующего "bar". Помните, что это выражение имеет нулевой размер, что означает, что
#a(?!b)d# совпадёт с #ad#, потому что #a# сопровождается знаком, который не #b# (а #d#),
а #d# идёт за выражением нулевого размера.
    #(?<=pattern)# - ^<wrap>просмотр назад. К сожалению, pattern должен быть фиксированной длины.
    #(?<!pattern)# - ^<wrap>отрицание просмотра назад. Те же ограничения, что и для просмотра назад.

    #Квантификаторы#

    За любым знаком, группой или классом знаков может идти один из
квантификаторов:

    #?#      - ^<wrap>жадное совпадение 0 или один раз.
    #??#     - ^<wrap>нежадное совпадение 0 или один раз.
    #*#      - ^<wrap>жадное совпадение 0 или более раз.
    #*?#     - ^<wrap>нежадное совпадение 0 или более раз.
    #+#      - ^<wrap>жадное совпадение 1 или более раз.
    #+?#     - ^<wrap>нежадное совпадение 1 или более раз.
    #{n}#    - ^<wrap>совпадение точно n раз.
    #{n,}#   - ^<wrap>жадное совпадение n или более раз.
    #{n,}?#  - ^<wrap>нежадное совпадение n или более раз.
    #{n,m}#  - ^<wrap>жадное совпадение не меньше чем n, но не больше чем m раз.
    #{n,m}?# - ^<wrap>нежадное совпадение не меньше чем n, но не больше чем m раз.
    #{,m}#   - ^<wrap>эквивалентно {0,m}
    #{,m}?#  - ^<wrap>эквивалентно {0,m}?


    #Что такое "жадный" и "нежадный" квантификатор#

    Жадный квантификатор захватывает как можно больше. И только, если
дальнейшего совпадения не получилось, "отдаёт" захваченное (происходит
"откат", не самая "дешёвая" операция).
    Если выражение "A.*Z" сопоставить строке
"AZXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", то #.*# сначала захватит всю строку, а
потом будет по одному знаку "откатываться" пока не найдёт Z. А если
выражение будет "A.*?Z" то Z найдётся сразу же. Нежадный квантификатор ещё
называют #минимизирующим#, он захватывает минимально возможное количество
знаков, и только, если дальнейшее совпадение не получилось, захватывает ещё.

    #Спецсимволы#

   Перед небуквой и нецифрой можно в большинстве случаев ставить знак '#\#',  а
для букв и цифр это делать нужно осторожно, ибо таким образом обозначаются
спецсимволы:

    #.#    - ^<wrap>любой знак, кроме перевода строки. Если среди опций есть s, то вообще любой знак.
    #\t#   - tab (0x09)
    #\n#   - new line (lf, 0x0a)
    #\r#   - return (cr, 0x0d)
    #\f#   - form feed (0x0c)
    #\a#   - bell (0x07)
    #\e#   - escape (0x1b)
    #\xNNNN# - hex char, где N - [0-9A-Fa-f].
    #\Q#   - ^<wrap>начало квотирования метасимволов - всё, что квотируется,
будет обрабатываться как текст, а не как регулярное выражение
    #\E#   - конец квотирования метасимволов
    #\w#   - буква, цифра или '_'.
    #\W#   - не \w
    #\s#   - пробельный знак (tab/space/lf/cr).
    #\S#   - не \s
    #\d#   - цифра
    #\D#   - не цифра
    #\i#   - буква
    #\I#   - не буква
    #\l#   - знак в нижнем регистре
    #\L#   - не знак в нижнем регистре
    #\u#   - знак в верхнем регистре
    #\U#   - не знак в верхнем регистре
    #\b#   - ^<wrap>граница слова - означает, что слева или справа от текущей
позиции находится знак из "слова", а справа или слева, соответственно, из "не слова"
    #\B#   - не \b
    #\A#   - начало текста, независимо от опции m
    #\Z#   - конец текста, независимо от опции m
    #\O#   - ^<wrap>точка "невозврата". Если при матчинге пройден этот знак,
то отката назад не будет, сразу выдаст no match. Можно
использовать в сложном выражении после обязательного
фрагмента с квантификатором. Этот спецсимвол можно
использовать, когда обрабатываемые объёмы данных очень
большие.
         Пример:
         /.*?name\O=(['"])(.*?)\1\O.*?value\O=(['"])(.*?)\3/
         ^<wrap>Строки,  в которых есть "name=", но нету "value=", будут обрабатываться (фактически - пропускаться) быстрее.

    #\NN#  - ^<wrap>ссылка на ранее совпавшую скобку. NN - целое число
от 0 до 15. Каждая скобка кроме (?:pattern), (?=pattern),
(?!pattern), (?<=pattern) и (?<!pattern)
имеет номер (по порядку появления открывающей скобки).

         Пример:
         "(['"])hello\1" совпадёт с "hello" или 'hello'.


    #Примеры#

    #/foobar/#
       совпадёт с "foobar", но не с "FOOBAR"
    #/ FOO bar /ix#
       совпадёт с "foobar" и с "FOOBAR"
    #/(foo)?bar/#
       совпадёт с "foobar" и "bar"
    #/^foobar$/#
       совпадёт _только_ с "foobar", но не с "foofoofoobarfoobar"
    #/[\d\.]+/#
       совпадёт с любым числом с десятичной точкой
    #/(foo|bar)+/#
       совпадёт с "foofoofoobarfoobar" и "bar"
    #/\Q.)))$\E/#
       эквивалентно "\.\)\)\)\$"

@RegExpRepl
$ #Регулярные выражения для замены#
    В строке замены помимо обычных знаков вы можете использовать специальные
операторы - регулярные выражения для строки замены.

    #$0#..#$9#, #$A#..#$Z#

    Номера найденных групп. Соответствующая группа подставляется в строку во время
работы. Номера группам присваиваются в порядке следования открывающих скобок в
регулярном выражении. #$0# означает всю найденную последовательность
целиком. #$*# заменяется на символ '*'.

    Оба спецсимвола #\n# и #\r# будут заменены на перевод строки в зависимости 
от стиля конца строки, принятого в файле. Их поведение идентично.

    #\t# заменяется символом табуляции (0x09).


@ElevationDlg
$ #Запрос привилегий администратора#


@KeyMacro
$ #Макросы #
    Клавиатурные макрокоманды или макросы - это записанная последовательность
нажатий клавиш. Макрос позволяет многократно выполнять одну и ту же
последовательность действий за одно нажатие горячей клавиши.

    Каждый макрос имеет следующие параметры:

    - горячую клавишу, при нажатии на которую будет выполнена
      записанная последовательность;
    - набор дополнительных ~параметров~@KeyMacroSetting@, которые влияют на способ
      и место воспроизведения FAR2L записанной последовательности;

    Макросы могут содержать ~специальные команды~@KeyMacroLang@, реализующие
сервисные функции, условное и циклическое воспроизведение последовательностей и т.д.

    Макросы, чаще всего, используются для:

    1. Совершения одинаковых действий несколько раз, используя для
       вызова последовательности этих действий одно сочетание кнопок.
    2. Выполнения специальных функций, которые задаются специальными
       командами в тексте макроса.
    3. Переопределение стандартных сочетаний клавиш, которые
       использует FAR2L для совершения тех или иных действий.

    Основным применением макросов является определение кнопок для быстрого
вызова внешних плагинов и переопределение действий FAR2L.

    См. также:

    ~Области действия макросов~@KeyMacroArea@
    ~Кнопки назначения~@KeyMacroAssign@
    ~Запись и воспроизведение макросов~@KeyMacroRecPlay@
    ~Удаление макроса~@KeyMacroDelete@
    ~Параметры макрокоманды~@KeyMacroSetting@
    ~Макроязык~@KeyMacroLang@
    ~Установленные макросы~@KeyMacroList@


@KeyMacroArea
$ #Макросы: области действия#
    FAR2L позволяет создавать независимые ~макросы~@KeyMacro@ (макросы, у которых
совпадает сочетание клавиш запуска) для различных областей.

    Внимание: Область, к которой будет принадлежать макрос,
              определяется тем местом, где его #начали# записывать.

    В настоящий момент такими независимыми областями являются:

    - файловые панели;
    - внутренняя программа просмотра;
    - редактор;
    - диалоги;
    - быстрый поиск в панелях;
    - меню перехода;
    - основное меню;
    - прочие меню;
    - система помощи;
    - информационная панель;
    - панель быстрого просмотра;
    - панель дерева папок;
    - пользовательское меню;
    - остальное: режим копирования текста с экрана, вертикальные меню.

    Нельзя назначить на какое-либо сочетание клавиш в одной области несколько
различных действий. При попытке назначить для нового макроса уже используемое
сочетание предыдущий макрос будет удалён.

    Таким образом, вы можете иметь по одному макросу с одинаковым сочетанием
клавиш запуска в каждой из перечисленных областей.


@KeyMacroAssign
$ #Макросы: кнопки назначения#
    ~Макрос~@KeyMacro@ может быть назначен на:

    1. любую клавишу;
    2. на сочетание клавиши с модификаторами #Ctrl#, #Alt# и #Shift#;
    3. на сочетание клавиши с двумя модификаторами.
       FAR2L позволяет использовать следующие двойные модификаторы:
       #Ctrl-Shift-<клавиша>#, #Ctrl-Alt-<клавиша># и #Alt-Shift-<клавиша#>

    Макрос #не# может быть назначен на следующие клавиши и сочетания клавиш:
#Alt-Ins#, #Ctrl-<.>#, #Ctrl-Shift-<.>#, #Ctrl-Alt#, #Ctrl-Shift#, #Shift-Alt#
и #Shift-<символ>#.

    Некоторые комбинации клавиш (в частности, #Enter#, #Esc#, #F1#, #Ctrl-F5#,
#MsWheelUp# и #MsWheelDown# с комбинацией #Ctrl#, #Shift# и #Alt#) невозможно
ввести напрямую в диалоге назначения макроклавиши, поскольку они имеют
специальные функции. Для того, чтобы назначить макрос на одну из таких
комбинаций клавиш, выберите её из выпадающего списка.


@ChangeLocationConfig
$ #Настройки меню перехода#
    Этот диалог можно вызвать, нажав кнопку F9 в меню перехода, открытом по Alt+F1/F2.
    Здесь вы можете выбрать, какие виды объектов должны быть добавлены в меню
перехода: #точки монтирования#, #закладки# и #плагины#.
    Также можно настроить список точек монтирования указанием шаблонов исключений
и изменением шаблонов, определяющих содержимое дополнительных колонок.
    Там могут быть использованы следующие сокращения для подстановки значений:
    #$T# - полный размер диска
    #$U# - использованное место на диске
    #$F# - свободное место на диске
    #$A# - место, доступное не привилегированному пользователю
    #$u# - проценты использованного места
    #$f# - проценты свободного места
    #$a# - проценты доступного места
    #$N# - название файловой системы
    #$D# - устройство, на котором расположена файловая система
    #$S# - один символ, обозначающий статус файловой системы:
       ! - ФС доступна только для чтения
       ? - ФС недоступна из-за ошибки или таймаута
       <пробел> - ФС полностью доступна
    Также можно дополнительно выравнивать слова внутри результирующих строк при помощи:
    #$<# - дополнить пробелами слово слева так, чтобы его длина сравнялась с длиной самого длинного слова в том же месте
    #$># - дополнить пробелами слово справа так, чтобы его длина сравнялась с длиной самого длинного слова в том же месте

@KeyMacroRecPlay
$ #Макросы: запись и воспроизведение#
    FAR2L может выполнять ~макросы~@KeyMacro@ в двух основных режимах:

    1. Общий режим: нажимаемые клавиши при записи
       и воспроизведении #будут# передаваться плагинам.

    2. Специальный режим: нажимаемые клавиши при записи
       и воспроизведении #не будут# передаваться плагинам,
       перехватывающим события в редакторе.

    Например, если какой-то плагин обрабатывает сочетание клавиш #Ctrl+A#, то
при специальном режиме работы макросов этот плагин не получит управления и не
выполнит действия, которые он обычно выполняет при реакции на это сочетание
клавиш.

    Создание макроса выполняется следующими действиями:

    1. Начало записи макроса.

       Клавиша #Ctrl-<.># (#Ctrl# и клавишу с точкой) для записи
       макроса в общем режиме и #Ctrl-Shift-<.># (#Ctrl#,
       #Shift# и клавишу с точкой), для записи макроса в специальном
       режиме.

       После того как FAR2L начал запись макроса, в левом верхнем
       углу экрана будет отображаться символ '\4FR\-'.

    2. Текст макроса.

       FAR2L будет сохранять все нажимаемые клавиши со следующими
       исключениями:

       - будут сохранены только клавиши, обрабатываемые FAR2L.
         Т.е. если вы в процессе записи макроса из консоли FAR2L
         запустите внешнюю программу, то FAR2L сохранит только
         клавиши, нажатые до запуска и после завершения внешней
         программы.

       #Примечание:# На время записи макроса все остальные макросы
       отключаются. Таким образом, нельзя записать "многоступенчатый"
       макрос, вызывающий ранее записанные макропоследовательности.

    3. Окончание записи макроса.

       Для завершения записи макроса служат специальные сочетания
       клавиш. Т.к. макрос может быть дополнительно настроен,
       то таких сочетаний два: #Ctrl-<.># (#Ctrl# и клавиша с точкой)
       и #Ctrl-Shift-<.># (#Ctrl#, #Shift# и клавиша с точкой).
       Первое сочетание вызывает запись макроса с параметрами
       воспроизведения, принятыми по умолчанию. Второе сочетание
       клавиш показывает диалог с ~параметрами~@KeyMacroSetting@ выполнения макроса.

    4. Назначение сочетания клавиш для запуска макроса.

       После окончания ввода текста макроса и назначения параметров
       его выполнения будет показан диалог ~назначения клавиши~@KeyMacroSetting@,
       в котором можно задать горячую клавишу для воспроизведения
       записанной последовательности.

    Воспроизведение макроса сопровождается отображением в левом верхнем углу экрана символа '\2FP\-'.

@KeyMacroDelete
$ #Макросы: удаление макроса#
    Для того, чтобы удалить ~макрос~@KeyMacro@, нужно записать пустой (не
содержащий действий) макрос и присвоить ему горячую клавишу макроса, который вы
хотите удалить.

    Эту операцию можно выполнить, осуществив следующие действия:

    1. Начать запись макроса (#Ctrl-<.>#)
    2. Закончить запись макроса (#Ctrl-<.>#)
    3. Ввести или выбрать в диалоге назначения горячей клавиши
       сочетание, макрос для которого вы хотите удалить

    #Внимание#

    После удаления макроса сочетание клавиш, используемое для его
    выполнения, начнёт выполнять свою первоначальную функцию. Т.е.
    если это сочетание клавиш до записи макроса обрабатывалось FAR2L
    или каким-либо плагином, то после удаления макроса оно снова начнёт
    обрабатываться.


@KeyMacroSetting
$ #Макросы: параметры макрокоманды#
    Для задания дополнительных параметров ~макрокоманды~@KeyMacro@ завершите её
запись с помощью #Ctrl-Shift-.# вместо #Ctrl-.# и выберите желаемые опции в
появившемся диалоге:

    #Последовательность:#

    Позволяет изменить записанную последовательность клавиш.

    #Разрешить во время выполнения вывод на экран#

    Если отключить этот параметр, то во время выполнения макрокоманды FAR2L
Manager отключает перерисовку экрана. Все изменения будут отображены после
завершения макрокоманды.

    #Выполнять после запуска FAR#

    Позволяет выполнять макрокоманду сразу после запуска FAR2L.

    Для активной и пассивной панелей возможны следующие условия, активизирующие
макрокоманду:

     #На панели плагина#
        [x] - выполнять, только если панель плагиновая
        [ ] - выполнять только для файловой панели
        [?] - игнорировать тип панели

     #Выполнять для папок#
        [x] - выполнять, только если на панели под курсором папка
        [ ] - выполнять, только если на панели под курсором файл
        [?] - выполнять для папок и файлов

     #Отмечены файлы#
        [x] - выполнять, только если на панели есть отмеченные
              файлы/папки
        [ ] - выполнять, если нет отмеченных файлов/папок
        [?] - игнорировать состояние отметки файлов/папок

   Прочие условия активизирующие макрокоманду:

     #Пустая командная строка#
        [x] - выполнять, только если командная строка пуста
        [ ] - выполнять, только если командная строка не пуста
        [?] - игнорировать состояние командной строки

     #Отмечен блок#
        [x] - выполнять, только если выделен блок в редакторе,
              программе просмотра, командной строке или в строке
              ввода в диалоге.
        [ ] - выполнять, если нет отмеченного блока
        [?] - игнорировать состояние отметки блока


   Примечания:

    1. FAR2L, перед активацией макрокоманды, проверяет все описанные выше
условия.

    2. Некоторые комбинации клавиш (в частности, #Enter#, #Esc#, #F1#,
#Ctrl-F5#, #MsWheelUp#, #MsWheelDown# и другие клавиши мыши с комбинацией #Ctrl#, #Shift# и #Alt#)
невозможно ввести напрямую, поскольку они имеют специальные функции в диалоге.
Для того, чтобы ~назначить макрос~@KeyMacroAssign@ на одну из таких комбинаций
клавиш, выберите её из выпадающего списка в диалоге.


@KeyMacroLang
$ #Макросы: макроязык#
    В FAR2L реализован примитивный макроязык, который позволяет в простую
последовательность клавиш ввести логику, что делает макросы (вместе с
~плагинами~@Plugins@) мощным средством, помогающим в работе с FAR2L.

    Вот часть команд, демонстрирующая возможности:
    #$Exit#         - прервать выполнение макрокоманды
    #$Text#         - вставка произвольного текста
    #$XLat#         - функция транслитерации
    #$If-$Else#     - условный оператор
    #$While#        - условный оператор
    #$Rep#          - оператор цикла
    #%var#          - использование переменных
     и другие...

    Добавить элементы макроязыка в ~макрос~@KeyMacro@ можно только путём ручной
правки файла конфигурации или путём применения специальных программ/плагинов.

    Описание макроязыка можно найти в сопроводительной документации.

    Онлайн документация:
    ~https://api.farmanager.com/ru/macro/~@https://api.farmanager.com/ru/macro/@

@KeyMacroList
$ #Макросы: Список установленных макросов#
    Ниже приведен список разделов, в которых можно узнать какие ~макросы~@KeyMacro@ 
действуют в текущей сессии Far Manager.

  ~Список переменных~@KeyMacroVarList@
  ~Список констант~@KeyMacroConstList@

  ~Общие макросы#~@KeyMacroCommonList@

  ~Панели~@KeyMacroShellList@
  ~Панель быстрого просмотра~@KeyMacroQViewList@
  ~Панель папок~@KeyMacroTreeList@
  ~Информационная панель~@KeyMacroInfoList@

  ~Быстрый поиск в панелях~@KeyMacroSearchList@
  ~Поиск папки~@KeyMacroFindFolderList@

  ~Диалоги~@KeyMacroDialogList@

  ~Главное меню~@KeyMacroMainMenuList@
  ~Меню перехода~@KeyMacroDisksList@
  ~Меню пользователя~@KeyMacroUserMenuList@
  ~Прочие меню~@KeyMacroMenuList@
  
  ~Программа просмотра~@KeyMacroViewerList@
  ~Редактор~@KeyMacroEditList@
  
  ~Файл помощи#~@KeyMacroHelpList@
  
  ~Остальные области~@KeyMacroOtherList@

@KeyMacroVarList
$ #Макросы: Список переменных#
    Ниже приведён список глобальных переменных, которые можно использовать в макросах.

<!Macro:Vars!>

@KeyMacroConstList
$ #Макросы: Список констант#
    Ниже приведён список констант, которые можно использовать в макросах.

<!Macro:Consts!>

@KeyMacroCommonList
$ #Макросы: Общие#
    Ниже приведены комбинации макроклавиш, действующих везде.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>

@KeyMacroQViewList
$ #Макросы: Панель быстрого просмотра#
    Ниже приведены комбинации макроклавиш, действующих в панели быстрого просмотра.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>
<!Macro:Qview!>

@KeyMacroMainMenuList
$ #Макросы: Главное меню#
    Ниже приведены комбинации макроклавиш, действующих в главном меню.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>
<!Macro:MainMenu!>

@KeyMacroTreeList
$ #Макросы: Панель папок#
    Ниже приведены комбинации макроклавиш, действующих в панели папок.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>
<!Macro:Tree!>

@KeyMacroDialogList
$ #Макросы: Диалоги#
    Ниже приведены комбинации макроклавиш, действующих в диалогах.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>
<!Macro:Dialog!>

@KeyMacroInfoList
$ #Макросы: Информационная панель#
    Ниже приведены комбинации макроклавиш, действующих в информационной панели.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>
<!Macro:Info!>

@KeyMacroDisksList
$ #Макросы: Меню перехода#
    Ниже приведены комбинации макроклавиш, действующих в меню перехода.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>
<!Macro:Disks!>

@KeyMacroUserMenuList
$ #Макросы: Меню пользователя#
    Ниже приведены комбинации макроклавиш, действующих в пользовательском меню.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>
<!Macro:UserMenu!>

@KeyMacroShellList
$ #Макросы: Панели#
    Ниже приведены комбинации макроклавиш, действующих в файловых панелях.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>
<!Macro:Shell!>

@KeyMacroSearchList
$ #Макросы: Быстрый поиск в панелях#
    Ниже приведены комбинации макроклавиш, действующих в быстром поиске файловых панелей.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>
<!Macro:Search!>

@KeyMacroFindFolderList
$ #Макросы: Поиск папки#
    Ниже приведены комбинации макроклавиш, действующих в поиске папки.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>
<!Macro:FindFolder!>

@KeyMacroViewerList
$ #Макросы: Программа просмотра#
    Ниже приведены комбинации макроклавиш, действующих в программе просмотра.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>
<!Macro:Viewer!>

@KeyMacroMenuList
$ #Макросы: Прочие меню#
    Ниже приведены комбинации макроклавиш, действующих в прочих меню.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>
<!Macro:Menu!>

@KeyMacroEditList
$ #Макросы: Редактор#
    Ниже приведены комбинации макроклавиш, действующих в редакторе.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>
<!Macro:Editor!>

@KeyMacroHelpList
$ #Макросы: Файл помощи#
    Ниже приведены комбинации макроклавиш, действующих в файле помощи.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>
<!Macro:Help!>

@KeyMacroOtherList
$ #Макросы: Остальные области#
    Ниже приведены комбинации макроклавиш, действующих в других областях: копировании текста с экрана, вертикальных меню.
    Описание для каждой макроклавиши берётся из файла конфигурации (поле Description).

<!Macro:Common!>
<!Macro:Other!>

@Index
$ #Индекс файла помощи#
<%INDEX%>
