#ifndef __CONFIGPLUGIN_H__
#define __CONFIGPLUGIN_H__

#include <farplug-wide.h>
#include <farkeys.h>
#include <map>
#include <string>
#include "sqllng.h"
#include "farapi.h"

enum {
	PanelModeBrief,
	PanelModeMedium,
	PanelModeFull,
	PanelModeWide,
	PanelModeDetailed,
	PanelModeDiz,
	PanelModeLongDiz,
	PanelModeOwners,
	PanelModeLinks,
	PanelModeAlternative,
	PanelModeMax,
};

typedef struct {
	const wchar_t * statusColumnTypes;
	const wchar_t * statusColumnWidths;
	const wchar_t * columnTypes[2];
	const wchar_t * columnWidths[2];
	const wchar_t * columnTitles[2][15];
	uint32_t keyBarTitles[12];
	uint32_t keyBarShiftTitles[12];
	uint32_t panelTitle;
	uint32_t format;
	uint32_t flags;
} CfgDefaults;

typedef enum {
	SqliteDbPanelIndex,
	SqliteTablePanelIndex,
	MaxPanelIndex
} PanelIndex;

class PluginCfg : public FarApi {

	private:
		static std::map<PanelIndex, CfgDefaults> def;
		static size_t init;

		const char * GetPanelName(PanelIndex index) const;

		static bool logEnable;

		friend LONG_PTR WINAPI CfgDialogProc(HANDLE hDlg, int msg, int param1, LONG_PTR param2);

		void SaveConfig(void) const;

	public:
		explicit PluginCfg();
		~PluginCfg();

		static bool sqlAddToDisksMenu;
		static bool sqlAddToPluginsMenu;
		std::wstring prefix;

		void FillPanelData(struct PanelData * data, PanelIndex index);
		void ReloadPanelKeyBar(struct PanelData * data, PanelIndex index);
		void ReloadPanelString(struct PanelData * data, PanelIndex index);

		void GetPluginInfo(struct PluginInfo *info);
		int Configure(int itemNumber);
};

#endif /* __CONFIGPLUGIN_H__ */
