# spec file for package 7z, to make 7z.so only

Name:           lib7zz
Version:        24.09
Release:        1
Group:			Productivity/File utilities
Summary:        7zz.so, primarily for Far manager for Linux
License:        GPL-2.0-only
URL:            https://github.com/7z/7zip
Source0:        lib7zz-%{version}.orig.tar.xz
Source1:        changelog
BuildArchitectures: x86_64 i586 aarch64
Distribution: 	openSUSE Tumbleweed

%define	override_gcc
%if 0%{?is_opensuse}
	%if 0%{?sle_version} == 150300
BuildRequires:  gcc10 gcc10-c++
	%define override_gcc CXX=g++-10 CC=gcc-10
	%endif
	%if 0%{?sle_version} == 150400
BuildRequires:  gcc11 gcc11-c++
	%define override_gcc CXX=g++-11 CC=gcc-11
	%endif
	%if 0%{?sle_version} == 150500
BuildRequires:  gcc12 gcc12-c++
	%define override_gcc -CXX=g++-12 CC=gcc-12
	%endif
	%if 0%{?sle_version} == 150600
BuildRequires: gcc13 gcc13-c++
	%define override_gcc -CXX=g++-13 CC=gcc-13
	%endif

	%if 0%{?suse_version} > 1600
BuildRequires:  gcc-c++
	%endif
%else
BuildRequires:  gcc-c++
%endif

BuildRequires:  pkgconfig
BuildRequires:  gawk m4 make git
BuildRequires:  cmake

Requires:		/bin/sh

%description
The dynamic library of well-known 7z archiver for API access from 3rd party software.

Summary: 	The dynamic library of well-known 7z archiver for API access from 3rd party software.
Provides:	7z-so

# build

%prep
%autosetup -p1

%build

pushd CPP/7zip/Bundles/Alone2
make %{override_gcc} DEF_FILE=1 DEBUG_BUILD=1 -f ../../cmpl_gcc.mak
popd

%install
pushd CPP/7zip/Bundles/Alone2/b/g
install -d %{buildroot}/%{_libdir}
install 7zz.so %{buildroot}/%{_libdir}/7zz.so
popd

# per-package files

%files
%{_libdir}/7zz.so

