/* Distributed Checksum Clearinghouse
 *
 * --C-LICENSE--
 * $Revision: 1.19 $
 */

#include "dcc_defs.h"
#include "dcc_xhdr.h"


const char *
id2str(char *buf, u_int buf_len, DCC_CLNT_ID id)
{
	switch (id) {
	case DCC_ID_INVALID:
		STRLCPY(buf, DCC_XHDR_ID_INVALID, buf_len);
		return buf;

	case DCC_ID_WHITE:
		*buf = '\0';
		break;
	case DCC_ID_COMP:
		STRLCPY(buf, DCC_XHDR_ID_COMP, buf_len);
		return buf;

	case DCC_ID_SRVR_SIMPLE:
		STRLCPY(buf, DCC_XHDR_ID_SIMPLE, buf_len);
		return buf;
	case DCC_ID_SRVR_IGNORE:
		STRLCPY(buf, DCC_XHDR_ID_IGNORE, buf_len);
		return buf;
	case DCC_ID_SRVR_ROGUE:
		STRLCPY(buf, DCC_XHDR_ID_ROGUE, buf_len);
		return buf;

	case DCC_ID_SRVR_DATE:
		STRLCPY(buf, DCC_XHDR_ID_DATE, buf_len);
		return buf;

	default:
		snprintf(buf, buf_len, "%d", id);
	}
	return buf;
}
