/* Distributed Checksum Clearinghouse
 *
 * message authentication
 *
 * --C-LICENSE--
 *
 * $Revision: 1.14 $
 */

#include "dcc_defs.h"
#include "dcc_md5.h"
#include <string.h>


/* sign a DCC packet */
void
dcc_sign(const void *passwd,
	 int passwd_len,
	 void *pkt,
	 u_int pkt_len)			/* including signature */
{
	MD5_CTX ctx;

	MD5Init(&ctx);
	MD5Update(&ctx, passwd, passwd_len);
	MD5Update(&ctx, pkt, pkt_len-sizeof(DCC_SIGNATURE));
	MD5Final(&((u_char*)pkt)[pkt_len-sizeof(DCC_SIGNATURE)], &ctx);
}



/* check the signature of a DCC packet */
u_char					/* 0=forgery, 1=good signature */
dcc_ck_signature(const void *passwd,
		 int passwd_len,
		 const void *pkt,
		 u_int pkt_len)		/* including signature */
{
	MD5_CTX ctx;
	DCC_SIGNATURE signature;

	MD5Init(&ctx);
	MD5Update(&ctx, passwd, passwd_len);
	MD5Update(&ctx, pkt, pkt_len-sizeof(DCC_SIGNATURE));
	MD5Final(signature, &ctx);
	return !memcmp(signature, &((char*)pkt)[pkt_len-sizeof(DCC_SIGNATURE)],
		       sizeof(signature));
}
