/* compatibility hack for old systems that don't have hstrerror()
 *
 * --C-LICENSE--
 * $Revision: 1.6 $
 */

#include "dcc_defs.h"

#include <stdio.h>

static const char *h_errlist[] = {
	"Resolver Error 0 (no error)",
	"Unknown host",			/* 1 HOST_NOT_FOUND */
	"Host name lookup failure",	/* 2 TRY_AGAIN */
	"Unknown server error",		/* 3 NO_RECOVERY */
	"No address associated with name",  /* 4 NO_ADDRESS */
};
#define H_NERR ((int)(sizeof(h_errlist)/sizeof( h_errlist[0])))

const char *
dcc_hstrerror(int err)
{
    static char buf[64];

    if (err < 0 || err > H_NERR || h_errlist[err] == NULL) {
	snprintf(buf, sizeof(buf), "host name error %d", err);
	return buf;
    }
    return h_errlist[err];
}
