/* Distributed Checksum Clearinghouse
 *
 * --C-LICENSE--
 * $Revision: 1.2 $
 */

#include "dcc_defs.h"


/* get a password */
const char *				/* 0 or remainder of line */
parse_passwd(DCC_EMSG *emsg,
	     DCC_PASSWD passwd,		/* copy password here */
	     const char *line,		/* line of words */
	     const char *fieldname,
	     const char *fnm, int lno)
{
	char buf[sizeof(DCC_PASSWD)+1];
	const char *result;

	memset(buf, 0, sizeof(buf));
	result = dcc_parse_word(emsg, buf, sizeof(buf),
				line, fieldname, fnm, lno);
	if (result)
		memcpy(passwd, buf, sizeof(DCC_PASSWD));
	else
		memset(passwd, 0, sizeof(DCC_PASSWD));
	return result;
}



/* see if a string starts with a word possibly followed by a comma */
u_char					/* 1=yes */
ck_word_comma(const char **parg, const char *word)
{
	u_int word_len = strlen(word);
	const char *arg = *parg;

	if (strncasecmp(arg, word, word_len))
		return 0;
	arg += word_len;
	if (*arg == '\0') {
		*parg = arg;
		return 1;
	}
	if (*arg == ',') {
		*parg = arg+1;
		return 1;
	}
	return 0;
}
