/* Distributed Checksum Clearinghouse
 *
 * --C-LICENSE--
 *
 * $Revision: 1.15 $
 */

#include "dcc_defs.h"
#include "dcc_xhdr.h"


DCC_TGTS
dcc_str2cnt(const char *str)
{
	u_long l;
	char *p;

	l = strtoul(str, &p, 0);
	if (*p == '\0') {
		if (l > DCC_TGTS_TOO_MANY)
			l = DCC_TGTS_TOO_MANY;
		return l;
	}
	if (!strcasecmp(str, DCC_XHDR_TOO_MANY))
		return DCC_TGTS_TOO_MANY;
	if (!strcasecmp(str, DCC_XHDR_OK))
		return DCC_TGTS_OK;
	if (!strcasecmp(str, DCC_XHDR_OK2))
		return DCC_TGTS_OK2;
	if (!strcasecmp(str, DCC_XHDR_OK_MX))
		return DCC_TGTS_OK_MX;
	if (!strcasecmp(str, DCC_XHDR_OK_MXDCC))
		return DCC_TGTS_OK_MXDCC;
	if (!strcasecmp(str, DCC_XHDR_SUBMIT_CLIENT))
		return DCC_TGTS_SUBMIT_CLIENT;
	return DCC_TGTS_INVALID;
}
