/* Distributed Checksum Clearinghouse heap debugging
 *
 * --C-LICENSE--
 *
 * $Revision: 1.12 $
 */

#ifndef DCC_HEAP_DEBUG_H
#define DCC_HEAP_DEBUG_H

#ifdef DCC_DEBUG_HEAP
extern void *dcc_malloc(size_t);
extern void *dcc_calloc(size_t, size_t);
extern void dcc_malloc_check(void);
extern char *dcc_strdup(const char *);
extern void dcc_free(void *);
#ifdef DCC_UNIX
extern char *malloc_options;
#endif

#else /* !DCC_DEBUG_HEAP */
#define dcc_malloc(l) malloc(l)
#define dcc_calloc(l,n) calloc(l,n)
#define dcc_malloc_check()
#define dcc_strdup(s) strdup(s)
#define dcc_free(p) free(p)
#endif /* !DCC_DEBUG_HEAP */

#endif /* DCC_HEAP_DEBUG_H */
