# PlatformIO Project Examples

- [Development platforms](#development-platforms):
  - [Embedded](#embedded)
  - [Desktop](#desktop)
- [Frameworks](#frameworks)

## Development platforms

### Embedded

* [Aceinna IMU](https://github.com/aceinna/platform-aceinna_imu/tree/master/examples)
* [Atmel AVR](https://github.com/platformio/platform-atmelavr/tree/master/examples)
* [Atmel megaAVR](https://github.com/platformio/platform-atmelmegaavr/tree/master/examples)
* [Atmel SAM](https://github.com/platformio/platform-atmelsam/tree/master/examples)
* [CHIPS Alliance](https://github.com/platformio/platform-chipsalliance/tree/master/examples)
* [Espressif 32](https://github.com/platformio/platform-espressif32/tree/master/examples)
* [Espressif 8266](https://github.com/platformio/platform-espressif8266/tree/master/examples)
* [Freescale Kinetis](https://github.com/platformio/platform-freescalekinetis/tree/master/examples)
* [Heltec CubeCell](https://github.com/HelTecAutomation/platform-heltec-cubecell/tree/master/examples)
* [Intel ARC32](https://github.com/platformio/platform-intel_arc32/tree/master/examples)
* [Intel MCS-51 (8051)](https://github.com/platformio/platform-intel_mcs51/tree/master/examples)
* [Lattice iCE40](https://github.com/platformio/platform-lattice_ice40/tree/master/examples)
* [Maxim 32](https://github.com/platformio/platform-maxim32/tree/master/examples)
* [Microchip PIC32](https://github.com/platformio/platform-microchippic32/tree/master/examples)
* [Nordic nRF51](https://github.com/platformio/platform-nordicnrf51/tree/master/examples)
* [Nordic nRF52](https://github.com/platformio/platform-nordicnrf52/tree/master/examples)
* [NXP i.MX RT](https://github.com/platformio/platform-nxpimxrt/tree/master/examples)
* [NXP LPC](https://github.com/platformio/platform-nxplpc/tree/master/examples)
* [OpenHW Group](https://github.com/platformio/platform-openhw/tree/master/examples)
* [Raspberry Pi RP2040](https://github.com/platformio/platform-raspberrypi/tree/master/examples)
* [Renesas RA](https://github.com/platformio/platform-renesas-ra/tree/master/examples)
* [RISC-V GAP](https://github.com/platformio/platform-riscv_gap/tree/master/examples)
* [Shakti](https://github.com/platformio/platform-shakti/tree/master/examples)
* [SiFive](https://github.com/platformio/platform-sifive/tree/master/examples)
* [Silicon Labs EFM32](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples)
* [ST STM32](https://github.com/platformio/platform-ststm32/tree/master/examples)
* [ST STM8](https://github.com/platformio/platform-ststm8/tree/master/examples)
* [Teensy](https://github.com/platformio/platform-teensy/tree/master/examples)
* [TI MSP430](https://github.com/platformio/platform-timsp430/tree/master/examples)
* [TI TIVA](https://github.com/platformio/platform-titiva/tree/master/examples)

### Desktop

* [Linux ARM](https://github.com/platformio/platform-linux_arm/tree/master/examples)
* [Linux i686](https://github.com/platformio/platform-linux_i686/tree/master/examples)
* [Linux x86_64](https://github.com/platformio/platform-linux_x86_64/tree/master/examples)
* [Native](https://github.com/platformio/platform-native/tree/master/examples)
* [Windows x86](https://github.com/platformio/platform-windows_x86/tree/master/examples)

## Frameworks

* [Arduino](https://docs.platformio.org/en/latest/frameworks/arduino.html?utm_source=github&utm_medium=examples#examples)
* [CMSIS](https://docs.platformio.org/en/latest/frameworks/cmsis.html?utm_source=github&utm_medium=examples#examples)
* [Energia](https://docs.platformio.org/en/latest/frameworks/energia.html?utm_source=github&utm_medium=examples#examples)
* [ESP8266 Non-OS SDK](https://docs.platformio.org/en/latest/frameworks/esp8266-nonos-sdk.html?utm_source=github&utm_medium=examples#examples)
* [ESP8266 RTOS SDK](https://docs.platformio.org/en/latest/frameworks/esp8266-rtos-sdk.html?utm_source=github&utm_medium=examples#examples)
* [Espressif IoT Development Framework](https://docs.platformio.org/en/latest/frameworks/espidf.html?utm_source=github&utm_medium=examples#examples)
* [Freedom E SDK](https://docs.platformio.org/en/latest/frameworks/freedom-e-sdk.html?utm_source=github&utm_medium=examples#examples)
* [FreeRTOS](https://docs.platformio.org/en/latest/frameworks/freertos.html?utm_source=github&utm_medium=examples#examples)
* [Renesas Flexible Software Package](https://docs.platformio.org/en/latest/frameworks/fsp.html?utm_source=github&utm_medium=examples#examples)
* [libopencm3](https://docs.platformio.org/en/latest/frameworks/libopencm3.html?utm_source=github&utm_medium=examples#examples)
* [Mbed OS](https://docs.platformio.org/en/latest/frameworks/mbed.html?utm_source=github&utm_medium=examples#examples)
* [PULP OS](https://docs.platformio.org/en/latest/frameworks/pulp-os.html?utm_source=github&utm_medium=examples#examples)
* [PULP Runtime Environment](https://docs.platformio.org/en/latest/frameworks/pulp-runtime.html?utm_source=github&utm_medium=examples#examples)
* [PULP SDK](https://docs.platformio.org/en/latest/frameworks/pulp-sdk.html?utm_source=github&utm_medium=examples#examples)
* [Shakti SDK](https://docs.platformio.org/en/latest/frameworks/shakti-sdk.html?utm_source=github&utm_medium=examples#examples)
* [Standard Peripheral Library](https://docs.platformio.org/en/latest/frameworks/spl.html?utm_source=github&utm_medium=examples#examples)
* [STM32Cube](https://docs.platformio.org/en/latest/frameworks/stm32cube.html?utm_source=github&utm_medium=examples#examples)
* [WD-Firmware](https://docs.platformio.org/en/latest/frameworks/wd-riscv-sdk.html?utm_source=github&utm_medium=examples#examples)
* [WiringPi](https://docs.platformio.org/en/latest/frameworks/wiringpi.html?utm_source=github&utm_medium=examples#examples)
* [Zephyr](https://docs.platformio.org/en/latest/frameworks/zephyr.html?utm_source=github&utm_medium=examples#examples)
