function el320x(method, varargin)

if ~nargin
    return
end

%display([gcb ' ' method]);

switch lower(method)
case 'set'
    model = get_param(gcbh, 'model');

    if model(1) ~= 'E'
        errordlg('Please choose a correct slave', gcb);
        return
    end

    ud = get_param(gcbh,'UserData');
    [ud.SlaveConfig,gain] = slave_config(model);
    ud.PortConfig = port_config(ud.SlaveConfig,gain);
    set_param(gcbh, 'UserData', ud);

case 'check'
    % If UserData.SlaveConfig does not exist, this is an update
    % Convert this block and return
    model = get_param(gcbh,'model');

    ud = get_param(gcbh, 'UserData');

    % Get slave and port configuration based on product code and revision
    [sc,gain] = slave_config(ud.SlaveConfig.product, ud.SlaveConfig.revision);
    pc = port_config(sc,gain);

    if isequal(sc.sm, ud.SlaveConfig.sm) && ~isequal(sc, ud.SlaveConfig)
        % The slave has a new name
        warning('el31xx:NewName', ...
                '%s: Renaming device from %s to %s', ...
                gcb, get_param(gcbh,'model'), sc.description)
        set_param(gcbh, 'model', sc.description)
        return;
    end

    if ~isequal(pc, ud.PortConfig)
        errordlg('Configuration error. Please replace this block', gcb);
        %error('el31xx:PortConfig', 'Configuration error on %s. Replace it',...
                %gcb);
    end

case 'update'
    update_devices(varargin{1}, slave_config());

otherwise
    display([gcb, ': Unknown method ', method])
end

return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [rv,gain] = slave_config(varargin)

%      PdoIdx            PdoEntry
% Note: the PdoIdx field will be incremented by IndexOffset (column 3)
%       from the models struct below
pdo = {...
        hex2dec('1a00'), [hex2dec('6000'), 1, 1;...
                          hex2dec('6000'), 2, 1;...
                          hex2dec('6000'), 3, 2;...
                          hex2dec('6000'), 5, 2;...
                          hex2dec('6000'), 7, 1;...
                          0              , 0, 7;...
                          hex2dec('1800'), 7, 1;...
                          hex2dec('1800'), 9, 1;...
                          hex2dec('6000'),17,16;...
                         ];...
        hex2dec('1a01'), [hex2dec('6010'), 1, 1;...
                          hex2dec('6010'), 2, 1;...
                          hex2dec('6010'), 3, 2;...
                          hex2dec('6010'), 5, 2;...
                          hex2dec('6010'), 7, 1;...
                          0              , 0, 7;...
                          hex2dec('1801'), 7, 1;...
                          hex2dec('1801'), 9, 1;...
                          hex2dec('6010'),17,16;...
                         ];...
        hex2dec('1a02'), [hex2dec('6020'), 1, 1;...
                          hex2dec('6020'), 2, 1;...
                          hex2dec('6020'), 3, 2;...
                          hex2dec('6020'), 5, 2;...
                          hex2dec('6020'), 7, 1;...
                          0              , 0, 7;...
                          hex2dec('1802'), 7, 1;...
                          hex2dec('1802'), 9, 1;...
                          hex2dec('6020'),17,16;...
                         ];...
        hex2dec('1a03'), [hex2dec('6030'), 1, 1;...
                          hex2dec('6030'), 2, 1;...
                          hex2dec('6030'), 3, 2;...
                          hex2dec('6030'), 5, 2;...
                          hex2dec('6030'), 7, 1;...
                          0              , 0, 7;...
                          hex2dec('1803'), 7, 1;...
                          hex2dec('1803'), 9, 1;...
                          hex2dec('6030'),17,16;...
                         ];...
};

%   Model       ProductCode          Revision          IndexOffset, function
models = {...
  'EL3201',       hex2dec('0c813052'), hex2dec('00110000'), 0.1 ; ...
  'EL3201-0010',  hex2dec('0c813052'), hex2dec('0011000a'), 0.01; ...
  'EL3201-0020',  hex2dec('0c813052'), hex2dec('00110014'), 0.01; ...
  'EL3202',       hex2dec('0c823052'), hex2dec('00110000'), 0.1 ; ...
  'EL3202-0010',  hex2dec('0c823052'), hex2dec('0011000a'), 0.01; ...
  'EL3204',       hex2dec('0c843052'), hex2dec('00110000'), 0.1 ; ...
};

gain = [];

switch nargin
case 2
    pos = cell2mat(models(:,2)) == varargin{1}...
        & cell2mat(models(:,3)) == varargin{2};
    product = models(pos,:);

case 1
    product = models(strcmp(models(:,1),varargin{1}),:);

otherwise
    fields = models(:,1);
    obsolete = cellfun(@length, fields) > 11;
    rv = vertcat(sort(fields(~obsolete)), sort(fields(obsolete)));
    return
end

if isempty(product)
    rv = [];
    return;
end

rv.vendor = 2;
rv.description = product{1};
rv.product = product{2};
rv.revision = product{3};
gain = product{4};

% Find out which rows of pdo matrix we need
rows = 1:str2double(rv.description(6));

% Populate the PDO structure
rv.sm = {{3, 1, {}}};
rv.sm{1}{3} = ...
        arrayfun(@(x) {pdo{x,1}, pdo{x,2}}, rows, 'UniformOutput', false);

return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function rv = port_config(SlaveConfig, gain)
% Populate the blocks output port(s)

vector  = strcmp(get_param(gcbh,'vector'), 'on');
pdo_count = numel(SlaveConfig.sm{1}{3});

if vector
    rv.output.pdo      = zeros(pdo_count, 4);
    rv.output.pdo(:,2) = 0:pdo_count-1;
    rv.output.pdo(:,3) = repmat(8,pdo_count,1);
    rv.output.pdo_data_type = 2016;
    rv.output.gain     = gain;

    if strcmp(get_param(gcbh,'enable_status'),'on')
        rv.output(2).pdo = rv.output(1).pdo;
        rv.output(2).pdo(:,3) = repmat(4,pdo_count,1);
        rv.output(2).pdo_data_type = 1001;
    end
else
    rv.output  = arrayfun(@(x) struct('pdo', [0 x 8 0],...
                                      'gain', gain, ...
                                      'pdo_data_type', 2016), ...
                          0:pdo_count-1);
end

return
