/*****************************************************************************
 *
 * $Id$
 *
 * Copyright (C) 2009 - 2012  Richard Hacker <lerich@gmx.net>
 *                            Florian Pose <fp@igh-essen.com>
 *
 * This file is part of the PdCom library.
 *
 * The PdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The PdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the PdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 * \file PdCom example implementation.
 *
 ****************************************************************************/

#include <iostream>
using namespace std;

#include "ExampleProcess.h"

/****************************************************************************/

/** Constructor.
 */
ExampleProcess::ExampleProcess(
        const char *address, /**< IP address or host name. */
        int port /**< TCP port number. */
        ):
    LinuxProcess(address, port)
{
    scale.gain = 1.0;
    scale.offset = 0.0;
}

/****************************************************************************/

/* Destructor.
 */
ExampleProcess::~ExampleProcess()
{
    reset();
}

/****************************************************************************/

/* Called by PdCom::Process, if protocol initialisation is complete.
 *
 * Reimplements Process::sigConnected()
 */
void ExampleProcess::sigConnected()
{
    PdCom::Variable *pv;

#ifdef PDCOM_HAVE_BROADCAST
    sendBroadcast("Hello from the example!", "text");
#endif

    // In our case, we choose to subscribe to our variables here.
    // This is not entirely necessary; it could be done any time
    // later, as long as it is after this call.
    if ((pv = findVariable("/Hydraulik/Oeltemperatur"))) {

        // Subscribing to a variable may fail if there are problems.
        // Since sigConnected() is called within the context of
        // newData(), we cannot rely on a global try-catch construct,
        // otherwise the protocol handler will get confused.
        // We need a local try-catch block here.
        try {
            //pv->poll(this);
            pv->subscribe(this, 0.2);
        } catch (PdCom::Exception &e) {
            cerr << "An error occurred while trying to subscribe "
                "to a variable: " << e.what() << endl;
            finished = true;
        }
    }

    if ((pv = findVariable("/Temperaturregler/Solltemperatur"))) {
        double v = 41.5;
        pv->setValue(&v);
    }
}

/****************************************************************************/

/* Notification, that a new value has arrived.
 *
 * Reimplemented from VariableSubscriber::notify().
 */
void ExampleProcess::notify(
        PdCom::Variable *pv /**< The variable that changed */
        )
{
    size_t nelem = pv->dimension.getElementCount();
    double value[nelem];

    pv->getValue(value, nelem, &scale);

    cout << "notify(" << pv->path << "): "
        << pv->getMTime().str() << endl;

    for (size_t i = 0; i < nelem; i++) {
        cout << value[i];
        if (i < nelem - 1) {
            cout << " ";
        }
    }
    cout << endl;

    finished = true;
}

/****************************************************************************/

/* The subscription has been cancelled.
 *
 * Called to notify the subscriber that this subscription has
 * been cancelled.
 */
void ExampleProcess::notifyDelete(
        PdCom::Variable *pv /**< The variable that is deleted */
        )
{
}

/****************************************************************************/
