/*****************************************************************************
 *
 * $Id$
 *
 * Copyright (C) 2009  Richard Hacker <lerich@gmx.net>
 *                     Florian Pose <fp@igh-essen.com>
 *
 * This file is part of the PdCom library.
 * 
 * The PdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The PdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the PdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#include "LinuxProcess.h"

/****************************************************************************/

/* Example process subclass.
 *
 * This inherits from both LinuxProcess and Subscriber, which is
 * allowed. Hence this process receives signals from both classes.
 */
class ExampleProcess:
    public LinuxProcess,
    public PdCom::Subscriber
{
    public:
        /* Constructor. */
        ExampleProcess(const char *, int);
        ~ExampleProcess();

        // from PdCom::Process
        void sigConnected();

        // from PdCom::Subscriber
        void notify(PdCom::Variable *);
        void notifyDelete(PdCom::Variable *);

    private:
        PdCom::Variable::Scale scale;
};

/****************************************************************************/
