/*****************************************************************************
 *
 * $Id$
 *
 * Copyright (C) 2009  Richard Hacker <lerich@gmx.net>
 *                     Florian Pose <fp@igh-essen.com>
 *
 * This file is part of the PdCom library.
 * 
 * The PdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The PdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the PdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 * \file PdCom example implementation.
 *
 ****************************************************************************/

#include <string>
#include <stdexcept>
using namespace std;

#include "pdcom.h"

/****************************************************************************/

/* PdCom::Process implementation for Linux.
 *
 * Uses a TCP socket to connect to the process.
 */
class LinuxProcess:
    public PdCom::Process
{
    public:
        LinuxProcess(const char *, int);
        ~LinuxProcess();

        void exec(void);

        /** Exception class.
         */
        class Exception: public runtime_error {
            public:
                /** Constructor. */
                Exception(const string &s /**< Message */):
                    runtime_error(s) {};
        };

    protected:
        bool finished;

    private:
        int fd;
        bool writeRequest;

        int readSocket();
        int writeSocket();

        // PdCom::Process
        void sendRequest();
        int sendData(const char *, size_t);
        bool clientInteraction(const string&, const std::string&,
                const std::string&, list<ClientInteraction>&);
};

/****************************************************************************/
