/*****************************************************************************
 *
 * $Id$
 *
 * Copyright (C) 2009 - 2012  Richard Hacker <lerich@gmx.net>
 *                            Florian Pose <fp@igh-essen.com>
 *
 * This file is part of the PdCom library.
 *
 * The PdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The PdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the PdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef MSRCHANNEL_H
#define MSRCHANNEL_H

#include "MsrVariable.h"
#include "pdcom/Exception.h"

#include <set>
#include <string>

namespace MSRProto {

/****************************************************************************/

/** MSR channel.
 * \todo doc
 */

class Channel: public Variable {
    public:
        Channel(
                ProtocolHandler *protocolhandler,
                std::ostream* os,
                const char *name,
                const char *alias,
                unsigned int index,
                unsigned int rnum,
                unsigned int cnum,
                const char *orientation,
                const char *datatype,
                unsigned int datasize,
                unsigned int bufsize,
                double freq,
                const char *unit);
        ~Channel();

        void newValues(const std::string& t, const char *buf);
        void newEvent(const std::string& t, const char *buf);
        void newPoll(const char *buf);

    private:
        // The buffer size as reported by <rk>
        const unsigned int msr_channel_bufsize;
        unsigned int reduction;   // If reduction == 0, use event transmission
        unsigned int blocksize;   // Blocksize of transmission

        // True if MSR Server supports event based transmission
        bool eventChannels;

        // Set if the MSR Server is sending the channel as event
        bool eventTransmission;

        unsigned int receiveCount;
        bool pollActive;

        typedef std::set<unsigned int> Decimations;
        Decimations decimations;
        Decimations::value_type maxDecimation;

        // Here are the methods reimplemented from base class
        unsigned int addTransmissionInterval(double interval);
        void rmTransmissionDecimation(int decimation);

        void updateTransmission();
        void pollVariable();

        void initBase64Src(const char* src);
        bool readBase64Value();
        unsigned int calcBase64DecodedSize(const char *) const;
        const char* base64Str;
        unsigned int base64ChrPos; /* Pos in binary output stream; 0..2 */
        unsigned char base64Value;

        static unsigned char base64ToChr[];
};

} // namespace MSRProto

#endif // MSRCHANNEL_H
