/*****************************************************************************
 *
 * $Id$
 *
 * Copyright (C) 2009 - 2012  Richard Hacker <lerich@gmx.net>
 *                            Florian Pose <fp@igh-essen.com>
 *
 * This file is part of the PdCom library.
 *
 * The PdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The PdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the PdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef MSRVARIABLE_H
#define MSRVARIABLE_H

#include "pdcom/Variable.h"
#include "MsrException.h"

#include <string>

namespace MSRProto {

class ProtocolHandler;

/****************************************************************************/

/** MSR variable.
 */

class Variable: public PdCom::Variable
{
    public:
        Variable(
                ProtocolHandler *protocolhandler,
                std::ostream *os,
                const char *name,
                const char *alias,
                unsigned int index,
                unsigned int rnum,
                unsigned int cnum,
                const char *orientation,
                const char *datatype,
                unsigned int datasize,
                double sampleTime,
                const char *unit);
        ~Variable();

    protected:
        ProtocolHandler * const msrHandler;
        std::ostream    * const os;
        unsigned int      const index;      /**< protocol index */
        std::string       const unit;
        unsigned int      const rnum;       /**< row count */
        unsigned int      const cnum;       /**< column count */
        size_t            const datawidth;  /**< bytes for a single element */
        size_t            const transpose_skip;

    private:

        /** \return a data type corresponding to the character string */
        static PdCom::Data::Type genDataType(const char* dt);
        static PdCom::Data::Dimension genDimension(const char* dt,
                const char* orientation, int rnum, int cnum);

        struct DimensionException: public Exception {
            DimensionException(const std::string& msg):
                Exception(msg) {}
        };

        static size_t getTransposeSkip(const char* dt, size_t cnum);

};

} // namespace MSRProto

#endif // MSRVARIABLE_H

/****************************************************************************/
