/*****************************************************************************
 *
 * $Id$
 *
 * Copyright (C) 2009 - 2012  Richard Hacker <lerich@gmx.net>
 *                            Florian Pose <fp@igh-essen.com>
 *
 * This file is part of the PdCom library.
 *
 * The PdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The PdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the PdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef PDCOM_EXCEPTION_H
#define PDCOM_EXCEPTION_H

#include <string>
#include <sstream>
#include <stdexcept>

namespace PdCom {

/****************************************************************************/

/** Exception base class.
 */
class Exception: public std::runtime_error {
    public:
        /** Constructor with std::string parameter. */
        Exception(
                const std::string &s /**< Message. */):
            std::runtime_error(s) {}

        /** Constructor with std::ostringstream parameter. */
        Exception(
                const std::ostringstream &s /**< Message. */
                ): std::runtime_error(s.str()) {}

        /** Constructor with const char pointer parameter. */
        Exception(
                const char *s /**< message. */
                ): std::runtime_error(s) {}
};

/** Exception concerning a variable.
 */
class VariableException: public Exception {
    public:
        /** Constructor with std::string parameter. */
        VariableException(
                const std::string &s /**< Message. */):
            Exception(s) {}

        /** Constructor with std::ostringstream parameter. */
        VariableException(
                const std::ostringstream &s /**< Message. */
                ): Exception(s.str()) {}

        /** Constructor with const char pointer parameter. */
        VariableException(
                const char *s /**< message. */
                ): Exception(s) {}
};

/** Exception concerning the protocol handling.
 */
class ProtocolException: public Exception {
    public:
        /** Constructor with std::string parameter. */
        ProtocolException(
                const std::string &s /**< Message. */):
            Exception(s) {}

        /** Constructor with std::ostringstream parameter. */
        ProtocolException(
                const std::ostringstream &s /**< Message. */
                ): Exception(s.str()) {}

        /** Constructor with const char pointer parameter. */
        ProtocolException(
                const char *s /**< message. */
                ): Exception(s) {}
};

} // namespace PdCom

#endif // PDCOM_EXCEPTION_H

/****************************************************************************/
