/*****************************************************************************
 *
 * $Id$
 *
 * Copyright (C) 2009 - 2012  Richard Hacker <lerich@gmx.net>
 *                            Florian Pose <fp@igh-essen.com>
 *
 * This file is part of the PdCom library.
 *
 * The PdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The PdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the PdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef PDCOM_RAWDATA_H
#define PDCOM_RAWDATA_H

#include "AbstractData.h"

namespace PdCom {

/****************************************************************************/

/** Raw data template.
 */
template <class T>
class DataType: public AbstractData {
    public:
        /** Constructor.
         */
        DataType(
                const Type& type         /**< Data type. */
                ): AbstractData(type) {}

        /** Destructor.
         */
        ~DataType() {}

    private:
        void getValue(double* dst, size_t n,
                const Scale* scale, const Type::Dimension* dim) {
            unsigned int offset = dim ? type.dimension.getOffset(dim) : 0;
            if (scale) {
                for (unsigned int i = 0; i < n; i++)
                    dst[i] = double(((T*)dataPtr)[i+offset]) * scale->gain
                            + scale->offset;
            }
            else {
                for (unsigned int i = 0; i < n; i++)
                    dst[i] = double(((T*)dataPtr)[i+offset]);
            }
        }
};

} // namespace PdCom

#endif // PDCOM_RAWDATA_H

/****************************************************************************/
