/*****************************************************************************
 *
 *  Copyright 2025 Florian Pose <fp@igh.de>
 *
 *  This file is part of the pdserv library.
 *
 *  The pdserv library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published
 *  by the Free Software Foundation, either version 3 of the License, or (at
 *  your option) any later version.
 *
 *  The pdserv library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 *  License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with the pdserv library. If not, see <http://www.gnu.org/licenses/>.
 *
 *****************************************************************************/

#include <pdserv.h>

#include <iostream>
#include <cassert>

using std::cerr;
using std::endl;

int main(int, const char *[])
{
    struct pdserv *pdserv {pdserv_create("logging_test", "0.999", nullptr)};
    if (not pdserv) {
        return 1;
    }

    pdserv_config_file(pdserv, "bad_logging.conf");
 
    int test_ret {0};
    try {
        int ret {pdserv_prepare(pdserv)};
        assert(ret == -1);
    }
    catch (std::exception &e) {
        cerr << "Caught std::exception: " << e.what() << endl;
        test_ret = 1;
    }

    pdserv_exit(pdserv);

    return test_ret;
}
