#!/usr/bin/python3

import zlib
import os.path
import sys

def dump_file(dest, z, line_prefix):
    dest.write('%s"' % line_prefix)
    for i in xrange(len(z)):
        # Insert new line every 16 characters
        if i and not i % 16: 
            if i:
                dest.write('"\n')
            dest.write('%s"' % line_prefix)

        # Insert character
        dest.write('\\x%02x' % ord(z[i]))
    dest.write('"')

# Need at least 2
if len(sys.argv) > 1 and (sys.argv[1] == "--help" or sys.argv[1] == "-h"):
    print("""
Usage: %s <dest file> <include files> ...

where: <dest file> is the name of the generated file
       <other files> are 0 or more files that to be included (for later use)
""" % sys.argv[0])
    sys.exit(1)

#out = open(sys.argv.pop(), 'w')
out = sys.stdout

out.write("""\
/* application payload file
 *
 * The strings below contain packed versions of miscellaneous files that 
 * are included in the kernel module
 * These are exported in the /proc filesystem
 * 
 * Generated by: 
 * $Id$
 * 
 */

#include "app_payload.h"

""")

out.write('const struct payload_files payload_files[] = {\n')
for f in sys.argv[1:]:
    if os.path.isfile(f):
        z = zlib.compress(open(sys.argv.pop()).read())
    else:
        sys.stderr.write("Error: file %s does not exist.\n" % f)
        continue
    out.write('\t{ "%s.gz", %i,\n' % (os.path.basename(f), len(z)))
    dump_file(out, z, "\t  ")
    out.write(' },\n')
out.write('\t{NULL,},\n')
out.write('};\n')
