/****************************************************************************
**
** Example application for qml pdwidgets integration
**
** Copyright (C) 2019 Wilhelm Hagemeister
** Contact: hm@igh.de
**
**
****************************************************************************/

import QtQuick 2.9           
import QtQuick.Layouts 1.3   
import QtQuick.Controls 2.3
import QtQuick.Controls.Material 2.1
import QtQuick.Window 2.2
import QtQuick.Dialogs 1.3

import de.igh.pd 1.0
import "qrc:/de/igh/PdQmlWidgets"
import "qrc:/de/igh/PdQmlWidgets/style"

ApplicationWindow {
    id: appContainer
    width: 1024
    height: 600
    visible: true
    title: "PD-QML"

    Material.theme:themeSwitch.checked?Material.Dark:Material.Light
    Material.primary:Material.background
    Material.accent:Solarized.green
    
    FontLoader {
        source: "qrc:/de/igh/PdQmlWidgets/FontAwesome.otf"
    }

    MessageDialog {
        id:noFunctionDialog
        text: "No function."
    }

    Menu {
        id:menu
        implicitWidth: 260 
        Action { 
            text: "Open" 
            icon.source:"qrc:/images/folder-open.svg" 
            onTriggered:{
                noFunctionDialog.open()
            }
        }
        Action { 
            id:saveAction
            text: "Save" 
            icon.source:"qrc:/images/save.svg" 
            onTriggered: {
                noFunctionDialog.open()
            }            
        }
        Action { 
            text: "Save As" 
            icon.source:"qrc:/images/save.svg" 
            onTriggered: {
                noFunctionDialog.open()
            }            
        }
        Action { 
            text: "Close" 
            icon.source:"qrc:/images/bolt.svg" 
            onTriggered: {
                Qt.callLater(Qt.quit);
            }            

        }
    }  //Menu ----------------------------------------

    header: ToolBar {
        RowLayout {
            spacing: 5
            anchors.fill: parent
            ToolButton {
                Layout.leftMargin:10
                font.family: "FontAwesome"
                font.pixelSize: 20
                text: "\uf0c9"
               onClicked: menu.open()
            }

            Label{
                Layout.fillWidth:true
                text:""
            }

            ToolButton { //Reload
                font.family: "FontAwesome"
                font.pixelSize: 20
                text: "\uf01e"
                ToolTip.visible: hovered
                ToolTip.text: qsTr("reload parameter set")
                enabled: true
                onClicked: {}
            }

            PdDigital { //Supply Voltage
                process:pdProcess
                id:supplyVoltage
                path:"/Taskinfo/0/ExecTime"  
                sampleTime:0.5
                font.pixelSize:20
                decimals:2
                scale:1000000
                suffix:" µs"
            }

            PdScalar {
                id:controllerActivate
                process:pdProcess
                path:"/osc/enable"
            }

            PdToolButton { 
                id:motorToolButton
                process:pdProcess
                path:"/osc/enable"
                font.family: "FontAwesome"
                font.pixelSize: 20
                text: "\uf085"

            }

            PdToolButton { 
                process:pdProcess
                path:"/osc/enable"
                font.family: "FontAwesome"
                activeColor:"red"
                font.pixelSize: 20
                text: "\uf0e7"
                ToolTip.visible: hovered
                ToolTip.text: qsTr("Overcurrent")
            }

            PdBar {
                Layout.rightMargin:10
                from:0
                to:10
                suffix:" µs"
                decimals:2
                scale:1e6
                sampleTime:0.1
                process:pdProcess
                path:"/Taskinfo/0/ExecTime"
            }
	    Label {
                text:qsTr("Dunkel")
                leftPadding: 10
            }
            Switch {
		id:themeSwitch
		checked:(appContainer.Material.theme == Material.Dark)
            }

        } //RowLayout
    } //header

    footer:TabBar {
        id: bar
        width: parent.width
        currentIndex: view.currentIndex

        TabButton {
            text: qsTr("Page 1")
            icon.source:"qrc:/images/cogs.svg"
        }
        TabButton {
            text: qsTr("Page 2")
            icon.source:"qrc:/images/plug.svg"
        }

        TabButton {
            text: qsTr("SVG")
            icon.source:"qrc:/images/wrench.svg"
        }
    } //footer

    SwipeView {
        id: view
        interactive:true
        currentIndex: bar.currentIndex
        anchors.fill: parent

        onCurrentIndexChanged: {
        }

        ChannelPane {
        }

        ParameterPane {
        }

	SvgPane {
	}
    } //SwipeView
} //Application Window

